'\"
'\" Copyright (c) 1990-1994 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.TH scale n 4.1 Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
scale \- Create and manipulate scale widgets
.SH SYNOPSIS
\fBscale\fR \fIpathName \fR?\fIoptions\fR?
.SO
\-activebackground	\-foreground	\-relief
\-background	\-highlightbackground	\-repeatdelay
\-borderwidth	\-highlightcolor	\-repeatinterval
\-cursor	\-highlightthickness	\-takefocus
\-font	\-orient	\-troughcolor
.SE
.SH "WIDGET-SPECIFIC OPTIONS"
.OP \-bigincrement bigIncrement BigIncrement
Some interactions with the scale cause its value to change by
.QW large
increments;  this option specifies the size of the
large increments.  If specified as 0, the large increments default
to 1/10 the range of the scale.
.OP \-command command Command
Specifies the prefix of a Tcl command to invoke whenever the scale's
value is changed via a widget command.
The actual command consists
of this option followed by a space and a real number indicating the
new value of the scale.
.OP \-digits digits Digits
An integer specifying how many significant digits should be retained
when converting the value of the scale to a string.
If the number is less than or equal to zero, then the scale picks
the smallest value that guarantees that every possible slider
position prints as a different string.
.OP \-from from From
A real value corresponding to the left or top end of the scale.
.OP \-label label Label
A string to display as a label for the scale.  For
vertical scales the label is displayed just to the right of the
top end of the scale.  For horizontal scales the label is displayed
just above the left end of the scale.  If the option is specified
as an empty string, no label is displayed.
.OP \-length length Length
Specifies the desired long dimension of the scale in screen units
(i.e. any of the forms acceptable to \fBTk_GetPixels\fR).
For vertical scales this is the scale's height;  for horizontal scales
it is the scale's width.
.OP \-resolution resolution Resolution
A real value specifying the resolution for the scale.
If this value is greater than zero then the scale's value will always be
rounded to an even multiple of this value, as will tick marks and
the endpoints of the scale.  If the value is less than zero then no
rounding occurs.  Defaults to 1 (i.e., the value will be integral).
.OP \-showvalue showValue ShowValue
Specifies a boolean value indicating whether or not the current
value of the scale is to be displayed.
.OP \-sliderlength sliderLength SliderLength
Specifies the size of the slider, measured in screen units along the slider's
long dimension.  The value may be specified in any of the forms acceptable
to \fBTk_GetPixels\fR.
.OP \-sliderrelief sliderRelief SliderRelief
Specifies the relief to use when drawing the slider, such as \fBraised\fR
or \fBsunken\fR.
.OP \-state state State
Specifies one of three states for the scale:  \fBnormal\fR,
\fBactive\fR, or \fBdisabled\fR.
If the scale is disabled then the value may not be changed and the scale
will not activate.
If the scale is active, the slider is displayed using the color
specified by the \fBactiveBackground\fR option.
.OP \-tickinterval tickInterval TickInterval
Must be a real value.
Determines the spacing between numerical
tick marks displayed below or to the left of the slider.
If 0, no tick marks will be displayed.
.OP \-to to To
Specifies a real value corresponding
to the right or bottom end of the scale.
This value may be either less than or greater than the \fBfrom\fR option.
.OP \-variable variable Variable
Specifies the name of a global variable to link to the scale.  Whenever the
value of the variable changes, the scale will update to reflect this
value.
Whenever the scale is manipulated interactively, the variable
will be modified to reflect the scale's new value.
.OP \-width width Width
Specifies the desired narrow dimension of the trough in screen units
(i.e. any of the forms acceptable to \fBTk_GetPixels\fR).
For vertical scales this is the trough's width;  for horizontal scales
this is the trough's height.
.BE

.SH DESCRIPTION
.PP
The \fBscale\fR command creates a new window (given by the
\fIpathName\fR argument) and makes it into a scale widget.
Additional
options, described above, may be specified on the command line
or in the option database
to configure aspects of the scale such as its colors, orientation,
and relief.  The \fBscale\fR command returns its
\fIpathName\fR argument.  At the time this command is invoked,
there must not exist a window named \fIpathName\fR, but
\fIpathName\fR's parent must exist.
.PP
A scale is a widget that displays a rectangular \fItrough\fR and a
small \fIslider\fR.  The trough corresponds to a range
of real values (determined by the \fBfrom\fR, \fBto\fR, and
\fBresolution\fR options),
and the position of the slider selects a particular real value.
The slider's position (and hence the scale's value) may be adjusted
with the mouse or keyboard as described in the \fBBINDINGS\fR
section below.  Whenever the scale's value is changed, a Tcl
command is invoked (using the \fBcommand\fR option) to notify
other interested widgets of the change.
In addition, the value
of the scale can be linked to a Tcl variable (using the \fBvariable\fR
option), so that changes in either are reflected in the other.
.PP
Three annotations may be displayed in a scale widget:  a label
appearing at the top right of the widget (top left for horizontal
scales), a number displayed just to the left of the slider
(just above the slider for horizontal scales), and a collection
of numerical tick marks just to the left of the current value
(just below the trough for horizontal scales).  Each of these three
annotations may be enabled or disabled using the
configuration options.
.SH "WIDGET COMMAND"
.PP
The \fBscale\fR command creates a new Tcl command whose
name is \fIpathName\fR.  This
command may be used to invoke various
operations on the widget.  It has the following general form:
.CS
\fIpathName option \fR?\fIarg arg ...\fR?
.CE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.  The following
commands are possible for scale widgets:
.TP
\fIpathName \fBcget\fR \fIoption\fR
Returns the current value of the configuration option given
by \fIoption\fR.
\fIOption\fR may have any of the values accepted by the \fBscale\fR
command.
.TP
\fIpathName \fBconfigure\fR ?\fIoption\fR? ?\fIvalue option value ...\fR?
Query or modify the configuration options of the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for \fIpathName\fR (see \fBTk_ConfigureInfo\fR for
information on the format of this list).  If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given widget option(s) to have the given value(s);  in
this case the command returns an empty string.
\fIOption\fR may have any of the values accepted by the \fBscale\fR
command.
.TP
\fIpathName \fBcoords \fR?\fIvalue\fR?
Returns a list whose elements are the x and y coordinates of
the point along the centerline of the trough that corresponds
to \fIvalue\fR.
If \fIvalue\fR is omitted then the scale's current value is used.
.TP
\fIpathName \fBget\fR ?\fIx y\fR?
If \fIx\fR and \fIy\fR are omitted, returns the current value
of the scale.  If \fIx\fR and \fIy\fR are specified, they give
pixel coordinates within the widget;  the command returns
the scale value corresponding to the given pixel.
Only one of \fIx\fR or \fIy\fR is used:  for horizontal scales
\fIy\fR is ignored, and for vertical scales \fIx\fR is ignored.
.TP
\fIpathName \fBidentify\fR \fIx y\fR
Returns a string indicating what part of the scale lies under
the coordinates given by \fIx\fR and \fIy\fR.
A return value of \fBslider\fR means that the point is over
the slider;  \fBtrough1\fR means that the point is over the
portion of the slider above  or to the left of the slider;
and \fBtrough2\fR means that the point is over the portion
of the slider below or to the right of the slider.
If the point is not over one of these elements, an empty string
is returned.
.TP
\fIpathName \fBset\fR \fIvalue\fR
This command is invoked to change the current value of the scale,
and hence the position at which the slider is displayed.  \fIValue\fR
gives the new value for the scale.
The command has no effect if the scale is disabled.
.SH BINDINGS
.PP
Tk automatically creates class bindings for scales that give them
the following default behavior.
Where the behavior is different for vertical and horizontal scales,
the horizontal behavior is described in parentheses.
.IP [1]
If button 1 is pressed in the trough, the scale's value will
be incremented or decremented by the value of the \fBresolution\fR
option so that the slider moves in the direction of the cursor. 
If the button is held down, the action auto-repeats.
.IP [2]
If button 1 is pressed over the slider, the slider can be dragged
with the mouse.
.IP [3]
If button 1 is pressed in the trough with the Control key down,
the slider moves all the way to the end of its range, in the
direction towards the mouse cursor.
.IP [4]
If button 2 is pressed, the scale's value is set to the mouse
position.  If the mouse is dragged with button 2 down, the scale's
value changes with the drag.
.IP [5]
The Up and Left keys move the slider up (left) by the value
of the \fBresolution\fR option.
.IP [6]
The Down and Right keys move the slider down (right) by the value
of the \fBresolution\fR option.
.IP [7]
Control-Up and Control-Left move the slider up (left) by the
value of the \fBbigIncrement\fR option.
.IP [8]
Control-Down and Control-Right move the slider down (right) by the
value of the \fBbigIncrement\fR option.
.IP [9]
Home moves the slider to the top (left) end of its range.
.IP [10]
End moves the slider to the bottom (right) end of its range.
.PP
If the scale is disabled using the \fBstate\fR option then
none of the above bindings have any effect.
.PP
The behavior of scales can be changed by defining new bindings for
individual widgets or by redefining the class bindings.

.SH KEYWORDS
scale, slider, trough, widget
