'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" Copyright (c) 1994-1996 Sun Microsystems, Inc.
'\"
'\" See the file "license.terms" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\" 
.\" The -*- nroff -*- definitions below are for supplemental macros used
.\" in Tcl/Tk manual entries.
.\"
.\" .AP type name in/out ?indent?
.\"	Start paragraph describing an argument to a library procedure.
.\"	type is type of argument (int, etc.), in/out is either "in", "out",
.\"	or "in/out" to describe whether procedure reads or modifies arg,
.\"	and indent is equivalent to second arg of .IP (shouldn't ever be
.\"	needed;  use .AS below instead)
.\"
.\" .AS ?type? ?name?
.\"	Give maximum sizes of arguments for setting tab stops.  Type and
.\"	name are examples of largest possible arguments that will be passed
.\"	to .AP later.  If args are omitted, default tab stops are used.
.\"
.\" .BS
.\"	Start box enclosure.  From here until next .BE, everything will be
.\"	enclosed in one large box.
.\"
.\" .BE
.\"	End of box enclosure.
.\"
.\" .CS
.\"	Begin code excerpt.
.\"
.\" .CE
.\"	End code excerpt.
.\"
.\" .VS ?version? ?br?
.\"	Begin vertical sidebar, for use in marking newly-changed parts
.\"	of man pages.  The first argument is ignored and used for recording
.\"	the version when the .VS was added, so that the sidebars can be
.\"	found and removed when they reach a certain age.  If another argument
.\"	is present, then a line break is forced before starting the sidebar.
.\"
.\" .VE
.\"	End of vertical sidebar.
.\"
.\" .DS
.\"	Begin an indented unfilled display.
.\"
.\" .DE
.\"	End of indented unfilled display.
.\"
.\" .SO ?manpage?
.\"	Start of list of standard options for a Tk widget. The manpage
.\"	argument defines where to look up the standard options; if
.\"	omitted, defaults to "options". The options follow on successive
.\"	lines, in three columns separated by tabs.
.\"
.\" .SE
.\"	End of list of standard options for a Tk widget.
.\"
.\" .OP cmdName dbName dbClass
.\"	Start of description of a specific option.  cmdName gives the
.\"	option's name as specified in the class command, dbName gives
.\"	the option's name in the option database, and dbClass gives
.\"	the option's class in the option database.
.\"
.\" .UL arg1 arg2
.\"	Print arg1 underlined, then print arg2 normally.
.\"
.\" .QW arg1 ?arg2?
.\"	Print arg1 in quotes, then arg2 normally (for trailing punctuation).
.\"
.\" .PQ arg1 ?arg2?
.\"	Print an open parenthesis, arg1 in quotes, then arg2 normally
.\"	(for trailing punctuation) and then a closing parenthesis.
.\"
.\"	# Set up traps and other miscellaneous stuff for Tcl/Tk man pages.
.if t .wh -1.3i ^B
.nr ^l \n(.l
.ad b
.\"	# Start an argument description
.de AP
.ie !"\\$4"" .TP \\$4
.el \{\
.   ie !"\\$2"" .TP \\n()Cu
.   el          .TP 15
.\}
.ta \\n()Au \\n()Bu
.ie !"\\$3"" \{\
\&\\$1 \\fI\\$2\\fP (\\$3)
.\".b
.\}
.el \{\
.br
.ie !"\\$2"" \{\
\&\\$1	\\fI\\$2\\fP
.\}
.el \{\
\&\\fI\\$1\\fP
.\}
.\}
..
.\"	# define tabbing values for .AP
.de AS
.nr )A 10n
.if !"\\$1"" .nr )A \\w'\\$1'u+3n
.nr )B \\n()Au+15n
.\"
.if !"\\$2"" .nr )B \\w'\\$2'u+\\n()Au+3n
.nr )C \\n()Bu+\\w'(in/out)'u+2n
..
.AS Tcl_Interp Tcl_CreateInterp in/out
.\"	# BS - start boxed text
.\"	# ^y = starting y location
.\"	# ^b = 1
.de BS
.br
.mk ^y
.nr ^b 1u
.if n .nf
.if n .ti 0
.if n \l'\\n(.lu\(ul'
.if n .fi
..
.\"	# BE - end boxed text (draw box now)
.de BE
.nf
.ti 0
.mk ^t
.ie n \l'\\n(^lu\(ul'
.el \{\
.\"	Draw four-sided box normally, but don't draw top of
.\"	box if the box started on an earlier page.
.ie !\\n(^b-1 \{\
\h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.el \}\
\h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\l'|0u-1.5n\(ul'
.\}
.\}
.fi
.br
.nr ^b 0
..
.\"	# VS - start vertical sidebar
.\"	# ^Y = starting y location
.\"	# ^v = 1 (for troff;  for nroff this doesn't matter)
.de VS
.if !"\\$2"" .br
.mk ^Y
.ie n 'mc \s12\(br\s0
.el .nr ^v 1u
..
.\"	# VE - end of vertical sidebar
.de VE
.ie n 'mc
.el \{\
.ev 2
.nf
.ti 0
.mk ^t
\h'|\\n(^lu+3n'\L'|\\n(^Yu-1v\(bv'\v'\\n(^tu+1v-\\n(^Yu'\h'-|\\n(^lu+3n'
.sp -1
.fi
.ev
.\}
.nr ^v 0
..
.\"	# Special macro to handle page bottom:  finish off current
.\"	# box/sidebar if in box/sidebar mode, then invoked standard
.\"	# page bottom macro.
.de ^B
.ev 2
'ti 0
'nf
.mk ^t
.if \\n(^b \{\
.\"	Draw three-sided box if this is the box's first page,
.\"	draw two sides but no top otherwise.
.ie !\\n(^b-1 \h'-1.5n'\L'|\\n(^yu-1v'\l'\\n(^lu+3n\(ul'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.el \h'-1.5n'\L'|\\n(^yu-1v'\h'\\n(^lu+3n'\L'\\n(^tu+1v-\\n(^yu'\h'|0u'\c
.\}
.if \\n(^v \{\
.nr ^x \\n(^tu+1v-\\n(^Yu
\kx\h'-\\nxu'\h'|\\n(^lu+3n'\ky\L'-\\n(^xu'\v'\\n(^xu'\h'|0u'\c
.\}
.bp
'fi
.ev
.if \\n(^b \{\
.mk ^y
.nr ^b 2
.\}
.if \\n(^v \{\
.mk ^Y
.\}
..
.\"	# DS - begin display
.de DS
.RS
.nf
.sp
..
.\"	# DE - end display
.de DE
.fi
.RE
.sp
..
.\"	# SO - start of list of standard options
.de SO
'ie '\\$1'' .ds So \\fBoptions\\fR
'el .ds So \\fB\\$1\\fR
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 5.5c 11c
.ft B
..
.\"	# SE - end of list of standard options
.de SE
.fi
.ft R
.LP
See the \\*(So manual entry for details on the standard options.
..
.\"	# OP - start of full description for a single option
.de OP
.LP
.nf
.ta 4c
Command-Line Name:	\\fB\\$1\\fR
Database Name:	\\fB\\$2\\fR
Database Class:	\\fB\\$3\\fR
.fi
.IP
..
.\"	# CS - begin code excerpt
.de CS
.RS
.nf
.ta .25i .5i .75i 1i
..
.\"	# CE - end code excerpt
.de CE
.fi
.RE
..
.\"	# UL - underline word
.de UL
\\$1\l'|0\(ul'\\$2
..
.\"	# QW - apply quotation marks to word
.de QW
.ie '\\*(lq'"' ``\\$1''\\$2
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\$2
..
.\"	# PQ - apply parens and quotation marks to word
.de PQ
.ie '\\*(lq'"' (``\\$1''\\$2)\\$3
.\"" fix emacs highlighting
.el (\\*(lq\\$1\\*(rq\\$2)\\$3
..
.\"	# QR - quoted range
.de QR
.ie '\\*(lq'"' ``\\$1''\\-``\\$2''\\$3
.\"" fix emacs highlighting
.el \\*(lq\\$1\\*(rq\\-\\*(lq\\$2\\*(rq\\$3
..
.\"	# MT - "empty" string
.de MT
.QW ""
..
.TH grab n "" Tk "Tk Built-In Commands"
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
grab \- Confine pointer and keyboard events to a window sub-tree
.SH SYNOPSIS
\fBgrab \fR?\fB\-global\fR? \fIwindow\fR
.sp
\fBgrab \fIoption \fR?\fIarg arg \fR...?
.BE

.SH DESCRIPTION
.PP
This command implements simple pointer and keyboard grabs for Tk.
Tk's grabs are different than the grabs
described in the Xlib documentation.
When a grab is set for a particular window, Tk restricts all pointer
events to the grab window and its descendants in Tk's window hierarchy.
Whenever the pointer is within the grab window's subtree, the pointer
will behave exactly the same as if there had been no grab at all
and all events will be reported in the normal fashion.
When the pointer is outside \fIwindow\fR's tree, button presses and
releases and
mouse motion events are reported to \fIwindow\fR, and window entry
and window exit events are ignored. The grab subtree
.QW owns
the pointer:
windows outside the grab subtree will be visible on the screen
but they will be insensitive until the grab is released.
The tree of windows underneath the grab window can include top-level
windows, in which case all of those top-level windows
and their descendants will continue to receive mouse events
during the grab.
.PP
Two forms of grabs are possible:  local and global.
A local grab affects only the grabbing application:  events will
be reported to other applications as if the grab had never occurred.
Grabs are local by default.
A global grab locks out all applications on the screen,
so that only the given subtree of the grabbing application will be
sensitive to pointer events (mouse button presses, mouse button releases,
pointer motions, window entries, and window exits).
During global grabs the window manager will not receive pointer
events either.
.PP
During local grabs, keyboard events (key presses and key releases)
are delivered as usual:  the window
manager controls which application receives keyboard events, and
if they are sent to any window in the grabbing application then they are
redirected to the focus window.
During a global grab Tk grabs the keyboard so that all keyboard events
are always sent to the grabbing application.
The \fBfocus\fR command is still used to determine which window in the
application receives the keyboard events.
The keyboard grab is released when the grab is released.
.PP
Grabs apply to particular displays.  If an application has windows
on multiple displays then it can establish a separate grab on each
display.
The grab on a particular display affects only the windows on
that display.
It is possible for different applications on a single display to have
simultaneous local grabs, but only one application can have a global
grab on a given display at once.
.PP
The \fBgrab\fR command can take any of the following forms:
.TP
\fBgrab \fR?\fB\-global\fR? \fIwindow\fR
Same as \fBgrab set\fR, described below.
.TP
\fBgrab current \fR?\fIwindow\fR?
If \fIwindow\fR is specified, returns the name of the current grab
window in this application for \fIwindow\fR's display, or an empty
string if there is no such window.
If \fIwindow\fR is omitted, the command returns a list whose elements
are all of the windows grabbed by this application for all displays,
or an empty string if the application has no grabs.
.TP
\fBgrab release \fIwindow\fR
Releases the grab on \fIwindow\fR if there is one, otherwise does
nothing.  Returns an empty string.
.TP
\fBgrab set \fR?\fB\-global\fR? \fIwindow\fR
Sets a grab on \fIwindow\fR.  If \fB\-global\fR is specified then the
grab is global, otherwise it is local.
If a grab was already in effect for this application on
\fIwindow\fR's display then it is automatically released.
If there is already a grab on \fIwindow\fR and it has the same
global/local form as the requested grab, then the command
does nothing.  Returns an empty string.
.TP
\fBgrab status \fIwindow\fR
Returns \fBnone\fR if no grab is currently set on \fIwindow\fR,
\fBlocal\fR if a local grab is set on \fIwindow\fR, and
\fBglobal\fR if a global grab is set.
.SH WARNING
It is very easy to use global grabs to render a display completely
unusable (e.g. by setting a grab on a widget which does not respond to
events and not providing any mechanism for releasing the grab).  Take
\fIextreme\fR care when using them!
.SH BUGS
.PP
It took an incredibly complex and gross implementation to produce
the simple grab effect described above.
Given the current implementation, it is not safe for applications
to use the Xlib grab facilities at all except through the Tk grab
procedures.
If applications try to manipulate X's grab mechanisms directly,
things will probably break.
.PP
If a single process is managing several different Tk applications,
only one of those applications can have a local grab for a given
display at any given time.  If the applications are in different
processes, this restriction does not exist.
.SH EXAMPLE
Set a grab so that only one button may be clicked out of a group.  The
other buttons are unresponsive to the mouse until the middle button is
clicked.
.CS
pack [button .b1 \-text "Click me! #1" \-command {destroy .b1}]
pack [button .b2 \-text "Click me! #2" \-command {destroy .b2}]
pack [button .b3 \-text "Click me! #3" \-command {destroy .b3}]
\fBgrab\fR .b2
.CE

.SH KEYWORDS
grab, keyboard events, pointer events, window
