/* $NetBSD$ */

/*-
 * Copyright (c) 2008 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Mihai Chelaru <kefren@NetBSD.org>
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <netinet/in.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/select.h>
#include <arpa/inet.h>

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>

#include "ldp.h"
#include "ldp_command.h"
#include "socketops.h"
#include "tlv.h"
#include "pdu.h"
#include "fsm.h"
#include "ldp_errors.h"
#include "mpls_interface.h"

extern int      ls;		/* TCP listening socket */
extern int	dont_catch;
extern int	command_port;
extern int	command_socket;

extern int	debug_f, warn_f;

void print_usage(char *myself)
{
	printf("\nUsage: %s [-hdDW] [-p PORT]\n\n", myself);
}

int 
main(int argc, char *argv[])
{
	int ch;
	while((ch = getopt(argc, argv, "dDhp:W")) != -1)
		switch(ch) {
		case 'd':
			dont_catch = 1;
			break;
		case 'D':
			debug_f = 1;
			break;
		case 'p':
			if ((command_port = atoi(optarg)) < 1) {
				print_usage(argv[0]);
				return -1;
			}
			break;
		case 'W':
			warn_f = 1;
			break;
		case 'h':
		default:
			print_usage(argv[0]);
			return -1;
			break;
		}
	if (geteuid()) {
		fatalp("You have to run this as ROOT\n");
		return -1;
	}
	if (set_my_ldp_id()) {
		fatalp("Cannot set LDP ID\n");
		return -1;
	}
	if (mpls_start_ldp() == -1)
		return -1;
	if (!strcmp(LDP_ID, "0.0.0.0")) {
		fatalp("Cannot set my LDP ID.\nAre you sure you've got\
a non-loopback INET interface UP ?\n");
		return -1;
	}
	init_command_sockets();
	if ((command_socket = create_command_socket(command_port)) < 1) {
		fatalp("Cannot create command socket\n");
		return -1;
	}
	if (create_hello_sockets() < 1) {
		fatalp("Cannot create hello socket\n");
		return -1;
	}
	ls = create_listening_socket();

	if (ls < 0) {
		fatalp("Cannot create listening socket\n");
		return -1;
	}
	if (fork())
		return 0;

	the_big_loop();

	/* We should never reach here */
	return 666;
}
