<?php

/**
 * ownCloud - Updater plugin
 *
 * @author Victor Dubiniuk
 * @copyright 2012-2013 Victor Dubiniuk victor.dubiniuk@gmail.com
 *
 * This file is licensed under the Affero General Public License version 3 or
 * later.
 */

namespace OCA\Updater;

\OCP\User::checkAdminUser();

\OCP\Util::addScript(App::APP_ID, '3rdparty/angular');
\OCP\Util::addScript(App::APP_ID, 'app');
\OCP\Util::addScript(App::APP_ID, 'controllers');

\OCP\Util::addStyle(App::APP_ID, 'updater');

if (!@file_exists(App::getBackupBase())){
	Helper::mkdir(App::getBackupBase());
}

$data = App::getFeed();
$isNewVersionAvailable = isset($data['version']) && $data['version'] != '' && $data['version'] !== Array();

$tmpl = new \OCP\Template(App::APP_ID, 'admin');
$lastCheck = \OC_Appconfig::getValue('core', 'lastupdatedat');
$tmpl->assign('checkedAt', \OCP\Util::formatDate($lastCheck));
$tmpl->assign('isNewVersionAvailable', $isNewVersionAvailable ? 'true' : 'false');
$tmpl->assign('channels', Channel::getChannels());
$tmpl->assign('currentChannel', Channel::getCurrentChannel());
$tmpl->assign('version', isset($data['versionstring']) ? $data['versionstring'] : '');
return $tmpl->fetchPage();