;;; loaddefs.el --- automatically extracted autoloads
;;
;;; Code:


;;;### (autoloads nil "5x5" "play/5x5.el" (21710 25077 0 0))
;;; Generated autoloads from play/5x5.el

(autoload '5x5 "5x5" "\
Play 5x5.

The object of 5x5 is very simple, by moving around the grid and flipping
squares you must fill the grid.

5x5 keyboard bindings are:
\\<5x5-mode-map>
Flip                        \\[5x5-flip-current]
Move up                     \\[5x5-up]
Move down                   \\[5x5-down]
Move left                   \\[5x5-left]
Move right                  \\[5x5-right]
Start new game              \\[5x5-new-game]
New game with random grid   \\[5x5-randomize]
Random cracker              \\[5x5-crack-randomly]
Mutate current cracker      \\[5x5-crack-mutating-current]
Mutate best cracker         \\[5x5-crack-mutating-best]
Mutate xor cracker          \\[5x5-crack-xor-mutate]
Solve with Calc             \\[5x5-solve-suggest]
Rotate left Calc Solutions  \\[5x5-solve-rotate-left]
Rotate right Calc Solutions \\[5x5-solve-rotate-right]
Quit current game           \\[5x5-quit-game]

\(fn &optional SIZE)" t nil)

(autoload '5x5-crack-randomly "5x5" "\
Attempt to crack 5x5 using random solutions.

\(fn)" t nil)

(autoload '5x5-crack-mutating-current "5x5" "\
Attempt to crack 5x5 by mutating the current solution.

\(fn)" t nil)

(autoload '5x5-crack-mutating-best "5x5" "\
Attempt to crack 5x5 by mutating the best solution.

\(fn)" t nil)

(autoload '5x5-crack-xor-mutate "5x5" "\
Attempt to crack 5x5 by xoring the current and best solution.
Mutate the result.

\(fn)" t nil)

(autoload '5x5-crack "5x5" "\
Attempt to find a solution for 5x5.

5x5-crack takes the argument BREEDER which should be a function that takes
two parameters, the first will be a grid vector array that is the current
solution and the second will be the best solution so far.  The function
should return a grid vector array that is the new solution.

\(fn BREEDER)" t nil)

;;;***

;;;### (autoloads nil "ada-mode" "progmodes/ada-mode.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/ada-mode.el

(autoload 'ada-add-extensions "ada-mode" "\
Define SPEC and BODY as being valid extensions for Ada files.
Going from body to spec with `ff-find-other-file' used these
extensions.
SPEC and BODY are two regular expressions that must match against
the file name.

\(fn SPEC BODY)" nil nil)

(autoload 'ada-mode "ada-mode" "\
Ada mode is the major mode for editing Ada code.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ada-stmt" "progmodes/ada-stmt.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/ada-stmt.el

(autoload 'ada-header "ada-stmt" "\
Insert a descriptive header at the top of the file.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ada-xref" "progmodes/ada-xref.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/ada-xref.el

(autoload 'ada-find-file "ada-xref" "\
Open FILENAME, from anywhere in the source path.
Completion is available.

\(fn FILENAME)" t nil)

;;;***

;;;### (autoloads nil "add-log" "vc/add-log.el" (21788 61018 0 0))
;;; Generated autoloads from vc/add-log.el

(put 'change-log-default-name 'safe-local-variable 'string-or-null-p)

(defvar add-log-current-defun-function nil "\
If non-nil, function to guess name of surrounding function.
It is called by `add-log-current-defun' with no argument, and
should return the function's name as a string, or nil if point is
outside a function.")

(custom-autoload 'add-log-current-defun-function "add-log" t)

(defvar add-log-full-name nil "\
Full name of user, for inclusion in ChangeLog daily headers.
This defaults to the value returned by the function `user-full-name'.")

(custom-autoload 'add-log-full-name "add-log" t)

(defvar add-log-mailing-address nil "\
Email addresses of user, for inclusion in ChangeLog headers.
This defaults to the value of `user-mail-address'.  In addition to
being a simple string, this value can also be a list.  All elements
will be recognized as referring to the same user; when creating a new
ChangeLog entry, one element will be chosen at random.")

(custom-autoload 'add-log-mailing-address "add-log" t)

(autoload 'prompt-for-change-log-name "add-log" "\
Prompt for a change log name.

\(fn)" nil nil)

(autoload 'find-change-log "add-log" "\
Find a change log file for \\[add-change-log-entry] and return the name.

Optional arg FILE-NAME specifies the file to use.
If FILE-NAME is nil, use the value of `change-log-default-name'.
If `change-log-default-name' is nil, behave as though it were 'ChangeLog'
\(or whatever we use on this operating system).

If `change-log-default-name' contains a leading directory component, then
simply find it in the current directory.  Otherwise, search in the current
directory and its successive parents for a file so named.

Once a file is found, `change-log-default-name' is set locally in the
current buffer to the complete file name.
Optional arg BUFFER-FILE overrides `buffer-file-name'.

\(fn &optional FILE-NAME BUFFER-FILE)" nil nil)

(autoload 'add-change-log-entry "add-log" "\
Find change log file, and add an entry for today and an item for this file.
Optional arg WHOAMI (interactive prefix) non-nil means prompt for user
name and email (stored in `add-log-full-name' and `add-log-mailing-address').

Second arg FILE-NAME is file name of the change log.
If nil, use the value of `change-log-default-name'.

Third arg OTHER-WINDOW non-nil means visit in other window.

Fourth arg NEW-ENTRY non-nil means always create a new entry at the front;
never append to an existing entry.  Option `add-log-keep-changes-together'
otherwise affects whether a new entry is created.

Fifth arg PUT-NEW-ENTRY-ON-NEW-LINE non-nil means that if a new
entry is created, put it on a new line by itself, do not put it
after a comma on an existing line.

Option `add-log-always-start-new-record' non-nil means always create a
new record, even when the last record was made on the same date and by
the same person.

The change log file can start with a copyright notice and a copying
permission notice.  The first blank line indicates the end of these
notices.

Today's date is calculated according to `add-log-time-zone-rule' if
non-nil, otherwise in local time.

\(fn &optional WHOAMI FILE-NAME OTHER-WINDOW NEW-ENTRY PUT-NEW-ENTRY-ON-NEW-LINE)" t nil)

(autoload 'add-change-log-entry-other-window "add-log" "\
Find change log file in other window and add entry and item.
This is just like `add-change-log-entry' except that it displays
the change log file in another window.

\(fn &optional WHOAMI FILE-NAME)" t nil)

(autoload 'change-log-mode "add-log" "\
Major mode for editing change logs; like Indented Text mode.
Prevents numeric backups and sets `left-margin' to 8 and `fill-column' to 74.
New log entries are usually made with \\[add-change-log-entry] or \\[add-change-log-entry-other-window].
Each entry behaves as a paragraph, and the entries for one day as a page.
Runs `change-log-mode-hook'.

\\{change-log-mode-map}

\(fn)" t nil)

(autoload 'add-log-current-defun "add-log" "\
Return name of function definition point is in, or nil.

Understands C, Lisp, LaTeX (\"functions\" are chapters, sections, ...),
Texinfo (@node titles) and Perl.

Other modes are handled by a heuristic that looks in the 10K before
point for uppercase headings starting in the first column or
identifiers followed by `:' or `='.  See variables
`add-log-current-defun-header-regexp' and
`add-log-current-defun-function'.

Has a preference of looking backwards.

\(fn)" nil nil)

(autoload 'change-log-merge "add-log" "\
Merge the contents of change log file OTHER-LOG with this buffer.
Both must be found in Change Log mode (since the merging depends on
the appropriate motion commands).  OTHER-LOG can be either a file name
or a buffer.

Entries are inserted in chronological order.  Both the current and
old-style time formats for entries are supported.

\(fn OTHER-LOG)" t nil)

;;;***

;;;### (autoloads nil "advice" "emacs-lisp/advice.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/advice.el

(defvar ad-redefinition-action 'warn "\
Defines what to do with redefinitions during Advice de/activation.
Redefinition occurs if a previously activated function that already has an
original definition associated with it gets redefined and then de/activated.
In such a case we can either accept the current definition as the new
original definition, discard the current definition and replace it with the
old original, or keep it and raise an error.  The values `accept', `discard',
`error' or `warn' govern what will be done.  `warn' is just like `accept' but
it additionally prints a warning message.  All other values will be
interpreted as `error'.")

(custom-autoload 'ad-redefinition-action "advice" t)

(defvar ad-default-compilation-action 'maybe "\
Defines whether to compile advised definitions during activation.
A value of `always' will result in unconditional compilation, `never' will
always avoid compilation, `maybe' will compile if the byte-compiler is already
loaded, and `like-original' will compile if the original definition of the
advised function is compiled or a built-in function.  Every other value will
be interpreted as `maybe'.  This variable will only be considered if the
COMPILE argument of `ad-activate' was supplied as nil.")

(custom-autoload 'ad-default-compilation-action "advice" t)

(autoload 'ad-enable-advice "advice" "\
Enables the advice of FUNCTION with CLASS and NAME.

\(fn FUNCTION CLASS NAME)" t nil)

(autoload 'ad-disable-advice "advice" "\
Disable the advice of FUNCTION with CLASS and NAME.

\(fn FUNCTION CLASS NAME)" t nil)

(autoload 'ad-add-advice "advice" "\
Add a piece of ADVICE to FUNCTION's list of advices in CLASS.

ADVICE has the form (NAME PROTECTED ENABLED DEFINITION), where
NAME is the advice name; PROTECTED is a flag specifying whether
to protect against non-local exits; ENABLED is a flag specifying
whether to initially enable the advice; and DEFINITION has the
form (advice . LAMBDA), where LAMBDA is a lambda expression.

If FUNCTION already has a piece of advice with the same name,
then POSITION is ignored, and the old advice is overwritten with
the new one.

If FUNCTION already has one or more pieces of advice of the
specified CLASS, then POSITION determines where the new piece
goes.  POSITION can either be `first', `last' or a number (where
0 corresponds to `first', and numbers outside the valid range are
mapped to the closest extremal position).

If FUNCTION was not advised already, its advice info will be
initialized.  Redefining a piece of advice whose name is part of
the cache-id will clear the cache.

\(fn FUNCTION ADVICE CLASS POSITION)" nil nil)

(autoload 'ad-activate "advice" "\
Activate all the advice information of an advised FUNCTION.
If FUNCTION has a proper original definition then an advised
definition will be generated from FUNCTION's advice info and the
definition of FUNCTION will be replaced with it.  If a previously
cached advised definition was available, it will be used.
The optional COMPILE argument determines whether the resulting function
or a compilable cached definition will be compiled.  If it is negative
no compilation will be performed, if it is positive or otherwise non-nil
the resulting function will be compiled, if it is nil the behavior depends
on the value of `ad-default-compilation-action' (which see).
Activation of an advised function that has an advice info but no actual
pieces of advice is equivalent to a call to `ad-unadvise'.  Activation of
an advised function that has actual pieces of advice but none of them are
enabled is equivalent to a call to `ad-deactivate'.  The current advised
definition will always be cached for later usage.

\(fn FUNCTION &optional COMPILE)" t nil)

(autoload 'defadvice "advice" "\
Define a piece of advice for FUNCTION (a symbol).
The syntax of `defadvice' is as follows:

  (defadvice FUNCTION (CLASS NAME [POSITION] [ARGLIST] FLAG...)
    [DOCSTRING] [INTERACTIVE-FORM]
    BODY...)

FUNCTION ::= Name of the function to be advised.
CLASS ::= `before' | `around' | `after' | `activation' | `deactivation'.
NAME ::= Non-nil symbol that names this piece of advice.
POSITION ::= `first' | `last' | NUMBER. Optional, defaults to `first',
    see also `ad-add-advice'.
ARGLIST ::= An optional argument list to be used for the advised function
    instead of the argument list of the original.  The first one found in
    before/around/after-advices will be used.
FLAG ::= `protect'|`disable'|`activate'|`compile'|`preactivate'.
    All flags can be specified with unambiguous initial substrings.
DOCSTRING ::= Optional documentation for this piece of advice.
INTERACTIVE-FORM ::= Optional interactive form to be used for the advised
    function.  The first one found in before/around/after-advices will be used.
BODY ::= Any s-expression.

Semantics of the various flags:
`protect': The piece of advice will be protected against non-local exits in
any code that precedes it.  If any around-advice of a function is protected
then automatically all around-advices will be protected (the complete onion).

`activate': All advice of FUNCTION will be activated immediately if
FUNCTION has been properly defined prior to this application of `defadvice'.

`compile': In conjunction with `activate' specifies that the resulting
advised function should be compiled.

`disable': The defined advice will be disabled, hence, it will not be used
during activation until somebody enables it.

`preactivate': Preactivates the advised FUNCTION at macro-expansion/compile
time.  This generates a compiled advised definition according to the current
advice state that will be used during activation if appropriate.  Only use
this if the `defadvice' gets actually compiled.

usage: (defadvice FUNCTION (CLASS NAME [POSITION] [ARGLIST] FLAG...)
          [DOCSTRING] [INTERACTIVE-FORM]
          BODY...)

\(fn FUNCTION ARGS &rest BODY)" nil t)

(put 'defadvice 'doc-string-elt '3)

(put 'defadvice 'lisp-indent-function '2)

;;;***

;;;### (autoloads nil "align" "align.el" (21710 25077 0 0))
;;; Generated autoloads from align.el

(autoload 'align "align" "\
Attempt to align a region based on a set of alignment rules.
BEG and END mark the region.  If BEG and END are specifically set to
nil (this can only be done programmatically), the beginning and end of
the current alignment section will be calculated based on the location
of point, and the value of `align-region-separate' (or possibly each
rule's `separate' attribute).

If SEPARATE is non-nil, it overrides the value of
`align-region-separate' for all rules, except those that have their
`separate' attribute set.

RULES and EXCLUDE-RULES, if either is non-nil, will replace the
default rule lists defined in `align-rules-list' and
`align-exclude-rules-list'.  See `align-rules-list' for more details
on the format of these lists.

\(fn BEG END &optional SEPARATE RULES EXCLUDE-RULES)" t nil)

(autoload 'align-regexp "align" "\
Align the current region using an ad-hoc rule read from the minibuffer.
BEG and END mark the limits of the region.  Interactively, this function
prompts for the regular expression REGEXP to align with.

For example, let's say you had a list of phone numbers, and wanted to
align them so that the opening parentheses would line up:

    Fred (123) 456-7890
    Alice (123) 456-7890
    Mary-Anne (123) 456-7890
    Joe (123) 456-7890

There is no predefined rule to handle this, but you could easily do it
using a REGEXP like \"(\".  Interactively, all you would have to do is
to mark the region, call `align-regexp' and enter that regular expression.

REGEXP must contain at least one parenthesized subexpression, typically
whitespace of the form \"\\\\(\\\\s-*\\\\)\".  In normal interactive use,
this is automatically added to the start of your regular expression after
you enter it.  You only need to supply the characters to be lined up, and
any preceding whitespace is replaced.

If you specify a prefix argument (or use this function non-interactively),
you must enter the full regular expression, including the subexpression.
The function also then prompts for which subexpression parenthesis GROUP
\(default 1) within REGEXP to modify, the amount of SPACING (default
`align-default-spacing') to use, and whether or not to REPEAT the rule
throughout the line.

See `align-rules-list' for more information about these options.

The non-interactive form of the previous example would look something like:
  (align-regexp (point-min) (point-max) \"\\\\(\\\\s-*\\\\)(\")

This function is a nothing more than a small wrapper that helps you
construct a rule to pass to `align-region', which does the real work.

\(fn BEG END REGEXP &optional GROUP SPACING REPEAT)" t nil)

(autoload 'align-entire "align" "\
Align the selected region as if it were one alignment section.
BEG and END mark the extent of the region.  If RULES or EXCLUDE-RULES
is set to a list of rules (see `align-rules-list'), it can be used to
override the default alignment rules that would have been used to
align that section.

\(fn BEG END &optional RULES EXCLUDE-RULES)" t nil)

(autoload 'align-current "align" "\
Call `align' on the current alignment section.
This function assumes you want to align only the current section, and
so saves you from having to specify the region.  If RULES or
EXCLUDE-RULES is set to a list of rules (see `align-rules-list'), it
can be used to override the default alignment rules that would have
been used to align that section.

\(fn &optional RULES EXCLUDE-RULES)" t nil)

(autoload 'align-highlight-rule "align" "\
Highlight the whitespace which a given rule would have modified.
BEG and END mark the extent of the region.  TITLE identifies the rule
that should be highlighted.  If RULES or EXCLUDE-RULES is set to a
list of rules (see `align-rules-list'), it can be used to override the
default alignment rules that would have been used to identify the text
to be colored.

\(fn BEG END TITLE &optional RULES EXCLUDE-RULES)" t nil)

(autoload 'align-unhighlight-rule "align" "\
Remove any highlighting that was added by `align-highlight-rule'.

\(fn)" t nil)

(autoload 'align-newline-and-indent "align" "\
A replacement function for `newline-and-indent', aligning as it goes.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "allout" "allout.el" (21710 25077 0 0))
;;; Generated autoloads from allout.el
(push (purecopy '(allout 2 3)) package--builtin-versions)

(autoload 'allout-auto-activation-helper "allout" "\
Institute `allout-auto-activation'.

Intended to be used as the `allout-auto-activation' :set function.

\(fn VAR VALUE)" nil nil)

(autoload 'allout-setup "allout" "\
Do fundamental Emacs session for allout auto-activation.

Establishes allout processing as part of visiting a file if
`allout-auto-activation' is non-nil, or removes it otherwise.

The proper way to use this is through customizing the setting of
`allout-auto-activation'.

\(fn)" nil nil)

(defvar allout-auto-activation nil "\
Configure allout outline mode auto-activation.

Control whether and how allout outline mode is automatically
activated when files are visited with non-nil buffer-specific
file variable `allout-layout'.

When allout-auto-activation is \"On\" (t), allout mode is
activated in buffers with non-nil `allout-layout', and the
specified layout is applied.

With value \"ask\", auto-mode-activation is enabled, and endorsement for
performing auto-layout is asked of the user each time.

With value \"activate\", only auto-mode-activation is enabled.
Auto-layout is not.

With value nil, inhibit any automatic allout-mode activation.")

(custom-autoload 'allout-auto-activation "allout" nil)

(put 'allout-use-hanging-indents 'safe-local-variable (if (fboundp 'booleanp) 'booleanp (lambda (x) (member x '(t nil)))))

(put 'allout-reindent-bodies 'safe-local-variable (lambda (x) (memq x '(nil t text force))))

(put 'allout-show-bodies 'safe-local-variable (if (fboundp 'booleanp) 'booleanp (lambda (x) (member x '(t nil)))))

(put 'allout-header-prefix 'safe-local-variable 'stringp)

(put 'allout-primary-bullet 'safe-local-variable 'stringp)

(put 'allout-plain-bullets-string 'safe-local-variable 'stringp)

(put 'allout-distinctive-bullets-string 'safe-local-variable 'stringp)

(put 'allout-use-mode-specific-leader 'safe-local-variable (lambda (x) (or (memq x '(t nil allout-mode-leaders comment-start)) (stringp x))))

(put 'allout-old-style-prefixes 'safe-local-variable (if (fboundp 'booleanp) 'booleanp (lambda (x) (member x '(t nil)))))

(put 'allout-stylish-prefixes 'safe-local-variable (if (fboundp 'booleanp) 'booleanp (lambda (x) (member x '(t nil)))))

(put 'allout-numbered-bullet 'safe-local-variable (if (fboundp 'string-or-null-p) 'string-or-null-p (lambda (x) (or (stringp x) (null x)))))

(put 'allout-file-xref-bullet 'safe-local-variable (if (fboundp 'string-or-null-p) 'string-or-null-p (lambda (x) (or (stringp x) (null x)))))

(put 'allout-presentation-padding 'safe-local-variable 'integerp)

(put 'allout-layout 'safe-local-variable (lambda (x) (or (numberp x) (listp x) (memq x '(: * + -)))))

(put 'allout-passphrase-verifier-string 'safe-local-variable 'stringp)

(put 'allout-passphrase-hint-string 'safe-local-variable 'stringp)

(autoload 'allout-mode-p "allout" "\
Return t if `allout-mode' is active in current buffer.

\(fn)" nil t)

(autoload 'allout-mode "allout" "\
Toggle Allout outline mode.
With a prefix argument ARG, enable Allout outline mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

\\<allout-mode-map-value>
Allout outline mode is a minor mode that provides extensive
outline oriented formatting and manipulation.  It enables
structural editing of outlines, as well as navigation and
exposure.  It also is specifically aimed at accommodating
syntax-sensitive text like programming languages.  (For example,
see the allout code itself, which is organized as an allout
outline.)

In addition to typical outline navigation and exposure, allout includes:

 - topic-oriented authoring, including keystroke-based topic creation,
   repositioning, promotion/demotion, cut, and paste
 - incremental search with dynamic exposure and reconcealment of hidden text
 - adjustable format, so programming code can be developed in outline-structure
 - easy topic encryption and decryption, symmetric or key-pair
 - \"Hot-spot\" operation, for single-keystroke maneuvering and exposure control
 - integral outline layout, for automatic initial exposure when visiting a file
 - independent extensibility, using comprehensive exposure and authoring hooks

and many other features.

Below is a description of the key bindings, and then description
of special `allout-mode' features and terminology.  See also the
outline menubar additions for quick reference to many of the
features.  Customize `allout-auto-activation' to prepare your
Emacs session for automatic activation of `allout-mode'.

The bindings are those listed in `allout-prefixed-keybindings'
and `allout-unprefixed-keybindings'.  We recommend customizing
`allout-command-prefix' to use just `\\C-c' as the command
prefix, if the allout bindings don't conflict with any personal
bindings you have on \\C-c.  In any case, outline structure
navigation and authoring is simplified by positioning the cursor
on an item's bullet character, the \"hot-spot\" -- then you can
invoke allout commands with just the un-prefixed,
un-control-shifted command letters.  This is described further in
the HOT-SPOT Operation section.

        Exposure Control:
        ----------------
\\[allout-hide-current-subtree]   `allout-hide-current-subtree'
\\[allout-show-children] `allout-show-children'
\\[allout-show-current-subtree] `allout-show-current-subtree'
\\[allout-show-current-entry] `allout-show-current-entry'
\\[allout-show-all]   `allout-show-all'

        Navigation:
        ----------
\\[allout-next-visible-heading] `allout-next-visible-heading'
\\[allout-previous-visible-heading] `allout-previous-visible-heading'
\\[allout-up-current-level] `allout-up-current-level'
\\[allout-forward-current-level] `allout-forward-current-level'
\\[allout-backward-current-level] `allout-backward-current-level'
\\[allout-end-of-entry] `allout-end-of-entry'
\\[allout-beginning-of-current-entry] `allout-beginning-of-current-entry' (alternately, goes to hot-spot)
\\[allout-beginning-of-line]  `allout-beginning-of-line' -- like regular beginning-of-line, but
     if immediately repeated cycles to the beginning of the current item
     and then to the hot-spot (if `allout-beginning-of-line-cycles' is set).


        Topic Header Production:
        -----------------------
\\[allout-open-sibtopic] `allout-open-sibtopic' Create a new sibling after current topic.
\\[allout-open-subtopic]   `allout-open-subtopic' ... an offspring of current topic.
\\[allout-open-supertopic] `allout-open-supertopic' ... a sibling of the current topic's parent.

        Topic Level and Prefix Adjustment:
        ---------------------------------
\\[allout-shift-in] `allout-shift-in'   Shift current topic and all offspring deeper
\\[allout-shift-out] `allout-shift-out' ... less deep
\\[allout-rebullet-current-heading] `allout-rebullet-current-heading' Prompt for alternate bullet for
            current topic
\\[allout-rebullet-topic] `allout-rebullet-topic'   Reconcile bullets of topic and
            its offspring -- distinctive bullets are not changed, others
            are alternated according to nesting depth.
\\[allout-number-siblings] `allout-number-siblings'  Number bullets of topic and siblings --
           the offspring are not affected.
           With repeat count, revoke numbering.

        Topic-oriented Killing and Yanking:
        ----------------------------------
\\[allout-kill-topic] `allout-kill-topic'   Kill current topic, including offspring.
\\[allout-copy-topic-as-kill] `allout-copy-topic-as-kill' Copy current topic, including offspring.
\\[allout-kill-line]     `allout-kill-line'    Kill line, attending to outline structure.
\\[allout-copy-line-as-kill]     `allout-copy-line-as-kill' Copy line but don't delete it.
\\[allout-yank] `allout-yank'        Yank, adjusting depth of yanked topic to
                             depth of heading if yanking into bare topic
                             heading (ie, prefix sans text).
\\[allout-yank-pop]     `allout-yank-pop'       Is to `allout-yank' as `yank-pop' is to `yank'.

        Topic-oriented Encryption:
        -------------------------
\\[allout-toggle-current-subtree-encryption] `allout-toggle-current-subtree-encryption'
          Encrypt/Decrypt topic content

        Misc commands:
        -------------
M-x outlineify-sticky       Activate outline mode for current buffer,
                            and establish a default file-var setting
                            for `allout-layout'.
\\[allout-mark-topic]       `allout-mark-topic'
\\[allout-copy-exposed-to-buffer] `allout-copy-exposed-to-buffer'
                            Duplicate outline, sans concealed text, to
                            buffer with name derived from derived from that
                            of current buffer -- \"*BUFFERNAME exposed*\".
\\[allout-flatten-exposed-to-buffer] `allout-flatten-exposed-to-buffer'
                            Like above 'copy-exposed', but convert topic
                            prefixes to section.subsection... numeric
                            format.
\\[customize-variable] allout-auto-activation
                            Prepare Emacs session for allout outline mode
                            auto-activation.

                  Topic Encryption

Outline mode supports gpg encryption of topics, with support for
symmetric and key-pair modes, and auto-encryption of topics
pending encryption on save.

Topics pending encryption are, by default, automatically
encrypted during file saves, including checkpoint saves, to avoid
exposing the plain text of encrypted topics in the file system.
If the content of the topic containing the cursor was encrypted
for a save, it is automatically decrypted for continued editing.

NOTE: A few GnuPG v2 versions improperly preserve incorrect
symmetric decryption keys, preventing entry of the correct key on
subsequent decryption attempts until the cache times-out.  That
can take several minutes.  (Decryption of other entries is not
affected.)  Upgrade your EasyPG version, if you can, and you can
deliberately clear your gpg-agent's cache by sending it a '-HUP'
signal.

See `allout-toggle-current-subtree-encryption' function docstring
and `allout-encrypt-unencrypted-on-saves' customization variable
for details.

                 HOT-SPOT Operation

Hot-spot operation provides a means for easy, single-keystroke outline
navigation and exposure control.

When the text cursor is positioned directly on the bullet character of
a topic, regular characters (a to z) invoke the commands of the
corresponding allout-mode keymap control chars.  For example, \"f\"
would invoke the command typically bound to \"C-c<space>C-f\"
\(\\[allout-forward-current-level] `allout-forward-current-level').

Thus, by positioning the cursor on a topic bullet, you can
execute the outline navigation and manipulation commands with a
single keystroke.  Regular navigation keys (eg, \\[forward-char], \\[next-line]) don't get
this special translation, so you can use them to get out of the
hot-spot and back to normal editing operation.

In allout-mode, the normal beginning-of-line command (\\[allout-beginning-of-line]) is
replaced with one that makes it easy to get to the hot-spot.  If you
repeat it immediately it cycles (if `allout-beginning-of-line-cycles'
is set) to the beginning of the item and then, if you hit it again
immediately, to the hot-spot.  Similarly, `allout-beginning-of-current-entry'
\(\\[allout-beginning-of-current-entry]) moves to the hot-spot when the cursor is already located
at the beginning of the current entry.

                             Extending Allout

Allout exposure and authoring activities all have associated
hooks, by which independent code can cooperate with allout
without changes to the allout core.  Here are key ones:

`allout-mode-hook'
`allout-mode-deactivate-hook' (deprecated)
`allout-mode-off-hook'
`allout-exposure-change-functions'
`allout-structure-added-functions'
`allout-structure-deleted-functions'
`allout-structure-shifted-functions'
`allout-after-copy-or-kill-hook'
`allout-post-undo-hook'

                            Terminology

Topic hierarchy constituents -- TOPICS and SUBTOPICS:

ITEM:   A unitary outline element, including the HEADER and ENTRY text.
TOPIC:  An ITEM and any ITEMs contained within it, ie having greater DEPTH
        and with no intervening items of lower DEPTH than the container.
CURRENT ITEM:
        The visible ITEM most immediately containing the cursor.
DEPTH:  The degree of nesting of an ITEM; it increases with containment.
        The DEPTH is determined by the HEADER PREFIX.  The DEPTH is also
        called the:
LEVEL:  The same as DEPTH.

ANCESTORS:
        Those ITEMs whose TOPICs contain an ITEM.
PARENT: An ITEM's immediate ANCESTOR.  It has a DEPTH one less than that
        of the ITEM.
OFFSPRING:
        The ITEMs contained within an ITEM's TOPIC.
SUBTOPIC:
        An OFFSPRING of its ANCESTOR TOPICs.
CHILD:
        An immediate SUBTOPIC of its PARENT.
SIBLINGS:
        TOPICs having the same PARENT and DEPTH.

Topic text constituents:

HEADER: The first line of an ITEM, include the ITEM PREFIX and HEADER
        text.
ENTRY:  The text content of an ITEM, before any OFFSPRING, but including
        the HEADER text and distinct from the ITEM PREFIX.
BODY:   Same as ENTRY.
PREFIX: The leading text of an ITEM which distinguishes it from normal
        ENTRY text.  Allout recognizes the outline structure according
        to the strict PREFIX format.  It consists of a PREFIX-LEAD string,
        PREFIX-PADDING, and a BULLET.  The BULLET might be followed by a
        number, indicating the ordinal number of the topic among its
        siblings, or an asterisk indicating encryption, plus an optional
        space.  After that is the ITEM HEADER text, which is not part of
        the PREFIX.

        The relative length of the PREFIX determines the nesting DEPTH
        of the ITEM.
PREFIX-LEAD:
        The string at the beginning of a HEADER PREFIX, by default a `.'.
        It can be customized by changing the setting of
        `allout-header-prefix' and then reinitializing `allout-mode'.

        When the PREFIX-LEAD is set to the comment-string of a
        programming language, outline structuring can be embedded in
        program code without interfering with processing of the text
        (by Emacs or the language processor) as program code.  This
        setting happens automatically when allout mode is used in
        programming-mode buffers.  See `allout-use-mode-specific-leader'
        docstring for more detail.
PREFIX-PADDING:
        Spaces or asterisks which separate the PREFIX-LEAD and the
        bullet, determining the ITEM's DEPTH.
BULLET: A character at the end of the ITEM PREFIX, it must be one of
        the characters listed on `allout-plain-bullets-string' or
        `allout-distinctive-bullets-string'.  When creating a TOPIC,
        plain BULLETs are by default used, according to the DEPTH of the
        TOPIC.  Choice among the distinctive BULLETs is offered when you
        provide a universal argument (\\[universal-argument]) to the
        TOPIC creation command, or when explicitly rebulleting a TOPIC.  The
        significance of the various distinctive bullets is purely by
        convention.  See the documentation for the above bullet strings for
        more details.
EXPOSURE:
        The state of a TOPIC which determines the on-screen visibility
        of its OFFSPRING and contained ENTRY text.
CONCEALED:
        TOPICs and ENTRY text whose EXPOSURE is inhibited.  Concealed
        text is represented by \"...\" ellipses.

        CONCEALED TOPICs are effectively collapsed within an ANCESTOR.
CLOSED: A TOPIC whose immediate OFFSPRING and body-text is CONCEALED.
OPEN:	A TOPIC that is not CLOSED, though its OFFSPRING or BODY may be.

\(fn &optional ARG)" t nil)

(defalias 'outlinify-sticky 'outlineify-sticky)

(autoload 'outlineify-sticky "allout" "\
Activate outline mode and establish file var so it is started subsequently.

See `allout-layout' and customization of `allout-auto-activation'
for details on preparing Emacs for automatic allout activation.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "allout-widgets" "allout-widgets.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from allout-widgets.el
(push (purecopy '(allout-widgets 1 0)) package--builtin-versions)

(autoload 'allout-widgets-setup "allout-widgets" "\
Commission or decommission allout-widgets-mode along with allout-mode.

Meant to be used by customization of `allout-widgets-auto-activation'.

\(fn VARNAME VALUE)" nil nil)

(defvar allout-widgets-auto-activation nil "\
Activate to enable allout icon graphics wherever allout mode is active.

Also enable `allout-auto-activation' for this to take effect upon
visiting an outline.

When this is set you can disable allout widgets in select files
by setting `allout-widgets-mode-inhibit'

Instead of setting `allout-widgets-auto-activation' you can
explicitly invoke `allout-widgets-mode' in allout buffers where
you want allout widgets operation.

See `allout-widgets-mode' for allout widgets mode features.")

(custom-autoload 'allout-widgets-auto-activation "allout-widgets" nil)

(put 'allout-widgets-mode-inhibit 'safe-local-variable (if (fboundp 'booleanp) 'booleanp (lambda (x) (member x '(t nil)))))

(autoload 'allout-widgets-mode "allout-widgets" "\
Toggle Allout Widgets mode.
With a prefix argument ARG, enable Allout Widgets mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Allout Widgets mode is an extension of Allout mode that provides
graphical decoration of outline structure.  It is meant to
operate along with `allout-mode', via `allout-mode-hook'.

The graphics include:

- guide lines connecting item bullet-icons with those of their subitems.

- icons for item bullets, varying to indicate whether or not the item
  has subitems, and if so, whether or not the item is expanded.

- cue area between the bullet-icon and the start of the body headline,
  for item numbering, encryption indicator, and distinctive bullets.

The bullet-icon and guide line graphics provide keybindings and mouse
bindings for easy outline navigation and exposure control, extending
outline hot-spot navigation (see `allout-mode').

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "ange-ftp" "net/ange-ftp.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from net/ange-ftp.el

(defalias 'ange-ftp-re-read-dir 'ange-ftp-reread-dir)

(autoload 'ange-ftp-reread-dir "ange-ftp" "\
Reread remote directory DIR to update the directory cache.
The implementation of remote FTP file names caches directory contents
for speed.  Therefore, when new remote files are created, Emacs
may not know they exist.  You can use this command to reread a specific
directory, so that Emacs will know its current contents.

\(fn &optional DIR)" t nil)

(autoload 'ange-ftp-hook-function "ange-ftp" "\


\(fn OPERATION &rest ARGS)" nil nil)

;;;***

;;;### (autoloads nil "animate" "play/animate.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from play/animate.el

(autoload 'animate-string "animate" "\
Display STRING animations starting at position VPOS, HPOS.
The characters start at randomly chosen places,
and all slide in parallel to their final positions,
passing through `animate-n-steps' positions before the final ones.
If HPOS is nil (or omitted), center the string horizontally
in the current window.

\(fn STRING VPOS &optional HPOS)" nil nil)

(autoload 'animate-sequence "animate" "\
Display animation strings from LIST-OF-STRING with buffer *Animation*.
Strings will be separated from each other by SPACE lines.
 When the variable `animation-buffer-name' is non-nil display
animation in the buffer named by variable's value, creating the
buffer if one does not exist.

\(fn LIST-OF-STRINGS SPACE)" nil nil)

(autoload 'animate-birthday-present "animate" "\
Return a birthday present in the buffer *Birthday-Present*.
When optional arg NAME is non-nil or called-interactively, prompt for
NAME of birthday present receiver and return a birthday present in
the buffer *Birthday-Present-for-Name*.

\(fn &optional NAME)" t nil)

;;;***

;;;### (autoloads nil "ansi-color" "ansi-color.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from ansi-color.el
(push (purecopy '(ansi-color 3 4 2)) package--builtin-versions)

(autoload 'ansi-color-for-comint-mode-on "ansi-color" "\
Set `ansi-color-for-comint-mode' to t.

\(fn)" t nil)

(autoload 'ansi-color-process-output "ansi-color" "\
Maybe translate SGR control sequences of comint output into text properties.

Depending on variable `ansi-color-for-comint-mode' the comint output is
either not processed, SGR control sequences are filtered using
`ansi-color-filter-region', or SGR control sequences are translated into
text properties using `ansi-color-apply-on-region'.

The comint output is assumed to lie between the marker
`comint-last-output-start' and the process-mark.

This is a good function to put in `comint-output-filter-functions'.

\(fn IGNORED)" nil nil)

;;;***

;;;### (autoloads nil "antlr-mode" "progmodes/antlr-mode.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from progmodes/antlr-mode.el
(push (purecopy '(antlr-mode 2 2 3)) package--builtin-versions)

(autoload 'antlr-show-makefile-rules "antlr-mode" "\
Show Makefile rules for all grammar files in the current directory.
If the `major-mode' of the current buffer has the value `makefile-mode',
the rules are directory inserted at point.  Otherwise, a *Help* buffer
is shown with the rules which are also put into the `kill-ring' for
\\[yank].

This command considers import/export vocabularies and grammar
inheritance and provides a value for the \"-glib\" option if necessary.
Customize variable `antlr-makefile-specification' for the appearance of
the rules.

If the file for a super-grammar cannot be determined, special file names
are used according to variable `antlr-unknown-file-formats' and a
commentary with value `antlr-help-unknown-file-text' is added.  The
*Help* buffer always starts with the text in `antlr-help-rules-intro'.

\(fn)" t nil)

(autoload 'antlr-mode "antlr-mode" "\
Major mode for editing ANTLR grammar files.

\(fn)" t nil)

(autoload 'antlr-set-tabs "antlr-mode" "\
Use ANTLR's convention for TABs according to `antlr-tab-offset-alist'.
Used in `antlr-mode'.  Also a useful function in `java-mode-hook'.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "appt" "calendar/appt.el" (21788 61018 0 0))
;;; Generated autoloads from calendar/appt.el

(autoload 'appt-add "appt" "\
Add an appointment for today at TIME with message MSG.
The time should be in either 24 hour format or am/pm format.
Optional argument WARNTIME is an integer (or string) giving the number
of minutes before the appointment at which to start warning.
The default is `appt-message-warning-time'.

\(fn TIME MSG &optional WARNTIME)" t nil)

(autoload 'appt-activate "appt" "\
Toggle checking of appointments.
With optional numeric argument ARG, turn appointment checking on if
ARG is positive, otherwise off.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "apropos" "apropos.el" (21788 61018 0 0))
;;; Generated autoloads from apropos.el

(autoload 'apropos-read-pattern "apropos" "\
Read an apropos pattern, either a word list or a regexp.
Returns the user pattern, either a list of words which are matched
literally, or a string which is used as a regexp to search for.

SUBJECT is a string that is included in the prompt to identify what
kind of objects to search.

\(fn SUBJECT)" nil nil)

(autoload 'apropos-user-option "apropos" "\
Show user options that match PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

With \\[universal-argument] prefix, or if `apropos-do-all' is non-nil, also show
variables, not just user options.

\(fn PATTERN &optional DO-ALL)" t nil)

(autoload 'apropos-variable "apropos" "\
Show variables that match PATTERN.
When DO-NOT-ALL is non-nil, show user options only, i.e. behave
like `apropos-user-option'.

\(fn PATTERN &optional DO-NOT-ALL)" t nil)

(defalias 'command-apropos 'apropos-command)

(autoload 'apropos-command "apropos" "\
Show commands (interactively callable functions) that match PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

With \\[universal-argument] prefix, or if `apropos-do-all' is non-nil, also show
noninteractive functions.

If VAR-PREDICATE is non-nil, show only variables, and only those that
satisfy the predicate VAR-PREDICATE.

When called from a Lisp program, a string PATTERN is used as a regexp,
while a list of strings is used as a word list.

\(fn PATTERN &optional DO-ALL VAR-PREDICATE)" t nil)

(autoload 'apropos-documentation-property "apropos" "\
Like (documentation-property SYMBOL PROPERTY RAW) but handle errors.

\(fn SYMBOL PROPERTY RAW)" nil nil)

(autoload 'apropos "apropos" "\
Show all meaningful Lisp symbols whose names match PATTERN.
Symbols are shown if they are defined as functions, variables, or
faces, or if they have nonempty property lists.

PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

With \\[universal-argument] prefix, or if `apropos-do-all' is non-nil,
consider all symbols (if they match PATTERN).

Returns list of symbols and documentation found.

\(fn PATTERN &optional DO-ALL)" t nil)

(autoload 'apropos-library "apropos" "\
List the variables and functions defined by library FILE.
FILE should be one of the libraries currently loaded and should
thus be found in `load-history'.  If `apropos-do-all' is non-nil,
the output includes key-bindings of commands.

\(fn FILE)" t nil)

(autoload 'apropos-value "apropos" "\
Show all symbols whose value's printed representation matches PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

With \\[universal-argument] prefix, or if `apropos-do-all' is non-nil, also looks
at function definitions (arguments, documentation and body) and at the
names and values of properties.

Returns list of symbols and values found.

\(fn PATTERN &optional DO-ALL)" t nil)

(autoload 'apropos-documentation "apropos" "\
Show symbols whose documentation contains matches for PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of words,
search for matches for any two (or more) of those words.

Note that by default this command only searches in the file specified by
`internal-doc-file-name'; i.e., the etc/DOC file.  With \\[universal-argument] prefix,
or if `apropos-do-all' is non-nil, it searches all currently defined
documentation strings.

Returns list of symbols and documentation found.

\(fn PATTERN &optional DO-ALL)" t nil)

;;;***

;;;### (autoloads nil "arc-mode" "arc-mode.el" (21788 61018 0 0))
;;; Generated autoloads from arc-mode.el

(autoload 'archive-mode "arc-mode" "\
Major mode for viewing an archive file in a dired-like way.
You can move around using the usual cursor motion commands.
Letters no longer insert themselves.
Type `e' to pull a file out of the archive and into its own buffer;
or click mouse-2 on the file's line in the archive mode buffer.

If you edit a sub-file of this archive (as with the `e' command) and
save it, the contents of that buffer will be saved back into the
archive.

\\{archive-mode-map}

\(fn &optional FORCE)" nil nil)

;;;***

;;;### (autoloads nil "array" "array.el" (21710 25077 0 0))
;;; Generated autoloads from array.el

(autoload 'array-mode "array" "\
Major mode for editing arrays.

  Array mode is a specialized mode for editing arrays.  An array is
considered to be a two-dimensional set of strings.  The strings are
NOT recognized as integers or real numbers.

  The array MUST reside at the top of the buffer.

  TABs are not respected, and may be converted into spaces at any time.
Setting the variable `array-respect-tabs' to non-nil will prevent TAB conversion,
but will cause many functions to give errors if they encounter one.

  Upon entering array mode, you will be prompted for the values of
several variables.  Others will be calculated based on the values you
supply.  These variables are all local to the buffer.  Other buffer
in array mode may have different values assigned to the variables.
The variables are:

Variables you assign:
     array-max-row:          The number of rows in the array.
     array-max-column:       The number of columns in the array.
     array-columns-per-line: The number of columns in the array per line of buffer.
     array-field-width:      The width of each field, in characters.
     array-rows-numbered:    A logical variable describing whether to ignore
                       row numbers in the buffer.

Variables which are calculated:
     array-line-length:      The number of characters in a buffer line.
     array-lines-per-row:    The number of buffer lines used to display each row.

  The following commands are available (an asterisk indicates it may
take a numeric prefix argument):

    *  	\\<array-mode-map>\\[array-forward-column]	  Move forward one column.
    *  	\\[array-backward-column]	  Move backward one column.
    *  	\\[array-next-row]	  Move down one row.
    *  	\\[array-previous-row]	  Move up one row.

    *   \\[array-copy-forward]	  Copy the current field into the column to the right.
    *   \\[array-copy-backward]	  Copy the current field into the column to the left.
    *   \\[array-copy-down]	  Copy the current field into the row below.
    *   \\[array-copy-up]	  Copy the current field into the row above.

    *   \\[array-copy-column-forward]   Copy the current column into the column to the right.
    *   \\[array-copy-column-backward]   Copy the current column into the column to the left.
    *   \\[array-copy-row-down]   Copy the current row into the row below.
    *   \\[array-copy-row-up]   Copy the current row into the row above.

        \\[array-fill-rectangle]   Copy the field at mark into every cell with row and column
                  between that of point and mark.

	\\[array-what-position]	  Display the current array row and column.
	\\[array-goto-cell]	  Go to a particular array cell.

	\\[array-make-template]	  Make a template for a new array.
	\\[array-reconfigure-rows]	  Reconfigure the array.
        \\[array-expand-rows]   Expand the array (remove row numbers and
                  newlines inside rows)

        \\[array-display-local-variables]   Display the current values of local variables.

Entering array mode calls the function `array-mode-hook'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "artist" "textmodes/artist.el" (21781 3670
;;;;;;  0 0))
;;; Generated autoloads from textmodes/artist.el
(push (purecopy '(artist 1 2 6)) package--builtin-versions)

(autoload 'artist-mode "artist" "\
Toggle Artist mode.
With argument ARG, turn Artist mode on if ARG is positive.
Artist lets you draw lines, squares, rectangles and poly-lines,
ellipses and circles with your mouse and/or keyboard.

How to quit Artist mode

 Type \\[artist-mode-off] to quit artist-mode.


How to submit a bug report

 Type \\[artist-submit-bug-report] to submit a bug report.


Drawing with the mouse:

 mouse-2
 shift mouse-2	Pops up a menu where you can select what to draw with
		mouse-1, and where you can do some settings (described
		below).

 mouse-1
 shift mouse-1	Draws lines, rectangles or poly-lines, erases, cuts, copies
		or pastes:

		Operation	Not shifted		  Shifted
		--------------------------------------------------------------
                Pen             fill-char at point        line from last point
                                                          to new point
		--------------------------------------------------------------
		Line		Line in any direction	  Straight line
		--------------------------------------------------------------
		Rectangle	Rectangle		  Square
		--------------------------------------------------------------
		Poly-line	Poly-line in any dir	  Straight poly-lines
		--------------------------------------------------------------
		Ellipses	Ellipses		  Circles
		--------------------------------------------------------------
		Text		Text (see thru)		  Text (overwrite)
		--------------------------------------------------------------
		Spray-can	Spray-can		  Set size for spray
		--------------------------------------------------------------
		Erase		Erase character		  Erase rectangle
		--------------------------------------------------------------
		Vaporize	Erase single line	  Erase connected
							  lines
		--------------------------------------------------------------
		Cut		Cut rectangle		  Cut square
		--------------------------------------------------------------
		Copy		Copy rectangle		  Copy square
		--------------------------------------------------------------
		Paste		Paste			  Paste
		--------------------------------------------------------------
		Flood-fill	Flood-fill		  Flood-fill
		--------------------------------------------------------------

		* Straight lines can only go horizontally, vertically
		  or diagonally.

		* Poly-lines are drawn while holding mouse-1 down.  When you
		  release the button, the point is set.  If you want a segment
		  to be straight, hold down shift before pressing the
		  mouse-1 button.  Click mouse-2 or mouse-3 to stop drawing
		  poly-lines.

		* See thru for text means that text already in the buffer
		  will be visible through blanks in the text rendered, while
		  overwrite means the opposite.

		* Vaporizing connected lines only vaporizes lines whose
		  _endpoints_ are connected.  See also the variable
		  `artist-vaporize-fuzziness'.

		* Cut copies, then clears the rectangle/square.

		* When drawing lines or poly-lines, you can set arrows.
		  See below under ``Arrows'' for more info.

		* The mode line shows the currently selected drawing operation.
		  In addition, if it has an asterisk (*) at the end, you
		  are currently drawing something.

		* Be patient when flood-filling -- large areas take quite
		  some time to fill.


 mouse-3	Erases character under pointer
 shift mouse-3	Erases rectangle


Settings

 Set fill	Sets the character used when filling rectangles/squares

 Set line	Sets the character used when drawing lines

 Erase char	Sets the character used when erasing

 Rubber-banding	Toggles rubber-banding

 Trimming	Toggles trimming of line-endings (that is: when the shape
		is drawn, extraneous white-space at end of lines is removed)

 Borders        Toggles the drawing of line borders around filled shapes


Drawing with keys

 \\[artist-key-set-point]		Does one of the following:
		For lines/rectangles/squares: sets the first/second endpoint
		For poly-lines: sets a point (use C-u \\[artist-key-set-point] to set last point)
		When erase characters: toggles erasing
		When cutting/copying: Sets first/last endpoint of rect/square
		When pasting: Pastes

 \\[artist-select-operation]	Selects what to draw

 Move around with \\[artist-next-line], \\[artist-previous-line], \\[artist-forward-char] and \\[artist-backward-char].

 \\[artist-select-fill-char]	Sets the character to use when filling
 \\[artist-select-line-char]	Sets the character to use when drawing
 \\[artist-select-erase-char]	Sets the character to use when erasing
 \\[artist-toggle-rubber-banding]	Toggles rubber-banding
 \\[artist-toggle-trim-line-endings]	Toggles trimming of line-endings
 \\[artist-toggle-borderless-shapes]	Toggles borders on drawn shapes


Arrows

 \\[artist-toggle-first-arrow]		Sets/unsets an arrow at the beginning
		of the line/poly-line

 \\[artist-toggle-second-arrow]		Sets/unsets an arrow at the end
		of the line/poly-line


Selecting operation

 There are some keys for quickly selecting drawing operations:

 \\[artist-select-op-line]	Selects drawing lines
 \\[artist-select-op-straight-line]	Selects drawing straight lines
 \\[artist-select-op-rectangle]	Selects drawing rectangles
 \\[artist-select-op-square]	Selects drawing squares
 \\[artist-select-op-poly-line]	Selects drawing poly-lines
 \\[artist-select-op-straight-poly-line]	Selects drawing straight poly-lines
 \\[artist-select-op-ellipse]	Selects drawing ellipses
 \\[artist-select-op-circle]	Selects drawing circles
 \\[artist-select-op-text-see-thru]	Selects rendering text (see thru)
 \\[artist-select-op-text-overwrite]	Selects rendering text (overwrite)
 \\[artist-select-op-spray-can]	Spray with spray-can
 \\[artist-select-op-spray-set-size]	Set size for the spray-can
 \\[artist-select-op-erase-char]	Selects erasing characters
 \\[artist-select-op-erase-rectangle]	Selects erasing rectangles
 \\[artist-select-op-vaporize-line]	Selects vaporizing single lines
 \\[artist-select-op-vaporize-lines]	Selects vaporizing connected lines
 \\[artist-select-op-cut-rectangle]	Selects cutting rectangles
 \\[artist-select-op-copy-rectangle]	Selects copying rectangles
 \\[artist-select-op-paste]	Selects pasting
 \\[artist-select-op-flood-fill]	Selects flood-filling


Variables

 This is a brief overview of the different variables.  For more info,
 see the documentation for the variables (type \\[describe-variable] <variable> RET).

 artist-rubber-banding		Interactively do rubber-banding or not
 artist-first-char		What to set at first/second point...
 artist-second-char		...when not rubber-banding
 artist-interface-with-rect	If cut/copy/paste should interface with rect
 artist-arrows			The arrows to use when drawing arrows
 artist-aspect-ratio		Character height-to-width for squares
 artist-trim-line-endings	Trimming of line endings
 artist-flood-fill-right-border	Right border when flood-filling
 artist-flood-fill-show-incrementally	Update display while filling
 artist-pointer-shape		Pointer shape to use while drawing
 artist-ellipse-left-char	Character to use for narrow ellipses
 artist-ellipse-right-char	Character to use for narrow ellipses
 artist-borderless-shapes       If shapes should have borders
 artist-picture-compatibility   Whether or not to be picture mode compatible
 artist-vaporize-fuzziness      Tolerance when recognizing lines
 artist-spray-interval          Seconds between repeated sprayings
 artist-spray-radius            Size of the spray-area
 artist-spray-chars             The spray-``color''
 artist-spray-new-chars         Initial spray-``color''

Hooks

 Turning the mode on or off runs `artist-mode-hook'.


Keymap summary

\\{artist-mode-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "asm-mode" "progmodes/asm-mode.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/asm-mode.el

(autoload 'asm-mode "asm-mode" "\
Major mode for editing typical assembler code.
Features a private abbrev table and the following bindings:

\\[asm-colon]	outdent a preceding label, tab to next tab stop.
\\[tab-to-tab-stop]	tab to next tab stop.
\\[asm-newline]	newline, then tab to next tab stop.
\\[asm-comment]	smart placement of assembler comments.

The character used for making comments is set by the variable
`asm-comment-char' (which defaults to `?\\;').

Alternatively, you may set this variable in `asm-mode-set-comment-hook',
which is called near the beginning of mode initialization.

Turning on Asm mode runs the hook `asm-mode-hook' at the end of initialization.

Special commands:
\\{asm-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "auth-source" "gnus/auth-source.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from gnus/auth-source.el

(defvar auth-source-cache-expiry 7200 "\
How many seconds passwords are cached, or nil to disable
expiring.  Overrides `password-cache-expiry' through a
let-binding.")

(custom-autoload 'auth-source-cache-expiry "auth-source" t)

;;;***

;;;### (autoloads nil "autoarg" "autoarg.el" (21710 25077 0 0))
;;; Generated autoloads from autoarg.el

(defvar autoarg-mode nil "\
Non-nil if Autoarg mode is enabled.
See the command `autoarg-mode' for a description of this minor mode.")

(custom-autoload 'autoarg-mode "autoarg" nil)

(autoload 'autoarg-mode "autoarg" "\
Toggle Autoarg mode, a global minor mode.
With a prefix argument ARG, enable Autoarg mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

\\<autoarg-mode-map>
In Autoarg mode, digits are bound to `digit-argument', i.e. they
supply prefix arguments as C-DIGIT and M-DIGIT normally do.
Furthermore, C-DIGIT inserts DIGIT.
\\[autoarg-terminate] terminates the prefix sequence and inserts
the digits of the autoarg sequence into the buffer.
Without a numeric prefix arg, the normal binding of \\[autoarg-terminate]
is invoked, i.e. what it would be with Autoarg mode off.

For example:
`6 9 \\[autoarg-terminate]' inserts `69' into the buffer, as does `C-6 C-9'.
`6 9 a' inserts 69 `a's into the buffer.
`6 9 \\[autoarg-terminate] \\[autoarg-terminate]' inserts `69' into the buffer and
then invokes the normal binding of \\[autoarg-terminate].
`C-u \\[autoarg-terminate]' invokes the normal binding of \\[autoarg-terminate] four times.

\\{autoarg-mode-map}

\(fn &optional ARG)" t nil)

(defvar autoarg-kp-mode nil "\
Non-nil if Autoarg-Kp mode is enabled.
See the command `autoarg-kp-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `autoarg-kp-mode'.")

(custom-autoload 'autoarg-kp-mode "autoarg" nil)

(autoload 'autoarg-kp-mode "autoarg" "\
Toggle Autoarg-KP mode, a global minor mode.
With a prefix argument ARG, enable Autoarg-KP mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

\\<autoarg-kp-mode-map>
This is similar to `autoarg-mode' but rebinds the keypad keys
`kp-1' etc. to supply digit arguments.

\\{autoarg-kp-mode-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "autoconf" "progmodes/autoconf.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/autoconf.el

(autoload 'autoconf-mode "autoconf" "\
Major mode for editing Autoconf configure.ac files.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "autoinsert" "autoinsert.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from autoinsert.el

(autoload 'auto-insert "autoinsert" "\
Insert default contents into new files if variable `auto-insert' is non-nil.
Matches the visited file name against the elements of `auto-insert-alist'.

\(fn)" t nil)

(autoload 'define-auto-insert "autoinsert" "\
Associate CONDITION with (additional) ACTION in `auto-insert-alist'.
Optional AFTER means to insert action after all existing actions for CONDITION,
or if CONDITION had no actions, after all other CONDITIONs.

\(fn CONDITION ACTION &optional AFTER)" nil nil)

(defvar auto-insert-mode nil "\
Non-nil if Auto-Insert mode is enabled.
See the command `auto-insert-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `auto-insert-mode'.")

(custom-autoload 'auto-insert-mode "autoinsert" nil)

(autoload 'auto-insert-mode "autoinsert" "\
Toggle Auto-insert mode, a global minor mode.
With a prefix argument ARG, enable Auto-insert mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

When Auto-insert mode is enabled, when new files are created you can
insert a template for the file depending on the mode of the buffer.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "autoload" "emacs-lisp/autoload.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from emacs-lisp/autoload.el

(put 'generated-autoload-file 'safe-local-variable 'stringp)

(put 'generated-autoload-load-name 'safe-local-variable 'stringp)

(autoload 'update-file-autoloads "autoload" "\
Update the autoloads for FILE.
If prefix arg SAVE-AFTER is non-nil, save the buffer too.

If FILE binds `generated-autoload-file' as a file-local variable,
autoloads are written into that file.  Otherwise, the autoloads
file is determined by OUTFILE.  If called interactively, prompt
for OUTFILE; if called from Lisp with OUTFILE nil, use the
existing value of `generated-autoload-file'.

Return FILE if there was no autoload cookie in it, else nil.

\(fn FILE &optional SAVE-AFTER OUTFILE)" t nil)

(autoload 'update-directory-autoloads "autoload" "\
Update autoload definitions for Lisp files in the directories DIRS.
In an interactive call, you must give one argument, the name of a
single directory.  In a call from Lisp, you can supply multiple
directories as separate arguments, but this usage is discouraged.

The function does NOT recursively descend into subdirectories of the
directory or directories specified.

In an interactive call, prompt for a default output file for the
autoload definitions, and temporarily bind the variable
`generated-autoload-file' to this value.  When called from Lisp,
use the existing value of `generated-autoload-file'.  If any Lisp
file binds `generated-autoload-file' as a file-local variable,
write its autoloads into the specified file instead.

\(fn &rest DIRS)" t nil)

(autoload 'batch-update-autoloads "autoload" "\
Update loaddefs.el autoloads in batch mode.
Calls `update-directory-autoloads' on the command line arguments.
Definitions are written to `generated-autoload-file' (which
should be non-nil).

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "autorevert" "autorevert.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from autorevert.el

(autoload 'auto-revert-mode "autorevert" "\
Toggle reverting buffer when the file changes (Auto Revert mode).
With a prefix argument ARG, enable Auto Revert mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Auto Revert mode is a minor mode that affects only the current
buffer.  When enabled, it reverts the buffer when the file on
disk changes.

Use `global-auto-revert-mode' to automatically revert all buffers.
Use `auto-revert-tail-mode' if you know that the file will only grow
without being changed in the part that is already in the buffer.

\(fn &optional ARG)" t nil)

(autoload 'turn-on-auto-revert-mode "autorevert" "\
Turn on Auto-Revert Mode.

This function is designed to be added to hooks, for example:
  (add-hook 'c-mode-hook 'turn-on-auto-revert-mode)

\(fn)" nil nil)

(autoload 'auto-revert-tail-mode "autorevert" "\
Toggle reverting tail of buffer when the file grows.
With a prefix argument ARG, enable Auto-Revert Tail mode if ARG
is positive, and disable it otherwise.  If called from Lisp,
enable the mode if ARG is omitted or nil.

When Auto Revert Tail mode is enabled, the tail of the file is
constantly followed, as with the shell command `tail -f'.  This
means that whenever the file grows on disk (presumably because
some background process is appending to it from time to time),
this is reflected in the current buffer.

You can edit the buffer and turn this mode off and on again as
you please.  But make sure the background process has stopped
writing before you save the file!

Use `auto-revert-mode' for changes other than appends!

\(fn &optional ARG)" t nil)

(autoload 'turn-on-auto-revert-tail-mode "autorevert" "\
Turn on Auto-Revert Tail mode.

This function is designed to be added to hooks, for example:
  (add-hook 'my-logfile-mode-hook 'turn-on-auto-revert-tail-mode)

\(fn)" nil nil)

(defvar global-auto-revert-mode nil "\
Non-nil if Global-Auto-Revert mode is enabled.
See the command `global-auto-revert-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-auto-revert-mode'.")

(custom-autoload 'global-auto-revert-mode "autorevert" nil)

(autoload 'global-auto-revert-mode "autorevert" "\
Toggle Global Auto Revert mode.
With a prefix argument ARG, enable Global Auto Revert mode if ARG
is positive, and disable it otherwise.  If called from Lisp,
enable the mode if ARG is omitted or nil.

Global Auto Revert mode is a global minor mode that reverts any
buffer associated with a file when the file changes on disk.  Use
`auto-revert-mode' to revert a particular buffer.

If `global-auto-revert-non-file-buffers' is non-nil, this mode
may also revert some non-file buffers, as described in the
documentation of that variable.  It ignores buffers with modes
matching `global-auto-revert-ignore-modes', and buffers with a
non-nil vale of `global-auto-revert-ignore-buffer'.

This function calls the hook `global-auto-revert-mode-hook'.
It displays the text that `global-auto-revert-mode-text'
specifies in the mode line.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "avoid" "avoid.el" (21710 25077 0 0))
;;; Generated autoloads from avoid.el

(defvar mouse-avoidance-mode nil "\
Activate Mouse Avoidance mode.
See function `mouse-avoidance-mode' for possible values.
Setting this variable directly does not take effect;
use either \\[customize] or the function `mouse-avoidance-mode'.")

(custom-autoload 'mouse-avoidance-mode "avoid" nil)

(autoload 'mouse-avoidance-mode "avoid" "\
Set Mouse Avoidance mode to MODE.
MODE should be one of the symbols `banish', `exile', `jump', `animate',
`cat-and-mouse', `proteus', or `none'.

If MODE is nil, toggle mouse avoidance between `none' and `banish'
modes.  Positive numbers and symbols other than the above are treated
as equivalent to `banish'; negative numbers and `-' are equivalent to `none'.

Effects of the different modes:
 * banish: Move the mouse to the upper-right corner on any keypress.
 * exile: Move the mouse to the corner only if the cursor gets too close,
     and allow it to return once the cursor is out of the way.
 * jump: If the cursor gets too close to the mouse, displace the mouse
     a random distance & direction.
 * animate: As `jump', but shows steps along the way for illusion of motion.
 * cat-and-mouse: Same as `animate'.
 * proteus: As `animate', but changes the shape of the mouse pointer too.

\(See `mouse-avoidance-threshold' for definition of \"too close\",
and `mouse-avoidance-nudge-dist' and `mouse-avoidance-nudge-var' for
definition of \"random distance\".)

\(fn &optional MODE)" t nil)

;;;***

;;;### (autoloads nil "bat-mode" "progmodes/bat-mode.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/bat-mode.el

(add-to-list 'auto-mode-alist '("\\.\\(bat\\|cmd\\)\\'" . bat-mode))

(autoload 'bat-mode "bat-mode" "\
Major mode for editing DOS/Windows batch files.

Start a new script from `bat-template'.  Read help pages for DOS commands
with `bat-cmd-help'.  Navigate between sections using `imenu'.
Run script using `bat-run' and `bat-run-args'.

\\{bat-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "battery" "battery.el" (21788 61018 0 0))
;;; Generated autoloads from battery.el
 (put 'battery-mode-line-string 'risky-local-variable t)

(autoload 'battery "battery" "\
Display battery status information in the echo area.
The text being displayed in the echo area is controlled by the variables
`battery-echo-area-format' and `battery-status-function'.

\(fn)" t nil)

(defvar display-battery-mode nil "\
Non-nil if Display-Battery mode is enabled.
See the command `display-battery-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `display-battery-mode'.")

(custom-autoload 'display-battery-mode "battery" nil)

(autoload 'display-battery-mode "battery" "\
Toggle battery status display in mode line (Display Battery mode).
With a prefix argument ARG, enable Display Battery mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

The text displayed in the mode line is controlled by
`battery-mode-line-format' and `battery-status-function'.
The mode line is be updated every `battery-update-interval'
seconds.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "benchmark" "emacs-lisp/benchmark.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from emacs-lisp/benchmark.el

(autoload 'benchmark-run "benchmark" "\
Time execution of FORMS.
If REPETITIONS is supplied as a number, run forms that many times,
accounting for the overhead of the resulting loop.  Otherwise run
FORMS once.
Return a list of the total elapsed time for execution, the number of
garbage collections that ran, and the time taken by garbage collection.
See also `benchmark-run-compiled'.

\(fn &optional REPETITIONS &rest FORMS)" nil t)

(put 'benchmark-run 'lisp-indent-function '1)

(autoload 'benchmark-run-compiled "benchmark" "\
Time execution of compiled version of FORMS.
This is like `benchmark-run', but what is timed is a funcall of the
byte code obtained by wrapping FORMS in a `lambda' and compiling the
result.  The overhead of the `lambda's is accounted for.

\(fn &optional REPETITIONS &rest FORMS)" nil t)

(put 'benchmark-run-compiled 'lisp-indent-function '1)

(autoload 'benchmark "benchmark" "\
Print the time taken for REPETITIONS executions of FORM.
Interactively, REPETITIONS is taken from the prefix arg.
For non-interactive use see also `benchmark-run' and
`benchmark-run-compiled'.

\(fn REPETITIONS FORM)" t nil)

;;;***

;;;### (autoloads nil "bibtex" "textmodes/bibtex.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from textmodes/bibtex.el

(autoload 'bibtex-initialize "bibtex" "\
(Re)Initialize BibTeX buffers.
Visit the BibTeX files defined by `bibtex-files' and return a list
of corresponding buffers.
Initialize in these buffers `bibtex-reference-keys' if not yet set.
List of BibTeX buffers includes current buffer if CURRENT is non-nil
and the current buffer visits a file using `bibtex-mode'.
If FORCE is non-nil, (re)initialize `bibtex-reference-keys' even if
already set.  If SELECT is non-nil interactively select a BibTeX buffer.

When called interactively, FORCE is t, CURRENT is t if current buffer
visits a file using `bibtex-mode', and SELECT is t if current buffer
does not use `bibtex-mode',

\(fn &optional CURRENT FORCE SELECT)" t nil)

(autoload 'bibtex-mode "bibtex" "\
Major mode for editing BibTeX files.

General information on working with BibTeX mode:

Use commands such as \\<bibtex-mode-map>\\[bibtex-Book] to get a template for a specific entry.
Then fill in all desired fields using \\[bibtex-next-field] to jump from field
to field.  After having filled in all desired fields in the entry, clean the
new entry with the command \\[bibtex-clean-entry].

Some features of BibTeX mode are available only by setting the variable
`bibtex-maintain-sorted-entries' to non-nil.  However, then BibTeX mode
works only with buffers containing valid (syntactically correct) and sorted
entries.  This is usually the case, if you have created a buffer completely
with BibTeX mode and finished every new entry with \\[bibtex-clean-entry].

For third party BibTeX files, call the command \\[bibtex-convert-alien]
to fully take advantage of all features of BibTeX mode.


Special information:

A command such as \\[bibtex-Book] outlines the fields for a BibTeX book entry.

The names of optional fields start with the string OPT, and are thus ignored
by BibTeX.  The names of alternative fields from which only one is required
start with the string ALT.  The OPT or ALT string may be removed from
the name of a field with \\[bibtex-remove-OPT-or-ALT].
\\[bibtex-make-field] inserts a new field after the current one.
\\[bibtex-kill-field] kills the current field entirely.
\\[bibtex-yank] yanks the last recently killed field after the current field.
\\[bibtex-remove-delimiters] removes the double-quotes or braces around the text of the current field.
\\[bibtex-empty-field] replaces the text of the current field with the default \"\" or {}.
\\[bibtex-find-text] moves point to the end of the current field.
\\[completion-at-point] completes word fragment before point according to context.

The command \\[bibtex-clean-entry] cleans the current entry, i.e. it removes OPT/ALT
from the names of all non-empty optional or alternative fields, checks that
no required fields are empty, and does some formatting dependent on the value
of `bibtex-entry-format'.  Furthermore, it can automatically generate a key
for the BibTeX entry, see `bibtex-generate-autokey'.
Note: some functions in BibTeX mode depend on entries being in a special
format (all fields beginning on separate lines), so it is usually a bad
idea to remove `realign' from `bibtex-entry-format'.

BibTeX mode supports Imenu and hideshow minor mode (`hs-minor-mode').

----------------------------------------------------------
Entry to BibTeX mode calls the value of `bibtex-mode-hook'
if that value is non-nil.

\\{bibtex-mode-map}

\(fn)" t nil)

(autoload 'bibtex-search-entry "bibtex" "\
Move point to the beginning of BibTeX entry named KEY.
Return position of entry if KEY is found or nil if not found.
With GLOBAL non-nil, search KEY in `bibtex-files'.  Otherwise the search
is limited to the current buffer.  Optional arg START is buffer position
where the search starts.  If it is nil, start search at beginning of buffer.
If DISPLAY is non-nil, display the buffer containing KEY.
Otherwise, use `set-buffer'.
When called interactively, START is nil, DISPLAY is t.
Also, GLOBAL is t if the current mode is not `bibtex-mode'
or `bibtex-search-entry-globally' is non-nil.
A prefix arg negates the value of `bibtex-search-entry-globally'.

\(fn KEY &optional GLOBAL START DISPLAY)" t nil)

;;;***

;;;### (autoloads nil "bibtex-style" "textmodes/bibtex-style.el"
;;;;;;  (21710 25077 0 0))
;;; Generated autoloads from textmodes/bibtex-style.el

(autoload 'bibtex-style-mode "bibtex-style" "\
Major mode for editing BibTeX style files.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "binhex" "mail/binhex.el" (21710 25077 0 0))
;;; Generated autoloads from mail/binhex.el

(defconst binhex-begin-line "^:...............................................................$" "\
Regular expression matching the start of a BinHex encoded region.")

(autoload 'binhex-decode-region-internal "binhex" "\
Binhex decode region between START and END without using an external program.
If HEADER-ONLY is non-nil only decode header and return filename.

\(fn START END &optional HEADER-ONLY)" t nil)

(autoload 'binhex-decode-region-external "binhex" "\
Binhex decode region between START and END using external decoder.

\(fn START END)" t nil)

(autoload 'binhex-decode-region "binhex" "\
Binhex decode region between START and END.

\(fn START END)" t nil)

;;;***

;;;### (autoloads nil "blackbox" "play/blackbox.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from play/blackbox.el

(autoload 'blackbox "blackbox" "\
Play blackbox.
Optional prefix argument is the number of balls; the default is 4.

What is blackbox?

Blackbox is a game of hide and seek played on an 8 by 8 grid (the
Blackbox).  Your opponent (Emacs, in this case) has hidden several
balls (usually 4) within this box.  By shooting rays into the box and
observing where they emerge it is possible to deduce the positions of
the hidden balls.  The fewer rays you use to find the balls, the lower
your score.

Overview of play:

\\<blackbox-mode-map>To play blackbox, type \\[blackbox].  An optional prefix argument
specifies the number of balls to be hidden in the box; the default is
four.

The cursor can be moved around the box with the standard cursor
movement keys.

To shoot a ray, move the cursor to the edge of the box and press SPC.
The result will be determined and the playfield updated.

You may place or remove balls in the box by moving the cursor into the
box and pressing \\[bb-romp].

When you think the configuration of balls you have placed is correct,
press \\[bb-done].  You will be informed whether you are correct or
not, and be given your score.  Your score is the number of letters and
numbers around the outside of the box plus five for each incorrectly
placed ball.  If you placed any balls incorrectly, they will be
indicated with `x', and their actual positions indicated with `o'.

Details:

There are three possible outcomes for each ray you send into the box:

	Detour: the ray is deflected and emerges somewhere other than
		where you sent it in.  On the playfield, detours are
		denoted by matching pairs of numbers -- one where the
		ray went in, and the other where it came out.

	Reflection: the ray is reflected and emerges in the same place
		it was sent in.  On the playfield, reflections are
		denoted by the letter `R'.

	Hit:	the ray strikes a ball directly and is absorbed.  It does
		not emerge from the box.  On the playfield, hits are
		denoted by the letter `H'.

The rules for how balls deflect rays are simple and are best shown by
example.

As a ray approaches a ball it is deflected ninety degrees.  Rays can
be deflected multiple times.  In the diagrams below, the dashes
represent empty box locations and the letter `O' represents a ball.
The entrance and exit points of each ray are marked with numbers as
described under \"Detour\" above.  Note that the entrance and exit
points are always interchangeable.  `*' denotes the path taken by the
ray.

Note carefully the relative positions of the ball and the ninety
degree deflection it causes.

    1
  - * - - - - - -         - - - - - - - -         - - - - - - - -
  - * - - - - - -         - - - - - - - -         - - - - - - - -
1 * * - - - - - -         - - - - - - - -         - O - - - - O -
  - - O - - - - -         - - O - - - - -         - - * * * * - -
  - - - - - - - -         - - - * * * * * 2     3 * * * - - * - -
  - - - - - - - -         - - - * - - - -         - - - O - * - -
  - - - - - - - -         - - - * - - - -         - - - - * * - -
  - - - - - - - -         - - - * - - - -         - - - - * - O -
                                2                         3

As mentioned above, a reflection occurs when a ray emerges from the same point
it was sent in.  This can happen in several ways:


  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - O - - -         - - O - O - - -          - - - - - - - -
R * * * * - - - -         - - - * - - - -          O - - - - - - -
  - - - - O - - -         - - - * - - - -        R - - - - - - - -
  - - - - - - - -         - - - * - - - -          - - - - - - - -
  - - - - - - - -         - - - * - - - -          - - - - - - - -
  - - - - - - - -       R * * * * - - - -          - - - - - - - -
  - - - - - - - -         - - - - O - - -          - - - - - - - -

In the first example, the ray is deflected downwards by the upper
ball, then left by the lower ball, and finally retraces its path to
its point of origin.  The second example is similar.  The third
example is a bit anomalous but can be rationalized by realizing the
ray never gets a chance to get into the box.  Alternatively, the ray
can be thought of as being deflected downwards and immediately
emerging from the box.

A hit occurs when a ray runs straight into a ball:

  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - O - - -
  - - - - - - - -         - - - - O - - -        H * * * * - - - -
  - - - - - - - -       H * * * * O - - -          - - - * - - - -
  - - - - - - - -         - - - - O - - -          - - - O - - - -
H * * * O - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - - - - -
  - - - - - - - -         - - - - - - - -          - - - - - - - -

Be sure to compare the second example of a hit with the first example of
a reflection.

\(fn NUM)" t nil)

;;;***

;;;### (autoloads nil "bookmark" "bookmark.el" (21788 61018 0 0))
;;; Generated autoloads from bookmark.el
 (define-key ctl-x-r-map "b" 'bookmark-jump)
 (define-key ctl-x-r-map "m" 'bookmark-set)
 (define-key ctl-x-r-map "l" 'bookmark-bmenu-list)

(defvar bookmark-map (let ((map (make-sparse-keymap))) (define-key map "x" 'bookmark-set) (define-key map "m" 'bookmark-set) (define-key map "j" 'bookmark-jump) (define-key map "g" 'bookmark-jump) (define-key map "o" 'bookmark-jump-other-window) (define-key map "i" 'bookmark-insert) (define-key map "e" 'edit-bookmarks) (define-key map "f" 'bookmark-insert-location) (define-key map "r" 'bookmark-rename) (define-key map "d" 'bookmark-delete) (define-key map "l" 'bookmark-load) (define-key map "w" 'bookmark-write) (define-key map "s" 'bookmark-save) map) "\
Keymap containing bindings to bookmark functions.
It is not bound to any key by default: to bind it
so that you have a bookmark prefix, just use `global-set-key' and bind a
key of your choice to `bookmark-map'.  All interactive bookmark
functions have a binding in this keymap.")
 (fset 'bookmark-map bookmark-map)

(autoload 'bookmark-set "bookmark" "\
Set a bookmark named NAME at the current location.
If name is nil, then prompt the user.

With a prefix arg (non-nil NO-OVERWRITE), do not overwrite any
existing bookmark that has the same name as NAME, but instead push the
new bookmark onto the bookmark alist.  The most recently set bookmark
with name NAME is thus the one in effect at any given time, but the
others are still there, should the user decide to delete the most
recent one.

To yank words from the text of the buffer and use them as part of the
bookmark name, type C-w while setting a bookmark.  Successive C-w's
yank successive words.

Typing C-u inserts (at the bookmark name prompt) the name of the last
bookmark used in the document where the new bookmark is being set;
this helps you use a single bookmark name to track progress through a
large document.  If there is no prior bookmark for this document, then
C-u inserts an appropriate name based on the buffer or file.

Use \\[bookmark-delete] to remove bookmarks (you give it a name and
it removes only the first instance of a bookmark with that name from
the list of bookmarks.)

\(fn &optional NAME NO-OVERWRITE)" t nil)

(autoload 'bookmark-jump "bookmark" "\
Jump to bookmark BOOKMARK (a point in some file).
You may have a problem using this function if the value of variable
`bookmark-alist' is nil.  If that happens, you need to load in some
bookmarks.  See help on function `bookmark-load' for more about
this.

If the file pointed to by BOOKMARK no longer exists, you will be asked
if you wish to give the bookmark a new location, and `bookmark-jump'
will then jump to the new location, as well as recording it in place
of the old one in the permanent bookmark record.

BOOKMARK is usually a bookmark name (a string).  It can also be a
bookmark record, but this is usually only done by programmatic callers.

If DISPLAY-FUNC is non-nil, it is a function to invoke to display the
bookmark.  It defaults to `switch-to-buffer'.  A typical value for
DISPLAY-FUNC would be `switch-to-buffer-other-window'.

\(fn BOOKMARK &optional DISPLAY-FUNC)" t nil)

(autoload 'bookmark-jump-other-window "bookmark" "\
Jump to BOOKMARK in another window.  See `bookmark-jump' for more.

\(fn BOOKMARK)" t nil)

(autoload 'bookmark-relocate "bookmark" "\
Relocate BOOKMARK-NAME to another file, reading file name with minibuffer.

This makes an already existing bookmark point to that file, instead of
the one it used to point at.  Useful when a file has been renamed
after a bookmark was set in it.

\(fn BOOKMARK-NAME)" t nil)

(autoload 'bookmark-insert-location "bookmark" "\
Insert the name of the file associated with BOOKMARK-NAME.

Optional second arg NO-HISTORY means don't record this in the
minibuffer history list `bookmark-history'.

\(fn BOOKMARK-NAME &optional NO-HISTORY)" t nil)

(defalias 'bookmark-locate 'bookmark-insert-location)

(autoload 'bookmark-rename "bookmark" "\
Change the name of OLD-NAME bookmark to NEW-NAME name.
If called from keyboard, prompt for OLD-NAME and NEW-NAME.
If called from menubar, select OLD-NAME from a menu and prompt for NEW-NAME.

If called from Lisp, prompt for NEW-NAME if only OLD-NAME was passed
as an argument.  If called with two strings, then no prompting is done.
You must pass at least OLD-NAME when calling from Lisp.

While you are entering the new name, consecutive C-w's insert
consecutive words from the text of the buffer into the new bookmark
name.

\(fn OLD-NAME &optional NEW-NAME)" t nil)

(autoload 'bookmark-insert "bookmark" "\
Insert the text of the file pointed to by bookmark BOOKMARK-NAME.
BOOKMARK-NAME is a bookmark name (a string), not a bookmark record.

You may have a problem using this function if the value of variable
`bookmark-alist' is nil.  If that happens, you need to load in some
bookmarks.  See help on function `bookmark-load' for more about
this.

\(fn BOOKMARK-NAME)" t nil)

(autoload 'bookmark-delete "bookmark" "\
Delete BOOKMARK-NAME from the bookmark list.

Removes only the first instance of a bookmark with that name.  If
there are one or more other bookmarks with the same name, they will
not be deleted.  Defaults to the \"current\" bookmark (that is, the
one most recently used in this file, if any).
Optional second arg BATCH means don't update the bookmark list buffer,
probably because we were called from there.

\(fn BOOKMARK-NAME &optional BATCH)" t nil)

(autoload 'bookmark-write "bookmark" "\
Write bookmarks to a file (reading the file name with the minibuffer).
Don't use this in Lisp programs; use `bookmark-save' instead.

\(fn)" t nil)

(autoload 'bookmark-save "bookmark" "\
Save currently defined bookmarks.
Saves by default in the file defined by the variable
`bookmark-default-file'.  With a prefix arg, save it in file FILE
\(second argument).

If you are calling this from Lisp, the two arguments are PARG and
FILE, and if you just want it to write to the default file, then
pass no arguments.  Or pass in nil and FILE, and it will save in FILE
instead.  If you pass in one argument, and it is non-nil, then the
user will be interactively queried for a file to save in.

When you want to load in the bookmarks from a file, use
`bookmark-load', \\[bookmark-load].  That function will prompt you
for a file, defaulting to the file defined by variable
`bookmark-default-file'.

\(fn &optional PARG FILE)" t nil)

(autoload 'bookmark-load "bookmark" "\
Load bookmarks from FILE (which must be in bookmark format).
Appends loaded bookmarks to the front of the list of bookmarks.  If
optional second argument OVERWRITE is non-nil, existing bookmarks are
destroyed.  Optional third arg NO-MSG means don't display any messages
while loading.

If you load a file that doesn't contain a proper bookmark alist, you
will corrupt Emacs's bookmark list.  Generally, you should only load
in files that were created with the bookmark functions in the first
place.  Your own personal bookmark file, `~/.emacs.bmk', is
maintained automatically by Emacs; you shouldn't need to load it
explicitly.

If you load a file containing bookmarks with the same names as
bookmarks already present in your Emacs, the new bookmarks will get
unique numeric suffixes \"<2>\", \"<3>\", etc.

\(fn FILE &optional OVERWRITE NO-MSG)" t nil)

(autoload 'bookmark-bmenu-list "bookmark" "\
Display a list of existing bookmarks.
The list is displayed in a buffer named `*Bookmark List*'.
The leftmost column displays a D if the bookmark is flagged for
deletion, or > if it is flagged for displaying.

\(fn)" t nil)

(defalias 'list-bookmarks 'bookmark-bmenu-list)

(defalias 'edit-bookmarks 'bookmark-bmenu-list)

(autoload 'bookmark-bmenu-search "bookmark" "\
Incremental search of bookmarks, hiding the non-matches as we go.

\(fn)" t nil)

(defvar menu-bar-bookmark-map (let ((map (make-sparse-keymap "Bookmark functions"))) (bindings--define-key map [load] '(menu-item "Load a Bookmark File..." bookmark-load :help "Load bookmarks from a bookmark file)")) (bindings--define-key map [write] '(menu-item "Save Bookmarks As..." bookmark-write :help "Write bookmarks to a file (reading the file name with the minibuffer)")) (bindings--define-key map [save] '(menu-item "Save Bookmarks" bookmark-save :help "Save currently defined bookmarks")) (bindings--define-key map [edit] '(menu-item "Edit Bookmark List" bookmark-bmenu-list :help "Display a list of existing bookmarks")) (bindings--define-key map [delete] '(menu-item "Delete Bookmark..." bookmark-delete :help "Delete a bookmark from the bookmark list")) (bindings--define-key map [rename] '(menu-item "Rename Bookmark..." bookmark-rename :help "Change the name of a bookmark")) (bindings--define-key map [locate] '(menu-item "Insert Location..." bookmark-locate :help "Insert the name of the file associated with a bookmark")) (bindings--define-key map [insert] '(menu-item "Insert Contents..." bookmark-insert :help "Insert the text of the file pointed to by a bookmark")) (bindings--define-key map [set] '(menu-item "Set Bookmark..." bookmark-set :help "Set a bookmark named inside a file.")) (bindings--define-key map [jump] '(menu-item "Jump to Bookmark..." bookmark-jump :help "Jump to a bookmark (a point in some file)")) map))

(defalias 'menu-bar-bookmark-map menu-bar-bookmark-map)

;;;***

;;;### (autoloads nil "browse-url" "net/browse-url.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from net/browse-url.el

(defvar browse-url-browser-function 'browse-url-default-browser "\
Function to display the current buffer in a WWW browser.
This is used by the `browse-url-at-point', `browse-url-at-mouse', and
`browse-url-of-file' commands.

If the value is not a function it should be a list of pairs
\(REGEXP . FUNCTION).  In this case the function called will be the one
associated with the first REGEXP which matches the current URL.  The
function is passed the URL and any other args of `browse-url'.  The last
regexp should probably be \".\" to specify a default browser.")

(custom-autoload 'browse-url-browser-function "browse-url" t)

(autoload 'browse-url-of-file "browse-url" "\
Ask a WWW browser to display FILE.
Display the current buffer's file if FILE is nil or if called
interactively.  Turn the filename into a URL with function
`browse-url-file-url'.  Pass the URL to a browser using the
`browse-url' function then run `browse-url-of-file-hook'.

\(fn &optional FILE)" t nil)

(autoload 'browse-url-of-buffer "browse-url" "\
Ask a WWW browser to display BUFFER.
Display the current buffer if BUFFER is nil.  Display only the
currently visible part of BUFFER (from a temporary file) if buffer is
narrowed.

\(fn &optional BUFFER)" t nil)

(autoload 'browse-url-of-dired-file "browse-url" "\
In Dired, ask a WWW browser to display the file named on this line.

\(fn)" t nil)

(autoload 'browse-url-of-region "browse-url" "\
Ask a WWW browser to display the current region.

\(fn MIN MAX)" t nil)

(autoload 'browse-url "browse-url" "\
Ask a WWW browser to load URL.
Prompts for a URL, defaulting to the URL at or before point.  Variable
`browse-url-browser-function' says which browser to use.
If the URL is a mailto: URL, consult `browse-url-mailto-function'
first, if that exists.

\(fn URL &rest ARGS)" t nil)

(autoload 'browse-url-at-point "browse-url" "\
Ask a WWW browser to load the URL at or before point.
Doesn't let you edit the URL like `browse-url'.  Variable
`browse-url-browser-function' says which browser to use.

\(fn &optional ARG)" t nil)

(autoload 'browse-url-at-mouse "browse-url" "\
Ask a WWW browser to load a URL clicked with the mouse.
The URL is the one around or before the position of the mouse click
but point is not changed.  Doesn't let you edit the URL like
`browse-url'.  Variable `browse-url-browser-function' says which browser
to use.

\(fn EVENT)" t nil)

(autoload 'browse-url-xdg-open "browse-url" "\
Pass the specified URL to the \"xdg-open\" command.
xdg-open is a desktop utility that calls your preferred web browser.
The optional argument IGNORED is not used.

\(fn URL &optional IGNORED)" t nil)

(autoload 'browse-url-netscape "browse-url" "\
Ask the Netscape WWW browser to load URL.
Default to the URL around or before point.  The strings in variable
`browse-url-netscape-arguments' are also passed to Netscape.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new Netscape window, otherwise use a
random existing one.  A non-nil interactive prefix argument reverses
the effect of `browse-url-new-window-flag'.

If `browse-url-netscape-new-window-is-tab' is non-nil, then
whenever a document would otherwise be loaded in a new window, it
is loaded in a new tab in an existing window instead.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-mozilla "browse-url" "\
Ask the Mozilla WWW browser to load URL.
Default to the URL around or before point.  The strings in variable
`browse-url-mozilla-arguments' are also passed to Mozilla.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new Mozilla window, otherwise use a
random existing one.  A non-nil interactive prefix argument reverses
the effect of `browse-url-new-window-flag'.

If `browse-url-mozilla-new-window-is-tab' is non-nil, then whenever a
document would otherwise be loaded in a new window, it is loaded in a
new tab in an existing window instead.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-firefox "browse-url" "\
Ask the Firefox WWW browser to load URL.
Defaults to the URL around or before point.  Passes the strings
in the variable `browse-url-firefox-arguments' to Firefox.

Interactively, if the variable `browse-url-new-window-flag' is non-nil,
loads the document in a new Firefox window.  A non-nil prefix argument
reverses the effect of `browse-url-new-window-flag'.

If `browse-url-firefox-new-window-is-tab' is non-nil, then
whenever a document would otherwise be loaded in a new window, it
is loaded in a new tab in an existing window instead.

Non-interactively, this uses the optional second argument NEW-WINDOW
instead of `browse-url-new-window-flag'.

On MS Windows, this ignores `browse-url-new-window-flag' and
`browse-url-firefox-new-window-is-tab', as well as the NEW-WINDOW argument.
It always uses a new window.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-chromium "browse-url" "\
Ask the Chromium WWW browser to load URL.
Default to the URL around or before point.  The strings in
variable `browse-url-chromium-arguments' are also passed to
Chromium.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-galeon "browse-url" "\
Ask the Galeon WWW browser to load URL.
Default to the URL around or before point.  The strings in variable
`browse-url-galeon-arguments' are also passed to Galeon.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new Galeon window, otherwise use a
random existing one.  A non-nil interactive prefix argument reverses
the effect of `browse-url-new-window-flag'.

If `browse-url-galeon-new-window-is-tab' is non-nil, then whenever a
document would otherwise be loaded in a new window, it is loaded in a
new tab in an existing window instead.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-emacs "browse-url" "\
Ask Emacs to load URL into a buffer and show it in another window.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-gnome-moz "browse-url" "\
Ask Mozilla/Netscape to load URL via the GNOME program `gnome-moz-remote'.
Default to the URL around or before point.  The strings in variable
`browse-url-gnome-moz-arguments' are also passed.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new browser window, otherwise use an
existing one.  A non-nil interactive prefix argument reverses the
effect of `browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-mosaic "browse-url" "\
Ask the XMosaic WWW browser to load URL.

Default to the URL around or before point.  The strings in variable
`browse-url-mosaic-arguments' are also passed to Mosaic and the
program is invoked according to the variable
`browse-url-mosaic-program'.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new Mosaic window, otherwise use a
random existing one.  A non-nil interactive prefix argument reverses
the effect of `browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-cci "browse-url" "\
Ask the XMosaic WWW browser to load URL.
Default to the URL around or before point.

This function only works for XMosaic version 2.5 or later.  You must
select `CCI' from XMosaic's File menu, set the CCI Port Address to the
value of variable `browse-url-CCI-port', and enable `Accept requests'.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new browser window, otherwise use a
random existing one.  A non-nil interactive prefix argument reverses
the effect of `browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-w3 "browse-url" "\
Ask the w3 WWW browser to load URL.
Default to the URL around or before point.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new window.  A non-nil interactive
prefix argument reverses the effect of `browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-w3-gnudoit "browse-url" "\
Ask another Emacs running gnuserv to load the URL using the W3 browser.
The `browse-url-gnudoit-program' program is used with options given by
`browse-url-gnudoit-args'.  Default to the URL around or before point.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-text-xterm "browse-url" "\
Ask a text browser to load URL.
URL defaults to the URL around or before point.
This runs the text browser specified by `browse-url-text-browser'.
in an Xterm window using the Xterm program named by `browse-url-xterm-program'
with possible additional arguments `browse-url-xterm-args'.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-text-emacs "browse-url" "\
Ask a text browser to load URL.
URL defaults to the URL around or before point.
This runs the text browser specified by `browse-url-text-browser'.
With a prefix argument, it runs a new browser process in a new buffer.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil, load the document in a new browser process in a new term window,
otherwise use any existing one.  A non-nil interactive prefix argument
reverses the effect of `browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-BUFFER)" t nil)

(autoload 'browse-url-mail "browse-url" "\
Open a new mail message buffer within Emacs for the RFC 2368 URL.
Default to using the mailto: URL around or before point as the
recipient's address.  Supplying a non-nil interactive prefix argument
will cause the mail to be composed in another window rather than the
current one.

When called interactively, if variable `browse-url-new-window-flag' is
non-nil use `compose-mail-other-window', otherwise `compose-mail'.  A
non-nil interactive prefix argument reverses the effect of
`browse-url-new-window-flag'.

When called non-interactively, optional second argument NEW-WINDOW is
used instead of `browse-url-new-window-flag'.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-generic "browse-url" "\
Ask the WWW browser defined by `browse-url-generic-program' to load URL.
Default to the URL around or before point.  A fresh copy of the
browser is started up in a new process with possible additional arguments
`browse-url-generic-args'.  This is appropriate for browsers which
don't offer a form of remote control.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-kde "browse-url" "\
Ask the KDE WWW browser to load URL.
Default to the URL around or before point.

\(fn URL &optional NEW-WINDOW)" t nil)

(autoload 'browse-url-elinks "browse-url" "\
Ask the Elinks WWW browser to load URL.
Default to the URL around the point.

The document is loaded in a new tab of a running Elinks or, if
none yet running, a newly started instance.

The Elinks command will be prepended by the program+arguments
from `browse-url-elinks-wrapper'.

\(fn URL &optional NEW-WINDOW)" t nil)

;;;***

;;;### (autoloads nil "bs" "bs.el" (21788 61018 0 0))
;;; Generated autoloads from bs.el
(push (purecopy '(bs 1 17)) package--builtin-versions)

(autoload 'bs-cycle-next "bs" "\
Select next buffer defined by buffer cycling.
The buffers taking part in buffer cycling are defined
by buffer configuration `bs-cycle-configuration-name'.

\(fn)" t nil)

(autoload 'bs-cycle-previous "bs" "\
Select previous buffer defined by buffer cycling.
The buffers taking part in buffer cycling are defined
by buffer configuration `bs-cycle-configuration-name'.

\(fn)" t nil)

(autoload 'bs-customize "bs" "\
Customization of group bs for Buffer Selection Menu.

\(fn)" t nil)

(autoload 'bs-show "bs" "\
Make a menu of buffers so you can manipulate buffers or the buffer list.
\\<bs-mode-map>
There are many key commands similar to `Buffer-menu-mode' for
manipulating the buffer list and the buffers themselves.
User can move with [up] or [down], select a buffer
by \\[bs-select] or [SPC]

Type \\[bs-kill] to leave Buffer Selection Menu without a selection.
Type \\[bs-help] after invocation to get help on commands available.
With prefix argument ARG show a different buffer list.  Function
`bs--configuration-name-for-prefix-arg' determine accordingly
name of buffer configuration.

\(fn ARG)" t nil)

;;;***

;;;### (autoloads nil "bubbles" "play/bubbles.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from play/bubbles.el

(autoload 'bubbles "bubbles" "\
Play Bubbles game.
\\<bubbles-mode-map>
The goal is to remove all bubbles with as few moves as possible.
\\[bubbles-plop] on a bubble removes that bubble and all
connected bubbles of the same color.  Unsupported bubbles fall
down, and columns that do not contain any bubbles suck the
columns on its right towards the left.

\\[bubbles-set-game-easy] sets the difficulty to easy.
\\[bubbles-set-game-medium] sets the difficulty to medium.
\\[bubbles-set-game-difficult] sets the difficulty to difficult.
\\[bubbles-set-game-hard] sets the difficulty to hard.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "bug-reference" "progmodes/bug-reference.el"
;;;;;;  (21710 25077 0 0))
;;; Generated autoloads from progmodes/bug-reference.el

(put 'bug-reference-url-format 'safe-local-variable (lambda (s) (or (stringp s) (and (symbolp s) (get s 'bug-reference-url-format)))))

(autoload 'bug-reference-mode "bug-reference" "\
Toggle hyperlinking bug references in the buffer (Bug Reference mode).
With a prefix argument ARG, enable Bug Reference mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

(autoload 'bug-reference-prog-mode "bug-reference" "\
Like `bug-reference-mode', but only buttonize in comments and strings.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "bytecomp" "emacs-lisp/bytecomp.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from emacs-lisp/bytecomp.el
(put 'byte-compile-dynamic 'safe-local-variable 'booleanp)
(put 'byte-compile-disable-print-circle 'safe-local-variable 'booleanp)
(put 'byte-compile-dynamic-docstrings 'safe-local-variable 'booleanp)

(put 'byte-compile-warnings 'safe-local-variable (lambda (v) (or (symbolp v) (null (delq nil (mapcar (lambda (x) (not (symbolp x))) v))))))

(autoload 'byte-compile-disable-warning "bytecomp" "\
Change `byte-compile-warnings' to disable WARNING.
If `byte-compile-warnings' is t, set it to `(not WARNING)'.
Otherwise, if the first element is `not', add WARNING, else remove it.
Normally you should let-bind `byte-compile-warnings' before calling this,
else the global value will be modified.

\(fn WARNING)" nil nil)

(autoload 'byte-compile-enable-warning "bytecomp" "\
Change `byte-compile-warnings' to enable WARNING.
If `byte-compile-warnings' is `t', do nothing.  Otherwise, if the
first element is `not', remove WARNING, else add it.
Normally you should let-bind `byte-compile-warnings' before calling this,
else the global value will be modified.

\(fn WARNING)" nil nil)

(autoload 'byte-force-recompile "bytecomp" "\
Recompile every `.el' file in DIRECTORY that already has a `.elc' file.
Files in subdirectories of DIRECTORY are processed also.

\(fn DIRECTORY)" t nil)

(autoload 'byte-recompile-directory "bytecomp" "\
Recompile every `.el' file in DIRECTORY that needs recompilation.
This happens when a `.elc' file exists but is older than the `.el' file.
Files in subdirectories of DIRECTORY are processed also.

If the `.elc' file does not exist, normally this function *does not*
compile the corresponding `.el' file.  However, if the prefix argument
ARG is 0, that means do compile all those files.  A nonzero
ARG means ask the user, for each such `.el' file, whether to
compile it.  A nonzero ARG also means ask about each subdirectory
before scanning it.

If the third argument FORCE is non-nil, recompile every `.el' file
that already has a `.elc' file.

\(fn DIRECTORY &optional ARG FORCE)" t nil)
(put 'no-byte-compile 'safe-local-variable 'booleanp)

(autoload 'byte-compile-file "bytecomp" "\
Compile a file of Lisp code named FILENAME into a file of byte code.
The output file's name is generated by passing FILENAME to the
function `byte-compile-dest-file' (which see).
With prefix arg (noninteractively: 2nd arg), LOAD the file after compiling.
The value is non-nil if there were no errors, nil if errors.

\(fn FILENAME &optional LOAD)" t nil)

(autoload 'compile-defun "bytecomp" "\
Compile and evaluate the current top-level form.
Print the result in the echo area.
With argument ARG, insert value in current buffer after the form.

\(fn &optional ARG)" t nil)

(autoload 'byte-compile "bytecomp" "\
If FORM is a symbol, byte-compile its function definition.
If FORM is a lambda or a macro, byte-compile it as a function.

\(fn FORM)" nil nil)

(autoload 'display-call-tree "bytecomp" "\
Display a call graph of a specified file.
This lists which functions have been called, what functions called
them, and what functions they call.  The list includes all functions
whose definitions have been compiled in this Emacs session, as well as
all functions called by those functions.

The call graph does not include macros, inline functions, or
primitives that the byte-code interpreter knows about directly (eq,
cons, etc.).

The call tree also lists those functions which are not known to be called
\(that is, to which no calls have been compiled), and which cannot be
invoked interactively.

\(fn &optional FILENAME)" t nil)

(autoload 'batch-byte-compile-if-not-done "bytecomp" "\
Like `byte-compile-file' but doesn't recompile if already up to date.
Use this from the command line, with `-batch';
it won't work in an interactive Emacs.

\(fn)" nil nil)

(autoload 'batch-byte-compile "bytecomp" "\
Run `byte-compile-file' on the files remaining on the command line.
Use this from the command line, with `-batch';
it won't work in an interactive Emacs.
Each file is processed even if an error occurred previously.
For example, invoke \"emacs -batch -f batch-byte-compile $emacs/ ~/*.el\".
If NOFORCE is non-nil, don't recompile a file that seems to be
already up-to-date.

\(fn &optional NOFORCE)" nil nil)

(autoload 'batch-byte-recompile-directory "bytecomp" "\
Run `byte-recompile-directory' on the dirs remaining on the command line.
Must be used only with `-batch', and kills Emacs on completion.
For example, invoke `emacs -batch -f batch-byte-recompile-directory .'.

Optional argument ARG is passed as second argument ARG to
`byte-recompile-directory'; see there for its possible values
and corresponding effects.

\(fn &optional ARG)" nil nil)

;;;***

;;;### (autoloads nil "cal-china" "calendar/cal-china.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from calendar/cal-china.el

(put 'calendar-chinese-time-zone 'risky-local-variable t)

(put 'chinese-calendar-time-zone 'risky-local-variable t)

;;;***

;;;### (autoloads nil "cal-dst" "calendar/cal-dst.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from calendar/cal-dst.el

(put 'calendar-daylight-savings-starts 'risky-local-variable t)

(put 'calendar-daylight-savings-ends 'risky-local-variable t)

(put 'calendar-current-time-zone-cache 'risky-local-variable t)

;;;***

;;;### (autoloads nil "cal-hebrew" "calendar/cal-hebrew.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from calendar/cal-hebrew.el

(autoload 'calendar-hebrew-list-yahrzeits "cal-hebrew" "\
List Yahrzeit dates for *Gregorian* DEATH-DATE from START-YEAR to END-YEAR.
When called interactively from the calendar window, the date of death is taken
from the cursor position.

\(fn DEATH-DATE START-YEAR END-YEAR)" t nil)

(define-obsolete-function-alias 'list-yahrzeit-dates 'calendar-hebrew-list-yahrzeits "23.1")

;;;***

;;;### (autoloads nil "calc" "calc/calc.el" (21788 61018 0 0))
;;; Generated autoloads from calc/calc.el
 (define-key ctl-x-map "*" 'calc-dispatch)

(autoload 'calc-dispatch "calc" "\
Invoke the GNU Emacs Calculator.  See \\[calc-dispatch-help] for details.

\(fn &optional ARG)" t nil)

(autoload 'calc "calc" "\
The Emacs Calculator.  Full documentation is listed under \"calc-mode\".

\(fn &optional ARG FULL-DISPLAY INTERACTIVE)" t nil)

(autoload 'full-calc "calc" "\
Invoke the Calculator and give it a full-sized window.

\(fn &optional INTERACTIVE)" t nil)

(autoload 'quick-calc "calc" "\
Do a quick calculation in the minibuffer without invoking full Calculator.

\(fn)" t nil)

(autoload 'calc-eval "calc" "\
Do a quick calculation and return the result as a string.
Return value will either be the formatted result in string form,
or a list containing a character position and an error message in string form.

\(fn STR &optional SEPARATOR &rest ARGS)" nil nil)

(autoload 'calc-keypad "calc" "\
Invoke the Calculator in \"visual keypad\" mode.
This is most useful in the X window system.
In this mode, click on the Calc \"buttons\" using the left mouse button.
Or, position the cursor manually and do M-x calc-keypad-press.

\(fn &optional INTERACTIVE)" t nil)

(autoload 'full-calc-keypad "calc" "\
Invoke the Calculator in full-screen \"visual keypad\" mode.
See calc-keypad for details.

\(fn &optional INTERACTIVE)" t nil)

(autoload 'calc-grab-region "calc" "\
Parse the region as a vector of numbers and push it on the Calculator stack.

\(fn TOP BOT ARG)" t nil)

(autoload 'calc-grab-rectangle "calc" "\
Parse a rectangle as a matrix of numbers and push it on the Calculator stack.

\(fn TOP BOT ARG)" t nil)

(autoload 'calc-embedded "calc" "\
Start Calc Embedded mode on the formula surrounding point.

\(fn ARG &optional END OBEG OEND)" t nil)

(autoload 'calc-embedded-activate "calc" "\
Scan the current editing buffer for all embedded := and => formulas.
Also looks for the equivalent TeX words, \\gets and \\evalto.

\(fn &optional ARG CBUF)" t nil)

(autoload 'defmath "calc" "\
Define Calc function.

Like `defun' except that code in the body of the definition can
make use of the full range of Calc data types and the usual
arithmetic operations are converted to their Calc equivalents.

The prefix `calcFunc-' is added to the specified name to get the
actual Lisp function name.

See Info node `(calc)Defining Functions'.

\(fn FUNC ARGS &rest BODY)" nil t)

(put 'defmath 'doc-string-elt '3)

;;;***

;;;### (autoloads nil "calc-undo" "calc/calc-undo.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from calc/calc-undo.el

(autoload 'calc-undo "calc-undo" "\


\(fn N)" t nil)

;;;***

;;;### (autoloads nil "calculator" "calculator.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from calculator.el

(autoload 'calculator "calculator" "\
Run the Emacs calculator.
See the documentation for `calculator-mode' for more information.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "calendar" "calendar/calendar.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from calendar/calendar.el

(autoload 'calendar "calendar" "\
Display a three-month Gregorian calendar.
The three months appear side by side, with the current month in
the middle surrounded by the previous and next months.  The
cursor is put on today's date.  If optional prefix argument ARG
is non-nil, prompts for the central month and year.

Once in the calendar window, future or past months can be moved
into view.  Arbitrary months can be displayed, or the calendar
can be scrolled forward or backward.  The cursor can be moved
forward or backward by one day, one week, one month, or one year.
All of these commands take prefix arguments which, when negative,
cause movement in the opposite direction.  For convenience, the
digit keys and the minus sign are automatically prefixes.  Use
\\[describe-mode] for details of the key bindings in the calendar
window.

Displays the calendar in a separate window, or optionally in a
separate frame, depending on the value of `calendar-setup'.

If `calendar-view-diary-initially-flag' is non-nil, also displays the
diary entries for the current date (or however many days
`diary-number-of-entries' specifies).  This variable can be
overridden by `calendar-setup'.  As well as being displayed,
diary entries can also be marked on the calendar (see
`calendar-mark-diary-entries-flag').

Runs the following hooks:

`calendar-load-hook' - after loading calendar.el
`calendar-today-visible-hook', `calendar-today-invisible-hook' - after
   generating a calendar, if today's date is visible or not, respectively
`calendar-initial-window-hook' - after first creating a calendar

This function is suitable for execution in an init file.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "canlock" "gnus/canlock.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from gnus/canlock.el

(autoload 'canlock-insert-header "canlock" "\
Insert a Cancel-Key and/or a Cancel-Lock header if possible.

\(fn &optional ID-FOR-KEY ID-FOR-LOCK PASSWORD)" nil nil)

(autoload 'canlock-verify "canlock" "\
Verify Cancel-Lock or Cancel-Key in BUFFER.
If BUFFER is nil, the current buffer is assumed.  Signal an error if
it fails.

\(fn &optional BUFFER)" t nil)

;;;***

;;;### (autoloads nil "cap-words" "progmodes/cap-words.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from progmodes/cap-words.el

(autoload 'capitalized-words-mode "cap-words" "\
Toggle Capitalized Words mode.
With a prefix argument ARG, enable Capitalized Words mode if ARG
is positive, and disable it otherwise.  If called from Lisp,
enable the mode if ARG is omitted or nil.

Capitalized Words mode is a buffer-local minor mode.  When
enabled, a word boundary occurs immediately before an uppercase
letter in a symbol.  This is in addition to all the normal
boundaries given by the syntax and category tables.  There is no
restriction to ASCII.

E.g. the beginning of words in the following identifier are as marked:

  capitalizedWorDD
  ^          ^  ^^

Note that these word boundaries only apply for word motion and
marking commands such as \\[forward-word].  This mode does not affect word
boundaries found by regexp matching (`\\>', `\\w' &c).

This style of identifiers is common in environments like Java ones,
where underscores aren't trendy enough.  Capitalization rules are
sometimes part of the language, e.g. Haskell, which may thus encourage
such a style.  It is appropriate to add `capitalized-words-mode' to
the mode hook for programming language modes in which you encounter
variables like this, e.g. `java-mode-hook'.  It's unlikely to cause
trouble if such identifiers aren't used.

See also `glasses-mode' and `studlify-word'.
Obsoletes `c-forward-into-nomenclature'.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "cc-engine" "progmodes/cc-engine.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from progmodes/cc-engine.el

(autoload 'c-guess-basic-syntax "cc-engine" "\
Return the syntactic context of the current line.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "cc-guess" "progmodes/cc-guess.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/cc-guess.el

(defvar c-guess-guessed-offsets-alist nil "\
Currently guessed offsets-alist.")

(defvar c-guess-guessed-basic-offset nil "\
Currently guessed basic-offset.")

(autoload 'c-guess "cc-guess" "\
Guess the style in the region up to `c-guess-region-max', and install it.

The style is given a name based on the file's absolute file name.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

\(fn &optional ACCUMULATE)" t nil)

(autoload 'c-guess-no-install "cc-guess" "\
Guess the style in the region up to `c-guess-region-max'; don't install it.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

\(fn &optional ACCUMULATE)" t nil)

(autoload 'c-guess-buffer "cc-guess" "\
Guess the style on the whole current buffer, and install it.

The style is given a name based on the file's absolute file name.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

\(fn &optional ACCUMULATE)" t nil)

(autoload 'c-guess-buffer-no-install "cc-guess" "\
Guess the style on the whole current buffer; don't install it.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

\(fn &optional ACCUMULATE)" t nil)

(autoload 'c-guess-region "cc-guess" "\
Guess the style on the region and install it.

The style is given a name based on the file's absolute file name.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous guess is extended, otherwise a new guess is
made from scratch.

\(fn START END &optional ACCUMULATE)" t nil)

(autoload 'c-guess-region-no-install "cc-guess" "\
Guess the style on the region; don't install it.

Every line of code in the region is examined and values for the following two
variables are guessed:

* `c-basic-offset', and
* the indentation values of the various syntactic symbols in
  `c-offsets-alist'.

The guessed values are put into `c-guess-guessed-basic-offset' and
`c-guess-guessed-offsets-alist'.

Frequencies of use are taken into account when guessing, so minor
inconsistencies in the indentation style shouldn't produce wrong guesses.

If given a prefix argument (or if the optional argument ACCUMULATE is
non-nil) then the previous examination is extended, otherwise a new
guess is made from scratch.

Note that the larger the region to guess in, the slower the guessing.
So you can limit the region with `c-guess-region-max'.

\(fn START END &optional ACCUMULATE)" t nil)

(autoload 'c-guess-install "cc-guess" "\
Install the latest guessed style into the current buffer.
\(This guessed style is a combination of `c-guess-guessed-basic-offset',
`c-guess-guessed-offsets-alist' and `c-offsets-alist'.)

The style is entered into CC Mode's style system by
`c-add-style'.  Its name is either STYLE-NAME, or a name based on
the absolute file name of the file if STYLE-NAME is nil.

\(fn &optional STYLE-NAME)" t nil)

;;;***

;;;### (autoloads nil "cc-mode" "progmodes/cc-mode.el" (21793 5616
;;;;;;  0 0))
;;; Generated autoloads from progmodes/cc-mode.el

(autoload 'c-initialize-cc-mode "cc-mode" "\
Initialize CC Mode for use in the current buffer.
If the optional NEW-STYLE-INIT is nil or left out then all necessary
initialization to run CC Mode for the C language is done.  Otherwise
only some basic setup is done, and a call to `c-init-language-vars' or
`c-init-language-vars-for' is necessary too (which gives more
control).  See \"cc-mode.el\" for more info.

\(fn &optional NEW-STYLE-INIT)" nil nil)
 (add-to-list 'auto-mode-alist '("\\.\\(cc\\|hh\\)\\'" . c++-mode))
 (add-to-list 'auto-mode-alist '("\\.[ch]\\(pp\\|xx\\|\\+\\+\\)\\'" . c++-mode))
 (add-to-list 'auto-mode-alist '("\\.\\(CC?\\|HH?\\)\\'" . c++-mode))
 (add-to-list 'auto-mode-alist '("\\.[ch]\\'" . c-mode))
 (add-to-list 'auto-mode-alist '("\\.y\\(acc\\)?\\'" . c-mode))
 (add-to-list 'auto-mode-alist '("\\.lex\\'" . c-mode))
 (add-to-list 'auto-mode-alist '("\\.i\\'" . c-mode))
 (add-to-list 'auto-mode-alist '("\\.ii\\'" . c++-mode))

(autoload 'c-mode "cc-mode" "\
Major mode for editing K&R and ANSI C code.
To submit a problem report, enter `\\[c-submit-bug-report]' from a
c-mode buffer.  This automatically sets up a mail buffer with version
information already added.  You just need to add a description of the
problem, including a reproducible test case, and send the message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `c-mode-hook'.

Key bindings:
\\{c-mode-map}

\(fn)" t nil)

(autoload 'c++-mode "cc-mode" "\
Major mode for editing C++ code.
To submit a problem report, enter `\\[c-submit-bug-report]' from a
c++-mode buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `c++-mode-hook'.

Key bindings:
\\{c++-mode-map}

\(fn)" t nil)
 (add-to-list 'auto-mode-alist '("\\.m\\'" . objc-mode))

(autoload 'objc-mode "cc-mode" "\
Major mode for editing Objective C code.
To submit a problem report, enter `\\[c-submit-bug-report]' from an
objc-mode buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `objc-mode-hook'.

Key bindings:
\\{objc-mode-map}

\(fn)" t nil)
 (add-to-list 'auto-mode-alist '("\\.java\\'" . java-mode))

(autoload 'java-mode "cc-mode" "\
Major mode for editing Java code.
To submit a problem report, enter `\\[c-submit-bug-report]' from a
java-mode buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `java-mode-hook'.

Key bindings:
\\{java-mode-map}

\(fn)" t nil)
 (add-to-list 'auto-mode-alist '("\\.idl\\'" . idl-mode))

(autoload 'idl-mode "cc-mode" "\
Major mode for editing CORBA's IDL, PSDL and CIDL code.
To submit a problem report, enter `\\[c-submit-bug-report]' from an
idl-mode buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `idl-mode-hook'.

Key bindings:
\\{idl-mode-map}

\(fn)" t nil)
 (add-to-list 'auto-mode-alist '("\\.\\(u?lpc\\|pike\\|pmod\\(\\.in\\)?\\)\\'" . pike-mode))
 (add-to-list 'interpreter-mode-alist '("pike" . pike-mode))

(autoload 'pike-mode "cc-mode" "\
Major mode for editing Pike code.
To submit a problem report, enter `\\[c-submit-bug-report]' from a
pike-mode buffer.  This automatically sets up a mail buffer with
version information already added.  You just need to add a description
of the problem, including a reproducible test case, and send the
message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `pike-mode-hook'.

Key bindings:
\\{pike-mode-map}

\(fn)" t nil)
 (add-to-list 'auto-mode-alist '("\\.awk\\'" . awk-mode))
 (add-to-list 'interpreter-mode-alist '("awk" . awk-mode))
 (add-to-list 'interpreter-mode-alist '("mawk" . awk-mode))
 (add-to-list 'interpreter-mode-alist '("nawk" . awk-mode))
 (add-to-list 'interpreter-mode-alist '("gawk" . awk-mode))

(autoload 'awk-mode "cc-mode" "\
Major mode for editing AWK code.
To submit a problem report, enter `\\[c-submit-bug-report]' from an
awk-mode buffer.  This automatically sets up a mail buffer with version
information already added.  You just need to add a description of the
problem, including a reproducible test case, and send the message.

To see what version of CC Mode you are running, enter `\\[c-version]'.

The hook `c-mode-common-hook' is run with no args at mode
initialization, then `awk-mode-hook'.

Key bindings:
\\{awk-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "cc-styles" "progmodes/cc-styles.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from progmodes/cc-styles.el

(autoload 'c-set-style "cc-styles" "\
Set the current buffer to use the style STYLENAME.
STYLENAME, a string, must be an existing CC Mode style - These are contained
in the variable `c-style-alist'.

The variable `c-indentation-style' will get set to STYLENAME.

\"Setting the style\" is done by setting CC Mode's \"style variables\" to the
values indicated by the pertinent entry in `c-style-alist'.  Other variables
might get set too.

If DONT-OVERRIDE is neither nil nor t, style variables whose default values
have been set (more precisely, whose default values are not the symbol
`set-from-style') will not be changed.  This avoids overriding global settings
done in your init file.  It is useful to call c-set-style from a mode hook
in this way.

If DONT-OVERRIDE is t, style variables that already have values (i.e., whose
values are not the symbol `set-from-style') will not be overridden.  CC Mode
calls c-set-style internally in this way whilst initializing a buffer; if
cc-set-style is called like this from anywhere else, it will usually behave as
a null operation.

\(fn STYLENAME &optional DONT-OVERRIDE)" t nil)

(autoload 'c-add-style "cc-styles" "\
Adds a style to `c-style-alist', or updates an existing one.
STYLE is a string identifying the style to add or update.  DESCRIPTION
is an association list describing the style and must be of the form:

  ([BASESTYLE] (VARIABLE . VALUE) [(VARIABLE . VALUE) ...])

See the variable `c-style-alist' for the semantics of BASESTYLE,
VARIABLE and VALUE.  This function also sets the current style to
STYLE using `c-set-style' if the optional SET-P flag is non-nil.

\(fn STYLE DESCRIPTION &optional SET-P)" t nil)

(autoload 'c-set-offset "cc-styles" "\
Change the value of a syntactic element symbol in `c-offsets-alist'.
SYMBOL is the syntactic element symbol to change and OFFSET is the new
offset for that syntactic element.  The optional argument is not used
and exists only for compatibility reasons.

\(fn SYMBOL OFFSET &optional IGNORED)" t nil)

;;;***

;;;### (autoloads nil "cc-vars" "progmodes/cc-vars.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/cc-vars.el
(put 'c-basic-offset 'safe-local-variable 'integerp)
(put 'c-backslash-column 'safe-local-variable 'integerp)
(put 'c-file-style 'safe-local-variable 'string-or-null-p)

;;;***

;;;### (autoloads nil "ccl" "international/ccl.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from international/ccl.el

(autoload 'ccl-compile "ccl" "\
Return the compiled code of CCL-PROGRAM as a vector of integers.

\(fn CCL-PROGRAM)" nil nil)

(autoload 'ccl-dump "ccl" "\
Disassemble compiled CCL-CODE.

\(fn CCL-CODE)" nil nil)

(autoload 'declare-ccl-program "ccl" "\
Declare NAME as a name of CCL program.

This macro exists for backward compatibility.  In the old version of
Emacs, to compile a CCL program which calls another CCL program not
yet defined, it must be declared as a CCL program in advance.  But,
now CCL program names are resolved not at compile time but before
execution.

Optional arg VECTOR is a compiled CCL code of the CCL program.

\(fn NAME &optional VECTOR)" nil t)

(autoload 'define-ccl-program "ccl" "\
Set NAME the compiled code of CCL-PROGRAM.

CCL-PROGRAM has this form:
	(BUFFER_MAGNIFICATION
	 CCL_MAIN_CODE
	 [ CCL_EOF_CODE ])

BUFFER_MAGNIFICATION is an integer value specifying the approximate
output buffer magnification size compared with the bytes of input data
text.  It is assured that the actual output buffer has 256 bytes
more than the size calculated by BUFFER_MAGNIFICATION.
If the value is zero, the CCL program can't execute `read' and
`write' commands.

CCL_MAIN_CODE and CCL_EOF_CODE are CCL program codes.  CCL_MAIN_CODE
executed at first.  If there's no more input data when `read' command
is executed in CCL_MAIN_CODE, CCL_EOF_CODE is executed.  If
CCL_MAIN_CODE is terminated, CCL_EOF_CODE is not executed.

Here's the syntax of CCL program code in BNF notation.  The lines
starting by two semicolons (and optional leading spaces) describe the
semantics.

CCL_MAIN_CODE := CCL_BLOCK

CCL_EOF_CODE := CCL_BLOCK

CCL_BLOCK := STATEMENT | (STATEMENT [STATEMENT ...])

STATEMENT :=
	SET | IF | BRANCH | LOOP | REPEAT | BREAK | READ | WRITE | CALL
	| TRANSLATE | MAP | LOOKUP | END

SET :=	(REG = EXPRESSION)
	| (REG ASSIGNMENT_OPERATOR EXPRESSION)
	;; The following form is the same as (r0 = integer).
	| integer

EXPRESSION := ARG | (EXPRESSION OPERATOR ARG)

;; Evaluate EXPRESSION.  If the result is nonzero, execute
;; CCL_BLOCK_0.  Otherwise, execute CCL_BLOCK_1.
IF :=	(if EXPRESSION CCL_BLOCK_0 CCL_BLOCK_1)

;; Evaluate EXPRESSION.  Provided that the result is N, execute
;; CCL_BLOCK_N.
BRANCH := (branch EXPRESSION CCL_BLOCK_0 [CCL_BLOCK_1 ...])

;; Execute STATEMENTs until (break) or (end) is executed.
LOOP := (loop STATEMENT [STATEMENT ...])

;; Terminate the most inner loop.
BREAK := (break)

REPEAT :=
	;; Jump to the head of the most inner loop.
	(repeat)
	;; Same as: ((write [REG | integer | string])
	;;	     (repeat))
	| (write-repeat [REG | integer | string])
	;; Same as: ((write REG [ARRAY])
	;;	     (read REG)
	;;	     (repeat))
	| (write-read-repeat REG [ARRAY])
	;; Same as: ((write integer)
	;;	     (read REG)
	;;	     (repeat))
	| (write-read-repeat REG integer)

READ := ;; Set REG_0 to a byte read from the input text, set REG_1
	;; to the next byte read, and so on.
	(read REG_0 [REG_1 ...])
	;; Same as: ((read REG)
	;;	     (if (REG OPERATOR ARG) CCL_BLOCK_0 CCL_BLOCK_1))
	| (read-if (REG OPERATOR ARG) CCL_BLOCK_0 CCL_BLOCK_1)
	;; Same as: ((read REG)
	;;	     (branch REG CCL_BLOCK_0 [CCL_BLOCK_1 ...]))
	| (read-branch REG CCL_BLOCK_0 [CCL_BLOCK_1 ...])
	;; Read a character from the input text while parsing
	;; multibyte representation, set REG_0 to the charset ID of
	;; the character, set REG_1 to the code point of the
	;; character.  If the dimension of charset is two, set REG_1
	;; to ((CODE0 << 7) | CODE1), where CODE0 is the first code
	;; point and CODE1 is the second code point.
	| (read-multibyte-character REG_0 REG_1)

WRITE :=
	;; Write REG_0, REG_1, ... to the output buffer.  If REG_N is
	;; a multibyte character, write the corresponding multibyte
	;; representation.
	(write REG_0 [REG_1 ...])
	;; Same as: ((r7 = EXPRESSION)
	;;	     (write r7))
	| (write EXPRESSION)
	;; Write the value of `integer' to the output buffer.  If it
	;; is a multibyte character, write the corresponding multibyte
	;; representation.
	| (write integer)
	;; Write the byte sequence of `string' as is to the output
	;; buffer.
	| (write string)
	;; Same as: (write string)
	| string
	;; Provided that the value of REG is N, write Nth element of
	;; ARRAY to the output buffer.  If it is a multibyte
	;; character, write the corresponding multibyte
	;; representation.
	| (write REG ARRAY)
	;; Write a multibyte representation of a character whose
	;; charset ID is REG_0 and code point is REG_1.  If the
	;; dimension of the charset is two, REG_1 should be ((CODE0 <<
	;; 7) | CODE1), where CODE0 is the first code point and CODE1
	;; is the second code point of the character.
	| (write-multibyte-character REG_0 REG_1)

;; Call CCL program whose name is ccl-program-name.
CALL := (call ccl-program-name)

;; Terminate the CCL program.
END := (end)

;; CCL registers that can contain any integer value.  As r7 is also
;; used by CCL interpreter, its value is changed unexpectedly.
REG := r0 | r1 | r2 | r3 | r4 | r5 | r6 | r7

ARG := REG | integer

OPERATOR :=
	;; Normal arithmetic operators (same meaning as C code).
	+ | - | * | / | %

	;; Bitwise operators (same meaning as C code)
	| & | `|' | ^

	;; Shifting operators (same meaning as C code)
	| << | >>

	;; (REG = ARG_0 <8 ARG_1) means:
	;;	(REG = ((ARG_0 << 8) | ARG_1))
	| <8

	;; (REG = ARG_0 >8 ARG_1) means:
	;;	((REG = (ARG_0 >> 8))
	;;	 (r7 = (ARG_0 & 255)))
	| >8

	;; (REG = ARG_0 // ARG_1) means:
	;;	((REG = (ARG_0 / ARG_1))
	;;	 (r7 = (ARG_0 % ARG_1)))
	| //

	;; Normal comparing operators (same meaning as C code)
	| < | > | == | <= | >= | !=

	;; If ARG_0 and ARG_1 are higher and lower byte of Shift-JIS
	;; code, and CHAR is the corresponding JISX0208 character,
	;; (REG = ARG_0 de-sjis ARG_1) means:
	;;	((REG = CODE0)
	;;	 (r7 = CODE1))
	;; where CODE0 is the first code point of CHAR, CODE1 is the
	;; second code point of CHAR.
	| de-sjis

	;; If ARG_0 and ARG_1 are the first and second code point of
	;; JISX0208 character CHAR, and SJIS is the corresponding
	;; Shift-JIS code,
	;; (REG = ARG_0 en-sjis ARG_1) means:
	;;	((REG = HIGH)
	;;	 (r7 = LOW))
	;; where HIGH is the higher byte of SJIS, LOW is the lower
	;; byte of SJIS.
	| en-sjis

ASSIGNMENT_OPERATOR :=
	;; Same meaning as C code
	+= | -= | *= | /= | %= | &= | `|=' | ^= | <<= | >>=

	;; (REG <8= ARG) is the same as:
	;;	((REG <<= 8)
	;;	 (REG |= ARG))
	| <8=

	;; (REG >8= ARG) is the same as:
	;;	((r7 = (REG & 255))
	;;	 (REG >>= 8))

	;; (REG //= ARG) is the same as:
	;;	((r7 = (REG % ARG))
	;;	 (REG /= ARG))
	| //=

ARRAY := `[' integer ... `]'


TRANSLATE :=
	(translate-character REG(table) REG(charset) REG(codepoint))
	| (translate-character SYMBOL REG(charset) REG(codepoint))
        ;; SYMBOL must refer to a table defined by `define-translation-table'.
LOOKUP :=
	(lookup-character SYMBOL REG(charset) REG(codepoint))
	| (lookup-integer SYMBOL REG(integer))
        ;; SYMBOL refers to a table defined by `define-translation-hash-table'.
MAP :=
     (iterate-multiple-map REG REG MAP-IDs)
     | (map-multiple REG REG (MAP-SET))
     | (map-single REG REG MAP-ID)
MAP-IDs := MAP-ID ...
MAP-SET := MAP-IDs | (MAP-IDs) MAP-SET
MAP-ID := integer

\(fn NAME CCL-PROGRAM &optional DOC)" nil t)

(put 'define-ccl-program 'doc-string-elt '3)

(autoload 'check-ccl-program "ccl" "\
Check validity of CCL-PROGRAM.
If CCL-PROGRAM is a symbol denoting a CCL program, return
CCL-PROGRAM, else return nil.
If CCL-PROGRAM is a vector and optional arg NAME (symbol) is supplied,
register CCL-PROGRAM by name NAME, and return NAME.

\(fn CCL-PROGRAM &optional NAME)" nil t)

(autoload 'ccl-execute-with-args "ccl" "\
Execute CCL-PROGRAM with registers initialized by the remaining args.
The return value is a vector of resulting CCL registers.

See the documentation of `define-ccl-program' for the detail of CCL program.

\(fn CCL-PROG &rest ARGS)" nil nil)

;;;***

;;;### (autoloads nil "cconv" "emacs-lisp/cconv.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/cconv.el

(autoload 'cconv-closure-convert "cconv" "\
Main entry point for closure conversion.
-- FORM is a piece of Elisp code after macroexpansion.
-- TOPLEVEL(optional) is a boolean variable, true if we are at the root of AST

Returns a form where all lambdas don't have any free variables.

\(fn FORM)" nil nil)

(autoload 'cconv-warnings-only "cconv" "\
Add the warnings that closure conversion would encounter.

\(fn FORM)" nil nil)

;;;***

;;;### (autoloads nil "cedet" "cedet/cedet.el" (21710 25077 0 0))
;;; Generated autoloads from cedet/cedet.el
(push (purecopy '(cedet 2 0)) package--builtin-versions)

;;;***

;;;### (autoloads nil "cfengine" "progmodes/cfengine.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/cfengine.el
(push (purecopy '(cfengine 1 3)) package--builtin-versions)

(autoload 'cfengine3-mode "cfengine" "\
Major mode for editing CFEngine3 input.
There are no special keybindings by default.

Action blocks are treated as defuns, i.e. \\[beginning-of-defun] moves
to the action header.

\(fn)" t nil)

(autoload 'cfengine2-mode "cfengine" "\
Major mode for editing CFEngine2 input.
There are no special keybindings by default.

Action blocks are treated as defuns, i.e. \\[beginning-of-defun] moves
to the action header.

\(fn)" t nil)

(autoload 'cfengine-auto-mode "cfengine" "\
Choose between `cfengine2-mode' and `cfengine3-mode' depending
on the buffer contents

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "chart" "emacs-lisp/chart.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/chart.el
(push (purecopy '(chart 0 2)) package--builtin-versions)

;;;***

;;;### (autoloads nil "check-declare" "emacs-lisp/check-declare.el"
;;;;;;  (21788 61018 0 0))
;;; Generated autoloads from emacs-lisp/check-declare.el

(autoload 'check-declare-file "check-declare" "\
Check veracity of all `declare-function' statements in FILE.
See `check-declare-directory' for more information.

\(fn FILE)" t nil)

(autoload 'check-declare-directory "check-declare" "\
Check veracity of all `declare-function' statements under directory ROOT.
Returns non-nil if any false statements are found.

\(fn ROOT)" t nil)

;;;***

;;;### (autoloads nil "checkdoc" "emacs-lisp/checkdoc.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from emacs-lisp/checkdoc.el
(push (purecopy '(checkdoc 0 6 2)) package--builtin-versions)
(put 'checkdoc-force-docstrings-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-force-history-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-permit-comma-termination-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-spellcheck-documentation-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-ispell-list-words 'safe-local-variable #'checkdoc-list-of-strings-p)
(put 'checkdoc-arguments-in-order-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-verb-check-experimental-flag 'safe-local-variable #'booleanp)
(put 'checkdoc-symbol-words 'safe-local-variable #'checkdoc-list-of-strings-p)

(autoload 'checkdoc-list-of-strings-p "checkdoc" "\


\(fn OBJ)" nil nil)
(put 'checkdoc-proper-noun-regexp 'safe-local-variable 'stringp)
(put 'checkdoc-common-verbs-regexp 'safe-local-variable 'stringp)

(autoload 'checkdoc "checkdoc" "\
Interactively check the entire buffer for style errors.
The current status of the check will be displayed in a buffer which
the users will view as each check is completed.

\(fn)" t nil)

(autoload 'checkdoc-interactive "checkdoc" "\
Interactively check the current buffer for doc string errors.
Prefix argument START-HERE will start the checking from the current
point, otherwise the check starts at the beginning of the current
buffer.  Allows navigation forward and backwards through document
errors.  Does not check for comment or space warnings.
Optional argument SHOWSTATUS indicates that we should update the
checkdoc status window instead of the usual behavior.

\(fn &optional START-HERE SHOWSTATUS)" t nil)

(autoload 'checkdoc-message-interactive "checkdoc" "\
Interactively check the current buffer for message string errors.
Prefix argument START-HERE will start the checking from the current
point, otherwise the check starts at the beginning of the current
buffer.  Allows navigation forward and backwards through document
errors.  Does not check for comment or space warnings.
Optional argument SHOWSTATUS indicates that we should update the
checkdoc status window instead of the usual behavior.

\(fn &optional START-HERE SHOWSTATUS)" t nil)

(autoload 'checkdoc-eval-current-buffer "checkdoc" "\
Evaluate and check documentation for the current buffer.
Evaluation is done first because good documentation for something that
doesn't work is just not useful.  Comments, doc strings, and rogue
spacing are all verified.

\(fn)" t nil)

(autoload 'checkdoc-current-buffer "checkdoc" "\
Check current buffer for document, comment, error style, and rogue spaces.
With a prefix argument (in Lisp, the argument TAKE-NOTES),
store all errors found in a warnings buffer,
otherwise stop after the first error.

\(fn &optional TAKE-NOTES)" t nil)

(autoload 'checkdoc-start "checkdoc" "\
Start scanning the current buffer for documentation string style errors.
Only documentation strings are checked.
Use `checkdoc-continue' to continue checking if an error cannot be fixed.
Prefix argument TAKE-NOTES means to collect all the warning messages into
a separate buffer.

\(fn &optional TAKE-NOTES)" t nil)

(autoload 'checkdoc-continue "checkdoc" "\
Find the next doc string in the current buffer which has a style error.
Prefix argument TAKE-NOTES means to continue through the whole buffer and
save warnings in a separate buffer.  Second optional argument START-POINT
is the starting location.  If this is nil, `point-min' is used instead.

\(fn &optional TAKE-NOTES)" t nil)

(autoload 'checkdoc-comments "checkdoc" "\
Find missing comment sections in the current Emacs Lisp file.
Prefix argument TAKE-NOTES non-nil means to save warnings in a
separate buffer.  Otherwise print a message.  This returns the error
if there is one.

\(fn &optional TAKE-NOTES)" t nil)

(autoload 'checkdoc-rogue-spaces "checkdoc" "\
Find extra spaces at the end of lines in the current file.
Prefix argument TAKE-NOTES non-nil means to save warnings in a
separate buffer.  Otherwise print a message.  This returns the error
if there is one.
Optional argument INTERACT permits more interactive fixing.

\(fn &optional TAKE-NOTES INTERACT)" t nil)

(autoload 'checkdoc-message-text "checkdoc" "\
Scan the buffer for occurrences of the error function, and verify text.
Optional argument TAKE-NOTES causes all errors to be logged.

\(fn &optional TAKE-NOTES)" t nil)

(autoload 'checkdoc-eval-defun "checkdoc" "\
Evaluate the current form with `eval-defun' and check its documentation.
Evaluation is done first so the form will be read before the
documentation is checked.  If there is a documentation error, then the display
of what was evaluated will be overwritten by the diagnostic message.

\(fn)" t nil)

(autoload 'checkdoc-defun "checkdoc" "\
Examine the doc string of the function or variable under point.
Call `error' if the doc string has problems.  If NO-ERROR is
non-nil, then do not call error, but call `message' instead.
If the doc string passes the test, then check the function for rogue white
space at the end of each line.

\(fn &optional NO-ERROR)" t nil)

(autoload 'checkdoc-ispell "checkdoc" "\
Check the style and spelling of everything interactively.
Calls `checkdoc' with spell-checking turned on.
Prefix argument is the same as for `checkdoc'

\(fn)" t nil)

(autoload 'checkdoc-ispell-current-buffer "checkdoc" "\
Check the style and spelling of the current buffer.
Calls `checkdoc-current-buffer' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-current-buffer'

\(fn)" t nil)

(autoload 'checkdoc-ispell-interactive "checkdoc" "\
Check the style and spelling of the current buffer interactively.
Calls `checkdoc-interactive' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-interactive'

\(fn)" t nil)

(autoload 'checkdoc-ispell-message-interactive "checkdoc" "\
Check the style and spelling of message text interactively.
Calls `checkdoc-message-interactive' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-message-interactive'

\(fn)" t nil)

(autoload 'checkdoc-ispell-message-text "checkdoc" "\
Check the style and spelling of message text interactively.
Calls `checkdoc-message-text' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-message-text'

\(fn)" t nil)

(autoload 'checkdoc-ispell-start "checkdoc" "\
Check the style and spelling of the current buffer.
Calls `checkdoc-start' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-start'

\(fn)" t nil)

(autoload 'checkdoc-ispell-continue "checkdoc" "\
Check the style and spelling of the current buffer after point.
Calls `checkdoc-continue' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-continue'

\(fn)" t nil)

(autoload 'checkdoc-ispell-comments "checkdoc" "\
Check the style and spelling of the current buffer's comments.
Calls `checkdoc-comments' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-comments'

\(fn)" t nil)

(autoload 'checkdoc-ispell-defun "checkdoc" "\
Check the style and spelling of the current defun with Ispell.
Calls `checkdoc-defun' with spell-checking turned on.
Prefix argument is the same as for `checkdoc-defun'

\(fn)" t nil)

(autoload 'checkdoc-minor-mode "checkdoc" "\
Toggle automatic docstring checking (Checkdoc minor mode).
With a prefix argument ARG, enable Checkdoc minor mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

In Checkdoc minor mode, the usual bindings for `eval-defun' which is
bound to \\<checkdoc-minor-mode-map>\\[checkdoc-eval-defun] and `checkdoc-eval-current-buffer' are overridden to include
checking of documentation strings.

\\{checkdoc-minor-mode-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "china-util" "language/china-util.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from language/china-util.el

(autoload 'decode-hz-region "china-util" "\
Decode HZ/ZW encoded text in the current region.
Return the length of resulting text.

\(fn BEG END)" t nil)

(autoload 'decode-hz-buffer "china-util" "\
Decode HZ/ZW encoded text in the current buffer.

\(fn)" t nil)

(autoload 'encode-hz-region "china-util" "\
Encode the text in the current region to HZ.
Return the length of resulting text.

\(fn BEG END)" t nil)

(autoload 'encode-hz-buffer "china-util" "\
Encode the text in the current buffer to HZ.

\(fn)" t nil)

(autoload 'post-read-decode-hz "china-util" "\


\(fn LEN)" nil nil)

(autoload 'pre-write-encode-hz "china-util" "\


\(fn FROM TO)" nil nil)

;;;***

;;;### (autoloads nil "chistory" "chistory.el" (21710 25077 0 0))
;;; Generated autoloads from chistory.el

(autoload 'repeat-matching-complex-command "chistory" "\
Edit and re-evaluate complex command with name matching PATTERN.
Matching occurrences are displayed, most recent first, until you select
a form for evaluation.  If PATTERN is empty (or nil), every form in the
command history is offered.  The form is placed in the minibuffer for
editing and the result is evaluated.

\(fn &optional PATTERN)" t nil)

(autoload 'list-command-history "chistory" "\
List history of commands typed to minibuffer.
The number of commands listed is controlled by `list-command-history-max'.
Calls value of `list-command-history-filter' (if non-nil) on each history
element to judge if that element should be excluded from the list.

The buffer is left in Command History mode.

\(fn)" t nil)

(autoload 'command-history "chistory" "\
Examine commands from `command-history' in a buffer.
The number of commands listed is controlled by `list-command-history-max'.
The command history is filtered by `list-command-history-filter' if non-nil.
Use \\<command-history-map>\\[command-history-repeat] to repeat the command on the current line.

Otherwise much like Emacs-Lisp Mode except that there is no self-insertion
and digits provide prefix arguments.  Tab does not indent.
\\{command-history-map}

This command always recompiles the Command History listing
and runs the normal hook `command-history-hook'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "cl-indent" "emacs-lisp/cl-indent.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from emacs-lisp/cl-indent.el

(autoload 'common-lisp-indent-function "cl-indent" "\
Function to indent the arguments of a Lisp function call.
This is suitable for use as the value of the variable
`lisp-indent-function'.  INDENT-POINT is the point at which the
indentation function is called, and STATE is the
`parse-partial-sexp' state at that position.  Browse the
`lisp-indent' customize group for options affecting the behavior
of this function.

If the indentation point is in a call to a Lisp function, that
function's `common-lisp-indent-function' property specifies how
this function should indent it.  Possible values for this
property are:

* defun, meaning indent according to `lisp-indent-defun-method';
  i.e., like (4 &lambda &body), as explained below.

* any other symbol, meaning a function to call.  The function should
  take the arguments: PATH STATE INDENT-POINT SEXP-COLUMN NORMAL-INDENT.
  PATH is a list of integers describing the position of point in terms of
  list-structure with respect to the containing lists.  For example, in
  ((a b c (d foo) f) g), foo has a path of (0 3 1).  In other words,
  to reach foo take the 0th element of the outermost list, then
  the 3rd element of the next list, and finally the 1st element.
  STATE and INDENT-POINT are as in the arguments to
  `common-lisp-indent-function'.  SEXP-COLUMN is the column of
  the open parenthesis of the innermost containing list.
  NORMAL-INDENT is the column the indentation point was
  originally in.  This function should behave like `lisp-indent-259'.

* an integer N, meaning indent the first N arguments like
  function arguments, and any further arguments like a body.
  This is equivalent to (4 4 ... &body).

* a list.  The list element in position M specifies how to indent the Mth
  function argument.  If there are fewer elements than function arguments,
  the last list element applies to all remaining arguments.  The accepted
  list elements are:

  * nil, meaning the default indentation.

  * an integer, specifying an explicit indentation.

  * &lambda.  Indent the argument (which may be a list) by 4.

  * &rest.  When used, this must be the penultimate element.  The
    element after this one applies to all remaining arguments.

  * &body.  This is equivalent to &rest lisp-body-indent, i.e., indent
    all remaining elements by `lisp-body-indent'.

  * &whole.  This must be followed by nil, an integer, or a
    function symbol.  This indentation is applied to the
    associated argument, and as a base indent for all remaining
    arguments.  For example, an integer P means indent this
    argument by P, and all remaining arguments by P, plus the
    value specified by their associated list element.

  * a symbol.  A function to call, with the 6 arguments specified above.

  * a list, with elements as described above.  This applies when the
    associated function argument is itself a list.  Each element of the list
    specifies how to indent the associated argument.

For example, the function `case' has an indent property
\(4 &rest (&whole 2 &rest 1)), meaning:
  * indent the first argument by 4.
  * arguments after the first should be lists, and there may be any number
    of them.  The first list element has an offset of 2, all the rest
    have an offset of 2+1=3.

\(fn INDENT-POINT STATE)" nil nil)

;;;***

;;;### (autoloads nil "cl-lib" "emacs-lisp/cl-lib.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/cl-lib.el
(push (purecopy '(cl-lib 1 0)) package--builtin-versions)

(define-obsolete-variable-alias 'custom-print-functions 'cl-custom-print-functions "24.3")

(defvar cl-custom-print-functions nil "\
This is a list of functions that format user objects for printing.
Each function is called in turn with three arguments: the object, the
stream, and the print level (currently ignored).  If it is able to
print the object it returns true; otherwise it returns nil and the
printer proceeds to the next function on the list.

This variable is not used at present, but it is defined in hopes that
a future Emacs interpreter will be able to use it.")

(define-error 'cl-assertion-failed (purecopy "Assertion failed"))

(autoload 'cl--defsubst-expand "cl-macs")

(put 'cl-defun 'doc-string-elt 3)

(put 'cl-defmacro 'doc-string-elt 3)

(put 'cl-defsubst 'doc-string-elt 3)

(put 'cl-defstruct 'doc-string-elt 2)

;;;***

;;;### (autoloads nil "cmacexp" "progmodes/cmacexp.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/cmacexp.el

(autoload 'c-macro-expand "cmacexp" "\
Expand C macros in the region, using the C preprocessor.
Normally display output in temp buffer, but
prefix arg means replace the region with it.

`c-macro-preprocessor' specifies the preprocessor to use.
Tf the user option `c-macro-prompt-flag' is non-nil
prompt for arguments to the preprocessor (e.g. `-DDEBUG -I ./include'),
otherwise use `c-macro-cppflags'.

Noninteractive args are START, END, SUBST.
For use inside Lisp programs, see also `c-macro-expansion'.

\(fn START END SUBST)" t nil)

;;;***

;;;### (autoloads nil "cmuscheme" "cmuscheme.el" (21710 25077 0 0))
;;; Generated autoloads from cmuscheme.el

(autoload 'run-scheme "cmuscheme" "\
Run an inferior Scheme process, input and output via buffer `*scheme*'.
If there is a process already running in `*scheme*', switch to that buffer.
With argument, allows you to edit the command line (default is value
of `scheme-program-name').
If the file `~/.emacs_SCHEMENAME' or `~/.emacs.d/init_SCHEMENAME.scm' exists,
it is given as initial input.
Note that this may lose due to a timing error if the Scheme processor
discards input when it starts up.
Runs the hook `inferior-scheme-mode-hook' (after the `comint-mode-hook'
is run).
\(Type \\[describe-mode] in the process buffer for a list of commands.)

\(fn CMD)" t nil)

;;;***

;;;### (autoloads nil "color" "color.el" (21710 25077 0 0))
;;; Generated autoloads from color.el

(autoload 'color-name-to-rgb "color" "\
Convert COLOR string to a list of normalized RGB components.
COLOR should be a color name (e.g. \"white\") or an RGB triplet
string (e.g. \"#ff12ec\").

Normally the return value is a list of three floating-point
numbers, (RED GREEN BLUE), each between 0.0 and 1.0 inclusive.

Optional argument FRAME specifies the frame where the color is to be
displayed.  If FRAME is omitted or nil, use the selected frame.
If FRAME cannot display COLOR, return nil.

\(fn COLOR &optional FRAME)" nil nil)

;;;***

;;;### (autoloads nil "comint" "comint.el" (21788 61018 0 0))
;;; Generated autoloads from comint.el

(defvar comint-output-filter-functions '(ansi-color-process-output comint-postoutput-scroll-to-bottom comint-watch-for-password-prompt) "\
Functions to call after output is inserted into the buffer.
One possible function is `comint-postoutput-scroll-to-bottom'.
These functions get one argument, a string containing the text as originally
inserted.  Note that this might not be the same as the buffer contents between
`comint-last-output-start' and the buffer's `process-mark', if other filter
functions have already modified the buffer.

See also `comint-preoutput-filter-functions'.

You can use `add-hook' to add functions to this list
either globally or locally.")

(autoload 'make-comint-in-buffer "comint" "\
Make a Comint process NAME in BUFFER, running PROGRAM.
If BUFFER is nil, it defaults to NAME surrounded by `*'s.
If there is a running process in BUFFER, it is not restarted.

PROGRAM should be one of the following:
- a string, denoting an executable program to create via
  `start-file-process'
- a cons pair of the form (HOST . SERVICE), denoting a TCP
  connection to be opened via `open-network-stream'
- nil, denoting a newly-allocated pty.

Optional fourth arg STARTFILE is the name of a file, whose
contents are sent to the process as its initial input.

If PROGRAM is a string, any more args are arguments to PROGRAM.

Return the (possibly newly created) process buffer.

\(fn NAME BUFFER PROGRAM &optional STARTFILE &rest SWITCHES)" nil nil)

(autoload 'make-comint "comint" "\
Make a Comint process NAME in a buffer, running PROGRAM.
The name of the buffer is made by surrounding NAME with `*'s.
PROGRAM should be either a string denoting an executable program to create
via `start-file-process', or a cons pair of the form (HOST . SERVICE) denoting
a TCP connection to be opened via `open-network-stream'.  If there is already
a running process in that buffer, it is not restarted.  Optional third arg
STARTFILE is the name of a file, whose contents are sent to the
process as its initial input.

If PROGRAM is a string, any more args are arguments to PROGRAM.

Returns the (possibly newly created) process buffer.

\(fn NAME PROGRAM &optional STARTFILE &rest SWITCHES)" nil nil)

(autoload 'comint-run "comint" "\
Run PROGRAM in a Comint buffer and switch to it.
The buffer name is made by surrounding the file name of PROGRAM with `*'s.
The file name is used to make a symbol name, such as `comint-sh-hook', and any
hooks on this symbol are run in the buffer.
See `make-comint' and `comint-exec'.

\(fn PROGRAM)" t nil)

(defvar comint-file-name-prefix (purecopy "") "\
Prefix prepended to absolute file names taken from process input.
This is used by Comint's and shell's completion functions, and by shell's
directory tracking functions.")

(autoload 'comint-redirect-send-command "comint" "\
Send COMMAND to process in current buffer, with output to OUTPUT-BUFFER.
With prefix arg ECHO, echo output in process buffer.

If NO-DISPLAY is non-nil, do not show the output buffer.

\(fn COMMAND OUTPUT-BUFFER ECHO &optional NO-DISPLAY)" t nil)

(autoload 'comint-redirect-send-command-to-process "comint" "\
Send COMMAND to PROCESS, with output to OUTPUT-BUFFER.
With prefix arg, echo output in process buffer.

If NO-DISPLAY is non-nil, do not show the output buffer.

\(fn COMMAND OUTPUT-BUFFER PROCESS ECHO &optional NO-DISPLAY)" t nil)

(autoload 'comint-redirect-results-list "comint" "\
Send COMMAND to current process.
Return a list of expressions in the output which match REGEXP.
REGEXP-GROUP is the regular expression group in REGEXP to use.

\(fn COMMAND REGEXP REGEXP-GROUP)" nil nil)

(autoload 'comint-redirect-results-list-from-process "comint" "\
Send COMMAND to PROCESS.
Return a list of expressions in the output which match REGEXP.
REGEXP-GROUP is the regular expression group in REGEXP to use.

\(fn PROCESS COMMAND REGEXP REGEXP-GROUP)" nil nil)

;;;***

;;;### (autoloads nil "compare-w" "vc/compare-w.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from vc/compare-w.el

(autoload 'compare-windows "compare-w" "\
Compare text in current window with text in next window.
Compares the text starting at point in each window,
moving over text in each one as far as they match.

This command pushes the mark in each window
at the prior location of point in that window.
If both windows display the same buffer,
the mark is pushed twice in that buffer:
first in the other window, then in the selected window.

A prefix arg means reverse the value of variable
`compare-ignore-whitespace'.  If `compare-ignore-whitespace' is
nil, then a prefix arg means ignore changes in whitespace.  If
`compare-ignore-whitespace' is non-nil, then a prefix arg means
don't ignore changes in whitespace.  The variable
`compare-windows-whitespace' controls how whitespace is skipped.
If `compare-ignore-case' is non-nil, changes in case are also
ignored.

If `compare-windows-sync' is non-nil, then successive calls of
this command work in interlaced mode:
on first call it advances points to the next difference,
on second call it synchronizes points by skipping the difference,
on third call it again advances points to the next difference and so on.

\(fn IGNORE-WHITESPACE)" t nil)

;;;***

;;;### (autoloads nil "compile" "progmodes/compile.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/compile.el

(defvar compilation-mode-hook nil "\
List of hook functions run by `compilation-mode'.")

(custom-autoload 'compilation-mode-hook "compile" t)

(defvar compilation-start-hook nil "\
Hook run after starting a new compilation process.
The hook is run with one argument, the new process.")

(custom-autoload 'compilation-start-hook "compile" t)

(defvar compilation-window-height nil "\
Number of lines in a compilation window.
If nil, use Emacs default.")

(custom-autoload 'compilation-window-height "compile" t)

(defvar compilation-process-setup-function nil "\
Function to call to customize the compilation process.
This function is called immediately before the compilation process is
started.  It can be used to set any variables or functions that are used
while processing the output of the compilation process.")

(defvar compilation-buffer-name-function nil "\
Function to compute the name of a compilation buffer.
The function receives one argument, the name of the major mode of the
compilation buffer.  It should return a string.
If nil, compute the name with `(concat \"*\" (downcase major-mode) \"*\")'.")

(defvar compilation-finish-function nil "\
Function to call when a compilation process finishes.
It is called with two arguments: the compilation buffer, and a string
describing how the process finished.")

(defvar compilation-finish-functions nil "\
Functions to call when a compilation process finishes.
Each function is called with two arguments: the compilation buffer,
and a string describing how the process finished.")
(put 'compilation-directory 'safe-local-variable 'stringp)

(defvar compilation-ask-about-save t "\
Non-nil means \\[compile] asks which buffers to save before compiling.
Otherwise, it saves all modified buffers without asking.")

(custom-autoload 'compilation-ask-about-save "compile" t)

(defvar compilation-search-path '(nil) "\
List of directories to search for source files named in error messages.
Elements should be directory names, not file names of directories.
The value nil as an element means to try the default directory.")

(custom-autoload 'compilation-search-path "compile" t)

(defvar compile-command (purecopy "make -k ") "\
Last shell command used to do a compilation; default for next compilation.

Sometimes it is useful for files to supply local values for this variable.
You might also use mode hooks to specify it in certain modes, like this:

    (add-hook 'c-mode-hook
       (lambda ()
	 (unless (or (file-exists-p \"makefile\")
		     (file-exists-p \"Makefile\"))
	   (set (make-local-variable 'compile-command)
		(concat \"make -k \"
			(if buffer-file-name
			  (shell-quote-argument
			    (file-name-sans-extension buffer-file-name))))))))")

(custom-autoload 'compile-command "compile" t)
(put 'compile-command 'safe-local-variable (lambda (a) (and (stringp a) (or (not (boundp 'compilation-read-command)) compilation-read-command))))

(defvar compilation-disable-input nil "\
If non-nil, send end-of-file as compilation process input.
This only affects platforms that support asynchronous processes (see
`start-process'); synchronous compilation processes never accept input.")

(custom-autoload 'compilation-disable-input "compile" t)

(autoload 'compile "compile" "\
Compile the program including the current buffer.  Default: run `make'.
Runs COMMAND, a shell command, in a separate process asynchronously
with output going to the buffer `*compilation*'.

You can then use the command \\[next-error] to find the next error message
and move to the source code that caused it.

If optional second arg COMINT is t the buffer will be in Comint mode with
`compilation-shell-minor-mode'.

Interactively, prompts for the command if the variable
`compilation-read-command' is non-nil; otherwise uses `compile-command'.
With prefix arg, always prompts.
Additionally, with universal prefix arg, compilation buffer will be in
comint mode, i.e. interactive.

To run more than one compilation at once, start one then rename
the `*compilation*' buffer to some other name with
\\[rename-buffer].  Then _switch buffers_ and start the new compilation.
It will create a new `*compilation*' buffer.

On most systems, termination of the main compilation process
kills its subprocesses.

The name used for the buffer is actually whatever is returned by
the function in `compilation-buffer-name-function', so you can set that
to a function that generates a unique name.

\(fn COMMAND &optional COMINT)" t nil)

(autoload 'compilation-start "compile" "\
Run compilation command COMMAND (low level interface).
If COMMAND starts with a cd command, that becomes the `default-directory'.
The rest of the arguments are optional; for them, nil means use the default.

MODE is the major mode to set in the compilation buffer.  Mode
may also be t meaning use `compilation-shell-minor-mode' under `comint-mode'.

If NAME-FUNCTION is non-nil, call it with one argument (the mode name)
to determine the buffer name.  Otherwise, the default is to
reuses the current buffer if it has the proper major mode,
else use or create a buffer with name based on the major mode.

If HIGHLIGHT-REGEXP is non-nil, `next-error' will temporarily highlight
the matching section of the visited source line; the default is to use the
global value of `compilation-highlight-regexp'.

Returns the compilation buffer created.

\(fn COMMAND &optional MODE NAME-FUNCTION HIGHLIGHT-REGEXP)" nil nil)

(autoload 'compilation-mode "compile" "\
Major mode for compilation log buffers.
\\<compilation-mode-map>To visit the source for a line-numbered error,
move point to the error message line and type \\[compile-goto-error].
To kill the compilation, type \\[kill-compilation].

Runs `compilation-mode-hook' with `run-mode-hooks' (which see).

\\{compilation-mode-map}

\(fn &optional NAME-OF-MODE)" t nil)

(put 'define-compilation-mode 'doc-string-elt 3)

(autoload 'compilation-shell-minor-mode "compile" "\
Toggle Compilation Shell minor mode.
With a prefix argument ARG, enable Compilation Shell minor mode
if ARG is positive, and disable it otherwise.  If called from
Lisp, enable the mode if ARG is omitted or nil.

When Compilation Shell minor mode is enabled, all the
error-parsing commands of the Compilation major mode are
available but bound to keys that don't collide with Shell mode.
See `compilation-mode'.

\(fn &optional ARG)" t nil)

(autoload 'compilation-minor-mode "compile" "\
Toggle Compilation minor mode.
With a prefix argument ARG, enable Compilation minor mode if ARG
is positive, and disable it otherwise.  If called from Lisp,
enable the mode if ARG is omitted or nil.

When Compilation minor mode is enabled, all the error-parsing
commands of Compilation major mode are available.  See
`compilation-mode'.

\(fn &optional ARG)" t nil)

(autoload 'compilation-next-error-function "compile" "\
Advance to the next error message and visit the file where the error was.
This is the value of `next-error-function' in Compilation buffers.

\(fn N &optional RESET)" t nil)

;;;***

;;;### (autoloads nil "completion" "completion.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from completion.el

(defvar dynamic-completion-mode nil "\
Non-nil if Dynamic-Completion mode is enabled.
See the command `dynamic-completion-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `dynamic-completion-mode'.")

(custom-autoload 'dynamic-completion-mode "completion" nil)

(autoload 'dynamic-completion-mode "completion" "\
Toggle dynamic word-completion on or off.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "conf-mode" "textmodes/conf-mode.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from textmodes/conf-mode.el

(autoload 'conf-mode "conf-mode" "\
Mode for Unix and Windows Conf files and Java properties.
Most conf files know only three kinds of constructs: parameter
assignments optionally grouped into sections and comments.  Yet
there is a great range of variation in the exact syntax of conf
files.  See below for various wrapper commands that set up the
details for some of the most widespread variants.

This mode sets up font locking, outline, imenu and it provides
alignment support through `conf-align-assignments'.  If strings
come out wrong, try `conf-quote-normal'.

Some files allow continuation lines, either with a backslash at
the end of line, or by indenting the next line (further).  These
constructs cannot currently be recognized.

Because of this great variety of nuances, which are often not
even clearly specified, please don't expect it to get every file
quite right.  Patches that clearly identify some special case,
without breaking the general ones, are welcome.

If instead you start this mode with the generic `conf-mode'
command, it will parse the buffer.  It will generally well
identify the first four cases listed below.  If the buffer
doesn't have enough contents to decide, this is identical to
`conf-windows-mode' on Windows, elsewhere to `conf-unix-mode'.
See also `conf-space-mode', `conf-colon-mode', `conf-javaprop-mode',
`conf-ppd-mode' and `conf-xdefaults-mode'.

\\{conf-mode-map}

\(fn)" t nil)

(autoload 'conf-unix-mode "conf-mode" "\
Conf Mode starter for Unix style Conf files.
Comments start with `#'.
For details see `conf-mode'.  Example:

# Conf mode font-locks this right on Unix and with \\[conf-unix-mode]

\[Desktop Entry]
	 Encoding=UTF-8
	 Name=The GIMP
	 Name[ca]=El GIMP
	 Name[cs]=GIMP

\(fn)" t nil)

(autoload 'conf-windows-mode "conf-mode" "\
Conf Mode starter for Windows style Conf files.
Comments start with `;'.
For details see `conf-mode'.  Example:

; Conf mode font-locks this right on Windows and with \\[conf-windows-mode]

\[ExtShellFolderViews]
Default={5984FFE0-28D4-11CF-AE66-08002B2E1262}
{5984FFE0-28D4-11CF-AE66-08002B2E1262}={5984FFE0-28D4-11CF-AE66-08002B2E1262}

\[{5984FFE0-28D4-11CF-AE66-08002B2E1262}]
PersistMoniker=file://Folder.htt

\(fn)" t nil)

(autoload 'conf-javaprop-mode "conf-mode" "\
Conf Mode starter for Java properties files.
Comments start with `#' but are also recognized with `//' or
between `/*' and `*/'.
For details see `conf-mode'.  Example:

# Conf mode font-locks this right with \\[conf-javaprop-mode] (Java properties)
// another kind of comment
/* yet another */

name:value
name=value
name value
x.1 =
x.2.y.1.z.1 =
x.2.y.1.z.2.zz =

\(fn)" t nil)

(autoload 'conf-space-mode "conf-mode" "\
Conf Mode starter for space separated conf files.
\"Assignments\" are with ` '.  Keywords before the parameters are
recognized according to the variable `conf-space-keywords-alist'.
Alternatively, you can specify a value for the file local variable
`conf-space-keywords'.
Use the function `conf-space-keywords' if you want to specify keywords
in an interactive fashion instead.

For details see `conf-mode'.  Example:

# Conf mode font-locks this right with \\[conf-space-mode] (space separated)

image/jpeg			jpeg jpg jpe
image/png			png
image/tiff			tiff tif

# Or with keywords (from a recognized file name):
class desktop
# Standard multimedia devices
add /dev/audio		desktop
add /dev/mixer		desktop

\(fn)" t nil)

(autoload 'conf-space-keywords "conf-mode" "\
Enter Conf Space mode using regexp KEYWORDS to match the keywords.
See `conf-space-mode'.

\(fn KEYWORDS)" t nil)

(autoload 'conf-colon-mode "conf-mode" "\
Conf Mode starter for Colon files.
\"Assignments\" are with `:'.
For details see `conf-mode'.  Example:

# Conf mode font-locks this right with \\[conf-colon-mode] (colon)

<Multi_key> <exclam> <exclam>		: \"\\241\"	exclamdown
<Multi_key> <c> <slash>			: \"\\242\"	cent

\(fn)" t nil)

(autoload 'conf-ppd-mode "conf-mode" "\
Conf Mode starter for Adobe/CUPS PPD files.
Comments start with `*%' and \"assignments\" are with `:'.
For details see `conf-mode'.  Example:

*% Conf mode font-locks this right with \\[conf-ppd-mode] (PPD)

*DefaultTransfer: Null
*Transfer Null.Inverse: \"{ 1 exch sub }\"

\(fn)" t nil)

(autoload 'conf-xdefaults-mode "conf-mode" "\
Conf Mode starter for Xdefaults files.
Comments start with `!' and \"assignments\" are with `:'.
For details see `conf-mode'.  Example:

! Conf mode font-locks this right with \\[conf-xdefaults-mode] (.Xdefaults)

*background:			gray99
*foreground:			black

\(fn)" t nil)

;;;***

;;;### (autoloads nil "cookie1" "play/cookie1.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from play/cookie1.el

(autoload 'cookie "cookie1" "\
Return a random phrase from PHRASE-FILE.
When the phrase file is read in, display STARTMSG at the beginning
of load, ENDMSG at the end.
Interactively, PHRASE-FILE defaults to `cookie-file', unless that
is nil or a prefix argument is used.

\(fn PHRASE-FILE &optional STARTMSG ENDMSG)" t nil)

(autoload 'cookie-insert "cookie1" "\
Insert random phrases from PHRASE-FILE; COUNT of them.
When the phrase file is read in, display STARTMSG at the beginning
of load, ENDMSG at the end.

\(fn PHRASE-FILE &optional COUNT STARTMSG ENDMSG)" nil nil)

(autoload 'cookie-snarf "cookie1" "\
Reads in the PHRASE-FILE, returns it as a vector of strings.
Emit STARTMSG and ENDMSG before and after.  Caches the result; second
and subsequent calls on the same file won't go to disk.

\(fn PHRASE-FILE &optional STARTMSG ENDMSG)" nil nil)

;;;***

;;;### (autoloads nil "copyright" "emacs-lisp/copyright.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from emacs-lisp/copyright.el
(put 'copyright-at-end-flag 'safe-local-variable 'booleanp)
(put 'copyright-names-regexp 'safe-local-variable 'stringp)
(put 'copyright-year-ranges 'safe-local-variable 'booleanp)

(autoload 'copyright-update "copyright" "\
Update copyright notice to indicate the current year.
With prefix ARG, replace the years in the notice rather than adding
the current year after them.  If necessary, and
`copyright-current-gpl-version' is set, any copying permissions
following the copyright are updated as well.
If non-nil, INTERACTIVEP tells the function to behave as when it's called
interactively.

\(fn &optional ARG INTERACTIVEP)" t nil)

(autoload 'copyright-fix-years "copyright" "\
Convert 2 digit years to 4 digit years.
Uses heuristic: year >= 50 means 19xx, < 50 means 20xx.
If `copyright-year-ranges' (which see) is non-nil, also
independently replaces consecutive years with a range.

\(fn)" t nil)

(autoload 'copyright "copyright" "\
Insert a copyright by $ORGANIZATION notice at cursor.

\(fn &optional STR ARG)" t nil)

(autoload 'copyright-update-directory "copyright" "\
Update copyright notice for all files in DIRECTORY matching MATCH.
If FIX is non-nil, run `copyright-fix-years' instead.

\(fn DIRECTORY MATCH &optional FIX)" t nil)

;;;***

;;;### (autoloads nil "cperl-mode" "progmodes/cperl-mode.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from progmodes/cperl-mode.el
(put 'cperl-indent-level 'safe-local-variable 'integerp)
(put 'cperl-brace-offset 'safe-local-variable 'integerp)
(put 'cperl-continued-brace-offset 'safe-local-variable 'integerp)
(put 'cperl-label-offset 'safe-local-variable 'integerp)
(put 'cperl-continued-statement-offset 'safe-local-variable 'integerp)
(put 'cperl-extra-newline-before-brace 'safe-local-variable 'booleanp)
(put 'cperl-merge-trailing-else 'safe-local-variable 'booleanp)

(autoload 'cperl-mode "cperl-mode" "\
Major mode for editing Perl code.
Expression and list commands understand all C brackets.
Tab indents for Perl code.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.

Various characters in Perl almost always come in pairs: {}, (), [],
sometimes <>.  When the user types the first, she gets the second as
well, with optional special formatting done on {}.  (Disabled by
default.)  You can always quote (with \\[quoted-insert]) the left
\"paren\" to avoid the expansion.  The processing of < is special,
since most the time you mean \"less\".  CPerl mode tries to guess
whether you want to type pair <>, and inserts is if it
appropriate.  You can set `cperl-electric-parens-string' to the string that
contains the parens from the above list you want to be electrical.
Electricity of parens is controlled by `cperl-electric-parens'.
You may also set `cperl-electric-parens-mark' to have electric parens
look for active mark and \"embrace\" a region if possible.'

CPerl mode provides expansion of the Perl control constructs:

   if, else, elsif, unless, while, until, continue, do,
   for, foreach, formy and foreachmy.

and POD directives (Disabled by default, see `cperl-electric-keywords'.)

The user types the keyword immediately followed by a space, which
causes the construct to be expanded, and the point is positioned where
she is most likely to want to be.  E.g., when the user types a space
following \"if\" the following appears in the buffer: if () { or if ()
} { } and the cursor is between the parentheses.  The user can then
type some boolean expression within the parens.  Having done that,
typing \\[cperl-linefeed] places you - appropriately indented - on a
new line between the braces (if you typed \\[cperl-linefeed] in a POD
directive line, then appropriate number of new lines is inserted).

If CPerl decides that you want to insert \"English\" style construct like

            bite if angry;

it will not do any expansion.  See also help on variable
`cperl-extra-newline-before-brace'.  (Note that one can switch the
help message on expansion by setting `cperl-message-electric-keyword'
to nil.)

\\[cperl-linefeed] is a convenience replacement for typing carriage
return.  It places you in the next line with proper indentation, or if
you type it inside the inline block of control construct, like

            foreach (@lines) {print; print}

and you are on a boundary of a statement inside braces, it will
transform the construct into a multiline and will place you into an
appropriately indented blank line.  If you need a usual
`newline-and-indent' behavior, it is on \\[newline-and-indent],
see documentation on `cperl-electric-linefeed'.

Use \\[cperl-invert-if-unless] to change a construction of the form

	    if (A) { B }

into

            B if A;

\\{cperl-mode-map}

Setting the variable `cperl-font-lock' to t switches on font-lock-mode
\(even with older Emacsen), `cperl-electric-lbrace-space' to t switches
on electric space between $ and {, `cperl-electric-parens-string' is
the string that contains parentheses that should be electric in CPerl
\(see also `cperl-electric-parens-mark' and `cperl-electric-parens'),
setting `cperl-electric-keywords' enables electric expansion of
control structures in CPerl.  `cperl-electric-linefeed' governs which
one of two linefeed behavior is preferable.  You can enable all these
options simultaneously (recommended mode of use) by setting
`cperl-hairy' to t.  In this case you can switch separate options off
by setting them to `null'.  Note that one may undo the extra
whitespace inserted by semis and braces in `auto-newline'-mode by
consequent \\[cperl-electric-backspace].

If your site has perl5 documentation in info format, you can use commands
\\[cperl-info-on-current-command] and \\[cperl-info-on-command] to access it.
These keys run commands `cperl-info-on-current-command' and
`cperl-info-on-command', which one is which is controlled by variable
`cperl-info-on-command-no-prompt' and `cperl-clobber-lisp-bindings'
\(in turn affected by `cperl-hairy').

Even if you have no info-format documentation, short one-liner-style
help is available on \\[cperl-get-help], and one can run perldoc or
man via menu.

It is possible to show this help automatically after some idle time.
This is regulated by variable `cperl-lazy-help-time'.  Default with
`cperl-hairy' (if the value of `cperl-lazy-help-time' is nil) is 5
secs idle time .  It is also possible to switch this on/off from the
menu, or via \\[cperl-toggle-autohelp].  Requires `run-with-idle-timer'.

Use \\[cperl-lineup] to vertically lineup some construction - put the
beginning of the region at the start of construction, and make region
span the needed amount of lines.

Variables `cperl-pod-here-scan', `cperl-pod-here-fontify',
`cperl-pod-face', `cperl-pod-head-face' control processing of POD and
here-docs sections.  With capable Emaxen results of scan are used
for indentation too, otherwise they are used for highlighting only.

Variables controlling indentation style:
 `cperl-tab-always-indent'
    Non-nil means TAB in CPerl mode should always reindent the current line,
    regardless of where in the line point is when the TAB command is used.
 `cperl-indent-left-aligned-comments'
    Non-nil means that the comment starting in leftmost column should indent.
 `cperl-auto-newline'
    Non-nil means automatically newline before and after braces,
    and after colons and semicolons, inserted in Perl code.  The following
    \\[cperl-electric-backspace] will remove the inserted whitespace.
    Insertion after colons requires both this variable and
    `cperl-auto-newline-after-colon' set.
 `cperl-auto-newline-after-colon'
    Non-nil means automatically newline even after colons.
    Subject to `cperl-auto-newline' setting.
 `cperl-indent-level'
    Indentation of Perl statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 `cperl-continued-statement-offset'
    Extra indentation given to a substatement, such as the
    then-clause of an if, or body of a while, or just a statement continuation.
 `cperl-continued-brace-offset'
    Extra indentation given to a brace that starts a substatement.
    This is in addition to `cperl-continued-statement-offset'.
 `cperl-brace-offset'
    Extra indentation for line if it starts with an open brace.
 `cperl-brace-imaginary-offset'
    An open brace following other text is treated as if it the line started
    this far to the right of the actual line indentation.
 `cperl-label-offset'
    Extra indentation for line that is a label.
 `cperl-min-label-indent'
    Minimal indentation for line that is a label.

Settings for classic indent-styles: K&R BSD=C++ GNU PerlStyle=Whitesmith
  `cperl-indent-level'                5   4       2   4
  `cperl-brace-offset'                0   0       0   0
  `cperl-continued-brace-offset'     -5  -4       0   0
  `cperl-label-offset'               -5  -4      -2  -4
  `cperl-continued-statement-offset'  5   4       2   4

CPerl knows several indentation styles, and may bulk set the
corresponding variables.  Use \\[cperl-set-style] to do this.  Use
\\[cperl-set-style-back] to restore the memorized preexisting values
\(both available from menu).  See examples in `cperl-style-examples'.

Part of the indentation style is how different parts of if/elsif/else
statements are broken into lines; in CPerl, this is reflected on how
templates for these constructs are created (controlled by
`cperl-extra-newline-before-brace'), and how reflow-logic should treat
\"continuation\" blocks of else/elsif/continue, controlled by the same
variable, and by `cperl-extra-newline-before-brace-multiline',
`cperl-merge-trailing-else', `cperl-indent-region-fix-constructs'.

If `cperl-indent-level' is 0, the statement after opening brace in
column 0 is indented on
`cperl-brace-offset'+`cperl-continued-statement-offset'.

Turning on CPerl mode calls the hooks in the variable `cperl-mode-hook'
with no args.

DO NOT FORGET to read micro-docs (available from `Perl' menu)
or as help on variables `cperl-tips', `cperl-problems',
`cperl-praise', `cperl-speed'.

\(fn)" t nil)

(autoload 'cperl-perldoc "cperl-mode" "\
Run `perldoc' on WORD.

\(fn WORD)" t nil)

(autoload 'cperl-perldoc-at-point "cperl-mode" "\
Run a `perldoc' on the word around point.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "cpp" "progmodes/cpp.el" (21710 25077 0 0))
;;; Generated autoloads from progmodes/cpp.el

(autoload 'cpp-highlight-buffer "cpp" "\
Highlight C code according to preprocessor conditionals.
This command pops up a buffer which you should edit to specify
what kind of highlighting to use, and the criteria for highlighting.
A prefix arg suppresses display of that buffer.

\(fn ARG)" t nil)

(autoload 'cpp-parse-edit "cpp" "\
Edit display information for cpp conditionals.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "crm" "emacs-lisp/crm.el" (21710 25077 0 0))
;;; Generated autoloads from emacs-lisp/crm.el

(autoload 'completing-read-multiple "crm" "\
Read multiple strings in the minibuffer, with completion.
The arguments are the same as those of `completing-read'.
\\<crm-local-completion-map>
Input multiple strings by separating each one with a string that
matches the regexp `crm-separator'.  For example, if the separator
regexp is \",\", entering \"alice,bob,eve\" specifies the strings
\"alice\", \"bob\", and \"eve\".

We refer to contiguous strings of non-separator-characters as
\"elements\".  In this example there are three elements.

Completion is available on a per-element basis.  For example, if the
contents of the minibuffer are \"alice,bob,eve\" and point is between
\"l\" and \"i\", pressing \\[minibuffer-complete] operates on the element \"alice\".

This function returns a list of the strings that were read,
with empty strings removed.

\(fn PROMPT TABLE &optional PREDICATE REQUIRE-MATCH INITIAL-INPUT HIST DEF INHERIT-INPUT-METHOD)" nil nil)

;;;***

;;;### (autoloads nil "css-mode" "textmodes/css-mode.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from textmodes/css-mode.el

(autoload 'css-mode "css-mode" "\
Major mode to edit Cascading Style Sheets.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "cua-base" "emulation/cua-base.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emulation/cua-base.el

(defvar cua-mode nil "\
Non-nil if Cua mode is enabled.
See the command `cua-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `cua-mode'.")

(custom-autoload 'cua-mode "cua-base" nil)

(autoload 'cua-mode "cua-base" "\
Toggle Common User Access style editing (CUA mode).
With a prefix argument ARG, enable CUA mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

CUA mode is a global minor mode.  When enabled, typed text
replaces the active selection, and you can use C-z, C-x, C-c, and
C-v to undo, cut, copy, and paste in addition to the normal Emacs
bindings.  The C-x and C-c keys only do cut and copy when the
region is active, so in most cases, they do not conflict with the
normal function of these prefix keys.

If you really need to perform a command which starts with one of
the prefix keys even when the region is active, you have three
options:
- press the prefix key twice very quickly (within 0.2 seconds),
- press the prefix key and the following key within 0.2 seconds, or
- use the SHIFT key with the prefix key, i.e. C-S-x or C-S-c.

You can customize `cua-enable-cua-keys' to completely disable the
CUA bindings, or `cua-prefix-override-inhibit-delay' to change
the prefix fallback behavior.

\(fn &optional ARG)" t nil)

(autoload 'cua-selection-mode "cua-base" "\
Enable CUA selection mode without the C-z/C-x/C-c/C-v bindings.

\(fn ARG)" t nil)

;;;***

;;;### (autoloads nil "cua-rect" "emulation/cua-rect.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from emulation/cua-rect.el

(autoload 'cua-rectangle-mark-mode "cua-rect" "\
Toggle the region as rectangular.
Activates the region if needed.  Only lasts until the region is deactivated.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "cus-edit" "cus-edit.el" (21788 61018 0 0))
;;; Generated autoloads from cus-edit.el

(defvar custom-browse-sort-alphabetically nil "\
If non-nil, sort customization group alphabetically in `custom-browse'.")

(custom-autoload 'custom-browse-sort-alphabetically "cus-edit" t)

(defvar custom-buffer-sort-alphabetically t "\
Whether to sort customization groups alphabetically in Custom buffer.")

(custom-autoload 'custom-buffer-sort-alphabetically "cus-edit" t)

(defvar custom-menu-sort-alphabetically nil "\
If non-nil, sort each customization group alphabetically in menus.")

(custom-autoload 'custom-menu-sort-alphabetically "cus-edit" t)

(autoload 'customize-set-value "cus-edit" "\
Set VARIABLE to VALUE, and return VALUE.  VALUE is a Lisp object.

If VARIABLE has a `variable-interactive' property, that is used as if
it were the arg to `interactive' (which see) to interactively read the value.

If VARIABLE has a `custom-type' property, it must be a widget and the
`:prompt-value' property of that widget will be used for reading the value.

If given a prefix (or a COMMENT argument), also prompt for a comment.

\(fn VARIABLE VALUE &optional COMMENT)" t nil)

(autoload 'customize-set-variable "cus-edit" "\
Set the default for VARIABLE to VALUE, and return VALUE.
VALUE is a Lisp object.

If VARIABLE has a `custom-set' property, that is used for setting
VARIABLE, otherwise `set-default' is used.

If VARIABLE has a `variable-interactive' property, that is used as if
it were the arg to `interactive' (which see) to interactively read the value.

If VARIABLE has a `custom-type' property, it must be a widget and the
`:prompt-value' property of that widget will be used for reading the value.

If given a prefix (or a COMMENT argument), also prompt for a comment.

\(fn VARIABLE VALUE &optional COMMENT)" t nil)

(autoload 'customize-save-variable "cus-edit" "\
Set the default for VARIABLE to VALUE, and save it for future sessions.
Return VALUE.

If VARIABLE has a `custom-set' property, that is used for setting
VARIABLE, otherwise `set-default' is used.

If VARIABLE has a `variable-interactive' property, that is used as if
it were the arg to `interactive' (which see) to interactively read the value.

If VARIABLE has a `custom-type' property, it must be a widget and the
`:prompt-value' property of that widget will be used for reading the value.

If given a prefix (or a COMMENT argument), also prompt for a comment.

\(fn VARIABLE VALUE &optional COMMENT)" t nil)

(autoload 'customize-push-and-save "cus-edit" "\
Add ELTS to LIST-VAR and save for future sessions, safely.
ELTS should be a list.  This function adds each entry to the
value of LIST-VAR using `add-to-list'.

If Emacs is initialized, call `customize-save-variable' to save
the resulting list value now.  Otherwise, add an entry to
`after-init-hook' to save it after initialization.

\(fn LIST-VAR ELTS)" nil nil)

(autoload 'customize "cus-edit" "\
Select a customization buffer which you can use to set user options.
User options are structured into \"groups\".
Initially the top-level group `Emacs' and its immediate subgroups
are shown; the contents of those subgroups are initially hidden.

\(fn)" t nil)

(autoload 'customize-mode "cus-edit" "\
Customize options related to the current major mode.
If a prefix \\[universal-argument] was given (or if the current major mode has no known group),
then prompt for the MODE to customize.

\(fn MODE)" t nil)

(autoload 'customize-group "cus-edit" "\
Customize GROUP, which must be a customization group.
If OTHER-WINDOW is non-nil, display in another window.

\(fn &optional GROUP OTHER-WINDOW)" t nil)

(autoload 'customize-group-other-window "cus-edit" "\
Customize GROUP, which must be a customization group, in another window.

\(fn &optional GROUP)" t nil)

(defalias 'customize-variable 'customize-option)

(autoload 'customize-option "cus-edit" "\
Customize SYMBOL, which must be a user option.

\(fn SYMBOL)" t nil)

(defalias 'customize-variable-other-window 'customize-option-other-window)

(autoload 'customize-option-other-window "cus-edit" "\
Customize SYMBOL, which must be a user option.
Show the buffer in another window, but don't select it.

\(fn SYMBOL)" t nil)

(defvar customize-package-emacs-version-alist nil "\
Alist mapping versions of a package to Emacs versions.
We use this for packages that have their own names, but are released
as part of Emacs itself.

Each elements looks like this:

     (PACKAGE (PVERSION . EVERSION)...)

Here PACKAGE is the name of a package, as a symbol.  After
PACKAGE come one or more elements, each associating a
package version PVERSION with the first Emacs version
EVERSION in which it (or a subsequent version of PACKAGE)
was first released.  Both PVERSION and EVERSION are strings.
PVERSION should be a string that this package used in
the :package-version keyword for `defcustom', `defgroup',
and `defface'.

For example, the MH-E package updates this alist as follows:

     (add-to-list 'customize-package-emacs-version-alist
                  '(MH-E (\"6.0\" . \"22.1\") (\"6.1\" . \"22.1\")
                         (\"7.0\" . \"22.1\") (\"7.1\" . \"22.1\")
                         (\"7.2\" . \"22.1\") (\"7.3\" . \"22.1\")
                         (\"7.4\" . \"22.1\") (\"8.0\" . \"22.1\")))

The value of PACKAGE needs to be unique and it needs to match the
PACKAGE value appearing in the :package-version keyword.  Since
the user might see the value in a error message, a good choice is
the official name of the package, such as MH-E or Gnus.")

(defalias 'customize-changed 'customize-changed-options)

(autoload 'customize-changed-options "cus-edit" "\
Customize all settings whose meanings have changed in Emacs itself.
This includes new user options and faces, and new customization
groups, as well as older options and faces whose meanings or
default values have changed since the previous major Emacs
release.

With argument SINCE-VERSION (a string), customize all settings
that were added or redefined since that version.

\(fn &optional SINCE-VERSION)" t nil)

(autoload 'customize-face "cus-edit" "\
Customize FACE, which should be a face name or nil.
If FACE is nil, customize all faces.  If FACE is actually a
face-alias, customize the face it is aliased to.

If OTHER-WINDOW is non-nil, display in another window.

Interactively, when point is on text which has a face specified,
suggest to customize that face, if it's customizable.

\(fn &optional FACE OTHER-WINDOW)" t nil)

(autoload 'customize-face-other-window "cus-edit" "\
Show customization buffer for face FACE in other window.
If FACE is actually a face-alias, customize the face it is aliased to.

Interactively, when point is on text which has a face specified,
suggest to customize that face, if it's customizable.

\(fn &optional FACE)" t nil)

(autoload 'customize-unsaved "cus-edit" "\
Customize all options and faces set in this session but not saved.

\(fn)" t nil)

(autoload 'customize-rogue "cus-edit" "\
Customize all user variables modified outside customize.

\(fn)" t nil)

(autoload 'customize-saved "cus-edit" "\
Customize all saved options and faces.

\(fn)" t nil)

(autoload 'customize-apropos "cus-edit" "\
Customize loaded options, faces and groups matching PATTERN.
PATTERN can be a word, a list of words (separated by spaces),
or a regexp (using some regexp special characters).  If it is a word,
search for matches for that word as a substring.  If it is a list of
words, search for matches for any two (or more) of those words.

If TYPE is `options', include only options.
If TYPE is `faces', include only faces.
If TYPE is `groups', include only groups.

\(fn PATTERN &optional TYPE)" t nil)

(autoload 'customize-apropos-options "cus-edit" "\
Customize all loaded customizable options matching REGEXP.

\(fn REGEXP &optional IGNORED)" t nil)

(autoload 'customize-apropos-faces "cus-edit" "\
Customize all loaded faces matching REGEXP.

\(fn REGEXP)" t nil)

(autoload 'customize-apropos-groups "cus-edit" "\
Customize all loaded groups matching REGEXP.

\(fn REGEXP)" t nil)

(autoload 'custom-buffer-create "cus-edit" "\
Create a buffer containing OPTIONS.
Optional NAME is the name of the buffer.
OPTIONS should be an alist of the form ((SYMBOL WIDGET)...), where
SYMBOL is a customization option, and WIDGET is a widget for editing
that option.
DESCRIPTION is unused.

\(fn OPTIONS &optional NAME DESCRIPTION)" nil nil)

(autoload 'custom-buffer-create-other-window "cus-edit" "\
Create a buffer containing OPTIONS, and display it in another window.
The result includes selecting that window.
Optional NAME is the name of the buffer.
OPTIONS should be an alist of the form ((SYMBOL WIDGET)...), where
SYMBOL is a customization option, and WIDGET is a widget for editing
that option.

\(fn OPTIONS &optional NAME DESCRIPTION)" nil nil)

(autoload 'customize-browse "cus-edit" "\
Create a tree browser for the customize hierarchy.

\(fn &optional GROUP)" t nil)

(defvar custom-file nil "\
File used for storing customization information.
The default is nil, which means to use your init file
as specified by `user-init-file'.  If the value is not nil,
it should be an absolute file name.

You can set this option through Custom, if you carefully read the
last paragraph below.  However, usually it is simpler to write
something like the following in your init file:

\(setq custom-file \"~/.emacs-custom.el\")
\(load custom-file)

Note that both lines are necessary: the first line tells Custom to
save all customizations in this file, but does not load it.

When you change this variable outside Custom, look in the
previous custom file (usually your init file) for the
forms `(custom-set-variables ...)'  and `(custom-set-faces ...)',
and copy them (whichever ones you find) to the new custom file.
This will preserve your existing customizations.

If you save this option using Custom, Custom will write all
currently saved customizations, including the new one for this
option itself, into the file you specify, overwriting any
`custom-set-variables' and `custom-set-faces' forms already
present in that file.  It will not delete any customizations from
the old custom file.  You should do that manually if that is what you
want.  You also have to put something like `(load \"CUSTOM-FILE\")
in your init file, where CUSTOM-FILE is the actual name of the
file.  Otherwise, Emacs will not load the file when it starts up,
and hence will not set `custom-file' to that file either.")

(custom-autoload 'custom-file "cus-edit" t)

(autoload 'custom-save-all "cus-edit" "\
Save all customizations in `custom-file'.

\(fn)" nil nil)

(autoload 'customize-save-customized "cus-edit" "\
Save all user options which have been set in this session.

\(fn)" t nil)

(autoload 'custom-menu-create "cus-edit" "\
Create menu for customization group SYMBOL.
The menu is in a format applicable to `easy-menu-define'.

\(fn SYMBOL)" nil nil)

(autoload 'customize-menu-create "cus-edit" "\
Return a customize menu for customization group SYMBOL.
If optional NAME is given, use that as the name of the menu.
Otherwise the menu will be named `Customize'.
The format is suitable for use with `easy-menu-define'.

\(fn SYMBOL &optional NAME)" nil nil)

;;;***

;;;### (autoloads nil "cus-theme" "cus-theme.el" (21710 25077 0 0))
;;; Generated autoloads from cus-theme.el

(autoload 'customize-create-theme "cus-theme" "\
Create or edit a custom theme.
THEME, if non-nil, should be an existing theme to edit.  If THEME
is `user', the resulting *Custom Theme* buffer also contains a
checkbox for removing the theme settings specified in the buffer
from the Custom save file.
BUFFER, if non-nil, should be a buffer to use; the default is
named *Custom Theme*.

\(fn &optional THEME BUFFER)" t nil)

(autoload 'custom-theme-visit-theme "cus-theme" "\
Set up a Custom buffer to edit custom theme THEME.

\(fn THEME)" t nil)

(autoload 'describe-theme "cus-theme" "\
Display a description of the Custom theme THEME (a symbol).

\(fn THEME)" t nil)

(autoload 'customize-themes "cus-theme" "\
Display a selectable list of Custom themes.
When called from Lisp, BUFFER should be the buffer to use; if
omitted, a buffer named *Custom Themes* is used.

\(fn &optional BUFFER)" t nil)

;;;***

;;;### (autoloads nil "cvs-status" "vc/cvs-status.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from vc/cvs-status.el

(autoload 'cvs-status-mode "cvs-status" "\
Mode used for cvs status output.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "cwarn" "progmodes/cwarn.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from progmodes/cwarn.el
(push (purecopy '(cwarn 1 3 1)) package--builtin-versions)

(autoload 'cwarn-mode "cwarn" "\
Minor mode that highlights suspicious C and C++ constructions.

Suspicious constructs are highlighted using `font-lock-warning-face'.

Note, in addition to enabling this minor mode, the major mode must
be included in the variable `cwarn-configuration'.  By default C and
C++ modes are included.

With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

(define-obsolete-function-alias 'turn-on-cwarn-mode 'cwarn-mode "24.1")

(defvar global-cwarn-mode nil "\
Non-nil if Global-Cwarn mode is enabled.
See the command `global-cwarn-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-cwarn-mode'.")

(custom-autoload 'global-cwarn-mode "cwarn" nil)

(autoload 'global-cwarn-mode "cwarn" "\
Toggle Cwarn mode in all buffers.
With prefix ARG, enable Global-Cwarn mode if ARG is positive;
otherwise, disable it.  If called from Lisp, enable the mode if
ARG is omitted or nil.

Cwarn mode is enabled in all buffers where
`turn-on-cwarn-mode-if-enabled' would do it.
See `cwarn-mode' for more information on Cwarn mode.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "cyril-util" "language/cyril-util.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from language/cyril-util.el

(autoload 'cyrillic-encode-koi8-r-char "cyril-util" "\
Return KOI8-R external character code of CHAR if appropriate.

\(fn CHAR)" nil nil)

(autoload 'cyrillic-encode-alternativnyj-char "cyril-util" "\
Return ALTERNATIVNYJ external character code of CHAR if appropriate.

\(fn CHAR)" nil nil)

(autoload 'standard-display-cyrillic-translit "cyril-util" "\
Display a cyrillic buffer using a transliteration.
For readability, the table is slightly
different from the one used for the input method `cyrillic-translit'.

The argument is a string which specifies which language you are using;
that affects the choice of transliterations slightly.
Possible values are listed in `cyrillic-language-alist'.
If the argument is t, we use the default cyrillic transliteration.
If the argument is nil, we return the display table to its standard state.

\(fn &optional CYRILLIC-LANGUAGE)" t nil)

;;;***

;;;### (autoloads nil "dabbrev" "dabbrev.el" (21710 25077 0 0))
;;; Generated autoloads from dabbrev.el
(put 'dabbrev-case-fold-search 'risky-local-variable t)
(put 'dabbrev-case-replace 'risky-local-variable t)
 (define-key esc-map "/" 'dabbrev-expand)
 (define-key esc-map [?\C-/] 'dabbrev-completion)

(autoload 'dabbrev-completion "dabbrev" "\
Completion on current word.
Like \\[dabbrev-expand] but finds all expansions in the current buffer
and presents suggestions for completion.

With a prefix argument ARG, it searches all buffers accepted by the
function pointed out by `dabbrev-friend-buffer-function' to find the
completions.

If the prefix argument is 16 (which comes from \\[universal-argument] \\[universal-argument]),
then it searches *all* buffers.

\(fn &optional ARG)" t nil)

(autoload 'dabbrev-expand "dabbrev" "\
Expand previous word \"dynamically\".

Expands to the most recent, preceding word for which this is a prefix.
If no suitable preceding word is found, words following point are
considered.  If still no suitable word is found, then look in the
buffers accepted by the function pointed out by variable
`dabbrev-friend-buffer-function'.

A positive prefix argument, N, says to take the Nth backward *distinct*
possibility.  A negative argument says search forward.

If the cursor has not moved from the end of the previous expansion and
no argument is given, replace the previously-made expansion
with the next possible expansion not yet tried.

The variable `dabbrev-backward-only' may be used to limit the
direction of search to backward if set non-nil.

See also `dabbrev-abbrev-char-regexp' and \\[dabbrev-completion].

\(fn ARG)" t nil)

;;;***

;;;### (autoloads nil "data-debug" "cedet/data-debug.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from cedet/data-debug.el

(autoload 'data-debug-new-buffer "data-debug" "\
Create a new data-debug buffer with NAME.

\(fn NAME)" nil nil)

;;;***

;;;### (autoloads nil "dbus" "net/dbus.el" (21788 61018 0 0))
;;; Generated autoloads from net/dbus.el

(autoload 'dbus-handle-event "dbus" "\
Handle events from the D-Bus.
EVENT is a D-Bus event, see `dbus-check-event'.  HANDLER, being
part of the event, is called with arguments ARGS.
If the HANDLER returns a `dbus-error', it is propagated as return message.

\(fn EVENT)" t nil)

;;;***

;;;### (autoloads nil "dcl-mode" "progmodes/dcl-mode.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/dcl-mode.el

(autoload 'dcl-mode "dcl-mode" "\
Major mode for editing DCL-files.

This mode indents command lines in blocks.  (A block is commands between
THEN-ELSE-ENDIF and between lines matching dcl-block-begin-regexp and
dcl-block-end-regexp.)

Labels are indented to a fixed position unless they begin or end a block.
Whole-line comments (matching dcl-comment-line-regexp) are not indented.
Data lines are not indented.

Key bindings:

\\{dcl-mode-map}
Commands not usually bound to keys:

\\[dcl-save-nondefault-options]		Save changed options
\\[dcl-save-all-options]		Save all options
\\[dcl-save-option]			Save any option
\\[dcl-save-mode]			Save buffer mode

Variables controlling indentation style and extra features:

 dcl-basic-offset
    Extra indentation within blocks.

 dcl-continuation-offset
    Extra indentation for continued lines.

 dcl-margin-offset
    Indentation for the first command line in a file or SUBROUTINE.

 dcl-margin-label-offset
    Indentation for a label.

 dcl-comment-line-regexp
    Lines matching this regexp will not be indented.

 dcl-block-begin-regexp
 dcl-block-end-regexp
    Regexps that match command lines that begin and end, respectively,
    a block of command lines that will be given extra indentation.
    Command lines between THEN-ELSE-ENDIF are always indented; these variables
    make it possible to define other places to indent.
    Set to nil to disable this feature.

 dcl-calc-command-indent-function
    Can be set to a function that customizes indentation for command lines.
    Two such functions are included in the package:
	dcl-calc-command-indent-multiple
	dcl-calc-command-indent-hang

 dcl-calc-cont-indent-function
    Can be set to a function that customizes indentation for continued lines.
    One such function is included in the package:
	dcl-calc-cont-indent-relative    (set by default)

 dcl-tab-always-indent
    If t, pressing TAB always indents the current line.
    If nil, pressing TAB indents the current line if point is at the left
    margin.

 dcl-electric-characters
    Non-nil causes lines to be indented at once when a label, ELSE or ENDIF is
    typed.

 dcl-electric-reindent-regexps
    Use this variable and function dcl-electric-character to customize
    which words trigger electric indentation.

 dcl-tempo-comma
 dcl-tempo-left-paren
 dcl-tempo-right-paren
    These variables control the look of expanded templates.

 dcl-imenu-generic-expression
    Default value for imenu-generic-expression.  The default includes
    SUBROUTINE labels in the main listing and sub-listings for
    other labels, CALL, GOTO and GOSUB statements.

 dcl-imenu-label-labels
 dcl-imenu-label-goto
 dcl-imenu-label-gosub
 dcl-imenu-label-call
    Change the text that is used as sub-listing labels in imenu.

Loading this package calls the value of the variable
`dcl-mode-load-hook' with no args, if that value is non-nil.
Turning on DCL mode calls the value of the variable `dcl-mode-hook'
with no args, if that value is non-nil.


The following example uses the default values for all variables:

$! This is a comment line that is not indented (it matches
$! dcl-comment-line-regexp)
$! Next follows the first command line.  It is indented dcl-margin-offset.
$       i = 1
$       ! Other comments are indented like command lines.
$       ! A margin label indented dcl-margin-label-offset:
$ label:
$       if i.eq.1
$       then
$           ! Lines between THEN-ELSE and ELSE-ENDIF are
$           ! indented dcl-basic-offset
$           loop1: ! This matches dcl-block-begin-regexp...
$               ! ...so this line is indented dcl-basic-offset
$               text = \"This \" + - ! is a continued line
                       \"lined up with the command line\"
$               type sys$input
Data lines are not indented at all.
$           endloop1: ! This matches dcl-block-end-regexp
$       endif
$


There is some minimal font-lock support (see vars
`dcl-font-lock-defaults' and `dcl-font-lock-keywords').

\(fn)" t nil)

;;;***

;;;### (autoloads nil "debug" "emacs-lisp/debug.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/debug.el

(setq debugger 'debug)

(autoload 'debug "debug" "\
Enter debugger.  \\<debugger-mode-map>`\\[debugger-continue]' returns from the debugger.
Arguments are mainly for use when this is called from the internals
of the evaluator.

You may call with no args, or you may pass nil as the first arg and
any other args you like.  In that case, the list of args after the
first will be printed into the backtrace buffer.

\(fn &rest ARGS)" t nil)

(autoload 'debug-on-entry "debug" "\
Request FUNCTION to invoke debugger each time it is called.

When called interactively, prompt for FUNCTION in the minibuffer.

This works by modifying the definition of FUNCTION.  If you tell the
debugger to continue, FUNCTION's execution proceeds.  If FUNCTION is a
normal function or a macro written in Lisp, you can also step through
its execution.  FUNCTION can also be a primitive that is not a special
form, in which case stepping is not possible.  Break-on-entry for
primitive functions only works when that function is called from Lisp.

Use \\[cancel-debug-on-entry] to cancel the effect of this command.
Redefining FUNCTION also cancels it.

\(fn FUNCTION)" t nil)

(autoload 'cancel-debug-on-entry "debug" "\
Undo effect of \\[debug-on-entry] on FUNCTION.
If FUNCTION is nil, cancel debug-on-entry for all functions.
When called interactively, prompt for FUNCTION in the minibuffer.
To specify a nil argument interactively, exit with an empty minibuffer.

\(fn &optional FUNCTION)" t nil)

;;;***

;;;### (autoloads nil "decipher" "play/decipher.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from play/decipher.el

(autoload 'decipher "decipher" "\
Format a buffer of ciphertext for cryptanalysis and enter Decipher mode.

\(fn)" t nil)

(autoload 'decipher-mode "decipher" "\
Major mode for decrypting monoalphabetic substitution ciphers.
Lower-case letters enter plaintext.
Upper-case letters are commands.

The buffer is made read-only so that normal Emacs commands cannot
modify it.

The most useful commands are:
\\<decipher-mode-map>
\\[decipher-digram-list]  Display a list of all digrams & their frequency
\\[decipher-frequency-count]  Display the frequency of each ciphertext letter
\\[decipher-adjacency-list]  Show adjacency list for current letter (lists letters appearing next to it)
\\[decipher-make-checkpoint]  Save the current cipher alphabet (checkpoint)
\\[decipher-restore-checkpoint]  Restore a saved cipher alphabet (checkpoint)

\(fn)" t nil)

;;;***

;;;### (autoloads nil "delim-col" "delim-col.el" (21710 25077 0 0))
;;; Generated autoloads from delim-col.el
(push (purecopy '(delim-col 2 1)) package--builtin-versions)

(autoload 'delimit-columns-customize "delim-col" "\
Customization of `columns' group.

\(fn)" t nil)

(autoload 'delimit-columns-region "delim-col" "\
Prettify all columns in a text region.

START and END delimits the text region.

\(fn START END)" t nil)

(autoload 'delimit-columns-rectangle "delim-col" "\
Prettify all columns in a text rectangle.

START and END delimits the corners of text rectangle.

\(fn START END)" t nil)

;;;***

;;;### (autoloads nil "delsel" "delsel.el" (21788 61018 0 0))
;;; Generated autoloads from delsel.el

(defalias 'pending-delete-mode 'delete-selection-mode)

(defvar delete-selection-mode nil "\
Non-nil if Delete-Selection mode is enabled.
See the command `delete-selection-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `delete-selection-mode'.")

(custom-autoload 'delete-selection-mode "delsel" nil)

(autoload 'delete-selection-mode "delsel" "\
Toggle Delete Selection mode.
With a prefix argument ARG, enable Delete Selection mode if ARG
is positive, and disable it otherwise.  If called from Lisp,
enable the mode if ARG is omitted or nil.

When Delete Selection mode is enabled, typed text replaces the selection
if the selection is active.  Otherwise, typed text is just inserted at
point regardless of any selection.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "derived" "emacs-lisp/derived.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/derived.el

(autoload 'define-derived-mode "derived" "\
Create a new mode as a variant of an existing mode.

The arguments to this command are as follow:

CHILD:     the name of the command for the derived mode.
PARENT:    the name of the command for the parent mode (e.g. `text-mode')
           or nil if there is no parent.
NAME:      a string which will appear in the status line (e.g. \"Hypertext\")
DOCSTRING: an optional documentation string--if you do not supply one,
           the function will attempt to invent something useful.
BODY:      forms to execute just before running the
           hooks for the new mode.  Do not use `interactive' here.

BODY can start with a bunch of keyword arguments.  The following keyword
  arguments are currently understood:
:group GROUP
	Declare the customization group that corresponds to this mode.
	The command `customize-mode' uses this.
:syntax-table TABLE
	Use TABLE instead of the default (CHILD-syntax-table).
	A nil value means to simply use the same syntax-table as the parent.
:abbrev-table TABLE
	Use TABLE instead of the default (CHILD-abbrev-table).
	A nil value means to simply use the same abbrev-table as the parent.

Here is how you could define LaTeX-Thesis mode as a variant of LaTeX mode:

  (define-derived-mode LaTeX-thesis-mode LaTeX-mode \"LaTeX-Thesis\")

You could then make new key bindings for `LaTeX-thesis-mode-map'
without changing regular LaTeX mode.  In this example, BODY is empty,
and DOCSTRING is generated by default.

On a more complicated level, the following command uses `sgml-mode' as
the parent, and then sets the variable `case-fold-search' to nil:

  (define-derived-mode article-mode sgml-mode \"Article\"
    \"Major mode for editing technical articles.\"
    (setq case-fold-search nil))

Note that if the documentation string had been left out, it would have
been generated automatically, with a reference to the keymap.

The new mode runs the hook constructed by the function
`derived-mode-hook-name'.

See Info node `(elisp)Derived Modes' for more details.

\(fn CHILD PARENT NAME &optional DOCSTRING &rest BODY)" nil t)

(put 'define-derived-mode 'doc-string-elt '4)

(autoload 'derived-mode-init-mode-variables "derived" "\
Initialize variables for a new MODE.
Right now, if they don't already exist, set up a blank keymap, an
empty syntax table, and an empty abbrev table -- these will be merged
the first time the mode is used.

\(fn MODE)" nil nil)

;;;***

;;;### (autoloads nil "descr-text" "descr-text.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from descr-text.el

(autoload 'describe-text-properties "descr-text" "\
Describe widgets, buttons, overlays, and text properties at POS.
POS is taken to be in BUFFER or in current buffer if nil.
Interactively, describe them for the character after point.
If optional second argument OUTPUT-BUFFER is non-nil,
insert the output into that buffer, and don't initialize or clear it
otherwise.

\(fn POS &optional OUTPUT-BUFFER BUFFER)" t nil)

(autoload 'describe-char "descr-text" "\
Describe position POS (interactively, point) and the char after POS.
POS is taken to be in BUFFER, or the current buffer if BUFFER is nil.
The information is displayed in buffer `*Help*'.

The position information includes POS; the total size of BUFFER; the
region limits, if narrowed; the column number; and the horizontal
scroll amount, if the buffer is horizontally scrolled.

The character information includes the character code; charset and
code points in it; syntax; category; how the character is encoded in
BUFFER and in BUFFER's file; character composition information (if
relevant); the font and font glyphs used to display the character;
the character's canonical name and other properties defined by the
Unicode Data Base; and widgets, buttons, overlays, and text properties
relevant to POS.

\(fn POS &optional BUFFER)" t nil)

;;;***

;;;### (autoloads nil "desktop" "desktop.el" (21788 61018 0 0))
;;; Generated autoloads from desktop.el

(defvar desktop-save-mode nil "\
Non-nil if Desktop-Save mode is enabled.
See the command `desktop-save-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `desktop-save-mode'.")

(custom-autoload 'desktop-save-mode "desktop" nil)

(autoload 'desktop-save-mode "desktop" "\
Toggle desktop saving (Desktop Save mode).
With a prefix argument ARG, enable Desktop Save mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode if ARG
is omitted or nil.

When Desktop Save mode is enabled, the state of Emacs is saved from
one session to another.  In particular, Emacs will save the desktop when
it exits (this may prompt you; see the option `desktop-save').  The next
time Emacs starts, if this mode is active it will restore the desktop.

To manually save the desktop at any time, use the command `M-x desktop-save'.
To load it, use `M-x desktop-read'.

Once a desktop file exists, Emacs will auto-save it according to the
option `desktop-auto-save-timeout'.

To see all the options you can set, browse the `desktop' customization group.

For further details, see info node `(emacs)Saving Emacs Sessions'.

\(fn &optional ARG)" t nil)

(defvar desktop-locals-to-save '(desktop-locals-to-save truncate-lines case-fold-search case-replace fill-column overwrite-mode change-log-default-name line-number-mode column-number-mode size-indication-mode buffer-file-coding-system indent-tabs-mode tab-width indicate-buffer-boundaries indicate-empty-lines show-trailing-whitespace) "\
List of local variables to save for each buffer.
The variables are saved only when they really are local.  Conventional minor
modes are restored automatically; they should not be listed here.")

(custom-autoload 'desktop-locals-to-save "desktop" t)

(defvar-local desktop-save-buffer nil "\
When non-nil, save buffer status in desktop file.

If the value is a function, it is called by `desktop-save' with argument
DESKTOP-DIRNAME to obtain auxiliary information to save in the desktop
file along with the state of the buffer for which it was called.

When file names are returned, they should be formatted using the call
\"(desktop-file-name FILE-NAME DESKTOP-DIRNAME)\".

Later, when `desktop-read' evaluates the desktop file, auxiliary information
is passed as the argument DESKTOP-BUFFER-MISC to functions in
`desktop-buffer-mode-handlers'.")

(defvar desktop-buffer-mode-handlers nil "\
Alist of major mode specific functions to restore a desktop buffer.
Functions listed are called by `desktop-create-buffer' when `desktop-read'
evaluates the desktop file.  List elements must have the form

   (MAJOR-MODE . RESTORE-BUFFER-FUNCTION).

Buffers with a major mode not specified here, are restored by the default
handler `desktop-restore-file-buffer'.

Handlers are called with argument list

   (DESKTOP-BUFFER-FILE-NAME DESKTOP-BUFFER-NAME DESKTOP-BUFFER-MISC)

Furthermore, they may use the following variables:

   `desktop-file-version'
   `desktop-buffer-major-mode'
   `desktop-buffer-minor-modes'
   `desktop-buffer-point'
   `desktop-buffer-mark'
   `desktop-buffer-read-only'
   `desktop-buffer-locals'

If a handler returns a buffer, then the saved mode settings
and variable values for that buffer are copied into it.

Modules that define a major mode that needs a special handler should contain
code like

   (defun foo-restore-desktop-buffer
   ...
   (add-to-list 'desktop-buffer-mode-handlers
                '(foo-mode . foo-restore-desktop-buffer))

Furthermore the major mode function must be autoloaded.")

(put 'desktop-buffer-mode-handlers 'risky-local-variable t)

(defvar desktop-minor-mode-handlers nil "\
Alist of functions to restore non-standard minor modes.
Functions are called by `desktop-create-buffer' to restore minor modes.
List elements must have the form

   (MINOR-MODE . RESTORE-FUNCTION).

Minor modes not specified here, are restored by the standard minor mode
function.

Handlers are called with argument list

   (DESKTOP-BUFFER-LOCALS)

Furthermore, they may use the following variables:

   `desktop-file-version'
   `desktop-buffer-file-name'
   `desktop-buffer-name'
   `desktop-buffer-major-mode'
   `desktop-buffer-minor-modes'
   `desktop-buffer-point'
   `desktop-buffer-mark'
   `desktop-buffer-read-only'
   `desktop-buffer-misc'

When a handler is called, the buffer has been created and the major mode has
been set, but local variables listed in desktop-buffer-locals has not yet been
created and set.

Modules that define a minor mode that needs a special handler should contain
code like

   (defun foo-desktop-restore
   ...
   (add-to-list 'desktop-minor-mode-handlers
                '(foo-mode . foo-desktop-restore))

Furthermore the minor mode function must be autoloaded.

See also `desktop-minor-mode-table'.")

(put 'desktop-minor-mode-handlers 'risky-local-variable t)

(autoload 'desktop-clear "desktop" "\
Empty the Desktop.
This kills all buffers except for internal ones and those with names matched by
a regular expression in the list `desktop-clear-preserve-buffers'.
Furthermore, it clears the variables listed in `desktop-globals-to-clear'.
When called interactively and `desktop-restore-frames' is non-nil, it also
deletes all frames except the selected one (and its minibuffer frame,
if different).

\(fn)" t nil)

(autoload 'desktop-save "desktop" "\
Save the desktop in a desktop file.
Parameter DIRNAME specifies where to save the desktop file.
Optional parameter RELEASE says whether we're done with this desktop.
If ONLY-IF-CHANGED is non-nil, compare the current desktop information
to that in the desktop file, and if the desktop information has not
changed since it was last saved then do not rewrite the file.

\(fn DIRNAME &optional RELEASE ONLY-IF-CHANGED)" t nil)

(autoload 'desktop-remove "desktop" "\
Delete desktop file in `desktop-dirname'.
This function also sets `desktop-dirname' to nil.

\(fn)" t nil)

(autoload 'desktop-read "desktop" "\
Read and process the desktop file in directory DIRNAME.
Look for a desktop file in DIRNAME, or if DIRNAME is omitted, look in
directories listed in `desktop-path'.  If a desktop file is found, it
is processed and `desktop-after-read-hook' is run.  If no desktop file
is found, clear the desktop and run `desktop-no-desktop-file-hook'.
This function is a no-op when Emacs is running in batch mode.
It returns t if a desktop file was loaded, nil otherwise.

\(fn &optional DIRNAME)" t nil)

(autoload 'desktop-load-default "desktop" "\
Load the `default' start-up library manually.
Also inhibit further loading of it.

\(fn)" nil nil)

(make-obsolete 'desktop-load-default 'desktop-save-mode '"22.1")

(autoload 'desktop-change-dir "desktop" "\
Change to desktop saved in DIRNAME.
Kill the desktop as specified by variables `desktop-save-mode' and
`desktop-save', then clear the desktop and load the desktop file in
directory DIRNAME.

\(fn DIRNAME)" t nil)

(autoload 'desktop-save-in-desktop-dir "desktop" "\
Save the desktop in directory `desktop-dirname'.

\(fn)" t nil)

(autoload 'desktop-revert "desktop" "\
Revert to the last loaded desktop.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "deuglify" "gnus/deuglify.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/deuglify.el

(autoload 'gnus-article-outlook-unwrap-lines "deuglify" "\
Unwrap lines that appear to be wrapped citation lines.
You can control what lines will be unwrapped by frobbing
`gnus-outlook-deuglify-unwrap-min' and `gnus-outlook-deuglify-unwrap-max',
indicating the minimum and maximum length of an unwrapped citation line.  If
NODISPLAY is non-nil, don't redisplay the article buffer.

\(fn &optional NODISPLAY)" t nil)

(autoload 'gnus-article-outlook-repair-attribution "deuglify" "\
Repair a broken attribution line.
If NODISPLAY is non-nil, don't redisplay the article buffer.

\(fn &optional NODISPLAY)" t nil)

(autoload 'gnus-outlook-deuglify-article "deuglify" "\
Full deuglify of broken Outlook (Express) articles.
Treat dumbquotes, unwrap lines, repair attribution and rearrange citation.  If
NODISPLAY is non-nil, don't redisplay the article buffer.

\(fn &optional NODISPLAY)" t nil)

(autoload 'gnus-article-outlook-deuglify-article "deuglify" "\
Deuglify broken Outlook (Express) articles and redisplay.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "diary-lib" "calendar/diary-lib.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from calendar/diary-lib.el

(autoload 'diary "diary-lib" "\
Generate the diary window for ARG days starting with the current date.
If no argument is provided, the number of days of diary entries is governed
by the variable `diary-number-of-entries'.  A value of ARG less than 1
does nothing.  This function is suitable for execution in an init file.

\(fn &optional ARG)" t nil)

(autoload 'diary-mail-entries "diary-lib" "\
Send a mail message showing diary entries for next NDAYS days.
If no prefix argument is given, NDAYS is set to `diary-mail-days'.
Mail is sent to the address specified by `diary-mail-addr'.

Here is an example of a script to call `diary-mail-entries',
suitable for regular scheduling using cron (or at).  Note that
since `emacs -script' does not load your init file, you should
ensure that all relevant variables are set.

#!/usr/bin/emacs -script
;; diary-rem.el - run the Emacs diary-reminder

\(setq diary-mail-days 3
      diary-file \"/path/to/diary.file\"
      calendar-date-style 'european
      diary-mail-addr \"user@host.name\")

\(diary-mail-entries)

# diary-rem.el ends here

\(fn &optional NDAYS)" t nil)

(autoload 'diary-mode "diary-lib" "\
Major mode for editing the diary file.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "diff" "vc/diff.el" (21710 25077 0 0))
;;; Generated autoloads from vc/diff.el

(defvar diff-switches (purecopy "-c") "\
A string or list of strings specifying switches to be passed to diff.")

(custom-autoload 'diff-switches "diff" t)

(defvar diff-command (purecopy "diff") "\
The command to use to run diff.")

(custom-autoload 'diff-command "diff" t)

(autoload 'diff "diff" "\
Find and display the differences between OLD and NEW files.
When called interactively, read NEW, then OLD, using the
minibuffer.  The default for NEW is the current buffer's file
name, and the default for OLD is a backup file for NEW, if one
exists.  If NO-ASYNC is non-nil, call diff synchronously.

When called interactively with a prefix argument, prompt
interactively for diff switches.  Otherwise, the switches
specified in the variable `diff-switches' are passed to the diff command.

\(fn OLD NEW &optional SWITCHES NO-ASYNC)" t nil)

(autoload 'diff-backup "diff" "\
Diff this file with its backup file or vice versa.
Uses the latest backup, if there are several numerical backups.
If this file is a backup, diff it with its original.
The backup file is the first file given to `diff'.
With prefix arg, prompt for diff switches.

\(fn FILE &optional SWITCHES)" t nil)

(autoload 'diff-latest-backup-file "diff" "\
Return the latest existing backup of FILE, or nil.

\(fn FN)" nil nil)

(autoload 'diff-buffer-with-file "diff" "\
View the differences between BUFFER and its associated file.
This requires the external program `diff' to be in your `exec-path'.

\(fn &optional BUFFER)" t nil)

;;;***

;;;### (autoloads nil "diff-mode" "vc/diff-mode.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from vc/diff-mode.el

(autoload 'diff-mode "diff-mode" "\
Major mode for viewing/editing context diffs.
Supports unified and context diffs as well as (to a lesser extent)
normal diffs.

When the buffer is read-only, the ESC prefix is not necessary.
If you edit the buffer manually, diff-mode will try to update the hunk
headers for you on-the-fly.

You can also switch between context diff and unified diff with \\[diff-context->unified],
or vice versa with \\[diff-unified->context] and you can also reverse the direction of
a diff with \\[diff-reverse-direction].

   \\{diff-mode-map}

\(fn)" t nil)

(autoload 'diff-minor-mode "diff-mode" "\
Toggle Diff minor mode.
With a prefix argument ARG, enable Diff minor mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

\\{diff-minor-mode-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "dig" "net/dig.el" (21710 25077 0 0))
;;; Generated autoloads from net/dig.el

(autoload 'dig "dig" "\
Query addresses of a DOMAIN using dig, by calling `dig-invoke'.
Optional arguments are passed to `dig-invoke'.

\(fn DOMAIN &optional QUERY-TYPE QUERY-CLASS QUERY-OPTION DIG-OPTION SERVER)" t nil)

;;;***

;;;### (autoloads nil "dired" "dired.el" (21788 61018 0 0))
;;; Generated autoloads from dired.el

(defvar dired-listing-switches (purecopy "-al") "\
Switches passed to `ls' for Dired.  MUST contain the `l' option.
May contain all other options that don't contradict `-l';
may contain even `F', `b', `i' and `s'.  See also the variable
`dired-ls-F-marks-symlinks' concerning the `F' switch.
On systems such as MS-DOS and MS-Windows, which use `ls' emulation in Lisp,
some of the `ls' switches are not supported; see the doc string of
`insert-directory' in `ls-lisp.el' for more details.")

(custom-autoload 'dired-listing-switches "dired" t)

(defvar dired-directory nil "\
The directory name or wildcard spec that this Dired directory lists.
Local to each Dired buffer.  May be a list, in which case the car is the
directory name and the cdr is the list of files to mention.
The directory name must be absolute, but need not be fully expanded.")
 (define-key ctl-x-map "d" 'dired)

(autoload 'dired "dired" "\
\"Edit\" directory DIRNAME--delete, rename, print, etc. some files in it.
Optional second argument SWITCHES specifies the `ls' options used.
\(Interactively, use a prefix argument to be able to specify SWITCHES.)
Dired displays a list of files in DIRNAME (which may also have
shell wildcards appended to select certain files).  If DIRNAME is a cons,
its first element is taken as the directory name and the rest as an explicit
list of files to make directory entries for.
\\<dired-mode-map>You can flag files for deletion with \\[dired-flag-file-deletion] and then
delete them by typing \\[dired-do-flagged-delete].
Type \\[describe-mode] after entering Dired for more info.

If DIRNAME is already in a Dired buffer, that buffer is used without refresh.

\(fn DIRNAME &optional SWITCHES)" t nil)
 (define-key ctl-x-4-map "d" 'dired-other-window)

(autoload 'dired-other-window "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but selects in another window.

\(fn DIRNAME &optional SWITCHES)" t nil)
 (define-key ctl-x-5-map "d" 'dired-other-frame)

(autoload 'dired-other-frame "dired" "\
\"Edit\" directory DIRNAME.  Like `dired' but makes a new frame.

\(fn DIRNAME &optional SWITCHES)" t nil)

(autoload 'dired-noselect "dired" "\
Like `dired' but returns the Dired buffer as value, does not select it.

\(fn DIR-OR-LIST &optional SWITCHES)" nil nil)

(autoload 'dired-mode "dired" "\
Mode for \"editing\" directory listings.
In Dired, you are \"editing\" a list of the files in a directory and
  (optionally) its subdirectories, in the format of `ls -lR'.
  Each directory is a page: use \\[backward-page] and \\[forward-page] to move pagewise.
\"Editing\" means that you can run shell commands on files, visit,
  compress, load or byte-compile them, change their file attributes
  and insert subdirectories into the same buffer.  You can \"mark\"
  files for later commands or \"flag\" them for deletion, either file
  by file or all files matching certain criteria.
You can move using the usual cursor motion commands.\\<dired-mode-map>
The buffer is read-only.  Digits are prefix arguments.
Type \\[dired-flag-file-deletion] to flag a file `D' for deletion.
Type \\[dired-mark] to Mark a file or subdirectory for later commands.
  Most commands operate on the marked files and use the current file
  if no files are marked.  Use a numeric prefix argument to operate on
  the next ARG (or previous -ARG if ARG<0) files, or just `1'
  to operate on the current file only.  Prefix arguments override marks.
  Mark-using commands display a list of failures afterwards.  Type \\[dired-summary]
  to see why something went wrong.
Type \\[dired-unmark] to Unmark a file or all files of an inserted subdirectory.
Type \\[dired-unmark-backward] to back up one line and unmark or unflag.
Type \\[dired-do-flagged-delete] to delete (eXecute) the files flagged `D'.
Type \\[dired-find-file] to Find the current line's file
  (or dired it in another buffer, if it is a directory).
Type \\[dired-find-file-other-window] to find file or Dired directory in Other window.
Type \\[dired-maybe-insert-subdir] to Insert a subdirectory in this buffer.
Type \\[dired-do-rename] to Rename a file or move the marked files to another directory.
Type \\[dired-do-copy] to Copy files.
Type \\[dired-sort-toggle-or-edit] to toggle Sorting by name/date or change the `ls' switches.
Type \\[revert-buffer] to read all currently expanded directories aGain.
  This retains all marks and hides subdirs again that were hidden before.
Use `SPC' and `DEL' to move down and up by lines.

If Dired ever gets confused, you can either type \\[revert-buffer] to read the
directories again, type \\[dired-do-redisplay] to relist the file at point or the marked files or a
subdirectory, or type \\[dired-build-subdir-alist] to parse the buffer
again for the directory tree.

Customization variables (rename this buffer and type \\[describe-variable] on each line
for more info):

  `dired-listing-switches'
  `dired-trivial-filenames'
  `dired-marker-char'
  `dired-del-marker'
  `dired-keep-marker-rename'
  `dired-keep-marker-copy'
  `dired-keep-marker-hardlink'
  `dired-keep-marker-symlink'

Hooks (use \\[describe-variable] to see their documentation):

  `dired-before-readin-hook'
  `dired-after-readin-hook'
  `dired-mode-hook'
  `dired-load-hook'

Keybindings:
\\{dired-mode-map}

\(fn &optional DIRNAME SWITCHES)" nil nil)
 (put 'dired-find-alternate-file 'disabled t)

;;;***

;;;### (autoloads nil "dirtrack" "dirtrack.el" (21710 25077 0 0))
;;; Generated autoloads from dirtrack.el

(autoload 'dirtrack-mode "dirtrack" "\
Toggle directory tracking in shell buffers (Dirtrack mode).
With a prefix argument ARG, enable Dirtrack mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

This method requires that your shell prompt contain the current
working directory at all times, and that you set the variable
`dirtrack-list' to match the prompt.

This is an alternative to `shell-dirtrack-mode', which works by
tracking `cd' and similar commands which change the shell working
directory.

\(fn &optional ARG)" t nil)

(autoload 'dirtrack "dirtrack" "\
Determine the current directory from the process output for a prompt.
This filter function is used by `dirtrack-mode'.  It looks for
the prompt specified by `dirtrack-list', and calls
`shell-process-cd' if the directory seems to have changed away
from `default-directory'.

\(fn INPUT)" nil nil)

;;;***

;;;### (autoloads nil "disass" "emacs-lisp/disass.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/disass.el

(autoload 'disassemble "disass" "\
Print disassembled code for OBJECT in (optional) BUFFER.
OBJECT can be a symbol defined as a function, or a function itself
\(a lambda expression or a compiled-function object).
If OBJECT is not already compiled, we compile it, but do not
redefine OBJECT if it is a symbol.

\(fn OBJECT &optional BUFFER INDENT INTERACTIVE-P)" t nil)

;;;***

;;;### (autoloads nil "disp-table" "disp-table.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from disp-table.el

(autoload 'make-display-table "disp-table" "\
Return a new, empty display table.

\(fn)" nil nil)

(autoload 'display-table-slot "disp-table" "\
Return the value of the extra slot in DISPLAY-TABLE named SLOT.
SLOT may be a number from 0 to 5 inclusive, or a slot name (symbol).
Valid symbols are `truncation', `wrap', `escape', `control',
`selective-display', and `vertical-border'.

\(fn DISPLAY-TABLE SLOT)" nil nil)

(autoload 'set-display-table-slot "disp-table" "\
Set the value of the extra slot in DISPLAY-TABLE named SLOT to VALUE.
SLOT may be a number from 0 to 5 inclusive, or a name (symbol).
Valid symbols are `truncation', `wrap', `escape', `control',
`selective-display', and `vertical-border'.

\(fn DISPLAY-TABLE SLOT VALUE)" nil nil)

(autoload 'describe-display-table "disp-table" "\
Describe the display table DT in a help buffer.

\(fn DT)" nil nil)

(autoload 'describe-current-display-table "disp-table" "\
Describe the display table in use in the selected window and buffer.

\(fn)" t nil)

(autoload 'standard-display-8bit "disp-table" "\
Display characters representing raw bytes in the range L to H literally.

On a terminal display, each character in the range is displayed
by sending the corresponding byte directly to the terminal.

On a graphic display, each character in the range is displayed
using the default font by a glyph whose code is the corresponding
byte.

Note that ASCII printable characters (SPC to TILDA) are displayed
in the default way after this call.

\(fn L H)" nil nil)

(autoload 'standard-display-default "disp-table" "\
Display characters in the range L to H using the default notation.

\(fn L H)" nil nil)

(autoload 'standard-display-ascii "disp-table" "\
Display character C using printable string S.

\(fn C S)" nil nil)

(autoload 'standard-display-g1 "disp-table" "\
Display character C as character SC in the g1 character set.
This function assumes that your terminal uses the SO/SI characters;
it is meaningless for an X frame.

\(fn C SC)" nil nil)

(autoload 'standard-display-graphic "disp-table" "\
Display character C as character GC in graphics character set.
This function assumes VT100-compatible escapes; it is meaningless for an
X frame.

\(fn C GC)" nil nil)

(autoload 'standard-display-underline "disp-table" "\
Display character C as character UC plus underlining.

\(fn C UC)" nil nil)

(autoload 'create-glyph "disp-table" "\
Allocate a glyph code to display by sending STRING to the terminal.

\(fn STRING)" nil nil)

(autoload 'make-glyph-code "disp-table" "\
Return a glyph code representing char CHAR with face FACE.

\(fn CHAR &optional FACE)" nil nil)

(autoload 'glyph-char "disp-table" "\
Return the character of glyph code GLYPH.

\(fn GLYPH)" nil nil)

(autoload 'glyph-face "disp-table" "\
Return the face of glyph code GLYPH, or nil if glyph has default face.

\(fn GLYPH)" nil nil)

(autoload 'standard-display-european "disp-table" "\
Semi-obsolete way to toggle display of ISO 8859 European characters.

This function is semi-obsolete; you probably don't need it, or else you
probably should use `set-language-environment' or `set-locale-environment'.

This function enables European character display if ARG is positive,
disables it if negative.  Otherwise, it toggles European character display.

When this mode is enabled, characters in the range of 160 to 255
display not as octal escapes, but as accented characters.  Codes 146
and 160 display as apostrophe and space, even though they are not the
ASCII codes for apostrophe and space.

Enabling European character display with this command noninteractively
from Lisp code also selects Latin-1 as the language environment.
This provides increased compatibility for users who call this function
in `.emacs'.

\(fn ARG)" nil nil)

;;;***

;;;### (autoloads nil "dissociate" "play/dissociate.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from play/dissociate.el

(autoload 'dissociated-press "dissociate" "\
Dissociate the text of the current buffer.
Output goes in buffer named *Dissociation*,
which is redisplayed each time text is added to it.
Every so often the user must say whether to continue.
If ARG is positive, require ARG chars of continuity.
If ARG is negative, require -ARG words of continuity.
Default is 2.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "dnd" "dnd.el" (21788 61018 0 0))
;;; Generated autoloads from dnd.el

(defvar dnd-protocol-alist `((,(purecopy "^file:///") . dnd-open-local-file) (,(purecopy "^file://") . dnd-open-file) (,(purecopy "^file:") . dnd-open-local-file) (,(purecopy "^\\(https?\\|ftp\\|file\\|nfs\\)://") . dnd-open-file)) "\
The functions to call for different protocols when a drop is made.
This variable is used by `dnd-handle-one-url' and `dnd-handle-file-name'.
The list contains of (REGEXP . FUNCTION) pairs.
The functions shall take two arguments, URL, which is the URL dropped and
ACTION which is the action to be performed for the drop (move, copy, link,
private or ask).
If no match is found here, and the value of `browse-url-browser-function'
is a pair of (REGEXP . FUNCTION), those regexps are tried for a match.
If no match is found, the URL is inserted as text by calling `dnd-insert-text'.
The function shall return the action done (move, copy, link or private)
if some action was made, or nil if the URL is ignored.")

(custom-autoload 'dnd-protocol-alist "dnd" t)

;;;***

;;;### (autoloads nil "dns-mode" "textmodes/dns-mode.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from textmodes/dns-mode.el

(autoload 'dns-mode "dns-mode" "\
Major mode for viewing and editing DNS master files.
This mode is inherited from text mode.  It add syntax
highlighting, and some commands for handling DNS master files.
Its keymap inherits from `text-mode' and it has the same
variables for customizing indentation.  It has its own abbrev
table and its own syntax table.

Turning on DNS mode runs `dns-mode-hook'.

\(fn)" t nil)
 (defalias 'zone-mode 'dns-mode)

(autoload 'dns-mode-soa-increment-serial "dns-mode" "\
Locate SOA record and increment the serial field.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "doc-view" "doc-view.el" (21788 61018 0 0))
;;; Generated autoloads from doc-view.el

(autoload 'doc-view-mode-p "doc-view" "\
Return non-nil if document type TYPE is available for `doc-view'.
Document types are symbols like `dvi', `ps', `pdf', or `odf' (any
OpenDocument format).

\(fn TYPE)" nil nil)

(autoload 'doc-view-mode "doc-view" "\
Major mode in DocView buffers.

DocView Mode is an Emacs document viewer.  It displays PDF, PS
and DVI files (as PNG images) in Emacs buffers.

You can use \\<doc-view-mode-map>\\[doc-view-toggle-display] to
toggle between displaying the document or editing it as text.
\\{doc-view-mode-map}

\(fn)" t nil)

(autoload 'doc-view-mode-maybe "doc-view" "\
Switch to `doc-view-mode' if possible.
If the required external tools are not available, then fallback
to the next best mode.

\(fn)" nil nil)

(autoload 'doc-view-minor-mode "doc-view" "\
Toggle displaying buffer via Doc View (Doc View minor mode).
With a prefix argument ARG, enable Doc View minor mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

See the command `doc-view-mode' for more information on this mode.

\(fn &optional ARG)" t nil)

(autoload 'doc-view-bookmark-jump "doc-view" "\


\(fn BMK)" nil nil)

;;;***

;;;### (autoloads nil "doctor" "play/doctor.el" (21710 25077 0 0))
;;; Generated autoloads from play/doctor.el

(autoload 'doctor "doctor" "\
Switch to *doctor* buffer and start giving psychotherapy.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "double" "double.el" (21710 25077 0 0))
;;; Generated autoloads from double.el

(autoload 'double-mode "double" "\
Toggle special insertion on double keypresses (Double mode).
With a prefix argument ARG, enable Double mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

When Double mode is enabled, some keys will insert different
strings when pressed twice.  See `double-map' for details.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "dunnet" "play/dunnet.el" (21788 61018 0 0))
;;; Generated autoloads from play/dunnet.el
(push (purecopy '(dunnet 2 1)) package--builtin-versions)

(autoload 'dunnet "dunnet" "\
Switch to *dungeon* buffer and start game.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "easy-mmode" "emacs-lisp/easy-mmode.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from emacs-lisp/easy-mmode.el

(defalias 'easy-mmode-define-minor-mode 'define-minor-mode)

(autoload 'define-minor-mode "easy-mmode" "\
Define a new minor mode MODE.
This defines the toggle command MODE and (by default) a control variable
MODE (you can override this with the :variable keyword, see below).
DOC is the documentation for the mode toggle command.

The defined mode command takes one optional (prefix) argument.
Interactively with no prefix argument, it toggles the mode.
A prefix argument enables the mode if the argument is positive,
and disables it otherwise.

When called from Lisp, the mode command toggles the mode if the
argument is `toggle', disables the mode if the argument is a
non-positive integer, and enables the mode otherwise (including
if the argument is omitted or nil or a positive integer).

If DOC is nil, give the mode command a basic doc-string
documenting what its argument does.

Optional INIT-VALUE is the initial value of the mode's variable.
Optional LIGHTER is displayed in the mode line when the mode is on.
Optional KEYMAP is the default keymap bound to the mode keymap.
  If non-nil, it should be a variable name (whose value is a keymap),
  or an expression that returns either a keymap or a list of
  arguments for `easy-mmode-define-keymap'.  If you supply a KEYMAP
  argument that is not a symbol, this macro defines the variable
  MODE-map and gives it the value that KEYMAP specifies.

BODY contains code to execute each time the mode is enabled or disabled.
  It is executed after toggling the mode, and before running MODE-hook.
  Before the actual body code, you can write keyword arguments, i.e.
  alternating keywords and values.  These following special keywords
  are supported (other keywords are passed to `defcustom' if the minor
  mode is global):

:group GROUP	Custom group name to use in all generated `defcustom' forms.
		Defaults to MODE without the possible trailing \"-mode\".
		Don't use this default group name unless you have written a
		`defgroup' to define that group properly.
:global GLOBAL	If non-nil specifies that the minor mode is not meant to be
		buffer-local, so don't make the variable MODE buffer-local.
		By default, the mode is buffer-local.
:init-value VAL	Same as the INIT-VALUE argument.
		Not used if you also specify :variable.
:lighter SPEC	Same as the LIGHTER argument.
:keymap MAP	Same as the KEYMAP argument.
:require SYM	Same as in `defcustom'.
:variable PLACE	The location to use instead of the variable MODE to store
		the state of the mode.	This can be simply a different
		named variable, or a generalized variable.
		PLACE can also be of the form (GET . SET), where GET is
		an expression that returns the current state, and SET is
		a function that takes one argument, the new state, and
		sets it.  If you specify a :variable, this function does
		not define a MODE variable (nor any of the terms used
		in :variable).

:after-hook     A single lisp form which is evaluated after the mode hooks
                have been run.  It should not be quoted.

For example, you could write
  (define-minor-mode foo-mode \"If enabled, foo on you!\"
    :lighter \" Foo\" :require 'foo :global t :group 'hassle :version \"27.5\"
    ...BODY CODE...)

\(fn MODE DOC &optional INIT-VALUE LIGHTER KEYMAP &rest BODY)" nil t)

(put 'define-minor-mode 'doc-string-elt '2)

(defalias 'easy-mmode-define-global-mode 'define-globalized-minor-mode)

(defalias 'define-global-minor-mode 'define-globalized-minor-mode)

(autoload 'define-globalized-minor-mode "easy-mmode" "\
Make a global mode GLOBAL-MODE corresponding to buffer-local minor MODE.
TURN-ON is a function that will be called with no args in every buffer
  and that should try to turn MODE on if applicable for that buffer.
KEYS is a list of CL-style keyword arguments.  As the minor mode
  defined by this function is always global, any :global keyword is
  ignored.  Other keywords have the same meaning as in `define-minor-mode',
  which see.  In particular, :group specifies the custom group.
  The most useful keywords are those that are passed on to the
  `defcustom'.  It normally makes no sense to pass the :lighter
  or :keymap keywords to `define-globalized-minor-mode', since these
  are usually passed to the buffer-local version of the minor mode.

If MODE's set-up depends on the major mode in effect when it was
enabled, then disabling and reenabling MODE should make MODE work
correctly with the current major mode.  This is important to
prevent problems with derived modes, that is, major modes that
call another major mode in their body.

When a major mode is initialized, MODE is actually turned on just
after running the major mode's hook.  However, MODE is not turned
on if the hook has explicitly disabled it.

\(fn GLOBAL-MODE MODE TURN-ON &rest KEYS)" nil t)

(put 'define-globalized-minor-mode 'doc-string-elt '2)

(autoload 'easy-mmode-define-keymap "easy-mmode" "\
Return a keymap built from bindings BS.
BS must be a list of (KEY . BINDING) where
KEY and BINDINGS are suitable for `define-key'.
Optional NAME is passed to `make-sparse-keymap'.
Optional map M can be used to modify an existing map.
ARGS is a list of additional keyword arguments.

Valid keywords and arguments are:

  :name      Name of the keymap; overrides NAME argument.
  :dense     Non-nil for a dense keymap.
  :inherit   Parent keymap.
  :group     Ignored.
  :suppress  Non-nil to call `suppress-keymap' on keymap,
             'nodigits to suppress digits as prefix arguments.

\(fn BS &optional NAME M ARGS)" nil nil)

(autoload 'easy-mmode-defmap "easy-mmode" "\
Define a constant M whose value is the result of `easy-mmode-define-keymap'.
The M, BS, and ARGS arguments are as per that function.  DOC is
the constant's documentation.

\(fn M BS DOC &rest ARGS)" nil t)

(autoload 'easy-mmode-defsyntax "easy-mmode" "\
Define variable ST as a syntax-table.
CSS contains a list of syntax specifications of the form (CHAR . SYNTAX).

\(fn ST CSS DOC &rest ARGS)" nil t)

;;;***

;;;### (autoloads nil "easymenu" "emacs-lisp/easymenu.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from emacs-lisp/easymenu.el

(autoload 'easy-menu-define "easymenu" "\
Define a pop-up menu and/or menu bar menu specified by MENU.
If SYMBOL is non-nil, define SYMBOL as a function to pop up the
submenu defined by MENU, with DOC as its doc string.

MAPS, if non-nil, should be a keymap or a list of keymaps; add
the submenu defined by MENU to the keymap or each of the keymaps,
as a top-level menu bar item.

The first element of MENU must be a string.  It is the menu bar
item name.  It may be followed by the following keyword argument
pairs:

 :filter FUNCTION
    FUNCTION must be a function which, if called with one
    argument---the list of the other menu items---returns the
    items to actually display.

 :visible INCLUDE
    INCLUDE is an expression.  The menu is visible if the
    expression evaluates to a non-nil value.  `:included' is an
    alias for `:visible'.

 :active ENABLE
    ENABLE is an expression.  The menu is enabled for selection
    if the expression evaluates to a non-nil value.  `:enable' is
    an alias for `:active'.

The rest of the elements in MENU are menu items.
A menu item can be a vector of three elements:

  [NAME CALLBACK ENABLE]

NAME is a string--the menu item name.

CALLBACK is a command to run when the item is chosen, or an
expression to evaluate when the item is chosen.

ENABLE is an expression; the item is enabled for selection if the
expression evaluates to a non-nil value.

Alternatively, a menu item may have the form:

   [ NAME CALLBACK [ KEYWORD ARG ]... ]

where NAME and CALLBACK have the same meanings as above, and each
optional KEYWORD and ARG pair should be one of the following:

 :keys KEYS
    KEYS is a string; a keyboard equivalent to the menu item.
    This is normally not needed because keyboard equivalents are
    usually computed automatically.  KEYS is expanded with
    `substitute-command-keys' before it is used.

 :key-sequence KEYS
    KEYS is a hint for speeding up Emacs's first display of the
    menu.  It should be nil if you know that the menu item has no
    keyboard equivalent; otherwise it should be a string or
    vector specifying a keyboard equivalent for the menu item.

 :active ENABLE
    ENABLE is an expression; the item is enabled for selection
    whenever this expression's value is non-nil.  `:enable' is an
    alias for `:active'.

 :visible INCLUDE
    INCLUDE is an expression; this item is only visible if this
    expression has a non-nil value.  `:included' is an alias for
    `:visible'.

 :label FORM
    FORM is an expression that is dynamically evaluated and whose
    value serves as the menu item's label (the default is NAME).

 :suffix FORM
    FORM is an expression that is dynamically evaluated and whose
    value is concatenated with the menu entry's label.

 :style STYLE
    STYLE is a symbol describing the type of menu item; it should
    be `toggle' (a checkbox), or `radio' (a radio button), or any
    other value (meaning an ordinary menu item).

 :selected SELECTED
    SELECTED is an expression; the checkbox or radio button is
    selected whenever the expression's value is non-nil.

 :help HELP
    HELP is a string, the help to display for the menu item.

Alternatively, a menu item can be a string.  Then that string
appears in the menu as unselectable text.  A string consisting
solely of dashes is displayed as a menu separator.

Alternatively, a menu item can be a list with the same format as
MENU.  This is a submenu.

\(fn SYMBOL MAPS DOC MENU)" nil t)

(put 'easy-menu-define 'lisp-indent-function 'defun)

(autoload 'easy-menu-do-define "easymenu" "\


\(fn SYMBOL MAPS DOC MENU)" nil nil)

(autoload 'easy-menu-create-menu "easymenu" "\
Create a menu called MENU-NAME with items described in MENU-ITEMS.
MENU-NAME is a string, the name of the menu.  MENU-ITEMS is a list of items
possibly preceded by keyword pairs as described in `easy-menu-define'.

\(fn MENU-NAME MENU-ITEMS)" nil nil)

(autoload 'easy-menu-change "easymenu" "\
Change menu found at PATH as item NAME to contain ITEMS.
PATH is a list of strings for locating the menu that
should contain a submenu named NAME.
ITEMS is a list of menu items, as in `easy-menu-define'.
These items entirely replace the previous items in that submenu.

If MAP is specified, it should normally be a keymap; nil stands for the local
menu-bar keymap.  It can also be a symbol, which has earlier been used as the
first argument in a call to `easy-menu-define', or the value of such a symbol.

If the menu located by PATH has no submenu named NAME, add one.
If the optional argument BEFORE is present, add it just before
the submenu named BEFORE, otherwise add it at the end of the menu.

To implement dynamic menus, either call this from
`menu-bar-update-hook' or use a menu filter.

\(fn PATH NAME ITEMS &optional BEFORE MAP)" nil nil)

;;;***

;;;### (autoloads nil "ebnf2ps" "progmodes/ebnf2ps.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/ebnf2ps.el
(push (purecopy '(ebnf2ps 4 4)) package--builtin-versions)

(autoload 'ebnf-customize "ebnf2ps" "\
Customization for ebnf group.

\(fn)" t nil)

(autoload 'ebnf-print-directory "ebnf2ps" "\
Generate and print a PostScript syntactic chart image of DIRECTORY.

If DIRECTORY is nil, it's used `default-directory'.

The files in DIRECTORY that matches `ebnf-file-suffix-regexp' (which see) are
processed.

See also `ebnf-print-buffer'.

\(fn &optional DIRECTORY)" t nil)

(autoload 'ebnf-print-file "ebnf2ps" "\
Generate and print a PostScript syntactic chart image of the file FILE.

If optional arg DO-NOT-KILL-BUFFER-WHEN-DONE is non-nil, the buffer isn't
killed after process termination.

See also `ebnf-print-buffer'.

\(fn FILE &optional DO-NOT-KILL-BUFFER-WHEN-DONE)" t nil)

(autoload 'ebnf-print-buffer "ebnf2ps" "\
Generate and print a PostScript syntactic chart image of the buffer.

When called with a numeric prefix argument (C-u), prompts the user for
the name of a file to save the PostScript image in, instead of sending
it to the printer.

More specifically, the FILENAME argument is treated as follows: if it
is nil, send the image to the printer.  If FILENAME is a string, save
the PostScript image in a file with that name.  If FILENAME is a
number, prompt the user for the name of the file to save in.

\(fn &optional FILENAME)" t nil)

(autoload 'ebnf-print-region "ebnf2ps" "\
Generate and print a PostScript syntactic chart image of the region.
Like `ebnf-print-buffer', but prints just the current region.

\(fn FROM TO &optional FILENAME)" t nil)

(autoload 'ebnf-spool-directory "ebnf2ps" "\
Generate and spool a PostScript syntactic chart image of DIRECTORY.

If DIRECTORY is nil, it's used `default-directory'.

The files in DIRECTORY that matches `ebnf-file-suffix-regexp' (which see) are
processed.

See also `ebnf-spool-buffer'.

\(fn &optional DIRECTORY)" t nil)

(autoload 'ebnf-spool-file "ebnf2ps" "\
Generate and spool a PostScript syntactic chart image of the file FILE.

If optional arg DO-NOT-KILL-BUFFER-WHEN-DONE is non-nil, the buffer isn't
killed after process termination.

See also `ebnf-spool-buffer'.

\(fn FILE &optional DO-NOT-KILL-BUFFER-WHEN-DONE)" t nil)

(autoload 'ebnf-spool-buffer "ebnf2ps" "\
Generate and spool a PostScript syntactic chart image of the buffer.
Like `ebnf-print-buffer' except that the PostScript image is saved in a
local buffer to be sent to the printer later.

Use the command `ebnf-despool' to send the spooled images to the printer.

\(fn)" t nil)

(autoload 'ebnf-spool-region "ebnf2ps" "\
Generate a PostScript syntactic chart image of the region and spool locally.
Like `ebnf-spool-buffer', but spools just the current region.

Use the command `ebnf-despool' to send the spooled images to the printer.

\(fn FROM TO)" t nil)

(autoload 'ebnf-eps-directory "ebnf2ps" "\
Generate EPS files from EBNF files in DIRECTORY.

If DIRECTORY is nil, it's used `default-directory'.

The files in DIRECTORY that matches `ebnf-file-suffix-regexp' (which see) are
processed.

See also `ebnf-eps-buffer'.

\(fn &optional DIRECTORY)" t nil)

(autoload 'ebnf-eps-file "ebnf2ps" "\
Generate an EPS file from EBNF file FILE.

If optional arg DO-NOT-KILL-BUFFER-WHEN-DONE is non-nil, the buffer isn't
killed after EPS generation.

See also `ebnf-eps-buffer'.

\(fn FILE &optional DO-NOT-KILL-BUFFER-WHEN-DONE)" t nil)

(autoload 'ebnf-eps-buffer "ebnf2ps" "\
Generate a PostScript syntactic chart image of the buffer in an EPS file.

Generate an EPS file for each production in the buffer.
The EPS file name has the following form:

   <PREFIX><PRODUCTION>.eps

<PREFIX>     is given by variable `ebnf-eps-prefix'.
	     The default value is \"ebnf--\".

<PRODUCTION> is the production name.
	     Some characters in the production file name are replaced to
	     produce a valid file name.  For example, the production name
	     \"A/B + C\" is modified to produce \"A_B_+_C\", and the EPS
	     file name used in this case will be \"ebnf--A_B_+_C.eps\".

WARNING: This function does *NOT* ask any confirmation to override existing
	 files.

\(fn)" t nil)

(autoload 'ebnf-eps-region "ebnf2ps" "\
Generate a PostScript syntactic chart image of the region in an EPS file.

Generate an EPS file for each production in the region.
The EPS file name has the following form:

   <PREFIX><PRODUCTION>.eps

<PREFIX>     is given by variable `ebnf-eps-prefix'.
	     The default value is \"ebnf--\".

<PRODUCTION> is the production name.
	     Some characters in the production file name are replaced to
	     produce a valid file name.  For example, the production name
	     \"A/B + C\" is modified to produce \"A_B_+_C\", and the EPS
	     file name used in this case will be \"ebnf--A_B_+_C.eps\".

WARNING: This function does *NOT* ask any confirmation to override existing
	 files.

\(fn FROM TO)" t nil)

(defalias 'ebnf-despool 'ps-despool)

(autoload 'ebnf-syntax-directory "ebnf2ps" "\
Do a syntactic analysis of the files in DIRECTORY.

If DIRECTORY is nil, use `default-directory'.

Only the files in DIRECTORY that match `ebnf-file-suffix-regexp' (which see)
are processed.

See also `ebnf-syntax-buffer'.

\(fn &optional DIRECTORY)" t nil)

(autoload 'ebnf-syntax-file "ebnf2ps" "\
Do a syntactic analysis of the named FILE.

If optional arg DO-NOT-KILL-BUFFER-WHEN-DONE is non-nil, the buffer isn't
killed after syntax checking.

See also `ebnf-syntax-buffer'.

\(fn FILE &optional DO-NOT-KILL-BUFFER-WHEN-DONE)" t nil)

(autoload 'ebnf-syntax-buffer "ebnf2ps" "\
Do a syntactic analysis of the current buffer.

\(fn)" t nil)

(autoload 'ebnf-syntax-region "ebnf2ps" "\
Do a syntactic analysis of a region.

\(fn FROM TO)" t nil)

(autoload 'ebnf-setup "ebnf2ps" "\
Return the current ebnf2ps setup.

\(fn)" nil nil)

(autoload 'ebnf-find-style "ebnf2ps" "\
Return style definition if NAME is already defined; otherwise, return nil.

See `ebnf-style-database' documentation.

\(fn NAME)" t nil)

(autoload 'ebnf-insert-style "ebnf2ps" "\
Insert a new style NAME with inheritance INHERITS and values VALUES.

See `ebnf-style-database' documentation.

\(fn NAME INHERITS &rest VALUES)" t nil)

(autoload 'ebnf-delete-style "ebnf2ps" "\
Delete style NAME.

See `ebnf-style-database' documentation.

\(fn NAME)" t nil)

(autoload 'ebnf-merge-style "ebnf2ps" "\
Merge values of style NAME with style VALUES.

See `ebnf-style-database' documentation.

\(fn NAME &rest VALUES)" t nil)

(autoload 'ebnf-apply-style "ebnf2ps" "\
Set STYLE as the current style.

Returns the old style symbol.

See `ebnf-style-database' documentation.

\(fn STYLE)" t nil)

(autoload 'ebnf-reset-style "ebnf2ps" "\
Reset current style.

Returns the old style symbol.

See `ebnf-style-database' documentation.

\(fn &optional STYLE)" t nil)

(autoload 'ebnf-push-style "ebnf2ps" "\
Push the current style onto a stack and set STYLE as the current style.

Returns the old style symbol.

See also `ebnf-pop-style'.

See `ebnf-style-database' documentation.

\(fn &optional STYLE)" t nil)

(autoload 'ebnf-pop-style "ebnf2ps" "\
Pop a style from the stack of pushed styles and set it as the current style.

Returns the old style symbol.

See also `ebnf-push-style'.

See `ebnf-style-database' documentation.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ebrowse" "progmodes/ebrowse.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/ebrowse.el

(autoload 'ebrowse-tree-mode "ebrowse" "\
Major mode for Ebrowse class tree buffers.
Each line corresponds to a class in a class tree.
Letters do not insert themselves, they are commands.
File operations in the tree buffer work on class tree data structures.
E.g.\\[save-buffer] writes the tree to the file it was loaded from.

Tree mode key bindings:
\\{ebrowse-tree-mode-map}

\(fn)" t nil)

(autoload 'ebrowse-electric-choose-tree "ebrowse" "\
Return a buffer containing a tree or nil if no tree found or canceled.

\(fn)" t nil)

(autoload 'ebrowse-member-mode "ebrowse" "\
Major mode for Ebrowse member buffers.

\(fn)" t nil)

(autoload 'ebrowse-tags-view-declaration "ebrowse" "\
View declaration of member at point.

\(fn)" t nil)

(autoload 'ebrowse-tags-find-declaration "ebrowse" "\
Find declaration of member at point.

\(fn)" t nil)

(autoload 'ebrowse-tags-view-definition "ebrowse" "\
View definition of member at point.

\(fn)" t nil)

(autoload 'ebrowse-tags-find-definition "ebrowse" "\
Find definition of member at point.

\(fn)" t nil)

(autoload 'ebrowse-tags-find-declaration-other-window "ebrowse" "\
Find declaration of member at point in other window.

\(fn)" t nil)

(autoload 'ebrowse-tags-view-definition-other-window "ebrowse" "\
View definition of member at point in other window.

\(fn)" t nil)

(autoload 'ebrowse-tags-find-definition-other-window "ebrowse" "\
Find definition of member at point in other window.

\(fn)" t nil)

(autoload 'ebrowse-tags-find-declaration-other-frame "ebrowse" "\
Find definition of member at point in other frame.

\(fn)" t nil)

(autoload 'ebrowse-tags-view-definition-other-frame "ebrowse" "\
View definition of member at point in other frame.

\(fn)" t nil)

(autoload 'ebrowse-tags-find-definition-other-frame "ebrowse" "\
Find definition of member at point in other frame.

\(fn)" t nil)

(autoload 'ebrowse-tags-complete-symbol "ebrowse" "\
Perform completion on the C++ symbol preceding point.
A second call of this function without changing point inserts the next match.
A call with prefix PREFIX reads the symbol to insert from the minibuffer with
completion.

\(fn PREFIX)" t nil)

(autoload 'ebrowse-tags-loop-continue "ebrowse" "\
Repeat last operation on files in tree.
FIRST-TIME non-nil means this is not a repetition, but the first time.
TREE-BUFFER if indirectly specifies which files to loop over.

\(fn &optional FIRST-TIME TREE-BUFFER)" t nil)

(autoload 'ebrowse-tags-search "ebrowse" "\
Search for REGEXP in all files in a tree.
If marked classes exist, process marked classes, only.
If regular expression is nil, repeat last search.

\(fn REGEXP)" t nil)

(autoload 'ebrowse-tags-query-replace "ebrowse" "\
Query replace FROM with TO in all files of a class tree.
With prefix arg, process files of marked classes only.

\(fn FROM TO)" t nil)

(autoload 'ebrowse-tags-search-member-use "ebrowse" "\
Search for call sites of a member.
If FIX-NAME is specified, search uses of that member.
Otherwise, read a member name from the minibuffer.
Searches in all files mentioned in a class tree for something that
looks like a function call to the member.

\(fn &optional FIX-NAME)" t nil)

(autoload 'ebrowse-back-in-position-stack "ebrowse" "\
Move backward in the position stack.
Prefix arg ARG says how much.

\(fn ARG)" t nil)

(autoload 'ebrowse-forward-in-position-stack "ebrowse" "\
Move forward in the position stack.
Prefix arg ARG says how much.

\(fn ARG)" t nil)

(autoload 'ebrowse-electric-position-menu "ebrowse" "\
List positions in the position stack in an electric buffer.

\(fn)" t nil)

(autoload 'ebrowse-save-tree "ebrowse" "\
Save current tree in same file it was loaded from.

\(fn)" t nil)

(autoload 'ebrowse-save-tree-as "ebrowse" "\
Write the current tree data structure to a file.
Read the file name from the minibuffer if interactive.
Otherwise, FILE-NAME specifies the file to save the tree in.

\(fn &optional FILE-NAME)" t nil)

(autoload 'ebrowse-statistics "ebrowse" "\
Display statistics for a class tree.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ebuff-menu" "ebuff-menu.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from ebuff-menu.el

(autoload 'electric-buffer-list "ebuff-menu" "\
Pop up the Buffer Menu in an \"electric\" window.
If you type SPC or RET (`Electric-buffer-menu-select'), that
selects the buffer at point and quits the \"electric\" window.
Otherwise, you can move around in the Buffer Menu, marking
buffers to be selected, saved or deleted; these other commands
are much like those of `Buffer-menu-mode'.

Run hooks in `electric-buffer-menu-mode-hook' on entry.

\\<electric-buffer-menu-mode-map>
\\[keyboard-quit] or \\[Electric-buffer-menu-quit] -- exit buffer menu, returning to previous window and buffer
  configuration.  If the very first character typed is a space, it
  also has this effect.
\\[Electric-buffer-menu-select] -- select buffer of line point is on.
  Also show buffers marked with m in other windows,
  deletes buffers marked with \"D\", and saves those marked with \"S\".
\\[Buffer-menu-mark] -- mark buffer to be displayed.
\\[Buffer-menu-not-modified] -- clear modified-flag on that buffer.
\\[Buffer-menu-save] -- mark that buffer to be saved.
\\[Buffer-menu-delete] or \\[Buffer-menu-delete-backwards] -- mark that buffer to be deleted.
\\[Buffer-menu-unmark] -- remove all kinds of marks from current line.
\\[Electric-buffer-menu-mode-view-buffer] -- view buffer, returning when done.
\\[Buffer-menu-backup-unmark] -- back up a line and remove marks.

\(fn ARG)" t nil)

;;;***

;;;### (autoloads nil "echistory" "echistory.el" (21710 25077 0 0))
;;; Generated autoloads from echistory.el

(autoload 'Electric-command-history-redo-expression "echistory" "\
Edit current history line in minibuffer and execute result.
With prefix arg NOCONFIRM, execute current line as-is without editing.

\(fn &optional NOCONFIRM)" t nil)

;;;***

;;;### (autoloads nil "ecomplete" "gnus/ecomplete.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/ecomplete.el

(autoload 'ecomplete-setup "ecomplete" "\


\(fn)" nil nil)

;;;***

;;;### (autoloads nil "ede" "cedet/ede.el" (21788 61018 0 0))
;;; Generated autoloads from cedet/ede.el
(push (purecopy '(ede 1 2)) package--builtin-versions)

(defvar global-ede-mode nil "\
Non-nil if Global-Ede mode is enabled.
See the command `global-ede-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-ede-mode'.")

(custom-autoload 'global-ede-mode "ede" nil)

(autoload 'global-ede-mode "ede" "\
Toggle global EDE (Emacs Development Environment) mode.
With a prefix argument ARG, enable global EDE mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

This global minor mode enables `ede-minor-mode' in all buffers in
an EDE controlled project.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "edebug" "emacs-lisp/edebug.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/edebug.el

(defvar edebug-all-defs nil "\
If non-nil, evaluating defining forms instruments for Edebug.
This applies to `eval-defun', `eval-region', `eval-buffer', and
`eval-current-buffer'.  `eval-region' is also called by
`eval-last-sexp', and `eval-print-last-sexp'.

You can use the command `edebug-all-defs' to toggle the value of this
variable.  You may wish to make it local to each buffer with
\(make-local-variable 'edebug-all-defs) in your
`emacs-lisp-mode-hook'.")

(custom-autoload 'edebug-all-defs "edebug" t)

(defvar edebug-all-forms nil "\
Non-nil means evaluation of all forms will instrument for Edebug.
This doesn't apply to loading or evaluations in the minibuffer.
Use the command `edebug-all-forms' to toggle the value of this option.")

(custom-autoload 'edebug-all-forms "edebug" t)

(autoload 'edebug-basic-spec "edebug" "\
Return t if SPEC uses only extant spec symbols.
An extant spec symbol is a symbol that is not a function and has a
`edebug-form-spec' property.

\(fn SPEC)" nil nil)

(defalias 'edebug-defun 'edebug-eval-top-level-form)

(autoload 'edebug-eval-top-level-form "edebug" "\
Evaluate the top level form point is in, stepping through with Edebug.
This is like `eval-defun' except that it steps the code for Edebug
before evaluating it.  It displays the value in the echo area
using `eval-expression' (which see).

If you do this on a function definition such as a defun or defmacro,
it defines the function and instruments its definition for Edebug,
so it will do Edebug stepping when called later.  It displays
`Edebug: FUNCTION' in the echo area to indicate that FUNCTION is now
instrumented for Edebug.

If the current defun is actually a call to `defvar' or `defcustom',
evaluating it this way resets the variable using its initial value
expression even if the variable already has some other value.
\(Normally `defvar' and `defcustom' do not alter the value if there
already is one.)

\(fn)" t nil)

(autoload 'edebug-all-defs "edebug" "\
Toggle edebugging of all definitions.

\(fn)" t nil)

(autoload 'edebug-all-forms "edebug" "\
Toggle edebugging of all forms.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ediff" "vc/ediff.el" (21710 25077 0 0))
;;; Generated autoloads from vc/ediff.el
(push (purecopy '(ediff 2 81 4)) package--builtin-versions)

(autoload 'ediff-files "ediff" "\
Run Ediff on a pair of files, FILE-A and FILE-B.

\(fn FILE-A FILE-B &optional STARTUP-HOOKS)" t nil)

(autoload 'ediff-files3 "ediff" "\
Run Ediff on three files, FILE-A, FILE-B, and FILE-C.

\(fn FILE-A FILE-B FILE-C &optional STARTUP-HOOKS)" t nil)

(defalias 'ediff3 'ediff-files3)

(defalias 'ediff 'ediff-files)

(autoload 'ediff-current-file "ediff" "\
Start ediff between current buffer and its file on disk.
This command can be used instead of `revert-buffer'.  If there is
nothing to revert then this command fails.

\(fn)" t nil)

(autoload 'ediff-backup "ediff" "\
Run Ediff on FILE and its backup file.
Uses the latest backup, if there are several numerical backups.
If this file is a backup, `ediff' it with its original.

\(fn FILE)" t nil)

(autoload 'ediff-buffers "ediff" "\
Run Ediff on a pair of buffers, BUFFER-A and BUFFER-B.

\(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS JOB-NAME)" t nil)

(defalias 'ebuffers 'ediff-buffers)

(autoload 'ediff-buffers3 "ediff" "\
Run Ediff on three buffers, BUFFER-A, BUFFER-B, and BUFFER-C.

\(fn BUFFER-A BUFFER-B BUFFER-C &optional STARTUP-HOOKS JOB-NAME)" t nil)

(defalias 'ebuffers3 'ediff-buffers3)

(autoload 'ediff-directories "ediff" "\
Run Ediff on a pair of directories, DIR1 and DIR2, comparing files that have
the same name in both.  The third argument, REGEXP, is nil or a regular
expression; only file names that match the regexp are considered.

\(fn DIR1 DIR2 REGEXP)" t nil)

(defalias 'edirs 'ediff-directories)

(autoload 'ediff-directory-revisions "ediff" "\
Run Ediff on a directory, DIR1, comparing its files with their revisions.
The second argument, REGEXP, is a regular expression that filters the file
names.  Only the files that are under revision control are taken into account.

\(fn DIR1 REGEXP)" t nil)

(defalias 'edir-revisions 'ediff-directory-revisions)

(autoload 'ediff-directories3 "ediff" "\
Run Ediff on three directories, DIR1, DIR2, and DIR3, comparing files that
have the same name in all three.  The last argument, REGEXP, is nil or a
regular expression; only file names that match the regexp are considered.

\(fn DIR1 DIR2 DIR3 REGEXP)" t nil)

(defalias 'edirs3 'ediff-directories3)

(autoload 'ediff-merge-directories "ediff" "\
Run Ediff on a pair of directories, DIR1 and DIR2, merging files that have
the same name in both.  The third argument, REGEXP, is nil or a regular
expression; only file names that match the regexp are considered.

\(fn DIR1 DIR2 REGEXP &optional MERGE-AUTOSTORE-DIR)" t nil)

(defalias 'edirs-merge 'ediff-merge-directories)

(autoload 'ediff-merge-directories-with-ancestor "ediff" "\
Merge files in directories DIR1 and DIR2 using files in ANCESTOR-DIR as ancestors.
Ediff merges files that have identical names in DIR1, DIR2.  If a pair of files
in DIR1 and DIR2 doesn't have an ancestor in ANCESTOR-DIR, Ediff will merge
without ancestor.  The fourth argument, REGEXP, is nil or a regular expression;
only file names that match the regexp are considered.

\(fn DIR1 DIR2 ANCESTOR-DIR REGEXP &optional MERGE-AUTOSTORE-DIR)" t nil)

(autoload 'ediff-merge-directory-revisions "ediff" "\
Run Ediff on a directory, DIR1, merging its files with their revisions.
The second argument, REGEXP, is a regular expression that filters the file
names.  Only the files that are under revision control are taken into account.

\(fn DIR1 REGEXP &optional MERGE-AUTOSTORE-DIR)" t nil)

(defalias 'edir-merge-revisions 'ediff-merge-directory-revisions)

(autoload 'ediff-merge-directory-revisions-with-ancestor "ediff" "\
Run Ediff on a directory, DIR1, merging its files with their revisions and ancestors.
The second argument, REGEXP, is a regular expression that filters the file
names.  Only the files that are under revision control are taken into account.

\(fn DIR1 REGEXP &optional MERGE-AUTOSTORE-DIR)" t nil)

(defalias 'edir-merge-revisions-with-ancestor 'ediff-merge-directory-revisions-with-ancestor)

(defalias 'edirs-merge-with-ancestor 'ediff-merge-directories-with-ancestor)

(autoload 'ediff-windows-wordwise "ediff" "\
Compare WIND-A and WIND-B, which are selected by clicking, wordwise.
With prefix argument, DUMB-MODE, or on a non-windowing display, works as
follows:
If WIND-A is nil, use selected window.
If WIND-B is nil, use window next to WIND-A.

\(fn DUMB-MODE &optional WIND-A WIND-B STARTUP-HOOKS)" t nil)

(autoload 'ediff-windows-linewise "ediff" "\
Compare WIND-A and WIND-B, which are selected by clicking, linewise.
With prefix argument, DUMB-MODE, or on a non-windowing display, works as
follows:
If WIND-A is nil, use selected window.
If WIND-B is nil, use window next to WIND-A.

\(fn DUMB-MODE &optional WIND-A WIND-B STARTUP-HOOKS)" t nil)

(autoload 'ediff-regions-wordwise "ediff" "\
Run Ediff on a pair of regions in specified buffers.
Regions (i.e., point and mark) can be set in advance or marked interactively.
This function is effective only for relatively small regions, up to 200
lines.  For large regions, use `ediff-regions-linewise'.

\(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS)" t nil)

(autoload 'ediff-regions-linewise "ediff" "\
Run Ediff on a pair of regions in specified buffers.
Regions (i.e., point and mark) can be set in advance or marked interactively.
Each region is enlarged to contain full lines.
This function is effective for large regions, over 100-200
lines.  For small regions, use `ediff-regions-wordwise'.

\(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS)" t nil)

(defalias 'ediff-merge 'ediff-merge-files)

(autoload 'ediff-merge-files "ediff" "\
Merge two files without ancestor.

\(fn FILE-A FILE-B &optional STARTUP-HOOKS MERGE-BUFFER-FILE)" t nil)

(autoload 'ediff-merge-files-with-ancestor "ediff" "\
Merge two files with ancestor.

\(fn FILE-A FILE-B FILE-ANCESTOR &optional STARTUP-HOOKS MERGE-BUFFER-FILE)" t nil)

(defalias 'ediff-merge-with-ancestor 'ediff-merge-files-with-ancestor)

(autoload 'ediff-merge-buffers "ediff" "\
Merge buffers without ancestor.

\(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS JOB-NAME MERGE-BUFFER-FILE)" t nil)

(autoload 'ediff-merge-buffers-with-ancestor "ediff" "\
Merge buffers with ancestor.

\(fn BUFFER-A BUFFER-B BUFFER-ANCESTOR &optional STARTUP-HOOKS JOB-NAME MERGE-BUFFER-FILE)" t nil)

(autoload 'ediff-merge-revisions "ediff" "\
Run Ediff by merging two revisions of a file.
The file is the optional FILE argument or the file visited by the current
buffer.

\(fn &optional FILE STARTUP-HOOKS MERGE-BUFFER-FILE)" t nil)

(autoload 'ediff-merge-revisions-with-ancestor "ediff" "\
Run Ediff by merging two revisions of a file with a common ancestor.
The file is the optional FILE argument or the file visited by the current
buffer.

\(fn &optional FILE STARTUP-HOOKS MERGE-BUFFER-FILE)" t nil)

(autoload 'ediff-patch-file "ediff" "\
Query for a file name, and then run Ediff by patching that file.
If optional PATCH-BUF is given, use the patch in that buffer
and don't ask the user.
If prefix argument, then: if even argument, assume that the patch is in a
buffer. If odd -- assume it is in a file.

\(fn &optional ARG PATCH-BUF)" t nil)

(autoload 'ediff-patch-buffer "ediff" "\
Run Ediff by patching the buffer specified at prompt.
Without the optional prefix ARG, asks if the patch is in some buffer and
prompts for the buffer or a file, depending on the answer.
With ARG=1, assumes the patch is in a file and prompts for the file.
With ARG=2, assumes the patch is in a buffer and prompts for the buffer.
PATCH-BUF is an optional argument, which specifies the buffer that contains the
patch. If not given, the user is prompted according to the prefix argument.

\(fn &optional ARG PATCH-BUF)" t nil)

(defalias 'epatch 'ediff-patch-file)

(defalias 'epatch-buffer 'ediff-patch-buffer)

(autoload 'ediff-revision "ediff" "\
Run Ediff by comparing versions of a file.
The file is an optional FILE argument or the file entered at the prompt.
Default: the file visited by the current buffer.
Uses `vc.el' or `rcs.el' depending on `ediff-version-control-package'.

\(fn &optional FILE STARTUP-HOOKS)" t nil)

(defalias 'erevision 'ediff-revision)

(autoload 'ediff-version "ediff" "\
Return string describing the version of Ediff.
When called interactively, displays the version.

\(fn)" t nil)

(autoload 'ediff-documentation "ediff" "\
Display Ediff's manual.
With optional NODE, goes to that node.

\(fn &optional NODE)" t nil)

(autoload 'ediff-files-command "ediff" "\


\(fn)" nil nil)

(autoload 'ediff3-files-command "ediff" "\


\(fn)" nil nil)

(autoload 'ediff-merge-command "ediff" "\


\(fn)" nil nil)

(autoload 'ediff-merge-with-ancestor-command "ediff" "\


\(fn)" nil nil)

(autoload 'ediff-directories-command "ediff" "\


\(fn)" nil nil)

(autoload 'ediff-directories3-command "ediff" "\


\(fn)" nil nil)

(autoload 'ediff-merge-directories-command "ediff" "\


\(fn)" nil nil)

(autoload 'ediff-merge-directories-with-ancestor-command "ediff" "\


\(fn)" nil nil)

;;;***

;;;### (autoloads nil "ediff-help" "vc/ediff-help.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from vc/ediff-help.el

(autoload 'ediff-customize "ediff-help" "\


\(fn)" t nil)

;;;***

;;;### (autoloads nil "ediff-mult" "vc/ediff-mult.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from vc/ediff-mult.el

(autoload 'ediff-show-registry "ediff-mult" "\
Display Ediff's registry.

\(fn)" t nil)

(defalias 'eregistry 'ediff-show-registry)

;;;***

;;;### (autoloads nil "ediff-util" "vc/ediff-util.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from vc/ediff-util.el

(autoload 'ediff-toggle-multiframe "ediff-util" "\
Switch from multiframe display to single-frame display and back.
To change the default, set the variable `ediff-window-setup-function',
which see.

\(fn)" t nil)

(autoload 'ediff-toggle-use-toolbar "ediff-util" "\
Enable or disable Ediff toolbar.
Works only in versions of Emacs that support toolbars.
To change the default, set the variable `ediff-use-toolbar-p', which see.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "edmacro" "edmacro.el" (21710 25077 0 0))
;;; Generated autoloads from edmacro.el
(push (purecopy '(edmacro 2 1)) package--builtin-versions)

(autoload 'edit-kbd-macro "edmacro" "\
Edit a keyboard macro.
At the prompt, type any key sequence which is bound to a keyboard macro.
Or, type `C-x e' or RET to edit the last keyboard macro, `C-h l' to edit
the last 300 keystrokes as a keyboard macro, or `M-x' to edit a macro by
its command name.
With a prefix argument, format the macro in a more concise way.

\(fn KEYS &optional PREFIX FINISH-HOOK STORE-HOOK)" t nil)

(autoload 'edit-last-kbd-macro "edmacro" "\
Edit the most recently defined keyboard macro.

\(fn &optional PREFIX)" t nil)

(autoload 'edit-named-kbd-macro "edmacro" "\
Edit a keyboard macro which has been given a name by `name-last-kbd-macro'.

\(fn &optional PREFIX)" t nil)

(autoload 'read-kbd-macro "edmacro" "\
Read the region as a keyboard macro definition.
The region is interpreted as spelled-out keystrokes, e.g., \"M-x abc RET\".
See documentation for `edmacro-mode' for details.
Leading/trailing \"C-x (\" and \"C-x )\" in the text are allowed and ignored.
The resulting macro is installed as the \"current\" keyboard macro.

In Lisp, may also be called with a single STRING argument in which case
the result is returned rather than being installed as the current macro.
The result will be a string if possible, otherwise an event vector.
Second argument NEED-VECTOR means to return an event vector always.

\(fn START &optional END)" t nil)

(autoload 'format-kbd-macro "edmacro" "\
Return the keyboard macro MACRO as a human-readable string.
This string is suitable for passing to `read-kbd-macro'.
Second argument VERBOSE means to put one command per line with comments.
If VERBOSE is `1', put everything on one line.  If VERBOSE is omitted
or nil, use a compact 80-column format.

\(fn &optional MACRO VERBOSE)" nil nil)

;;;***

;;;### (autoloads nil "edt" "emulation/edt.el" (21788 61018 0 0))
;;; Generated autoloads from emulation/edt.el

(autoload 'edt-set-scroll-margins "edt" "\
Set scroll margins.
Argument TOP is the top margin in number of lines or percent of window.
Argument BOTTOM is the bottom margin in number of lines or percent of window.

\(fn TOP BOTTOM)" t nil)

(autoload 'edt-emulation-on "edt" "\
Turn on EDT Emulation.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ehelp" "ehelp.el" (21710 25077 0 0))
;;; Generated autoloads from ehelp.el

(autoload 'with-electric-help "ehelp" "\
Pop up an \"electric\" help buffer.
THUNK is a function of no arguments which is called to initialize the
contents of BUFFER.  BUFFER defaults to `*Help*'.  BUFFER will be
erased before THUNK is called unless NOERASE is non-nil.  THUNK will
be called while BUFFER is current and with `standard-output' bound to
the buffer specified by BUFFER.

If THUNK returns nil, we display BUFFER starting at the top, and shrink
the window to fit.  If THUNK returns non-nil, we don't do those things.

After THUNK has been called, this function \"electrically\" pops up a
window in which BUFFER is displayed and allows the user to scroll
through that buffer in `electric-help-mode'.  The window's height will
be at least MINHEIGHT if this value is non-nil.

If THUNK returns nil, we display BUFFER starting at the top, and
shrink the window to fit if `electric-help-shrink-window' is non-nil.
If THUNK returns non-nil, we don't do those things.

When the user exits (with `electric-help-exit', or otherwise), the help
buffer's window disappears (i.e., we use `save-window-excursion'), and
BUFFER is put back into its original major mode.

\(fn THUNK &optional BUFFER NOERASE MINHEIGHT)" nil nil)

(autoload 'electric-helpify "ehelp" "\


\(fn FUN &optional NAME)" nil nil)

;;;***

;;;### (autoloads nil "eieio" "emacs-lisp/eieio.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/eieio.el
(push (purecopy '(eieio 1 4)) package--builtin-versions)

;;;***

;;;### (autoloads nil "eieio-core" "emacs-lisp/eieio-core.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from emacs-lisp/eieio-core.el
(push (purecopy '(eieio-core 1 4)) package--builtin-versions)

(autoload 'eieio-defclass-autoload "eieio-core" "\
Create autoload symbols for the EIEIO class CNAME.
SUPERCLASSES are the superclasses that CNAME inherits from.
DOC is the docstring for CNAME.
This function creates a mock-class for CNAME and adds it into
SUPERCLASSES as children.
It creates an autoload function for CNAME's constructor.

\(fn CNAME SUPERCLASSES FILENAME DOC)" nil nil)

;;;***

;;;### (autoloads nil "eldoc" "emacs-lisp/eldoc.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/eldoc.el

(defvar eldoc-minor-mode-string (purecopy " ElDoc") "\
String to display in mode line when ElDoc Mode is enabled; nil for none.")

(custom-autoload 'eldoc-minor-mode-string "eldoc" t)

(autoload 'eldoc-mode "eldoc" "\
Toggle echo area display of Lisp objects at point (ElDoc mode).
With a prefix argument ARG, enable ElDoc mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable ElDoc mode
if ARG is omitted or nil.

ElDoc mode is a buffer-local minor mode.  When enabled, the echo
area displays information about a function or variable in the
text where point is.  If point is on a documented variable, it
displays the first line of that variable's doc string.  Otherwise
it displays the argument list of the function called in the
expression point is on.

\(fn &optional ARG)" t nil)

(define-obsolete-function-alias 'turn-on-eldoc-mode 'eldoc-mode "24.4")

(defvar eldoc-documentation-function nil "\
If non-nil, function to call to return doc string.
The function of no args should return a one-line string for displaying
doc about a function etc. appropriate to the context around point.
It should return nil if there's no doc appropriate for the context.
Typically doc is returned if point is on a function-like name or in its
arg list.

The result is used as is, so the function must explicitly handle
the variables `eldoc-argument-case' and `eldoc-echo-area-use-multiline-p',
and the face `eldoc-highlight-function-argument', if they are to have any
effect.

This variable is expected to be made buffer-local by modes (other than
Emacs Lisp mode) that support ElDoc.")

;;;***

;;;### (autoloads nil "elec-pair" "elec-pair.el" (21788 61018 0 0))
;;; Generated autoloads from elec-pair.el

(defvar electric-pair-text-pairs '((34 . 34)) "\
Alist of pairs that should always be used in comments and strings.

Pairs of delimiters in this list are a fallback in case they have
no syntax relevant to `electric-pair-mode' in the syntax table
defined in `electric-pair-text-syntax-table'")

(custom-autoload 'electric-pair-text-pairs "elec-pair" t)

(defvar electric-pair-mode nil "\
Non-nil if Electric-Pair mode is enabled.
See the command `electric-pair-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `electric-pair-mode'.")

(custom-autoload 'electric-pair-mode "elec-pair" nil)

(autoload 'electric-pair-mode "elec-pair" "\
Toggle automatic parens pairing (Electric Pair mode).
With a prefix argument ARG, enable Electric Pair mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Electric Pair mode is a global minor mode.  When enabled, typing
an open parenthesis automatically inserts the corresponding
closing parenthesis.  (Likewise for brackets, etc.).

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "elide-head" "elide-head.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from elide-head.el

(autoload 'elide-head "elide-head" "\
Hide header material in buffer according to `elide-head-headers-to-hide'.

The header is made invisible with an overlay.  With a prefix arg, show
an elided material again.

This is suitable as an entry on `find-file-hook' or appropriate mode hooks.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "elint" "emacs-lisp/elint.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/elint.el

(autoload 'elint-file "elint" "\
Lint the file FILE.

\(fn FILE)" t nil)

(autoload 'elint-directory "elint" "\
Lint all the .el files in DIRECTORY.
A complicated directory may require a lot of memory.

\(fn DIRECTORY)" t nil)

(autoload 'elint-current-buffer "elint" "\
Lint the current buffer.
If necessary, this first calls `elint-initialize'.

\(fn)" t nil)

(autoload 'elint-defun "elint" "\
Lint the function at point.
If necessary, this first calls `elint-initialize'.

\(fn)" t nil)

(autoload 'elint-initialize "elint" "\
Initialize elint.
If elint is already initialized, this does nothing, unless
optional prefix argument REINIT is non-nil.

\(fn &optional REINIT)" t nil)

;;;***

;;;### (autoloads nil "elp" "emacs-lisp/elp.el" (21710 25077 0 0))
;;; Generated autoloads from emacs-lisp/elp.el

(autoload 'elp-instrument-function "elp" "\
Instrument FUNSYM for profiling.
FUNSYM must be a symbol of a defined function.

\(fn FUNSYM)" t nil)

(autoload 'elp-instrument-list "elp" "\
Instrument, for profiling, all functions in `elp-function-list'.
Use optional LIST if provided instead.
If called interactively, read LIST using the minibuffer.

\(fn &optional LIST)" t nil)

(autoload 'elp-instrument-package "elp" "\
Instrument for profiling, all functions which start with PREFIX.
For example, to instrument all ELP functions, do the following:

    \\[elp-instrument-package] RET elp- RET

\(fn PREFIX)" t nil)

(autoload 'elp-results "elp" "\
Display current profiling results.
If `elp-reset-after-results' is non-nil, then current profiling
information for all instrumented functions is reset after results are
displayed.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "emacs-lock" "emacs-lock.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from emacs-lock.el

(autoload 'emacs-lock-mode "emacs-lock" "\
Toggle Emacs Lock mode in the current buffer.
If called with a plain prefix argument, ask for the locking mode
to be used.  With any other prefix ARG, turn mode on if ARG is
positive, off otherwise.  If called from Lisp, enable the mode if
ARG is omitted or nil.

Initially, if the user does not pass an explicit locking mode, it
defaults to `emacs-lock-default-locking-mode' (which see);
afterwards, the locking mode most recently set on the buffer is
used instead.

When called from Elisp code, ARG can be any locking mode:

 exit   -- Emacs cannot exit while the buffer is locked
 kill   -- the buffer cannot be killed, but Emacs can exit as usual
 all    -- the buffer is locked against both actions

Other values are interpreted as usual.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "emacsbug" "mail/emacsbug.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from mail/emacsbug.el

(autoload 'report-emacs-bug "emacsbug" "\
Report a bug in GNU Emacs.
Prompts for bug subject.  Leaves you in a mail buffer.

\(fn TOPIC &optional UNUSED)" t nil)

(set-advertised-calling-convention 'report-emacs-bug '(topic) '"24.5")

;;;***

;;;### (autoloads nil "emerge" "vc/emerge.el" (21788 61018 0 0))
;;; Generated autoloads from vc/emerge.el

(autoload 'emerge-files "emerge" "\
Run Emerge on two files.

\(fn ARG FILE-A FILE-B FILE-OUT &optional STARTUP-HOOKS QUIT-HOOKS)" t nil)

(autoload 'emerge-files-with-ancestor "emerge" "\
Run Emerge on two files, giving another file as the ancestor.

\(fn ARG FILE-A FILE-B FILE-ANCESTOR FILE-OUT &optional STARTUP-HOOKS QUIT-HOOKS)" t nil)

(autoload 'emerge-buffers "emerge" "\
Run Emerge on two buffers.

\(fn BUFFER-A BUFFER-B &optional STARTUP-HOOKS QUIT-HOOKS)" t nil)

(autoload 'emerge-buffers-with-ancestor "emerge" "\
Run Emerge on two buffers, giving another buffer as the ancestor.

\(fn BUFFER-A BUFFER-B BUFFER-ANCESTOR &optional STARTUP-HOOKS QUIT-HOOKS)" t nil)

(autoload 'emerge-files-command "emerge" "\


\(fn)" nil nil)

(autoload 'emerge-files-with-ancestor-command "emerge" "\


\(fn)" nil nil)

(autoload 'emerge-files-remote "emerge" "\


\(fn FILE-A FILE-B FILE-OUT)" nil nil)

(autoload 'emerge-files-with-ancestor-remote "emerge" "\


\(fn FILE-A FILE-B FILE-ANC FILE-OUT)" nil nil)

(autoload 'emerge-revisions "emerge" "\
Emerge two RCS revisions of a file.

\(fn ARG FILE REVISION-A REVISION-B &optional STARTUP-HOOKS QUIT-HOOKS)" t nil)

(autoload 'emerge-revisions-with-ancestor "emerge" "\
Emerge two RCS revisions of a file, with another revision as ancestor.

\(fn ARG FILE REVISION-A REVISION-B ANCESTOR &optional STARTUP-HOOKS QUIT-HOOKS)" t nil)

(autoload 'emerge-merge-directories "emerge" "\


\(fn A-DIR B-DIR ANCESTOR-DIR OUTPUT-DIR)" t nil)

;;;***

;;;### (autoloads nil "enriched" "textmodes/enriched.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from textmodes/enriched.el

(autoload 'enriched-mode "enriched" "\
Minor mode for editing text/enriched files.
These are files with embedded formatting information in the MIME standard
text/enriched format.

With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

Turning the mode on or off runs `enriched-mode-hook'.

More information about Enriched mode is available in the file
\"enriched.txt\" in `data-directory'.

Commands:

\\{enriched-mode-map}

\(fn &optional ARG)" t nil)

(autoload 'enriched-encode "enriched" "\


\(fn FROM TO ORIG-BUF)" nil nil)

(autoload 'enriched-decode "enriched" "\


\(fn FROM TO)" nil nil)

;;;***

;;;### (autoloads nil "epa" "epa.el" (21788 61018 0 0))
;;; Generated autoloads from epa.el

(autoload 'epa-list-keys "epa" "\
List all keys matched with NAME from the public keyring.

\(fn &optional NAME)" t nil)

(autoload 'epa-list-secret-keys "epa" "\
List all keys matched with NAME from the private keyring.

\(fn &optional NAME)" t nil)

(autoload 'epa-select-keys "epa" "\
Display a user's keyring and ask him to select keys.
CONTEXT is an epg-context.
PROMPT is a string to prompt with.
NAMES is a list of strings to be matched with keys.  If it is nil, all
the keys are listed.
If SECRET is non-nil, list secret keys instead of public keys.

\(fn CONTEXT PROMPT &optional NAMES SECRET)" nil nil)

(autoload 'epa-decrypt-file "epa" "\
Decrypt DECRYPT-FILE into PLAIN-FILE.
If you do not specify PLAIN-FILE, this functions prompts for the value to use.

\(fn DECRYPT-FILE &optional PLAIN-FILE)" t nil)

(autoload 'epa-verify-file "epa" "\
Verify FILE.

\(fn FILE)" t nil)

(autoload 'epa-sign-file "epa" "\
Sign FILE by SIGNERS keys selected.

\(fn FILE SIGNERS MODE)" t nil)

(autoload 'epa-encrypt-file "epa" "\
Encrypt FILE for RECIPIENTS.

\(fn FILE RECIPIENTS)" t nil)

(autoload 'epa-decrypt-region "epa" "\
Decrypt the current region between START and END.

If MAKE-BUFFER-FUNCTION is non-nil, call it to prepare an output buffer.
It should return that buffer.  If it copies the input, it should
delete the text now being decrypted.  It should leave point at the
proper place to insert the plaintext.

Be careful about using this command in Lisp programs!
Since this function operates on regions, it does some tricks such
as coding-system detection and unibyte/multibyte conversion.  If
you are sure how the data in the region should be treated, you
should consider using the string based counterpart
`epg-decrypt-string', or the file based counterpart
`epg-decrypt-file' instead.

For example:

\(let ((context (epg-make-context 'OpenPGP)))
  (decode-coding-string
    (epg-decrypt-string context (buffer-substring start end))
    'utf-8))

\(fn START END &optional MAKE-BUFFER-FUNCTION)" t nil)

(autoload 'epa-decrypt-armor-in-region "epa" "\
Decrypt OpenPGP armors in the current region between START and END.

Don't use this command in Lisp programs!
See the reason described in the `epa-decrypt-region' documentation.

\(fn START END)" t nil)

(autoload 'epa-verify-region "epa" "\
Verify the current region between START and END.

Don't use this command in Lisp programs!
Since this function operates on regions, it does some tricks such
as coding-system detection and unibyte/multibyte conversion.  If
you are sure how the data in the region should be treated, you
should consider using the string based counterpart
`epg-verify-string', or the file based counterpart
`epg-verify-file' instead.

For example:

\(let ((context (epg-make-context 'OpenPGP)))
  (decode-coding-string
    (epg-verify-string context (buffer-substring start end))
    'utf-8))

\(fn START END)" t nil)

(autoload 'epa-verify-cleartext-in-region "epa" "\
Verify OpenPGP cleartext signed messages in the current region
between START and END.

Don't use this command in Lisp programs!
See the reason described in the `epa-verify-region' documentation.

\(fn START END)" t nil)

(autoload 'epa-sign-region "epa" "\
Sign the current region between START and END by SIGNERS keys selected.

Don't use this command in Lisp programs!
Since this function operates on regions, it does some tricks such
as coding-system detection and unibyte/multibyte conversion.  If
you are sure how the data should be treated, you should consider
using the string based counterpart `epg-sign-string', or the file
based counterpart `epg-sign-file' instead.

For example:

\(let ((context (epg-make-context 'OpenPGP)))
  (epg-sign-string
    context
    (encode-coding-string (buffer-substring start end) 'utf-8)))

\(fn START END SIGNERS MODE)" t nil)

(autoload 'epa-encrypt-region "epa" "\
Encrypt the current region between START and END for RECIPIENTS.

Don't use this command in Lisp programs!
Since this function operates on regions, it does some tricks such
as coding-system detection and unibyte/multibyte conversion.  If
you are sure how the data should be treated, you should consider
using the string based counterpart `epg-encrypt-string', or the
file based counterpart `epg-encrypt-file' instead.

For example:

\(let ((context (epg-make-context 'OpenPGP)))
  (epg-encrypt-string
    context
    (encode-coding-string (buffer-substring start end) 'utf-8)
    nil))

\(fn START END RECIPIENTS SIGN SIGNERS)" t nil)

(autoload 'epa-delete-keys "epa" "\
Delete selected KEYS.

\(fn KEYS &optional ALLOW-SECRET)" t nil)

(autoload 'epa-import-keys "epa" "\
Import keys from FILE.

\(fn FILE)" t nil)

(autoload 'epa-import-keys-region "epa" "\
Import keys from the region.

\(fn START END)" t nil)

(autoload 'epa-import-armor-in-region "epa" "\
Import keys in the OpenPGP armor format in the current region
between START and END.

\(fn START END)" t nil)

(autoload 'epa-export-keys "epa" "\
Export selected KEYS to FILE.

\(fn KEYS FILE)" t nil)

(autoload 'epa-insert-keys "epa" "\
Insert selected KEYS after the point.

\(fn KEYS)" t nil)

;;;***

;;;### (autoloads nil "epa-dired" "epa-dired.el" (21710 25077 0 0))
;;; Generated autoloads from epa-dired.el

(autoload 'epa-dired-do-decrypt "epa-dired" "\
Decrypt marked files.

\(fn)" t nil)

(autoload 'epa-dired-do-verify "epa-dired" "\
Verify marked files.

\(fn)" t nil)

(autoload 'epa-dired-do-sign "epa-dired" "\
Sign marked files.

\(fn)" t nil)

(autoload 'epa-dired-do-encrypt "epa-dired" "\
Encrypt marked files.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "epa-file" "epa-file.el" (21788 61018 0 0))
;;; Generated autoloads from epa-file.el

(autoload 'epa-file-handler "epa-file" "\


\(fn OPERATION &rest ARGS)" nil nil)

(autoload 'epa-file-enable "epa-file" "\


\(fn)" t nil)

(autoload 'epa-file-disable "epa-file" "\


\(fn)" t nil)

;;;***

;;;### (autoloads nil "epa-mail" "epa-mail.el" (21788 61018 0 0))
;;; Generated autoloads from epa-mail.el

(autoload 'epa-mail-mode "epa-mail" "\
A minor-mode for composing encrypted/clearsigned mails.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

(autoload 'epa-mail-decrypt "epa-mail" "\
Decrypt OpenPGP armors in the current buffer.
The buffer is expected to contain a mail message.

Don't use this command in Lisp programs!

\(fn)" t nil)

(autoload 'epa-mail-verify "epa-mail" "\
Verify OpenPGP cleartext signed messages in the current buffer.
The buffer is expected to contain a mail message.

Don't use this command in Lisp programs!

\(fn)" t nil)

(autoload 'epa-mail-sign "epa-mail" "\
Sign the current buffer.
The buffer is expected to contain a mail message.

Don't use this command in Lisp programs!

\(fn START END SIGNERS MODE)" t nil)

(autoload 'epa-mail-encrypt "epa-mail" "\
Encrypt the outgoing mail message in the current buffer.
Takes the recipients from the text in the header in the buffer
and translates them through `epa-mail-aliases'.
With prefix argument, asks you to select among them interactively
and also whether and how to sign.

Called from Lisp, the optional argument RECIPIENTS is a list
of recipient addresses, t to perform symmetric encryption,
or nil meaning use the defaults.

SIGNERS is a list of keys to sign the message with.

\(fn &optional RECIPIENTS SIGNERS)" t nil)

(autoload 'epa-mail-import-keys "epa-mail" "\
Import keys in the OpenPGP armor format in the current buffer.
The buffer is expected to contain a mail message.

Don't use this command in Lisp programs!

\(fn)" t nil)

(defvar epa-global-mail-mode nil "\
Non-nil if Epa-Global-Mail mode is enabled.
See the command `epa-global-mail-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `epa-global-mail-mode'.")

(custom-autoload 'epa-global-mail-mode "epa-mail" nil)

(autoload 'epa-global-mail-mode "epa-mail" "\
Minor mode to hook EasyPG into Mail mode.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "epg" "epg.el" (21788 61018 0 0))
;;; Generated autoloads from epg.el
(push (purecopy '(epg 1 0 0)) package--builtin-versions)

(autoload 'epg-make-context "epg" "\
Return a context object.

\(fn &optional PROTOCOL ARMOR TEXTMODE INCLUDE-CERTS CIPHER-ALGORITHM DIGEST-ALGORITHM COMPRESS-ALGORITHM)" nil nil)

;;;***

;;;### (autoloads nil "epg-config" "epg-config.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from epg-config.el

(autoload 'epg-configuration "epg-config" "\
Return a list of internal configuration parameters of `epg-gpg-program'.

\(fn)" nil nil)

(autoload 'epg-check-configuration "epg-config" "\
Verify that a sufficient version of GnuPG is installed.

\(fn CONFIG &optional MINIMUM-VERSION)" nil nil)

(autoload 'epg-expand-group "epg-config" "\
Look at CONFIG and try to expand GROUP.

\(fn CONFIG GROUP)" nil nil)

;;;***

;;;### (autoloads nil "erc" "erc/erc.el" (21788 61018 0 0))
;;; Generated autoloads from erc/erc.el
(push (purecopy '(erc 5 3)) package--builtin-versions)

(autoload 'erc-select-read-args "erc" "\
Prompt the user for values of nick, server, port, and password.

\(fn)" nil nil)

(autoload 'erc "erc" "\
ERC is a powerful, modular, and extensible IRC client.
This function is the main entry point for ERC.

It permits you to select connection parameters, and then starts ERC.

Non-interactively, it takes the keyword arguments
   (server (erc-compute-server))
   (port   (erc-compute-port))
   (nick   (erc-compute-nick))
   password
   (full-name (erc-compute-full-name)))

That is, if called with

   (erc :server \"irc.freenode.net\" :full-name \"Harry S Truman\")

then the server and full-name will be set to those values, whereas
`erc-compute-port', `erc-compute-nick' and `erc-compute-full-name' will
be invoked for the values of the other parameters.

\(fn &key (server (erc-compute-server)) (port (erc-compute-port)) (nick (erc-compute-nick)) PASSWORD (full-name (erc-compute-full-name)))" t nil)

(defalias 'erc-select 'erc)

(autoload 'erc-tls "erc" "\
Interactively select TLS connection parameters and run ERC.
Arguments are the same as for `erc'.

\(fn &rest R)" t nil)

(autoload 'erc-handle-irc-url "erc" "\
Use ERC to IRC on HOST:PORT in CHANNEL as USER with PASSWORD.
If ERC is already connected to HOST:PORT, simply /join CHANNEL.
Otherwise, connect to HOST:PORT as USER and /join CHANNEL.

\(fn HOST PORT CHANNEL USER PASSWORD)" nil nil)

;;;***

;;;### (autoloads nil "erc-autoaway" "erc/erc-autoaway.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from erc/erc-autoaway.el
 (autoload 'erc-autoaway-mode "erc-autoaway")

;;;***

;;;### (autoloads nil "erc-button" "erc/erc-button.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-button.el
 (autoload 'erc-button-mode "erc-button" nil t)

;;;***

;;;### (autoloads nil "erc-capab" "erc/erc-capab.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-capab.el
 (autoload 'erc-capab-identify-mode "erc-capab" nil t)

;;;***

;;;### (autoloads nil "erc-compat" "erc/erc-compat.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-compat.el
 (autoload 'erc-define-minor-mode "erc-compat")

;;;***

;;;### (autoloads nil "erc-dcc" "erc/erc-dcc.el" (21788 61018 0 0))
;;; Generated autoloads from erc/erc-dcc.el
 (autoload 'erc-dcc-mode "erc-dcc")

(autoload 'erc-cmd-DCC "erc-dcc" "\
Parser for /dcc command.
This figures out the dcc subcommand and calls the appropriate routine to
handle it.  The function dispatched should be named \"erc-dcc-do-FOO-command\",
where FOO is one of CLOSE, GET, SEND, LIST, CHAT, etc.

\(fn CMD &rest ARGS)" nil nil)

(autoload 'pcomplete/erc-mode/DCC "erc-dcc" "\
Provides completion for the /DCC command.

\(fn)" nil nil)

(defvar erc-ctcp-query-DCC-hook '(erc-ctcp-query-DCC) "\
Hook variable for CTCP DCC queries.")

(autoload 'erc-ctcp-query-DCC "erc-dcc" "\
The function called when a CTCP DCC request is detected by the client.
It examines the DCC subcommand, and calls the appropriate routine for
that subcommand.

\(fn PROC NICK LOGIN HOST TO QUERY)" nil nil)

;;;***

;;;### (autoloads nil "erc-desktop-notifications" "erc/erc-desktop-notifications.el"
;;;;;;  (21788 61018 0 0))
;;; Generated autoloads from erc/erc-desktop-notifications.el
(autoload 'erc-notifications-mode "erc-desktop-notifications" "" t)

;;;***

;;;### (autoloads nil "erc-ezbounce" "erc/erc-ezbounce.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from erc/erc-ezbounce.el

(autoload 'erc-cmd-ezb "erc-ezbounce" "\
Send EZB commands to the EZBouncer verbatim.

\(fn LINE &optional FORCE)" nil nil)

(autoload 'erc-ezb-get-login "erc-ezbounce" "\
Return an appropriate EZBounce login for SERVER and PORT.
Look up entries in `erc-ezb-login-alist'. If the username or password
in the alist is `nil', prompt for the appropriate values.

\(fn SERVER PORT)" nil nil)

(autoload 'erc-ezb-lookup-action "erc-ezbounce" "\


\(fn MESSAGE)" nil nil)

(autoload 'erc-ezb-notice-autodetect "erc-ezbounce" "\
React on an EZBounce NOTICE request.

\(fn PROC PARSED)" nil nil)

(autoload 'erc-ezb-identify "erc-ezbounce" "\
Identify to the EZBouncer server.

\(fn MESSAGE)" nil nil)

(autoload 'erc-ezb-init-session-list "erc-ezbounce" "\
Reset the EZBounce session list to nil.

\(fn MESSAGE)" nil nil)

(autoload 'erc-ezb-end-of-session-list "erc-ezbounce" "\
Indicate the end of the EZBounce session listing.

\(fn MESSAGE)" nil nil)

(autoload 'erc-ezb-add-session "erc-ezbounce" "\
Add an EZBounce session to the session list.

\(fn MESSAGE)" nil nil)

(autoload 'erc-ezb-select "erc-ezbounce" "\
Select an IRC server to use by EZBounce, in ERC style.

\(fn MESSAGE)" nil nil)

(autoload 'erc-ezb-select-session "erc-ezbounce" "\
Select a detached EZBounce session.

\(fn)" nil nil)

(autoload 'erc-ezb-initialize "erc-ezbounce" "\
Add EZBouncer convenience functions to ERC.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "erc-fill" "erc/erc-fill.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from erc/erc-fill.el
 (autoload 'erc-fill-mode "erc-fill" nil t)

(autoload 'erc-fill "erc-fill" "\
Fill a region using the function referenced in `erc-fill-function'.
You can put this on `erc-insert-modify-hook' and/or `erc-send-modify-hook'.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "erc-identd" "erc/erc-identd.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-identd.el
 (autoload 'erc-identd-mode "erc-identd")

(autoload 'erc-identd-start "erc-identd" "\
Start an identd server listening to port 8113.
Port 113 (auth) will need to be redirected to port 8113 on your
machine -- using iptables, or a program like redir which can be
run from inetd.  The idea is to provide a simple identd server
when you need one, without having to install one globally on your
system.

\(fn &optional PORT)" t nil)

(autoload 'erc-identd-stop "erc-identd" "\


\(fn &rest IGNORE)" t nil)

;;;***

;;;### (autoloads nil "erc-imenu" "erc/erc-imenu.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-imenu.el

(autoload 'erc-create-imenu-index "erc-imenu" "\


\(fn)" nil nil)

;;;***

;;;### (autoloads nil "erc-join" "erc/erc-join.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from erc/erc-join.el
 (autoload 'erc-autojoin-mode "erc-join" nil t)

;;;***

;;;### (autoloads nil "erc-list" "erc/erc-list.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from erc/erc-list.el
 (autoload 'erc-list-mode "erc-list")

;;;***

;;;### (autoloads nil "erc-log" "erc/erc-log.el" (21710 25077 0 0))
;;; Generated autoloads from erc/erc-log.el
 (autoload 'erc-log-mode "erc-log" nil t)

(autoload 'erc-logging-enabled "erc-log" "\
Return non-nil if logging is enabled for BUFFER.
If BUFFER is nil, the value of `current-buffer' is used.
Logging is enabled if `erc-log-channels-directory' is non-nil, the directory
is writable (it will be created as necessary) and
`erc-enable-logging' returns a non-nil value.

\(fn &optional BUFFER)" nil nil)

(autoload 'erc-save-buffer-in-logs "erc-log" "\
Append BUFFER contents to the log file, if logging is enabled.
If BUFFER is not provided, current buffer is used.
Logging is enabled if `erc-logging-enabled' returns non-nil.

This is normally done on exit, to save the unsaved portion of the
buffer, since only the text that runs off the buffer limit is logged
automatically.

You can save every individual message by putting this function on
`erc-insert-post-hook'.

\(fn &optional BUFFER)" t nil)

;;;***

;;;### (autoloads nil "erc-match" "erc/erc-match.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-match.el
 (autoload 'erc-match-mode "erc-match")

(autoload 'erc-add-pal "erc-match" "\
Add pal interactively to `erc-pals'.

\(fn)" t nil)

(autoload 'erc-delete-pal "erc-match" "\
Delete pal interactively to `erc-pals'.

\(fn)" t nil)

(autoload 'erc-add-fool "erc-match" "\
Add fool interactively to `erc-fools'.

\(fn)" t nil)

(autoload 'erc-delete-fool "erc-match" "\
Delete fool interactively to `erc-fools'.

\(fn)" t nil)

(autoload 'erc-add-keyword "erc-match" "\
Add keyword interactively to `erc-keywords'.

\(fn)" t nil)

(autoload 'erc-delete-keyword "erc-match" "\
Delete keyword interactively to `erc-keywords'.

\(fn)" t nil)

(autoload 'erc-add-dangerous-host "erc-match" "\
Add dangerous-host interactively to `erc-dangerous-hosts'.

\(fn)" t nil)

(autoload 'erc-delete-dangerous-host "erc-match" "\
Delete dangerous-host interactively to `erc-dangerous-hosts'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "erc-menu" "erc/erc-menu.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from erc/erc-menu.el
 (autoload 'erc-menu-mode "erc-menu" nil t)

;;;***

;;;### (autoloads nil "erc-netsplit" "erc/erc-netsplit.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from erc/erc-netsplit.el
 (autoload 'erc-netsplit-mode "erc-netsplit")

(autoload 'erc-cmd-WHOLEFT "erc-netsplit" "\
Show who's gone.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "erc-networks" "erc/erc-networks.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from erc/erc-networks.el

(autoload 'erc-determine-network "erc-networks" "\
Return the name of the network or \"Unknown\" as a symbol.  Use the
server parameter NETWORK if provided, otherwise parse the server name and
search for a match in `erc-networks-alist'.

\(fn)" nil nil)

(autoload 'erc-server-select "erc-networks" "\
Interactively select a server to connect to using `erc-server-alist'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "erc-notify" "erc/erc-notify.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-notify.el
 (autoload 'erc-notify-mode "erc-notify" nil t)

(autoload 'erc-cmd-NOTIFY "erc-notify" "\
Change `erc-notify-list' or list current notify-list members online.
Without args, list the current list of notified people online,
with args, toggle notify status of people.

\(fn &rest ARGS)" nil nil)

(autoload 'pcomplete/erc-mode/NOTIFY "erc-notify" "\


\(fn)" nil nil)

;;;***

;;;### (autoloads nil "erc-page" "erc/erc-page.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from erc/erc-page.el
 (autoload 'erc-page-mode "erc-page")

;;;***

;;;### (autoloads nil "erc-pcomplete" "erc/erc-pcomplete.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from erc/erc-pcomplete.el
 (autoload 'erc-completion-mode "erc-pcomplete" nil t)

;;;***

;;;### (autoloads nil "erc-replace" "erc/erc-replace.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-replace.el
 (autoload 'erc-replace-mode "erc-replace")

;;;***

;;;### (autoloads nil "erc-ring" "erc/erc-ring.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from erc/erc-ring.el
 (autoload 'erc-ring-mode "erc-ring" nil t)

;;;***

;;;### (autoloads nil "erc-services" "erc/erc-services.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from erc/erc-services.el
 (autoload 'erc-services-mode "erc-services" nil t)

(autoload 'erc-nickserv-identify-mode "erc-services" "\
Set up hooks according to which MODE the user has chosen.

\(fn MODE)" t nil)

(autoload 'erc-nickserv-identify "erc-services" "\
Send an \"identify <PASSWORD>\" message to NickServ.
When called interactively, read the password using `read-passwd'.

\(fn PASSWORD)" t nil)

;;;***

;;;### (autoloads nil "erc-sound" "erc/erc-sound.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-sound.el
 (autoload 'erc-sound-mode "erc-sound")

;;;***

;;;### (autoloads nil "erc-speedbar" "erc/erc-speedbar.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from erc/erc-speedbar.el

(autoload 'erc-speedbar-browser "erc-speedbar" "\
Initialize speedbar to display an ERC browser.
This will add a speedbar major display mode.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "erc-spelling" "erc/erc-spelling.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from erc/erc-spelling.el
 (autoload 'erc-spelling-mode "erc-spelling" nil t)

;;;***

;;;### (autoloads nil "erc-stamp" "erc/erc-stamp.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-stamp.el
 (autoload 'erc-timestamp-mode "erc-stamp" nil t)

;;;***

;;;### (autoloads nil "erc-track" "erc/erc-track.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from erc/erc-track.el

(defvar erc-track-minor-mode nil "\
Non-nil if Erc-Track minor mode is enabled.
See the command `erc-track-minor-mode' for a description of this minor mode.")

(custom-autoload 'erc-track-minor-mode "erc-track" nil)

(autoload 'erc-track-minor-mode "erc-track" "\
Toggle mode line display of ERC activity (ERC Track minor mode).
With a prefix argument ARG, enable ERC Track minor mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

ERC Track minor mode is a global minor mode.  It exists for the
sole purpose of providing the C-c C-SPC and C-c C-@ keybindings.
Make sure that you have enabled the track module, otherwise the
keybindings will not do anything useful.

\(fn &optional ARG)" t nil)
 (autoload 'erc-track-mode "erc-track" nil t)

;;;***

;;;### (autoloads nil "erc-truncate" "erc/erc-truncate.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from erc/erc-truncate.el
 (autoload 'erc-truncate-mode "erc-truncate" nil t)

(autoload 'erc-truncate-buffer-to-size "erc-truncate" "\
Truncates the buffer to the size SIZE.
If BUFFER is not provided, the current buffer is assumed.  The deleted
region is logged if `erc-logging-enabled' returns non-nil.

\(fn SIZE &optional BUFFER)" nil nil)

(autoload 'erc-truncate-buffer "erc-truncate" "\
Truncates the current buffer to `erc-max-buffer-size'.
Meant to be used in hooks, like `erc-insert-post-hook'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "erc-xdcc" "erc/erc-xdcc.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from erc/erc-xdcc.el
 (autoload 'erc-xdcc-mode "erc-xdcc")

(autoload 'erc-xdcc-add-file "erc-xdcc" "\
Add a file to `erc-xdcc-files'.

\(fn FILE)" t nil)

;;;***

;;;### (autoloads nil "ert" "emacs-lisp/ert.el" (21788 61018 0 0))
;;; Generated autoloads from emacs-lisp/ert.el

(autoload 'ert-deftest "ert" "\
Define NAME (a symbol) as a test.

BODY is evaluated as a `progn' when the test is run.  It should
signal a condition on failure or just return if the test passes.

`should', `should-not', `should-error' and `skip-unless' are
useful for assertions in BODY.

Use `ert' to run tests interactively.

Tests that are expected to fail can be marked as such
using :expected-result.  See `ert-test-result-type-p' for a
description of valid values for RESULT-TYPE.

\(fn NAME () [DOCSTRING] [:expected-result RESULT-TYPE] [:tags '(TAG...)] BODY...)" nil (quote macro))

(put 'ert-deftest 'lisp-indent-function 2)

(put 'ert-info 'lisp-indent-function 1)

(autoload 'ert-run-tests-batch "ert" "\
Run the tests specified by SELECTOR, printing results to the terminal.

SELECTOR works as described in `ert-select-tests', except if
SELECTOR is nil, in which case all tests rather than none will be
run; this makes the command line \"emacs -batch -l my-tests.el -f
ert-run-tests-batch-and-exit\" useful.

Returns the stats object.

\(fn &optional SELECTOR)" nil nil)

(autoload 'ert-run-tests-batch-and-exit "ert" "\
Like `ert-run-tests-batch', but exits Emacs when done.

The exit status will be 0 if all test results were as expected, 1
on unexpected results, or 2 if the tool detected an error outside
of the tests (e.g. invalid SELECTOR or bug in the code that runs
the tests).

\(fn &optional SELECTOR)" nil nil)

(autoload 'ert-run-tests-interactively "ert" "\
Run the tests specified by SELECTOR and display the results in a buffer.

SELECTOR works as described in `ert-select-tests'.
OUTPUT-BUFFER-NAME and MESSAGE-FN should normally be nil; they
are used for automated self-tests and specify which buffer to use
and how to display message.

\(fn SELECTOR &optional OUTPUT-BUFFER-NAME MESSAGE-FN)" t nil)

(defalias 'ert 'ert-run-tests-interactively)

(autoload 'ert-describe-test "ert" "\
Display the documentation for TEST-OR-TEST-NAME (a symbol or ert-test).

\(fn TEST-OR-TEST-NAME)" t nil)

;;;***

;;;### (autoloads nil "ert-x" "emacs-lisp/ert-x.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/ert-x.el

(put 'ert-with-test-buffer 'lisp-indent-function 1)

(autoload 'ert-kill-all-test-buffers "ert-x" "\
Kill all test buffers that are still live.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "esh-mode" "eshell/esh-mode.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from eshell/esh-mode.el

(autoload 'eshell-mode "esh-mode" "\
Emacs shell interactive mode.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "eshell" "eshell/eshell.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from eshell/eshell.el
(push (purecopy '(eshell 2 4 2)) package--builtin-versions)

(autoload 'eshell "eshell" "\
Create an interactive Eshell buffer.
The buffer used for Eshell sessions is determined by the value of
`eshell-buffer-name'.  If there is already an Eshell session active in
that buffer, Emacs will simply switch to it.  Otherwise, a new session
will begin.  A numeric prefix arg (as in `C-u 42 M-x eshell RET')
switches to the session with that number, creating it if necessary.  A
nonnumeric prefix arg means to create a new session.  Returns the
buffer selected (or created).

\(fn &optional ARG)" t nil)

(autoload 'eshell-command "eshell" "\
Execute the Eshell command string COMMAND.
With prefix ARG, insert output into the current buffer at point.

\(fn &optional COMMAND ARG)" t nil)

(autoload 'eshell-command-result "eshell" "\
Execute the given Eshell COMMAND, and return the result.
The result might be any Lisp object.
If STATUS-VAR is a symbol, it will be set to the exit status of the
command.  This is the only way to determine whether the value returned
corresponding to a successful execution.

\(fn COMMAND &optional STATUS-VAR)" nil nil)

(define-obsolete-function-alias 'eshell-report-bug 'report-emacs-bug "23.1")

;;;***

;;;### (autoloads nil "etags" "progmodes/etags.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from progmodes/etags.el

(defvar tags-file-name nil "\
File name of tags table.
To switch to a new tags table, setting this variable is sufficient.
If you set this variable, do not also set `tags-table-list'.
Use the `etags' program to make a tags table file.")
 (put 'tags-file-name 'variable-interactive (purecopy "fVisit tags table: "))
 (put 'tags-file-name 'safe-local-variable 'stringp)

(defvar tags-case-fold-search 'default "\
Whether tags operations should be case-sensitive.
A value of t means case-insensitive, a value of nil means case-sensitive.
Any other value means use the setting of `case-fold-search'.")

(custom-autoload 'tags-case-fold-search "etags" t)

(defvar tags-table-list nil "\
List of file names of tags tables to search.
An element that is a directory means the file \"TAGS\" in that directory.
To switch to a new list of tags tables, setting this variable is sufficient.
If you set this variable, do not also set `tags-file-name'.
Use the `etags' program to make a tags table file.")

(custom-autoload 'tags-table-list "etags" t)

(defvar tags-compression-info-list (purecopy '("" ".Z" ".bz2" ".gz" ".xz" ".tgz")) "\
List of extensions tried by etags when `auto-compression-mode' is on.
An empty string means search the non-compressed file.")

(custom-autoload 'tags-compression-info-list "etags" t)

(defvar tags-add-tables 'ask-user "\
Control whether to add a new tags table to the current list.
t means do; nil means don't (always start a new list).
Any other value means ask the user whether to add a new tags table
to the current list (as opposed to starting a new list).")

(custom-autoload 'tags-add-tables "etags" t)

(defvar find-tag-hook nil "\
Hook to be run by \\[find-tag] after finding a tag.  See `run-hooks'.
The value in the buffer in which \\[find-tag] is done is used,
not the value in the buffer \\[find-tag] goes to.")

(custom-autoload 'find-tag-hook "etags" t)

(defvar find-tag-default-function nil "\
A function of no arguments used by \\[find-tag] to pick a default tag.
If nil, and the symbol that is the value of `major-mode'
has a `find-tag-default-function' property (see `put'), that is used.
Otherwise, `find-tag-default' is used.")

(custom-autoload 'find-tag-default-function "etags" t)

(autoload 'tags-table-mode "etags" "\
Major mode for tags table file buffers.

\(fn)" t nil)

(autoload 'visit-tags-table "etags" "\
Tell tags commands to use tags table file FILE.
FILE should be the name of a file created with the `etags' program.
A directory name is ok too; it means file TAGS in that directory.

Normally \\[visit-tags-table] sets the global value of `tags-file-name'.
With a prefix arg, set the buffer-local value instead.
When you find a tag with \\[find-tag], the buffer it finds the tag
in is given a local value of this variable which is the name of the tags
file the tag was in.

\(fn FILE &optional LOCAL)" t nil)

(autoload 'visit-tags-table-buffer "etags" "\
Select the buffer containing the current tags table.
If optional arg is a string, visit that file as a tags table.
If optional arg is t, visit the next table in `tags-table-list'.
If optional arg is the atom `same', don't look for a new table;
 just select the buffer visiting `tags-file-name'.
If arg is nil or absent, choose a first buffer from information in
 `tags-file-name', `tags-table-list', `tags-table-list-pointer'.
Returns t if it visits a tags table, or nil if there are no more in the list.

\(fn &optional CONT)" nil nil)

(autoload 'tags-table-files "etags" "\
Return a list of files in the current tags table.
Assumes the tags table is the current buffer.  The file names are returned
as they appeared in the `etags' command that created the table, usually
without directory names.

\(fn)" nil nil)
 (defun tags-completion-at-point-function ()
  (if (or tags-table-list tags-file-name)
      (progn
        (load "etags")
        (tags-completion-at-point-function))))

(autoload 'find-tag-noselect "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Returns the buffer containing the tag's definition and moves its point there,
but does not select the buffer.
The default for TAGNAME is the expression in the buffer near point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is the atom `-' (interactively, with prefix arg that is a negative number
or just \\[negative-argument]), pop back to the previous tag gone to.

If third arg REGEXP-P is non-nil, treat TAGNAME as a regexp.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

\(fn TAGNAME &optional NEXT-P REGEXP-P)" t nil)

(autoload 'find-tag "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Select the buffer containing the tag's definition, and move point there.
The default for TAGNAME is the expression in the buffer around or before point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is the atom `-' (interactively, with prefix arg that is a negative number
or just \\[negative-argument]), pop back to the previous tag gone to.

If third arg REGEXP-P is non-nil, treat TAGNAME as a regexp.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

\(fn TAGNAME &optional NEXT-P REGEXP-P)" t nil)
 (define-key esc-map "." 'find-tag)

(autoload 'find-tag-other-window "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Select the buffer containing the tag's definition in another window, and
move point there.  The default for TAGNAME is the expression in the buffer
around or before point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is negative (interactively, with prefix arg that is a negative number or
just \\[negative-argument]), pop back to the previous tag gone to.

If third arg REGEXP-P is non-nil, treat TAGNAME as a regexp.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

\(fn TAGNAME &optional NEXT-P REGEXP-P)" t nil)
 (define-key ctl-x-4-map "." 'find-tag-other-window)

(autoload 'find-tag-other-frame "etags" "\
Find tag (in current tags table) whose name contains TAGNAME.
Select the buffer containing the tag's definition in another frame, and
move point there.  The default for TAGNAME is the expression in the buffer
around or before point.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is negative (interactively, with prefix arg that is a negative number or
just \\[negative-argument]), pop back to the previous tag gone to.

If third arg REGEXP-P is non-nil, treat TAGNAME as a regexp.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

\(fn TAGNAME &optional NEXT-P)" t nil)
 (define-key ctl-x-5-map "." 'find-tag-other-frame)

(autoload 'find-tag-regexp "etags" "\
Find tag (in current tags table) whose name matches REGEXP.
Select the buffer containing the tag's definition and move point there.

If second arg NEXT-P is t (interactively, with prefix arg), search for
another tag that matches the last tagname or regexp used.  When there are
multiple matches for a tag, more exact matches are found first.  If NEXT-P
is negative (interactively, with prefix arg that is a negative number or
just \\[negative-argument]), pop back to the previous tag gone to.

If third arg OTHER-WINDOW is non-nil, select the buffer in another window.

A marker representing the point when this command is invoked is pushed
onto a ring and may be popped back to with \\[pop-tag-mark].
Contrast this with the ring of marks gone to by the command.

See documentation of variable `tags-file-name'.

\(fn REGEXP &optional NEXT-P OTHER-WINDOW)" t nil)
 (define-key esc-map [?\C-.] 'find-tag-regexp)
 (define-key esc-map "*" 'pop-tag-mark)

(autoload 'pop-tag-mark "etags" "\
Pop back to where \\[find-tag] was last invoked.

This is distinct from invoking \\[find-tag] with a negative argument
since that pops a stack of markers at which tags were found, not from
where they were found.

\(fn)" t nil)

(autoload 'next-file "etags" "\
Select next file among files in current tags table.

A first argument of t (prefix arg, if interactive) initializes to the
beginning of the list of files in the tags table.  If the argument is
neither nil nor t, it is evalled to initialize the list of files.

Non-nil second argument NOVISIT means use a temporary buffer
 to save time and avoid uninteresting warnings.

Value is nil if the file was already visited;
if the file was newly read in, the value is the filename.

\(fn &optional INITIALIZE NOVISIT)" t nil)

(autoload 'tags-loop-continue "etags" "\
Continue last \\[tags-search] or \\[tags-query-replace] command.
Used noninteractively with non-nil argument to begin such a command (the
argument is passed to `next-file', which see).

Two variables control the processing we do on each file: the value of
`tags-loop-scan' is a form to be executed on each file to see if it is
interesting (it returns non-nil if so) and `tags-loop-operate' is a form to
evaluate to operate on an interesting file.  If the latter evaluates to
nil, we exit; otherwise we scan the next file.

\(fn &optional FIRST-TIME)" t nil)
 (define-key esc-map "," 'tags-loop-continue)

(autoload 'tags-search "etags" "\
Search through all files listed in tags table for match for REGEXP.
Stops when a match is found.
To continue searching for next match, use command \\[tags-loop-continue].

If FILE-LIST-FORM is non-nil, it should be a form that, when
evaluated, will return a list of file names.  The search will be
restricted to these files.

Also see the documentation of the `tags-file-name' variable.

\(fn REGEXP &optional FILE-LIST-FORM)" t nil)

(autoload 'tags-query-replace "etags" "\
Do `query-replace-regexp' of FROM with TO on all files listed in tags table.
Third arg DELIMITED (prefix arg) means replace only word-delimited matches.
If you exit (\\[keyboard-quit], RET or q), you can resume the query replace
with the command \\[tags-loop-continue].
Fourth arg FILE-LIST-FORM non-nil means initialize the replacement loop.
Fifth and sixth arguments START and END are accepted, for compatibility
with `query-replace-regexp', and ignored.

If FILE-LIST-FORM is non-nil, it is a form to evaluate to
produce the list of files to search.

See also the documentation of the variable `tags-file-name'.

\(fn FROM TO &optional DELIMITED FILE-LIST-FORM)" t nil)

(autoload 'list-tags "etags" "\
Display list of tags in file FILE.
This searches only the first table in the list, and no included tables.
FILE should be as it appeared in the `etags' command, usually without a
directory specification.

\(fn FILE &optional NEXT-MATCH)" t nil)

(autoload 'tags-apropos "etags" "\
Display list of all tags in tags table REGEXP matches.

\(fn REGEXP)" t nil)

(autoload 'select-tags-table "etags" "\
Select a tags table file from a menu of those you have already used.
The list of tags tables to select from is stored in `tags-table-set-list';
see the doc of that variable if you want to add names to the list.

\(fn)" t nil)

(autoload 'complete-tag "etags" "\
Perform tags completion on the text around point.
Completes to the set of names listed in the current tags table.
The string to complete is chosen in the same way as the default
for \\[find-tag] (which see).

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ethio-util" "language/ethio-util.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from language/ethio-util.el

(autoload 'setup-ethiopic-environment-internal "ethio-util" "\


\(fn)" nil nil)

(autoload 'ethio-sera-to-fidel-buffer "ethio-util" "\
Convert the current buffer from SERA to FIDEL.

The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 1st optional argument SECONDARY is non-nil, assume the
buffer begins with the secondary language; otherwise with the
primary language.

If the 2nd optional argument FORCE is non-nil, perform conversion
even if the buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon' and `ethio-use-three-dot-question'.

\(fn &optional SECONDARY FORCE)" t nil)

(autoload 'ethio-sera-to-fidel-region "ethio-util" "\
Convert the characters in region from SERA to FIDEL.

The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 3rd argument SECONDARY is given and non-nil, assume the
region begins with the secondary language; otherwise with the
primary language.

If the 4th argument FORCE is given and non-nil, perform
conversion even if the buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon' and `ethio-use-three-dot-question'.

\(fn BEGIN END &optional SECONDARY FORCE)" t nil)

(autoload 'ethio-sera-to-fidel-marker "ethio-util" "\
Convert the regions surrounded by \"<sera>\" and \"</sera>\" from SERA to FIDEL.
Assume that each region begins with `ethio-primary-language'.
The markers \"<sera>\" and \"</sera>\" themselves are not deleted.

\(fn &optional FORCE)" t nil)

(autoload 'ethio-fidel-to-sera-buffer "ethio-util" "\
Replace all the FIDEL characters in the current buffer to the SERA format.
The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 1st optional argument SECONDARY is non-nil, try to convert the
region so that it begins with the secondary language; otherwise with the
primary language.

If the 2nd optional argument FORCE is non-nil, convert even if the
buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon', `ethio-use-three-dot-question',
`ethio-quote-vowel-always' and `ethio-numeric-reduction'.

\(fn &optional SECONDARY FORCE)" t nil)

(autoload 'ethio-fidel-to-sera-region "ethio-util" "\
Replace all the FIDEL characters in the region to the SERA format.

The variable `ethio-primary-language' specifies the primary
language and `ethio-secondary-language' specifies the secondary.

If the 3rd argument SECONDARY is given and non-nil, convert
the region so that it begins with the secondary language; otherwise with
the primary language.

If the 4th argument FORCE is given and non-nil, convert even if the
buffer is read-only.

See also the descriptions of the variables
`ethio-use-colon-for-colon', `ethio-use-three-dot-question',
`ethio-quote-vowel-always' and `ethio-numeric-reduction'.

\(fn BEGIN END &optional SECONDARY FORCE)" t nil)

(autoload 'ethio-fidel-to-sera-marker "ethio-util" "\
Convert the regions surrounded by \"<sera>\" and \"</sera>\" from FIDEL to SERA.
The markers \"<sera>\" and \"</sera>\" themselves are not deleted.

\(fn &optional FORCE)" t nil)

(autoload 'ethio-modify-vowel "ethio-util" "\
Modify the vowel of the FIDEL that is under the cursor.

\(fn)" t nil)

(autoload 'ethio-replace-space "ethio-util" "\
Replace ASCII spaces with Ethiopic word separators in the region.

In the specified region, replace word separators surrounded by two
Ethiopic characters, depending on the first argument CH, which should
be 1, 2, or 3.

If CH = 1, word separator will be replaced with an ASCII space.
If CH = 2, with two ASCII spaces.
If CH = 3, with the Ethiopic colon-like word separator.

The 2nd and 3rd arguments BEGIN and END specify the region.

\(fn CH BEGIN END)" t nil)

(autoload 'ethio-input-special-character "ethio-util" "\
This function is deprecated.

\(fn ARG)" t nil)

(autoload 'ethio-fidel-to-tex-buffer "ethio-util" "\
Convert each fidel characters in the current buffer into a fidel-tex command.

\(fn)" t nil)

(autoload 'ethio-tex-to-fidel-buffer "ethio-util" "\
Convert fidel-tex commands in the current buffer into fidel chars.

\(fn)" t nil)

(autoload 'ethio-fidel-to-java-buffer "ethio-util" "\
Convert Ethiopic characters into the Java escape sequences.

Each escape sequence is of the form \\uXXXX, where XXXX is the
character's codepoint (in hex) in Unicode.

If `ethio-java-save-lowercase' is non-nil, use [0-9a-f].
Otherwise, [0-9A-F].

\(fn)" nil nil)

(autoload 'ethio-java-to-fidel-buffer "ethio-util" "\
Convert the Java escape sequences into corresponding Ethiopic characters.

\(fn)" nil nil)

(autoload 'ethio-find-file "ethio-util" "\
Transliterate file content into Ethiopic depending on filename suffix.

\(fn)" nil nil)

(autoload 'ethio-write-file "ethio-util" "\
Transliterate Ethiopic characters in ASCII depending on the file extension.

\(fn)" nil nil)

(autoload 'ethio-insert-ethio-space "ethio-util" "\
Insert the Ethiopic word delimiter (the colon-like character).
With ARG, insert that many delimiters.

\(fn ARG)" t nil)

(autoload 'ethio-composition-function "ethio-util" "\


\(fn POS TO FONT-OBJECT STRING)" nil nil)

;;;***

;;;### (autoloads nil "eudc" "net/eudc.el" (21788 61018 0 0))
;;; Generated autoloads from net/eudc.el

(autoload 'eudc-set-server "eudc" "\
Set the directory server to SERVER using PROTOCOL.
Unless NO-SAVE is non-nil, the server is saved as the default
server for future sessions.

\(fn SERVER PROTOCOL &optional NO-SAVE)" t nil)

(autoload 'eudc-get-email "eudc" "\
Get the email field of NAME from the directory server.
If ERROR is non-nil, report an error if there is none.

\(fn NAME &optional ERROR)" t nil)

(autoload 'eudc-get-phone "eudc" "\
Get the phone field of NAME from the directory server.
If ERROR is non-nil, report an error if there is none.

\(fn NAME &optional ERROR)" t nil)

(autoload 'eudc-expand-inline "eudc" "\
Query the directory server, and expand the query string before point.
The query string consists of the buffer substring from the point back to
the preceding comma, colon or beginning of line.
The variable `eudc-inline-query-format' controls how to associate the
individual inline query words with directory attribute names.
After querying the server for the given string, the expansion specified by
`eudc-inline-expansion-format' is inserted in the buffer at point.
If REPLACE is non-nil, then this expansion replaces the name in the buffer.
`eudc-expansion-overwrites-query' being non-nil inverts the meaning of REPLACE.
Multiple servers can be tried with the same query until one finds a match,
see `eudc-inline-expansion-servers'

\(fn &optional REPLACE)" t nil)

(autoload 'eudc-query-form "eudc" "\
Display a form to query the directory server.
If given a non-nil argument GET-FIELDS-FROM-SERVER, the function first
queries the server for the existing fields and displays a corresponding form.

\(fn &optional GET-FIELDS-FROM-SERVER)" t nil)

(autoload 'eudc-load-eudc "eudc" "\
Load the Emacs Unified Directory Client.
This does nothing except loading eudc by autoload side-effect.

\(fn)" t nil)

(cond ((not (featurep 'xemacs)) (defvar eudc-tools-menu (let ((map (make-sparse-keymap "Directory Search"))) (define-key map [phone] `(menu-item ,(purecopy "Get Phone") eudc-get-phone :help ,(purecopy "Get the phone field of name from the directory server"))) (define-key map [email] `(menu-item ,(purecopy "Get Email") eudc-get-email :help ,(purecopy "Get the email field of NAME from the directory server"))) (define-key map [separator-eudc-email] menu-bar-separator) (define-key map [expand-inline] `(menu-item ,(purecopy "Expand Inline Query") eudc-expand-inline :help ,(purecopy "Query the directory server, and expand the query string before point"))) (define-key map [query] `(menu-item ,(purecopy "Query with Form") eudc-query-form :help ,(purecopy "Display a form to query the directory server"))) (define-key map [separator-eudc-query] menu-bar-separator) (define-key map [new] `(menu-item ,(purecopy "New Server") eudc-set-server :help ,(purecopy "Set the directory server to SERVER using PROTOCOL"))) (define-key map [load] `(menu-item ,(purecopy "Load Hotlist of Servers") eudc-load-eudc :help ,(purecopy "Load the Emacs Unified Directory Client"))) map)) (fset 'eudc-tools-menu (symbol-value 'eudc-tools-menu))) (t (let ((menu '("Directory Search" ["Load Hotlist of Servers" eudc-load-eudc t] ["New Server" eudc-set-server t] ["---" nil nil] ["Query with Form" eudc-query-form t] ["Expand Inline Query" eudc-expand-inline t] ["---" nil nil] ["Get Email" eudc-get-email t] ["Get Phone" eudc-get-phone t]))) (if (not (featurep 'eudc-autoloads)) (if (featurep 'xemacs) (if (and (featurep 'menubar) (not (featurep 'infodock))) (add-submenu '("Tools") menu)) (require 'easymenu) (cond ((fboundp 'easy-menu-add-item) (easy-menu-add-item nil '("tools") (easy-menu-create-menu (car menu) (cdr menu)))) ((fboundp 'easy-menu-create-keymaps) (define-key global-map [menu-bar tools eudc] (cons "Directory Search" (easy-menu-create-keymaps "Directory Search" (cdr menu)))))))))))

;;;***

;;;### (autoloads nil "eudc-bob" "net/eudc-bob.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from net/eudc-bob.el

(autoload 'eudc-display-generic-binary "eudc-bob" "\
Display a button for unidentified binary DATA.

\(fn DATA)" nil nil)

(autoload 'eudc-display-url "eudc-bob" "\
Display URL and make it clickable.

\(fn URL)" nil nil)

(autoload 'eudc-display-mail "eudc-bob" "\
Display e-mail address and make it clickable.

\(fn MAIL)" nil nil)

(autoload 'eudc-display-sound "eudc-bob" "\
Display a button to play the sound DATA.

\(fn DATA)" nil nil)

(autoload 'eudc-display-jpeg-inline "eudc-bob" "\
Display the JPEG DATA inline at point if possible.

\(fn DATA)" nil nil)

(autoload 'eudc-display-jpeg-as-button "eudc-bob" "\
Display a button for the JPEG DATA.

\(fn DATA)" nil nil)

;;;***

;;;### (autoloads nil "eudc-export" "net/eudc-export.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from net/eudc-export.el

(autoload 'eudc-insert-record-at-point-into-bbdb "eudc-export" "\
Insert record at point into the BBDB database.
This function can only be called from a directory query result buffer.

\(fn)" t nil)

(autoload 'eudc-try-bbdb-insert "eudc-export" "\
Call `eudc-insert-record-at-point-into-bbdb' if on a record.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "eudc-hotlist" "net/eudc-hotlist.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from net/eudc-hotlist.el

(autoload 'eudc-edit-hotlist "eudc-hotlist" "\
Edit the hotlist of directory servers in a specialized buffer.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ewoc" "emacs-lisp/ewoc.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from emacs-lisp/ewoc.el

(autoload 'ewoc-create "ewoc" "\
Create an empty ewoc.

The ewoc will be inserted in the current buffer at the current position.

PRETTY-PRINTER should be a function that takes one argument, an
element, and inserts a string representing it in the buffer (at
point).  The string PRETTY-PRINTER inserts may be empty or span
several lines.  The PRETTY-PRINTER should use `insert', and not
`insert-before-markers'.

Optional second and third arguments HEADER and FOOTER are strings,
possibly empty, that will always be present at the top and bottom,
respectively, of the ewoc.

Normally, a newline is automatically inserted after the header,
the footer and every node's printed representation.  Optional
fourth arg NOSEP non-nil inhibits this.

\(fn PRETTY-PRINTER &optional HEADER FOOTER NOSEP)" nil nil)

;;;***

;;;### (autoloads nil "eww" "net/eww.el" (21788 61018 0 0))
;;; Generated autoloads from net/eww.el

(autoload 'eww "eww" "\
Fetch URL and render the page.
If the input doesn't look like an URL or a domain name, the
word(s) will be searched for via `eww-search-prefix'.

\(fn URL)" t nil)
 (defalias 'browse-web 'eww)

(autoload 'eww-open-file "eww" "\
Render a file using EWW.

\(fn FILE)" t nil)

(autoload 'eww-browse-url "eww" "\


\(fn URL &optional NEW-WINDOW)" nil nil)

;;;***

;;;### (autoloads nil "executable" "progmodes/executable.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from progmodes/executable.el

(autoload 'executable-command-find-posix-p "executable" "\
Check if PROGRAM handles arguments Posix-style.
If PROGRAM is non-nil, use that instead of \"find\".

\(fn &optional PROGRAM)" nil nil)

(autoload 'executable-interpret "executable" "\
Run script with user-specified args, and collect output in a buffer.
While script runs asynchronously, you can use the \\[next-error]
command to find the next error.  The buffer is also in `comint-mode' and
`compilation-shell-minor-mode', so that you can answer any prompts.

\(fn COMMAND)" t nil)

(autoload 'executable-set-magic "executable" "\
Set this buffer's interpreter to INTERPRETER with optional ARGUMENT.
The variables `executable-magicless-file-regexp', `executable-prefix',
`executable-insert', `executable-query' and `executable-chmod' control
when and how magic numbers are inserted or replaced and scripts made
executable.

\(fn INTERPRETER &optional ARGUMENT NO-QUERY-FLAG INSERT-FLAG)" t nil)

(autoload 'executable-self-display "executable" "\
Turn a text file into a self-displaying Un*x command.
The magic number of such a command displays all lines but itself.

\(fn)" t nil)

(autoload 'executable-make-buffer-file-executable-if-script-p "executable" "\
Make file executable according to umask if not already executable.
If file already has any execute bits set at all, do not change existing
file modes.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "expand" "expand.el" (21710 25077 0 0))
;;; Generated autoloads from expand.el

(autoload 'expand-add-abbrevs "expand" "\
Add a list of abbreviations to abbrev table TABLE.
ABBREVS is a list of abbrev definitions; each abbrev description entry
has the form (ABBREV EXPANSION ARG).

ABBREV is the abbreviation to replace.

EXPANSION is the replacement string or a function which will make the
expansion.  For example, you could use the DMacros or skeleton packages
to generate such functions.

ARG is an optional argument which can be a number or a list of
numbers.  If ARG is a number, point is placed ARG chars from the
beginning of the expanded text.

If ARG is a list of numbers, point is placed according to the first
member of the list, but you can visit the other specified positions
cyclically with the functions `expand-jump-to-previous-slot' and
`expand-jump-to-next-slot'.

If ARG is omitted, point is placed at the end of the expanded text.

\(fn TABLE ABBREVS)" nil nil)

(autoload 'expand-abbrev-hook "expand" "\
Abbrev hook used to do the expansion job of expand abbrevs.
See `expand-add-abbrevs'.  Value is non-nil if expansion was done.

\(fn)" nil nil)

(autoload 'expand-jump-to-previous-slot "expand" "\
Move the cursor to the previous slot in the last abbrev expansion.
This is used only in conjunction with `expand-add-abbrevs'.

\(fn)" t nil)

(autoload 'expand-jump-to-next-slot "expand" "\
Move the cursor to the next slot in the last abbrev expansion.
This is used only in conjunction with `expand-add-abbrevs'.

\(fn)" t nil)
 (define-key abbrev-map "p" 'expand-jump-to-previous-slot)
 (define-key abbrev-map "n" 'expand-jump-to-next-slot)

;;;***

;;;### (autoloads nil "f90" "progmodes/f90.el" (21788 61018 0 0))
;;; Generated autoloads from progmodes/f90.el

(autoload 'f90-mode "f90" "\
Major mode for editing Fortran 90,95 code in free format.
For fixed format code, use `fortran-mode'.

\\[f90-indent-line] indents the current line.
\\[f90-indent-new-line] indents current line and creates a new indented line.
\\[f90-indent-subprogram] indents the current subprogram.

Type `? or `\\[help-command] to display a list of built-in abbrevs for F90 keywords.

Key definitions:
\\{f90-mode-map}

Variables controlling indentation style and extra features:

`f90-do-indent'
  Extra indentation within do blocks (default 3).
`f90-if-indent'
  Extra indentation within if/select/where/forall blocks (default 3).
`f90-type-indent'
  Extra indentation within type/enum/interface/block-data blocks (default 3).
`f90-program-indent'
  Extra indentation within program/module/subroutine/function blocks
  (default 2).
`f90-associate-indent'
  Extra indentation within associate blocks (default 2).
`f90-critical-indent'
  Extra indentation within critical/block blocks (default 2).
`f90-continuation-indent'
  Extra indentation applied to continuation lines (default 5).
`f90-comment-region'
  String inserted by function \\[f90-comment-region] at start of each
  line in region (default \"!!!$\").
`f90-indented-comment-re'
  Regexp determining the type of comment to be intended like code
  (default \"!\").
`f90-directive-comment-re'
  Regexp of comment-like directive like \"!HPF\\\\$\", not to be indented
  (default \"!hpf\\\\$\").
`f90-break-delimiters'
  Regexp holding list of delimiters at which lines may be broken
  (default \"[-+*/><=,% \\t]\").
`f90-break-before-delimiters'
  Non-nil causes `f90-do-auto-fill' to break lines before delimiters
  (default t).
`f90-beginning-ampersand'
  Automatic insertion of & at beginning of continuation lines (default t).
`f90-smart-end'
  From an END statement, check and fill the end using matching block start.
  Allowed values are `blink', `no-blink', and nil, which determine
  whether to blink the matching beginning (default `blink').
`f90-auto-keyword-case'
  Automatic change of case of keywords (default nil).
  The possibilities are `downcase-word', `upcase-word', `capitalize-word'.
`f90-leave-line-no'
  Do not left-justify line numbers (default nil).

Turning on F90 mode calls the value of the variable `f90-mode-hook'
with no args, if that value is non-nil.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "face-remap" "face-remap.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from face-remap.el

(autoload 'face-remap-add-relative "face-remap" "\
Add a face remapping entry of FACE to SPECS in the current buffer.
Return a cookie which can be used to delete this remapping with
`face-remap-remove-relative'.

The remaining arguments, SPECS, should form a list of faces.
Each list element should be either a face name or a property list
of face attribute/value pairs.  If more than one face is listed,
that specifies an aggregate face, in the same way as in a `face'
text property, except for possible priority changes noted below.

The face remapping specified by SPECS takes effect alongside the
remappings from other calls to `face-remap-add-relative' for the
same FACE, as well as the normal definition of FACE (at lowest
priority).  This function tries to sort multiple remappings for
the same face, so that remappings specifying relative face
attributes are applied after remappings specifying absolute face
attributes.

The base (lowest priority) remapping may be set to something
other than the normal definition of FACE via `face-remap-set-base'.

\(fn FACE &rest SPECS)" nil nil)

(autoload 'face-remap-reset-base "face-remap" "\
Set the base remapping of FACE to the normal definition of FACE.
This causes the remappings specified by `face-remap-add-relative'
to apply on top of the normal definition of FACE.

\(fn FACE)" nil nil)

(autoload 'face-remap-set-base "face-remap" "\
Set the base remapping of FACE in the current buffer to SPECS.
This causes the remappings specified by `face-remap-add-relative'
to apply on top of the face specification given by SPECS.

The remaining arguments, SPECS, should form a list of faces.
Each list element should be either a face name or a property list
of face attribute/value pairs, like in a `face' text property.

If SPECS is empty, call `face-remap-reset-base' to use the normal
definition of FACE as the base remapping; note that this is
different from SPECS containing a single value `nil', which means
not to inherit from the global definition of FACE at all.

\(fn FACE &rest SPECS)" nil nil)

(autoload 'text-scale-set "face-remap" "\
Set the scale factor of the default face in the current buffer to LEVEL.
If LEVEL is non-zero, `text-scale-mode' is enabled, otherwise it is disabled.

LEVEL is a number of steps, with 0 representing the default size.
Each step scales the height of the default face by the variable
`text-scale-mode-step' (a negative number decreases the height by
the same amount).

\(fn LEVEL)" t nil)

(autoload 'text-scale-increase "face-remap" "\
Increase the height of the default face in the current buffer by INC steps.
If the new height is other than the default, `text-scale-mode' is enabled.

Each step scales the height of the default face by the variable
`text-scale-mode-step' (a negative number of steps decreases the
height by the same amount).  As a special case, an argument of 0
will remove any scaling currently active.

\(fn INC)" t nil)

(autoload 'text-scale-decrease "face-remap" "\
Decrease the height of the default face in the current buffer by DEC steps.
See `text-scale-increase' for more details.

\(fn DEC)" t nil)
 (define-key ctl-x-map [(control ?+)] 'text-scale-adjust)
 (define-key ctl-x-map [(control ?-)] 'text-scale-adjust)
 (define-key ctl-x-map [(control ?=)] 'text-scale-adjust)
 (define-key ctl-x-map [(control ?0)] 'text-scale-adjust)

(autoload 'text-scale-adjust "face-remap" "\
Adjust the height of the default face by INC.

INC may be passed as a numeric prefix argument.

The actual adjustment made depends on the final component of the
key-binding used to invoke the command, with all modifiers removed:

   +, =   Increase the default face height by one step
   -      Decrease the default face height by one step
   0      Reset the default face height to the global default

After adjusting, continue to read input events and further adjust
the face height as long as the input event read
\(with all modifiers removed) is one of the above characters.

Each step scales the height of the default face by the variable
`text-scale-mode-step' (a negative number of steps decreases the
height by the same amount).  As a special case, an argument of 0
will remove any scaling currently active.

This command is a special-purpose wrapper around the
`text-scale-increase' command which makes repetition convenient
even when it is bound in a non-top-level keymap.  For binding in
a top-level keymap, `text-scale-increase' or
`text-scale-decrease' may be more appropriate.

\(fn INC)" t nil)

(autoload 'buffer-face-mode "face-remap" "\
Minor mode for a buffer-specific default face.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.  When enabled, the face specified by the
variable `buffer-face-mode-face' is used to display the buffer text.

\(fn &optional ARG)" t nil)

(autoload 'buffer-face-set "face-remap" "\
Enable `buffer-face-mode', using face specs SPECS.
Each argument in SPECS should be a face, i.e. either a face name
or a property list of face attributes and values.  If more than
one face is listed, that specifies an aggregate face, like in a
`face' text property.  If SPECS is nil or omitted, disable
`buffer-face-mode'.

This function makes the variable `buffer-face-mode-face' buffer
local, and sets it to FACE.

\(fn &rest SPECS)" t nil)

(autoload 'buffer-face-toggle "face-remap" "\
Toggle `buffer-face-mode', using face specs SPECS.
Each argument in SPECS should be a face, i.e. either a face name
or a property list of face attributes and values.  If more than
one face is listed, that specifies an aggregate face, like in a
`face' text property.

If `buffer-face-mode' is already enabled, and is currently using
the face specs SPECS, then it is disabled; if `buffer-face-mode'
is disabled, or is enabled and currently displaying some other
face, then is left enabled, but the face changed to reflect SPECS.

This function will make the variable `buffer-face-mode-face'
buffer local, and set it to SPECS.

\(fn &rest SPECS)" t nil)

(autoload 'variable-pitch-mode "face-remap" "\
Variable-pitch default-face mode.
An interface to `buffer-face-mode' which uses the `variable-pitch' face.
Besides the choice of face, it is the same as `buffer-face-mode'.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "feedmail" "mail/feedmail.el" (21676 8646 0
;;;;;;  0))
;;; Generated autoloads from mail/feedmail.el
(push (purecopy '(feedmail 11)) package--builtin-versions)

(autoload 'feedmail-send-it "feedmail" "\
Send the current mail buffer using the Feedmail package.
This is a suitable value for `send-mail-function'.  It can be used
with various lower-level mechanisms to provide features such as queueing.

\(fn)" nil nil)

(autoload 'feedmail-run-the-queue-no-prompts "feedmail" "\
Like `feedmail-run-the-queue', but suppress confirmation prompts.

\(fn &optional ARG)" t nil)

(autoload 'feedmail-run-the-queue-global-prompt "feedmail" "\
Like `feedmail-run-the-queue', but with a global confirmation prompt.
This is generally most useful if run non-interactively, since you can
bail out with an appropriate answer to the global confirmation prompt.

\(fn &optional ARG)" t nil)

(autoload 'feedmail-run-the-queue "feedmail" "\
Visit each message in the feedmail queue directory and send it out.
Return value is a list of three things: number of messages sent, number of
messages skipped, and number of non-message things in the queue (commonly
backup file names and the like).

\(fn &optional ARG)" t nil)

(autoload 'feedmail-queue-reminder "feedmail" "\
Perform some kind of reminder activity about queued and draft messages.
Called with an optional symbol argument which says what kind of event
is triggering the reminder activity.  The default is 'on-demand, which
is what you typically would use if you were putting this in your Emacs start-up
or mail hook code.  Other recognized values for WHAT-EVENT (these are passed
internally by feedmail):

   after-immediate      (a message has just been sent in immediate mode)
   after-queue          (a message has just been queued)
   after-draft          (a message has just been placed in the draft directory)
   after-run            (the queue has just been run, possibly sending messages)

WHAT-EVENT is used as a key into the table `feedmail-queue-reminder-alist'.  If
the associated value is a function, it is called without arguments and is expected
to perform the reminder activity.  You can supply your own reminder functions
by redefining `feedmail-queue-reminder-alist'.  If you don't want any reminders,
you can set `feedmail-queue-reminder-alist' to nil.

\(fn &optional WHAT-EVENT)" t nil)

;;;***

;;;### (autoloads nil "ffap" "ffap.el" (21788 61018 0 0))
;;; Generated autoloads from ffap.el

(autoload 'ffap-next "ffap" "\
Search buffer for next file or URL, and run ffap.
Optional argument BACK says to search backwards.
Optional argument WRAP says to try wrapping around if necessary.
Interactively: use a single prefix \\[universal-argument] to search backwards,
double prefix to wrap forward, triple to wrap backwards.
Actual search is done by the function `ffap-next-guess'.

\(fn &optional BACK WRAP)" t nil)

(autoload 'find-file-at-point "ffap" "\
Find FILENAME, guessing a default from text around point.
If `ffap-url-regexp' is not nil, the FILENAME may also be an URL.
With a prefix, this command behaves exactly like `ffap-file-finder'.
If `ffap-require-prefix' is set, the prefix meaning is reversed.
See also the variables `ffap-dired-wildcards', `ffap-newfile-prompt',
and the functions `ffap-file-at-point' and `ffap-url-at-point'.

\(fn &optional FILENAME)" t nil)

(defalias 'ffap 'find-file-at-point)

(autoload 'ffap-menu "ffap" "\
Put up a menu of files and URLs mentioned in this buffer.
Then set mark, jump to choice, and try to fetch it.  The menu is
cached in `ffap-menu-alist', and rebuilt by `ffap-menu-rescan'.
The optional RESCAN argument (a prefix, interactively) forces
a rebuild.  Searches with `ffap-menu-regexp'.

\(fn &optional RESCAN)" t nil)

(autoload 'ffap-at-mouse "ffap" "\
Find file or URL guessed from text around mouse click.
Interactively, calls `ffap-at-mouse-fallback' if no guess is found.
Return value:
  * if a guess string is found, return it (after finding it)
  * if the fallback is called, return whatever it returns
  * otherwise, nil

\(fn E)" t nil)

(autoload 'dired-at-point "ffap" "\
Start Dired, defaulting to file at point.  See `ffap'.
If `dired-at-point-require-prefix' is set, the prefix meaning is reversed.

\(fn &optional FILENAME)" t nil)

(autoload 'ffap-guess-file-name-at-point "ffap" "\
Try to get a file name at point.
This hook is intended to be put in `file-name-at-point-functions'.

\(fn)" nil nil)

(autoload 'ffap-bindings "ffap" "\
Evaluate the forms in variable `ffap-bindings'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "filecache" "filecache.el" (21788 61018 0 0))
;;; Generated autoloads from filecache.el

(autoload 'file-cache-add-directory "filecache" "\
Add all files in DIRECTORY to the file cache.
If called from Lisp with a non-nil REGEXP argument is non-nil,
only add files whose names match REGEXP.

\(fn DIRECTORY &optional REGEXP)" t nil)

(autoload 'file-cache-add-directory-list "filecache" "\
Add DIRECTORIES (a list of directory names) to the file cache.
If called interactively, read the directory names one by one.
If the optional REGEXP argument is non-nil, only files which match it
will be added to the cache.  Note that the REGEXP is applied to the
files in each directory, not to the directory list itself.

\(fn DIRECTORIES &optional REGEXP)" t nil)

(autoload 'file-cache-add-file "filecache" "\
Add FILE to the file cache.

\(fn FILE)" t nil)

(autoload 'file-cache-add-directory-using-find "filecache" "\
Use the `find' command to add files to the file cache.
Find is run in DIRECTORY.

\(fn DIRECTORY)" t nil)

(autoload 'file-cache-add-directory-using-locate "filecache" "\
Use the `locate' command to add files to the file cache.
STRING is passed as an argument to the locate command.

\(fn STRING)" t nil)

(autoload 'file-cache-add-directory-recursively "filecache" "\
Adds DIR and any subdirectories to the file-cache.
This function does not use any external programs.
If the optional REGEXP argument is non-nil, only files which match it
will be added to the cache.  Note that the REGEXP is applied to the
files in each directory, not to the directory list itself.

\(fn DIR &optional REGEXP)" t nil)

(autoload 'file-cache-minibuffer-complete "filecache" "\
Complete a filename in the minibuffer using a preloaded cache.
Filecache does two kinds of substitution: it completes on names in
the cache, and, once it has found a unique name, it cycles through
the directories that the name is available in.  With a prefix argument,
the name is considered already unique; only the second substitution
\(directories) is done.

\(fn ARG)" t nil)

;;;***

;;;### (autoloads nil "filenotify" "filenotify.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from filenotify.el

(autoload 'file-notify-handle-event "filenotify" "\
Handle file system monitoring event.
If EVENT is a filewatch event, call its callback.  It has the format

  (file-notify (DESCRIPTOR ACTIONS FILE COOKIE) CALLBACK)

Otherwise, signal a `file-notify-error'.

\(fn EVENT)" t nil)

;;;***

;;;### (autoloads nil "files-x" "files-x.el" (21710 25077 0 0))
;;; Generated autoloads from files-x.el

(autoload 'add-file-local-variable "files-x" "\
Add file-local VARIABLE with its VALUE to the Local Variables list.

This command deletes all existing settings of VARIABLE (except `mode'
and `eval') and adds a new file-local VARIABLE with VALUE to the
Local Variables list.

If there is no Local Variables list in the current file buffer
then this function adds the first line containing the string
`Local Variables:' and the last line containing the string `End:'.

\(fn VARIABLE VALUE &optional INTERACTIVE)" t nil)

(autoload 'delete-file-local-variable "files-x" "\
Delete all settings of file-local VARIABLE from the Local Variables list.

\(fn VARIABLE &optional INTERACTIVE)" t nil)

(autoload 'add-file-local-variable-prop-line "files-x" "\
Add file-local VARIABLE with its VALUE to the -*- line.

This command deletes all existing settings of VARIABLE (except `mode'
and `eval') and adds a new file-local VARIABLE with VALUE to
the -*- line.

If there is no -*- line at the beginning of the current file buffer
then this function adds it.

\(fn VARIABLE VALUE &optional INTERACTIVE)" t nil)

(autoload 'delete-file-local-variable-prop-line "files-x" "\
Delete all settings of file-local VARIABLE from the -*- line.

\(fn VARIABLE &optional INTERACTIVE)" t nil)

(autoload 'add-dir-local-variable "files-x" "\
Add directory-local VARIABLE with its VALUE and MODE to .dir-locals.el.

\(fn MODE VARIABLE VALUE)" t nil)

(autoload 'delete-dir-local-variable "files-x" "\
Delete all MODE settings of file-local VARIABLE from .dir-locals.el.

\(fn MODE VARIABLE)" t nil)

(autoload 'copy-file-locals-to-dir-locals "files-x" "\
Copy file-local variables to .dir-locals.el.

\(fn)" t nil)

(autoload 'copy-dir-locals-to-file-locals "files-x" "\
Copy directory-local variables to the Local Variables list.

\(fn)" t nil)

(autoload 'copy-dir-locals-to-file-locals-prop-line "files-x" "\
Copy directory-local variables to the -*- line.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "filesets" "filesets.el" (21710 25077 0 0))
;;; Generated autoloads from filesets.el

(autoload 'filesets-init "filesets" "\
Filesets initialization.
Set up hooks, load the cache file -- if existing -- and build the menu.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "find-cmd" "find-cmd.el" (21788 61018 0 0))
;;; Generated autoloads from find-cmd.el
(push (purecopy '(find-cmd 0 6)) package--builtin-versions)

(autoload 'find-cmd "find-cmd" "\
Initiate the building of a find command.
For example:

\(find-cmd '(prune (name \".svn\" \".git\" \".CVS\"))
          '(and (or (name \"*.pl\" \"*.pm\" \"*.t\")
                    (mtime \"+1\"))
                (fstype \"nfs\" \"ufs\"))))

`default-directory' is used as the initial search path.  The
result is a string that should be ready for the command line.

\(fn &rest SUBFINDS)" nil nil)

;;;***

;;;### (autoloads nil "find-dired" "find-dired.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from find-dired.el

(autoload 'find-dired "find-dired" "\
Run `find' and go into Dired mode on a buffer of the output.
The command run (after changing into DIR) is essentially

    find . \\( ARGS \\) -ls

except that the car of the variable `find-ls-option' specifies what to
use in place of \"-ls\" as the final argument.

\(fn DIR ARGS)" t nil)

(autoload 'find-name-dired "find-dired" "\
Search DIR recursively for files matching the globbing pattern PATTERN,
and run Dired on those files.
PATTERN is a shell wildcard (not an Emacs regexp) and need not be quoted.
The default command run (after changing into DIR) is

    find . -name 'PATTERN' -ls

See `find-name-arg' to customize the arguments.

\(fn DIR PATTERN)" t nil)

(autoload 'find-grep-dired "find-dired" "\
Find files in DIR matching a regexp REGEXP and start Dired on output.
The command run (after changing into DIR) is

  find . \\( -type f -exec `grep-program' `find-grep-options' \\
    -e REGEXP {} \\; \\) -ls

where the car of the variable `find-ls-option' specifies what to
use in place of \"-ls\" as the final argument.

\(fn DIR REGEXP)" t nil)

;;;***

;;;### (autoloads nil "find-file" "find-file.el" (21710 25077 0 0))
;;; Generated autoloads from find-file.el

(defvar ff-special-constructs `((,(purecopy "^#\\s *\\(include\\|import\\)\\s +[<\"]\\(.*\\)[>\"]") lambda nil (buffer-substring (match-beginning 2) (match-end 2)))) "\
List of special constructs recognized by `ff-treat-as-special'.
Each element, tried in order, has the form (REGEXP . EXTRACT).
If REGEXP matches the current line (from the beginning of the line),
`ff-treat-as-special' calls function EXTRACT with no args.
If EXTRACT returns nil, keep trying.  Otherwise, return the
filename that EXTRACT returned.")

(custom-autoload 'ff-special-constructs "find-file" t)

(autoload 'ff-get-other-file "find-file" "\
Find the header or source file corresponding to this file.
See also the documentation for `ff-find-other-file'.

If optional IN-OTHER-WINDOW is non-nil, find the file in another window.

\(fn &optional IN-OTHER-WINDOW)" t nil)

(defalias 'ff-find-related-file 'ff-find-other-file)

(autoload 'ff-find-other-file "find-file" "\
Find the header or source file corresponding to this file.
Being on a `#include' line pulls in that file.

If optional IN-OTHER-WINDOW is non-nil, find the file in the other window.
If optional IGNORE-INCLUDE is non-nil, ignore being on `#include' lines.

Variables of interest include:

 - `ff-case-fold-search'
   Non-nil means ignore cases in matches (see `case-fold-search').
   If you have extensions in different cases, you will want this to be nil.

 - `ff-always-in-other-window'
   If non-nil, always open the other file in another window, unless an
   argument is given to `ff-find-other-file'.

 - `ff-ignore-include'
   If non-nil, ignores #include lines.

 - `ff-always-try-to-create'
   If non-nil, always attempt to create the other file if it was not found.

 - `ff-quiet-mode'
   If non-nil, traces which directories are being searched.

 - `ff-special-constructs'
   A list of regular expressions specifying how to recognize special
   constructs such as include files etc, and an associated method for
   extracting the filename from that construct.

 - `ff-other-file-alist'
   Alist of extensions to find given the current file's extension.

 - `ff-search-directories'
   List of directories searched through with each extension specified in
   `ff-other-file-alist' that matches this file's extension.

 - `ff-pre-find-hook'
   List of functions to be called before the search for the file starts.

 - `ff-pre-load-hook'
   List of functions to be called before the other file is loaded.

 - `ff-post-load-hook'
   List of functions to be called after the other file is loaded.

 - `ff-not-found-hook'
   List of functions to be called if the other file could not be found.

 - `ff-file-created-hook'
   List of functions to be called if the other file has been created.

\(fn &optional IN-OTHER-WINDOW IGNORE-INCLUDE)" t nil)

(autoload 'ff-mouse-find-other-file "find-file" "\
Visit the file you click on.

\(fn EVENT)" t nil)

(autoload 'ff-mouse-find-other-file-other-window "find-file" "\
Visit the file you click on in another window.

\(fn EVENT)" t nil)

;;;***

;;;### (autoloads nil "find-func" "emacs-lisp/find-func.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from emacs-lisp/find-func.el

(autoload 'find-library "find-func" "\
Find the Emacs Lisp source of LIBRARY.
LIBRARY should be a string (the name of the library).

\(fn LIBRARY)" t nil)

(autoload 'find-function-search-for-symbol "find-func" "\
Search for SYMBOL's definition of type TYPE in LIBRARY.
Visit the library in a buffer, and return a cons cell (BUFFER . POSITION),
or just (BUFFER . nil) if the definition can't be found in the file.

If TYPE is nil, look for a function definition.
Otherwise, TYPE specifies the kind of definition,
and it is interpreted via `find-function-regexp-alist'.
The search is done in the source for library LIBRARY.

\(fn SYMBOL TYPE LIBRARY)" nil nil)

(autoload 'find-function-noselect "find-func" "\
Return a pair (BUFFER . POINT) pointing to the definition of FUNCTION.

Finds the source file containing the definition of FUNCTION
in a buffer and the point of the definition.  The buffer is
not selected.  If the function definition can't be found in
the buffer, returns (BUFFER).

If FUNCTION is a built-in function, this function normally
attempts to find it in the Emacs C sources; however, if LISP-ONLY
is non-nil, signal an error instead.

If the file where FUNCTION is defined is not known, then it is
searched for in `find-function-source-path' if non-nil, otherwise
in `load-path'.

\(fn FUNCTION &optional LISP-ONLY)" nil nil)

(autoload 'find-function "find-func" "\
Find the definition of the FUNCTION near point.

Finds the source file containing the definition of the function
near point (selected by `function-called-at-point') in a buffer and
places point before the definition.
Set mark before moving, if the buffer already existed.

The library where FUNCTION is defined is searched for in
`find-function-source-path', if non-nil, otherwise in `load-path'.
See also `find-function-recenter-line' and `find-function-after-hook'.

\(fn FUNCTION)" t nil)

(autoload 'find-function-other-window "find-func" "\
Find, in another window, the definition of FUNCTION near point.

See `find-function' for more details.

\(fn FUNCTION)" t nil)

(autoload 'find-function-other-frame "find-func" "\
Find, in another frame, the definition of FUNCTION near point.

See `find-function' for more details.

\(fn FUNCTION)" t nil)

(autoload 'find-variable-noselect "find-func" "\
Return a pair `(BUFFER . POINT)' pointing to the definition of VARIABLE.

Finds the library containing the definition of VARIABLE in a buffer and
the point of the definition.  The buffer is not selected.
If the variable's definition can't be found in the buffer, return (BUFFER).

The library where VARIABLE is defined is searched for in FILE or
`find-function-source-path', if non-nil, otherwise in `load-path'.

\(fn VARIABLE &optional FILE)" nil nil)

(autoload 'find-variable "find-func" "\
Find the definition of the VARIABLE at or before point.

Finds the library containing the definition of the variable
near point (selected by `variable-at-point') in a buffer and
places point before the definition.

Set mark before moving, if the buffer already existed.

The library where VARIABLE is defined is searched for in
`find-function-source-path', if non-nil, otherwise in `load-path'.
See also `find-function-recenter-line' and `find-function-after-hook'.

\(fn VARIABLE)" t nil)

(autoload 'find-variable-other-window "find-func" "\
Find, in another window, the definition of VARIABLE near point.

See `find-variable' for more details.

\(fn VARIABLE)" t nil)

(autoload 'find-variable-other-frame "find-func" "\
Find, in another frame, the definition of VARIABLE near point.

See `find-variable' for more details.

\(fn VARIABLE)" t nil)

(autoload 'find-definition-noselect "find-func" "\
Return a pair `(BUFFER . POINT)' pointing to the definition of SYMBOL.
If the definition can't be found in the buffer, return (BUFFER).
TYPE says what type of definition: nil for a function, `defvar' for a
variable, `defface' for a face.  This function does not switch to the
buffer nor display it.

The library where SYMBOL is defined is searched for in FILE or
`find-function-source-path', if non-nil, otherwise in `load-path'.

\(fn SYMBOL TYPE &optional FILE)" nil nil)

(autoload 'find-face-definition "find-func" "\
Find the definition of FACE.  FACE defaults to the name near point.

Finds the Emacs Lisp library containing the definition of the face
near point (selected by `variable-at-point') in a buffer and
places point before the definition.

Set mark before moving, if the buffer already existed.

The library where FACE is defined is searched for in
`find-function-source-path', if non-nil, otherwise in `load-path'.
See also `find-function-recenter-line' and `find-function-after-hook'.

\(fn FACE)" t nil)

(autoload 'find-function-on-key "find-func" "\
Find the function that KEY invokes.  KEY is a string.
Set mark before moving, if the buffer already existed.

\(fn KEY)" t nil)

(autoload 'find-function-at-point "find-func" "\
Find directly the function at point in the other window.

\(fn)" t nil)

(autoload 'find-variable-at-point "find-func" "\
Find directly the variable at point in the other window.

\(fn)" t nil)

(autoload 'find-function-setup-keys "find-func" "\
Define some key bindings for the find-function family of functions.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "find-lisp" "find-lisp.el" (21710 25077 0 0))
;;; Generated autoloads from find-lisp.el

(autoload 'find-lisp-find-dired "find-lisp" "\
Find files in DIR, matching REGEXP.

\(fn DIR REGEXP)" t nil)

(autoload 'find-lisp-find-dired-subdirectories "find-lisp" "\
Find all subdirectories of DIR.

\(fn DIR)" t nil)

(autoload 'find-lisp-find-dired-filter "find-lisp" "\
Change the filter on a `find-lisp-find-dired' buffer to REGEXP.

\(fn REGEXP)" t nil)

;;;***

;;;### (autoloads nil "finder" "finder.el" (21710 25077 0 0))
;;; Generated autoloads from finder.el
(push (purecopy '(finder 1 0)) package--builtin-versions)

(autoload 'finder-list-keywords "finder" "\
Display descriptions of the keywords in the Finder buffer.

\(fn)" t nil)

(autoload 'finder-commentary "finder" "\
Display FILE's commentary section.
FILE should be in a form suitable for passing to `locate-library'.

\(fn FILE)" t nil)

(autoload 'finder-by-keyword "finder" "\
Find packages matching a given keyword.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "flow-ctrl" "flow-ctrl.el" (21710 25077 0 0))
;;; Generated autoloads from flow-ctrl.el

(autoload 'enable-flow-control "flow-ctrl" "\
Toggle flow control handling.
When handling is enabled, user can type C-s as C-\\, and C-q as C-^.
With arg, enable flow control mode if arg is positive, otherwise disable.

\(fn &optional ARGUMENT)" t nil)

(autoload 'enable-flow-control-on "flow-ctrl" "\
Enable flow control if using one of a specified set of terminal types.
Use `(enable-flow-control-on \"vt100\" \"h19\")' to enable flow control
on VT-100 and H19 terminals.  When flow control is enabled,
you must type C-\\ to get the effect of a C-s, and type C-^
to get the effect of a C-q.

\(fn &rest LOSING-TERMINAL-TYPES)" nil nil)

;;;***

;;;### (autoloads nil "flow-fill" "gnus/flow-fill.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/flow-fill.el

(autoload 'fill-flowed-encode "flow-fill" "\


\(fn &optional BUFFER)" nil nil)

(autoload 'fill-flowed "flow-fill" "\


\(fn &optional BUFFER DELETE-SPACE)" nil nil)

;;;***

;;;### (autoloads nil "flymake" "progmodes/flymake.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/flymake.el
(push (purecopy '(flymake 0 3)) package--builtin-versions)

(autoload 'flymake-mode "flymake" "\
Toggle Flymake mode on or off.
With a prefix argument ARG, enable Flymake mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil, and toggle it if ARG is `toggle'.
\\{flymake-mode-map}

\(fn &optional ARG)" t nil)

(autoload 'flymake-mode-on "flymake" "\
Turn flymake mode on.

\(fn)" nil nil)

(autoload 'flymake-mode-off "flymake" "\
Turn flymake mode off.

\(fn)" nil nil)

(autoload 'flymake-find-file-hook "flymake" "\


\(fn)" nil nil)

;;;***

;;;### (autoloads nil "flyspell" "textmodes/flyspell.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from textmodes/flyspell.el

(autoload 'flyspell-prog-mode "flyspell" "\
Turn on `flyspell-mode' for comments and strings.

\(fn)" t nil)
(defvar flyspell-mode nil "Non-nil if Flyspell mode is enabled.")

(autoload 'flyspell-mode "flyspell" "\
Toggle on-the-fly spell checking (Flyspell mode).
With a prefix argument ARG, enable Flyspell mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Flyspell mode is a buffer-local minor mode.  When enabled, it
spawns a single Ispell process and checks each word.  The default
flyspell behavior is to highlight incorrect words.

Bindings:
\\[ispell-word]: correct words (using Ispell).
\\[flyspell-auto-correct-word]: automatically correct word.
\\[flyspell-auto-correct-previous-word]: automatically correct the last misspelled word.
\\[flyspell-correct-word] (or down-mouse-2): popup correct words.

Hooks:
This runs `flyspell-mode-hook' after flyspell mode is entered or exit.

Remark:
`flyspell-mode' uses `ispell-mode'.  Thus all Ispell options are
valid.  For instance, a different dictionary can be used by
invoking `ispell-change-dictionary'.

Consider using the `ispell-parser' to check your text.  For instance
consider adding:
\(add-hook 'tex-mode-hook (function (lambda () (setq ispell-parser 'tex))))
in your init file.

\\[flyspell-region] checks all words inside a region.
\\[flyspell-buffer] checks the whole buffer.

\(fn &optional ARG)" t nil)

(autoload 'turn-on-flyspell "flyspell" "\
Unconditionally turn on Flyspell mode.

\(fn)" nil nil)

(autoload 'turn-off-flyspell "flyspell" "\
Unconditionally turn off Flyspell mode.

\(fn)" nil nil)

(autoload 'flyspell-mode-off "flyspell" "\
Turn Flyspell mode off.

\(fn)" nil nil)

(autoload 'flyspell-region "flyspell" "\
Flyspell text between BEG and END.

\(fn BEG END)" t nil)

(autoload 'flyspell-buffer "flyspell" "\
Flyspell whole buffer.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "foldout" "foldout.el" (21710 25077 0 0))
;;; Generated autoloads from foldout.el
(push (purecopy '(foldout 1 10)) package--builtin-versions)

;;;***

;;;### (autoloads nil "follow" "follow.el" (21710 25077 0 0))
;;; Generated autoloads from follow.el

(autoload 'turn-on-follow-mode "follow" "\
Turn on Follow mode.  Please see the function `follow-mode'.

\(fn)" nil nil)

(autoload 'turn-off-follow-mode "follow" "\
Turn off Follow mode.  Please see the function `follow-mode'.

\(fn)" nil nil)

(autoload 'follow-mode "follow" "\
Toggle Follow mode.
With a prefix argument ARG, enable Follow mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Follow mode is a minor mode that combines windows into one tall
virtual window.  This is accomplished by two main techniques:

* The windows always displays adjacent sections of the buffer.
  This means that whenever one window is moved, all the
  others will follow.  (Hence the name Follow mode.)

* Should point (cursor) end up outside a window, another
  window displaying that point is selected, if possible.  This
  makes it possible to walk between windows using normal cursor
  movement commands.

Follow mode comes to its prime when used on a large screen and two
side-by-side windows are used.  The user can, with the help of Follow
mode, use two full-height windows as though they would have been
one.  Imagine yourself editing a large function, or section of text,
and being able to use 144 lines instead of the normal 72... (your
mileage may vary).

To split one large window into two side-by-side windows, the commands
`\\[split-window-right]' or `M-x follow-delete-other-windows-and-split' can be used.

Only windows displayed in the same frame follow each other.

This command runs the normal hook `follow-mode-hook'.

Keys specific to Follow mode:
\\{follow-mode-map}

\(fn &optional ARG)" t nil)

(autoload 'follow-delete-other-windows-and-split "follow" "\
Create two side by side windows and enter Follow mode.

Execute this command to display as much as possible of the text
in the selected window.  All other windows, in the current
frame, are deleted and the selected window is split in two
side-by-side windows.  Follow mode is activated, hence the
two windows always will display two successive pages.
\(If one window is moved, the other one will follow.)

If ARG is positive, the leftmost window is selected.  If negative,
the rightmost is selected.  If ARG is nil, the leftmost window is
selected if the original window is the first one in the frame.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "footnote" "mail/footnote.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/footnote.el
(push (purecopy '(footnote 0 19)) package--builtin-versions)

(autoload 'footnote-mode "footnote" "\
Toggle Footnote mode.
With a prefix argument ARG, enable Footnote mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Footnode mode is a buffer-local minor mode.  If enabled, it
provides footnote support for `message-mode'.  To get started,
play around with the following keys:
\\{footnote-minor-mode-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "forms" "forms.el" (21710 25077 0 0))
;;; Generated autoloads from forms.el

(autoload 'forms-mode "forms" "\
Major mode to visit files in a field-structured manner using a form.

Commands:                        Equivalent keys in read-only mode:
 TAB            forms-next-field          TAB
 C-c TAB        forms-next-field
 C-c <          forms-first-record         <
 C-c >          forms-last-record          >
 C-c ?          describe-mode              ?
 C-c C-k        forms-delete-record
 C-c C-q        forms-toggle-read-only     q
 C-c C-o        forms-insert-record
 C-c C-l        forms-jump-record          l
 C-c C-n        forms-next-record          n
 C-c C-p        forms-prev-record          p
 C-c C-r        forms-search-reverse       r
 C-c C-s        forms-search-forward       s
 C-c C-x        forms-exit                 x

\(fn &optional PRIMARY)" t nil)

(autoload 'forms-find-file "forms" "\
Visit a file in Forms mode.

\(fn FN)" t nil)

(autoload 'forms-find-file-other-window "forms" "\
Visit a file in Forms mode in other window.

\(fn FN)" t nil)

;;;***

;;;### (autoloads nil "fortran" "progmodes/fortran.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/fortran.el

(autoload 'fortran-mode "fortran" "\
Major mode for editing Fortran code in fixed format.
For free format code, use `f90-mode'.

\\[fortran-indent-line] indents the current Fortran line correctly.
Note that DO statements must not share a common CONTINUE.

Type ;? or ;\\[help-command] to display a list of built-in abbrevs for Fortran keywords.

Key definitions:
\\{fortran-mode-map}

Variables controlling indentation style and extra features:

`fortran-comment-line-start'
  To use comments starting with `!', set this to the string \"!\".
`fortran-do-indent'
  Extra indentation within DO blocks (default 3).
`fortran-if-indent'
  Extra indentation within IF blocks (default 3).
`fortran-structure-indent'
  Extra indentation within STRUCTURE, UNION, MAP and INTERFACE blocks.
  (default 3)
`fortran-continuation-indent'
  Extra indentation applied to continuation statements (default 5).
`fortran-comment-line-extra-indent'
  Amount of extra indentation for text in full-line comments (default 0).
`fortran-comment-indent-style'
  How to indent the text in full-line comments. Allowed values are:
  nil       don't change the indentation
  fixed     indent to `fortran-comment-line-extra-indent' beyond the
              value of either
                `fortran-minimum-statement-indent-fixed' (fixed format) or
                `fortran-minimum-statement-indent-tab' (TAB format),
              depending on the continuation format in use.
  relative  indent to `fortran-comment-line-extra-indent' beyond the
              indentation for a line of code.
  (default 'fixed)
`fortran-comment-indent-char'
  Single-character string to be inserted instead of space for
  full-line comment indentation (default \" \").
`fortran-minimum-statement-indent-fixed'
  Minimum indentation for statements in fixed format mode (default 6).
`fortran-minimum-statement-indent-tab'
  Minimum indentation for statements in TAB format mode (default 9).
`fortran-line-number-indent'
  Maximum indentation for line numbers (default 1).  A line number will
  get less than this much indentation if necessary to avoid reaching
  column 5.
`fortran-check-all-num-for-matching-do'
  Non-nil causes all numbered lines to be treated as possible \"continue\"
  statements (default nil).
`fortran-blink-matching-if'
  Non-nil causes \\[fortran-indent-line] on an ENDIF (or ENDDO) statement
  to blink on the matching IF (or DO [WHILE]).  (default nil)
`fortran-continuation-string'
  Single-character string to be inserted in column 5 of a continuation
  line (default \"$\").
`fortran-comment-region'
  String inserted by \\[fortran-comment-region] at start of each line in
  the region (default \"c$$$\").
`fortran-electric-line-number'
  Non-nil causes line number digits to be moved to the correct column
  as typed (default t).
`fortran-break-before-delimiters'
  Non-nil causes lines to be broken before delimiters (default t).

Turning on Fortran mode calls the value of the variable `fortran-mode-hook'
with no args, if that value is non-nil.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "fortune" "play/fortune.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from play/fortune.el

(autoload 'fortune-add-fortune "fortune" "\
Add STRING to a fortune file FILE.

Interactively, if called with a prefix argument,
read the file name to use.  Otherwise use the value of `fortune-file'.

\(fn STRING FILE)" t nil)

(autoload 'fortune-from-region "fortune" "\
Append the current region to a local fortune-like data file.

Interactively, if called with a prefix argument,
read the file name to use.  Otherwise use the value of `fortune-file'.

\(fn BEG END FILE)" t nil)

(autoload 'fortune-compile "fortune" "\
Compile fortune file.

If called with a prefix asks for the FILE to compile, otherwise uses
the value of `fortune-file'.  This currently cannot handle directories.

\(fn &optional FILE)" t nil)

(autoload 'fortune-to-signature "fortune" "\
Create signature from output of the fortune program.

If called with a prefix asks for the FILE to choose the fortune from,
otherwise uses the value of `fortune-file'.  If you want to have fortune
choose from a set of files in a directory, call interactively with prefix
and choose the directory as the fortune-file.

\(fn &optional FILE)" t nil)

(autoload 'fortune "fortune" "\
Display a fortune cookie.
If called with a prefix asks for the FILE to choose the fortune from,
otherwise uses the value of `fortune-file'.  If you want to have fortune
choose from a set of files in a directory, call interactively with prefix
and choose the directory as the fortune-file.

\(fn &optional FILE)" t nil)

;;;***

;;;### (autoloads nil "frameset" "frameset.el" (21788 61018 0 0))
;;; Generated autoloads from frameset.el

(defvar frameset-session-filter-alist '((name . :never) (left . frameset-filter-iconified) (minibuffer . frameset-filter-minibuffer) (top . frameset-filter-iconified)) "\
Minimum set of parameters to filter for live (on-session) framesets.
DO NOT MODIFY.  See `frameset-filter-alist' for a full description.")

(defvar frameset-persistent-filter-alist (nconc '((background-color . frameset-filter-sanitize-color) (buffer-list . :never) (buffer-predicate . :never) (buried-buffer-list . :never) (font . frameset-filter-shelve-param) (foreground-color . frameset-filter-sanitize-color) (fullscreen . frameset-filter-shelve-param) (GUI:font . frameset-filter-unshelve-param) (GUI:fullscreen . frameset-filter-unshelve-param) (GUI:height . frameset-filter-unshelve-param) (GUI:width . frameset-filter-unshelve-param) (height . frameset-filter-shelve-param) (outer-window-id . :never) (parent-id . :never) (tty . frameset-filter-tty-to-GUI) (tty-type . frameset-filter-tty-to-GUI) (width . frameset-filter-shelve-param) (window-id . :never) (window-system . :never)) frameset-session-filter-alist) "\
Parameters to filter for persistent framesets.
DO NOT MODIFY.  See `frameset-filter-alist' for a full description.")

(defvar frameset-filter-alist frameset-persistent-filter-alist "\
Alist of frame parameters and filtering functions.

This alist is the default value of the FILTERS argument of
`frameset-save' and `frameset-restore' (which see).

Initially, `frameset-filter-alist' is set to, and shares the value of,
`frameset-persistent-filter-alist'.  You can override any item in
this alist by `push'ing a new item onto it.  If, for some reason, you
intend to modify existing values, do

  (setq frameset-filter-alist (copy-tree frameset-filter-alist))

before changing anything.

On saving, PARAMETERS is the parameter alist of each frame processed,
and FILTERED is the parameter alist that gets saved to the frameset.

On restoring, PARAMETERS is the parameter alist extracted from the
frameset, and FILTERED is the resulting frame parameter alist used
to restore the frame.

Elements of `frameset-filter-alist' are conses (PARAM . ACTION),
where PARAM is a parameter name (a symbol identifying a frame
parameter), and ACTION can be:

 nil       The parameter is copied to FILTERED.
 :never    The parameter is never copied to FILTERED.
 :save     The parameter is copied only when saving the frame.
 :restore  The parameter is copied only when restoring the frame.
 FILTER    A filter function.

FILTER can be a symbol FILTER-FUN, or a list (FILTER-FUN ARGS...).
FILTER-FUN is invoked with

  (apply FILTER-FUN CURRENT FILTERED PARAMETERS SAVING ARGS)

where

 CURRENT     A cons (PARAM . VALUE), where PARAM is the one being
	     filtered and VALUE is its current value.
 FILTERED    The resulting alist (so far).
 PARAMETERS  The complete alist of parameters being filtered,
 SAVING      Non-nil if filtering before saving state, nil if filtering
	       before restoring it.
 ARGS        Any additional arguments specified in the ACTION.

FILTER-FUN is allowed to modify items in FILTERED, but no other arguments.
It must return:
 nil                      Skip CURRENT (do not add it to FILTERED).
 t                        Add CURRENT to FILTERED as is.
 (NEW-PARAM . NEW-VALUE)  Add this to FILTERED instead of CURRENT.

Frame parameters not on this alist are passed intact, as if they were
defined with ACTION = nil.")

(autoload 'frameset-frame-id "frameset" "\
Return the frame id of FRAME, if it has one; else, return nil.
A frame id is a string that uniquely identifies a frame.
It is persistent across `frameset-save' / `frameset-restore'
invocations, and once assigned is never changed unless the same
frame is duplicated (via `frameset-restore'), in which case the
newest frame keeps the id and the old frame's is set to nil.

\(fn FRAME)" nil nil)

(autoload 'frameset-frame-id-equal-p "frameset" "\
Return non-nil if FRAME's id matches ID.

\(fn FRAME ID)" nil nil)

(autoload 'frameset-frame-with-id "frameset" "\
Return the live frame with id ID, if exists; else nil.
If FRAME-LIST is a list of frames, check these frames only.
If nil, check all live frames.

\(fn ID &optional FRAME-LIST)" nil nil)

(autoload 'frameset-save "frameset" "\
Return a frameset for FRAME-LIST, a list of frames.
Dead frames and non-frame objects are silently removed from the list.
If nil, FRAME-LIST defaults to the output of `frame-list' (all live frames).
APP, NAME and DESCRIPTION are optional data; see the docstring of the
`frameset' defstruct for details.
FILTERS is an alist of parameter filters; if nil, the value of the variable
`frameset-filter-alist' is used instead.
PREDICATE is a predicate function, which must return non-nil for frames that
should be saved; if PREDICATE is nil, all frames from FRAME-LIST are saved.
PROPERTIES is a user-defined property list to add to the frameset.

\(fn FRAME-LIST &key APP NAME DESCRIPTION FILTERS PREDICATE PROPERTIES)" nil nil)

(autoload 'frameset-restore "frameset" "\
Restore a FRAMESET into the current display(s).

PREDICATE is a function called with two arguments, the parameter alist
and the window-state of the frame being restored, in that order (see
the docstring of the `frameset' defstruct for additional details).
If PREDICATE returns nil, the frame described by that parameter alist
and window-state is not restored.

FILTERS is an alist of parameter filters; if nil, the value of
`frameset-filter-alist' is used instead.

REUSE-FRAMES selects the policy to reuse frames when restoring:
  t        All existing frames can be reused.
  nil      No existing frame can be reused.
  match    Only frames with matching frame ids can be reused.
  PRED     A predicate function; it receives as argument a live frame,
             and must return non-nil to allow reusing it, nil otherwise.

FORCE-DISPLAY can be:
  t        Frames are restored in the current display.
  nil      Frames are restored, if possible, in their original displays.
  delete   Frames in other displays are deleted instead of restored.
  PRED     A function called with two arguments, the parameter alist and
	     the window state (in that order).  It must return t, nil or
	     `delete', as above but affecting only the frame that will
	     be created from that parameter alist.

FORCE-ONSCREEN can be:
  t        Force onscreen only those frames that are fully offscreen.
  nil      Do not force any frame back onscreen.
  all      Force onscreen any frame fully or partially offscreen.
  PRED     A function called with three arguments,
	   - the live frame just restored,
	   - a list (LEFT TOP WIDTH HEIGHT), describing the frame,
	   - a list (LEFT TOP WIDTH HEIGHT), describing the workarea.
	   It must return non-nil to force the frame onscreen, nil otherwise.

CLEANUP-FRAMES allows to \"clean up\" the frame list after restoring a frameset:
  t        Delete all frames that were not created or restored upon.
  nil      Keep all frames.
  FUNC     A function called with two arguments:
           - FRAME, a live frame.
           - ACTION, which can be one of
             :rejected  Frame existed, but was not a candidate for reuse.
             :ignored   Frame existed, was a candidate, but wasn't reused.
             :reused    Frame existed, was a candidate, and restored upon.
             :created   Frame didn't exist, was created and restored upon.
           Return value is ignored.

Note the timing and scope of the operations described above: REUSE-FRAMES
affects existing frames; PREDICATE, FILTERS and FORCE-DISPLAY affect the frame
being restored before that happens; FORCE-ONSCREEN affects the frame once
it has been restored; and CLEANUP-FRAMES affects all frames alive after the
restoration, including those that have been reused or created anew.

All keyword parameters default to nil.

\(fn FRAMESET &key PREDICATE FILTERS REUSE-FRAMES FORCE-DISPLAY FORCE-ONSCREEN CLEANUP-FRAMES)" nil nil)

(autoload 'frameset--jump-to-register "frameset" "\
Restore frameset from DATA stored in register.
Called from `jump-to-register'.  Internal use only.

\(fn DATA)" nil nil)

(autoload 'frameset-to-register "frameset" "\
Store the current frameset in register REGISTER.
Use \\[jump-to-register] to restore the frameset.
Argument is a character, naming the register.

Interactively, reads the register using `register-read-with-preview'.

\(fn REGISTER)" t nil)

;;;***

;;;### (autoloads nil "gamegrid" "play/gamegrid.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from play/gamegrid.el
(push (purecopy '(gamegrid 1 2)) package--builtin-versions)

;;;***

;;;### (autoloads nil "gdb-mi" "progmodes/gdb-mi.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/gdb-mi.el

(defvar gdb-enable-debug nil "\
Non-nil if Gdb-Enable-Debug mode is enabled.
See the command `gdb-enable-debug' for a description of this minor mode.")

(custom-autoload 'gdb-enable-debug "gdb-mi" nil)

(autoload 'gdb-enable-debug "gdb-mi" "\
Toggle logging of transaction between Emacs and Gdb.
The log is stored in `gdb-debug-log' as an alist with elements
whose cons is send, send-item or recv and whose cdr is the string
being transferred.  This list may grow up to a size of
`gdb-debug-log-max' after which the oldest element (at the end of
the list) is deleted every time a new one is added (at the front).

\(fn &optional ARG)" t nil)

(autoload 'gdb "gdb-mi" "\
Run gdb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

COMMAND-LINE is the shell command for starting the gdb session.
It should be a string consisting of the name of the gdb
executable followed by command line options.  The command line
options should include \"-i=mi\" to use gdb's MI text interface.
Note that the old \"--annotate\" option is no longer supported.

If option `gdb-many-windows' is nil (the default value) then gdb just
pops up the GUD buffer unless `gdb-show-main' is t.  In this case
it starts with two windows: one displaying the GUD buffer and the
other with the source file with the main routine of the inferior.

If option `gdb-many-windows' is t, regardless of the value of
`gdb-show-main', the layout below will appear.  Keybindings are
shown in some of the buffers.

Watch expressions appear in the speedbar/slowbar.

The following commands help control operation :

`gdb-many-windows'    - Toggle the number of windows gdb uses.
`gdb-restore-windows' - To restore the window layout.

See Info node `(emacs)GDB Graphical Interface' for a more
detailed description of this mode.


+----------------------------------------------------------------------+
|                               GDB Toolbar                            |
+-----------------------------------+----------------------------------+
| GUD buffer (I/O of GDB)           | Locals buffer                    |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
+-----------------------------------+----------------------------------+
| Source buffer                     | I/O buffer (of debugged program) |
|                                   | (comint-mode)                    |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
|                                   |                                  |
+-----------------------------------+----------------------------------+
| Stack buffer                      | Breakpoints buffer               |
| RET      gdb-select-frame         | SPC    gdb-toggle-breakpoint     |
|                                   | RET    gdb-goto-breakpoint       |
|                                   | D      gdb-delete-breakpoint     |
+-----------------------------------+----------------------------------+

\(fn COMMAND-LINE)" t nil)

;;;***

;;;### (autoloads nil "generic" "emacs-lisp/generic.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/generic.el

(defvar generic-mode-list nil "\
A list of mode names for `generic-mode'.
Do not add entries to this list directly; use `define-generic-mode'
instead (which see).")

(autoload 'define-generic-mode "generic" "\
Create a new generic mode MODE.

MODE is the name of the command for the generic mode; don't quote it.
The optional DOCSTRING is the documentation for the mode command.  If
you do not supply it, `define-generic-mode' uses a default
documentation string instead.

COMMENT-LIST is a list in which each element is either a character, a
string of one or two characters, or a cons cell.  A character or a
string is set up in the mode's syntax table as a \"comment starter\".
If the entry is a cons cell, the `car' is set up as a \"comment
starter\" and the `cdr' as a \"comment ender\".  (Use nil for the
latter if you want comments to end at the end of the line.)  Note that
the syntax table has limitations about what comment starters and
enders are actually possible.

KEYWORD-LIST is a list of keywords to highlight with
`font-lock-keyword-face'.  Each keyword should be a string.

FONT-LOCK-LIST is a list of additional expressions to highlight.  Each
element of this list should have the same form as an element of
`font-lock-keywords'.

AUTO-MODE-LIST is a list of regular expressions to add to
`auto-mode-alist'.  These regular expressions are added when Emacs
runs the macro expansion.

FUNCTION-LIST is a list of functions to call to do some additional
setup.  The mode command calls these functions just before it runs the
mode hook `MODE-hook'.

See the file generic-x.el for some examples of `define-generic-mode'.

\(fn MODE COMMENT-LIST KEYWORD-LIST FONT-LOCK-LIST AUTO-MODE-LIST FUNCTION-LIST &optional DOCSTRING)" nil t)

(put 'define-generic-mode 'lisp-indent-function '1)

(put 'define-generic-mode 'doc-string-elt '7)

(autoload 'generic-mode-internal "generic" "\
Go into the generic mode MODE.

\(fn MODE COMMENT-LIST KEYWORD-LIST FONT-LOCK-LIST FUNCTION-LIST)" nil nil)

(autoload 'generic-mode "generic" "\
Enter generic mode MODE.

Generic modes provide basic comment and font-lock functionality
for \"generic\" files.  (Files which are too small to warrant their
own mode, but have comment characters, keywords, and the like.)

To define a generic-mode, use the function `define-generic-mode'.
Some generic modes are defined in `generic-x.el'.

\(fn MODE)" t nil)

(autoload 'generic-make-keywords-list "generic" "\
Return a `font-lock-keywords' construct that highlights KEYWORD-LIST.
KEYWORD-LIST is a list of keyword strings that should be
highlighted with face FACE.  This function calculates a regular
expression that matches these keywords and concatenates it with
PREFIX and SUFFIX.  Then it returns a construct based on this
regular expression that can be used as an element of
`font-lock-keywords'.

\(fn KEYWORD-LIST FACE &optional PREFIX SUFFIX)" nil nil)

(make-obsolete 'generic-make-keywords-list 'regexp-opt '"24.4")

;;;***

;;;### (autoloads nil "glasses" "progmodes/glasses.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/glasses.el

(autoload 'glasses-mode "glasses" "\
Minor mode for making identifiers likeThis readable.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.  When this mode is active, it tries to
add virtual separators (like underscores) at places they belong to.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "gmm-utils" "gnus/gmm-utils.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gmm-utils.el

(autoload 'gmm-regexp-concat "gmm-utils" "\
Potentially concat a list of regexps into a single one.
The concatenation is done with logical ORs.

\(fn REGEXP)" nil nil)

(autoload 'gmm-message "gmm-utils" "\
If LEVEL is lower than `gmm-verbose' print ARGS using `message'.

Guideline for numbers:
1 - error messages
3 - non-serious error messages
5 - messages for things that take a long time
7 - not very important messages on stuff
9 - messages inside loops.

\(fn LEVEL &rest ARGS)" nil nil)

(autoload 'gmm-error "gmm-utils" "\
Beep an error if LEVEL is equal to or less than `gmm-verbose'.
ARGS are passed to `message'.

\(fn LEVEL &rest ARGS)" nil nil)

(autoload 'gmm-widget-p "gmm-utils" "\
Non-nil if SYMBOL is a widget.

\(fn SYMBOL)" nil nil)

(autoload 'gmm-tool-bar-from-list "gmm-utils" "\
Make a tool bar from ICON-LIST.

Within each entry of ICON-LIST, the first element is a menu
command, the second element is an icon file name and the third
element is a test function.  You can use \\[describe-key]
<menu-entry> to find out the name of a menu command.  The fourth
and all following elements are passed as the PROPS argument to the
function `tool-bar-local-item'.

If ZAP-LIST is a list, remove those item from the default
`tool-bar-map'.  If it is t, start with a new sparse map.  You
can use \\[describe-key] <icon> to find out the name of an icon
item.  When \\[describe-key] <icon> shows \"<tool-bar> <new-file>
runs the command find-file\", then use `new-file' in ZAP-LIST.

DEFAULT-MAP specifies the default key map for ICON-LIST.

\(fn ICON-LIST ZAP-LIST DEFAULT-MAP)" nil nil)

;;;***

;;;### (autoloads nil "gnus" "gnus/gnus.el" (21788 61018 0 0))
;;; Generated autoloads from gnus/gnus.el
(push (purecopy '(gnus 5 13)) package--builtin-versions)
(when (fboundp 'custom-autoload)
 (custom-autoload 'gnus-select-method "gnus"))

(autoload 'gnus-slave-no-server "gnus" "\
Read network news as a slave, without connecting to the local server.

\(fn &optional ARG)" t nil)

(autoload 'gnus-no-server "gnus" "\
Read network news.
If ARG is a positive number, Gnus will use that as the startup
level. If ARG is nil, Gnus will be started at level 2.  If ARG is
non-nil and not a positive number, Gnus will prompt the user for the
name of an NNTP server to use.
As opposed to `gnus', this command will not connect to the local
server.

\(fn &optional ARG SLAVE)" t nil)

(autoload 'gnus-slave "gnus" "\
Read news as a slave.

\(fn &optional ARG)" t nil)

(autoload 'gnus-other-frame "gnus" "\
Pop up a frame to read news.
This will call one of the Gnus commands which is specified by the user
option `gnus-other-frame-function' (default `gnus') with the argument
ARG if Gnus is not running, otherwise pop up a Gnus frame and run the
command specified by `gnus-other-frame-resume-function'.
The optional second argument DISPLAY should be a standard display string
such as \"unix:0\" to specify where to pop up a frame.  If DISPLAY is
omitted or the function `make-frame-on-display' is not available, the
current display is used.

\(fn &optional ARG DISPLAY)" t nil)

(autoload 'gnus "gnus" "\
Read network news.
If ARG is non-nil and a positive number, Gnus will use that as the
startup level.  If ARG is non-nil and not a positive number, Gnus will
prompt the user for the name of an NNTP server to use.

\(fn &optional ARG DONT-CONNECT SLAVE)" t nil)

;;;***

;;;### (autoloads nil "gnus-agent" "gnus/gnus-agent.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-agent.el

(autoload 'gnus-unplugged "gnus-agent" "\
Start Gnus unplugged.

\(fn)" t nil)

(autoload 'gnus-plugged "gnus-agent" "\
Start Gnus plugged.

\(fn)" t nil)

(autoload 'gnus-slave-unplugged "gnus-agent" "\
Read news as a slave unplugged.

\(fn &optional ARG)" t nil)

(autoload 'gnus-agentize "gnus-agent" "\
Allow Gnus to be an offline newsreader.

The gnus-agentize function is now called internally by gnus when
gnus-agent is set.  If you wish to avoid calling gnus-agentize,
customize gnus-agent to nil.

This will modify the `gnus-setup-news-hook', and
`message-send-mail-real-function' variables, and install the Gnus agent
minor mode in all Gnus buffers.

\(fn)" t nil)

(autoload 'gnus-agent-possibly-save-gcc "gnus-agent" "\
Save GCC if Gnus is unplugged.

\(fn)" nil nil)

(autoload 'gnus-agent-rename-group "gnus-agent" "\
Rename fully-qualified OLD-GROUP as NEW-GROUP.
Always updates the agent, even when disabled, as the old agent
files would corrupt gnus when the agent was next enabled.
Depends upon the caller to determine whether group renaming is
supported.

\(fn OLD-GROUP NEW-GROUP)" nil nil)

(autoload 'gnus-agent-delete-group "gnus-agent" "\
Delete fully-qualified GROUP.
Always updates the agent, even when disabled, as the old agent
files would corrupt gnus when the agent was next enabled.
Depends upon the caller to determine whether group deletion is
supported.

\(fn GROUP)" nil nil)

(autoload 'gnus-agent-get-undownloaded-list "gnus-agent" "\
Construct list of articles that have not been downloaded.

\(fn)" nil nil)

(autoload 'gnus-agent-possibly-alter-active "gnus-agent" "\
Possibly expand a group's active range to include articles
downloaded into the agent.

\(fn GROUP ACTIVE &optional INFO)" nil nil)

(autoload 'gnus-agent-find-parameter "gnus-agent" "\
Search for GROUPs SYMBOL in the group's parameters, the group's
topic parameters, the group's category, or the customizable
variables.  Returns the first non-nil value found.

\(fn GROUP SYMBOL)" nil nil)

(autoload 'gnus-agent-batch-fetch "gnus-agent" "\
Start Gnus and fetch session.

\(fn)" t nil)

(autoload 'gnus-agent-batch "gnus-agent" "\
Start Gnus, send queue and fetch session.

\(fn)" t nil)

(autoload 'gnus-agent-regenerate "gnus-agent" "\
Regenerate all agent covered files.
CLEAN is obsolete and ignored.

\(fn &optional CLEAN REREAD)" t nil)

;;;***

;;;### (autoloads nil "gnus-art" "gnus/gnus-art.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-art.el

(autoload 'gnus-article-prepare-display "gnus-art" "\
Make the current buffer look like a nice article.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "gnus-bookmark" "gnus/gnus-bookmark.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from gnus/gnus-bookmark.el

(autoload 'gnus-bookmark-set "gnus-bookmark" "\
Set a bookmark for this article.

\(fn)" t nil)

(autoload 'gnus-bookmark-jump "gnus-bookmark" "\
Jump to a Gnus bookmark (BMK-NAME).

\(fn &optional BMK-NAME)" t nil)

(autoload 'gnus-bookmark-bmenu-list "gnus-bookmark" "\
Display a list of existing Gnus bookmarks.
The list is displayed in a buffer named `*Gnus Bookmark List*'.
The leftmost column displays a D if the bookmark is flagged for
deletion, or > if it is flagged for displaying.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "gnus-cache" "gnus/gnus-cache.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-cache.el

(autoload 'gnus-jog-cache "gnus-cache" "\
Go through all groups and put the articles into the cache.

Usage:
$ emacs -batch -l ~/.emacs -l gnus -f gnus-jog-cache

\(fn)" t nil)

(autoload 'gnus-cache-generate-active "gnus-cache" "\
Generate the cache active file.

\(fn &optional DIRECTORY)" t nil)

(autoload 'gnus-cache-generate-nov-databases "gnus-cache" "\
Generate NOV files recursively starting in DIR.

\(fn DIR)" t nil)

(autoload 'gnus-cache-rename-group "gnus-cache" "\
Rename OLD-GROUP as NEW-GROUP.
Always updates the cache, even when disabled, as the old cache
files would corrupt Gnus when the cache was next enabled.  It
depends on the caller to determine whether group renaming is
supported.

\(fn OLD-GROUP NEW-GROUP)" nil nil)

(autoload 'gnus-cache-delete-group "gnus-cache" "\
Delete GROUP from the cache.
Always updates the cache, even when disabled, as the old cache
files would corrupt gnus when the cache was next enabled.
Depends upon the caller to determine whether group deletion is
supported.

\(fn GROUP)" nil nil)

;;;***

;;;### (autoloads nil "gnus-delay" "gnus/gnus-delay.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-delay.el

(autoload 'gnus-delay-article "gnus-delay" "\
Delay this article by some time.
DELAY is a string, giving the length of the time.  Possible values are:

* <digits><units> for <units> in minutes (`m'), hours (`h'), days (`d'),
  weeks (`w'), months (`M'), or years (`Y');

* YYYY-MM-DD for a specific date.  The time of day is given by the
  variable `gnus-delay-default-hour', minute and second are zero.

* hh:mm for a specific time.  Use 24h format.  If it is later than this
  time, then the deadline is tomorrow, else today.

\(fn DELAY)" t nil)

(autoload 'gnus-delay-send-queue "gnus-delay" "\
Send all the delayed messages that are due now.

\(fn)" t nil)

(autoload 'gnus-delay-initialize "gnus-delay" "\
Initialize the gnus-delay package.
This sets up a key binding in `message-mode' to delay a message.
This tells Gnus to look for delayed messages after getting new news.

The optional arg NO-KEYMAP is ignored.
Checking delayed messages is skipped if optional arg NO-CHECK is non-nil.

\(fn &optional NO-KEYMAP NO-CHECK)" nil nil)

;;;***

;;;### (autoloads nil "gnus-diary" "gnus/gnus-diary.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-diary.el

(autoload 'gnus-user-format-function-d "gnus-diary" "\


\(fn HEADER)" nil nil)

(autoload 'gnus-user-format-function-D "gnus-diary" "\


\(fn HEADER)" nil nil)

;;;***

;;;### (autoloads nil "gnus-dired" "gnus/gnus-dired.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-dired.el

(autoload 'turn-on-gnus-dired-mode "gnus-dired" "\
Convenience method to turn on gnus-dired-mode.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "gnus-draft" "gnus/gnus-draft.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-draft.el

(autoload 'gnus-draft-reminder "gnus-draft" "\
Reminder user if there are unsent drafts.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "gnus-fun" "gnus/gnus-fun.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-fun.el

(autoload 'gnus-random-x-face "gnus-fun" "\
Return X-Face header data chosen randomly from `gnus-x-face-directory'.

\(fn)" t nil)

(autoload 'gnus-insert-random-x-face-header "gnus-fun" "\
Insert a random X-Face header from `gnus-x-face-directory'.

\(fn)" t nil)

(autoload 'gnus-x-face-from-file "gnus-fun" "\
Insert an X-Face header based on an image file.

Depending on `gnus-convert-image-to-x-face-command' it may accept
different input formats.

\(fn FILE)" t nil)

(autoload 'gnus-face-from-file "gnus-fun" "\
Return a Face header based on an image file.

Depending on `gnus-convert-image-to-face-command' it may accept
different input formats.

\(fn FILE)" t nil)

(autoload 'gnus-convert-face-to-png "gnus-fun" "\
Convert FACE (which is base64-encoded) to a PNG.
The PNG is returned as a string.

\(fn FACE)" nil nil)

(autoload 'gnus-convert-png-to-face "gnus-fun" "\
Convert FILE to a Face.
FILE should be a PNG file that's 48x48 and smaller than or equal to
726 bytes.

\(fn FILE)" nil nil)

;;;***

;;;### (autoloads nil "gnus-gravatar" "gnus/gnus-gravatar.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from gnus/gnus-gravatar.el

(autoload 'gnus-treat-from-gravatar "gnus-gravatar" "\
Display gravatar in the From header.
If gravatar is already displayed, remove it.

\(fn &optional FORCE)" t nil)

(autoload 'gnus-treat-mail-gravatar "gnus-gravatar" "\
Display gravatars in the Cc and To headers.
If gravatars are already displayed, remove them.

\(fn &optional FORCE)" t nil)

;;;***

;;;### (autoloads nil "gnus-group" "gnus/gnus-group.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-group.el

(autoload 'gnus-fetch-group "gnus-group" "\
Start Gnus if necessary and enter GROUP.
If ARTICLES, display those articles.
Returns whether the fetching was successful or not.

\(fn GROUP &optional ARTICLES)" t nil)

(autoload 'gnus-fetch-group-other-frame "gnus-group" "\
Pop up a frame and enter GROUP.

\(fn GROUP)" t nil)

;;;***

;;;### (autoloads nil "gnus-html" "gnus/gnus-html.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-html.el

(autoload 'gnus-article-html "gnus-html" "\


\(fn &optional HANDLE)" nil nil)

(autoload 'gnus-html-prefetch-images "gnus-html" "\


\(fn SUMMARY)" nil nil)

;;;***

;;;### (autoloads nil "gnus-kill" "gnus/gnus-kill.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-kill.el

(defalias 'gnus-batch-kill 'gnus-batch-score)

(autoload 'gnus-batch-score "gnus-kill" "\
Run batched scoring.
Usage: emacs -batch -l ~/.emacs -l gnus -f gnus-batch-score

\(fn)" t nil)

;;;***

;;;### (autoloads nil "gnus-ml" "gnus/gnus-ml.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from gnus/gnus-ml.el

(autoload 'turn-on-gnus-mailing-list-mode "gnus-ml" "\


\(fn)" nil nil)

(autoload 'gnus-mailing-list-insinuate "gnus-ml" "\
Setup group parameters from List-Post header.
If FORCE is non-nil, replace the old ones.

\(fn &optional FORCE)" t nil)

(autoload 'gnus-mailing-list-mode "gnus-ml" "\
Minor mode for providing mailing-list commands.

\\{gnus-mailing-list-mode-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "gnus-mlspl" "gnus/gnus-mlspl.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-mlspl.el

(autoload 'gnus-group-split-setup "gnus-mlspl" "\
Set up the split for `nnmail-split-fancy'.
Sets things up so that nnmail-split-fancy is used for mail
splitting, and defines the variable nnmail-split-fancy according with
group parameters.

If AUTO-UPDATE is non-nil (prefix argument accepted, if called
interactively), it makes sure nnmail-split-fancy is re-computed before
getting new mail, by adding `gnus-group-split-update' to
`nnmail-pre-get-new-mail-hook'.

A non-nil CATCH-ALL replaces the current value of
`gnus-group-split-default-catch-all-group'.  This variable is only used
by gnus-group-split-update, and only when its CATCH-ALL argument is
nil.  This argument may contain any fancy split, that will be added as
the last split in a `|' split produced by `gnus-group-split-fancy',
unless overridden by any group marked as a catch-all group.  Typical
uses are as simple as the name of a default mail group, but more
elaborate fancy splits may also be useful to split mail that doesn't
match any of the group-specified splitting rules.  See
`gnus-group-split-fancy' for details.

\(fn &optional AUTO-UPDATE CATCH-ALL)" t nil)

(autoload 'gnus-group-split-update "gnus-mlspl" "\
Computes nnmail-split-fancy from group params and CATCH-ALL.
It does this by calling by calling (gnus-group-split-fancy nil
nil CATCH-ALL).

If CATCH-ALL is nil, `gnus-group-split-default-catch-all-group' is used
instead.  This variable is set by `gnus-group-split-setup'.

\(fn &optional CATCH-ALL)" t nil)

(autoload 'gnus-group-split "gnus-mlspl" "\
Use information from group parameters in order to split mail.
See `gnus-group-split-fancy' for more information.

`gnus-group-split' is a valid value for `nnmail-split-methods'.

\(fn)" nil nil)

(autoload 'gnus-group-split-fancy "gnus-mlspl" "\
Uses information from group parameters in order to split mail.
It can be embedded into `nnmail-split-fancy' lists with the SPLIT

\(: gnus-group-split-fancy GROUPS NO-CROSSPOST CATCH-ALL)

GROUPS may be a regular expression or a list of group names, that will
be used to select candidate groups.  If it is omitted or nil, all
existing groups are considered.

if NO-CROSSPOST is omitted or nil, a & split will be returned,
otherwise, a | split, that does not allow crossposting, will be
returned.

For each selected group, a SPLIT is composed like this: if SPLIT-SPEC
is specified, this split is returned as-is (unless it is nil: in this
case, the group is ignored).  Otherwise, if TO-ADDRESS, TO-LIST and/or
EXTRA-ALIASES are specified, a regexp that matches any of them is
constructed (extra-aliases may be a list).  Additionally, if
SPLIT-REGEXP is specified, the regexp will be extended so that it
matches this regexp too, and if SPLIT-EXCLUDE is specified, RESTRICT
clauses will be generated.

If CATCH-ALL is nil, no catch-all handling is performed, regardless of
catch-all marks in group parameters.  Otherwise, if there is no
selected group whose SPLIT-REGEXP matches the empty string, nor is
there a selected group whose SPLIT-SPEC is 'catch-all, this fancy
split (say, a group name) will be appended to the returned SPLIT list,
as the last element of a '| SPLIT.

For example, given the following group parameters:

nnml:mail.bar:
\((to-address . \"bar@femail.com\")
 (split-regexp . \".*@femail\\\\.com\"))
nnml:mail.foo:
\((to-list . \"foo@nowhere.gov\")
 (extra-aliases \"foo@localhost\" \"foo-redist@home\")
 (split-exclude \"bugs-foo\" \"rambling-foo\")
 (admin-address . \"foo-request@nowhere.gov\"))
nnml:mail.others:
\((split-spec . catch-all))

Calling (gnus-group-split-fancy nil nil \"mail.others\") returns:

\(| (& (any \"\\\\(bar@femail\\\\.com\\\\|.*@femail\\\\.com\\\\)\"
	   \"mail.bar\")
      (any \"\\\\(foo@nowhere\\\\.gov\\\\|foo@localhost\\\\|foo-redist@home\\\\)\"
	   - \"bugs-foo\" - \"rambling-foo\" \"mail.foo\"))
   \"mail.others\")

\(fn &optional GROUPS NO-CROSSPOST CATCH-ALL)" nil nil)

;;;***

;;;### (autoloads nil "gnus-msg" "gnus/gnus-msg.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-msg.el

(autoload 'gnus-msg-mail "gnus-msg" "\
Start editing a mail message to be sent.
Like `message-mail', but with Gnus paraphernalia, particularly the
Gcc: header for archiving purposes.
If Gnus isn't running, a plain `message-mail' setup is used
instead.

\(fn &optional TO SUBJECT OTHER-HEADERS CONTINUE SWITCH-ACTION YANK-ACTION SEND-ACTIONS RETURN-ACTION)" t nil)

(autoload 'gnus-button-mailto "gnus-msg" "\
Mail to ADDRESS.

\(fn ADDRESS)" nil nil)

(autoload 'gnus-button-reply "gnus-msg" "\
Like `message-reply'.

\(fn &optional TO-ADDRESS WIDE)" t nil)

(define-mail-user-agent 'gnus-user-agent 'gnus-msg-mail 'message-send-and-exit 'message-kill-buffer 'message-send-hook)

;;;***

;;;### (autoloads nil "gnus-notifications" "gnus/gnus-notifications.el"
;;;;;;  (21788 61018 0 0))
;;; Generated autoloads from gnus/gnus-notifications.el

(autoload 'gnus-notifications "gnus-notifications" "\
Send a notification on new message.
This check for new messages that are in group with a level lower
or equal to `gnus-notifications-minimum-level' and send a
notification using `notifications-notify' for it.

This is typically a function to add in
`gnus-after-getting-new-news-hook'

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "gnus-picon" "gnus/gnus-picon.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-picon.el

(autoload 'gnus-treat-from-picon "gnus-picon" "\
Display picons in the From header.
If picons are already displayed, remove them.

\(fn)" t nil)

(autoload 'gnus-treat-mail-picon "gnus-picon" "\
Display picons in the Cc and To headers.
If picons are already displayed, remove them.

\(fn)" t nil)

(autoload 'gnus-treat-newsgroups-picon "gnus-picon" "\
Display picons in the Newsgroups and Followup-To headers.
If picons are already displayed, remove them.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "gnus-range" "gnus/gnus-range.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-range.el

(autoload 'gnus-sorted-difference "gnus-range" "\
Return a list of elements of LIST1 that do not appear in LIST2.
Both lists have to be sorted over <.
The tail of LIST1 is not copied.

\(fn LIST1 LIST2)" nil nil)

(autoload 'gnus-sorted-ndifference "gnus-range" "\
Return a list of elements of LIST1 that do not appear in LIST2.
Both lists have to be sorted over <.
LIST1 is modified.

\(fn LIST1 LIST2)" nil nil)

(autoload 'gnus-sorted-complement "gnus-range" "\
Return a list of elements that are in LIST1 or LIST2 but not both.
Both lists have to be sorted over <.

\(fn LIST1 LIST2)" nil nil)

(autoload 'gnus-intersection "gnus-range" "\


\(fn LIST1 LIST2)" nil nil)

(autoload 'gnus-sorted-intersection "gnus-range" "\
Return intersection of LIST1 and LIST2.
LIST1 and LIST2 have to be sorted over <.

\(fn LIST1 LIST2)" nil nil)

(autoload 'gnus-sorted-range-intersection "gnus-range" "\
Return intersection of RANGE1 and RANGE2.
RANGE1 and RANGE2 have to be sorted over <.

\(fn RANGE1 RANGE2)" nil nil)

(defalias 'gnus-set-sorted-intersection 'gnus-sorted-nintersection)

(autoload 'gnus-sorted-nintersection "gnus-range" "\
Return intersection of LIST1 and LIST2 by modifying cdr pointers of LIST1.
LIST1 and LIST2 have to be sorted over <.

\(fn LIST1 LIST2)" nil nil)

(autoload 'gnus-sorted-union "gnus-range" "\
Return union of LIST1 and LIST2.
LIST1 and LIST2 have to be sorted over <.

\(fn LIST1 LIST2)" nil nil)

(autoload 'gnus-sorted-nunion "gnus-range" "\
Return union of LIST1 and LIST2 by modifying cdr pointers of LIST1.
LIST1 and LIST2 have to be sorted over <.

\(fn LIST1 LIST2)" nil nil)

(autoload 'gnus-add-to-sorted-list "gnus-range" "\
Add NUM into sorted LIST by side effect.

\(fn LIST NUM)" nil nil)

;;;***

;;;### (autoloads nil "gnus-registry" "gnus/gnus-registry.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from gnus/gnus-registry.el

(autoload 'gnus-registry-initialize "gnus-registry" "\
Initialize the Gnus registry.

\(fn)" t nil)

(autoload 'gnus-registry-install-hooks "gnus-registry" "\
Install the registry hooks.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "gnus-sieve" "gnus/gnus-sieve.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-sieve.el

(autoload 'gnus-sieve-update "gnus-sieve" "\
Update the Sieve script in gnus-sieve-file, by replacing the region
between gnus-sieve-region-start and gnus-sieve-region-end with
\(gnus-sieve-script gnus-sieve-select-method gnus-sieve-crosspost), then
execute gnus-sieve-update-shell-command.
See the documentation for these variables and functions for details.

\(fn)" t nil)

(autoload 'gnus-sieve-generate "gnus-sieve" "\
Generate the Sieve script in gnus-sieve-file, by replacing the region
between gnus-sieve-region-start and gnus-sieve-region-end with
\(gnus-sieve-script gnus-sieve-select-method gnus-sieve-crosspost).
See the documentation for these variables and functions for details.

\(fn)" t nil)

(autoload 'gnus-sieve-article-add-rule "gnus-sieve" "\


\(fn)" t nil)

;;;***

;;;### (autoloads nil "gnus-spec" "gnus/gnus-spec.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-spec.el

(autoload 'gnus-update-format "gnus-spec" "\
Update the format specification near point.

\(fn VAR)" t nil)

;;;***

;;;### (autoloads nil "gnus-start" "gnus/gnus-start.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-start.el

(autoload 'gnus-declare-backend "gnus-start" "\
Declare back end NAME with ABILITIES as a Gnus back end.

\(fn NAME &rest ABILITIES)" nil nil)

;;;***

;;;### (autoloads nil "gnus-sum" "gnus/gnus-sum.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-sum.el

(autoload 'gnus-summary-bookmark-jump "gnus-sum" "\
Handler function for record returned by `gnus-summary-bookmark-make-record'.
BOOKMARK is a bookmark name or a bookmark record.

\(fn BOOKMARK)" nil nil)

;;;***

;;;### (autoloads nil "gnus-sync" "gnus/gnus-sync.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-sync.el

(autoload 'gnus-sync-initialize "gnus-sync" "\
Initialize the Gnus sync facility.

\(fn)" t nil)

(autoload 'gnus-sync-install-hooks "gnus-sync" "\
Install the sync hooks.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "gnus-win" "gnus/gnus-win.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/gnus-win.el

(autoload 'gnus-add-configuration "gnus-win" "\
Add the window configuration CONF to `gnus-buffer-configuration'.

\(fn CONF)" nil nil)

;;;***

;;;### (autoloads nil "gnutls" "net/gnutls.el" (21788 61018 0 0))
;;; Generated autoloads from net/gnutls.el

(defvar gnutls-min-prime-bits 256 "\
Minimum number of prime bits accepted by GnuTLS for key exchange.
During a Diffie-Hellman handshake, if the server sends a prime
number with fewer than this number of bits, the handshake is
rejected.  (The smaller the prime number, the less secure the
key exchange is against man-in-the-middle attacks.)

A value of nil says to use the default GnuTLS value.")

(custom-autoload 'gnutls-min-prime-bits "gnutls" t)

;;;***

;;;### (autoloads nil "gomoku" "play/gomoku.el" (21710 25077 0 0))
;;; Generated autoloads from play/gomoku.el

(autoload 'gomoku "gomoku" "\
Start a Gomoku game between you and Emacs.

If a game is in progress, this command allows you to resume it.
If optional arguments N and M are given, an N by M board is used.
If prefix arg is given for N, M is prompted for.

You and Emacs play in turn by marking a free square.  You mark it with X
and Emacs marks it with O.  The winner is the first to get five contiguous
marks horizontally, vertically or in diagonal.

You play by moving the cursor over the square you choose and hitting
\\<gomoku-mode-map>\\[gomoku-human-plays].

This program actually plays a simplified or archaic version of the
Gomoku game, and ought to be upgraded to use the full modern rules.

Use \\[describe-mode] for more info.

\(fn &optional N M)" t nil)

;;;***

;;;### (autoloads nil "goto-addr" "net/goto-addr.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from net/goto-addr.el

(define-obsolete-function-alias 'goto-address-at-mouse 'goto-address-at-point "22.1")

(autoload 'goto-address-at-point "goto-addr" "\
Send to the e-mail address or load the URL at point.
Send mail to address at point.  See documentation for
`goto-address-find-address-at-point'.  If no address is found
there, then load the URL at or before point.

\(fn &optional EVENT)" t nil)

(autoload 'goto-address "goto-addr" "\
Sets up goto-address functionality in the current buffer.
Allows user to use mouse/keyboard command to click to go to a URL
or to send e-mail.
By default, goto-address binds `goto-address-at-point' to mouse-2 and C-c RET
only on URLs and e-mail addresses.

Also fontifies the buffer appropriately (see `goto-address-fontify-p' and
`goto-address-highlight-p' for more information).

\(fn)" t nil)
(put 'goto-address 'safe-local-eval-function t)

(autoload 'goto-address-mode "goto-addr" "\
Minor mode to buttonize URLs and e-mail addresses in the current buffer.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

(autoload 'goto-address-prog-mode "goto-addr" "\
Like `goto-address-mode', but only for comments and strings.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "gravatar" "gnus/gravatar.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/gravatar.el

(autoload 'gravatar-retrieve "gravatar" "\
Retrieve MAIL-ADDRESS gravatar and call CB on retrieval.
You can provide a list of argument to pass to CB in CBARGS.

\(fn MAIL-ADDRESS CB &optional CBARGS)" nil nil)

(autoload 'gravatar-retrieve-synchronously "gravatar" "\
Retrieve MAIL-ADDRESS gravatar and returns it.

\(fn MAIL-ADDRESS)" nil nil)

;;;***

;;;### (autoloads nil "grep" "progmodes/grep.el" (21788 61018 0 0))
;;; Generated autoloads from progmodes/grep.el

(defvar grep-window-height nil "\
Number of lines in a grep window.  If nil, use `compilation-window-height'.")

(custom-autoload 'grep-window-height "grep" t)

(defvar grep-command nil "\
The default grep command for \\[grep].
If the grep program used supports an option to always include file names
in its output (such as the `-H' option to GNU grep), it's a good idea to
include it when specifying `grep-command'.

In interactive usage, the actual value of this variable is set up
by `grep-compute-defaults'; to change the default value, use
Customize or call the function `grep-apply-setting'.")

(custom-autoload 'grep-command "grep" nil)

(defvar grep-find-command nil "\
The default find command for \\[grep-find].
In interactive usage, the actual value of this variable is set up
by `grep-compute-defaults'; to change the default value, use
Customize or call the function `grep-apply-setting'.")

(custom-autoload 'grep-find-command "grep" nil)

(defvar grep-setup-hook nil "\
List of hook functions run by `grep-process-setup' (see `run-hooks').")

(custom-autoload 'grep-setup-hook "grep" t)

(defconst grep-regexp-alist '(("^\\(.+?\\)\\(:[ 	]*\\)\\([1-9][0-9]*\\)\\2" 1 3 ((lambda nil (when grep-highlight-matches (let* ((beg (match-end 0)) (end (save-excursion (goto-char beg) (line-end-position))) (mbeg (text-property-any beg end 'font-lock-face grep-match-face))) (when mbeg (- mbeg beg))))) lambda nil (when grep-highlight-matches (let* ((beg (match-end 0)) (end (save-excursion (goto-char beg) (line-end-position))) (mbeg (text-property-any beg end 'font-lock-face grep-match-face)) (mend (and mbeg (next-single-property-change mbeg 'font-lock-face nil end)))) (when mend (- mend beg)))))) ("^Binary file \\(.+\\) matches$" 1 nil nil 0 1)) "\
Regexp used to match grep hits.  See `compilation-error-regexp-alist'.")

(defvar grep-program (purecopy "grep") "\
The default grep program for `grep-command' and `grep-find-command'.
This variable's value takes effect when `grep-compute-defaults' is called.")

(defvar find-program (purecopy "find") "\
The default find program.
This is used by commands like `grep-find-command', `find-dired'
and others.")

(defvar xargs-program (purecopy "xargs") "\
The default xargs program for `grep-find-command'.
See `grep-find-use-xargs'.
This variable's value takes effect when `grep-compute-defaults' is called.")

(defvar grep-find-use-xargs nil "\
How to invoke find and grep.
If `exec', use `find -exec {} ;'.
If `exec-plus' use `find -exec {} +'.
If `gnu', use `find -print0' and `xargs -0'.
Any other value means to use `find -print' and `xargs'.

This variable's value takes effect when `grep-compute-defaults' is called.")

(defvar grep-history nil "\
History list for grep.")

(defvar grep-find-history nil "\
History list for grep-find.")

(autoload 'grep-process-setup "grep" "\
Setup compilation variables and buffer for `grep'.
Set up `compilation-exit-message-function' and run `grep-setup-hook'.

\(fn)" nil nil)

(autoload 'grep-compute-defaults "grep" "\


\(fn)" nil nil)

(autoload 'grep-mode "grep" "\
Sets `grep-last-buffer' and `compilation-window-height'.

\(fn)" nil nil)

(autoload 'grep "grep" "\
Run grep, with user-specified args, and collect output in a buffer.
While grep runs asynchronously, you can use \\[next-error] (M-x next-error),
or \\<grep-mode-map>\\[compile-goto-error] in the *grep* buffer, to go to the lines where grep found
matches.  To kill the grep job before it finishes, type \\[kill-compilation].

For doing a recursive `grep', see the `rgrep' command.  For running
`grep' in a specific directory, see `lgrep'.

This command uses a special history list for its COMMAND-ARGS, so you
can easily repeat a grep command.

A prefix argument says to default the argument based upon the current
tag the cursor is over, substituting it into the last grep command
in the grep command history (or into `grep-command' if that history
list is empty).

\(fn COMMAND-ARGS)" t nil)

(autoload 'grep-find "grep" "\
Run grep via find, with user-specified args COMMAND-ARGS.
Collect output in a buffer.
While find runs asynchronously, you can use the \\[next-error] command
to find the text that grep hits refer to.

This command uses a special history list for its arguments, so you can
easily repeat a find command.

\(fn COMMAND-ARGS)" t nil)

(defalias 'find-grep 'grep-find)

(autoload 'lgrep "grep" "\
Run grep, searching for REGEXP in FILES in directory DIR.
The search is limited to file names matching shell pattern FILES.
FILES may use abbreviations defined in `grep-files-aliases', e.g.
entering `ch' is equivalent to `*.[ch]'.

With \\[universal-argument] prefix, you can edit the constructed shell command line
before it is executed.
With two \\[universal-argument] prefixes, directly edit and run `grep-command'.

Collect output in a buffer.  While grep runs asynchronously, you
can use \\[next-error] (M-x next-error), or \\<grep-mode-map>\\[compile-goto-error] in the grep output buffer,
to go to the lines where grep found matches.

This command shares argument histories with \\[rgrep] and \\[grep].

\(fn REGEXP &optional FILES DIR CONFIRM)" t nil)

(autoload 'rgrep "grep" "\
Recursively grep for REGEXP in FILES in directory tree rooted at DIR.
The search is limited to file names matching shell pattern FILES.
FILES may use abbreviations defined in `grep-files-aliases', e.g.
entering `ch' is equivalent to `*.[ch]'.

With \\[universal-argument] prefix, you can edit the constructed shell command line
before it is executed.
With two \\[universal-argument] prefixes, directly edit and run `grep-find-command'.

Collect output in a buffer.  While the recursive grep is running,
you can use \\[next-error] (M-x next-error), or \\<grep-mode-map>\\[compile-goto-error] in the grep output buffer,
to visit the lines where matches were found.  To kill the job
before it finishes, type \\[kill-compilation].

This command shares argument histories with \\[lgrep] and \\[grep-find].

When called programmatically and FILES is nil, REGEXP is expected
to specify a command to run.

\(fn REGEXP &optional FILES DIR CONFIRM)" t nil)

(autoload 'zrgrep "grep" "\
Recursively grep for REGEXP in gzipped FILES in tree rooted at DIR.
Like `rgrep' but uses `zgrep' for `grep-program', sets the default
file name to `*.gz', and sets `grep-highlight-matches' to `always'.

\(fn REGEXP &optional FILES DIR CONFIRM GREP-FIND-TEMPLATE)" t nil)

(defalias 'rzgrep 'zrgrep)

;;;***

;;;### (autoloads nil "gs" "gs.el" (21710 25077 0 0))
;;; Generated autoloads from gs.el

(autoload 'gs-load-image "gs" "\
Load a PS image for display on FRAME.
SPEC is an image specification, IMG-HEIGHT and IMG-WIDTH are width
and height of the image in pixels.  WINDOW-AND-PIXMAP-ID is a string of
the form \"WINDOW-ID PIXMAP-ID\".  Value is non-nil if successful.

\(fn FRAME SPEC IMG-WIDTH IMG-HEIGHT WINDOW-AND-PIXMAP-ID PIXEL-COLORS)" nil nil)

;;;***

;;;### (autoloads nil "gud" "progmodes/gud.el" (21788 61018 0 0))
;;; Generated autoloads from progmodes/gud.el

(autoload 'gud-gdb "gud" "\
Run gdb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working
directory and source-file directory for your debugger.

\(fn COMMAND-LINE)" t nil)

(autoload 'sdb "gud" "\
Run sdb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

\(fn COMMAND-LINE)" t nil)

(autoload 'dbx "gud" "\
Run dbx on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

\(fn COMMAND-LINE)" t nil)

(autoload 'xdb "gud" "\
Run xdb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

You can set the variable `gud-xdb-directories' to a list of program source
directories if your program contains sources from more than one directory.

\(fn COMMAND-LINE)" t nil)

(autoload 'perldb "gud" "\
Run perldb on program FILE in buffer *gud-FILE*.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

\(fn COMMAND-LINE)" t nil)

(autoload 'pdb "gud" "\
Run pdb on program FILE in buffer `*gud-FILE*'.
The directory containing FILE becomes the initial working directory
and source-file directory for your debugger.

\(fn COMMAND-LINE)" t nil)

(autoload 'jdb "gud" "\
Run jdb with command line COMMAND-LINE in a buffer.
The buffer is named \"*gud*\" if no initial class is given or
\"*gud-<initial-class-basename>*\" if there is.  If the \"-classpath\"
switch is given, omit all whitespace between it and its value.

See `gud-jdb-use-classpath' and `gud-jdb-classpath' documentation for
information on how jdb accesses source files.  Alternatively (if
`gud-jdb-use-classpath' is nil), see `gud-jdb-directories' for the
original source file access method.

For general information about commands available to control jdb from
gud, see `gud-mode'.

\(fn COMMAND-LINE)" t nil)

(autoload 'gdb-script-mode "gud" "\
Major mode for editing GDB scripts.

\(fn)" t nil)

(defvar gud-tooltip-mode nil "\
Non-nil if Gud-Tooltip mode is enabled.
See the command `gud-tooltip-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `gud-tooltip-mode'.")

(custom-autoload 'gud-tooltip-mode "gud" nil)

(autoload 'gud-tooltip-mode "gud" "\
Toggle the display of GUD tooltips.
With a prefix argument ARG, enable the feature if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
it if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "gv" "emacs-lisp/gv.el" (21788 61018 0 0))
;;; Generated autoloads from emacs-lisp/gv.el

(autoload 'gv-get "gv" "\
Build the code that applies DO to PLACE.
PLACE must be a valid generalized variable.
DO must be a function; it will be called with 2 arguments: GETTER and SETTER,
where GETTER is a (copyable) Elisp expression that returns the value of PLACE,
and SETTER is a function which returns the code to set PLACE when called
with a (not necessarily copyable) Elisp expression that returns the value to
set it to.
DO must return an Elisp expression.

\(fn PLACE DO)" nil nil)

(autoload 'gv-letplace "gv" "\
Build the code manipulating the generalized variable PLACE.
GETTER will be bound to a copyable expression that returns the value
of PLACE.
SETTER will be bound to a function that takes an expression V and returns
a new expression that sets PLACE to V.
BODY should return some Elisp expression E manipulating PLACE via GETTER
and SETTER.
The returned value will then be an Elisp expression that first evaluates
all the parts of PLACE that can be evaluated and then runs E.

\(fn (GETTER SETTER) PLACE &rest BODY)" nil t)

(put 'gv-letplace 'lisp-indent-function '2)

(autoload 'gv-define-expander "gv" "\
Use HANDLER to handle NAME as a generalized var.
NAME is a symbol: the name of a function, macro, or special form.
HANDLER is a function which takes an argument DO followed by the same
arguments as NAME.  DO is a function as defined in `gv-get'.

\(fn NAME HANDLER)" nil t)

(put 'gv-define-expander 'lisp-indent-function '1)

(autoload 'gv--defun-declaration "gv" "\


\(fn SYMBOL NAME ARGS HANDLER &optional FIX)" nil nil)

(or (assq 'gv-expander defun-declarations-alist) (push `(gv-expander ,(apply-partially #'gv--defun-declaration 'gv-expander)) defun-declarations-alist))

(or (assq 'gv-setter defun-declarations-alist) (push `(gv-setter ,(apply-partially #'gv--defun-declaration 'gv-setter)) defun-declarations-alist))

(autoload 'gv-define-setter "gv" "\
Define a setter method for generalized variable NAME.
This macro is an easy-to-use substitute for `gv-define-expander' that works
well for simple place forms.
Assignments of VAL to (NAME ARGS...) are expanded by binding the argument
forms (VAL ARGS...) according to ARGLIST, then executing BODY, which must
return a Lisp form that does the assignment.
The first arg in ARGLIST (the one that receives VAL) receives an expression
which can do arbitrary things, whereas the other arguments are all guaranteed
to be pure and copyable.  Example use:
  (gv-define-setter aref (v a i) `(aset ,a ,i ,v))

\(fn NAME ARGLIST &rest BODY)" nil t)

(put 'gv-define-setter 'lisp-indent-function '2)

(autoload 'gv-define-simple-setter "gv" "\
Define a simple setter method for generalized variable NAME.
This macro is an easy-to-use substitute for `gv-define-expander' that works
well for simple place forms.  Assignments of VAL to (NAME ARGS...) are
turned into calls of the form (SETTER ARGS... VAL).

If FIX-RETURN is non-nil, then SETTER is not assumed to return VAL and
instead the assignment is turned into something equivalent to
  (let ((temp VAL))
    (SETTER ARGS... temp)
    temp)
so as to preserve the semantics of `setf'.

\(fn NAME SETTER &optional FIX-RETURN)" nil t)

(autoload 'setf "gv" "\
Set each PLACE to the value of its VAL.
This is a generalized version of `setq'; the PLACEs may be symbolic
references such as (car x) or (aref x i), as well as plain symbols.
For example, (setf (cadr x) y) is equivalent to (setcar (cdr x) y).
The return value is the last VAL in the list.

\(fn PLACE VAL PLACE VAL ...)" nil t)

(put 'gv-place 'edebug-form-spec 'edebug-match-form)

(autoload 'gv-ref "gv" "\
Return a reference to PLACE.
This is like the `&' operator of the C language.
Note: this only works reliably with lexical binding mode, except for very
simple PLACEs such as (function-symbol 'foo) which will also work in dynamic
binding mode.

\(fn PLACE)" nil t)

;;;***

;;;### (autoloads nil "handwrite" "play/handwrite.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from play/handwrite.el

(autoload 'handwrite "handwrite" "\
Turns the buffer into a \"handwritten\" document.
The functions `handwrite-10pt', `handwrite-11pt', `handwrite-12pt'
and `handwrite-13pt' set up for various sizes of output.

Variables: `handwrite-linespace'     (default 12)
           `handwrite-fontsize'      (default 11)
           `handwrite-numlines'      (default 60)
           `handwrite-pagenumbering' (default nil)

\(fn)" t nil)

;;;***

;;;### (autoloads nil "hanoi" "play/hanoi.el" (21676 8647 0 0))
;;; Generated autoloads from play/hanoi.el

(autoload 'hanoi "hanoi" "\
Towers of Hanoi diversion.  Use NRINGS rings.

\(fn NRINGS)" t nil)

(autoload 'hanoi-unix "hanoi" "\
Towers of Hanoi, UNIX doomsday version.
Displays 32-ring towers that have been progressing at one move per
second since 1970-01-01 00:00:00 GMT.

Repent before ring 31 moves.

\(fn)" t nil)

(autoload 'hanoi-unix-64 "hanoi" "\
Like hanoi-unix, but pretend to have a 64-bit clock.
This is, necessarily (as of Emacs 20.3), a crock.  When the
current-time interface is made s2G-compliant, hanoi.el will need
to be updated.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "hashcash" "mail/hashcash.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from mail/hashcash.el

(autoload 'hashcash-insert-payment "hashcash" "\
Insert X-Payment and X-Hashcash headers with a payment for ARG

\(fn ARG)" t nil)

(autoload 'hashcash-insert-payment-async "hashcash" "\
Insert X-Payment and X-Hashcash headers with a payment for ARG
Only start calculation.  Results are inserted when ready.

\(fn ARG)" t nil)

(autoload 'hashcash-verify-payment "hashcash" "\
Verify a hashcash payment

\(fn TOKEN &optional RESOURCE AMOUNT)" nil nil)

(autoload 'mail-add-payment "hashcash" "\
Add X-Payment: and X-Hashcash: headers with a hashcash payment
for each recipient address.  Prefix arg sets default payment temporarily.
Set ASYNC to t to start asynchronous calculation.  (See
`mail-add-payment-async').

\(fn &optional ARG ASYNC)" t nil)

(autoload 'mail-add-payment-async "hashcash" "\
Add X-Payment: and X-Hashcash: headers with a hashcash payment
for each recipient address.  Prefix arg sets default payment temporarily.
Calculation is asynchronous.

\(fn &optional ARG)" t nil)

(autoload 'mail-check-payment "hashcash" "\
Look for a valid X-Payment: or X-Hashcash: header.
Prefix arg sets default accept amount temporarily.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "help-at-pt" "help-at-pt.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from help-at-pt.el

(autoload 'help-at-pt-string "help-at-pt" "\
Return the help-echo string at point.
Normally, the string produced by the `help-echo' text or overlay
property, or nil, is returned.
If KBD is non-nil, `kbd-help' is used instead, and any
`help-echo' property is ignored.  In this case, the return value
can also be t, if that is the value of the `kbd-help' property.

\(fn &optional KBD)" nil nil)

(autoload 'help-at-pt-kbd-string "help-at-pt" "\
Return the keyboard help string at point.
If the `kbd-help' text or overlay property at point produces a
string, return it.  Otherwise, use the `help-echo' property.
If this produces no string either, return nil.

\(fn)" nil nil)

(autoload 'display-local-help "help-at-pt" "\
Display local help in the echo area.
This displays a short help message, namely the string produced by
the `kbd-help' property at point.  If `kbd-help' does not produce
a string, but the `help-echo' property does, then that string is
printed instead.

A numeric argument ARG prevents display of a message in case
there is no help.  While ARG can be used interactively, it is
mainly meant for use from Lisp.

\(fn &optional ARG)" t nil)

(autoload 'help-at-pt-cancel-timer "help-at-pt" "\
Cancel any timer set by `help-at-pt-set-timer'.
This disables `help-at-pt-display-when-idle'.

\(fn)" t nil)

(autoload 'help-at-pt-set-timer "help-at-pt" "\
Enable `help-at-pt-display-when-idle'.
This is done by setting a timer, if none is currently active.

\(fn)" t nil)

(defvar help-at-pt-display-when-idle 'never "\
Automatically show local help on point-over.
If the value is t, the string obtained from any `kbd-help' or
`help-echo' property at point is automatically printed in the
echo area, if nothing else is already displayed there, or after a
quit.  If both `kbd-help' and `help-echo' produce help strings,
`kbd-help' is used.  If the value is a list, the help only gets
printed if there is a text or overlay property at point that is
included in this list.  Suggested properties are `keymap',
`local-map', `button' and `kbd-help'.  Any value other than t or
a non-empty list disables the feature.

This variable only takes effect after a call to
`help-at-pt-set-timer'.  The help gets printed after Emacs has
been idle for `help-at-pt-timer-delay' seconds.  You can call
`help-at-pt-cancel-timer' to cancel the timer set by, and the
effect of, `help-at-pt-set-timer'.

When this variable is set through Custom, `help-at-pt-set-timer'
is called automatically, unless the value is `never', in which
case `help-at-pt-cancel-timer' is called.  Specifying an empty
list of properties through Custom will set the timer, thus
enabling buffer local values.  It sets the actual value to nil.
Thus, Custom distinguishes between a nil value and other values
that disable the feature, which Custom identifies with `never'.
The default is `never'.")

(custom-autoload 'help-at-pt-display-when-idle "help-at-pt" nil)

(autoload 'scan-buf-move-to-region "help-at-pt" "\
Go to the start of the next region with non-nil PROP property.
Then run HOOK, which should be a quoted symbol that is a normal
hook variable, or an expression evaluating to such a symbol.
Adjacent areas with different non-nil PROP properties are
considered different regions.

With numeric argument ARG, move to the start of the ARGth next
such region, then run HOOK.  If ARG is negative, move backward.
If point is already in a region, then that region does not count
toward ARG.  If ARG is 0 and point is inside a region, move to
the start of that region.  If ARG is 0 and point is not in a
region, print a message to that effect, but do not move point and
do not run HOOK.  If there are not enough regions to move over,
an error results and the number of available regions is mentioned
in the error message.  Point is not moved and HOOK is not run.

\(fn PROP &optional ARG HOOK)" nil nil)

(autoload 'scan-buf-next-region "help-at-pt" "\
Go to the start of the next region with non-nil help-echo.
Print the help found there using `display-local-help'.  Adjacent
areas with different non-nil help-echo properties are considered
different regions.

With numeric argument ARG, move to the start of the ARGth next
help-echo region.  If ARG is negative, move backward.  If point
is already in a help-echo region, then that region does not count
toward ARG.  If ARG is 0 and point is inside a help-echo region,
move to the start of that region.  If ARG is 0 and point is not
in such a region, just print a message to that effect.  If there
are not enough regions to move over, an error results and the
number of available regions is mentioned in the error message.

A potentially confusing subtlety is that point can be in a
help-echo region without any local help being available.  This is
because `help-echo' can be a function evaluating to nil.  This
rarely happens in practice.

\(fn &optional ARG)" t nil)

(autoload 'scan-buf-previous-region "help-at-pt" "\
Go to the start of the previous region with non-nil help-echo.
Print the help found there using `display-local-help'.  Adjacent
areas with different non-nil help-echo properties are considered
different regions.  With numeric argument ARG, behaves like
`scan-buf-next-region' with argument -ARG.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "help-fns" "help-fns.el" (21788 61018 0 0))
;;; Generated autoloads from help-fns.el

(autoload 'describe-function "help-fns" "\
Display the full documentation of FUNCTION (a symbol).

\(fn FUNCTION)" t nil)

(autoload 'help-C-file-name "help-fns" "\
Return the name of the C file where SUBR-OR-VAR is defined.
KIND should be `var' for a variable or `subr' for a subroutine.

\(fn SUBR-OR-VAR KIND)" nil nil)

(autoload 'find-lisp-object-file-name "help-fns" "\
Guess the file that defined the Lisp object OBJECT, of type TYPE.
OBJECT should be a symbol associated with a function, variable, or face;
  alternatively, it can be a function definition.
If TYPE is `defvar', search for a variable definition.
If TYPE is `defface', search for a face definition.
If TYPE is the value returned by `symbol-function' for a function symbol,
 search for a function definition.

The return value is the absolute name of a readable file where OBJECT is
defined.  If several such files exist, preference is given to a file
found via `load-path'.  The return value can also be `C-source', which
means that OBJECT is a function or variable defined in C.  If no
suitable file is found, return nil.

\(fn OBJECT TYPE)" nil nil)

(autoload 'describe-function-1 "help-fns" "\


\(fn FUNCTION)" nil nil)

(autoload 'variable-at-point "help-fns" "\
Return the bound variable symbol found at or before point.
Return 0 if there is no such symbol.
If ANY-SYMBOL is non-nil, don't insist the symbol be bound.

\(fn &optional ANY-SYMBOL)" nil nil)

(autoload 'describe-variable "help-fns" "\
Display the full documentation of VARIABLE (a symbol).
Returns the documentation as a string, also.
If VARIABLE has a buffer-local value in BUFFER or FRAME
\(default to the current buffer and current frame),
it is displayed along with the global value.

\(fn VARIABLE &optional BUFFER FRAME)" t nil)

(autoload 'describe-syntax "help-fns" "\
Describe the syntax specifications in the syntax table of BUFFER.
The descriptions are inserted in a help buffer, which is then displayed.
BUFFER defaults to the current buffer.

\(fn &optional BUFFER)" t nil)

(autoload 'describe-categories "help-fns" "\
Describe the category specifications in the current category table.
The descriptions are inserted in a buffer, which is then displayed.
If BUFFER is non-nil, then describe BUFFER's category table instead.
BUFFER should be a buffer or a buffer name.

\(fn &optional BUFFER)" t nil)

(autoload 'doc-file-to-man "help-fns" "\
Produce an nroff buffer containing the doc-strings from the DOC file.

\(fn FILE)" t nil)

(autoload 'doc-file-to-info "help-fns" "\
Produce a texinfo buffer with sorted doc-strings from the DOC file.

\(fn FILE)" t nil)

;;;***

;;;### (autoloads nil "help-macro" "help-macro.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from help-macro.el

(defvar three-step-help nil "\
Non-nil means give more info about Help command in three steps.
The three steps are simple prompt, prompt with all options, and
window listing and describing the options.
A value of nil means skip the middle step, so that \\[help-command] \\[help-command]
gives the window that lists the options.")

(custom-autoload 'three-step-help "help-macro" t)

;;;***

;;;### (autoloads nil "help-mode" "help-mode.el" (21788 61018 0 0))
;;; Generated autoloads from help-mode.el

(autoload 'help-mode "help-mode" "\
Major mode for viewing help text and navigating references in it.
Entry to this mode runs the normal hook `help-mode-hook'.
Commands:
\\{help-mode-map}

\(fn)" t nil)

(autoload 'help-mode-setup "help-mode" "\


\(fn)" nil nil)

(autoload 'help-mode-finish "help-mode" "\


\(fn)" nil nil)

(autoload 'help-setup-xref "help-mode" "\
Invoked from commands using the \"*Help*\" buffer to install some xref info.

ITEM is a (FUNCTION . ARGS) pair appropriate for recreating the help
buffer after following a reference.  INTERACTIVE-P is non-nil if the
calling command was invoked interactively.  In this case the stack of
items for help buffer \"back\" buttons is cleared.

This should be called very early, before the output buffer is cleared,
because we want to record the \"previous\" position of point so we can
restore it properly when going back.

\(fn ITEM INTERACTIVE-P)" nil nil)

(autoload 'help-buffer "help-mode" "\
Return the name of a buffer for inserting help.
If `help-xref-following' is non-nil, this is the name of the
current buffer.  Signal an error if this buffer is not derived
from `help-mode'.
Otherwise, return \"*Help*\", creating a buffer with that name if
it does not already exist.

\(fn)" nil nil)

(autoload 'help-make-xrefs "help-mode" "\
Parse and hyperlink documentation cross-references in the given BUFFER.

Find cross-reference information in a buffer and activate such cross
references for selection with `help-follow'.  Cross-references have
the canonical form `...'  and the type of reference may be
disambiguated by the preceding word(s) used in
`help-xref-symbol-regexp'.  Faces only get cross-referenced if
preceded or followed by the word `face'.  Variables without
variable documentation do not get cross-referenced, unless
preceded by the word `variable' or `option'.

If the variable `help-xref-mule-regexp' is non-nil, find also
cross-reference information related to multilingual environment
\(e.g., coding-systems).  This variable is also used to disambiguate
the type of reference as the same way as `help-xref-symbol-regexp'.

A special reference `back' is made to return back through a stack of
help buffers.  Variable `help-back-label' specifies the text for
that.

\(fn &optional BUFFER)" t nil)

(autoload 'help-xref-button "help-mode" "\
Make a hyperlink for cross-reference text previously matched.
MATCH-NUMBER is the subexpression of interest in the last matched
regexp.  TYPE is the type of button to use.  Any remaining arguments are
passed to the button's help-function when it is invoked.
See `help-make-xrefs'.

\(fn MATCH-NUMBER TYPE &rest ARGS)" nil nil)

(autoload 'help-insert-xref-button "help-mode" "\
Insert STRING and make a hyperlink from cross-reference text on it.
TYPE is the type of button to use.  Any remaining arguments are passed
to the button's help-function when it is invoked.
See `help-make-xrefs'.

\(fn STRING TYPE &rest ARGS)" nil nil)

(autoload 'help-xref-on-pp "help-mode" "\
Add xrefs for symbols in `pp's output between FROM and TO.

\(fn FROM TO)" nil nil)

(autoload 'help-bookmark-jump "help-mode" "\
Jump to help-mode bookmark BOOKMARK.
Handler function for record returned by `help-bookmark-make-record'.
BOOKMARK is a bookmark name or a bookmark record.

\(fn BOOKMARK)" nil nil)

;;;***

;;;### (autoloads nil "helper" "emacs-lisp/helper.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/helper.el

(autoload 'Helper-describe-bindings "helper" "\
Describe local key bindings of current mode.

\(fn)" t nil)

(autoload 'Helper-help "helper" "\
Provide help for current mode.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "hexl" "hexl.el" (21788 61018 0 0))
;;; Generated autoloads from hexl.el

(autoload 'hexl-mode "hexl" "\
\\<hexl-mode-map>A mode for editing binary files in hex dump format.
This is not an ordinary major mode; it alters some aspects
of the current mode's behavior, but not all; also, you can exit
Hexl mode and return to the previous mode using `hexl-mode-exit'.

This function automatically converts a buffer into the hexl format
using the function `hexlify-buffer'.

Each line in the buffer has an \"address\" (displayed in hexadecimal)
representing the offset into the file that the characters on this line
are at and 16 characters from the file (displayed as hexadecimal
values grouped every `hexl-bits' bits, and as their ASCII values).

If any of the characters (displayed as ASCII characters) are
unprintable (control or meta characters) they will be replaced by
periods.

If `hexl-mode' is invoked with an argument the buffer is assumed to be
in hexl format.

A sample format:

  HEX ADDR: 0001 0203 0405 0607 0809 0a0b 0c0d 0e0f     ASCII-TEXT
  --------  ---- ---- ---- ---- ---- ---- ---- ----  ----------------
  00000000: 5468 6973 2069 7320 6865 786c 2d6d 6f64  This is hexl-mod
  00000010: 652e 2020 4561 6368 206c 696e 6520 7265  e.  Each line re
  00000020: 7072 6573 656e 7473 2031 3620 6279 7465  presents 16 byte
  00000030: 7320 6173 2068 6578 6164 6563 696d 616c  s as hexadecimal
  00000040: 2041 5343 4949 0a61 6e64 2070 7269 6e74   ASCII.and print
  00000050: 6162 6c65 2041 5343 4949 2063 6861 7261  able ASCII chara
  00000060: 6374 6572 732e 2020 416e 7920 636f 6e74  cters.  Any cont
  00000070: 726f 6c20 6f72 206e 6f6e 2d41 5343 4949  rol or non-ASCII
  00000080: 2063 6861 7261 6374 6572 730a 6172 6520   characters.are
  00000090: 6469 7370 6c61 7965 6420 6173 2070 6572  displayed as per
  000000a0: 696f 6473 2069 6e20 7468 6520 7072 696e  iods in the prin
  000000b0: 7461 626c 6520 6368 6172 6163 7465 7220  table character
  000000c0: 7265 6769 6f6e 2e0a                      region..

Movement is as simple as movement in a normal Emacs text buffer.
Most cursor movement bindings are the same: use \\[hexl-backward-char], \\[hexl-forward-char], \\[hexl-next-line], and \\[hexl-previous-line]
to move the cursor left, right, down, and up.

Advanced cursor movement commands (ala \\[hexl-beginning-of-line], \\[hexl-end-of-line], \\[hexl-beginning-of-buffer], and \\[hexl-end-of-buffer]) are
also supported.

There are several ways to change text in hexl mode:

ASCII characters (character between space (0x20) and tilde (0x7E)) are
bound to self-insert so you can simply type the character and it will
insert itself (actually overstrike) into the buffer.

\\[hexl-quoted-insert] followed by another keystroke allows you to insert the key even if
it isn't bound to self-insert.  An octal number can be supplied in place
of another key to insert the octal number's ASCII representation.

\\[hexl-insert-hex-char] will insert a given hexadecimal value (if it is between 0 and 0xFF)
into the buffer at the current point.

\\[hexl-insert-octal-char] will insert a given octal value (if it is between 0 and 0377)
into the buffer at the current point.

\\[hexl-insert-decimal-char] will insert a given decimal value (if it is between 0 and 255)
into the buffer at the current point.

\\[hexl-mode-exit] will exit `hexl-mode'.

Note: saving the file with any of the usual Emacs commands
will actually convert it back to binary format while saving.

You can use \\[hexl-find-file] to visit a file in Hexl mode.

\\[describe-bindings] for advanced commands.

\(fn &optional ARG)" t nil)

(autoload 'hexl-find-file "hexl" "\
Edit file FILENAME as a binary file in hex dump format.
Switch to a buffer visiting file FILENAME, creating one if none exists,
and edit the file in `hexl-mode'.

\(fn FILENAME)" t nil)

(autoload 'hexlify-buffer "hexl" "\
Convert a binary buffer to hexl format.
This discards the buffer's undo information.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "hi-lock" "hi-lock.el" (21788 61018 0 0))
;;; Generated autoloads from hi-lock.el

(autoload 'hi-lock-mode "hi-lock" "\
Toggle selective highlighting of patterns (Hi Lock mode).
With a prefix argument ARG, enable Hi Lock mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Hi Lock mode is automatically enabled when you invoke any of the
highlighting commands listed below, such as \\[highlight-regexp].
To enable Hi Lock mode in all buffers, use `global-hi-lock-mode'
or add (global-hi-lock-mode 1) to your init file.

In buffers where Font Lock mode is enabled, patterns are
highlighted using font lock.  In buffers where Font Lock mode is
disabled, patterns are applied using overlays; in this case, the
highlighting will not be updated as you type.

When Hi Lock mode is enabled, a \"Regexp Highlighting\" submenu
is added to the \"Edit\" menu.  The commands in the submenu,
which can be called interactively, are:

\\[highlight-regexp] REGEXP FACE
  Highlight matches of pattern REGEXP in current buffer with FACE.

\\[highlight-phrase] PHRASE FACE
  Highlight matches of phrase PHRASE in current buffer with FACE.
  (PHRASE can be any REGEXP, but spaces will be replaced by matches
  to whitespace and initial lower-case letters will become case insensitive.)

\\[highlight-lines-matching-regexp] REGEXP FACE
  Highlight lines containing matches of REGEXP in current buffer with FACE.

\\[highlight-symbol-at-point]
  Highlight the symbol found near point without prompting, using the next
  available face automatically.

\\[unhighlight-regexp] REGEXP
  Remove highlighting on matches of REGEXP in current buffer.

\\[hi-lock-write-interactive-patterns]
  Write active REGEXPs into buffer as comments (if possible).  They may
  be read the next time file is loaded or when the \\[hi-lock-find-patterns] command
  is issued.  The inserted regexps are in the form of font lock keywords.
  (See `font-lock-keywords'.)  They may be edited and re-loaded with \\[hi-lock-find-patterns],
  any valid `font-lock-keywords' form is acceptable.  When a file is
  loaded the patterns are read if `hi-lock-file-patterns-policy' is
  'ask and the user responds y to the prompt, or if
  `hi-lock-file-patterns-policy' is bound to a function and that
  function returns t.

\\[hi-lock-find-patterns]
  Re-read patterns stored in buffer (in the format produced by \\[hi-lock-write-interactive-patterns]).

When hi-lock is started and if the mode is not excluded or patterns
rejected, the beginning of the buffer is searched for lines of the
form:
  Hi-lock: FOO

where FOO is a list of patterns.  The patterns must start before
position (number of characters into buffer)
`hi-lock-file-patterns-range'.  Patterns will be read until
Hi-lock: end is found.  A mode is excluded if it's in the list
`hi-lock-exclude-modes'.

\(fn &optional ARG)" t nil)

(defvar global-hi-lock-mode nil "\
Non-nil if Global-Hi-Lock mode is enabled.
See the command `global-hi-lock-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-hi-lock-mode'.")

(custom-autoload 'global-hi-lock-mode "hi-lock" nil)

(autoload 'global-hi-lock-mode "hi-lock" "\
Toggle Hi-Lock mode in all buffers.
With prefix ARG, enable Global-Hi-Lock mode if ARG is positive;
otherwise, disable it.  If called from Lisp, enable the mode if
ARG is omitted or nil.

Hi-Lock mode is enabled in all buffers where
`turn-on-hi-lock-if-enabled' would do it.
See `hi-lock-mode' for more information on Hi-Lock mode.

\(fn &optional ARG)" t nil)

(defalias 'highlight-lines-matching-regexp 'hi-lock-line-face-buffer)

(autoload 'hi-lock-line-face-buffer "hi-lock" "\
Set face of all lines containing a match of REGEXP to FACE.
Interactively, prompt for REGEXP using `read-regexp', then FACE.
Use the global history list for FACE.

Use Font lock mode, if enabled, to highlight REGEXP.  Otherwise,
use overlays for highlighting.  If overlays are used, the
highlighting will not update as you type.

\(fn REGEXP &optional FACE)" t nil)

(defalias 'highlight-regexp 'hi-lock-face-buffer)

(autoload 'hi-lock-face-buffer "hi-lock" "\
Set face of each match of REGEXP to FACE.
Interactively, prompt for REGEXP using `read-regexp', then FACE.
Use the global history list for FACE.

Use Font lock mode, if enabled, to highlight REGEXP.  Otherwise,
use overlays for highlighting.  If overlays are used, the
highlighting will not update as you type.

\(fn REGEXP &optional FACE)" t nil)

(defalias 'highlight-phrase 'hi-lock-face-phrase-buffer)

(autoload 'hi-lock-face-phrase-buffer "hi-lock" "\
Set face of each match of phrase REGEXP to FACE.
Interactively, prompt for REGEXP using `read-regexp', then FACE.
Use the global history list for FACE.

When called interactively, replace whitespace in user-provided
regexp with arbitrary whitespace, and make initial lower-case
letters case-insensitive, before highlighting with `hi-lock-set-pattern'.

Use Font lock mode, if enabled, to highlight REGEXP.  Otherwise,
use overlays for highlighting.  If overlays are used, the
highlighting will not update as you type.

\(fn REGEXP &optional FACE)" t nil)

(defalias 'highlight-symbol-at-point 'hi-lock-face-symbol-at-point)

(autoload 'hi-lock-face-symbol-at-point "hi-lock" "\
Highlight each instance of the symbol at point.
Uses the next face from `hi-lock-face-defaults' without prompting,
unless you use a prefix argument.
Uses `find-tag-default-as-symbol-regexp' to retrieve the symbol at point.

This uses Font lock mode if it is enabled; otherwise it uses overlays,
in which case the highlighting will not update as you type.

\(fn)" t nil)

(defalias 'unhighlight-regexp 'hi-lock-unface-buffer)

(autoload 'hi-lock-unface-buffer "hi-lock" "\
Remove highlighting of each match to REGEXP set by hi-lock.
Interactively, prompt for REGEXP, accepting only regexps
previously inserted by hi-lock interactive functions.
If REGEXP is t (or if \\[universal-argument] was specified interactively),
then remove all hi-lock highlighting.

\(fn REGEXP)" t nil)

(autoload 'hi-lock-write-interactive-patterns "hi-lock" "\
Write interactively added patterns, if any, into buffer at point.

Interactively added patterns are those normally specified using
`highlight-regexp' and `highlight-lines-matching-regexp'; they can
be found in variable `hi-lock-interactive-patterns'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "hideif" "progmodes/hideif.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/hideif.el

(autoload 'hide-ifdef-mode "hideif" "\
Toggle features to hide/show #ifdef blocks (Hide-Ifdef mode).
With a prefix argument ARG, enable Hide-Ifdef mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Hide-Ifdef mode is a buffer-local minor mode for use with C and
C-like major modes.  When enabled, code within #ifdef constructs
that the C preprocessor would eliminate may be hidden from view.
Several variables affect how the hiding is done:

`hide-ifdef-env'
	An association list of defined and undefined symbols for the
	current buffer.  Initially, the global value of `hide-ifdef-env'
	is used.

`hide-ifdef-define-alist'
	An association list of defined symbol lists.
        Use `hide-ifdef-set-define-alist' to save the current `hide-ifdef-env'
        and `hide-ifdef-use-define-alist' to set the current `hide-ifdef-env'
        from one of the lists in `hide-ifdef-define-alist'.

`hide-ifdef-lines'
	Set to non-nil to not show #if, #ifdef, #ifndef, #else, and
	#endif lines when hiding.

`hide-ifdef-initially'
	Indicates whether `hide-ifdefs' should be called when Hide-Ifdef mode
	is activated.

`hide-ifdef-read-only'
	Set to non-nil if you want to make buffers read only while hiding.
	After `show-ifdefs', read-only status is restored to previous value.

\\{hide-ifdef-mode-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "hideshow" "progmodes/hideshow.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/hideshow.el

(defvar hs-special-modes-alist (mapcar 'purecopy '((c-mode "{" "}" "/[*/]" nil nil) (c++-mode "{" "}" "/[*/]" nil nil) (bibtex-mode ("@\\S(*\\(\\s(\\)" 1)) (java-mode "{" "}" "/[*/]" nil nil) (js-mode "{" "}" "/[*/]" nil))) "\
Alist for initializing the hideshow variables for different modes.
Each element has the form
  (MODE START END COMMENT-START FORWARD-SEXP-FUNC ADJUST-BEG-FUNC).

If non-nil, hideshow will use these values as regexps to define blocks
and comments, respectively for major mode MODE.

START, END and COMMENT-START are regular expressions.  A block is
defined as text surrounded by START and END.

As a special case, START may be a list of the form (COMPLEX-START
MDATA-SELECTOR), where COMPLEX-START is a regexp w/ multiple parts and
MDATA-SELECTOR an integer that specifies which sub-match is the proper
place to adjust point, before calling `hs-forward-sexp-func'.  Point
is adjusted to the beginning of the specified match.  For example,
see the `hs-special-modes-alist' entry for `bibtex-mode'.

For some major modes, `forward-sexp' does not work properly.  In those
cases, FORWARD-SEXP-FUNC specifies another function to use instead.

See the documentation for `hs-adjust-block-beginning' to see what is the
use of ADJUST-BEG-FUNC.

If any of the elements is left nil or omitted, hideshow tries to guess
appropriate values.  The regexps should not contain leading or trailing
whitespace.  Case does not matter.")

(autoload 'hs-minor-mode "hideshow" "\
Minor mode to selectively hide/show code and comment blocks.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

When hideshow minor mode is on, the menu bar is augmented with hideshow
commands and the hideshow commands are enabled.
The value '(hs . t) is added to `buffer-invisibility-spec'.

The main commands are: `hs-hide-all', `hs-show-all', `hs-hide-block',
`hs-show-block', `hs-hide-level' and `hs-toggle-hiding'.  There is also
`hs-hide-initial-comment-block' and `hs-mouse-toggle-hiding'.

Turning hideshow minor mode off reverts the menu bar and the
variables to default values and disables the hideshow commands.

Lastly, the normal hook `hs-minor-mode-hook' is run using `run-hooks'.

Key bindings:
\\{hs-minor-mode-map}

\(fn &optional ARG)" t nil)

(autoload 'turn-off-hideshow "hideshow" "\
Unconditionally turn off `hs-minor-mode'.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "hilit-chg" "hilit-chg.el" (21710 25077 0 0))
;;; Generated autoloads from hilit-chg.el

(autoload 'highlight-changes-mode "hilit-chg" "\
Toggle highlighting changes in this buffer (Highlight Changes mode).
With a prefix argument ARG, enable Highlight Changes mode if ARG
is positive, and disable it otherwise.  If called from Lisp,
enable the mode if ARG is omitted or nil.

When Highlight Changes is enabled, changes are marked with a text
property.  Normally they are displayed in a distinctive face, but
command \\[highlight-changes-visible-mode] can be used to toggle
this on and off.

Other functions for buffers in this mode include:
\\[highlight-changes-next-change] - move point to beginning of next change
\\[highlight-changes-previous-change] - move to beginning of previous change
\\[highlight-changes-remove-highlight] - remove the change face from the region
\\[highlight-changes-rotate-faces] - rotate different \"ages\" of changes
through	various faces.
\\[highlight-compare-with-file] - mark text as changed by comparing this
buffer with the contents of a file
\\[highlight-compare-buffers] highlights differences between two buffers.

\(fn &optional ARG)" t nil)

(autoload 'highlight-changes-visible-mode "hilit-chg" "\
Toggle visibility of highlighting due to Highlight Changes mode.
With a prefix argument ARG, enable Highlight Changes Visible mode
if ARG is positive, and disable it otherwise.  If called from
Lisp, enable the mode if ARG is omitted or nil.

Highlight Changes Visible mode only has an effect when Highlight
Changes mode is on.  When enabled, the changed text is displayed
in a distinctive face.

The default value can be customized with variable
`highlight-changes-visibility-initial-state'.

This command does not itself set Highlight Changes mode.

\(fn &optional ARG)" t nil)

(autoload 'highlight-changes-remove-highlight "hilit-chg" "\
Remove the change face from the region between BEG and END.
This allows you to manually remove highlighting from uninteresting changes.

\(fn BEG END)" t nil)

(autoload 'highlight-changes-next-change "hilit-chg" "\
Move to the beginning of the next change, if in Highlight Changes mode.

\(fn)" t nil)

(autoload 'highlight-changes-previous-change "hilit-chg" "\
Move to the beginning of the previous change, if in Highlight Changes mode.

\(fn)" t nil)

(autoload 'highlight-changes-rotate-faces "hilit-chg" "\
Rotate the faces if in Highlight Changes mode and the changes are visible.

Current changes are displayed in the face described by the first element
of `highlight-changes-face-list', one level older changes are shown in
face described by the second element, and so on.  Very old changes remain
shown in the last face in the list.

You can automatically rotate colors when the buffer is saved by adding
this function to `write-file-functions' as a buffer-local value.  To do
this, eval the following in the buffer to be saved:

  (add-hook 'write-file-functions 'highlight-changes-rotate-faces nil t)

\(fn)" t nil)

(autoload 'highlight-compare-buffers "hilit-chg" "\
Compare two buffers and highlight the differences.

The default is the current buffer and the one in the next window.

If either buffer is modified and is visiting a file, you are prompted
to save the file.

Unless the buffer is unmodified and visiting a file, the buffer is
written to a temporary file for comparison.

If a buffer is read-only, differences will be highlighted but no property
changes are made, so \\[highlight-changes-next-change] and
\\[highlight-changes-previous-change] will not work.

\(fn BUF-A BUF-B)" t nil)

(autoload 'highlight-compare-with-file "hilit-chg" "\
Compare this buffer with a file, and highlight differences.

If the buffer has a backup filename, it is used as the default when
this function is called interactively.

If the current buffer is visiting the file being compared against, it
also will have its differences highlighted.  Otherwise, the file is
read in temporarily but the buffer is deleted.

If the buffer is read-only, differences will be highlighted but no property
changes are made, so \\[highlight-changes-next-change] and
\\[highlight-changes-previous-change] will not work.

\(fn FILE-B)" t nil)

(defvar global-highlight-changes-mode nil "\
Non-nil if Global-Highlight-Changes mode is enabled.
See the command `global-highlight-changes-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-highlight-changes-mode'.")

(custom-autoload 'global-highlight-changes-mode "hilit-chg" nil)

(autoload 'global-highlight-changes-mode "hilit-chg" "\
Toggle Highlight-Changes mode in all buffers.
With prefix ARG, enable Global-Highlight-Changes mode if ARG is positive;
otherwise, disable it.  If called from Lisp, enable the mode if
ARG is omitted or nil.

Highlight-Changes mode is enabled in all buffers where
`highlight-changes-mode-turn-on' would do it.
See `highlight-changes-mode' for more information on Highlight-Changes mode.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "hippie-exp" "hippie-exp.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from hippie-exp.el
(push (purecopy '(hippie-exp 1 6)) package--builtin-versions)

(defvar hippie-expand-try-functions-list '(try-complete-file-name-partially try-complete-file-name try-expand-all-abbrevs try-expand-list try-expand-line try-expand-dabbrev try-expand-dabbrev-all-buffers try-expand-dabbrev-from-kill try-complete-lisp-symbol-partially try-complete-lisp-symbol) "\
The list of expansion functions tried in order by `hippie-expand'.
To change the behavior of `hippie-expand', remove, change the order of,
or insert functions in this list.")

(custom-autoload 'hippie-expand-try-functions-list "hippie-exp" t)

(autoload 'hippie-expand "hippie-exp" "\
Try to expand text before point, using multiple methods.
The expansion functions in `hippie-expand-try-functions-list' are
tried in order, until a possible expansion is found.  Repeated
application of `hippie-expand' inserts successively possible
expansions.
With a positive numeric argument, jumps directly to the ARG next
function in this list.  With a negative argument or just \\[universal-argument],
undoes the expansion.

\(fn ARG)" t nil)

(autoload 'make-hippie-expand-function "hippie-exp" "\
Construct a function similar to `hippie-expand'.
Make it use the expansion functions in TRY-LIST.  An optional second
argument VERBOSE non-nil makes the function verbose.

\(fn TRY-LIST &optional VERBOSE)" nil t)

;;;***

;;;### (autoloads nil "hl-line" "hl-line.el" (21710 25077 0 0))
;;; Generated autoloads from hl-line.el

(autoload 'hl-line-mode "hl-line" "\
Toggle highlighting of the current line (Hl-Line mode).
With a prefix argument ARG, enable Hl-Line mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Hl-Line mode is a buffer-local minor mode.  If
`hl-line-sticky-flag' is non-nil, Hl-Line mode highlights the
line about the buffer's point in all windows.  Caveat: the
buffer's point might be different from the point of a
non-selected window.  Hl-Line mode uses the function
`hl-line-highlight' on `post-command-hook' in this case.

When `hl-line-sticky-flag' is nil, Hl-Line mode highlights the
line about point in the selected window only.  In this case, it
uses the function `hl-line-unhighlight' on `pre-command-hook' in
addition to `hl-line-highlight' on `post-command-hook'.

\(fn &optional ARG)" t nil)

(defvar global-hl-line-mode nil "\
Non-nil if Global-Hl-Line mode is enabled.
See the command `global-hl-line-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-hl-line-mode'.")

(custom-autoload 'global-hl-line-mode "hl-line" nil)

(autoload 'global-hl-line-mode "hl-line" "\
Toggle line highlighting in all buffers (Global Hl-Line mode).
With a prefix argument ARG, enable Global Hl-Line mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

If `global-hl-line-sticky-flag' is non-nil, Global Hl-Line mode
highlights the line about the current buffer's point in all
windows.

Global-Hl-Line mode uses the functions `global-hl-line-unhighlight' and
`global-hl-line-highlight' on `pre-command-hook' and `post-command-hook'.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "holidays" "calendar/holidays.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from calendar/holidays.el

(define-obsolete-variable-alias 'general-holidays 'holiday-general-holidays "23.1")

(defvar holiday-general-holidays (mapcar 'purecopy '((holiday-fixed 1 1 "New Year's Day") (holiday-float 1 1 3 "Martin Luther King Day") (holiday-fixed 2 2 "Groundhog Day") (holiday-fixed 2 14 "Valentine's Day") (holiday-float 2 1 3 "President's Day") (holiday-fixed 3 17 "St. Patrick's Day") (holiday-fixed 4 1 "April Fools' Day") (holiday-float 5 0 2 "Mother's Day") (holiday-float 5 1 -1 "Memorial Day") (holiday-fixed 6 14 "Flag Day") (holiday-float 6 0 3 "Father's Day") (holiday-fixed 7 4 "Independence Day") (holiday-float 9 1 1 "Labor Day") (holiday-float 10 1 2 "Columbus Day") (holiday-fixed 10 31 "Halloween") (holiday-fixed 11 11 "Veteran's Day") (holiday-float 11 4 4 "Thanksgiving"))) "\
General holidays.  Default value is for the United States.
See the documentation for `calendar-holidays' for details.")

(custom-autoload 'holiday-general-holidays "holidays" t)

(put 'holiday-general-holidays 'risky-local-variable t)

(define-obsolete-variable-alias 'oriental-holidays 'holiday-oriental-holidays "23.1")

(defvar holiday-oriental-holidays (mapcar 'purecopy '((holiday-chinese-new-year) (if calendar-chinese-all-holidays-flag (append (holiday-chinese 1 15 "Lantern Festival") (holiday-chinese-qingming) (holiday-chinese 5 5 "Dragon Boat Festival") (holiday-chinese 7 7 "Double Seventh Festival") (holiday-chinese 8 15 "Mid-Autumn Festival") (holiday-chinese 9 9 "Double Ninth Festival") (holiday-chinese-winter-solstice))))) "\
Oriental holidays.
See the documentation for `calendar-holidays' for details.")

(custom-autoload 'holiday-oriental-holidays "holidays" t)

(put 'holiday-oriental-holidays 'risky-local-variable t)

(define-obsolete-variable-alias 'local-holidays 'holiday-local-holidays "23.1")

(defvar holiday-local-holidays nil "\
Local holidays.
See the documentation for `calendar-holidays' for details.")

(custom-autoload 'holiday-local-holidays "holidays" t)

(put 'holiday-local-holidays 'risky-local-variable t)

(define-obsolete-variable-alias 'other-holidays 'holiday-other-holidays "23.1")

(defvar holiday-other-holidays nil "\
User defined holidays.
See the documentation for `calendar-holidays' for details.")

(custom-autoload 'holiday-other-holidays "holidays" t)

(put 'holiday-other-holidays 'risky-local-variable t)

(defvar hebrew-holidays-1 (mapcar 'purecopy '((holiday-hebrew-rosh-hashanah) (if calendar-hebrew-all-holidays-flag (holiday-julian 11 (let ((m displayed-month) (y displayed-year) year) (calendar-increment-month m y -1) (setq year (calendar-extract-year (calendar-julian-from-absolute (calendar-absolute-from-gregorian (list m 1 y))))) (if (zerop (% (1+ year) 4)) 22 21)) "\"Tal Umatar\" (evening)")))) "\
Component of the old default value of `holiday-hebrew-holidays'.")

(put 'hebrew-holidays-1 'risky-local-variable t)

(defvar hebrew-holidays-2 (mapcar 'purecopy '((holiday-hebrew-hanukkah) (if calendar-hebrew-all-holidays-flag (holiday-hebrew 10 (let ((h-year (calendar-extract-year (calendar-hebrew-from-absolute (calendar-absolute-from-gregorian (list displayed-month 28 displayed-year)))))) (if (= 6 (% (calendar-hebrew-to-absolute (list 10 10 h-year)) 7)) 11 10)) "Tzom Teveth")) (if calendar-hebrew-all-holidays-flag (holiday-hebrew 11 15 "Tu B'Shevat")))) "\
Component of the old default value of `holiday-hebrew-holidays'.")

(put 'hebrew-holidays-2 'risky-local-variable t)

(defvar hebrew-holidays-3 (mapcar 'purecopy '((if calendar-hebrew-all-holidays-flag (holiday-hebrew 11 (let* ((m displayed-month) (y displayed-year) (h-year (progn (calendar-increment-month m y 1) (calendar-extract-year (calendar-hebrew-from-absolute (calendar-absolute-from-gregorian (list m (calendar-last-day-of-month m y) y)))))) (s-s (calendar-hebrew-from-absolute (if (= 6 (% (calendar-hebrew-to-absolute (list 7 1 h-year)) 7)) (calendar-dayname-on-or-before 6 (calendar-hebrew-to-absolute (list 11 17 h-year))) (calendar-dayname-on-or-before 6 (calendar-hebrew-to-absolute (list 11 16 h-year)))))) (day (calendar-extract-day s-s))) day) "Shabbat Shirah")))) "\
Component of the old default value of `holiday-hebrew-holidays'.")

(put 'hebrew-holidays-3 'risky-local-variable t)

(defvar hebrew-holidays-4 (mapcar 'purecopy '((holiday-hebrew-passover) (and calendar-hebrew-all-holidays-flag (let* ((m displayed-month) (y displayed-year) (year (progn (calendar-increment-month m y -1) (calendar-extract-year (calendar-julian-from-absolute (calendar-absolute-from-gregorian (list m 1 y))))))) (= 21 (% year 28))) (holiday-julian 3 26 "Kiddush HaHamah")) (if calendar-hebrew-all-holidays-flag (holiday-hebrew-tisha-b-av)))) "\
Component of the old default value of `holiday-hebrew-holidays'.")

(put 'hebrew-holidays-4 'risky-local-variable t)

(define-obsolete-variable-alias 'hebrew-holidays 'holiday-hebrew-holidays "23.1")

(defvar holiday-hebrew-holidays (mapcar 'purecopy '((holiday-hebrew-passover) (holiday-hebrew-rosh-hashanah) (holiday-hebrew-hanukkah) (if calendar-hebrew-all-holidays-flag (append (holiday-hebrew-tisha-b-av) (holiday-hebrew-misc))))) "\
Jewish holidays.
See the documentation for `calendar-holidays' for details.")

(custom-autoload 'holiday-hebrew-holidays "holidays" t)

(put 'holiday-hebrew-holidays 'risky-local-variable t)

(define-obsolete-variable-alias 'christian-holidays 'holiday-christian-holidays "23.1")

(defvar holiday-christian-holidays (mapcar 'purecopy '((holiday-easter-etc) (holiday-fixed 12 25 "Christmas") (if calendar-christian-all-holidays-flag (append (holiday-fixed 1 6 "Epiphany") (holiday-julian 12 25 "Christmas (Julian calendar)") (holiday-greek-orthodox-easter) (holiday-fixed 8 15 "Assumption") (holiday-advent 0 "Advent"))))) "\
Christian holidays.
See the documentation for `calendar-holidays' for details.")

(custom-autoload 'holiday-christian-holidays "holidays" t)

(put 'holiday-christian-holidays 'risky-local-variable t)

(define-obsolete-variable-alias 'islamic-holidays 'holiday-islamic-holidays "23.1")

(defvar holiday-islamic-holidays (mapcar 'purecopy '((holiday-islamic-new-year) (holiday-islamic 9 1 "Ramadan Begins") (if calendar-islamic-all-holidays-flag (append (holiday-islamic 1 10 "Ashura") (holiday-islamic 3 12 "Mulad-al-Nabi") (holiday-islamic 7 26 "Shab-e-Mi'raj") (holiday-islamic 8 15 "Shab-e-Bara't") (holiday-islamic 9 27 "Shab-e Qadr") (holiday-islamic 10 1 "Id-al-Fitr") (holiday-islamic 12 10 "Id-al-Adha"))))) "\
Islamic holidays.
See the documentation for `calendar-holidays' for details.")

(custom-autoload 'holiday-islamic-holidays "holidays" t)

(put 'holiday-islamic-holidays 'risky-local-variable t)

(define-obsolete-variable-alias 'bahai-holidays 'holiday-bahai-holidays "23.1")

(defvar holiday-bahai-holidays (mapcar 'purecopy '((holiday-bahai-new-year) (holiday-bahai-ridvan) (holiday-fixed 5 23 "Declaration of the Báb") (holiday-fixed 5 29 "Ascension of Bahá'u'lláh") (holiday-fixed 7 9 "Martyrdom of the Báb") (holiday-fixed 10 20 "Birth of the Báb") (holiday-fixed 11 12 "Birth of Bahá'u'lláh") (if calendar-bahai-all-holidays-flag (append (holiday-fixed 11 26 "Day of the Covenant") (holiday-fixed 11 28 "Ascension of `Abdu'l-Bahá"))))) "\
Bahá'í holidays.
See the documentation for `calendar-holidays' for details.")

(custom-autoload 'holiday-bahai-holidays "holidays" t)

(put 'holiday-bahai-holidays 'risky-local-variable t)

(define-obsolete-variable-alias 'solar-holidays 'holiday-solar-holidays "23.1")

(defvar holiday-solar-holidays (mapcar 'purecopy '((solar-equinoxes-solstices) (holiday-sexp calendar-daylight-savings-starts (format "Daylight Saving Time Begins %s" (solar-time-string (/ calendar-daylight-savings-starts-time (float 60)) calendar-standard-time-zone-name))) (holiday-sexp calendar-daylight-savings-ends (format "Daylight Saving Time Ends %s" (solar-time-string (/ calendar-daylight-savings-ends-time (float 60)) calendar-daylight-time-zone-name))))) "\
Sun-related holidays.
See the documentation for `calendar-holidays' for details.")

(custom-autoload 'holiday-solar-holidays "holidays" t)

(put 'holiday-solar-holidays 'risky-local-variable t)

(put 'calendar-holidays 'risky-local-variable t)

(autoload 'holidays "holidays" "\
Display the holidays for last month, this month, and next month.
If called with an optional prefix argument ARG, prompts for month and year.
This function is suitable for execution in a init file.

\(fn &optional ARG)" t nil)

(autoload 'list-holidays "holidays" "\
Display holidays for years Y1 to Y2 (inclusive).
Y2 defaults to Y1.  The optional list of holidays L defaults to
`calendar-holidays'.  If you want to control what holidays are
displayed, use a different list.  For example,

  (list-holidays 2006 2006
    (append holiday-general-holidays holiday-local-holidays))

will display holidays for the year 2006 defined in the two
mentioned lists, and nothing else.

When called interactively, this command offers a choice of
holidays, based on the variables `holiday-solar-holidays' etc.  See the
documentation of `calendar-holidays' for a list of the variables
that control the choices, as well as a description of the format
of a holiday list.

The optional LABEL is used to label the buffer created.

\(fn Y1 &optional Y2 L LABEL)" t nil)

(defalias 'holiday-list 'list-holidays)

;;;***

;;;### (autoloads nil "html2text" "gnus/html2text.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/html2text.el

(autoload 'html2text "html2text" "\
Convert HTML to plain text in the current buffer.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "htmlfontify" "htmlfontify.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from htmlfontify.el
(push (purecopy '(htmlfontify 0 21)) package--builtin-versions)

(autoload 'htmlfontify-buffer "htmlfontify" "\
Create a new buffer, named for the current buffer + a .html extension,
containing an inline CSS-stylesheet and formatted CSS-markup HTML
that reproduces the look of the current Emacs buffer as closely
as possible.

Dangerous characters in the existing buffer are turned into HTML
entities, so you should even be able to do HTML-within-HTML
fontified display.

You should, however, note that random control or eight-bit
characters such as ^L () or ¤ (\244) won't get mapped yet.

If the SRCDIR and FILE arguments are set, lookup etags derived
entries in the `hfy-tags-cache' and add HTML anchors and
hyperlinks as appropriate.

\(fn &optional SRCDIR FILE)" t nil)

(autoload 'htmlfontify-copy-and-link-dir "htmlfontify" "\
Trawl SRCDIR and write fontified-and-hyperlinked output in DSTDIR.
F-EXT and L-EXT specify values for `hfy-extn' and `hfy-link-extn'.

You may also want to set `hfy-page-header' and `hfy-page-footer'.

\(fn SRCDIR DSTDIR &optional F-EXT L-EXT)" t nil)

;;;***

;;;### (autoloads nil "ibuf-macs" "ibuf-macs.el" (21788 61018 0 0))
;;; Generated autoloads from ibuf-macs.el

(autoload 'define-ibuffer-column "ibuf-macs" "\
Define a column SYMBOL for use with `ibuffer-formats'.

BODY will be called with `buffer' bound to the buffer object, and
`mark' bound to the current mark on the buffer.  The original ibuffer
buffer will be bound to `ibuffer-buf'.

If NAME is given, it will be used as a title for the column.
Otherwise, the title will default to a capitalized version of the
SYMBOL's name.  PROPS is a plist of additional properties to add to
the text, such as `mouse-face'.  And SUMMARIZER, if given, is a
function which will be passed a list of all the strings in its column;
it should return a string to display at the bottom.

If HEADER-MOUSE-MAP is given, it will be used as a keymap for the
title of the column.

Note that this macro expands into a `defun' for a function named
ibuffer-make-column-NAME.  If INLINE is non-nil, then the form will be
inlined into the compiled format versions.  This means that if you
change its definition, you should explicitly call
`ibuffer-recompile-formats'.

\(fn SYMBOL (&key NAME INLINE PROPS SUMMARIZER) &rest BODY)" nil (quote macro))

(autoload 'define-ibuffer-sorter "ibuf-macs" "\
Define a method of sorting named NAME.
DOCUMENTATION is the documentation of the function, which will be called
`ibuffer-do-sort-by-NAME'.
DESCRIPTION is a short string describing the sorting method.

For sorting, the forms in BODY will be evaluated with `a' bound to one
buffer object, and `b' bound to another.  BODY should return a non-nil
value if and only if `a' is \"less than\" `b'.

\(fn NAME DOCUMENTATION (&key DESCRIPTION) &rest BODY)" nil (quote macro))

(autoload 'define-ibuffer-op "ibuf-macs" "\
Generate a function which operates on a buffer.
OP becomes the name of the function; if it doesn't begin with
`ibuffer-do-', then that is prepended to it.
When an operation is performed, this function will be called once for
each marked buffer, with that buffer current.

ARGS becomes the formal parameters of the function.
DOCUMENTATION becomes the docstring of the function.
INTERACTIVE becomes the interactive specification of the function.
MARK describes which type of mark (:deletion, or nil) this operation
uses.  :deletion means the function operates on buffers marked for
deletion, otherwise it acts on normally marked buffers.
MODIFIER-P describes how the function modifies buffers.  This is used
to set the modification flag of the Ibuffer buffer itself.  Valid
values are:
 nil - the function never modifiers buffers
 t - the function it always modifies buffers
 :maybe - attempt to discover this information by comparing the
  buffer's modification flag.
DANGEROUS is a boolean which should be set if the user should be
prompted before performing this operation.
OPSTRING is a string which will be displayed to the user after the
operation is complete, in the form:
 \"Operation complete; OPSTRING x buffers\"
ACTIVE-OPSTRING is a string which will be displayed to the user in a
confirmation message, in the form:
 \"Really ACTIVE-OPSTRING x buffers?\"
COMPLEX means this function is special; see the source code of this
macro for exactly what it does.

\(fn OP ARGS DOCUMENTATION (&key INTERACTIVE MARK MODIFIER-P DANGEROUS OPSTRING ACTIVE-OPSTRING COMPLEX) &rest BODY)" nil (quote macro))

(autoload 'define-ibuffer-filter "ibuf-macs" "\
Define a filter named NAME.
DOCUMENTATION is the documentation of the function.
READER is a form which should read a qualifier from the user.
DESCRIPTION is a short string describing the filter.

BODY should contain forms which will be evaluated to test whether or
not a particular buffer should be displayed or not.  The forms in BODY
will be evaluated with BUF bound to the buffer object, and QUALIFIER
bound to the current value of the filter.

\(fn NAME DOCUMENTATION (&key READER DESCRIPTION) &rest BODY)" nil (quote macro))

;;;***

;;;### (autoloads nil "ibuffer" "ibuffer.el" (21788 61018 0 0))
;;; Generated autoloads from ibuffer.el

(autoload 'ibuffer-list-buffers "ibuffer" "\
Display a list of buffers, in another window.
If optional argument FILES-ONLY is non-nil, then add a filter for
buffers which are visiting a file.

\(fn &optional FILES-ONLY)" t nil)

(autoload 'ibuffer-other-window "ibuffer" "\
Like `ibuffer', but displayed in another window by default.
If optional argument FILES-ONLY is non-nil, then add a filter for
buffers which are visiting a file.

\(fn &optional FILES-ONLY)" t nil)

(autoload 'ibuffer "ibuffer" "\
Begin using Ibuffer to edit a list of buffers.
Type 'h' after entering ibuffer for more information.

All arguments are optional.
OTHER-WINDOW-P says to use another window.
NAME specifies the name of the buffer (defaults to \"*Ibuffer*\").
QUALIFIERS is an initial set of filtering qualifiers to use;
  see `ibuffer-filtering-qualifiers'.
NOSELECT means don't select the Ibuffer buffer.
SHRINK means shrink the buffer to minimal size.  The special
  value `onewindow' means always use another window.
FILTER-GROUPS is an initial set of filtering groups to use;
  see `ibuffer-filter-groups'.
FORMATS is the value to use for `ibuffer-formats'.
  If specified, then the variable `ibuffer-formats' will have
  that value locally in this buffer.

\(fn &optional OTHER-WINDOW-P NAME QUALIFIERS NOSELECT SHRINK FILTER-GROUPS FORMATS)" t nil)

;;;***

;;;### (autoloads nil "icalendar" "calendar/icalendar.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from calendar/icalendar.el
(push (purecopy '(icalendar 0 19)) package--builtin-versions)

(autoload 'icalendar-export-file "icalendar" "\
Export diary file to iCalendar format.
All diary entries in the file DIARY-FILENAME are converted to iCalendar
format.  The result is appended to the file ICAL-FILENAME.

\(fn DIARY-FILENAME ICAL-FILENAME)" t nil)

(autoload 'icalendar-export-region "icalendar" "\
Export region in diary file to iCalendar format.
All diary entries in the region from MIN to MAX in the current buffer are
converted to iCalendar format.  The result is appended to the file
ICAL-FILENAME.
This function attempts to return t if something goes wrong.  In this
case an error string which describes all the errors and problems is
written into the buffer `*icalendar-errors*'.

\(fn MIN MAX ICAL-FILENAME)" t nil)

(autoload 'icalendar-import-file "icalendar" "\
Import an iCalendar file and append to a diary file.
Argument ICAL-FILENAME output iCalendar file.
Argument DIARY-FILENAME input `diary-file'.
Optional argument NON-MARKING determines whether events are created as
non-marking or not.

\(fn ICAL-FILENAME DIARY-FILENAME &optional NON-MARKING)" t nil)

(autoload 'icalendar-import-buffer "icalendar" "\
Extract iCalendar events from current buffer.

This function searches the current buffer for the first iCalendar
object, reads it and adds all VEVENT elements to the diary
DIARY-FILE.

It will ask for each appointment whether to add it to the diary
unless DO-NOT-ASK is non-nil.  When called interactively,
DO-NOT-ASK is nil, so that you are asked for each event.

NON-MARKING determines whether diary events are created as
non-marking.

Return code t means that importing worked well, return code nil
means that an error has occurred.  Error messages will be in the
buffer `*icalendar-errors*'.

\(fn &optional DIARY-FILE DO-NOT-ASK NON-MARKING)" t nil)

;;;***

;;;### (autoloads nil "icomplete" "icomplete.el" (21788 61018 0 0))
;;; Generated autoloads from icomplete.el

(defvar icomplete-mode nil "\
Non-nil if Icomplete mode is enabled.
See the command `icomplete-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `icomplete-mode'.")

(custom-autoload 'icomplete-mode "icomplete" nil)

(autoload 'icomplete-mode "icomplete" "\
Toggle incremental minibuffer completion (Icomplete mode).
With a prefix argument ARG, enable Icomplete mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

When this global minor mode is enabled, typing in the minibuffer
continuously displays a list of possible completions that match
the string you have typed.  See `icomplete-completions' for a
description of how prospective completions are displayed.

For more information, see Info node `(emacs)Icomplete'.
For options you can set, `\\[customize-group] icomplete'.

You can use the following key bindings to navigate and select
completions:

\\{icomplete-minibuffer-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "icon" "progmodes/icon.el" (21710 25077 0 0))
;;; Generated autoloads from progmodes/icon.el

(autoload 'icon-mode "icon" "\
Major mode for editing Icon code.
Expression and list commands understand all Icon brackets.
Tab indents for Icon code.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.
\\{icon-mode-map}
Variables controlling indentation style:
 icon-tab-always-indent
    Non-nil means TAB in Icon mode should always reindent the current line,
    regardless of where in the line point is when the TAB command is used.
 icon-auto-newline
    Non-nil means automatically newline before and after braces
    inserted in Icon code.
 icon-indent-level
    Indentation of Icon statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 icon-continued-statement-offset
    Extra indentation given to a substatement, such as the
    then-clause of an if or body of a while.
 icon-continued-brace-offset
    Extra indentation given to a brace that starts a substatement.
    This is in addition to `icon-continued-statement-offset'.
 icon-brace-offset
    Extra indentation for line if it starts with an open brace.
 icon-brace-imaginary-offset
    An open brace following other text is treated as if it were
    this far to the right of the start of its line.

Turning on Icon mode calls the value of the variable `icon-mode-hook'
with no args, if that value is non-nil.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "idlw-shell" "progmodes/idlw-shell.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from progmodes/idlw-shell.el

(autoload 'idlwave-shell "idlw-shell" "\
Run an inferior IDL, with I/O through buffer `(idlwave-shell-buffer)'.
If buffer exists but shell process is not running, start new IDL.
If buffer exists and shell process is running, just switch to the buffer.

When called with a prefix ARG, or when `idlwave-shell-use-dedicated-frame'
is non-nil, the shell buffer and the source buffers will be in
separate frames.

The command to run comes from variable `idlwave-shell-explicit-file-name',
with options taken from `idlwave-shell-command-line-options'.

The buffer is put in `idlwave-shell-mode', providing commands for sending
input and controlling the IDL job.  See help on `idlwave-shell-mode'.
See also the variable `idlwave-shell-prompt-pattern'.

\(Type \\[describe-mode] in the shell buffer for a list of commands.)

\(fn &optional ARG QUICK)" t nil)

;;;***

;;;### (autoloads nil "idlwave" "progmodes/idlwave.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/idlwave.el
(push (purecopy '(idlwave 6 1 22)) package--builtin-versions)

(autoload 'idlwave-mode "idlwave" "\
Major mode for editing IDL source files (version 6.1_em22).

The main features of this mode are

1. Indentation and Formatting
   --------------------------
   Like other Emacs programming modes, C-j inserts a newline and indents.
   TAB is used for explicit indentation of the current line.

   To start a continuation line, use \\[idlwave-split-line].  This
   function can also be used in the middle of a line to split the line
   at that point.  When used inside a long constant string, the string
   is split at that point with the `+' concatenation operator.

   Comments are indented as follows:

   `;;;' Indentation remains unchanged.
   `;;'  Indent like the surrounding code
   `;'   Indent to a minimum column.

   The indentation of comments starting in column 0 is never changed.

   Use \\[idlwave-fill-paragraph] to refill a paragraph inside a
   comment.  The indentation of the second line of the paragraph
   relative to the first will be retained.  Use
   \\[idlwave-auto-fill-mode] to toggle auto-fill mode for these
   comments.  When the variable `idlwave-fill-comment-line-only' is
   nil, code can also be auto-filled and auto-indented.

   To convert pre-existing IDL code to your formatting style, mark the
   entire buffer with \\[mark-whole-buffer] and execute
   \\[idlwave-expand-region-abbrevs].  Then mark the entire buffer
   again followed by \\[indent-region] (`indent-region').

2. Routine Info
   ------------
   IDLWAVE displays information about the calling sequence and the
   accepted keyword parameters of a procedure or function with
   \\[idlwave-routine-info].  \\[idlwave-find-module] jumps to the
   source file of a module.  These commands know about system
   routines, all routines in idlwave-mode buffers and (when the
   idlwave-shell is active) about all modules currently compiled under
   this shell.  It also makes use of pre-compiled or custom-scanned
   user and library catalogs many popular libraries ship with by
   default.  Use \\[idlwave-update-routine-info] to update this
   information, which is also used for completion (see item 4).

3. Online IDL Help
   ---------------

   \\[idlwave-context-help] displays the IDL documentation relevant
   for the system variable, keyword, or routines at point.  A single
   key stroke gets you directly to the right place in the docs.  See
   the manual to configure where and how the HTML help is displayed.

4. Completion
   ----------
   \\[idlwave-complete] completes the names of procedures, functions
   class names, keyword parameters, system variables and tags, class
   tags, structure tags, filenames and much more.  It is context
   sensitive and figures out what is expected at point.  Lower case
   strings are completed in lower case, other strings in mixed or
   upper case.

5. Code Templates and Abbreviations
   --------------------------------
   Many Abbreviations are predefined to expand to code fragments and templates.
   The abbreviations start generally with a `\\`.  Some examples:

   \\pr        PROCEDURE template
   \\fu        FUNCTION template
   \\c         CASE statement template
   \\sw        SWITCH statement template
   \\f         FOR loop template
   \\r         REPEAT Loop template
   \\w         WHILE loop template
   \\i         IF statement template
   \\elif      IF-ELSE statement template
   \\b         BEGIN

   For a full list, use \\[idlwave-list-abbrevs].  Some templates also
   have direct keybindings - see the list of keybindings below.

   \\[idlwave-doc-header] inserts a documentation header at the
   beginning of the current program unit (pro, function or main).
   Change log entries can be added to the current program unit with
   \\[idlwave-doc-modification].

6. Automatic Case Conversion
   -------------------------
   The case of reserved words and some abbrevs is controlled by
   `idlwave-reserved-word-upcase' and `idlwave-abbrev-change-case'.

7. Automatic END completion
   ------------------------
   If the variable `idlwave-expand-generic-end' is non-nil, each END typed
   will be converted to the specific version, like ENDIF, ENDFOR, etc.

8. Hooks
   -----
   Loading idlwave.el runs `idlwave-load-hook'.
   Turning on `idlwave-mode' runs `idlwave-mode-hook'.

9. Documentation and Customization
   -------------------------------
   Info documentation for this package is available.  Use
   \\[idlwave-info] to display (complain to your sysadmin if that does
   not work).  For Postscript, PDF, and HTML versions of the
   documentation, check IDLWAVE's homepage at URL
   `http://github.com/jdtsmith/idlwave'.
   IDLWAVE has customize support - see the group `idlwave'.

10.Keybindings
   -----------
   Here is a list of all keybindings of this mode.
   If some of the key bindings below show with ??, use \\[describe-key]
   followed by the key sequence to see what the key sequence does.

\\{idlwave-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ido" "ido.el" (21788 61018 0 0))
;;; Generated autoloads from ido.el

(defvar ido-mode nil "\
Determines for which buffer/file Ido should be enabled.
The following values are possible:
- `buffer': Turn only on Ido buffer behavior (switching, killing,
  displaying...)
- `file': Turn only on Ido file behavior (finding, writing, inserting...)
- `both': Turn on Ido buffer and file behavior.
-  nil: Turn off any Ido switching.

Setting this variable directly does not take effect;
use either \\[customize] or the function `ido-mode'.")

(custom-autoload 'ido-mode "ido" nil)

(autoload 'ido-mode "ido" "\
Toggle Ido mode on or off.
With ARG, turn Ido mode on if arg is positive, off otherwise.
Turning on Ido mode will remap (via a minor-mode keymap) the default
keybindings for the `find-file' and `switch-to-buffer' families of
commands to the Ido versions of these functions.
However, if ARG arg equals 'files, remap only commands for files, or
if it equals 'buffers, remap only commands for buffer switching.
This function also adds a hook to the minibuffer.

\(fn &optional ARG)" t nil)

(autoload 'ido-switch-buffer "ido" "\
Switch to another buffer.
The buffer is displayed according to `ido-default-buffer-method' -- the
default is to show it in the same window, unless it is already visible
in another frame.

As you type in a string, all of the buffers matching the string are
displayed if substring-matching is used (default).  Look at
`ido-enable-prefix' and `ido-toggle-prefix'.  When you have found the
buffer you want, it can then be selected.  As you type, most keys have
their normal keybindings, except for the following: \\<ido-buffer-completion-map>

RET	Select the buffer at the front of the list of matches.
	If the list is empty, possibly prompt to create new buffer.

\\[ido-select-text]	Use the current input string verbatim.

\\[ido-next-match]	Put the first element at the end of the list.
\\[ido-prev-match]	Put the last element at the start of the list.
\\[ido-complete]	Complete a common suffix to the current string that matches
	all buffers.  If there is only one match, select that buffer.
	If there is no common suffix, show a list of all matching buffers
	in a separate window.
\\[ido-edit-input]	Edit input string.
\\[ido-fallback-command]	Fallback to non-ido version of current command.
\\[ido-toggle-regexp]	Toggle regexp searching.
\\[ido-toggle-prefix]	Toggle between substring and prefix matching.
\\[ido-toggle-case]	Toggle case-sensitive searching of buffer names.
\\[ido-completion-help]	Show list of matching buffers in separate window.
\\[ido-enter-find-file]	Drop into `ido-find-file'.
\\[ido-kill-buffer-at-head]	Kill buffer at head of buffer list.
\\[ido-toggle-ignore]	Toggle ignoring buffers listed in `ido-ignore-buffers'.

\(fn)" t nil)

(autoload 'ido-switch-buffer-other-window "ido" "\
Switch to another buffer and show it in another window.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'.

\(fn)" t nil)

(autoload 'ido-display-buffer "ido" "\
Display a buffer in another window but don't select it.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'.

\(fn)" t nil)

(autoload 'ido-kill-buffer "ido" "\
Kill a buffer.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'.

\(fn)" t nil)

(autoload 'ido-insert-buffer "ido" "\
Insert contents of a buffer in current buffer after point.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'.

\(fn)" t nil)

(autoload 'ido-switch-buffer-other-frame "ido" "\
Switch to another buffer and show it in another frame.
The buffer name is selected interactively by typing a substring.
For details of keybindings, see `ido-switch-buffer'.

\(fn)" t nil)

(autoload 'ido-find-file-in-dir "ido" "\
Switch to another file starting from DIR.

\(fn DIR)" t nil)

(autoload 'ido-find-file "ido" "\
Edit file with name obtained via minibuffer.
The file is displayed according to `ido-default-file-method' -- the
default is to show it in the same window, unless it is already visible
in another frame.

The file name is selected interactively by typing a substring.  As you
type in a string, all of the filenames matching the string are displayed
if substring-matching is used (default).  Look at `ido-enable-prefix' and
`ido-toggle-prefix'.  When you have found the filename you want, it can
then be selected.  As you type, most keys have their normal keybindings,
except for the following: \\<ido-file-completion-map>

RET	Select the file at the front of the list of matches.
	If the list is empty, possibly prompt to create new file.

\\[ido-select-text]	Use the current input string verbatim.

\\[ido-next-match]	Put the first element at the end of the list.
\\[ido-prev-match]	Put the last element at the start of the list.
\\[ido-complete]	Complete a common suffix to the current string that matches
	all files.  If there is only one match, select that file.
	If there is no common suffix, show a list of all matching files
	in a separate window.
\\[ido-magic-delete-char]	Open the specified directory in Dired mode.
\\[ido-edit-input]	Edit input string (including directory).
\\[ido-prev-work-directory]	Go to previous directory in work directory history.
\\[ido-next-work-directory]	Go to next directory in work directory history.
\\[ido-merge-work-directories]	Search for file in the work directory history.
\\[ido-forget-work-directory]	Remove current directory from the work directory history.
\\[ido-prev-work-file]	Cycle to previous file in work file history.
\\[ido-next-work-file]	Cycle to next file in work file history.
\\[ido-wide-find-file-or-pop-dir]	Prompt for a file and use find to locate it.
\\[ido-wide-find-dir-or-delete-dir]	Prompt for a directory and use find to locate it.
\\[ido-make-directory]	Prompt for a directory to create in current directory.
\\[ido-fallback-command]	Fallback to non-Ido version of current command.
\\[ido-toggle-regexp]	Toggle regexp searching.
\\[ido-toggle-prefix]	Toggle between substring and prefix matching.
\\[ido-toggle-case]	Toggle case-sensitive searching of file names.
\\[ido-toggle-literal]	Toggle literal reading of this file.
\\[ido-completion-help]	Show list of matching files in separate window.
\\[ido-toggle-ignore]	Toggle ignoring files listed in `ido-ignore-files'.

\(fn)" t nil)

(autoload 'ido-find-file-other-window "ido" "\
Switch to another file and show it in another window.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-find-alternate-file "ido" "\
Switch to another file and show it in another window.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-find-file-read-only "ido" "\
Edit file read-only with name obtained via minibuffer.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-find-file-read-only-other-window "ido" "\
Edit file read-only in other window with name obtained via minibuffer.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-find-file-read-only-other-frame "ido" "\
Edit file read-only in other frame with name obtained via minibuffer.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-display-file "ido" "\
Display a file in another window but don't select it.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-find-file-other-frame "ido" "\
Switch to another file and show it in another frame.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-write-file "ido" "\
Write current buffer to a file.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-insert-file "ido" "\
Insert contents of file in current buffer.
The file name is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-dired "ido" "\
Call `dired' the Ido way.
The directory is selected interactively by typing a substring.
For details of keybindings, see `ido-find-file'.

\(fn)" t nil)

(autoload 'ido-read-buffer "ido" "\
Ido replacement for the built-in `read-buffer'.
Return the name of a buffer selected.
PROMPT is the prompt to give to the user.  DEFAULT if given is the default
buffer to be selected, which will go to the front of the list.
If REQUIRE-MATCH is non-nil, an existing buffer must be selected.

\(fn PROMPT &optional DEFAULT REQUIRE-MATCH)" nil nil)

(autoload 'ido-read-file-name "ido" "\
Ido replacement for the built-in `read-file-name'.
Read file name, prompting with PROMPT and completing in directory DIR.
See `read-file-name' for additional parameters.

\(fn PROMPT &optional DIR DEFAULT-FILENAME MUSTMATCH INITIAL PREDICATE)" nil nil)

(autoload 'ido-read-directory-name "ido" "\
Ido replacement for the built-in `read-directory-name'.
Read directory name, prompting with PROMPT and completing in directory DIR.
See `read-directory-name' for additional parameters.

\(fn PROMPT &optional DIR DEFAULT-DIRNAME MUSTMATCH INITIAL)" nil nil)

(autoload 'ido-completing-read "ido" "\
Ido replacement for the built-in `completing-read'.
Read a string in the minibuffer with Ido-style completion.
PROMPT is a string to prompt with; normally it ends in a colon and a space.
CHOICES is a list of strings which are the possible completions.
PREDICATE and INHERIT-INPUT-METHOD are currently ignored; they are included
 to be compatible with `completing-read'.
If REQUIRE-MATCH is non-nil, the user is not allowed to exit unless
 the input is (or completes to) an element of CHOICES or is null.
 If the input is null, `ido-completing-read' returns DEF, or an empty
 string if DEF is nil, regardless of the value of REQUIRE-MATCH.
If INITIAL-INPUT is non-nil, insert it in the minibuffer initially,
 with point positioned at the end.
HIST, if non-nil, specifies a history list.
DEF, if non-nil, is the default value.

\(fn PROMPT CHOICES &optional PREDICATE REQUIRE-MATCH INITIAL-INPUT HIST DEF INHERIT-INPUT-METHOD)" nil nil)

;;;***

;;;### (autoloads nil "ielm" "ielm.el" (21788 61018 0 0))
;;; Generated autoloads from ielm.el

(autoload 'ielm "ielm" "\
Interactively evaluate Emacs Lisp expressions.
Switches to the buffer `*ielm*', or creates it if it does not exist.
See `inferior-emacs-lisp-mode' for details.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "iimage" "iimage.el" (21710 25077 0 0))
;;; Generated autoloads from iimage.el

(define-obsolete-function-alias 'turn-on-iimage-mode 'iimage-mode "24.1")

(autoload 'iimage-mode "iimage" "\
Toggle Iimage mode on or off.
With a prefix argument ARG, enable Iimage mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil, and toggle it if ARG is `toggle'.
\\{iimage-mode-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "image" "image.el" (21710 25077 0 0))
;;; Generated autoloads from image.el

(autoload 'image-type-from-data "image" "\
Determine the image type from image data DATA.
Value is a symbol specifying the image type or nil if type cannot
be determined.

\(fn DATA)" nil nil)

(autoload 'image-type-from-buffer "image" "\
Determine the image type from data in the current buffer.
Value is a symbol specifying the image type or nil if type cannot
be determined.

\(fn)" nil nil)

(autoload 'image-type-from-file-header "image" "\
Determine the type of image file FILE from its first few bytes.
Value is a symbol specifying the image type, or nil if type cannot
be determined.

\(fn FILE)" nil nil)

(autoload 'image-type-from-file-name "image" "\
Determine the type of image file FILE from its name.
Value is a symbol specifying the image type, or nil if type cannot
be determined.

\(fn FILE)" nil nil)

(autoload 'image-type "image" "\
Determine and return image type.
SOURCE is an image file name or image data.
Optional TYPE is a symbol describing the image type.  If TYPE is omitted
or nil, try to determine the image type from its first few bytes
of image data.  If that doesn't work, and SOURCE is a file name,
use its file extension as image type.
Optional DATA-P non-nil means SOURCE is a string containing image data.

\(fn SOURCE &optional TYPE DATA-P)" nil nil)

(autoload 'image-type-available-p "image" "\
Return non-nil if image type TYPE is available.
Image types are symbols like `xbm' or `jpeg'.

\(fn TYPE)" nil nil)

(autoload 'image-type-auto-detected-p "image" "\
Return t if the current buffer contains an auto-detectable image.
This function is intended to be used from `magic-fallback-mode-alist'.

The buffer is considered to contain an auto-detectable image if
its beginning matches an image type in `image-type-header-regexps',
and that image type is present in `image-type-auto-detectable' with a
non-nil value.  If that value is non-nil, but not t, then the image type
must be available.

\(fn)" nil nil)

(autoload 'create-image "image" "\
Create an image.
FILE-OR-DATA is an image file name or image data.
Optional TYPE is a symbol describing the image type.  If TYPE is omitted
or nil, try to determine the image type from its first few bytes
of image data.  If that doesn't work, and FILE-OR-DATA is a file name,
use its file extension as image type.
Optional DATA-P non-nil means FILE-OR-DATA is a string containing image data.
Optional PROPS are additional image attributes to assign to the image,
like, e.g. `:mask MASK'.
Value is the image created, or nil if images of type TYPE are not supported.

Images should not be larger than specified by `max-image-size'.

Image file names that are not absolute are searched for in the
\"images\" sub-directory of `data-directory' and
`x-bitmap-file-path' (in that order).

\(fn FILE-OR-DATA &optional TYPE DATA-P &rest PROPS)" nil nil)

(autoload 'put-image "image" "\
Put image IMAGE in front of POS in the current buffer.
IMAGE must be an image created with `create-image' or `defimage'.
IMAGE is displayed by putting an overlay into the current buffer with a
`before-string' STRING that has a `display' property whose value is the
image.  STRING is defaulted if you omit it.
The overlay created will have the `put-image' property set to t.
POS may be an integer or marker.
AREA is where to display the image.  AREA nil or omitted means
display it in the text area, a value of `left-margin' means
display it in the left marginal area, a value of `right-margin'
means display it in the right marginal area.

\(fn IMAGE POS &optional STRING AREA)" nil nil)

(autoload 'insert-image "image" "\
Insert IMAGE into current buffer at point.
IMAGE is displayed by inserting STRING into the current buffer
with a `display' property whose value is the image.  STRING
defaults to a single space if you omit it.
AREA is where to display the image.  AREA nil or omitted means
display it in the text area, a value of `left-margin' means
display it in the left marginal area, a value of `right-margin'
means display it in the right marginal area.
SLICE specifies slice of IMAGE to insert.  SLICE nil or omitted
means insert whole image.  SLICE is a list (X Y WIDTH HEIGHT)
specifying the X and Y positions and WIDTH and HEIGHT of image area
to insert.  A float value 0.0 - 1.0 means relative to the width or
height of the image; integer values are taken as pixel values.

\(fn IMAGE &optional STRING AREA SLICE)" nil nil)

(autoload 'insert-sliced-image "image" "\
Insert IMAGE into current buffer at point.
IMAGE is displayed by inserting STRING into the current buffer
with a `display' property whose value is the image.  The default
STRING is a single space.
AREA is where to display the image.  AREA nil or omitted means
display it in the text area, a value of `left-margin' means
display it in the left marginal area, a value of `right-margin'
means display it in the right marginal area.
The image is automatically split into ROWS x COLS slices.

\(fn IMAGE &optional STRING AREA ROWS COLS)" nil nil)

(autoload 'remove-images "image" "\
Remove images between START and END in BUFFER.
Remove only images that were put in BUFFER with calls to `put-image'.
BUFFER nil or omitted means use the current buffer.

\(fn START END &optional BUFFER)" nil nil)

(autoload 'find-image "image" "\
Find an image, choosing one of a list of image specifications.

SPECS is a list of image specifications.

Each image specification in SPECS is a property list.  The contents of
a specification are image type dependent.  All specifications must at
least contain the properties `:type TYPE' and either `:file FILE' or
`:data DATA', where TYPE is a symbol specifying the image type,
e.g. `xbm', FILE is the file to load the image from, and DATA is a
string containing the actual image data.  The specification whose TYPE
is supported, and FILE exists, is used to construct the image
specification to be returned.  Return nil if no specification is
satisfied.

The image is looked for in `image-load-path'.

Image files should not be larger than specified by `max-image-size'.

\(fn SPECS)" nil nil)

(autoload 'defimage "image" "\
Define SYMBOL as an image, and return SYMBOL.

SPECS is a list of image specifications.  DOC is an optional
documentation string.

Each image specification in SPECS is a property list.  The contents of
a specification are image type dependent.  All specifications must at
least contain the properties `:type TYPE' and either `:file FILE' or
`:data DATA', where TYPE is a symbol specifying the image type,
e.g. `xbm', FILE is the file to load the image from, and DATA is a
string containing the actual image data.  The first image
specification whose TYPE is supported, and FILE exists, is used to
define SYMBOL.

Example:

   (defimage test-image ((:type xpm :file \"~/test1.xpm\")
                         (:type xbm :file \"~/test1.xbm\")))

\(fn SYMBOL SPECS &optional DOC)" nil t)

(put 'defimage 'doc-string-elt '3)

(autoload 'imagemagick-register-types "image" "\
Register file types that can be handled by ImageMagick.
This function is called at startup, after loading the init file.
It registers the ImageMagick types returned by `imagemagick-filter-types'.

Registered image types are added to `auto-mode-alist', so that
Emacs visits them in Image mode.  They are also added to
`image-type-file-name-regexps', so that the `image-type' function
recognizes these files as having image type `imagemagick'.

If Emacs is compiled without ImageMagick support, this does nothing.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "image-dired" "image-dired.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from image-dired.el
(push (purecopy '(image-dired 0 4 11)) package--builtin-versions)

(autoload 'image-dired-dired-toggle-marked-thumbs "image-dired" "\
Toggle thumbnails in front of file names in the dired buffer.
If no marked file could be found, insert or hide thumbnails on the
current line.  ARG, if non-nil, specifies the files to use instead
of the marked files.  If ARG is an integer, use the next ARG (or
previous -ARG, if ARG<0) files.

\(fn &optional ARG)" t nil)

(autoload 'image-dired-dired-with-window-configuration "image-dired" "\
Open directory DIR and create a default window configuration.

Convenience command that:

 - Opens dired in folder DIR
 - Splits windows in most useful (?) way
 - Set `truncate-lines' to t

After the command has finished, you would typically mark some
image files in dired and type
\\[image-dired-display-thumbs] (`image-dired-display-thumbs').

If called with prefix argument ARG, skip splitting of windows.

The current window configuration is saved and can be restored by
calling `image-dired-restore-window-configuration'.

\(fn DIR &optional ARG)" t nil)

(autoload 'image-dired-display-thumbs "image-dired" "\
Display thumbnails of all marked files, in `image-dired-thumbnail-buffer'.
If a thumbnail image does not exist for a file, it is created on the
fly.  With prefix argument ARG, display only thumbnail for file at
point (this is useful if you have marked some files but want to show
another one).

Recommended usage is to split the current frame horizontally so that
you have the dired buffer in the left window and the
`image-dired-thumbnail-buffer' buffer in the right window.

With optional argument APPEND, append thumbnail to thumbnail buffer
instead of erasing it first.

Optional argument DO-NOT-POP controls if `pop-to-buffer' should be
used or not.  If non-nil, use `display-buffer' instead of
`pop-to-buffer'.  This is used from functions like
`image-dired-next-line-and-display' and
`image-dired-previous-line-and-display' where we do not want the
thumbnail buffer to be selected.

\(fn &optional ARG APPEND DO-NOT-POP)" t nil)

(autoload 'image-dired-show-all-from-dir "image-dired" "\
Make a preview buffer for all images in DIR and display it.
If the number of files in DIR matching `image-file-name-regexp'
exceeds `image-dired-show-all-from-dir-max-files', a warning will be
displayed.

\(fn DIR)" t nil)

(defalias 'image-dired 'image-dired-show-all-from-dir)

(define-obsolete-function-alias 'tumme 'image-dired "24.4")

(autoload 'image-dired-tag-files "image-dired" "\
Tag marked file(s) in dired.  With prefix ARG, tag file at point.

\(fn ARG)" t nil)

(autoload 'image-dired-delete-tag "image-dired" "\
Remove tag for selected file(s).
With prefix argument ARG, remove tag from file at point.

\(fn ARG)" t nil)

(autoload 'image-dired-jump-thumbnail-buffer "image-dired" "\
Jump to thumbnail buffer.

\(fn)" t nil)

(autoload 'image-dired-setup-dired-keybindings "image-dired" "\
Setup easy-to-use keybindings for the commands to be used in dired mode.
Note that n, p and <down> and <up> will be hijacked and bound to
`image-dired-dired-x-line'.

\(fn)" t nil)

(autoload 'image-dired-display-thumbs-append "image-dired" "\
Append thumbnails to `image-dired-thumbnail-buffer'.

\(fn)" t nil)

(autoload 'image-dired-display-thumb "image-dired" "\
Shorthand for `image-dired-display-thumbs' with prefix argument.

\(fn)" t nil)

(autoload 'image-dired-dired-display-external "image-dired" "\
Display file at point using an external viewer.

\(fn)" t nil)

(autoload 'image-dired-dired-display-image "image-dired" "\
Display current image file.
See documentation for `image-dired-display-image' for more information.
With prefix argument ARG, display image in its original size.

\(fn &optional ARG)" t nil)

(autoload 'image-dired-dired-comment-files "image-dired" "\
Add comment to current or marked files in dired.

\(fn)" t nil)

(autoload 'image-dired-mark-tagged-files "image-dired" "\
Use regexp to mark files with matching tag.
A `tag' is a keyword, a piece of meta data, associated with an
image file and stored in image-dired's database file.  This command
lets you input a regexp and this will be matched against all tags
on all image files in the database file.  The files that have a
matching tag will be marked in the dired buffer.

\(fn)" t nil)

(autoload 'image-dired-dired-edit-comment-and-tags "image-dired" "\
Edit comment and tags of current or marked image files.
Edit comment and tags for all marked image files in an
easy-to-use form.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "image-file" "image-file.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from image-file.el

(defvar image-file-name-extensions (purecopy '("png" "jpeg" "jpg" "gif" "tiff" "tif" "xbm" "xpm" "pbm" "pgm" "ppm" "pnm" "svg")) "\
A list of image-file filename extensions.
Filenames having one of these extensions are considered image files,
in addition to those matching `image-file-name-regexps'.

See `auto-image-file-mode'; if `auto-image-file-mode' is enabled,
setting this variable directly does not take effect unless
`auto-image-file-mode' is re-enabled; this happens automatically when
the variable is set using \\[customize].")

(custom-autoload 'image-file-name-extensions "image-file" nil)

(defvar image-file-name-regexps nil "\
List of regexps matching image-file filenames.
Filenames matching one of these regexps are considered image files,
in addition to those with an extension in `image-file-name-extensions'.

See function `auto-image-file-mode'; if `auto-image-file-mode' is
enabled, setting this variable directly does not take effect unless
`auto-image-file-mode' is re-enabled; this happens automatically when
the variable is set using \\[customize].")

(custom-autoload 'image-file-name-regexps "image-file" nil)

(autoload 'image-file-name-regexp "image-file" "\
Return a regular expression matching image-file filenames.

\(fn)" nil nil)

(autoload 'insert-image-file "image-file" "\
Insert the image file FILE into the current buffer.
Optional arguments VISIT, BEG, END, and REPLACE are interpreted as for
the command `insert-file-contents'.

\(fn FILE &optional VISIT BEG END REPLACE)" nil nil)

(defvar auto-image-file-mode nil "\
Non-nil if Auto-Image-File mode is enabled.
See the command `auto-image-file-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `auto-image-file-mode'.")

(custom-autoload 'auto-image-file-mode "image-file" nil)

(autoload 'auto-image-file-mode "image-file" "\
Toggle visiting of image files as images (Auto Image File mode).
With a prefix argument ARG, enable Auto Image File mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

An image file is one whose name has an extension in
`image-file-name-extensions', or matches a regexp in
`image-file-name-regexps'.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "image-mode" "image-mode.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from image-mode.el

(autoload 'image-mode "image-mode" "\
Major mode for image files.
You can use \\<image-mode-map>\\[image-toggle-display]
to toggle between display as an image and display as text.

Key bindings:
\\{image-mode-map}

\(fn)" t nil)

(autoload 'image-minor-mode "image-mode" "\
Toggle Image minor mode in this buffer.
With a prefix argument ARG, enable Image minor mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Image minor mode provides the key \\<image-mode-map>\\[image-toggle-display],
to switch back to `image-mode' and display an image file as the
actual image.

\(fn &optional ARG)" t nil)

(autoload 'image-mode-as-text "image-mode" "\
Set a non-image mode as major mode in combination with image minor mode.
A non-image major mode found from `auto-mode-alist' or Fundamental mode
displays an image file as text.  `image-minor-mode' provides the key
\\<image-mode-map>\\[image-toggle-display] to switch back to `image-mode'
to display an image file as the actual image.

You can use `image-mode-as-text' in `auto-mode-alist' when you want
to display an image file as text initially.

See commands `image-mode' and `image-minor-mode' for more information
on these modes.

\(fn)" t nil)

(autoload 'image-bookmark-jump "image-mode" "\


\(fn BMK)" nil nil)

;;;***

;;;### (autoloads nil "imenu" "imenu.el" (21788 61018 0 0))
;;; Generated autoloads from imenu.el

(defvar imenu-sort-function nil "\
The function to use for sorting the index mouse-menu.

Affects only the mouse index menu.

Set this to nil if you don't want any sorting (faster).
The items in the menu are then presented in the order they were found
in the buffer.

Set it to `imenu--sort-by-name' if you want alphabetic sorting.

The function should take two arguments and return t if the first
element should come before the second.  The arguments are cons cells;
\(NAME . POSITION).  Look at `imenu--sort-by-name' for an example.")

(custom-autoload 'imenu-sort-function "imenu" t)

(defvar imenu-generic-expression nil "\
List of definition matchers for creating an Imenu index.
Each element of this list should have the form

  (MENU-TITLE REGEXP INDEX [FUNCTION] [ARGUMENTS...])

MENU-TITLE should be nil (in which case the matches for this
element are put in the top level of the buffer index) or a
string (which specifies the title of a submenu into which the
matches are put).
REGEXP is a regular expression matching a definition construct
which is to be displayed in the menu.  REGEXP may also be a
function, called without arguments.  It is expected to search
backwards.  It must return true and set `match-data' if it finds
another element.
INDEX is an integer specifying which subexpression of REGEXP
matches the definition's name; this subexpression is displayed as
the menu item.
FUNCTION, if present, specifies a function to call when the index
item is selected by the user.  This function is called with
arguments consisting of the item name, the buffer position, and
the ARGUMENTS.

The variable `imenu-case-fold-search' determines whether or not
the regexp matches are case sensitive, and `imenu-syntax-alist'
can be used to alter the syntax table for the search.

If non-nil this pattern is passed to `imenu--generic-function' to
create a buffer index.

For example, see the value of `fortran-imenu-generic-expression'
used by `fortran-mode' with `imenu-syntax-alist' set locally to
give the characters which normally have \"symbol\" syntax
\"word\" syntax during matching.")
(put 'imenu-generic-expression 'risky-local-variable t)

(make-variable-buffer-local 'imenu-generic-expression)

(defvar imenu-create-index-function 'imenu-default-create-index-function "\
The function to use for creating an index alist of the current buffer.

It should be a function that takes no arguments and returns
an index alist of the current buffer.  The function is
called within a `save-excursion'.

See `imenu--index-alist' for the format of the buffer index alist.")

(make-variable-buffer-local 'imenu-create-index-function)

(defvar imenu-prev-index-position-function 'beginning-of-defun "\
Function for finding the next index position.

If `imenu-create-index-function' is set to
`imenu-default-create-index-function', then you must set this variable
to a function that will find the next index, looking backwards in the
file.

The function should leave point at the place to be connected to the
index and it should return nil when it doesn't find another index.")

(make-variable-buffer-local 'imenu-prev-index-position-function)

(defvar imenu-extract-index-name-function nil "\
Function for extracting the index item name, given a position.

This function is called after `imenu-prev-index-position-function'
finds a position for an index item, with point at that position.
It should return the name for that index item.")

(make-variable-buffer-local 'imenu-extract-index-name-function)

(defvar imenu-name-lookup-function nil "\
Function to compare string with index item.

This function will be called with two strings, and should return
non-nil if they match.

If nil, comparison is done with `string='.
Set this to some other function for more advanced comparisons,
such as \"begins with\" or \"name matches and number of
arguments match\".")

(make-variable-buffer-local 'imenu-name-lookup-function)

(defvar imenu-default-goto-function 'imenu-default-goto-function "\
The default function called when selecting an Imenu item.
The function in this variable is called when selecting a normal index-item.")

(make-variable-buffer-local 'imenu-default-goto-function)
(put 'imenu--index-alist 'risky-local-variable t)

(make-variable-buffer-local 'imenu-syntax-alist)

(make-variable-buffer-local 'imenu-case-fold-search)

(autoload 'imenu-add-to-menubar "imenu" "\
Add an `imenu' entry to the menu bar for the current buffer.
NAME is a string used to name the menu bar item.
See the command `imenu' for more information.

\(fn NAME)" t nil)

(autoload 'imenu-add-menubar-index "imenu" "\
Add an Imenu \"Index\" entry on the menu bar for the current buffer.

A trivial interface to `imenu-add-to-menubar' suitable for use in a hook.

\(fn)" t nil)

(autoload 'imenu "imenu" "\
Jump to a place in the buffer chosen using a buffer menu or mouse menu.
INDEX-ITEM specifies the position.  See `imenu-choose-buffer-index'
for more information.

\(fn INDEX-ITEM)" t nil)

;;;***

;;;### (autoloads nil "ind-util" "language/ind-util.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from language/ind-util.el

(autoload 'indian-compose-region "ind-util" "\
Compose the region according to `composition-function-table'.

\(fn FROM TO)" t nil)

(autoload 'indian-compose-string "ind-util" "\


\(fn STRING)" nil nil)

(autoload 'in-is13194-post-read-conversion "ind-util" "\


\(fn LEN)" nil nil)

(autoload 'in-is13194-pre-write-conversion "ind-util" "\


\(fn FROM TO)" nil nil)

(autoload 'indian-2-column-to-ucs-region "ind-util" "\
Convert old Emacs Devanagari characters to UCS.

\(fn FROM TO)" t nil)

;;;***

;;;### (autoloads nil "inf-lisp" "progmodes/inf-lisp.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/inf-lisp.el

(autoload 'inferior-lisp "inf-lisp" "\
Run an inferior Lisp process, input and output via buffer `*inferior-lisp*'.
If there is a process already running in `*inferior-lisp*', just switch
to that buffer.
With argument, allows you to edit the command line (default is value
of `inferior-lisp-program').  Runs the hooks from
`inferior-lisp-mode-hook' (after the `comint-mode-hook' is run).
\(Type \\[describe-mode] in the process buffer for a list of commands.)

\(fn CMD)" t nil)

(defalias 'run-lisp 'inferior-lisp)

;;;***

;;;### (autoloads nil "info" "info.el" (21788 61018 0 0))
;;; Generated autoloads from info.el

(defcustom Info-default-directory-list (let* ((config-dir (file-name-as-directory (or (and (featurep 'ns) (let ((dir (expand-file-name "../info" data-directory))) (if (file-directory-p dir) dir))) configure-info-directory))) (prefixes (prune-directory-list '("/usr/local/" "/usr/" "/opt/" "/"))) (suffixes '("share/" "" "gnu/" "gnu/lib/" "gnu/lib/emacs/" "emacs/" "lib/" "lib/emacs/")) (standard-info-dirs (apply #'nconc (mapcar (lambda (pfx) (let ((dirs (mapcar (lambda (sfx) (concat pfx sfx "info/")) suffixes))) (prune-directory-list dirs))) prefixes))) (dirs (if (member config-dir standard-info-dirs) (nconc standard-info-dirs (list config-dir)) (cons config-dir standard-info-dirs)))) (if (not (eq system-type 'windows-nt)) dirs (let* ((instdir (file-name-directory invocation-directory)) (dir1 (expand-file-name "../info/" instdir)) (dir2 (expand-file-name "../../../info/" instdir))) (cond ((file-exists-p dir1) (append dirs (list dir1))) ((file-exists-p dir2) (append dirs (list dir2))) (t dirs))))) "\
Default list of directories to search for Info documentation files.
They are searched in the order they are given in the list.
Therefore, the directory of Info files that come with Emacs
normally should come last (so that local files override standard ones),
unless Emacs is installed into a non-standard directory.  In the latter
case, the directory of Info files that come with Emacs should be
first in this list.

Once Info is started, the list of directories to search
comes from the variable `Info-directory-list'.
This variable `Info-default-directory-list' is used as the default
for initializing `Info-directory-list' when Info is started, unless
the environment variable INFOPATH is set.

Although this is a customizable variable, that is mainly for technical
reasons.  Normally, you should either set INFOPATH or customize
`Info-additional-directory-list', rather than changing this variable." :initialize (quote custom-initialize-delay) :type (quote (repeat directory)) :group (quote info))

(autoload 'info-other-window "info" "\
Like `info' but show the Info buffer in another window.

\(fn &optional FILE-OR-NODE BUFFER)" t nil)
 (put 'info 'info-file (purecopy "emacs"))

(autoload 'info "info" "\
Enter Info, the documentation browser.
Optional argument FILE-OR-NODE specifies the file to examine;
the default is the top-level directory of Info.
Called from a program, FILE-OR-NODE may specify an Info node of the form
\"(FILENAME)NODENAME\".
Optional argument BUFFER specifies the Info buffer name;
the default buffer name is *info*.  If BUFFER exists,
just switch to BUFFER.  Otherwise, create a new buffer
with the top-level Info directory.

In interactive use, a non-numeric prefix argument directs
this command to read a file name from the minibuffer.

A numeric prefix argument of N selects an Info buffer named \"*info*<N>\".

The search path for Info files is in the variable `Info-directory-list'.
The top-level Info directory is made by combining all the files named `dir'
in all the directories in that path.

See a list of available Info commands in `Info-mode'.

\(fn &optional FILE-OR-NODE BUFFER)" t nil)

(autoload 'info-emacs-manual "info" "\
Display the Emacs manual in Info mode.

\(fn)" t nil)

(autoload 'info-emacs-bug "info" "\
Display the \"Reporting Bugs\" section of the Emacs manual in Info mode.

\(fn)" t nil)

(autoload 'info-standalone "info" "\
Run Emacs as a standalone Info reader.
Usage:  emacs -f info-standalone [filename]
In standalone mode, \\<Info-mode-map>\\[Info-exit] exits Emacs itself.

\(fn)" nil nil)

(autoload 'Info-on-current-buffer "info" "\
Use Info mode to browse the current Info buffer.
With a prefix arg, this queries for the node name to visit first;
otherwise, that defaults to `Top'.

\(fn &optional NODENAME)" t nil)

(autoload 'Info-directory "info" "\
Go to the Info directory node.

\(fn)" t nil)

(autoload 'Info-index "info" "\
Look up a string TOPIC in the index for this manual and go to that entry.
If there are no exact matches to the specified topic, this chooses
the first match which is a case-insensitive substring of a topic.
Use the \\<Info-mode-map>\\[Info-index-next] command to see the other matches.
Give an empty topic name to go to the Index node itself.

\(fn TOPIC)" t nil)

(autoload 'info-apropos "info" "\
Grovel indices of all known Info files on your system for STRING.
Build a menu of the possible matches.

\(fn STRING)" t nil)

(autoload 'info-finder "info" "\
Display descriptions of the keywords in the Finder virtual manual.
In interactive use, a prefix argument directs this command to read
a list of keywords separated by comma.  After that, it displays a node
with a list of packages that contain all specified keywords.

\(fn &optional KEYWORDS)" t nil)

(autoload 'Info-mode "info" "\
Info mode provides commands for browsing through the Info documentation tree.
Documentation in Info is divided into \"nodes\", each of which discusses
one topic and contains references to other nodes which discuss related
topics.  Info has commands to follow the references and show you other nodes.

\\<Info-mode-map>\\[Info-help]	Invoke the Info tutorial.
\\[Info-exit]	Quit Info: reselect previously selected buffer.

Selecting other nodes:
\\[Info-mouse-follow-nearest-node]
	Follow a node reference you click on.
	  This works with menu items, cross references, and
	  the \"next\", \"previous\" and \"up\", depending on where you click.
\\[Info-follow-nearest-node]	Follow a node reference near point, like \\[Info-mouse-follow-nearest-node].
\\[Info-next]	Move to the \"next\" node of this node.
\\[Info-prev]	Move to the \"previous\" node of this node.
\\[Info-up]	Move \"up\" from this node.
\\[Info-menu]	Pick menu item specified by name (or abbreviation).
	  Picking a menu item causes another node to be selected.
\\[Info-directory]	Go to the Info directory node.
\\[Info-top-node]	Go to the Top node of this file.
\\[Info-final-node]	Go to the final node in this file.
\\[Info-backward-node]	Go backward one node, considering all nodes as forming one sequence.
\\[Info-forward-node]	Go forward one node, considering all nodes as forming one sequence.
\\[Info-next-reference]	Move cursor to next cross-reference or menu item.
\\[Info-prev-reference]	Move cursor to previous cross-reference or menu item.
\\[Info-follow-reference]	Follow a cross reference.  Reads name of reference.
\\[Info-history-back]	Move back in history to the last node you were at.
\\[Info-history-forward]	Move forward in history to the node you returned from after using \\[Info-history-back].
\\[Info-history]	Go to menu of visited nodes.
\\[Info-toc]	Go to table of contents of the current Info file.

Moving within a node:
\\[Info-scroll-up]	Normally, scroll forward a full screen.
	  Once you scroll far enough in a node that its menu appears on the
	  screen but after point, the next scroll moves into its first
	  subnode.  When after all menu items (or if there is no menu),
	  move up to the parent node.
\\[Info-scroll-down]	Normally, scroll backward.  If the beginning of the buffer is
	  already visible, try to go to the previous menu entry, or up
	  if there is none.
\\[beginning-of-buffer]	Go to beginning of node.

Advanced commands:
\\[Info-search]	Search through this Info file for specified regexp,
	  and select the node in which the next occurrence is found.
\\[Info-search-case-sensitively]	Search through this Info file for specified regexp case-sensitively.
\\[isearch-forward], \\[isearch-forward-regexp]	Use Isearch to search through multiple Info nodes.
\\[Info-index]	Search for a topic in this manual's Index and go to index entry.
\\[Info-index-next]	(comma) Move to the next match from a previous \\<Info-mode-map>\\[Info-index] command.
\\[Info-virtual-index]	Look for a string and display the index node with results.
\\[info-apropos]	Look for a string in the indices of all manuals.
\\[Info-goto-node]	Move to node specified by name.
	  You may include a filename as well, as (FILENAME)NODENAME.
1 .. 9	Pick first ... ninth item in node's menu.
	  Every third `*' is highlighted to help pick the right number.
\\[Info-copy-current-node-name]	Put name of current Info node in the kill ring.
\\[clone-buffer]	Select a new cloned Info buffer in another window.
\\[universal-argument] \\[info]	Move to new Info file with completion.
\\[universal-argument] N \\[info]	Select Info buffer with prefix number in the name *info*<N>.

\(fn)" t nil)
 (put 'Info-goto-emacs-command-node 'info-file (purecopy "emacs"))

(autoload 'Info-goto-emacs-command-node "info" "\
Go to the Info node in the Emacs manual for command COMMAND.
The command is found by looking up in Emacs manual's indices
or in another manual found via COMMAND's `info-file' property or
the variable `Info-file-list-for-emacs'.
COMMAND must be a symbol or string.

\(fn COMMAND)" t nil)
 (put 'Info-goto-emacs-key-command-node 'info-file (purecopy "emacs"))

(autoload 'Info-goto-emacs-key-command-node "info" "\
Go to the node in the Emacs manual which describes the command bound to KEY.
KEY is a string.
Interactively, if the binding is `execute-extended-command', a command is read.
The command is found by looking up in Emacs manual's indices
or in another manual found via COMMAND's `info-file' property or
the variable `Info-file-list-for-emacs'.

\(fn KEY)" t nil)

(autoload 'Info-speedbar-browser "info" "\
Initialize speedbar to display an Info node browser.
This will add a speedbar major display mode.

\(fn)" t nil)

(autoload 'Info-bookmark-jump "info" "\
This implements the `handler' function interface for the record
type returned by `Info-bookmark-make-record', which see.

\(fn BMK)" nil nil)

(autoload 'info-display-manual "info" "\
Display an Info buffer displaying MANUAL.
If there is an existing Info buffer for MANUAL, display it.
Otherwise, visit the manual in a new Info buffer.

\(fn MANUAL)" t nil)

;;;***

;;;### (autoloads nil "info-look" "info-look.el" (21788 61018 0 0))
;;; Generated autoloads from info-look.el

(autoload 'info-lookup-reset "info-look" "\
Throw away all cached data.
This command is useful if the user wants to start at the beginning without
quitting Emacs, for example, after some Info documents were updated on the
system.

\(fn)" t nil)
 (put 'info-lookup-symbol 'info-file "emacs")

(autoload 'info-lookup-symbol "info-look" "\
Display the definition of SYMBOL, as found in the relevant manual.
When this command is called interactively, it reads SYMBOL from the
minibuffer.  In the minibuffer, use M-n to yank the default argument
value into the minibuffer so you can edit it.  The default symbol is the
one found at point.

With prefix arg MODE a query for the symbol help mode is offered.

\(fn SYMBOL &optional MODE)" t nil)
 (put 'info-lookup-file 'info-file "emacs")

(autoload 'info-lookup-file "info-look" "\
Display the documentation of a file.
When this command is called interactively, it reads FILE from the minibuffer.
In the minibuffer, use M-n to yank the default file name
into the minibuffer so you can edit it.
The default file name is the one found at point.

With prefix arg MODE a query for the file help mode is offered.

\(fn FILE &optional MODE)" t nil)

(autoload 'info-complete-symbol "info-look" "\
Perform completion on symbol preceding point.

\(fn &optional MODE)" t nil)

(autoload 'info-complete-file "info-look" "\
Perform completion on file preceding point.

\(fn &optional MODE)" t nil)

;;;***

;;;### (autoloads nil "info-xref" "info-xref.el" (21710 25077 0 0))
;;; Generated autoloads from info-xref.el
(push (purecopy '(info-xref 3)) package--builtin-versions)

(autoload 'info-xref-check "info-xref" "\
Check external references in FILENAME, an info document.
Interactively from an `Info-mode' or `texinfo-mode' buffer the
current info file is the default.

Results are shown in a `compilation-mode' buffer.  The format is
a bit rough, but there shouldn't be many problems normally.  The
file:line:column: is the info document, but of course normally
any correction should be made in the original .texi file.
Finding the right place in the .texi is a manual process.

When a target info file doesn't exist there's obviously no way to
validate node references within it.  A message is given for
missing target files once per source document.  It could be
simply that you don't have the target installed, or it could be a
mistake in the reference.

Indirect info files are understood, just pass the top-level
foo.info to `info-xref-check' and it traverses all sub-files.
Compressed info files are accepted too as usual for `Info-mode'.

\"makeinfo\" checks references internal to an info document, but
not external references, which makes it rather easy for mistakes
to creep in or node name changes to go unnoticed.
`Info-validate' doesn't check external references either.

\(fn FILENAME)" t nil)

(autoload 'info-xref-check-all "info-xref" "\
Check external references in all info documents in the info path.
`Info-directory-list' and `Info-additional-directory-list' are
the info paths.  See `info-xref-check' for how each file is
checked.

The search for \"all\" info files is rather permissive, since
info files don't necessarily have a \".info\" extension and in
particular the Emacs manuals normally don't.  If you have a
source code directory in `Info-directory-list' then a lot of
extraneous files might be read.  This will be time consuming but
should be harmless.

\(fn)" t nil)

(autoload 'info-xref-check-all-custom "info-xref" "\
Check info references in all customize groups and variables.
Info references can be in `custom-manual' or `info-link' entries
of the `custom-links' for a variable.

Any `custom-load' autoloads in variables are loaded in order to
get full link information.  This will be a lot of Lisp packages
and can take a long time.

\(fn)" t nil)

(autoload 'info-xref-docstrings "info-xref" "\
Check docstring info node references in source files.
The given files are searched for docstring hyperlinks like

    Info node `(elisp)Documentation Tips'

and those links checked by attempting to visit the target nodes
as per `info-xref-check' does.

Interactively filenames are read as a wildcard pattern like
\"foo*.el\", with the current file as a default.  Usually this
will be lisp sources, but anything with such hyperlinks can be
checked, including the Emacs .c sources (or the etc/DOC file of
all builtins).

Because info node hyperlinks are found by a simple regexp search
in the files, the Lisp code checked doesn't have to be loaded,
and links can be in the file commentary or elsewhere too.  Even
.elc files can usually be checked successfully if you don't have
the sources handy.

\(fn FILENAME-LIST)" t nil)

;;;***

;;;### (autoloads nil "informat" "informat.el" (21710 25077 0 0))
;;; Generated autoloads from informat.el

(autoload 'Info-tagify "informat" "\
Create or update Info file tag table in current buffer or in a region.

\(fn &optional INPUT-BUFFER-NAME)" t nil)

(defvar Info-split-threshold 262144 "\
The number of characters by which `Info-split' splits an info file.")

(custom-autoload 'Info-split-threshold "informat" t)

(autoload 'Info-split "informat" "\
Split an info file into an indirect file plus bounded-size subfiles.
Each subfile will be up to the number of characters that
`Info-split-threshold' specifies, plus one node.

To use this command, first visit a large Info file that has a tag
table.  The buffer is modified into a (small) indirect info file which
should be saved in place of the original visited file.

The subfiles are written in the same directory the original file is
in, with names generated by appending `-' and a number to the original
file name.  The indirect file still functions as an Info file, but it
contains just the tag table and a directory of subfiles.

\(fn)" t nil)

(autoload 'Info-validate "informat" "\
Check current buffer for validity as an Info file.
Check that every node pointer points to an existing node.

\(fn)" t nil)

(autoload 'batch-info-validate "informat" "\
Runs `Info-validate' on the files remaining on the command line.
Must be used only with -batch, and kills Emacs on completion.
Each file will be processed even if an error occurred previously.
For example, invoke \"emacs -batch -f batch-info-validate $info/ ~/*.info\"

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "inversion" "cedet/inversion.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from cedet/inversion.el
(push (purecopy '(inversion 1 3)) package--builtin-versions)

(autoload 'inversion-require-emacs "inversion" "\
Declare that you need either EMACS-VER, XEMACS-VER or SXEMACS-ver.
Only checks one based on which kind of Emacs is being run.

\(fn EMACS-VER XEMACS-VER SXEMACS-VER)" nil nil)

;;;***

;;;### (autoloads nil "isearch-x" "international/isearch-x.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from international/isearch-x.el

(autoload 'isearch-toggle-specified-input-method "isearch-x" "\
Select an input method and turn it on in interactive search.

\(fn)" t nil)

(autoload 'isearch-toggle-input-method "isearch-x" "\
Toggle input method in interactive search.

\(fn)" t nil)

(autoload 'isearch-process-search-multibyte-characters "isearch-x" "\


\(fn LAST-CHAR &optional COUNT)" nil nil)

;;;***

;;;### (autoloads nil "isearchb" "isearchb.el" (21788 61018 0 0))
;;; Generated autoloads from isearchb.el
(push (purecopy '(isearchb 1 5)) package--builtin-versions)

(autoload 'isearchb-activate "isearchb" "\
Active isearchb mode for subsequent alphanumeric keystrokes.
Executing this command again will terminate the search; or, if
the search has not yet begun, will toggle to the last buffer
accessed via isearchb.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "iso-cvt" "international/iso-cvt.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from international/iso-cvt.el

(autoload 'iso-spanish "iso-cvt" "\
Translate net conventions for Spanish to ISO 8859-1.
Translate the region between FROM and TO using the table
`iso-spanish-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

\(fn FROM TO &optional BUFFER)" t nil)

(autoload 'iso-german "iso-cvt" "\
Translate net conventions for German to ISO 8859-1.
Translate the region FROM and TO using the table
`iso-german-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

\(fn FROM TO &optional BUFFER)" t nil)

(autoload 'iso-iso2tex "iso-cvt" "\
Translate ISO 8859-1 characters to TeX sequences.
Translate the region between FROM and TO using the table
`iso-iso2tex-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

\(fn FROM TO &optional BUFFER)" t nil)

(autoload 'iso-tex2iso "iso-cvt" "\
Translate TeX sequences to ISO 8859-1 characters.
Translate the region between FROM and TO using the table
`iso-tex2iso-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

\(fn FROM TO &optional BUFFER)" t nil)

(autoload 'iso-gtex2iso "iso-cvt" "\
Translate German TeX sequences to ISO 8859-1 characters.
Translate the region between FROM and TO using the table
`iso-gtex2iso-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

\(fn FROM TO &optional BUFFER)" t nil)

(autoload 'iso-iso2gtex "iso-cvt" "\
Translate ISO 8859-1 characters to German TeX sequences.
Translate the region between FROM and TO using the table
`iso-iso2gtex-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

\(fn FROM TO &optional BUFFER)" t nil)

(autoload 'iso-iso2duden "iso-cvt" "\
Translate ISO 8859-1 characters to Duden sequences.
Translate the region between FROM and TO using the table
`iso-iso2duden-trans-tab'.
Optional arg BUFFER is ignored (for use in `format-alist').

\(fn FROM TO &optional BUFFER)" t nil)

(autoload 'iso-iso2sgml "iso-cvt" "\
Translate ISO 8859-1 characters in the region to SGML entities.
Use entities from \"ISO 8879:1986//ENTITIES Added Latin 1//EN\".
Optional arg BUFFER is ignored (for use in `format-alist').

\(fn FROM TO &optional BUFFER)" t nil)

(autoload 'iso-sgml2iso "iso-cvt" "\
Translate SGML entities in the region to ISO 8859-1 characters.
Use entities from \"ISO 8879:1986//ENTITIES Added Latin 1//EN\".
Optional arg BUFFER is ignored (for use in `format-alist').

\(fn FROM TO &optional BUFFER)" t nil)

(autoload 'iso-cvt-read-only "iso-cvt" "\
Warn that format is read-only.

\(fn &rest IGNORE)" t nil)

(autoload 'iso-cvt-write-only "iso-cvt" "\
Warn that format is write-only.

\(fn &rest IGNORE)" t nil)

(autoload 'iso-cvt-define-menu "iso-cvt" "\
Add submenus to the File menu, to convert to and from various formats.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "iso-transl" "international/iso-transl.el"
;;;;;;  (21710 25077 0 0))
;;; Generated autoloads from international/iso-transl.el
 (define-key key-translation-map "\C-x8" 'iso-transl-ctl-x-8-map)
 (autoload 'iso-transl-ctl-x-8-map "iso-transl" "Keymap for C-x 8 prefix." t 'keymap)

;;;***

;;;### (autoloads nil "ispell" "textmodes/ispell.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from textmodes/ispell.el

(put 'ispell-check-comments 'safe-local-variable (lambda (a) (memq a '(nil t exclusive))))

(defvar ispell-personal-dictionary nil "\
File name of your personal spelling dictionary, or nil.
If nil, the default personal dictionary, (\"~/.ispell_DICTNAME\" for ispell or
\"~/.aspell.LANG.pws\" for aspell) is used, where DICTNAME is the name of your
default dictionary and LANG the two letter language code.")

(custom-autoload 'ispell-personal-dictionary "ispell" t)

(put 'ispell-local-dictionary 'safe-local-variable 'string-or-null-p)

(defvar ispell-menu-map nil "\
Key map for ispell menu.")

(defvar ispell-menu-xemacs nil "\
Spelling menu for XEmacs.
If nil when package is loaded, a standard menu will be set,
and added as a submenu of the \"Edit\" menu.")

(defvar ispell-menu-map-needed (and (not ispell-menu-map) (not (featurep 'xemacs)) 'reload))

(if ispell-menu-map-needed (progn (setq ispell-menu-map (make-sparse-keymap "Spell")) (define-key ispell-menu-map [ispell-change-dictionary] `(menu-item ,(purecopy "Change Dictionary...") ispell-change-dictionary :help ,(purecopy "Supply explicit dictionary file name"))) (define-key ispell-menu-map [ispell-kill-ispell] `(menu-item ,(purecopy "Kill Process") (lambda nil (interactive) (ispell-kill-ispell nil 'clear)) :enable (and (boundp 'ispell-process) ispell-process (eq (ispell-process-status) 'run)) :help ,(purecopy "Terminate Ispell subprocess"))) (define-key ispell-menu-map [ispell-pdict-save] `(menu-item ,(purecopy "Save Dictionary") (lambda nil (interactive) (ispell-pdict-save t t)) :help ,(purecopy "Save personal dictionary"))) (define-key ispell-menu-map [ispell-customize] `(menu-item ,(purecopy "Customize...") (lambda nil (interactive) (customize-group 'ispell)) :help ,(purecopy "Customize spell checking options"))) (define-key ispell-menu-map [ispell-help] `(menu-item ,(purecopy "Help") (lambda nil (interactive) (describe-function 'ispell-help)) :help ,(purecopy "Show standard Ispell keybindings and commands"))) (define-key ispell-menu-map [flyspell-mode] `(menu-item ,(purecopy "Automatic spell checking (Flyspell)") flyspell-mode :help ,(purecopy "Check spelling while you edit the text") :button (:toggle bound-and-true-p flyspell-mode))) (define-key ispell-menu-map [ispell-complete-word] `(menu-item ,(purecopy "Complete Word") ispell-complete-word :help ,(purecopy "Complete word at cursor using dictionary"))) (define-key ispell-menu-map [ispell-complete-word-interior-frag] `(menu-item ,(purecopy "Complete Word Fragment") ispell-complete-word-interior-frag :help ,(purecopy "Complete word fragment at cursor")))))

(if ispell-menu-map-needed (progn (define-key ispell-menu-map [ispell-continue] `(menu-item ,(purecopy "Continue Spell-Checking") ispell-continue :enable (and (boundp 'ispell-region-end) (marker-position ispell-region-end) (equal (marker-buffer ispell-region-end) (current-buffer))) :help ,(purecopy "Continue spell checking last region"))) (define-key ispell-menu-map [ispell-word] `(menu-item ,(purecopy "Spell-Check Word") ispell-word :help ,(purecopy "Spell-check word at cursor"))) (define-key ispell-menu-map [ispell-comments-and-strings] `(menu-item ,(purecopy "Spell-Check Comments") ispell-comments-and-strings :help ,(purecopy "Spell-check only comments and strings")))))

(if ispell-menu-map-needed (progn (define-key ispell-menu-map [ispell-region] `(menu-item ,(purecopy "Spell-Check Region") ispell-region :enable mark-active :help ,(purecopy "Spell-check text in marked region"))) (define-key ispell-menu-map [ispell-message] `(menu-item ,(purecopy "Spell-Check Message") ispell-message :visible (eq major-mode 'mail-mode) :help ,(purecopy "Skip headers and included message text"))) (define-key ispell-menu-map [ispell-buffer] `(menu-item ,(purecopy "Spell-Check Buffer") ispell-buffer :help ,(purecopy "Check spelling of selected buffer"))) (fset 'ispell-menu-map (symbol-value 'ispell-menu-map))))

(defvar ispell-skip-region-alist `((ispell-words-keyword forward-line) (ispell-dictionary-keyword forward-line) (ispell-pdict-keyword forward-line) (ispell-parsing-keyword forward-line) (,(purecopy "^---*BEGIN PGP [A-Z ]*--*") \, (purecopy "^---*END PGP [A-Z ]*--*")) (,(purecopy "^begin [0-9][0-9][0-9] [^ 	]+$") \, (purecopy "\nend\n")) (,(purecopy "^%!PS-Adobe-[123].0") \, (purecopy "\n%%EOF\n")) (,(purecopy "^---* \\(Start of \\)?[Ff]orwarded [Mm]essage") \, (purecopy "^---* End of [Ff]orwarded [Mm]essage")) (,(purecopy "\\(--+\\|_+\\|\\(/\\w\\|\\(\\(\\w\\|[-_]\\)+[.:@]\\)\\)\\(\\w\\|[-_]\\)*\\([.:/@]+\\(\\w\\|[-_~=?&]\\)+\\)+\\)"))) "\
Alist expressing beginning and end of regions not to spell check.
The alist key must be a regular expression.
Valid forms include:
  (KEY) - just skip the key.
  (KEY . REGEXP) - skip to the end of REGEXP.  REGEXP may be string or symbol.
  (KEY REGEXP) - skip to end of REGEXP.  REGEXP must be a string.
  (KEY FUNCTION ARGS) - FUNCTION called with ARGS returns end of region.")

(defvar ispell-tex-skip-alists (purecopy '((("\\\\addcontentsline" ispell-tex-arg-end 2) ("\\\\add\\(tocontents\\|vspace\\)" ispell-tex-arg-end) ("\\\\\\([aA]lph\\|arabic\\)" ispell-tex-arg-end) ("\\\\bibliographystyle" ispell-tex-arg-end) ("\\\\makebox" ispell-tex-arg-end 0) ("\\\\e?psfig" ispell-tex-arg-end) ("\\\\document\\(class\\|style\\)" . "\\\\begin[ 	\n]*{[ 	\n]*document[ 	\n]*}")) (("\\(figure\\|table\\)\\*?" ispell-tex-arg-end 0) ("list" ispell-tex-arg-end 2) ("program" . "\\\\end[ 	\n]*{[ 	\n]*program[ 	\n]*}") ("verbatim\\*?" . "\\\\end[ 	\n]*{[ 	\n]*verbatim\\*?[ 	\n]*}")))) "\
Lists of regions to be skipped in TeX mode.
First list is used raw.
Second list has key placed inside \\begin{}.

Delete or add any regions you want to be automatically selected
for skipping in latex mode.")

(defconst ispell-html-skip-alists '(("<[cC][oO][dD][eE]\\>[^>]*>" "</[cC][oO][dD][eE]*>") ("<[sS][cC][rR][iI][pP][tT]\\>[^>]*>" "</[sS][cC][rR][iI][pP][tT]>") ("<[aA][pP][pP][lL][eE][tT]\\>[^>]*>" "</[aA][pP][pP][lL][eE][tT]>") ("<[vV][eE][rR][bB]\\>[^>]*>" "<[vV][eE][rR][bB]\\>[^>]*>") ("<[tT][tT]/" "/") ("<[^ 	\n>]" ">") ("&[^ 	\n;]" "[; 	\n]")) "\
Lists of start and end keys to skip in HTML buffers.
Same format as `ispell-skip-region-alist'.
Note - substrings of other matches must come last
 (e.g. \"<[tT][tT]/\" and \"<[^ \\t\\n>]\").")
(put 'ispell-local-pdict 'safe-local-variable 'stringp)
 (define-key esc-map "$" 'ispell-word)

(autoload 'ispell-word "ispell" "\
Check spelling of word under or before the cursor.
If the word is not found in dictionary, display possible corrections
in a window allowing you to choose one.

If optional argument FOLLOWING is non-nil or if `ispell-following-word'
is non-nil when called interactively, then the following word
\(rather than preceding) is checked when the cursor is not over a word.
When the optional argument QUIETLY is non-nil or `ispell-quietly' is non-nil
when called interactively, non-corrective messages are suppressed.

With a prefix argument (or if CONTINUE is non-nil),
resume interrupted spell-checking of a buffer or region.

Interactively, in Transient Mark mode when the mark is active, call
`ispell-region' to check the active region for spelling errors.

Word syntax is controlled by the definition of the chosen dictionary,
which is in `ispell-local-dictionary-alist' or `ispell-dictionary-alist'.

This will check or reload the dictionary.  Use \\[ispell-change-dictionary]
or \\[ispell-region] to update the Ispell process.

Return values:
nil           word is correct or spelling is accepted.
0             word is inserted into buffer-local definitions.
\"word\"        word corrected from word list.
\(\"word\" arg)  word is hand entered.
quit          spell session exited.

\(fn &optional FOLLOWING QUIETLY CONTINUE REGION)" t nil)

(autoload 'ispell-pdict-save "ispell" "\
Check to see if the personal dictionary has been modified.
If so, ask if it needs to be saved.

\(fn &optional NO-QUERY FORCE-SAVE)" t nil)

(autoload 'ispell-help "ispell" "\
Display a list of the options available when a misspelling is encountered.

Selections are:

DIGIT: Replace the word with a digit offered in the *Choices* buffer.
SPC:   Accept word this time.
`i':   Accept word and insert into private dictionary.
`a':   Accept word for this session.
`A':   Accept word and place in `buffer-local dictionary'.
`r':   Replace word with typed-in value.  Rechecked.
`R':   Replace word with typed-in value.  Query-replaced in buffer.  Rechecked.
`?':   Show these commands.
`x':   Exit spelling buffer.  Move cursor to original point.
`X':   Exit spelling buffer.  Leaves cursor at the current point, and permits
        the aborted check to be completed later.
`q':   Quit spelling session (Kills ispell process).
`l':   Look up typed-in replacement in alternate dictionary.  Wildcards okay.
`u':   Like `i', but the word is lower-cased first.
`m':   Place typed-in value in personal dictionary, then recheck current word.
`C-l':  Redraw screen.
`C-r':  Recursive edit.
`C-z':  Suspend Emacs or iconify frame.

\(fn)" nil nil)

(autoload 'ispell-kill-ispell "ispell" "\
Kill current Ispell process (so that you may start a fresh one).
With NO-ERROR, just return non-nil if there was no Ispell running.
With CLEAR, buffer session localwords are cleaned.

\(fn &optional NO-ERROR CLEAR)" t nil)

(autoload 'ispell-change-dictionary "ispell" "\
Change to dictionary DICT for Ispell.
With a prefix arg, set it \"globally\", for all buffers.
Without a prefix arg, set it \"locally\", just for this buffer.

By just answering RET you can find out what the current dictionary is.

\(fn DICT &optional ARG)" t nil)

(autoload 'ispell-region "ispell" "\
Interactively check a region for spelling errors.
Return nil if spell session was terminated, otherwise returns shift offset
amount for last line processed.

\(fn REG-START REG-END &optional RECHECKP SHIFT)" t nil)

(autoload 'ispell-comments-and-strings "ispell" "\
Check comments and strings in the current buffer for spelling errors.

\(fn)" t nil)

(autoload 'ispell-buffer "ispell" "\
Check the current buffer for spelling errors interactively.

\(fn)" t nil)

(autoload 'ispell-buffer-with-debug "ispell" "\
`ispell-buffer' with some output sent to `ispell-debug-buffer' buffer.
Use APPEND to append the info to previous buffer if exists.

\(fn &optional APPEND)" t nil)

(autoload 'ispell-continue "ispell" "\
Continue a halted spelling session beginning with the current word.

\(fn)" t nil)

(autoload 'ispell-complete-word "ispell" "\
Try to complete the word before or under point.
If optional INTERIOR-FRAG is non-nil then the word may be a character
sequence inside of a word.

Standard ispell choices are then available.

\(fn &optional INTERIOR-FRAG)" t nil)

(autoload 'ispell-complete-word-interior-frag "ispell" "\
Completes word matching character sequence inside a word.

\(fn)" t nil)

(autoload 'ispell "ispell" "\
Interactively check a region or buffer for spelling errors.
If `transient-mark-mode' is on, and a region is active, spell-check
that region.  Otherwise spell-check the buffer.

Ispell dictionaries are not distributed with Emacs.  If you are
looking for a dictionary, please see the distribution of the GNU ispell
program, or do an Internet search; there are various dictionaries
available on the net.

\(fn)" t nil)

(autoload 'ispell-minor-mode "ispell" "\
Toggle last-word spell checking (Ispell minor mode).
With a prefix argument ARG, enable Ispell minor mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Ispell minor mode is a buffer-local minor mode.  When enabled,
typing SPC or RET warns you if the previous word is incorrectly
spelled.

All the buffer-local variables and dictionaries are ignored.  To
read them into the running ispell process, type \\[ispell-word]
SPC.

For spell-checking \"on the fly\", not just after typing SPC or
RET, use `flyspell-mode'.

\(fn &optional ARG)" t nil)

(autoload 'ispell-message "ispell" "\
Check the spelling of a mail message or news post.
Don't check spelling of message headers except the Subject field.
Don't check included messages.

To abort spell checking of a message region and send the message anyway,
use the `x' command.  (Any subsequent regions will be checked.)
The `X' command aborts sending the message so that you can edit the buffer.

To spell-check whenever a message is sent, include the appropriate lines
in your init file:
   (add-hook 'message-send-hook 'ispell-message)  ;; GNUS 5
   (add-hook 'news-inews-hook 'ispell-message)    ;; GNUS 4
   (add-hook 'mail-send-hook  'ispell-message)
   (add-hook 'mh-before-send-letter-hook 'ispell-message)

You can bind this to the key C-c i in GNUS or mail by adding to
`news-reply-mode-hook' or `mail-mode-hook' the following lambda expression:
   (function (lambda () (local-set-key \"\\C-ci\" 'ispell-message)))

\(fn)" t nil)

;;;***

;;;### (autoloads nil "japan-util" "language/japan-util.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from language/japan-util.el

(autoload 'setup-japanese-environment-internal "japan-util" "\


\(fn)" nil nil)

(autoload 'japanese-katakana "japan-util" "\
Convert argument to Katakana and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.
Optional argument HANKAKU t means to convert to `hankaku' Katakana
 (`japanese-jisx0201-kana'), in which case return value
 may be a string even if OBJ is a character if two Katakanas are
 necessary to represent OBJ.

\(fn OBJ &optional HANKAKU)" nil nil)

(autoload 'japanese-hiragana "japan-util" "\
Convert argument to Hiragana and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.

\(fn OBJ)" nil nil)

(autoload 'japanese-hankaku "japan-util" "\
Convert argument to `hankaku' and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.
Optional argument ASCII-ONLY non-nil means to return only ASCII character.

\(fn OBJ &optional ASCII-ONLY)" nil nil)

(autoload 'japanese-zenkaku "japan-util" "\
Convert argument to `zenkaku' and return that.
The argument may be a character or string.  The result has the same type.
The argument object is not altered--the value is a copy.

\(fn OBJ)" nil nil)

(autoload 'japanese-katakana-region "japan-util" "\
Convert Japanese `hiragana' chars in the region to `katakana' chars.
Optional argument HANKAKU t means to convert to `hankaku katakana' character
of which charset is `japanese-jisx0201-kana'.

\(fn FROM TO &optional HANKAKU)" t nil)

(autoload 'japanese-hiragana-region "japan-util" "\
Convert Japanese `katakana' chars in the region to `hiragana' chars.

\(fn FROM TO)" t nil)

(autoload 'japanese-hankaku-region "japan-util" "\
Convert Japanese `zenkaku' chars in the region to `hankaku' chars.
`Zenkaku' chars belong to `japanese-jisx0208'
`Hankaku' chars belong to `ascii' or `japanese-jisx0201-kana'.
Optional argument ASCII-ONLY non-nil means to convert only to ASCII char.

\(fn FROM TO &optional ASCII-ONLY)" t nil)

(autoload 'japanese-zenkaku-region "japan-util" "\
Convert hankaku' chars in the region to Japanese `zenkaku' chars.
`Zenkaku' chars belong to `japanese-jisx0208'
`Hankaku' chars belong to `ascii' or `japanese-jisx0201-kana'.
Optional argument KATAKANA-ONLY non-nil means to convert only KATAKANA char.

\(fn FROM TO &optional KATAKANA-ONLY)" t nil)

(autoload 'read-hiragana-string "japan-util" "\
Read a Hiragana string from the minibuffer, prompting with string PROMPT.
If non-nil, second arg INITIAL-INPUT is a string to insert before reading.

\(fn PROMPT &optional INITIAL-INPUT)" nil nil)

;;;***

;;;### (autoloads nil "jka-compr" "jka-compr.el" (21710 25077 0 0))
;;; Generated autoloads from jka-compr.el

(defvar jka-compr-inhibit nil "\
Non-nil means inhibit automatic uncompression temporarily.
Lisp programs can bind this to t to do that.
It is not recommended to set this variable permanently to anything but nil.")

(autoload 'jka-compr-handler "jka-compr" "\


\(fn OPERATION &rest ARGS)" nil nil)

(autoload 'jka-compr-uninstall "jka-compr" "\
Uninstall jka-compr.
This removes the entries in `file-name-handler-alist' and `auto-mode-alist'
and `inhibit-local-variables-suffixes' that were added
by `jka-compr-installed'.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "js" "progmodes/js.el" (21788 61018 0 0))
;;; Generated autoloads from progmodes/js.el
(push (purecopy '(js 9)) package--builtin-versions)

(autoload 'js-mode "js" "\
Major mode for editing JavaScript.

\(fn)" t nil)
 (defalias 'javascript-mode 'js-mode)

;;;***

;;;### (autoloads nil "json" "json.el" (21788 61018 0 0))
;;; Generated autoloads from json.el
(push (purecopy '(json 1 4)) package--builtin-versions)

;;;***

;;;### (autoloads nil "keypad" "emulation/keypad.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from emulation/keypad.el

(defvar keypad-setup nil "\
Specifies the keypad setup for unshifted keypad keys when NumLock is off.
When selecting the plain numeric keypad setup, the character returned by the
decimal key must be specified.")

(custom-autoload 'keypad-setup "keypad" nil)

(defvar keypad-numlock-setup nil "\
Specifies the keypad setup for unshifted keypad keys when NumLock is on.
When selecting the plain numeric keypad setup, the character returned by the
decimal key must be specified.")

(custom-autoload 'keypad-numlock-setup "keypad" nil)

(defvar keypad-shifted-setup nil "\
Specifies the keypad setup for shifted keypad keys when NumLock is off.
When selecting the plain numeric keypad setup, the character returned by the
decimal key must be specified.")

(custom-autoload 'keypad-shifted-setup "keypad" nil)

(defvar keypad-numlock-shifted-setup nil "\
Specifies the keypad setup for shifted keypad keys when NumLock is off.
When selecting the plain numeric keypad setup, the character returned by the
decimal key must be specified.")

(custom-autoload 'keypad-numlock-shifted-setup "keypad" nil)

(autoload 'keypad-setup "keypad" "\
Set keypad bindings in `function-key-map' according to SETUP.
If optional second argument NUMLOCK is non-nil, the NumLock On bindings
are changed.  Otherwise, the NumLock Off bindings are changed.
If optional third argument SHIFT is non-nil, the shifted keypad
keys are bound.

 Setup      Binding
 -------------------------------------------------------------
 'prefix   Command prefix argument, i.e.  M-0 .. M-9 and M--
 'S-cursor Bind shifted keypad keys to the shifted cursor movement keys.
 'cursor   Bind keypad keys to the cursor movement keys.
 'numeric  Plain numeric keypad, i.e. 0 .. 9 and .  (or DECIMAL arg)
 'none     Removes all bindings for keypad keys in function-key-map;
           this enables any user-defined bindings for the keypad keys
           in the global and local keymaps.

If SETUP is 'numeric and the optional fourth argument DECIMAL is non-nil,
the decimal key on the keypad is mapped to DECIMAL instead of `.'

\(fn SETUP &optional NUMLOCK SHIFT DECIMAL)" nil nil)

;;;***

;;;### (autoloads nil "kinsoku" "international/kinsoku.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from international/kinsoku.el

(autoload 'kinsoku "kinsoku" "\
Go to a line breaking position near point by doing `kinsoku' processing.
LINEBEG is a buffer position we can't break a line before.

`Kinsoku' processing is to prohibit specific characters to be placed
at beginning of line or at end of line.  Characters not to be placed
at beginning and end of line have character category `>' and `<'
respectively.  This restriction is dissolved by making a line longer or
shorter.

`Kinsoku' is a Japanese word which originally means ordering to stay
in one place, and is used for the text processing described above in
the context of text formatting.

\(fn LINEBEG)" nil nil)

;;;***

;;;### (autoloads nil "kkc" "international/kkc.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from international/kkc.el

(defvar kkc-after-update-conversion-functions nil "\
Functions to run after a conversion is selected in `japanese' input method.
With this input method, a user can select a proper conversion from
candidate list.  Each time he changes the selection, functions in this
list are called with two arguments; starting and ending buffer
positions that contains the current selection.")

(autoload 'kkc-region "kkc" "\
Convert Kana string in the current region to Kanji-Kana mixed string.
Users can select a desirable conversion interactively.
When called from a program, expects two arguments,
positions FROM and TO (integers or markers) specifying the target region.
When it returns, the point is at the tail of the selected conversion,
and the return value is the length of the conversion.

\(fn FROM TO)" t nil)

;;;***

;;;### (autoloads nil "kmacro" "kmacro.el" (21710 25077 0 0))
;;; Generated autoloads from kmacro.el
 (global-set-key "\C-x(" 'kmacro-start-macro)
 (global-set-key "\C-x)" 'kmacro-end-macro)
 (global-set-key "\C-xe" 'kmacro-end-and-call-macro)
 (global-set-key [f3] 'kmacro-start-macro-or-insert-counter)
 (global-set-key [f4] 'kmacro-end-or-call-macro)
 (global-set-key "\C-x\C-k" 'kmacro-keymap)
 (autoload 'kmacro-keymap "kmacro" "Keymap for keyboard macro commands." t 'keymap)

(autoload 'kmacro-exec-ring-item "kmacro" "\
Execute item ITEM from the macro ring.
ARG is the number of times to execute the item.

\(fn ITEM ARG)" nil nil)

(autoload 'kmacro-start-macro "kmacro" "\
Record subsequent keyboard input, defining a keyboard macro.
The commands are recorded even as they are executed.
Use \\[kmacro-end-macro] to finish recording and make the macro available.
Use \\[kmacro-end-and-call-macro] to execute the macro.

Non-nil arg (prefix arg) means append to last macro defined.

With \\[universal-argument] prefix, append to last keyboard macro
defined.  Depending on `kmacro-execute-before-append', this may begin
by re-executing the last macro as if you typed it again.

Otherwise, it sets `kmacro-counter' to ARG or 0 if missing before
defining the macro.

Use \\[kmacro-insert-counter] to insert (and increment) the macro counter.
The counter value can be set or modified via \\[kmacro-set-counter] and \\[kmacro-add-counter].
The format of the counter can be modified via \\[kmacro-set-format].

Use \\[kmacro-name-last-macro] to give it a permanent name.
Use \\[kmacro-bind-to-key] to bind it to a key sequence.

\(fn ARG)" t nil)

(autoload 'kmacro-end-macro "kmacro" "\
Finish defining a keyboard macro.
The definition was started by \\[kmacro-start-macro].
The macro is now available for use via \\[kmacro-call-macro],
or it can be given a name with \\[kmacro-name-last-macro] and then invoked
under that name.

With numeric arg, repeat macro now that many times,
counting the definition just completed as the first repetition.
An argument of zero means repeat until error.

\(fn ARG)" t nil)

(autoload 'kmacro-call-macro "kmacro" "\
Call the keyboard MACRO that you defined with \\[kmacro-start-macro].
A prefix argument serves as a repeat count.  Zero means repeat until error.
MACRO defaults to `last-kbd-macro'.

When you call the macro, you can call the macro again by repeating
just the last key in the key sequence that you used to call this
command.  See `kmacro-call-repeat-key' and `kmacro-call-repeat-with-arg'
for details on how to adjust or disable this behavior.

To make a macro permanent so you can call it even after defining
others, use \\[kmacro-name-last-macro].

\(fn ARG &optional NO-REPEAT END-MACRO MACRO)" t nil)

(autoload 'kmacro-start-macro-or-insert-counter "kmacro" "\
Record subsequent keyboard input, defining a keyboard macro.
The commands are recorded even as they are executed.

Sets the `kmacro-counter' to ARG (or 0 if no prefix arg) before defining the
macro.

With \\[universal-argument], appends to current keyboard macro (keeping
the current value of `kmacro-counter').

When defining/executing macro, inserts macro counter and increments
the counter with ARG or 1 if missing.  With \\[universal-argument],
inserts previous `kmacro-counter' (but do not modify counter).

The macro counter can be modified via \\[kmacro-set-counter] and \\[kmacro-add-counter].
The format of the counter can be modified via \\[kmacro-set-format].

\(fn ARG)" t nil)

(autoload 'kmacro-end-or-call-macro "kmacro" "\
End kbd macro if currently being defined; else call last kbd macro.
With numeric prefix ARG, repeat macro that many times.
With \\[universal-argument], call second macro in macro ring.

\(fn ARG &optional NO-REPEAT)" t nil)

(autoload 'kmacro-end-and-call-macro "kmacro" "\
Call last keyboard macro, ending it first if currently being defined.
With numeric prefix ARG, repeat macro that many times.
Zero argument means repeat until there is an error.

To give a macro a permanent name, so you can call it
even after defining other macros, use \\[kmacro-name-last-macro].

\(fn ARG &optional NO-REPEAT)" t nil)

(autoload 'kmacro-end-call-mouse "kmacro" "\
Move point to the position clicked with the mouse and call last kbd macro.
If kbd macro currently being defined end it before activating it.

\(fn EVENT)" t nil)

;;;***

;;;### (autoloads nil "korea-util" "language/korea-util.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from language/korea-util.el

(defvar default-korean-keyboard (purecopy (if (string-match "3" (or (getenv "HANGUL_KEYBOARD_TYPE") "")) "3" "")) "\
The kind of Korean keyboard for Korean input method.
\"\" for 2, \"3\" for 3.")

(autoload 'setup-korean-environment-internal "korea-util" "\


\(fn)" nil nil)

;;;***

;;;### (autoloads nil "landmark" "play/landmark.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from play/landmark.el

(defalias 'landmark-repeat 'landmark-test-run)

(autoload 'landmark-test-run "landmark" "\
Run 100 Landmark games, each time saving the weights from the previous game.

\(fn)" t nil)

(autoload 'landmark "landmark" "\
Start or resume an Landmark game.
If a game is in progress, this command allows you to resume it.
Here is the relation between prefix args and game options:

prefix arg | robot is auto-started | weights are saved from last game
---------------------------------------------------------------------
none / 1   | yes                   | no
       2   | yes                   | yes
       3   | no                    | yes
       4   | no                    | no

You start by moving to a square and typing \\[landmark-start-robot],
if you did not use a prefix arg to ask for automatic start.
Use \\[describe-mode] for more info.

\(fn PARG)" t nil)

;;;***

;;;### (autoloads nil "lao-util" "language/lao-util.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from language/lao-util.el

(autoload 'lao-compose-string "lao-util" "\


\(fn STR)" nil nil)

(autoload 'lao-transcribe-single-roman-syllable-to-lao "lao-util" "\
Transcribe a Romanized Lao syllable in the region FROM and TO to Lao string.
Only the first syllable is transcribed.
The value has the form: (START END LAO-STRING), where
START and END are the beginning and end positions of the Roman Lao syllable,
LAO-STRING is the Lao character transcription of it.

Optional 3rd arg STR, if non-nil, is a string to search for Roman Lao
syllable.  In that case, FROM and TO are indexes to STR.

\(fn FROM TO &optional STR)" nil nil)

(autoload 'lao-transcribe-roman-to-lao-string "lao-util" "\
Transcribe Romanized Lao string STR to Lao character string.

\(fn STR)" nil nil)

(autoload 'lao-composition-function "lao-util" "\


\(fn GSTRING)" nil nil)

(autoload 'lao-compose-region "lao-util" "\


\(fn FROM TO)" t nil)

;;;***

;;;### (autoloads nil "latexenc" "international/latexenc.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from international/latexenc.el

(defvar latex-inputenc-coding-alist (purecopy '(("ansinew" . windows-1252) ("applemac" . mac-roman) ("ascii" . us-ascii) ("cp1250" . windows-1250) ("cp1252" . windows-1252) ("cp1257" . cp1257) ("cp437de" . cp437) ("cp437" . cp437) ("cp850" . cp850) ("cp852" . cp852) ("cp858" . cp858) ("cp865" . cp865) ("latin1" . iso-8859-1) ("latin2" . iso-8859-2) ("latin3" . iso-8859-3) ("latin4" . iso-8859-4) ("latin5" . iso-8859-5) ("latin9" . iso-8859-15) ("next" . next) ("utf8" . utf-8) ("utf8x" . utf-8))) "\
Mapping from LaTeX encodings in \"inputenc.sty\" to Emacs coding systems.
LaTeX encodings are specified with \"\\usepackage[encoding]{inputenc}\".
Used by the function `latexenc-find-file-coding-system'.")

(custom-autoload 'latex-inputenc-coding-alist "latexenc" t)

(autoload 'latexenc-inputenc-to-coding-system "latexenc" "\
Return the corresponding coding-system for the specified input encoding.
Return nil if no matching coding system can be found.

\(fn INPUTENC)" nil nil)

(autoload 'latexenc-coding-system-to-inputenc "latexenc" "\
Return the corresponding input encoding for the specified coding system.
Return nil if no matching input encoding can be found.

\(fn CS)" nil nil)

(autoload 'latexenc-find-file-coding-system "latexenc" "\
Determine the coding system of a LaTeX file if it uses \"inputenc.sty\".
The mapping from LaTeX's \"inputenc.sty\" encoding names to Emacs
coding system names is determined from `latex-inputenc-coding-alist'.

\(fn ARG-LIST)" nil nil)

;;;***

;;;### (autoloads nil "latin1-disp" "international/latin1-disp.el"
;;;;;;  (21710 25077 0 0))
;;; Generated autoloads from international/latin1-disp.el

(defvar latin1-display nil "\
Set up Latin-1/ASCII display for ISO8859 character sets.
This is done for each character set in the list `latin1-display-sets',
if no font is available to display it.  Characters are displayed using
the corresponding Latin-1 characters where they match.  Otherwise
ASCII sequences are used, mostly following the Latin prefix input
methods.  Some different ASCII sequences are used if
`latin1-display-mnemonic' is non-nil.

This option also treats some characters in the `mule-unicode-...'
charsets if you don't have a Unicode font with which to display them.

Setting this variable directly does not take effect;
use either \\[customize] or the function `latin1-display'.")

(custom-autoload 'latin1-display "latin1-disp" nil)

(autoload 'latin1-display "latin1-disp" "\
Set up Latin-1/ASCII display for the arguments character SETS.
See option `latin1-display' for the method.  The members of the list
must be in `latin1-display-sets'.  With no arguments, reset the
display for all of `latin1-display-sets'. See also
`latin1-display-setup'.

\(fn &rest SETS)" nil nil)

(defvar latin1-display-ucs-per-lynx nil "\
Set up Latin-1/ASCII display for Unicode characters.
This uses the transliterations of the Lynx browser.  The display isn't
changed if the display can render Unicode characters.

Setting this variable directly does not take effect;
use either \\[customize] or the function `latin1-display'.")

(custom-autoload 'latin1-display-ucs-per-lynx "latin1-disp" nil)

;;;***

;;;### (autoloads nil "ld-script" "progmodes/ld-script.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from progmodes/ld-script.el

(autoload 'ld-script-mode "ld-script" "\
A major mode to edit GNU ld script files

\(fn)" t nil)

;;;***

;;;### (autoloads nil "life" "play/life.el" (21710 25077 0 0))
;;; Generated autoloads from play/life.el

(autoload 'life "life" "\
Run Conway's Life simulation.
The starting pattern is randomly selected.  Prefix arg (optional first
arg non-nil from a program) is the number of seconds to sleep between
generations (this defaults to 1).

\(fn &optional SLEEPTIME)" t nil)

;;;***

;;;### (autoloads nil "linum" "linum.el" (21788 61018 0 0))
;;; Generated autoloads from linum.el
(push (purecopy '(linum 0 9 24)) package--builtin-versions)

(autoload 'linum-mode "linum" "\
Toggle display of line numbers in the left margin (Linum mode).
With a prefix argument ARG, enable Linum mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

Linum mode is a buffer-local minor mode.

\(fn &optional ARG)" t nil)

(defvar global-linum-mode nil "\
Non-nil if Global-Linum mode is enabled.
See the command `global-linum-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-linum-mode'.")

(custom-autoload 'global-linum-mode "linum" nil)

(autoload 'global-linum-mode "linum" "\
Toggle Linum mode in all buffers.
With prefix ARG, enable Global-Linum mode if ARG is positive;
otherwise, disable it.  If called from Lisp, enable the mode if
ARG is omitted or nil.

Linum mode is enabled in all buffers where
`linum-on' would do it.
See `linum-mode' for more information on Linum mode.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "loadhist" "loadhist.el" (21710 25077 0 0))
;;; Generated autoloads from loadhist.el

(autoload 'unload-feature "loadhist" "\
Unload the library that provided FEATURE.
If the feature is required by any other loaded code, and prefix arg FORCE
is nil, raise an error.

Standard unloading activities include restoring old autoloads for
functions defined by the library, undoing any additions that the
library has made to hook variables or to `auto-mode-alist', undoing
ELP profiling of functions in that library, unproviding any features
provided by the library, and canceling timers held in variables
defined by the library.

If a function `FEATURE-unload-function' is defined, this function
calls it with no arguments, before doing anything else.  That function
can do whatever is appropriate to undo the loading of the library.  If
`FEATURE-unload-function' returns non-nil, that suppresses the
standard unloading of the library.  Otherwise the standard unloading
proceeds.

`FEATURE-unload-function' has access to the package's list of
definitions in the variable `unload-function-defs-list' and could
remove symbols from it in the event that the package has done
something strange, such as redefining an Emacs function.

\(fn FEATURE &optional FORCE)" t nil)

;;;***

;;;### (autoloads nil "locate" "locate.el" (21710 25077 0 0))
;;; Generated autoloads from locate.el

(defvar locate-ls-subdir-switches (purecopy "-al") "\
`ls' switches for inserting subdirectories in `*Locate*' buffers.
This should contain the \"-l\" switch, but not the \"-F\" or \"-b\" switches.")

(custom-autoload 'locate-ls-subdir-switches "locate" t)

(autoload 'locate "locate" "\
Run the program `locate', putting results in `*Locate*' buffer.
Pass it SEARCH-STRING as argument.  Interactively, prompt for SEARCH-STRING.
With prefix arg ARG, prompt for the exact shell command to run instead.

This program searches for those file names in a database that match
SEARCH-STRING and normally outputs all matching absolute file names,
one per line.  The database normally consists of all files on your
system, or of all files that you have access to.  Consult the
documentation of the program for the details about how it determines
which file names match SEARCH-STRING.  (Those details vary highly with
the version.)

You can specify another program for this command to run by customizing
the variables `locate-command' or `locate-make-command-line'.

The main use of FILTER is to implement `locate-with-filter'.  See
the docstring of that function for its meaning.

After preparing the results buffer, this runs `dired-mode-hook' and
then `locate-post-command-hook'.

\(fn SEARCH-STRING &optional FILTER ARG)" t nil)

(autoload 'locate-with-filter "locate" "\
Run the executable program `locate' with a filter.
This function is similar to the function `locate', which see.
The difference is that, when invoked interactively, the present function
prompts for both SEARCH-STRING and FILTER.  It passes SEARCH-STRING
to the locate executable program.  It produces a `*Locate*' buffer
that lists only those lines in the output of the locate program that
contain a match for the regular expression FILTER; this is often useful
to constrain a big search.

ARG is the interactive prefix arg, which has the same effect as in `locate'.

When called from Lisp, this function is identical with `locate',
except that FILTER is not optional.

\(fn SEARCH-STRING FILTER &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "log-edit" "vc/log-edit.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from vc/log-edit.el

(autoload 'log-edit "log-edit" "\
Setup a buffer to enter a log message.
The buffer is put in mode MODE or `log-edit-mode' if MODE is nil.
\\<log-edit-mode-map>
If SETUP is non-nil, erase the buffer and run `log-edit-hook'.
Set mark and point around the entire contents of the buffer, so
that it is easy to kill the contents of the buffer with
\\[kill-region].  Once the user is done editing the message,
invoking the command \\[log-edit-done] (`log-edit-done') will
call CALLBACK to do the actual commit.

PARAMS if non-nil is an alist of variables and buffer-local
values to give them in the Log Edit buffer.  Possible keys and
associated values:
 `log-edit-listfun' -- function taking no arguments that returns the list of
 files that are concerned by the current operation (using relative names);
 `log-edit-diff-function' -- function taking no arguments that
 displays a diff of the files concerned by the current operation.
 `vc-log-fileset' -- the VC fileset to be committed (if any).

If BUFFER is non-nil `log-edit' will jump to that buffer, use it
to edit the log message and go back to the current buffer when
done.  Otherwise, it uses the current buffer.

\(fn CALLBACK &optional SETUP PARAMS BUFFER MODE &rest IGNORE)" nil nil)

;;;***

;;;### (autoloads nil "log-view" "vc/log-view.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from vc/log-view.el

(autoload 'log-view-mode "log-view" "\
Major mode for browsing CVS log output.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "lpr" "lpr.el" (21710 25077 0 0))
;;; Generated autoloads from lpr.el

(defvar lpr-windows-system (memq system-type '(ms-dos windows-nt)) "\
Non-nil if running on MS-DOS or MS Windows.")

(defvar lpr-lp-system (memq system-type '(usg-unix-v hpux irix)) "\
Non-nil if running on a system type that uses the \"lp\" command.")

(defvar printer-name (and (eq system-type 'ms-dos) "PRN") "\
The name of a local printer to which data is sent for printing.
\(Note that PostScript files are sent to `ps-printer-name', which see.)

On Unix-like systems, a string value should be a name understood by
lpr's -P option; otherwise the value should be nil.

On MS-DOS and MS-Windows systems, a string value is taken as the name of
a printer device or port, provided `lpr-command' is set to \"\".
Typical non-default settings would be \"LPT1\" to \"LPT3\" for parallel
printers, or \"COM1\" to \"COM4\" or \"AUX\" for serial printers, or
\"//hostname/printer\" for a shared network printer.  You can also set
it to the name of a file, in which case the output gets appended to that
file.  If you want to discard the printed output, set this to \"NUL\".")

(custom-autoload 'printer-name "lpr" t)

(defvar lpr-switches nil "\
List of strings to pass as extra options for the printer program.
It is recommended to set `printer-name' instead of including an explicit
switch on this list.
See `lpr-command'.")

(custom-autoload 'lpr-switches "lpr" t)

(defvar lpr-command (purecopy (cond (lpr-windows-system "") (lpr-lp-system "lp") (t "lpr"))) "\
Name of program for printing a file.

On MS-DOS and MS-Windows systems, if the value is an empty string then
Emacs will write directly to the printer port named by `printer-name'.
The programs `print' and `nprint' (the standard print programs on
Windows NT and Novell Netware respectively) are handled specially, using
`printer-name' as the destination for output; any other program is
treated like `lpr' except that an explicit filename is given as the last
argument.")

(custom-autoload 'lpr-command "lpr" t)

(autoload 'lpr-buffer "lpr" "\
Print buffer contents without pagination or page headers.
See the variables `lpr-switches' and `lpr-command'
for customization of the printer command.

\(fn)" t nil)

(autoload 'print-buffer "lpr" "\
Paginate and print buffer contents.

The variable `lpr-headers-switches' controls how to paginate.
If it is nil (the default), we run the `pr' program (or whatever program
`lpr-page-header-program' specifies) to paginate.
`lpr-page-header-switches' specifies the switches for that program.

Otherwise, the switches in `lpr-headers-switches' are used
in the print command itself; we expect them to request pagination.

See the variables `lpr-switches' and `lpr-command'
for further customization of the printer command.

\(fn)" t nil)

(autoload 'lpr-region "lpr" "\
Print region contents without pagination or page headers.
See the variables `lpr-switches' and `lpr-command'
for customization of the printer command.

\(fn START END)" t nil)

(autoload 'print-region "lpr" "\
Paginate and print the region contents.

The variable `lpr-headers-switches' controls how to paginate.
If it is nil (the default), we run the `pr' program (or whatever program
`lpr-page-header-program' specifies) to paginate.
`lpr-page-header-switches' specifies the switches for that program.

Otherwise, the switches in `lpr-headers-switches' are used
in the print command itself; we expect them to request pagination.

See the variables `lpr-switches' and `lpr-command'
for further customization of the printer command.

\(fn START END)" t nil)

;;;***

;;;### (autoloads nil "ls-lisp" "ls-lisp.el" (21788 61018 0 0))
;;; Generated autoloads from ls-lisp.el

(defvar ls-lisp-support-shell-wildcards t "\
Non-nil means ls-lisp treats file patterns as shell wildcards.
Otherwise they are treated as Emacs regexps (for backward compatibility).")

(custom-autoload 'ls-lisp-support-shell-wildcards "ls-lisp" t)

;;;***

;;;### (autoloads nil "lunar" "calendar/lunar.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from calendar/lunar.el

(autoload 'lunar-phases "lunar" "\
Display the quarters of the moon for last month, this month, and next month.
If called with an optional prefix argument ARG, prompts for month and year.
This function is suitable for execution in an init file.

\(fn &optional ARG)" t nil)

(define-obsolete-function-alias 'phases-of-moon 'lunar-phases "23.1")

;;;***

;;;### (autoloads nil "m4-mode" "progmodes/m4-mode.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/m4-mode.el

(autoload 'm4-mode "m4-mode" "\
A major mode to edit m4 macro files.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "macros" "macros.el" (21710 25077 0 0))
;;; Generated autoloads from macros.el

(autoload 'name-last-kbd-macro "macros" "\
Assign a name to the last keyboard macro defined.
Argument SYMBOL is the name to define.
The symbol's function definition becomes the keyboard macro string.
Such a \"function\" cannot be called from Lisp, but it is a valid editor command.

\(fn SYMBOL)" t nil)

(autoload 'insert-kbd-macro "macros" "\
Insert in buffer the definition of kbd macro MACRONAME, as Lisp code.
MACRONAME should be a symbol.
Optional second arg KEYS means also record the keys it is on
\(this is the prefix argument, when calling interactively).

This Lisp code will, when executed, define the kbd macro with the same
definition it has now.  If you say to record the keys, the Lisp code
will also rebind those keys to the macro.  Only global key bindings
are recorded since executing this Lisp code always makes global
bindings.

To save a kbd macro, visit a file of Lisp code such as your `~/.emacs',
use this command, and then save the file.

\(fn MACRONAME &optional KEYS)" t nil)

(autoload 'kbd-macro-query "macros" "\
Query user during kbd macro execution.
  With prefix argument, enters recursive edit, reading keyboard
commands even within a kbd macro.  You can give different commands
each time the macro executes.
  Without prefix argument, asks whether to continue running the macro.
Your options are: \\<query-replace-map>
\\[act]	Finish this iteration normally and continue with the next.
\\[skip]	Skip the rest of this iteration, and start the next.
\\[exit]	Stop the macro entirely right now.
\\[recenter]	Redisplay the screen, then ask again.
\\[edit]	Enter recursive edit; ask again when you exit from that.

\(fn FLAG)" t nil)

(autoload 'apply-macro-to-region-lines "macros" "\
Apply last keyboard macro to all lines in the region.
For each line that begins in the region, move to the beginning of
the line, and run the last keyboard macro.

When called from lisp, this function takes two arguments TOP and
BOTTOM, describing the current region.  TOP must be before BOTTOM.
The optional third argument MACRO specifies a keyboard macro to
execute.

This is useful for quoting or unquoting included text, adding and
removing comments, or producing tables where the entries are regular.

For example, in Usenet articles, sections of text quoted from another
author are indented, or have each line start with `>'.  To quote a
section of text, define a keyboard macro which inserts `>', put point
and mark at opposite ends of the quoted section, and use
`\\[apply-macro-to-region-lines]' to mark the entire section.

Suppose you wanted to build a keyword table in C where each entry
looked like this:

    { \"foo\", foo_data, foo_function },
    { \"bar\", bar_data, bar_function },
    { \"baz\", baz_data, baz_function },

You could enter the names in this format:

    foo
    bar
    baz

and write a macro to massage a word into a table entry:

    \\C-x (
       \\M-d { \"\\C-y\", \\C-y_data, \\C-y_function },
    \\C-x )

and then select the region of un-tablified names and use
`\\[apply-macro-to-region-lines]' to build the table from the names.

\(fn TOP BOTTOM &optional MACRO)" t nil)
 (define-key ctl-x-map "q" 'kbd-macro-query)

;;;***

;;;### (autoloads nil "mail-extr" "mail/mail-extr.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/mail-extr.el

(autoload 'mail-extract-address-components "mail-extr" "\
Given an RFC-822 address ADDRESS, extract full name and canonical address.
Returns a list of the form (FULL-NAME CANONICAL-ADDRESS).  If no
name can be extracted, FULL-NAME will be nil.  Also see
`mail-extr-ignore-single-names' and
`mail-extr-ignore-realname-equals-mailbox-name'.

If the optional argument ALL is non-nil, then ADDRESS can contain zero
or more recipients, separated by commas, and we return a list of
the form ((FULL-NAME CANONICAL-ADDRESS) ...) with one element for
each recipient.  If ALL is nil, then if ADDRESS contains more than
one recipients, all but the first is ignored.

ADDRESS may be a string or a buffer.  If it is a buffer, the visible
\(narrowed) portion of the buffer will be interpreted as the address.
\(This feature exists so that the clever caller might be able to avoid
consing a string.)

\(fn ADDRESS &optional ALL)" nil nil)

(autoload 'what-domain "mail-extr" "\
Convert mail domain DOMAIN to the country it corresponds to.

\(fn DOMAIN)" t nil)

;;;***

;;;### (autoloads nil "mail-hist" "mail/mail-hist.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/mail-hist.el

(autoload 'mail-hist-define-keys "mail-hist" "\
Define keys for accessing mail header history.  For use in hooks.

\(fn)" nil nil)

(autoload 'mail-hist-enable "mail-hist" "\


\(fn)" nil nil)

(defvar mail-hist-keep-history t "\
Non-nil means keep a history for headers and text of outgoing mail.")

(custom-autoload 'mail-hist-keep-history "mail-hist" t)

(autoload 'mail-hist-put-headers-into-history "mail-hist" "\
Put headers and contents of this message into mail header history.
Each header has its own independent history, as does the body of the
message.

This function normally would be called when the message is sent.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "mail-utils" "mail/mail-utils.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/mail-utils.el

(defvar mail-use-rfc822 nil "\
If non-nil, use a full, hairy RFC822 parser on mail addresses.
Otherwise, (the default) use a smaller, somewhat faster, and
often correct parser.")

(custom-autoload 'mail-use-rfc822 "mail-utils" t)

(defvar mail-dont-reply-to-names nil "\
Regexp specifying addresses to prune from a reply message.
If this is nil, it is set the first time you compose a reply, to
a value which excludes your own email address.

Matching addresses are excluded from the CC field in replies, and
also the To field, unless this would leave an empty To field.")

(custom-autoload 'mail-dont-reply-to-names "mail-utils" t)

(autoload 'mail-file-babyl-p "mail-utils" "\
Return non-nil if FILE is a Babyl file.

\(fn FILE)" nil nil)

(autoload 'mail-quote-printable "mail-utils" "\
Convert a string to the \"quoted printable\" Q encoding if necessary.
If the string contains only ASCII characters and no troublesome ones,
we return it unconverted.

If the optional argument WRAPPER is non-nil,
we add the wrapper characters =?ISO-8859-1?Q?....?=.

\(fn STRING &optional WRAPPER)" nil nil)

(autoload 'mail-quote-printable-region "mail-utils" "\
Convert the region to the \"quoted printable\" Q encoding.
If the optional argument WRAPPER is non-nil,
we add the wrapper characters =?ISO-8859-1?Q?....?=.

\(fn BEG END &optional WRAPPER)" t nil)

(autoload 'mail-unquote-printable "mail-utils" "\
Undo the \"quoted printable\" encoding.
If the optional argument WRAPPER is non-nil,
we expect to find and remove the wrapper characters =?ISO-8859-1?Q?....?=.

\(fn STRING &optional WRAPPER)" nil nil)

(autoload 'mail-unquote-printable-region "mail-utils" "\
Undo the \"quoted printable\" encoding in buffer from BEG to END.
If the optional argument WRAPPER is non-nil,
we expect to find and remove the wrapper characters =?ISO-8859-1?Q?....?=.
On encountering malformed quoted-printable text, exits with an error,
unless NOERROR is non-nil, in which case it continues, and returns nil
when finished.  Returns non-nil on successful completion.
If UNIBYTE is non-nil, insert converted characters as unibyte.
That is useful if you are going to character code decoding afterward,
as Rmail does.

\(fn BEG END &optional WRAPPER NOERROR UNIBYTE)" t nil)

(autoload 'mail-fetch-field "mail-utils" "\
Return the value of the header field whose type is FIELD-NAME.
If second arg LAST is non-nil, use the last field of type FIELD-NAME.
If third arg ALL is non-nil, concatenate all such fields with commas between.
If 4th arg LIST is non-nil, return a list of all such fields.
The buffer should be narrowed to just the header, else false
matches may be returned from the message body.

\(fn FIELD-NAME &optional LAST ALL LIST)" nil nil)

;;;***

;;;### (autoloads nil "mailabbrev" "mail/mailabbrev.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/mailabbrev.el

(defvar mail-abbrevs-mode nil "\
Non-nil if Mail-Abbrevs mode is enabled.
See the command `mail-abbrevs-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `mail-abbrevs-mode'.")

(custom-autoload 'mail-abbrevs-mode "mailabbrev" nil)

(autoload 'mail-abbrevs-mode "mailabbrev" "\
Toggle abbrev expansion of mail aliases (Mail Abbrevs mode).
With a prefix argument ARG, enable Mail Abbrevs mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Mail Abbrevs mode is a global minor mode.  When enabled,
abbrev-like expansion is performed when editing certain mail
headers (those specified by `mail-abbrev-mode-regexp'), based on
the entries in your `mail-personal-alias-file'.

\(fn &optional ARG)" t nil)

(autoload 'mail-abbrevs-setup "mailabbrev" "\
Initialize use of the `mailabbrev' package.

\(fn)" nil nil)

(autoload 'build-mail-abbrevs "mailabbrev" "\
Read mail aliases from personal mail alias file and set `mail-abbrevs'.
By default this is the file specified by `mail-personal-alias-file'.

\(fn &optional FILE RECURSIVEP)" nil nil)

(autoload 'define-mail-abbrev "mailabbrev" "\
Define NAME as a mail alias abbrev that translates to DEFINITION.
If DEFINITION contains multiple addresses, separate them with commas.

Optional argument FROM-MAILRC-FILE means that DEFINITION comes
from a mailrc file.  In that case, addresses are separated with
spaces and addresses with embedded spaces are surrounded by
double-quotes.

\(fn NAME DEFINITION &optional FROM-MAILRC-FILE)" t nil)

;;;***

;;;### (autoloads nil "mailalias" "mail/mailalias.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/mailalias.el

(defvar mail-complete-style 'angles "\
Specifies how \\[mail-complete] formats the full name when it completes.
If `nil', they contain just the return address like:
	king@grassland.com
If `parens', they look like:
	king@grassland.com (Elvis Parsley)
If `angles', they look like:
	Elvis Parsley <king@grassland.com>")

(custom-autoload 'mail-complete-style "mailalias" t)

(autoload 'expand-mail-aliases "mailalias" "\
Expand all mail aliases in suitable header fields found between BEG and END.
If interactive, expand in header fields.
Suitable header fields are `To', `From', `CC' and `BCC', `Reply-to', and
their `Resent-' variants.

Optional second arg EXCLUDE may be a regular expression defining text to be
removed from alias expansions.

\(fn BEG END &optional EXCLUDE)" t nil)

(autoload 'define-mail-alias "mailalias" "\
Define NAME as a mail alias that translates to DEFINITION.
This means that sending a message to NAME will actually send to DEFINITION.

Normally, the addresses in DEFINITION must be separated by commas.
If FROM-MAILRC-FILE is non-nil, then addresses in DEFINITION
can be separated by spaces; an address can contain spaces
if it is quoted with double-quotes.

\(fn NAME DEFINITION &optional FROM-MAILRC-FILE)" t nil)

(autoload 'mail-completion-at-point-function "mailalias" "\
Compute completion data for mail aliases.
For use on `completion-at-point-functions'.

\(fn)" nil nil)

(autoload 'mail-complete "mailalias" "\
Perform completion on header field or word preceding point.
Completable headers are according to `mail-complete-alist'.  If none matches
current header, calls `mail-complete-function' and passes prefix ARG if any.

\(fn ARG)" t nil)

(make-obsolete 'mail-complete 'mail-completion-at-point-function '"24.1")

;;;***

;;;### (autoloads nil "mailclient" "mail/mailclient.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/mailclient.el

(autoload 'mailclient-send-it "mailclient" "\
Pass current buffer on to the system's mail client.
Suitable value for `send-mail-function'.
The mail client is taken to be the handler of mailto URLs.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "make-mode" "progmodes/make-mode.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from progmodes/make-mode.el

(autoload 'makefile-mode "make-mode" "\
Major mode for editing standard Makefiles.

If you are editing a file for a different make, try one of the
variants `makefile-automake-mode', `makefile-gmake-mode',
`makefile-makepp-mode', `makefile-bsdmake-mode' or,
`makefile-imake-mode'.  All but the last should be correctly
chosen based on the file name, except if it is *.mk.  This
function ends by invoking the function(s) `makefile-mode-hook'.

It is strongly recommended to use `font-lock-mode', because that
provides additional parsing information.  This is used for
example to see that a rule action `echo foo: bar' is a not rule
dependency, despite the colon.

\\{makefile-mode-map}

In the browser, use the following keys:

\\{makefile-browser-map}

Makefile mode can be configured by modifying the following variables:

`makefile-browser-buffer-name':
    Name of the macro- and target browser buffer.

`makefile-target-colon':
    The string that gets appended to all target names
    inserted by `makefile-insert-target'.
    \":\" or \"::\" are quite common values.

`makefile-macro-assign':
   The string that gets appended to all macro names
   inserted by `makefile-insert-macro'.
   The normal value should be \" = \", since this is what
   standard make expects.  However, newer makes such as dmake
   allow a larger variety of different macro assignments, so you
   might prefer to use \" += \" or \" := \" .

`makefile-tab-after-target-colon':
   If you want a TAB (instead of a space) to be appended after the
   target colon, then set this to a non-nil value.

`makefile-browser-leftmost-column':
   Number of blanks to the left of the browser selection mark.

`makefile-browser-cursor-column':
   Column in which the cursor is positioned when it moves
   up or down in the browser.

`makefile-browser-selected-mark':
   String used to mark selected entries in the browser.

`makefile-browser-unselected-mark':
   String used to mark unselected entries in the browser.

`makefile-browser-auto-advance-after-selection-p':
   If this variable is set to a non-nil value the cursor
   will automagically advance to the next line after an item
   has been selected in the browser.

`makefile-pickup-everything-picks-up-filenames-p':
   If this variable is set to a non-nil value then
   `makefile-pickup-everything' also picks up filenames as targets
   (i.e. it calls `makefile-pickup-filenames-as-targets'), otherwise
   filenames are omitted.

`makefile-cleanup-continuations':
   If this variable is set to a non-nil value then Makefile mode
   will assure that no line in the file ends with a backslash
   (the continuation character) followed by any whitespace.
   This is done by silently removing the trailing whitespace, leaving
   the backslash itself intact.
   IMPORTANT: Please note that enabling this option causes Makefile mode
   to MODIFY A FILE WITHOUT YOUR CONFIRMATION when \"it seems necessary\".

`makefile-browser-hook':
   A function or list of functions to be called just before the
   browser is entered. This is executed in the makefile buffer.

`makefile-special-targets-list':
   List of special targets. You will be offered to complete
   on one of those in the minibuffer whenever you enter a `.'.
   at the beginning of a line in Makefile mode.

\(fn)" t nil)

(autoload 'makefile-automake-mode "make-mode" "\
An adapted `makefile-mode' that knows about automake.

\(fn)" t nil)

(autoload 'makefile-gmake-mode "make-mode" "\
An adapted `makefile-mode' that knows about gmake.

\(fn)" t nil)

(autoload 'makefile-makepp-mode "make-mode" "\
An adapted `makefile-mode' that knows about makepp.

\(fn)" t nil)

(autoload 'makefile-bsdmake-mode "make-mode" "\
An adapted `makefile-mode' that knows about BSD make.

\(fn)" t nil)

(autoload 'makefile-imake-mode "make-mode" "\
An adapted `makefile-mode' that knows about imake.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "makesum" "makesum.el" (21710 25077 0 0))
;;; Generated autoloads from makesum.el

(autoload 'make-command-summary "makesum" "\
Make a summary of current key bindings in the buffer *Summary*.
Previous contents of that buffer are killed first.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "man" "man.el" (21788 61018 0 0))
;;; Generated autoloads from man.el

(defalias 'manual-entry 'man)

(autoload 'man "man" "\
Get a Un*x manual page and put it in a buffer.
This command is the top-level command in the man package.  It
runs a Un*x command to retrieve and clean a manpage in the
background and places the results in a `Man-mode' browsing
buffer.  See variable `Man-notify-method' for what happens when
the buffer is ready.  If a buffer already exists for this man
page, it will display immediately.

For a manpage from a particular section, use either of the
following.  \"cat(1)\" is how cross-references appear and is
passed to man as \"1 cat\".

    cat(1)
    1 cat

To see manpages from all sections related to a subject, use an
\"all pages\" option (which might be \"-a\" if it's not the
default), then step through with `Man-next-manpage' (\\<Man-mode-map>\\[Man-next-manpage]) etc.
Add to `Man-switches' to make this option permanent.

    -a chmod

An explicit filename can be given too.  Use -l if it might
otherwise look like a page name.

    /my/file/name.1.gz
    -l somefile.1

An \"apropos\" query with -k gives a buffer of matching page
names or descriptions.  The pattern argument is usually an
\"egrep\" style regexp.

    -k pattern

\(fn MAN-ARGS)" t nil)

(autoload 'man-follow "man" "\
Get a Un*x manual page of the item under point and put it in a buffer.

\(fn MAN-ARGS)" t nil)

(autoload 'Man-bookmark-jump "man" "\
Default bookmark handler for Man buffers.

\(fn BOOKMARK)" nil nil)

;;;***

;;;### (autoloads nil "master" "master.el" (21710 25077 0 0))
;;; Generated autoloads from master.el
(push (purecopy '(master 1 0 2)) package--builtin-versions)

(autoload 'master-mode "master" "\
Toggle Master mode.
With a prefix argument ARG, enable Master mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

When Master mode is enabled, you can scroll the slave buffer
using the following commands:

\\{master-mode-map}

The slave buffer is stored in the buffer-local variable `master-of'.
You can set this variable using `master-set-slave'.  You can show
yourself the value of `master-of' by calling `master-show-slave'.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "mb-depth" "mb-depth.el" (21710 25077 0 0))
;;; Generated autoloads from mb-depth.el

(defvar minibuffer-depth-indicate-mode nil "\
Non-nil if Minibuffer-Depth-Indicate mode is enabled.
See the command `minibuffer-depth-indicate-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `minibuffer-depth-indicate-mode'.")

(custom-autoload 'minibuffer-depth-indicate-mode "mb-depth" nil)

(autoload 'minibuffer-depth-indicate-mode "mb-depth" "\
Toggle Minibuffer Depth Indication mode.
With a prefix argument ARG, enable Minibuffer Depth Indication
mode if ARG is positive, and disable it otherwise.  If called
from Lisp, enable the mode if ARG is omitted or nil.

Minibuffer Depth Indication mode is a global minor mode.  When
enabled, any recursive use of the minibuffer will show the
recursion depth in the minibuffer prompt.  This is only useful if
`enable-recursive-minibuffers' is non-nil.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "md4" "md4.el" (21710 25077 0 0))
;;; Generated autoloads from md4.el
(push (purecopy '(md4 1 0)) package--builtin-versions)

;;;***

;;;### (autoloads nil "message" "gnus/message.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from gnus/message.el

(define-mail-user-agent 'message-user-agent 'message-mail 'message-send-and-exit 'message-kill-buffer 'message-send-hook)

(autoload 'message-mode "message" "\
Major mode for editing mail and news to be sent.
Like Text Mode but with these additional commands:\\<message-mode-map>
C-c C-s  `message-send' (send the message)  C-c C-c  `message-send-and-exit'
C-c C-d  Postpone sending the message       C-c C-k  Kill the message
C-c C-f  move to a header field (and create it if there isn't):
	 C-c C-f C-t  move to To	C-c C-f C-s  move to Subject
	 C-c C-f C-c  move to Cc	C-c C-f C-b  move to Bcc
	 C-c C-f C-w  move to Fcc	C-c C-f C-r  move to Reply-To
	 C-c C-f C-u  move to Summary	C-c C-f C-n  move to Newsgroups
	 C-c C-f C-k  move to Keywords	C-c C-f C-d  move to Distribution
	 C-c C-f C-o  move to From (\"Originator\")
	 C-c C-f C-f  move to Followup-To
	 C-c C-f C-m  move to Mail-Followup-To
	 C-c C-f C-e  move to Expires
	 C-c C-f C-i  cycle through Importance values
	 C-c C-f s    change subject and append \"(was: <Old Subject>)\"
	 C-c C-f x    crossposting with FollowUp-To header and note in body
	 C-c C-f t    replace To: header with contents of Cc: or Bcc:
	 C-c C-f a    Insert X-No-Archive: header and a note in the body
C-c C-t  `message-insert-to' (add a To header to a news followup)
C-c C-l  `message-to-list-only' (removes all but list address in to/cc)
C-c C-n  `message-insert-newsgroups' (add a Newsgroup header to a news reply)
C-c C-b  `message-goto-body' (move to beginning of message text).
C-c C-i  `message-goto-signature' (move to the beginning of the signature).
C-c C-w  `message-insert-signature' (insert `message-signature-file' file).
C-c C-y  `message-yank-original' (insert current message, if any).
C-c C-q  `message-fill-yanked-message' (fill what was yanked).
C-c C-e  `message-elide-region' (elide the text between point and mark).
C-c C-v  `message-delete-not-region' (remove the text outside the region).
C-c C-z  `message-kill-to-signature' (kill the text up to the signature).
C-c C-r  `message-caesar-buffer-body' (rot13 the message body).
C-c C-a  `mml-attach-file' (attach a file as MIME).
C-c C-u  `message-insert-or-toggle-importance'  (insert or cycle importance).
C-c M-n  `message-insert-disposition-notification-to'  (request receipt).
C-c M-m  `message-mark-inserted-region' (mark region with enclosing tags).
C-c M-f  `message-mark-insert-file' (insert file marked with enclosing tags).
M-RET    `message-newline-and-reformat' (break the line and reformat).

\(fn)" t nil)

(autoload 'message-mail "message" "\
Start editing a mail message to be sent.
OTHER-HEADERS is an alist of header/value pairs.  CONTINUE says whether
to continue editing a message already being composed.  SWITCH-FUNCTION
is a function used to switch to and display the mail buffer.

\(fn &optional TO SUBJECT OTHER-HEADERS CONTINUE SWITCH-FUNCTION YANK-ACTION SEND-ACTIONS RETURN-ACTION &rest IGNORED)" t nil)

(autoload 'message-news "message" "\
Start editing a news article to be sent.

\(fn &optional NEWSGROUPS SUBJECT)" t nil)

(autoload 'message-reply "message" "\
Start editing a reply to the article in the current buffer.

\(fn &optional TO-ADDRESS WIDE SWITCH-FUNCTION)" t nil)

(autoload 'message-wide-reply "message" "\
Make a \"wide\" reply to the message in the current buffer.

\(fn &optional TO-ADDRESS)" t nil)

(autoload 'message-followup "message" "\
Follow up to the message in the current buffer.
If TO-NEWSGROUPS, use that as the new Newsgroups line.

\(fn &optional TO-NEWSGROUPS)" t nil)

(autoload 'message-cancel-news "message" "\
Cancel an article you posted.
If ARG, allow editing of the cancellation message.

\(fn &optional ARG)" t nil)

(autoload 'message-supersede "message" "\
Start composing a message to supersede the current message.
This is done simply by taking the old article and adding a Supersedes
header line with the old Message-ID.

\(fn)" t nil)

(autoload 'message-recover "message" "\
Reread contents of current buffer from its last auto-save file.

\(fn)" t nil)

(autoload 'message-forward "message" "\
Forward the current message via mail.
Optional NEWS will use news to forward instead of mail.
Optional DIGEST will use digest to forward.

\(fn &optional NEWS DIGEST)" t nil)

(autoload 'message-forward-make-body "message" "\


\(fn FORWARD-BUFFER &optional DIGEST)" nil nil)

(autoload 'message-forward-rmail-make-body "message" "\


\(fn FORWARD-BUFFER)" nil nil)

(autoload 'message-insinuate-rmail "message" "\
Let RMAIL use message to forward.

\(fn)" t nil)

(autoload 'message-resend "message" "\
Resend the current article to ADDRESS.

\(fn ADDRESS)" t nil)

(autoload 'message-bounce "message" "\
Re-mail the current message.
This only makes sense if the current message is a bounce message that
contains some mail you have written which has been bounced back to
you.

\(fn)" t nil)

(autoload 'message-mail-other-window "message" "\
Like `message-mail' command, but display mail buffer in another window.

\(fn &optional TO SUBJECT)" t nil)

(autoload 'message-mail-other-frame "message" "\
Like `message-mail' command, but display mail buffer in another frame.

\(fn &optional TO SUBJECT)" t nil)

(autoload 'message-news-other-window "message" "\
Start editing a news article to be sent.

\(fn &optional NEWSGROUPS SUBJECT)" t nil)

(autoload 'message-news-other-frame "message" "\
Start editing a news article to be sent.

\(fn &optional NEWSGROUPS SUBJECT)" t nil)

(autoload 'message-bold-region "message" "\
Bold all nonblank characters in the region.
Works by overstriking characters.
Called from program, takes two arguments START and END
which specify the range to operate on.

\(fn START END)" t nil)

(autoload 'message-unbold-region "message" "\
Remove all boldness (overstruck characters) in the region.
Called from program, takes two arguments START and END
which specify the range to operate on.

\(fn START END)" t nil)

;;;***

;;;### (autoloads nil "meta-mode" "progmodes/meta-mode.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from progmodes/meta-mode.el
(push (purecopy '(meta-mode 1 0)) package--builtin-versions)

(autoload 'metafont-mode "meta-mode" "\
Major mode for editing Metafont sources.

\(fn)" t nil)

(autoload 'metapost-mode "meta-mode" "\
Major mode for editing MetaPost sources.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "metamail" "mail/metamail.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/metamail.el

(autoload 'metamail-interpret-header "metamail" "\
Interpret a header part of a MIME message in current buffer.
Its body part is not interpreted at all.

\(fn)" t nil)

(autoload 'metamail-interpret-body "metamail" "\
Interpret a body part of a MIME message in current buffer.
Optional argument VIEWMODE specifies the value of the
EMACS_VIEW_MODE environment variable (defaulted to 1).
Optional argument NODISPLAY non-nil means buffer is not
redisplayed as output is inserted.
Its header part is not interpreted at all.

\(fn &optional VIEWMODE NODISPLAY)" t nil)

(autoload 'metamail-buffer "metamail" "\
Process current buffer through `metamail'.
Optional argument VIEWMODE specifies the value of the
EMACS_VIEW_MODE environment variable (defaulted to 1).
Optional argument BUFFER specifies a buffer to be filled (nil
means current).
Optional argument NODISPLAY non-nil means buffer is not
redisplayed as output is inserted.

\(fn &optional VIEWMODE BUFFER NODISPLAY)" t nil)

(autoload 'metamail-region "metamail" "\
Process current region through 'metamail'.
Optional argument VIEWMODE specifies the value of the
EMACS_VIEW_MODE environment variable (defaulted to 1).
Optional argument BUFFER specifies a buffer to be filled (nil
means current).
Optional argument NODISPLAY non-nil means buffer is not
redisplayed as output is inserted.

\(fn BEG END &optional VIEWMODE BUFFER NODISPLAY)" t nil)

;;;***

;;;### (autoloads nil "mh-comp" "mh-e/mh-comp.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from mh-e/mh-comp.el

(autoload 'mh-smail "mh-comp" "\
Compose a message with the MH mail system.
See `mh-send' for more details on composing mail.

\(fn)" t nil)

(autoload 'mh-smail-other-window "mh-comp" "\
Compose a message with the MH mail system in other window.
See `mh-send' for more details on composing mail.

\(fn)" t nil)

(autoload 'mh-smail-batch "mh-comp" "\
Compose a message with the MH mail system.

This function does not prompt the user for any header fields, and
thus is suitable for use by programs that want to create a mail
buffer. Users should use \\[mh-smail] to compose mail.

Optional arguments for setting certain fields include TO,
SUBJECT, and OTHER-HEADERS. Additional arguments are IGNORED.

This function remains for Emacs 21 compatibility. New
applications should use `mh-user-agent-compose'.

\(fn &optional TO SUBJECT OTHER-HEADERS &rest IGNORED)" nil nil)

(define-mail-user-agent 'mh-e-user-agent 'mh-user-agent-compose 'mh-send-letter 'mh-fully-kill-draft 'mh-before-send-letter-hook)

(autoload 'mh-user-agent-compose "mh-comp" "\
Set up mail composition draft with the MH mail system.
This is the `mail-user-agent' entry point to MH-E. This function
conforms to the contract specified by `define-mail-user-agent'
which means that this function should accept the same arguments
as `compose-mail'.

The optional arguments TO and SUBJECT specify recipients and the
initial Subject field, respectively.

OTHER-HEADERS is an alist specifying additional header fields.
Elements look like (HEADER . VALUE) where both HEADER and VALUE
are strings.

CONTINUE, SWITCH-FUNCTION, YANK-ACTION, SEND-ACTIONS, and
RETURN-ACTION and any additional arguments are IGNORED.

\(fn &optional TO SUBJECT OTHER-HEADERS CONTINUE SWITCH-FUNCTION YANK-ACTION SEND-ACTIONS RETURN-ACTION &rest IGNORED)" nil nil)

(autoload 'mh-send-letter "mh-comp" "\
Save draft and send message.

When you are all through editing a message, you send it with this
command. You can give a prefix argument ARG to monitor the first stage
of the delivery; this output can be found in a buffer called \"*MH-E
Mail Delivery*\".

The hook `mh-before-send-letter-hook' is run at the beginning of
this command. For example, if you want to check your spelling in
your message before sending, add the function `ispell-message'.

Unless `mh-insert-auto-fields' had previously been called
manually, the function `mh-insert-auto-fields' is called to
insert fields based upon the recipients. If fields are added, you
are given a chance to see and to confirm these fields before the
message is actually sent. You can do away with this confirmation
by turning off the option `mh-auto-fields-prompt-flag'.

In case the MH \"send\" program is installed under a different name,
use `mh-send-prog' to tell MH-E the name.

The hook `mh-annotate-msg-hook' is run after annotating the
message and scan line.

\(fn &optional ARG)" t nil)

(autoload 'mh-fully-kill-draft "mh-comp" "\
Quit editing and delete draft message.

If for some reason you are not happy with the draft, you can use
this command to kill the draft buffer and delete the draft
message. Use the command \\[kill-buffer] if you don't want to
delete the draft message.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "mh-e" "mh-e/mh-e.el" (21788 61018 0 0))
;;; Generated autoloads from mh-e/mh-e.el
(push (purecopy '(mh-e 8 6)) package--builtin-versions)

(put 'mh-progs 'risky-local-variable t)

(put 'mh-lib 'risky-local-variable t)

(put 'mh-lib-progs 'risky-local-variable t)

(autoload 'mh-version "mh-e" "\
Display version information about MH-E and the MH mail handling system.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "mh-folder" "mh-e/mh-folder.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mh-e/mh-folder.el

(autoload 'mh-rmail "mh-folder" "\
Incorporate new mail with MH.
Scan an MH folder if ARG is non-nil.

This function is an entry point to MH-E, the Emacs interface to
the MH mail system.

\(fn &optional ARG)" t nil)

(autoload 'mh-nmail "mh-folder" "\
Check for new mail in inbox folder.
Scan an MH folder if ARG is non-nil.

This function is an entry point to MH-E, the Emacs interface to
the MH mail system.

\(fn &optional ARG)" t nil)

(autoload 'mh-folder-mode "mh-folder" "\
Major MH-E mode for \"editing\" an MH folder scan listing.\\<mh-folder-mode-map>

You can show the message the cursor is pointing to, and step through
the messages. Messages can be marked for deletion or refiling into
another folder; these commands are executed all at once with a
separate command.

Options that control this mode can be changed with
\\[customize-group]; specify the \"mh\" group. In particular, please
see the `mh-scan-format-file' option if you wish to modify scan's
format.

When a folder is visited, the hook `mh-folder-mode-hook' is run.

Ranges
======
Many commands that operate on individual messages, such as
`mh-forward' or `mh-refile-msg' take a RANGE argument. This argument
can be used in several ways.

If you provide the prefix argument (\\[universal-argument]) to
these commands, then you will be prompted for the message range.
This can be any valid MH range which can include messages,
sequences, and the abbreviations (described in the mh(1) man
page):

<num1>-<num2>
    Indicates all messages in the range <num1> to <num2>, inclusive.
    The range must be nonempty.

<num>:N
<num>:+N
<num>:-N
    Up to N messages beginning with (or ending with) message num. Num
    may be any of the predefined symbols: first, prev, cur, next or
    last.

first:N
prev:N
next:N
last:N
    The first, previous, next or last messages, if they exist.

all
    All of the messages.

For example, a range that shows all of these things is `1 2 3
5-10 last:5 unseen'.

If the option `transient-mark-mode' is set to t and you set a
region in the MH-Folder buffer, then the MH-E command will
perform the operation on all messages in that region.

\\{mh-folder-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "midnight" "midnight.el" (21710 25077 0 0))
;;; Generated autoloads from midnight.el

(autoload 'clean-buffer-list "midnight" "\
Kill old buffers that have not been displayed recently.
The relevant variables are `clean-buffer-list-delay-general',
`clean-buffer-list-delay-special', `clean-buffer-list-kill-buffer-names',
`clean-buffer-list-kill-never-buffer-names',
`clean-buffer-list-kill-regexps' and
`clean-buffer-list-kill-never-regexps'.
While processing buffers, this procedure displays messages containing
the current date/time, buffer name, how many seconds ago it was
displayed (can be nil if the buffer was never displayed) and its
lifetime, i.e., its \"age\" when it will be purged.

\(fn)" t nil)

(autoload 'midnight-delay-set "midnight" "\
Modify `midnight-timer' according to `midnight-delay'.
Sets the first argument SYMB (which must be symbol `midnight-delay')
to its second argument TM.

\(fn SYMB TM)" nil nil)

;;;***

;;;### (autoloads nil "minibuf-eldef" "minibuf-eldef.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from minibuf-eldef.el

(defvar minibuffer-electric-default-mode nil "\
Non-nil if Minibuffer-Electric-Default mode is enabled.
See the command `minibuffer-electric-default-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `minibuffer-electric-default-mode'.")

(custom-autoload 'minibuffer-electric-default-mode "minibuf-eldef" nil)

(autoload 'minibuffer-electric-default-mode "minibuf-eldef" "\
Toggle Minibuffer Electric Default mode.
With a prefix argument ARG, enable Minibuffer Electric Default
mode if ARG is positive, and disable it otherwise.  If called
from Lisp, enable the mode if ARG is omitted or nil.

Minibuffer Electric Default mode is a global minor mode.  When
enabled, minibuffer prompts that show a default value only show
the default when it's applicable -- that is, when hitting RET
would yield the default value.  If the user modifies the input
such that hitting RET would enter a non-default value, the prompt
is modified to remove the default indication.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "misc" "misc.el" (21710 25077 0 0))
;;; Generated autoloads from misc.el

(autoload 'butterfly "misc" "\
Use butterflies to flip the desired bit on the drive platter.
Open hands and let the delicate wings flap once.  The disturbance
ripples outward, changing the flow of the eddy currents in the
upper atmosphere.  These cause momentary pockets of higher-pressure
air to form, which act as lenses that deflect incoming cosmic rays,
focusing them to strike the drive platter and flip the desired bit.
You can type `M-x butterfly C-M-c' to run it.  This is a permuted
variation of `C-x M-c M-butterfly' from url `http://xkcd.com/378/'.

\(fn)" t nil)

(autoload 'list-dynamic-libraries "misc" "\
Display a list of all dynamic libraries known to Emacs.
\(These are the libraries listed in `dynamic-library-alist'.)
If optional argument LOADED-ONLY-P (interactively, prefix arg)
is non-nil, only libraries already loaded are listed.
Optional argument BUFFER specifies a buffer to use, instead of
\"*Dynamic Libraries*\".
The return value is always nil.

\(fn &optional LOADED-ONLY-P BUFFER)" t nil)

;;;***

;;;### (autoloads nil "misearch" "misearch.el" (21788 61018 0 0))
;;; Generated autoloads from misearch.el
 (add-hook 'isearch-mode-hook 'multi-isearch-setup)

(defvar multi-isearch-next-buffer-function nil "\
Function to call to get the next buffer to search.

When this variable is set to a function that returns a buffer, then
after typing another \\[isearch-forward] or \\[isearch-backward] at a failing search, the search goes
to the next buffer in the series and continues searching for the
next occurrence.

This function should return the next buffer (it doesn't need to switch
to it), or nil if it can't find the next buffer (when it reaches the
end of the search space).

The first argument of this function is the current buffer where the
search is currently searching.  It defines the base buffer relative to
which this function should find the next buffer.  When the isearch
direction is backward (when option `isearch-forward' is nil), this function
should return the previous buffer to search.

If the second argument of this function WRAP is non-nil, then it
should return the first buffer in the series; and for the backward
search, it should return the last buffer in the series.")

(defvar multi-isearch-next-buffer-current-function nil "\
The currently active function to get the next buffer to search.
Initialized from `multi-isearch-next-buffer-function' when
Isearch starts.")

(defvar multi-isearch-current-buffer nil "\
The buffer where the search is currently searching.
The value is nil when the search still is in the initial buffer.")

(autoload 'multi-isearch-setup "misearch" "\
Set up isearch to search multiple buffers.
Intended to be added to `isearch-mode-hook'.

\(fn)" nil nil)

(autoload 'multi-isearch-buffers "misearch" "\
Start multi-buffer Isearch on a list of BUFFERS.
This list can contain live buffers or their names.
Interactively read buffer names to search, one by one, ended with RET.
With a prefix argument, ask for a regexp, and search in buffers
whose names match the specified regexp.

\(fn BUFFERS)" t nil)

(autoload 'multi-isearch-buffers-regexp "misearch" "\
Start multi-buffer regexp Isearch on a list of BUFFERS.
This list can contain live buffers or their names.
Interactively read buffer names to search, one by one, ended with RET.
With a prefix argument, ask for a regexp, and search in buffers
whose names match the specified regexp.

\(fn BUFFERS)" t nil)

(autoload 'multi-isearch-files "misearch" "\
Start multi-buffer Isearch on a list of FILES.
Relative file names in this list are expanded to absolute
file names using the current buffer's value of `default-directory'.
Interactively read file names to search, one by one, ended with RET.
With a prefix argument, ask for a wildcard, and search in file buffers
whose file names match the specified wildcard.

\(fn FILES)" t nil)

(autoload 'multi-isearch-files-regexp "misearch" "\
Start multi-buffer regexp Isearch on a list of FILES.
Relative file names in this list are expanded to absolute
file names using the current buffer's value of `default-directory'.
Interactively read file names to search, one by one, ended with RET.
With a prefix argument, ask for a wildcard, and search in file buffers
whose file names match the specified wildcard.

\(fn FILES)" t nil)

;;;***

;;;### (autoloads nil "mixal-mode" "progmodes/mixal-mode.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from progmodes/mixal-mode.el
(push (purecopy '(mixal-mode 0 1)) package--builtin-versions)

(autoload 'mixal-mode "mixal-mode" "\
Major mode for the mixal asm language.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "mm-encode" "gnus/mm-encode.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/mm-encode.el

(autoload 'mm-default-file-encoding "mm-encode" "\
Return a default encoding for FILE.

\(fn FILE)" nil nil)

;;;***

;;;### (autoloads nil "mm-extern" "gnus/mm-extern.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/mm-extern.el

(autoload 'mm-extern-cache-contents "mm-extern" "\
Put the external-body part of HANDLE into its cache.

\(fn HANDLE)" nil nil)

(autoload 'mm-inline-external-body "mm-extern" "\
Show the external-body part of HANDLE.
This function replaces the buffer of HANDLE with a buffer contains
the entire message.
If NO-DISPLAY is nil, display it. Otherwise, do nothing after replacing.

\(fn HANDLE &optional NO-DISPLAY)" nil nil)

;;;***

;;;### (autoloads nil "mm-partial" "gnus/mm-partial.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/mm-partial.el

(autoload 'mm-inline-partial "mm-partial" "\
Show the partial part of HANDLE.
This function replaces the buffer of HANDLE with a buffer contains
the entire message.
If NO-DISPLAY is nil, display it. Otherwise, do nothing after replacing.

\(fn HANDLE &optional NO-DISPLAY)" nil nil)

;;;***

;;;### (autoloads nil "mm-url" "gnus/mm-url.el" (21788 61018 0 0))
;;; Generated autoloads from gnus/mm-url.el

(autoload 'mm-url-insert-file-contents "mm-url" "\
Insert file contents of URL.
If `mm-url-use-external' is non-nil, use `mm-url-program'.

\(fn URL)" nil nil)

(autoload 'mm-url-insert-file-contents-external "mm-url" "\
Insert file contents of URL using `mm-url-program'.

\(fn URL)" nil nil)

;;;***

;;;### (autoloads nil "mm-uu" "gnus/mm-uu.el" (21788 61018 0 0))
;;; Generated autoloads from gnus/mm-uu.el

(autoload 'mm-uu-dissect "mm-uu" "\
Dissect the current buffer and return a list of uu handles.
The optional NOHEADER means there's no header in the buffer.
MIME-TYPE specifies a MIME type and parameters, which defaults to the
value of `mm-uu-text-plain-type'.

\(fn &optional NOHEADER MIME-TYPE)" nil nil)

(autoload 'mm-uu-dissect-text-parts "mm-uu" "\
Dissect text parts and put uu handles into HANDLE.
Assume text has been decoded if DECODED is non-nil.

\(fn HANDLE &optional DECODED)" nil nil)

;;;***

;;;### (autoloads nil "mml" "gnus/mml.el" (21788 61018 0 0))
;;; Generated autoloads from gnus/mml.el

(autoload 'mml-to-mime "mml" "\
Translate the current buffer from MML to MIME.

\(fn)" nil nil)

(autoload 'mml-attach-file "mml" "\
Attach a file to the outgoing MIME message.
The file is not inserted or encoded until you send the message with
`\\[message-send-and-exit]' or `\\[message-send]' in Message mode,
or `\\[mail-send-and-exit]' or `\\[mail-send]' in Mail mode.

FILE is the name of the file to attach.  TYPE is its
content-type, a string of the form \"type/subtype\".  DESCRIPTION
is a one-line description of the attachment.  The DISPOSITION
specifies how the attachment is intended to be displayed.  It can
be either \"inline\" (displayed automatically within the message
body) or \"attachment\" (separate from the body).

\(fn FILE &optional TYPE DESCRIPTION DISPOSITION)" t nil)

;;;***

;;;### (autoloads nil "mml1991" "gnus/mml1991.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from gnus/mml1991.el

(autoload 'mml1991-encrypt "mml1991" "\


\(fn CONT &optional SIGN)" nil nil)

(autoload 'mml1991-sign "mml1991" "\


\(fn CONT)" nil nil)

;;;***

;;;### (autoloads nil "mml2015" "gnus/mml2015.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from gnus/mml2015.el

(autoload 'mml2015-decrypt "mml2015" "\


\(fn HANDLE CTL)" nil nil)

(autoload 'mml2015-decrypt-test "mml2015" "\


\(fn HANDLE CTL)" nil nil)

(autoload 'mml2015-verify "mml2015" "\


\(fn HANDLE CTL)" nil nil)

(autoload 'mml2015-verify-test "mml2015" "\


\(fn HANDLE CTL)" nil nil)

(autoload 'mml2015-encrypt "mml2015" "\


\(fn CONT &optional SIGN)" nil nil)

(autoload 'mml2015-sign "mml2015" "\


\(fn CONT)" nil nil)

(autoload 'mml2015-self-encrypt "mml2015" "\


\(fn)" nil nil)

;;;***

;;;### (autoloads nil "mode-local" "cedet/mode-local.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from cedet/mode-local.el

(put 'define-overloadable-function 'doc-string-elt 3)

;;;***

;;;### (autoloads nil "modula2" "progmodes/modula2.el" (21676 8647
;;;;;;  0 0))
;;; Generated autoloads from progmodes/modula2.el

(defalias 'modula-2-mode 'm2-mode)

(autoload 'm2-mode "modula2" "\
This is a mode intended to support program development in Modula-2.
All control constructs of Modula-2 can be reached by typing C-c
followed by the first character of the construct.
\\<m2-mode-map>
  \\[m2-begin] begin         \\[m2-case] case
  \\[m2-definition] definition    \\[m2-else] else
  \\[m2-for] for           \\[m2-header] header
  \\[m2-if] if            \\[m2-module] module
  \\[m2-loop] loop          \\[m2-or] or
  \\[m2-procedure] procedure     Control-c Control-w with
  \\[m2-record] record        \\[m2-stdio] stdio
  \\[m2-type] type          \\[m2-until] until
  \\[m2-var] var           \\[m2-while] while
  \\[m2-export] export        \\[m2-import] import
  \\[m2-begin-comment] begin-comment \\[m2-end-comment] end-comment
  \\[suspend-emacs] suspend Emacs     \\[m2-toggle] toggle
  \\[m2-compile] compile           \\[m2-next-error] next-error
  \\[m2-link] link

   `m2-indent' controls the number of spaces for each indentation.
   `m2-compile-command' holds the command to compile a Modula-2 program.
   `m2-link-command' holds the command to link a Modula-2 program.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "morse" "play/morse.el" (21788 61018 0 0))
;;; Generated autoloads from play/morse.el

(autoload 'morse-region "morse" "\
Convert all text in a given region to morse code.

\(fn BEG END)" t nil)

(autoload 'unmorse-region "morse" "\
Convert morse coded text in region to ordinary ASCII text.

\(fn BEG END)" t nil)

(autoload 'nato-region "morse" "\
Convert all text in a given region to NATO phonetic alphabet.

\(fn BEG END)" t nil)

(autoload 'denato-region "morse" "\
Convert NATO phonetic alphabet in region to ordinary ASCII text.

\(fn BEG END)" t nil)

;;;***

;;;### (autoloads nil "mouse-drag" "mouse-drag.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from mouse-drag.el

(autoload 'mouse-drag-throw "mouse-drag" "\
\"Throw\" the page according to a mouse drag.

A \"throw\" is scrolling the page at a speed relative to the distance
from the original mouse click to the current mouse location.  Try it;
you'll like it.  It's easier to observe than to explain.

If the mouse is clicked and released in the same place of time we
assume that the user didn't want to scroll but wanted to whatever
mouse-2 used to do, so we pass it through.

Throw scrolling was inspired (but is not identical to) the \"hand\"
option in MacPaint, or the middle button in Tk text widgets.

If `mouse-throw-with-scroll-bar' is non-nil, then this command scrolls
in the opposite direction.  (Different people have different ideas
about which direction is natural.  Perhaps it has to do with which
hemisphere you're in.)

To test this function, evaluate:
    (global-set-key [down-mouse-2] 'mouse-drag-throw)

\(fn START-EVENT)" t nil)

(autoload 'mouse-drag-drag "mouse-drag" "\
\"Drag\" the page according to a mouse drag.

Drag scrolling moves the page according to the movement of the mouse.
You \"grab\" the character under the mouse and move it around.

If the mouse is clicked and released in the same place of time we
assume that the user didn't want to scroll but wanted to whatever
mouse-2 used to do, so we pass it through.

Drag scrolling is identical to the \"hand\" option in MacPaint, or the
middle button in Tk text widgets.

To test this function, evaluate:
    (global-set-key [down-mouse-2] 'mouse-drag-drag)

\(fn START-EVENT)" t nil)

;;;***

;;;### (autoloads nil "mpc" "mpc.el" (21788 61018 0 0))
;;; Generated autoloads from mpc.el

(autoload 'mpc "mpc" "\
Main entry point for MPC.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "mpuz" "play/mpuz.el" (21710 25077 0 0))
;;; Generated autoloads from play/mpuz.el

(autoload 'mpuz "mpuz" "\
Multiplication puzzle with GNU Emacs.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "msb" "msb.el" (21788 61018 0 0))
;;; Generated autoloads from msb.el

(defvar msb-mode nil "\
Non-nil if Msb mode is enabled.
See the command `msb-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `msb-mode'.")

(custom-autoload 'msb-mode "msb" nil)

(autoload 'msb-mode "msb" "\
Toggle Msb mode.
With a prefix argument ARG, enable Msb mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

This mode overrides the binding(s) of `mouse-buffer-menu' to provide a
different buffer menu using the function `msb'.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "mule-diag" "international/mule-diag.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from international/mule-diag.el

(autoload 'list-character-sets "mule-diag" "\
Display a list of all character sets.

The D column contains the dimension of this character set.  The CH
column contains the number of characters in a block of this character
set.  The FINAL-BYTE column contains an ISO-2022 <final-byte> to use
in the designation escape sequence for this character set in
ISO-2022-based coding systems.

With prefix ARG, the output format gets more cryptic,
but still shows the full information.

\(fn ARG)" t nil)

(autoload 'read-charset "mule-diag" "\
Read a character set from the minibuffer, prompting with string PROMPT.
It must be an Emacs character set listed in the variable `charset-list'.

Optional arguments are DEFAULT-VALUE and INITIAL-INPUT.
DEFAULT-VALUE, if non-nil, is the default value.
INITIAL-INPUT, if non-nil, is a string inserted in the minibuffer initially.
See the documentation of the function `completing-read' for the detailed
meanings of these arguments.

\(fn PROMPT &optional DEFAULT-VALUE INITIAL-INPUT)" nil nil)

(autoload 'list-charset-chars "mule-diag" "\
Display a list of characters in character set CHARSET.

\(fn CHARSET)" t nil)

(autoload 'describe-character-set "mule-diag" "\
Display information about built-in character set CHARSET.

\(fn CHARSET)" t nil)

(autoload 'describe-coding-system "mule-diag" "\
Display information about CODING-SYSTEM.

\(fn CODING-SYSTEM)" t nil)

(autoload 'describe-current-coding-system-briefly "mule-diag" "\
Display coding systems currently used in a brief format in echo area.

The format is \"F[..],K[..],T[..],P>[..],P<[..], default F[..],P<[..],P<[..]\",
where mnemonics of the following coding systems come in this order
in place of `..':
  `buffer-file-coding-system' (of the current buffer)
  eol-type of `buffer-file-coding-system' (of the current buffer)
  Value returned by `keyboard-coding-system'
  eol-type of `keyboard-coding-system'
  Value returned by `terminal-coding-system'.
  eol-type of `terminal-coding-system'
  `process-coding-system' for read (of the current buffer, if any)
  eol-type of `process-coding-system' for read (of the current buffer, if any)
  `process-coding-system' for write (of the current buffer, if any)
  eol-type of `process-coding-system' for write (of the current buffer, if any)
  default `buffer-file-coding-system'
  eol-type of default `buffer-file-coding-system'
  `default-process-coding-system' for read
  eol-type of `default-process-coding-system' for read
  `default-process-coding-system' for write
  eol-type of `default-process-coding-system'

\(fn)" t nil)

(autoload 'describe-current-coding-system "mule-diag" "\
Display coding systems currently used, in detail.

\(fn)" t nil)

(autoload 'list-coding-systems "mule-diag" "\
Display a list of all coding systems.
This shows the mnemonic letter, name, and description of each coding system.

With prefix ARG, the output format gets more cryptic,
but still contains full information about each coding system.

\(fn &optional ARG)" t nil)

(autoload 'list-coding-categories "mule-diag" "\
Display a list of all coding categories.

\(fn)" nil nil)

(autoload 'describe-font "mule-diag" "\
Display information about a font whose name is FONTNAME.
The font must be already used by Emacs.

\(fn FONTNAME)" t nil)

(autoload 'describe-fontset "mule-diag" "\
Display information about FONTSET.
This shows which font is used for which character(s).

\(fn FONTSET)" t nil)

(autoload 'list-fontsets "mule-diag" "\
Display a list of all fontsets.
This shows the name, size, and style of each fontset.
With prefix arg, also list the fonts contained in each fontset;
see the function `describe-fontset' for the format of the list.

\(fn ARG)" t nil)

(autoload 'list-input-methods "mule-diag" "\
Display information about all input methods.

\(fn)" t nil)

(autoload 'mule-diag "mule-diag" "\
Display diagnosis of the multilingual environment (Mule).

This shows various information related to the current multilingual
environment, including lists of input methods, coding systems,
character sets, and fontsets (if Emacs is running under a window
system which uses fontsets).

\(fn)" t nil)

(autoload 'font-show-log "mule-diag" "\
Show log of font listing and opening.
Prefix arg LIMIT says how many fonts to show for each listing.
The default is 20.  If LIMIT is negative, do not limit the listing.

\(fn &optional LIMIT)" t nil)

;;;***

;;;### (autoloads nil "mule-util" "international/mule-util.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from international/mule-util.el

(defsubst string-to-list (string) "\
Return a list of characters in STRING." (append string nil))

(defsubst string-to-vector (string) "\
Return a vector of characters in STRING." (vconcat string))

(autoload 'store-substring "mule-util" "\
Embed OBJ (string or character) at index IDX of STRING.

\(fn STRING IDX OBJ)" nil nil)

(autoload 'truncate-string-to-width "mule-util" "\
Truncate string STR to end at column END-COLUMN.
The optional 3rd arg START-COLUMN, if non-nil, specifies the starting
column; that means to return the characters occupying columns
START-COLUMN ... END-COLUMN of STR.  Both END-COLUMN and START-COLUMN
are specified in terms of character display width in the current
buffer; see also `char-width'.

The optional 4th arg PADDING, if non-nil, specifies a padding
character (which should have a display width of 1) to add at the end
of the result if STR doesn't reach column END-COLUMN, or if END-COLUMN
comes in the middle of a character in STR.  PADDING is also added at
the beginning of the result if column START-COLUMN appears in the
middle of a character in STR.

If PADDING is nil, no padding is added in these cases, so
the resulting string may be narrower than END-COLUMN.

If ELLIPSIS is non-nil, it should be a string which will replace the
end of STR (including any padding) if it extends beyond END-COLUMN,
unless the display width of STR is equal to or less than the display
width of ELLIPSIS.  If it is non-nil and not a string, then ELLIPSIS
defaults to \"...\".

\(fn STR END-COLUMN &optional START-COLUMN PADDING ELLIPSIS)" nil nil)

(defsubst nested-alist-p (obj) "\
Return t if OBJ is a nested alist.

Nested alist is a list of the form (ENTRY . BRANCHES), where ENTRY is
any Lisp object, and BRANCHES is a list of cons cells of the form
\(KEY-ELEMENT . NESTED-ALIST).

You can use a nested alist to store any Lisp object (ENTRY) for a key
sequence KEYSEQ, where KEYSEQ is a sequence of KEY-ELEMENT.  KEYSEQ
can be a string, a vector, or a list." (and obj (listp obj) (listp (cdr obj))))

(autoload 'set-nested-alist "mule-util" "\
Set ENTRY for KEYSEQ in a nested alist ALIST.
Optional 4th arg LEN non-nil means the first LEN elements in KEYSEQ
 are considered.
Optional 5th argument BRANCHES if non-nil is branches for a keyseq
longer than KEYSEQ.
See the documentation of `nested-alist-p' for more detail.

\(fn KEYSEQ ENTRY ALIST &optional LEN BRANCHES)" nil nil)

(autoload 'lookup-nested-alist "mule-util" "\
Look up key sequence KEYSEQ in nested alist ALIST.  Return the definition.
Optional 3rd argument LEN specifies the length of KEYSEQ.
Optional 4th argument START specifies index of the starting key.
The returned value is normally a nested alist of which
car part is the entry for KEYSEQ.
If ALIST is not deep enough for KEYSEQ, return number which is
 how many key elements at the front of KEYSEQ it takes
 to reach a leaf in ALIST.
Optional 5th argument NIL-FOR-TOO-LONG non-nil means return nil
 even if ALIST is not deep enough.

\(fn KEYSEQ ALIST &optional LEN START NIL-FOR-TOO-LONG)" nil nil)

(autoload 'coding-system-post-read-conversion "mule-util" "\
Return the value of CODING-SYSTEM's `post-read-conversion' property.

\(fn CODING-SYSTEM)" nil nil)

(autoload 'coding-system-pre-write-conversion "mule-util" "\
Return the value of CODING-SYSTEM's `pre-write-conversion' property.

\(fn CODING-SYSTEM)" nil nil)

(autoload 'coding-system-translation-table-for-decode "mule-util" "\
Return the value of CODING-SYSTEM's `decode-translation-table' property.

\(fn CODING-SYSTEM)" nil nil)

(autoload 'coding-system-translation-table-for-encode "mule-util" "\
Return the value of CODING-SYSTEM's `encode-translation-table' property.

\(fn CODING-SYSTEM)" nil nil)

(autoload 'with-coding-priority "mule-util" "\
Execute BODY like `progn' with CODING-SYSTEMS at the front of priority list.
CODING-SYSTEMS is a list of coding systems.  See `set-coding-system-priority'.
This affects the implicit sorting of lists of coding systems returned by
operations such as `find-coding-systems-region'.

\(fn CODING-SYSTEMS &rest BODY)" nil t)
(put 'with-coding-priority 'lisp-indent-function 1)

(autoload 'detect-coding-with-priority "mule-util" "\
Detect a coding system of the text between FROM and TO with PRIORITY-LIST.
PRIORITY-LIST is an alist of coding categories vs the corresponding
coding systems ordered by priority.

\(fn FROM TO PRIORITY-LIST)" nil t)

(make-obsolete 'detect-coding-with-priority 'with-coding-priority '"23.1")

(autoload 'detect-coding-with-language-environment "mule-util" "\
Detect a coding system for the text between FROM and TO with LANG-ENV.
The detection takes into account the coding system priorities for the
language environment LANG-ENV.

\(fn FROM TO LANG-ENV)" nil nil)

(autoload 'char-displayable-p "mule-util" "\
Return non-nil if we should be able to display CHAR.
On a multi-font display, the test is only whether there is an
appropriate font from the selected frame's fontset to display
CHAR's charset in general.  Since fonts may be specified on a
per-character basis, this may not be accurate.

\(fn CHAR)" nil nil)

;;;***

;;;### (autoloads nil "net-utils" "net/net-utils.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from net/net-utils.el

(autoload 'ifconfig "net-utils" "\
Run ifconfig and display diagnostic output.

\(fn)" t nil)

(autoload 'iwconfig "net-utils" "\
Run iwconfig and display diagnostic output.

\(fn)" t nil)

(autoload 'netstat "net-utils" "\
Run netstat and display diagnostic output.

\(fn)" t nil)

(autoload 'arp "net-utils" "\
Run arp and display diagnostic output.

\(fn)" t nil)

(autoload 'route "net-utils" "\
Run route and display diagnostic output.

\(fn)" t nil)

(autoload 'traceroute "net-utils" "\
Run traceroute program for TARGET.

\(fn TARGET)" t nil)

(autoload 'ping "net-utils" "\
Ping HOST.
If your system's ping continues until interrupted, you can try setting
`ping-program-options'.

\(fn HOST)" t nil)

(autoload 'nslookup-host "net-utils" "\
Lookup the DNS information for HOST.

\(fn HOST)" t nil)

(autoload 'nslookup "net-utils" "\
Run nslookup program.

\(fn)" t nil)

(autoload 'dns-lookup-host "net-utils" "\
Lookup the DNS information for HOST (name or IP address).

\(fn HOST)" t nil)

(autoload 'run-dig "net-utils" "\
Run dig program.

\(fn HOST)" t nil)

(autoload 'ftp "net-utils" "\
Run ftp program.

\(fn HOST)" t nil)

(autoload 'finger "net-utils" "\
Finger USER on HOST.

\(fn USER HOST)" t nil)

(autoload 'whois "net-utils" "\
Send SEARCH-STRING to server defined by the `whois-server-name' variable.
If `whois-guess-server' is non-nil, then try to deduce the correct server
from SEARCH-STRING.  With argument, prompt for whois server.

\(fn ARG SEARCH-STRING)" t nil)

(autoload 'whois-reverse-lookup "net-utils" "\


\(fn)" t nil)

(autoload 'network-connection-to-service "net-utils" "\
Open a network connection to SERVICE on HOST.

\(fn HOST SERVICE)" t nil)

(autoload 'network-connection "net-utils" "\
Open a network connection to HOST on PORT.

\(fn HOST PORT)" t nil)

;;;***

;;;### (autoloads nil "netrc" "net/netrc.el" (21710 25077 0 0))
;;; Generated autoloads from net/netrc.el

(autoload 'netrc-credentials "netrc" "\
Return a user name/password pair.
Port specifications will be prioritized in the order they are
listed in the PORTS list.

\(fn MACHINE &rest PORTS)" nil nil)

;;;***

;;;### (autoloads nil "network-stream" "net/network-stream.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from net/network-stream.el

(autoload 'open-network-stream "network-stream" "\
Open a TCP connection to HOST, optionally with encryption.
Normally, return a network process object; with a non-nil
:return-list parameter, return a list instead (see below).
Input and output work as for subprocesses; `delete-process'
closes it.

NAME is the name for the process.  It is modified if necessary to
 make it unique.
BUFFER is a buffer or buffer name to associate with the process.
 Process output goes at end of that buffer.  BUFFER may be nil,
 meaning that the process is not associated with any buffer.
HOST is the name or IP address of the host to connect to.
SERVICE is the name of the service desired, or an integer specifying
 a port number to connect to.

The remaining PARAMETERS should be a sequence of keywords and
values:

:type specifies the connection type, one of the following:
  nil or `network'
             -- Begin with an ordinary network connection, and if
                the parameters :success and :capability-command
                are also supplied, try to upgrade to an encrypted
                connection via STARTTLS.  Even if that
                fails (e.g. if HOST does not support TLS), retain
                an unencrypted connection.
  `plain'    -- An ordinary, unencrypted network connection.
  `starttls' -- Begin with an ordinary connection, and try
                upgrading via STARTTLS.  If that fails for any
                reason, drop the connection; in that case the
                returned object is a killed process.
  `tls'      -- A TLS connection.
  `ssl'      -- Equivalent to `tls'.
  `shell'    -- A shell connection.

:return-list specifies this function's return value.
  If omitted or nil, return a process object.  A non-nil means to
  return (PROC . PROPS), where PROC is a process object and PROPS
  is a plist of connection properties, with these keywords:
   :greeting -- the greeting returned by HOST (a string), or nil.
   :capabilities -- a string representing HOST's capabilities,
                    or nil if none could be found.
   :type -- the resulting connection type; `plain' (unencrypted)
            or `tls' (TLS-encrypted).

:end-of-command specifies a regexp matching the end of a command.

:end-of-capability specifies a regexp matching the end of the
  response to the command specified for :capability-command.
  It defaults to the regexp specified for :end-of-command.

:success specifies a regexp matching a message indicating a
  successful STARTTLS negotiation.  For instance, the default
  should be \"^3\" for an NNTP connection.

:capability-command specifies a command used to query the HOST
  for its capabilities.  For instance, for IMAP this should be
  \"1 CAPABILITY\\r\\n\".

:starttls-function specifies a function for handling STARTTLS.
  This function should take one parameter, the response to the
  capability command, and should return the command to switch on
  STARTTLS if the server supports STARTTLS, and nil otherwise.

:always-query-capabilities says whether to query the server for
  capabilities, even if we're doing a `plain' network connection.

:client-certificate should either be a list where the first
  element is the certificate key file name, and the second
  element is the certificate file name itself, or `t', which
  means that `auth-source' will be queried for the key and the
  certificate.  This parameter will only be used when doing TLS
  or STARTTLS connections.

:use-starttls-if-possible is a boolean that says to do opportunistic
STARTTLS upgrades even if Emacs doesn't have built-in TLS functionality.

:nogreeting is a boolean that can be used to inhibit waiting for
a greeting from the server.

:nowait is a boolean that says the connection should be made
  asynchronously, if possible.

\(fn NAME BUFFER HOST SERVICE &rest PARAMETERS)" nil nil)

(defalias 'open-protocol-stream 'open-network-stream)

;;;***

;;;### (autoloads nil "newst-backend" "net/newst-backend.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from net/newst-backend.el

(autoload 'newsticker-running-p "newst-backend" "\
Check whether newsticker is running.
Return t if newsticker is running, nil otherwise.  Newsticker is
considered to be running if the newsticker timer list is not empty.

\(fn)" nil nil)

(autoload 'newsticker-start "newst-backend" "\
Start the newsticker.
Start the timers for display and retrieval.  If the newsticker, i.e. the
timers, are running already a warning message is printed unless
DO-NOT-COMPLAIN-IF-RUNNING is not nil.
Run `newsticker-start-hook' if newsticker was not running already.

\(fn &optional DO-NOT-COMPLAIN-IF-RUNNING)" t nil)

;;;***

;;;### (autoloads nil "newst-plainview" "net/newst-plainview.el"
;;;;;;  (21788 61018 0 0))
;;; Generated autoloads from net/newst-plainview.el

(autoload 'newsticker-plainview "newst-plainview" "\
Start newsticker plainview.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "newst-reader" "net/newst-reader.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from net/newst-reader.el

(autoload 'newsticker-show-news "newst-reader" "\
Start reading news.  You may want to bind this to a key.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "newst-ticker" "net/newst-ticker.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from net/newst-ticker.el

(autoload 'newsticker-ticker-running-p "newst-ticker" "\
Check whether newsticker's actual ticker is running.
Return t if ticker is running, nil otherwise.  Newsticker is
considered to be running if the newsticker timer list is not
empty.

\(fn)" nil nil)

(autoload 'newsticker-start-ticker "newst-ticker" "\
Start newsticker's ticker (but not the news retrieval).
Start display timer for the actual ticker if wanted and not
running already.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "newst-treeview" "net/newst-treeview.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from net/newst-treeview.el

(autoload 'newsticker-treeview "newst-treeview" "\
Start newsticker treeview.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "newsticker" "net/newsticker.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from net/newsticker.el
(push (purecopy '(newsticker 1 99)) package--builtin-versions)

;;;***

;;;### (autoloads nil "nndiary" "gnus/nndiary.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from gnus/nndiary.el

(autoload 'nndiary-generate-nov-databases "nndiary" "\
Generate NOV databases in all nndiary directories.

\(fn &optional SERVER)" t nil)

;;;***

;;;### (autoloads nil "nndoc" "gnus/nndoc.el" (21710 25077 0 0))
;;; Generated autoloads from gnus/nndoc.el

(autoload 'nndoc-add-type "nndoc" "\
Add document DEFINITION to the list of nndoc document definitions.
If POSITION is nil or `last', the definition will be added
as the last checked definition, if t or `first', add as the
first definition, and if any other symbol, add after that
symbol in the alist.

\(fn DEFINITION &optional POSITION)" nil nil)

;;;***

;;;### (autoloads nil "nnfolder" "gnus/nnfolder.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from gnus/nnfolder.el

(autoload 'nnfolder-generate-active-file "nnfolder" "\
Look for mbox folders in the nnfolder directory and make them into groups.
This command does not work if you use short group names.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "nnml" "gnus/nnml.el" (21710 25077 0 0))
;;; Generated autoloads from gnus/nnml.el

(autoload 'nnml-generate-nov-databases "nnml" "\
Generate NOV databases in all nnml directories.

\(fn &optional SERVER)" t nil)

;;;***

;;;### (autoloads nil "novice" "novice.el" (21710 25077 0 0))
;;; Generated autoloads from novice.el

(define-obsolete-variable-alias 'disabled-command-hook 'disabled-command-function "22.1")

(defvar disabled-command-function 'disabled-command-function "\
Function to call to handle disabled commands.
If nil, the feature is disabled, i.e., all commands work normally.")

(autoload 'disabled-command-function "novice" "\


\(fn &optional CMD KEYS)" nil nil)

(autoload 'enable-command "novice" "\
Allow COMMAND to be executed without special confirmation from now on.
COMMAND must be a symbol.
This command alters the user's .emacs file so that this will apply
to future sessions.

\(fn COMMAND)" t nil)

(autoload 'disable-command "novice" "\
Require special confirmation to execute COMMAND from now on.
COMMAND must be a symbol.
This command alters your init file so that this choice applies to
future sessions.

\(fn COMMAND)" t nil)

;;;***

;;;### (autoloads nil "nroff-mode" "textmodes/nroff-mode.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from textmodes/nroff-mode.el

(autoload 'nroff-mode "nroff-mode" "\
Major mode for editing text intended for nroff to format.
\\{nroff-mode-map}
Turning on Nroff mode runs `text-mode-hook', then `nroff-mode-hook'.
Also, try `nroff-electric-mode', for automatically inserting
closing requests for requests that are used in matched pairs.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ntlm" "net/ntlm.el" (21788 61018 0 0))
;;; Generated autoloads from net/ntlm.el
(push (purecopy '(ntlm 1 0)) package--builtin-versions)

;;;***

;;;### (autoloads nil "nxml-glyph" "nxml/nxml-glyph.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from nxml/nxml-glyph.el

(autoload 'nxml-glyph-display-string "nxml-glyph" "\
Return a string that can display a glyph for Unicode code-point N.
FACE gives the face that will be used for displaying the string.
Return nil if the face cannot display a glyph for N.

\(fn N FACE)" nil nil)

;;;***

;;;### (autoloads nil "nxml-mode" "nxml/nxml-mode.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from nxml/nxml-mode.el

(autoload 'nxml-mode "nxml-mode" "\
Major mode for editing XML.

\\[nxml-finish-element] finishes the current element by inserting an end-tag.
C-c C-i closes a start-tag with `>' and then inserts a balancing end-tag
leaving point between the start-tag and end-tag.
\\[nxml-balanced-close-start-tag-block] is similar but for block rather than inline elements:
the start-tag, point, and end-tag are all left on separate lines.
If `nxml-slash-auto-complete-flag' is non-nil, then inserting a `</'
automatically inserts the rest of the end-tag.

\\[completion-at-point] performs completion on the symbol preceding point.

\\[nxml-dynamic-markup-word] uses the contents of the current buffer
to choose a tag to put around the word preceding point.

Sections of the document can be displayed in outline form.  The
variable `nxml-section-element-name-regexp' controls when an element
is recognized as a section.  The same key sequences that change
visibility in outline mode are used except that they start with C-c C-o
instead of C-c.

Validation is provided by the related minor-mode `rng-validate-mode'.
This also makes completion schema- and context- sensitive.  Element
names, attribute names, attribute values and namespace URIs can all be
completed. By default, `rng-validate-mode' is automatically enabled.
You can toggle it using \\[rng-validate-mode] or change the default by
customizing `rng-nxml-auto-validate-flag'.

\\[indent-for-tab-command] indents the current line appropriately.
This can be customized using the variable `nxml-child-indent'
and the variable `nxml-attribute-indent'.

\\[nxml-insert-named-char] inserts a character reference using
the character's name (by default, the Unicode name).
\\[universal-argument] \\[nxml-insert-named-char] inserts the character directly.

The Emacs commands that normally operate on balanced expressions will
operate on XML markup items.  Thus \\[forward-sexp] will move forward
across one markup item; \\[backward-sexp] will move backward across
one markup item; \\[kill-sexp] will kill the following markup item;
\\[mark-sexp] will mark the following markup item.  By default, each
tag each treated as a single markup item; to make the complete element
be treated as a single markup item, set the variable
`nxml-sexp-element-flag' to t.  For more details, see the function
`nxml-forward-balanced-item'.

\\[nxml-backward-up-element] and \\[nxml-down-element] move up and down the element structure.

Many aspects this mode can be customized using
\\[customize-group] nxml RET.

\(fn)" t nil)
(defalias 'xml-mode 'nxml-mode)

;;;***

;;;### (autoloads nil "nxml-uchnm" "nxml/nxml-uchnm.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from nxml/nxml-uchnm.el

(autoload 'nxml-enable-unicode-char-name-sets "nxml-uchnm" "\
Enable the use of Unicode standard names for characters.
The Unicode blocks for which names are enabled is controlled by
the variable `nxml-enabled-unicode-blocks'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "octave" "progmodes/octave.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/octave.el

(autoload 'octave-mode "octave" "\
Major mode for editing Octave code.

Octave is a high-level language, primarily intended for numerical
computations.  It provides a convenient command line interface
for solving linear and nonlinear problems numerically.  Function
definitions can also be stored in files and used in batch mode.

See Info node `(octave-mode) Using Octave Mode' for more details.

Key bindings:
\\{octave-mode-map}

\(fn)" t nil)

(autoload 'inferior-octave "octave" "\
Run an inferior Octave process, I/O via `inferior-octave-buffer'.
This buffer is put in Inferior Octave mode.  See `inferior-octave-mode'.

Unless ARG is non-nil, switches to this buffer.

The elements of the list `inferior-octave-startup-args' are sent as
command line arguments to the inferior Octave process on startup.

Additional commands to be executed on startup can be provided either in
the file specified by `inferior-octave-startup-file' or by the default
startup file, `~/.emacs-octave'.

\(fn &optional ARG)" t nil)

(defalias 'run-octave 'inferior-octave)

;;;***

;;;### (autoloads nil "opascal" "progmodes/opascal.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/opascal.el

(define-obsolete-function-alias 'delphi-mode 'opascal-mode "24.4")

(autoload 'opascal-mode "opascal" "\
Major mode for editing OPascal code.\\<opascal-mode-map>
\\[opascal-find-unit]	- Search for a OPascal source file.
\\[opascal-fill-comment]	- Fill the current comment.
\\[opascal-new-comment-line]	- If in a // comment, do a new comment line.

\\[indent-region] also works for indenting a whole region.

Customization:

 `opascal-indent-level'                (default 3)
    Indentation of OPascal statements with respect to containing block.
 `opascal-compound-block-indent'       (default 0)
    Extra indentation for blocks in compound statements.
 `opascal-case-label-indent'           (default 0)
    Extra indentation for case statement labels.
 `opascal-search-path'                 (default .)
    Directories to search when finding external units.
 `opascal-verbose'                     (default nil)
    If true then OPascal token processing progress is reported to the user.

Coloring:

 `opascal-keyword-face'                (default `font-lock-keyword-face')
    Face used to color OPascal keywords.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "org" "org/org.el" (21788 61018 0 0))
;;; Generated autoloads from org/org.el

(autoload 'org-babel-do-load-languages "org" "\
Load the languages defined in `org-babel-load-languages'.

\(fn SYM VALUE)" nil nil)

(autoload 'org-babel-load-file "org" "\
Load Emacs Lisp source code blocks in the Org-mode FILE.
This function exports the source code using `org-babel-tangle'
and then loads the resulting file using `load-file'.  With prefix
arg (noninteractively: 2nd arg) COMPILE the tangled Emacs Lisp
file to byte-code before it is loaded.

\(fn FILE &optional COMPILE)" t nil)

(autoload 'org-version "org" "\
Show the org-mode version in the echo area.
With prefix argument HERE, insert it at point.
When FULL is non-nil, use a verbose version string.
When MESSAGE is non-nil, display a message with the version.

\(fn &optional HERE FULL MESSAGE)" t nil)

(autoload 'turn-on-orgtbl "org" "\
Unconditionally turn on `orgtbl-mode'.

\(fn)" nil nil)

(autoload 'org-clock-persistence-insinuate "org" "\
Set up hooks for clock persistence.

\(fn)" nil nil)

(autoload 'org-mode "org" "\
Outline-based notes management and organizer, alias
\"Carsten's outline-mode for keeping track of everything.\"

Org-mode develops organizational tasks around a NOTES file which
contains information about projects as plain text.  Org-mode is
implemented on top of outline-mode, which is ideal to keep the content
of large files well structured.  It supports ToDo items, deadlines and
time stamps, which magically appear in the diary listing of the Emacs
calendar.  Tables are easily created with a built-in table editor.
Plain text URL-like links connect to websites, emails (VM), Usenet
messages (Gnus), BBDB entries, and any files related to the project.
For printing and sharing of notes, an Org-mode file (or a part of it)
can be exported as a structured ASCII or HTML file.

The following commands are available:

\\{org-mode-map}

\(fn)" t nil)

(autoload 'org-cycle "org" "\
TAB-action and visibility cycling for Org-mode.

This is the command invoked in Org-mode by the TAB key.  Its main purpose
is outline visibility cycling, but it also invokes other actions
in special contexts.

- When this function is called with a prefix argument, rotate the entire
  buffer through 3 states (global cycling)
  1. OVERVIEW: Show only top-level headlines.
  2. CONTENTS: Show all headlines of all levels, but no body text.
  3. SHOW ALL: Show everything.
  When called with two `C-u C-u' prefixes, switch to the startup visibility,
  determined by the variable `org-startup-folded', and by any VISIBILITY
  properties in the buffer.
  When called with three `C-u C-u C-u' prefixed, show the entire buffer,
  including any drawers.

- When inside a table, re-align the table and move to the next field.

- When point is at the beginning of a headline, rotate the subtree started
  by this line through 3 different states (local cycling)
  1. FOLDED:   Only the main headline is shown.
  2. CHILDREN: The main headline and the direct children are shown.
               From this state, you can move to one of the children
               and zoom in further.
  3. SUBTREE:  Show the entire subtree, including body text.
  If there is no subtree, switch directly from CHILDREN to FOLDED.

- When point is at the beginning of an empty headline and the variable
  `org-cycle-level-after-item/entry-creation' is set, cycle the level
  of the headline by demoting and promoting it to likely levels.  This
  speeds up creation document structure by pressing TAB once or several
  times right after creating a new headline.

- When there is a numeric prefix, go up to a heading with level ARG, do
  a `show-subtree' and return to the previous cursor position.  If ARG
  is negative, go up that many levels.

- When point is not at the beginning of a headline, execute the global
  binding for TAB, which is re-indenting the line.  See the option
  `org-cycle-emulate-tab' for details.

- Special case: if point is at the beginning of the buffer and there is
  no headline in line 1, this function will act as if called with prefix arg
  (C-u TAB, same as S-TAB) also when called without prefix arg.
  But only if also the variable `org-cycle-global-at-bob' is t.

\(fn &optional ARG)" t nil)

(autoload 'org-global-cycle "org" "\
Cycle the global visibility.  For details see `org-cycle'.
With \\[universal-argument] prefix arg, switch to startup visibility.
With a numeric prefix, show all headlines up to that level.

\(fn &optional ARG)" t nil)
(put 'orgstruct-heading-prefix-regexp 'safe-local-variable 'stringp)

(autoload 'orgstruct-mode "org" "\
Toggle the minor mode `orgstruct-mode'.
This mode is for using Org-mode structure commands in other
modes.  The following keys behave as if Org-mode were active, if
the cursor is on a headline, or on a plain list item (both as
defined by Org-mode).

\(fn &optional ARG)" t nil)

(autoload 'turn-on-orgstruct "org" "\
Unconditionally turn on `orgstruct-mode'.

\(fn)" nil nil)

(autoload 'turn-on-orgstruct++ "org" "\
Unconditionally turn on `orgstruct++-mode'.

\(fn)" nil nil)

(autoload 'org-run-like-in-org-mode "org" "\
Run a command, pretending that the current buffer is in Org-mode.
This will temporarily bind local variables that are typically bound in
Org-mode to the values they have in Org-mode, and then interactively
call CMD.

\(fn CMD)" nil nil)

(autoload 'org-store-link "org" "\
\\<org-mode-map>Store an org-link to the current location.
This link is added to `org-stored-links' and can later be inserted
into an org-buffer with \\[org-insert-link].

For some link types, a prefix arg is interpreted.
For links to Usenet articles, arg negates `org-gnus-prefer-web-links'.
For file links, arg negates `org-context-in-file-links'.

A double prefix arg force skipping storing functions that are not
part of Org's core.

A triple prefix arg force storing a link for each line in the
active region.

\(fn ARG)" t nil)

(autoload 'org-insert-link-global "org" "\
Insert a link like Org-mode does.
This command can be called in any mode to insert a link in Org-mode syntax.

\(fn)" t nil)

(autoload 'org-open-at-point-global "org" "\
Follow a link like Org-mode does.
This command can be called in any mode to follow a link that has
Org-mode syntax.

\(fn)" t nil)

(autoload 'org-open-link-from-string "org" "\
Open a link in the string S, as if it was in Org-mode.

\(fn S &optional ARG REFERENCE-BUFFER)" t nil)

(autoload 'org-switchb "org" "\
Switch between Org buffers.
With one prefix argument, restrict available buffers to files.
With two prefix arguments, restrict available buffers to agenda files.

Defaults to `iswitchb' for buffer name completion.
Set `org-completion-use-ido' to make it use ido instead.

\(fn &optional ARG)" t nil)

(defalias 'org-ido-switchb 'org-switchb)

(defalias 'org-iswitchb 'org-switchb)

(autoload 'org-cycle-agenda-files "org" "\
Cycle through the files in `org-agenda-files'.
If the current buffer visits an agenda file, find the next one in the list.
If the current buffer does not, find the first agenda file.

\(fn)" t nil)

(autoload 'org-submit-bug-report "org" "\
Submit a bug report on Org-mode via mail.

Don't hesitate to report any problems or inaccurate documentation.

If you don't have setup sending mail from (X)Emacs, please copy the
output buffer into your mail program, as it gives us important
information about your Org-mode version and configuration.

\(fn)" t nil)

(autoload 'org-reload "org" "\
Reload all org lisp files.
With prefix arg UNCOMPILED, load the uncompiled versions.

\(fn &optional UNCOMPILED)" t nil)

(autoload 'org-customize "org" "\
Call the customize function with org as argument.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "org-agenda" "org/org-agenda.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from org/org-agenda.el

(autoload 'org-toggle-sticky-agenda "org-agenda" "\
Toggle `org-agenda-sticky'.

\(fn &optional ARG)" t nil)

(autoload 'org-agenda "org-agenda" "\
Dispatch agenda commands to collect entries to the agenda buffer.
Prompts for a command to execute.  Any prefix arg will be passed
on to the selected command.  The default selections are:

a     Call `org-agenda-list' to display the agenda for current day or week.
t     Call `org-todo-list' to display the global todo list.
T     Call `org-todo-list' to display the global todo list, select only
      entries with a specific TODO keyword (the user gets a prompt).
m     Call `org-tags-view' to display headlines with tags matching
      a condition  (the user is prompted for the condition).
M     Like `m', but select only TODO entries, no ordinary headlines.
L     Create a timeline for the current buffer.
e     Export views to associated files.
s     Search entries for keywords.
S     Search entries for keywords, only with TODO keywords.
/     Multi occur across all agenda files and also files listed
      in `org-agenda-text-search-extra-files'.
<     Restrict agenda commands to buffer, subtree, or region.
      Press several times to get the desired effect.
>     Remove a previous restriction.
#     List \"stuck\" projects.
!     Configure what \"stuck\" means.
C     Configure custom agenda commands.

More commands can be added by configuring the variable
`org-agenda-custom-commands'.  In particular, specific tags and TODO keyword
searches can be pre-defined in this way.

If the current buffer is in Org-mode and visiting a file, you can also
first press `<' once to indicate that the agenda should be temporarily
\(until the next use of \\[org-agenda]) restricted to the current file.
Pressing `<' twice means to restrict to the current subtree or region
\(if active).

\(fn &optional ARG ORG-KEYS RESTRICTION)" t nil)

(autoload 'org-batch-agenda "org-agenda" "\
Run an agenda command in batch mode and send the result to STDOUT.
If CMD-KEY is a string of length 1, it is used as a key in
`org-agenda-custom-commands' and triggers this command.  If it is a
longer string it is used as a tags/todo match string.
Parameters are alternating variable names and values that will be bound
before running the agenda command.

\(fn CMD-KEY &rest PARAMETERS)" nil t)

(autoload 'org-batch-agenda-csv "org-agenda" "\
Run an agenda command in batch mode and send the result to STDOUT.
If CMD-KEY is a string of length 1, it is used as a key in
`org-agenda-custom-commands' and triggers this command.  If it is a
longer string it is used as a tags/todo match string.
Parameters are alternating variable names and values that will be bound
before running the agenda command.

The output gives a line for each selected agenda item.  Each
item is a list of comma-separated values, like this:

category,head,type,todo,tags,date,time,extra,priority-l,priority-n

category     The category of the item
head         The headline, without TODO kwd, TAGS and PRIORITY
type         The type of the agenda entry, can be
                todo               selected in TODO match
                tagsmatch          selected in tags match
                diary              imported from diary
                deadline           a deadline on given date
                scheduled          scheduled on given date
                timestamp          entry has timestamp on given date
                closed             entry was closed on given date
                upcoming-deadline  warning about deadline
                past-scheduled     forwarded scheduled item
                block              entry has date block including g. date
todo         The todo keyword, if any
tags         All tags including inherited ones, separated by colons
date         The relevant date, like 2007-2-14
time         The time, like 15:00-16:50
extra        Sting with extra planning info
priority-l   The priority letter if any was given
priority-n   The computed numerical priority
agenda-day   The day in the agenda where this is listed

\(fn CMD-KEY &rest PARAMETERS)" nil t)

(autoload 'org-store-agenda-views "org-agenda" "\
Store agenda views.

\(fn &rest PARAMETERS)" t nil)

(autoload 'org-batch-store-agenda-views "org-agenda" "\
Run all custom agenda commands that have a file argument.

\(fn &rest PARAMETERS)" nil t)

(autoload 'org-agenda-list "org-agenda" "\
Produce a daily/weekly view from all files in variable `org-agenda-files'.
The view will be for the current day or week, but from the overview buffer
you will be able to go to other days/weeks.

With a numeric prefix argument in an interactive call, the agenda will
span ARG days.  Lisp programs should instead specify SPAN to change
the number of days.  SPAN defaults to `org-agenda-span'.

START-DAY defaults to TODAY, or to the most recent match for the weekday
given in `org-agenda-start-on-weekday'.

When WITH-HOUR is non-nil, only include scheduled and deadline
items if they have an hour specification like [h]h:mm.

\(fn &optional ARG START-DAY SPAN WITH-HOUR)" t nil)

(autoload 'org-search-view "org-agenda" "\
Show all entries that contain a phrase or words or regular expressions.

With optional prefix argument TODO-ONLY, only consider entries that are
TODO entries.  The argument STRING can be used to pass a default search
string into this function.  If EDIT-AT is non-nil, it means that the
user should get a chance to edit this string, with cursor at position
EDIT-AT.

The search string can be viewed either as a phrase that should be found as
is, or it can be broken into a number of snippets, each of which must match
in a Boolean way to select an entry.  The default depends on the variable
`org-agenda-search-view-always-boolean'.
Even if this is turned off (the default) you can always switch to
Boolean search dynamically by preceding the first word with  \"+\" or \"-\".

The default is a direct search of the whole phrase, where each space in
the search string can expand to an arbitrary amount of whitespace,
including newlines.

If using a Boolean search, the search string is split on whitespace and
each snippet is searched separately, with logical AND to select an entry.
Words prefixed with a minus must *not* occur in the entry.  Words without
a prefix or prefixed with a plus must occur in the entry.  Matching is
case-insensitive.  Words are enclosed by word delimiters (i.e. they must
match whole words, not parts of a word) if
`org-agenda-search-view-force-full-words' is set (default is nil).

Boolean search snippets enclosed by curly braces are interpreted as
regular expressions that must or (when preceded with \"-\") must not
match in the entry.  Snippets enclosed into double quotes will be taken
as a whole, to include whitespace.

- If the search string starts with an asterisk, search only in headlines.
- If (possibly after the leading star) the search string starts with an
  exclamation mark, this also means to look at TODO entries only, an effect
  that can also be achieved with a prefix argument.
- If (possibly after star and exclamation mark) the search string starts
  with a colon, this will mean that the (non-regexp) snippets of the
  Boolean search must match as full words.

This command searches the agenda files, and in addition the files listed
in `org-agenda-text-search-extra-files'.

\(fn &optional TODO-ONLY STRING EDIT-AT)" t nil)

(autoload 'org-todo-list "org-agenda" "\
Show all (not done) TODO entries from all agenda file in a single list.
The prefix arg can be used to select a specific TODO keyword and limit
the list to these.  When using \\[universal-argument], you will be prompted
for a keyword.  A numeric prefix directly selects the Nth keyword in
`org-todo-keywords-1'.

\(fn &optional ARG)" t nil)

(autoload 'org-tags-view "org-agenda" "\
Show all headlines for all `org-agenda-files' matching a TAGS criterion.
The prefix arg TODO-ONLY limits the search to TODO entries.

\(fn &optional TODO-ONLY MATCH)" t nil)

(autoload 'org-agenda-list-stuck-projects "org-agenda" "\
Create agenda view for projects that are stuck.
Stuck projects are project that have no next actions.  For the definitions
of what a project is and how to check if it stuck, customize the variable
`org-stuck-projects'.

\(fn &rest IGNORE)" t nil)

(autoload 'org-diary "org-agenda" "\
Return diary information from org files.
This function can be used in a \"sexp\" diary entry in the Emacs calendar.
It accesses org files and extracts information from those files to be
listed in the diary.  The function accepts arguments specifying what
items should be listed.  For a list of arguments allowed here, see the
variable `org-agenda-entry-types'.

The call in the diary file should look like this:

   &%%(org-diary) ~/path/to/some/orgfile.org

Use a separate line for each org file to check.  Or, if you omit the file name,
all files listed in `org-agenda-files' will be checked automatically:

   &%%(org-diary)

If you don't give any arguments (as in the example above), the default value
of `org-agenda-entry-types' is used: (:deadline :scheduled :timestamp :sexp).
So the example above may also be written as

   &%%(org-diary :deadline :timestamp :sexp :scheduled)

The function expects the lisp variables `entry' and `date' to be provided
by the caller, because this is how the calendar works.  Don't use this
function from a program - use `org-agenda-get-day-entries' instead.

\(fn &rest ARGS)" nil nil)

(autoload 'org-agenda-check-for-timestamp-as-reason-to-ignore-todo-item "org-agenda" "\
Do we have a reason to ignore this TODO entry because it has a time stamp?

\(fn &optional END)" nil nil)

(autoload 'org-agenda-set-restriction-lock "org-agenda" "\
Set restriction lock for agenda, to current subtree or file.
Restriction will be the file if TYPE is `file', or if type is the
universal prefix '(4), or if the cursor is before the first headline
in the file.  Otherwise, restriction will be to the current subtree.

\(fn &optional TYPE)" t nil)

(autoload 'org-calendar-goto-agenda "org-agenda" "\
Compute the Org-mode agenda for the calendar date displayed at the cursor.
This is a command that has to be installed in `calendar-mode-map'.

\(fn)" t nil)

(autoload 'org-agenda-to-appt "org-agenda" "\
Activate appointments found in `org-agenda-files'.
With a \\[universal-argument] prefix, refresh the list of
appointments.

If FILTER is t, interactively prompt the user for a regular
expression, and filter out entries that don't match it.

If FILTER is a string, use this string as a regular expression
for filtering entries out.

If FILTER is a function, filter out entries against which
calling the function returns nil.  This function takes one
argument: an entry from `org-agenda-get-day-entries'.

FILTER can also be an alist with the car of each cell being
either 'headline or 'category.  For example:

  '((headline \"IMPORTANT\")
    (category \"Work\"))

will only add headlines containing IMPORTANT or headlines
belonging to the \"Work\" category.

ARGS are symbols indicating what kind of entries to consider.
By default `org-agenda-to-appt' will use :deadline*, :scheduled*
\(i.e., deadlines and scheduled items with a hh:mm specification)
and :timestamp entries.  See the docstring of `org-diary' for
details and examples.

If an entry has a APPT_WARNTIME property, its value will be used
to override `appt-message-warning-time'.

\(fn &optional REFRESH FILTER &rest ARGS)" t nil)

;;;***

;;;### (autoloads nil "org-capture" "org/org-capture.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from org/org-capture.el

(autoload 'org-capture-string "org-capture" "\
Capture STRING with the template selected by KEYS.

\(fn STRING &optional KEYS)" t nil)

(autoload 'org-capture "org-capture" "\
Capture something.
\\<org-capture-mode-map>
This will let you select a template from `org-capture-templates', and then
file the newly captured information.  The text is immediately inserted
at the target location, and an indirect buffer is shown where you can
edit it.  Pressing \\[org-capture-finalize] brings you back to the previous state
of Emacs, so that you can continue your work.

When called interactively with a \\[universal-argument] prefix argument GOTO, don't capture
anything, just go to the file/headline where the selected template
stores its notes.  With a double prefix argument \\[universal-argument] \\[universal-argument], go to the last note
stored.

When called with a `C-0' (zero) prefix, insert a template at point.

ELisp programs can set KEYS to a string associated with a template
in `org-capture-templates'.  In this case, interactive selection
will be bypassed.

If `org-capture-use-agenda-date' is non-nil, capturing from the
agenda will use the date at point as the default date.  Then, a
`C-1' prefix will tell the capture process to use the HH:MM time
of the day at point (if any) or the current HH:MM time.

\(fn &optional GOTO KEYS)" t nil)

(autoload 'org-capture-import-remember-templates "org-capture" "\
Set `org-capture-templates' to be similar to `org-remember-templates'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "org-colview" "org/org-colview.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from org/org-colview.el

(autoload 'org-columns-remove-overlays "org-colview" "\
Remove all currently active column overlays.

\(fn)" t nil)

(autoload 'org-columns-get-format-and-top-level "org-colview" "\


\(fn)" nil nil)

(autoload 'org-columns "org-colview" "\
Turn on column view on an org-mode file.
When COLUMNS-FMT-STRING is non-nil, use it as the column format.

\(fn &optional COLUMNS-FMT-STRING)" t nil)

(autoload 'org-columns-compute "org-colview" "\
Sum the values of property PROPERTY hierarchically, for the entire buffer.

\(fn PROPERTY)" t nil)

(autoload 'org-columns-number-to-string "org-colview" "\
Convert a computed column number to a string value, according to FMT.

\(fn N FMT &optional PRINTF)" nil nil)

(autoload 'org-dblock-write:columnview "org-colview" "\
Write the column view table.
PARAMS is a property list of parameters:

:width    enforce same column widths with <N> specifiers.
:id       the :ID: property of the entry where the columns view
	  should be built.  When the symbol `local', call locally.
	  When `global' call column view with the cursor at the beginning
	  of the buffer (usually this means that the whole buffer switches
	  to column view).  When \"file:path/to/file.org\", invoke column
	  view at the start of that file.  Otherwise, the ID is located
	  using `org-id-find'.
:hlines   When t, insert a hline before each item.  When a number, insert
	  a hline before each level <= that number.
:vlines   When t, make each column a colgroup to enforce vertical lines.
:maxlevel When set to a number, don't capture headlines below this level.
:skip-empty-rows
	  When t, skip rows where all specifiers other than ITEM are empty.
:format   When non-nil, specify the column view format to use.

\(fn PARAMS)" nil nil)

(autoload 'org-insert-columns-dblock "org-colview" "\
Create a dynamic block capturing a column view table.

\(fn)" t nil)

(autoload 'org-agenda-columns "org-colview" "\
Turn on or update column view in the agenda.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "org-compat" "org/org-compat.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from org/org-compat.el

(autoload 'org-check-version "org-compat" "\
Try very hard to provide sensible version strings.

\(fn)" nil t)

;;;***

;;;### (autoloads nil "org-macs" "org/org-macs.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from org/org-macs.el

(autoload 'org-load-noerror-mustsuffix "org-macs" "\
Load FILE with optional arguments NOERROR and MUSTSUFFIX.  Drop the MUSTSUFFIX argument for XEmacs, which doesn't recognize it.

\(fn FILE)" nil t)

;;;***

;;;### (autoloads nil "org-version" "org/org-version.el" (21676 8646
;;;;;;  0 0))
;;; Generated autoloads from org/org-version.el

(autoload 'org-release "org-version" "\
The release version of org-mode.
  Inserted by installing org-mode or when a release is made.

\(fn)" nil nil)

(autoload 'org-git-version "org-version" "\
The Git version of org-mode.
  Inserted by installing org-mode or when a release is made.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "outline" "outline.el" (21788 61018 0 0))
;;; Generated autoloads from outline.el
(put 'outline-regexp 'safe-local-variable 'stringp)
(put 'outline-heading-end-regexp 'safe-local-variable 'stringp)

(autoload 'outline-mode "outline" "\
Set major mode for editing outlines with selective display.
Headings are lines which start with asterisks: one for major headings,
two for subheadings, etc.  Lines not starting with asterisks are body lines.

Body text or subheadings under a heading can be made temporarily
invisible, or visible again.  Invisible lines are attached to the end
of the heading, so they move with it, if the line is killed and yanked
back.  A heading with text hidden under it is marked with an ellipsis (...).

Commands:\\<outline-mode-map>
\\[outline-next-visible-heading]   outline-next-visible-heading      move by visible headings
\\[outline-previous-visible-heading]   outline-previous-visible-heading
\\[outline-forward-same-level]   outline-forward-same-level        similar but skip subheadings
\\[outline-backward-same-level]   outline-backward-same-level
\\[outline-up-heading]   outline-up-heading		    move from subheading to heading

\\[hide-body]	make all text invisible (not headings).
\\[show-all]	make everything in buffer visible.
\\[hide-sublevels]  make only the first N levels of headers visible.

The remaining commands are used when point is on a heading line.
They apply to some of the body or subheadings of that heading.
\\[hide-subtree]   hide-subtree	make body and subheadings invisible.
\\[show-subtree]   show-subtree	make body and subheadings visible.
\\[show-children]   show-children	make direct subheadings visible.
		 No effect on body, or subheadings 2 or more levels down.
		 With arg N, affects subheadings N levels down.
\\[hide-entry]	   make immediately following body invisible.
\\[show-entry]	   make it visible.
\\[hide-leaves]	   make body under heading and under its subheadings invisible.
		     The subheadings remain visible.
\\[show-branches]  make all subheadings at all levels visible.

The variable `outline-regexp' can be changed to control what is a heading.
A line is a heading if `outline-regexp' matches something at the
beginning of the line.  The longer the match, the deeper the level.

Turning on outline mode calls the value of `text-mode-hook' and then of
`outline-mode-hook', if they are non-nil.

\(fn)" t nil)

(autoload 'outline-minor-mode "outline" "\
Toggle Outline minor mode.
With a prefix argument ARG, enable Outline minor mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

See the command `outline-mode' for more information on this mode.

\(fn &optional ARG)" t nil)
(put 'outline-level 'risky-local-variable t)

;;;***

;;;### (autoloads nil "package" "emacs-lisp/package.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/package.el
(push (purecopy '(package 1 0 1)) package--builtin-versions)

(defvar package-enable-at-startup t "\
Whether to activate installed packages when Emacs starts.
If non-nil, packages are activated after reading the init file
and before `after-init-hook'.  Activation is not done if
`user-init-file' is nil (e.g. Emacs was started with \"-q\").

Even if the value is nil, you can type \\[package-initialize] to
activate the package system at any time.")

(custom-autoload 'package-enable-at-startup "package" t)

(autoload 'package-install "package" "\
Install the package PKG.
PKG can be a package-desc or the package name of one the available packages
in an archive in `package-archives'.  Interactively, prompt for its name.

\(fn PKG)" t nil)

(autoload 'package-install-from-buffer "package" "\
Install a package from the current buffer.
The current buffer is assumed to be a single .el or .tar file that follows the
packaging guidelines; see info node `(elisp)Packaging'.
Downloads and installs required packages as needed.

\(fn)" t nil)

(autoload 'package-install-file "package" "\
Install a package from a file.
The file can either be a tar file or an Emacs Lisp file.

\(fn FILE)" t nil)

(autoload 'package-import-keyring "package" "\
Import keys from FILE.

\(fn &optional FILE)" t nil)

(autoload 'package-refresh-contents "package" "\
Download the ELPA archive description if needed.
This informs Emacs about the latest versions of all packages, and
makes them available for download.

\(fn)" t nil)

(autoload 'package-initialize "package" "\
Load Emacs Lisp packages, and activate them.
The variable `package-load-list' controls which packages to load.
If optional arg NO-ACTIVATE is non-nil, don't activate packages.

\(fn &optional NO-ACTIVATE)" t nil)

(autoload 'describe-package "package" "\
Display the full documentation of PACKAGE (a symbol).

\(fn PACKAGE)" t nil)

(autoload 'list-packages "package" "\
Display a list of packages.
This first fetches the updated list of packages before
displaying, unless a prefix argument NO-FETCH is specified.
The list is displayed in a buffer named `*Packages*'.

\(fn &optional NO-FETCH)" t nil)

(defalias 'package-list-packages 'list-packages)

;;;***

;;;### (autoloads nil "paren" "paren.el" (21788 61018 0 0))
;;; Generated autoloads from paren.el

(defvar show-paren-mode nil "\
Non-nil if Show-Paren mode is enabled.
See the command `show-paren-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `show-paren-mode'.")

(custom-autoload 'show-paren-mode "paren" nil)

(autoload 'show-paren-mode "paren" "\
Toggle visualization of matching parens (Show Paren mode).
With a prefix argument ARG, enable Show Paren mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Show Paren mode is a global minor mode.  When enabled, any
matching parenthesis is highlighted in `show-paren-style' after
`show-paren-delay' seconds of Emacs idle time.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "parse-time" "calendar/parse-time.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from calendar/parse-time.el
(put 'parse-time-rules 'risky-local-variable t)

(autoload 'parse-time-string "parse-time" "\
Parse the time-string STRING into (SEC MIN HOUR DAY MON YEAR DOW DST TZ).
The values are identical to those of `decode-time', but any values that are
unknown are returned as nil.

\(fn STRING)" nil nil)

;;;***

;;;### (autoloads nil "pascal" "progmodes/pascal.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/pascal.el

(autoload 'pascal-mode "pascal" "\
Major mode for editing Pascal code.\\<pascal-mode-map>
TAB indents for Pascal code.  Delete converts tabs to spaces as it moves back.

\\[completion-at-point] completes the word around current point with respect to position in code
\\[completion-help-at-point] shows all possible completions at this point.

Other useful functions are:

\\[pascal-mark-defun]	- Mark function.
\\[pascal-insert-block]	- insert begin ... end;
\\[pascal-star-comment]	- insert (* ... *)
\\[pascal-comment-area]	- Put marked area in a comment, fixing nested comments.
\\[pascal-uncomment-area]	- Uncomment an area commented with \\[pascal-comment-area].
\\[pascal-beg-of-defun]	- Move to beginning of current function.
\\[pascal-end-of-defun]	- Move to end of current function.
\\[pascal-goto-defun]	- Goto function prompted for in the minibuffer.
\\[pascal-outline-mode]	- Enter `pascal-outline-mode'.

Variables controlling indentation/edit style:

 `pascal-indent-level' (default 3)
    Indentation of Pascal statements with respect to containing block.
 `pascal-case-indent' (default 2)
    Indentation for case statements.
 `pascal-auto-newline' (default nil)
    Non-nil means automatically newline after semicolons and the punctuation
    mark after an end.
 `pascal-indent-nested-functions' (default t)
    Non-nil means nested functions are indented.
 `pascal-tab-always-indent' (default t)
    Non-nil means TAB in Pascal mode should always reindent the current line,
    regardless of where in the line point is when the TAB command is used.
 `pascal-auto-endcomments' (default t)
    Non-nil means a comment { ... } is set after the ends which ends cases and
    functions. The name of the function or case will be set between the braces.
 `pascal-auto-lineup' (default t)
    List of contexts where auto lineup of :'s or ='s should be done.

See also the user variables `pascal-type-keywords', `pascal-start-keywords' and
`pascal-separator-keywords'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "password-cache" "password-cache.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from password-cache.el

(defvar password-cache t "\
Whether to cache passwords.")

(custom-autoload 'password-cache "password-cache" t)

(defvar password-cache-expiry 16 "\
How many seconds passwords are cached, or nil to disable expiring.
Whether passwords are cached at all is controlled by `password-cache'.")

(custom-autoload 'password-cache-expiry "password-cache" t)

(autoload 'password-in-cache-p "password-cache" "\
Check if KEY is in the cache.

\(fn KEY)" nil nil)

;;;***

;;;### (autoloads nil "pcase" "emacs-lisp/pcase.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/pcase.el

(autoload 'pcase "pcase" "\
Perform ML-style pattern matching on EXP.
CASES is a list of elements of the form (UPATTERN CODE...).

UPatterns can take the following forms:
  _		matches anything.
  SELFQUOTING	matches itself.  This includes keywords, numbers, and strings.
  SYMBOL	matches anything and binds it to SYMBOL.
  (or UPAT...)	matches if any of the patterns matches.
  (and UPAT...)	matches if all the patterns match.
  `QPAT		matches if the QPattern QPAT matches.
  (pred PRED)	matches if PRED applied to the object returns non-nil.
  (guard BOOLEXP)	matches if BOOLEXP evaluates to non-nil.
  (let UPAT EXP)	matches if EXP matches UPAT.
If a SYMBOL is used twice in the same pattern (i.e. the pattern is
\"non-linear\"), then the second occurrence is turned into an `eq'uality test.

QPatterns can take the following forms:
  (QPAT1 . QPAT2)	matches if QPAT1 matches the car and QPAT2 the cdr.
  ,UPAT			matches if the UPattern UPAT matches.
  STRING		matches if the object is `equal' to STRING.
  ATOM			matches if the object is `eq' to ATOM.
QPatterns for vectors are not implemented yet.

PRED can take the form
  FUNCTION	     in which case it gets called with one argument.
  (FUN ARG1 .. ARGN) in which case it gets called with an N+1'th argument
                        which is the value being matched.
A PRED of the form FUNCTION is equivalent to one of the form (FUNCTION).
PRED patterns can refer to variables bound earlier in the pattern.
E.g. you can match pairs where the cdr is larger than the car with a pattern
like `(,a . ,(pred (< a))) or, with more checks:
`(,(and a (pred numberp)) . ,(and (pred numberp) (pred (< a))))

\(fn EXP &rest CASES)" nil t)

(put 'pcase 'lisp-indent-function '1)

(autoload 'pcase-let* "pcase" "\
Like `let*' but where you can use `pcase' patterns for bindings.
BODY should be an expression, and BINDINGS should be a list of bindings
of the form (UPAT EXP).

\(fn BINDINGS &rest BODY)" nil t)

(put 'pcase-let* 'lisp-indent-function '1)

(autoload 'pcase-let "pcase" "\
Like `let' but where you can use `pcase' patterns for bindings.
BODY should be a list of expressions, and BINDINGS should be a list of bindings
of the form (UPAT EXP).

\(fn BINDINGS &rest BODY)" nil t)

(put 'pcase-let 'lisp-indent-function '1)

;;;***

;;;### (autoloads nil "pcmpl-cvs" "pcmpl-cvs.el" (21710 25077 0 0))
;;; Generated autoloads from pcmpl-cvs.el

(autoload 'pcomplete/cvs "pcmpl-cvs" "\
Completion rules for the `cvs' command.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "pcmpl-gnu" "pcmpl-gnu.el" (21788 61018 0 0))
;;; Generated autoloads from pcmpl-gnu.el

(autoload 'pcomplete/gzip "pcmpl-gnu" "\
Completion for `gzip'.

\(fn)" nil nil)

(autoload 'pcomplete/bzip2 "pcmpl-gnu" "\
Completion for `bzip2'.

\(fn)" nil nil)

(autoload 'pcomplete/make "pcmpl-gnu" "\
Completion for GNU `make'.

\(fn)" nil nil)

(autoload 'pcomplete/tar "pcmpl-gnu" "\
Completion for the GNU tar utility.

\(fn)" nil nil)

(defalias 'pcomplete/gdb 'pcomplete/xargs)

;;;***

;;;### (autoloads nil "pcmpl-linux" "pcmpl-linux.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from pcmpl-linux.el

(autoload 'pcomplete/kill "pcmpl-linux" "\
Completion for GNU/Linux `kill', using /proc filesystem.

\(fn)" nil nil)

(autoload 'pcomplete/umount "pcmpl-linux" "\
Completion for GNU/Linux `umount'.

\(fn)" nil nil)

(autoload 'pcomplete/mount "pcmpl-linux" "\
Completion for GNU/Linux `mount'.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "pcmpl-rpm" "pcmpl-rpm.el" (21710 25077 0 0))
;;; Generated autoloads from pcmpl-rpm.el

(autoload 'pcomplete/rpm "pcmpl-rpm" "\
Completion for the `rpm' command.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "pcmpl-unix" "pcmpl-unix.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from pcmpl-unix.el

(autoload 'pcomplete/cd "pcmpl-unix" "\
Completion for `cd'.

\(fn)" nil nil)

(defalias 'pcomplete/pushd 'pcomplete/cd)

(autoload 'pcomplete/rmdir "pcmpl-unix" "\
Completion for `rmdir'.

\(fn)" nil nil)

(autoload 'pcomplete/rm "pcmpl-unix" "\
Completion for `rm'.

\(fn)" nil nil)

(autoload 'pcomplete/xargs "pcmpl-unix" "\
Completion for `xargs'.

\(fn)" nil nil)

(defalias 'pcomplete/time 'pcomplete/xargs)

(autoload 'pcomplete/which "pcmpl-unix" "\
Completion for `which'.

\(fn)" nil nil)

(autoload 'pcomplete/chown "pcmpl-unix" "\
Completion for the `chown' command.

\(fn)" nil nil)

(autoload 'pcomplete/chgrp "pcmpl-unix" "\
Completion for the `chgrp' command.

\(fn)" nil nil)

(autoload 'pcomplete/ssh "pcmpl-unix" "\
Completion rules for the `ssh' command.

\(fn)" nil nil)

(autoload 'pcomplete/scp "pcmpl-unix" "\
Completion rules for the `scp' command.
Includes files as well as host names followed by a colon.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "pcmpl-x" "pcmpl-x.el" (21710 25077 0 0))
;;; Generated autoloads from pcmpl-x.el

(autoload 'pcomplete/tlmgr "pcmpl-x" "\
Completion for the `tlmgr' command.

\(fn)" nil nil)

(autoload 'pcomplete/ack "pcmpl-x" "\
Completion for the `ack' command.
Start an argument with '-' to complete short options and '--' for
long options.

\(fn)" nil nil)

(defalias 'pcomplete/ack-grep 'pcomplete/ack)

(autoload 'pcomplete/ag "pcmpl-x" "\
Completion for the `ag' command.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "pcomplete" "pcomplete.el" (21710 25077 0 0))
;;; Generated autoloads from pcomplete.el

(autoload 'pcomplete "pcomplete" "\
Support extensible programmable completion.
To use this function, just bind the TAB key to it, or add it to your
completion functions list (it should occur fairly early in the list).

\(fn &optional INTERACTIVELY)" t nil)

(autoload 'pcomplete-reverse "pcomplete" "\
If cycling completion is in use, cycle backwards.

\(fn)" t nil)

(autoload 'pcomplete-expand-and-complete "pcomplete" "\
Expand the textual value of the current argument.
This will modify the current buffer.

\(fn)" t nil)

(autoload 'pcomplete-continue "pcomplete" "\
Complete without reference to any cycling completions.

\(fn)" t nil)

(autoload 'pcomplete-expand "pcomplete" "\
Expand the textual value of the current argument.
This will modify the current buffer.

\(fn)" t nil)

(autoload 'pcomplete-help "pcomplete" "\
Display any help information relative to the current argument.

\(fn)" t nil)

(autoload 'pcomplete-list "pcomplete" "\
Show the list of possible completions for the current argument.

\(fn)" t nil)

(autoload 'pcomplete-comint-setup "pcomplete" "\
Setup a comint buffer to use pcomplete.
COMPLETEF-SYM should be the symbol where the
dynamic-complete-functions are kept.  For comint mode itself,
this is `comint-dynamic-complete-functions'.

\(fn COMPLETEF-SYM)" nil nil)

(autoload 'pcomplete-shell-setup "pcomplete" "\
Setup `shell-mode' to use pcomplete.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "pcvs" "vc/pcvs.el" (21710 25077 0 0))
;;; Generated autoloads from vc/pcvs.el

(autoload 'cvs-checkout "pcvs" "\
Run a `cvs checkout MODULES' in DIR.
Feed the output to a *cvs* buffer, display it in the current window,
and run `cvs-mode' on it.

With a prefix argument, prompt for cvs FLAGS to use.

\(fn MODULES DIR FLAGS &optional ROOT)" t nil)

(autoload 'cvs-quickdir "pcvs" "\
Open a *cvs* buffer on DIR without running cvs.
With a prefix argument, prompt for a directory to use.
A prefix arg >8 (ex: \\[universal-argument] \\[universal-argument]),
  prevents reuse of an existing *cvs* buffer.
Optional argument NOSHOW if non-nil means not to display the buffer.
FLAGS is ignored.

\(fn DIR &optional FLAGS NOSHOW)" t nil)

(autoload 'cvs-examine "pcvs" "\
Run a `cvs -n update' in the specified DIRECTORY.
That is, check what needs to be done, but don't change the disc.
Feed the output to a *cvs* buffer and run `cvs-mode' on it.
With a prefix argument, prompt for a directory and cvs FLAGS to use.
A prefix arg >8 (ex: \\[universal-argument] \\[universal-argument]),
  prevents reuse of an existing *cvs* buffer.
Optional argument NOSHOW if non-nil means not to display the buffer.

\(fn DIRECTORY FLAGS &optional NOSHOW)" t nil)

(autoload 'cvs-update "pcvs" "\
Run a `cvs update' in the current working DIRECTORY.
Feed the output to a *cvs* buffer and run `cvs-mode' on it.
With a \\[universal-argument] prefix argument, prompt for a directory to use.
A prefix arg >8 (ex: \\[universal-argument] \\[universal-argument]),
  prevents reuse of an existing *cvs* buffer.
The prefix is also passed to `cvs-flags-query' to select the FLAGS
  passed to cvs.

\(fn DIRECTORY FLAGS)" t nil)

(autoload 'cvs-status "pcvs" "\
Run a `cvs status' in the current working DIRECTORY.
Feed the output to a *cvs* buffer and run `cvs-mode' on it.
With a prefix argument, prompt for a directory and cvs FLAGS to use.
A prefix arg >8 (ex: \\[universal-argument] \\[universal-argument]),
  prevents reuse of an existing *cvs* buffer.
Optional argument NOSHOW if non-nil means not to display the buffer.

\(fn DIRECTORY FLAGS &optional NOSHOW)" t nil)

(defvar cvs-dired-action 'cvs-quickdir "\
The action to be performed when opening a CVS directory.
Sensible values are `cvs-examine', `cvs-status' and `cvs-quickdir'.")

(custom-autoload 'cvs-dired-action "pcvs" t)

(defvar cvs-dired-use-hook '(4) "\
Whether or not opening a CVS directory should run PCL-CVS.
A value of nil means never do it.
`always' means to always do it unless a prefix argument is given to the
  command that prompted the opening of the directory.
Anything else means to do it only if the prefix arg is equal to this value.")

(custom-autoload 'cvs-dired-use-hook "pcvs" t)

(defun cvs-dired-noselect (dir) "\
Run `cvs-examine' if DIR is a CVS administrative directory.
The exact behavior is determined also by `cvs-dired-use-hook'." (when (stringp dir) (setq dir (directory-file-name dir)) (when (and (string= "CVS" (file-name-nondirectory dir)) (file-readable-p (expand-file-name "Entries" dir)) cvs-dired-use-hook (if (eq cvs-dired-use-hook (quote always)) (not current-prefix-arg) (equal current-prefix-arg cvs-dired-use-hook))) (save-excursion (funcall cvs-dired-action (file-name-directory dir) t t)))))

;;;***

;;;### (autoloads nil "pcvs-defs" "vc/pcvs-defs.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from vc/pcvs-defs.el

(defvar cvs-global-menu (let ((m (make-sparse-keymap "PCL-CVS"))) (define-key m [status] `(menu-item ,(purecopy "Directory Status") cvs-status :help ,(purecopy "A more verbose status of a workarea"))) (define-key m [checkout] `(menu-item ,(purecopy "Checkout Module") cvs-checkout :help ,(purecopy "Check out a module from the repository"))) (define-key m [update] `(menu-item ,(purecopy "Update Directory") cvs-update :help ,(purecopy "Fetch updates from the repository"))) (define-key m [examine] `(menu-item ,(purecopy "Examine Directory") cvs-examine :help ,(purecopy "Examine the current state of a workarea"))) (fset 'cvs-global-menu m)) "\
Global menu used by PCL-CVS.")

;;;***

;;;### (autoloads nil "perl-mode" "progmodes/perl-mode.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from progmodes/perl-mode.el
(put 'perl-indent-level 'safe-local-variable 'integerp)
(put 'perl-continued-statement-offset 'safe-local-variable 'integerp)
(put 'perl-continued-brace-offset 'safe-local-variable 'integerp)
(put 'perl-brace-offset 'safe-local-variable 'integerp)
(put 'perl-brace-imaginary-offset 'safe-local-variable 'integerp)
(put 'perl-label-offset 'safe-local-variable 'integerp)

(autoload 'perl-mode "perl-mode" "\
Major mode for editing Perl code.
Expression and list commands understand all Perl brackets.
Tab indents for Perl code.
Comments are delimited with # ... \\n.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.
\\{perl-mode-map}
Variables controlling indentation style:
 `perl-tab-always-indent'
    Non-nil means TAB in Perl mode should always indent the current line,
    regardless of where in the line point is when the TAB command is used.
 `perl-tab-to-comment'
    Non-nil means that for lines which don't need indenting, TAB will
    either delete an empty comment, indent an existing comment, move
    to end-of-line, or if at end-of-line already, create a new comment.
 `perl-nochange'
    Lines starting with this regular expression are not auto-indented.
 `perl-indent-level'
    Indentation of Perl statements within surrounding block.
    The surrounding block's indentation is the indentation
    of the line on which the open-brace appears.
 `perl-continued-statement-offset'
    Extra indentation given to a substatement, such as the
    then-clause of an if or body of a while.
 `perl-continued-brace-offset'
    Extra indentation given to a brace that starts a substatement.
    This is in addition to `perl-continued-statement-offset'.
 `perl-brace-offset'
    Extra indentation for line if it starts with an open brace.
 `perl-brace-imaginary-offset'
    An open brace following other text is treated as if it were
    this far to the right of the start of its line.
 `perl-label-offset'
    Extra indentation for line that is a label.
 `perl-indent-continued-arguments'
    Offset of argument lines relative to usual indentation.

Various indentation styles:       K&R  BSD  BLK  GNU  LW
  perl-indent-level                5    8    0    2    4
  perl-continued-statement-offset  5    8    4    2    4
  perl-continued-brace-offset      0    0    0    0   -4
  perl-brace-offset               -5   -8    0    0    0
  perl-brace-imaginary-offset      0    0    4    0    0
  perl-label-offset               -5   -8   -2   -2   -2

Turning on Perl mode runs the normal hook `perl-mode-hook'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "picture" "textmodes/picture.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from textmodes/picture.el

(autoload 'picture-mode "picture" "\
Switch to Picture mode, in which a quarter-plane screen model is used.
\\<picture-mode-map>
Printing characters replace instead of inserting themselves with motion
afterwards settable by these commands:

 Move left after insertion:            \\[picture-movement-left]
 Move right after insertion:           \\[picture-movement-right]
 Move up after insertion:              \\[picture-movement-up]
 Move down after insertion:            \\[picture-movement-down]

 Move northwest (nw) after insertion:  \\[picture-movement-nw]
 Move northeast (ne) after insertion:  \\[picture-movement-ne]
 Move southwest (sw) after insertion:  \\[picture-movement-sw]
 Move southeast (se) after insertion:  \\[picture-movement-se]

 Move westnorthwest (wnw) after insertion:  C-u \\[picture-movement-nw]
 Move eastnortheast (ene) after insertion:  C-u \\[picture-movement-ne]
 Move westsouthwest (wsw) after insertion:  C-u \\[picture-movement-sw]
 Move eastsoutheast (ese) after insertion:  C-u \\[picture-movement-se]

The current direction is displayed in the mode line.  The initial
direction is right.  Whitespace is inserted and tabs are changed to
spaces when required by movement.  You can move around in the buffer
with these commands:

 Move vertically to SAME column in previous line: \\[picture-move-down]
 Move vertically to SAME column in next line:     \\[picture-move-up]
 Move to column following last
  non-whitespace character:                       \\[picture-end-of-line]
 Move right, inserting spaces if required:        \\[picture-forward-column]
 Move left changing tabs to spaces if required:   \\[picture-backward-column]
 Move in direction of current picture motion:     \\[picture-motion]
 Move opposite to current picture motion:         \\[picture-motion-reverse]
 Move to beginning of next line:                  \\[next-line]

You can edit tabular text with these commands:

 Move to column beneath (or at) next interesting
  character (see variable `picture-tab-chars'):   \\[picture-tab-search]
 Move to next stop in tab stop list:              \\[picture-tab]
 Set tab stops according to context of this line: \\[picture-set-tab-stops]
   (With ARG, resets tab stops to default value.)
 Change the tab stop list:                        \\[edit-tab-stops]

You can manipulate text with these commands:
 Clear ARG columns after point without moving:    \\[picture-clear-column]
 Delete char at point:                            \\[picture-delete-char]
 Clear ARG columns backward:                      \\[picture-backward-clear-column]
 Clear ARG lines, advancing over them:            \\[picture-clear-line]
  (the cleared text is saved in the kill ring)
 Open blank line(s) beneath current line:         \\[picture-open-line]

You can manipulate rectangles with these commands:
  Clear a rectangle and save it:                  \\[picture-clear-rectangle]
  Clear a rectangle, saving in a named register:  \\[picture-clear-rectangle-to-register]
  Insert currently saved rectangle at point:      \\[picture-yank-rectangle]
  Insert rectangle from named register:           \\[picture-yank-rectangle-from-register]
  Draw a rectangular box around mark and point:   \\[picture-draw-rectangle]
  Copies a rectangle to a register:               \\[copy-rectangle-to-register]
  Undo effects of rectangle overlay commands:     \\[undo]

You can return to the previous mode with \\[picture-mode-exit], which
also strips trailing whitespace from every line.  Stripping is suppressed
by supplying an argument.

Entry to this mode calls the value of `picture-mode-hook' if non-nil.

Note that Picture mode commands will work outside of Picture mode, but
they are not by default assigned to keys.

\(fn)" t nil)

(defalias 'edit-picture 'picture-mode)

;;;***

;;;### (autoloads nil "plstore" "gnus/plstore.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from gnus/plstore.el

(autoload 'plstore-open "plstore" "\
Create a plstore instance associated with FILE.

\(fn FILE)" nil nil)

(autoload 'plstore-mode "plstore" "\
Major mode for editing PLSTORE files.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "po" "textmodes/po.el" (21710 25077 0 0))
;;; Generated autoloads from textmodes/po.el

(autoload 'po-find-file-coding-system "po" "\
Return a (DECODING . ENCODING) pair, according to PO file's charset.
Called through `file-coding-system-alist', before the file is visited for real.

\(fn ARG-LIST)" nil nil)

;;;***

;;;### (autoloads nil "pong" "play/pong.el" (21710 25077 0 0))
;;; Generated autoloads from play/pong.el

(autoload 'pong "pong" "\
Play pong and waste time.
This is an implementation of the classical game pong.
Move left and right bats and try to bounce the ball to your opponent.

pong-mode keybindings:\\<pong-mode-map>

\\{pong-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "pop3" "gnus/pop3.el" (21788 61018 0 0))
;;; Generated autoloads from gnus/pop3.el

(autoload 'pop3-movemail "pop3" "\
Transfer contents of a maildrop to the specified FILE.
Use streaming commands.

\(fn FILE)" nil nil)

;;;***

;;;### (autoloads nil "pp" "emacs-lisp/pp.el" (21788 61018 0 0))
;;; Generated autoloads from emacs-lisp/pp.el

(autoload 'pp-to-string "pp" "\
Return a string containing the pretty-printed representation of OBJECT.
OBJECT can be any Lisp object.  Quoting characters are used as needed
to make output that `read' can handle, whenever this is possible.

\(fn OBJECT)" nil nil)

(autoload 'pp-buffer "pp" "\
Prettify the current buffer with printed representation of a Lisp object.

\(fn)" nil nil)

(autoload 'pp "pp" "\
Output the pretty-printed representation of OBJECT, any Lisp object.
Quoting characters are printed as needed to make output that `read'
can handle, whenever this is possible.
Output stream is STREAM, or value of `standard-output' (which see).

\(fn OBJECT &optional STREAM)" nil nil)

(autoload 'pp-eval-expression "pp" "\
Evaluate EXPRESSION and pretty-print its value.
Also add the value to the front of the list in the variable `values'.

\(fn EXPRESSION)" t nil)

(autoload 'pp-macroexpand-expression "pp" "\
Macroexpand EXPRESSION and pretty-print its value.

\(fn EXPRESSION)" t nil)

(autoload 'pp-eval-last-sexp "pp" "\
Run `pp-eval-expression' on sexp before point.
With argument, pretty-print output into current buffer.
Ignores leading comment characters.

\(fn ARG)" t nil)

(autoload 'pp-macroexpand-last-sexp "pp" "\
Run `pp-macroexpand-expression' on sexp before point.
With argument, pretty-print output into current buffer.
Ignores leading comment characters.

\(fn ARG)" t nil)

;;;***

;;;### (autoloads nil "printing" "printing.el" (21788 61018 0 0))
;;; Generated autoloads from printing.el
(push (purecopy '(printing 6 9 3)) package--builtin-versions)

(autoload 'pr-interface "printing" "\
Activate the printing interface buffer.

If BUFFER is nil, the current buffer is used for printing.

For more information, type \\[pr-interface-help].

\(fn &optional BUFFER)" t nil)

(autoload 'pr-ps-directory-preview "printing" "\
Preview directory using ghostview.

Interactively, the command prompts for N-UP printing number, a directory, a
file name regexp for matching and, when you use a prefix argument (C-u), the
command prompts the user for a file name, and saves the PostScript image in
that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  If DIR is
nil, prompts for DIRectory.  If FILE-REGEXP is nil, prompts for
FILE(name)-REGEXP.  The argument FILENAME is treated as follows: if it's nil,
save the image in a temporary file.  If FILENAME is a string, save the
PostScript image in a file with that name.  If FILENAME is t, prompts for a
file name.

See also documentation for `pr-list-directory'.

\(fn N-UP DIR FILE-REGEXP &optional FILENAME)" t nil)

(autoload 'pr-ps-directory-using-ghostscript "printing" "\
Print directory using PostScript through ghostscript.

Interactively, the command prompts for N-UP printing number, a directory, a
file name regexp for matching and, when you use a prefix argument (C-u), the
command prompts the user for a file name, and saves the PostScript image in
that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  If DIR is
nil, prompts for DIRectory.  If FILE-REGEXP is nil, prompts for
FILE(name)-REGEXP.  The argument FILENAME is treated as follows: if it's nil,
save the image in a temporary file.  If FILENAME is a string, save the
PostScript image in a file with that name.  If FILENAME is t, prompts for a
file name.

See also documentation for `pr-list-directory'.

\(fn N-UP DIR FILE-REGEXP &optional FILENAME)" t nil)

(autoload 'pr-ps-directory-print "printing" "\
Print directory using PostScript printer.

Interactively, the command prompts for N-UP printing number, a directory, a
file name regexp for matching and, when you use a prefix argument (C-u), the
command prompts the user for a file name, and saves the PostScript image in
that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  If DIR is
nil, prompts for DIRectory.  If FILE-REGEXP is nil, prompts for
FILE(name)-REGEXP.  The argument FILENAME is treated as follows: if it's nil,
save the image in a temporary file.  If FILENAME is a string, save the
PostScript image in a file with that name.  If FILENAME is t, prompts for a
file name.

See also documentation for `pr-list-directory'.

\(fn N-UP DIR FILE-REGEXP &optional FILENAME)" t nil)

(autoload 'pr-ps-directory-ps-print "printing" "\
Print directory using PostScript printer or through ghostscript.

It depends on `pr-print-using-ghostscript'.

Interactively, the command prompts for N-UP printing number, a directory, a
file name regexp for matching and, when you use a prefix argument (C-u), the
command prompts the user for a file name, and saves the PostScript image in
that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  If DIR is
nil, prompts for DIRectory.  If FILE-REGEXP is nil, prompts for
FILE(name)-REGEXP.  The argument FILENAME is treated as follows: if it's nil,
save the image in a temporary file.  If FILENAME is a string, save the
PostScript image in a file with that name.  If FILENAME is t, prompts for a
file name.

See also documentation for `pr-list-directory'.

\(fn N-UP DIR FILE-REGEXP &optional FILENAME)" t nil)

(autoload 'pr-ps-buffer-preview "printing" "\
Preview buffer using ghostview.

Interactively, the command prompts for N-UP printing number and, when you use a
prefix argument (C-u), the command prompts the user for a file name, and saves
the PostScript image in that file instead of saving it in a temporary file.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  The
argument FILENAME is treated as follows: if it's nil, save the image in a
temporary file.  If FILENAME is a string, save the PostScript image in a file
with that name.  If FILENAME is t, prompts for a file name.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-buffer-using-ghostscript "printing" "\
Print buffer using PostScript through ghostscript.

Interactively, the command prompts for N-UP printing number and, when you use a
prefix argument (C-u), the command prompts the user for a file name, and saves
the PostScript image in that file instead of sending it to the printer.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  The
argument FILENAME is treated as follows: if it's nil, send the image to the
printer.  If FILENAME is a string, save the PostScript image in a file with
that name.  If FILENAME is t, prompts for a file name.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-buffer-print "printing" "\
Print buffer using PostScript printer.

Interactively, the command prompts for N-UP printing number and, when you use a
prefix argument (C-u), the command prompts the user for a file name, and saves
the PostScript image in that file instead of sending it to the printer.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  The
argument FILENAME is treated as follows: if it's nil, send the image to the
printer.  If FILENAME is a string, save the PostScript image in a file with
that name.  If FILENAME is t, prompts for a file name.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-buffer-ps-print "printing" "\
Print buffer using PostScript printer or through ghostscript.

It depends on `pr-print-using-ghostscript'.

Interactively, the command prompts for N-UP printing number and, when you use a
prefix argument (C-u), the command prompts the user for a file name, and saves
the PostScript image in that file instead of sending it to the printer.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  The
argument FILENAME is treated as follows: if it's nil, send the image to the
printer.  If FILENAME is a string, save the PostScript image in a file with
that name.  If FILENAME is t, prompts for a file name.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-region-preview "printing" "\
Preview region using ghostview.

See also `pr-ps-buffer-preview'.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-region-using-ghostscript "printing" "\
Print region using PostScript through ghostscript.

See also `pr-ps-buffer-using-ghostscript'.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-region-print "printing" "\
Print region using PostScript printer.

See also `pr-ps-buffer-print'.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-region-ps-print "printing" "\
Print region using PostScript printer or through ghostscript.

See also `pr-ps-buffer-ps-print'.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-mode-preview "printing" "\
Preview major mode using ghostview.

See also `pr-ps-buffer-preview'.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-mode-using-ghostscript "printing" "\
Print major mode using PostScript through ghostscript.

See also `pr-ps-buffer-using-ghostscript'.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-mode-print "printing" "\
Print major mode using PostScript printer.

See also `pr-ps-buffer-print'.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-ps-mode-ps-print "printing" "\
Print major mode using PostScript or through ghostscript.

See also `pr-ps-buffer-ps-print'.

\(fn N-UP &optional FILENAME)" t nil)

(autoload 'pr-printify-directory "printing" "\
Replace nonprinting characters in directory with printable representations.
The printable representations use ^ (for ASCII control characters) or hex.
The characters tab, linefeed, space, return and formfeed are not affected.

Interactively, the command prompts for a directory and a file name regexp for
matching.

Noninteractively, if DIR is nil, prompts for DIRectory.  If FILE-REGEXP is nil,
prompts for FILE(name)-REGEXP.

See also documentation for `pr-list-directory'.

\(fn &optional DIR FILE-REGEXP)" t nil)

(autoload 'pr-printify-buffer "printing" "\
Replace nonprinting characters in buffer with printable representations.
The printable representations use ^ (for ASCII control characters) or hex.
The characters tab, linefeed, space, return and formfeed are not affected.

\(fn)" t nil)

(autoload 'pr-printify-region "printing" "\
Replace nonprinting characters in region with printable representations.
The printable representations use ^ (for ASCII control characters) or hex.
The characters tab, linefeed, space, return and formfeed are not affected.

\(fn)" t nil)

(autoload 'pr-txt-directory "printing" "\
Print directory using text printer.

Interactively, the command prompts for a directory and a file name regexp for
matching.

Noninteractively, if DIR is nil, prompts for DIRectory.  If FILE-REGEXP is nil,
prompts for FILE(name)-REGEXP.

See also documentation for `pr-list-directory'.

\(fn &optional DIR FILE-REGEXP)" t nil)

(autoload 'pr-txt-buffer "printing" "\
Print buffer using text printer.

\(fn)" t nil)

(autoload 'pr-txt-region "printing" "\
Print region using text printer.

\(fn)" t nil)

(autoload 'pr-txt-mode "printing" "\
Print major mode using text printer.

\(fn)" t nil)

(autoload 'pr-despool-preview "printing" "\
Preview spooled PostScript.

Interactively, when you use a prefix argument (C-u), the command prompts the
user for a file name, and saves the spooled PostScript image in that file
instead of saving it in a temporary file.

Noninteractively, the argument FILENAME is treated as follows: if it is nil,
save the image in a temporary file.  If FILENAME is a string, save the
PostScript image in a file with that name.

\(fn &optional FILENAME)" t nil)

(autoload 'pr-despool-using-ghostscript "printing" "\
Print spooled PostScript using ghostscript.

Interactively, when you use a prefix argument (C-u), the command prompts the
user for a file name, and saves the spooled PostScript image in that file
instead of sending it to the printer.

Noninteractively, the argument FILENAME is treated as follows: if it is nil,
send the image to the printer.  If FILENAME is a string, save the PostScript
image in a file with that name.

\(fn &optional FILENAME)" t nil)

(autoload 'pr-despool-print "printing" "\
Send the spooled PostScript to the printer.

Interactively, when you use a prefix argument (C-u), the command prompts the
user for a file name, and saves the spooled PostScript image in that file
instead of sending it to the printer.

Noninteractively, the argument FILENAME is treated as follows: if it is nil,
send the image to the printer.  If FILENAME is a string, save the PostScript
image in a file with that name.

\(fn &optional FILENAME)" t nil)

(autoload 'pr-despool-ps-print "printing" "\
Send the spooled PostScript to the printer or use ghostscript to print it.

Interactively, when you use a prefix argument (C-u), the command prompts the
user for a file name, and saves the spooled PostScript image in that file
instead of sending it to the printer.

Noninteractively, the argument FILENAME is treated as follows: if it is nil,
send the image to the printer.  If FILENAME is a string, save the PostScript
image in a file with that name.

\(fn &optional FILENAME)" t nil)

(autoload 'pr-ps-file-preview "printing" "\
Preview PostScript file FILENAME.

\(fn FILENAME)" t nil)

(autoload 'pr-ps-file-up-preview "printing" "\
Preview PostScript file FILENAME.

\(fn N-UP IFILENAME &optional OFILENAME)" t nil)

(autoload 'pr-ps-file-using-ghostscript "printing" "\
Print PostScript file FILENAME using ghostscript.

\(fn FILENAME)" t nil)

(autoload 'pr-ps-file-print "printing" "\
Print PostScript file FILENAME.

\(fn FILENAME)" t nil)

(autoload 'pr-ps-file-ps-print "printing" "\
Send PostScript file FILENAME to printer or use ghostscript to print it.

\(fn FILENAME)" t nil)

(autoload 'pr-ps-file-up-ps-print "printing" "\
Process a PostScript file IFILENAME and send it to printer.

Interactively, the command prompts for N-UP printing number, for an input
PostScript file IFILENAME and, when you use a prefix argument (C-u), the
command prompts the user for an output PostScript file name OFILENAME, and
saves the PostScript image in that file instead of sending it to the printer.

Noninteractively, if N-UP is nil, prompts for N-UP printing number.  The
argument IFILENAME is treated as follows: if it's t, prompts for an input
PostScript file name; otherwise, it *must* be a string that it's an input
PostScript file name.  The argument OFILENAME is treated as follows: if it's
nil, send the image to the printer.  If OFILENAME is a string, save the
PostScript image in a file with that name.  If OFILENAME is t, prompts for a
file name.

\(fn N-UP IFILENAME &optional OFILENAME)" t nil)

(autoload 'pr-toggle-file-duplex "printing" "\
Toggle duplex for PostScript file.

\(fn)" t nil)

(autoload 'pr-toggle-file-tumble "printing" "\
Toggle tumble for PostScript file.

If tumble is off, produces a printing suitable for binding on the left or
right.
If tumble is on, produces a printing suitable for binding at the top or
bottom.

\(fn)" t nil)

(autoload 'pr-toggle-file-landscape "printing" "\
Toggle landscape for PostScript file.

\(fn)" t nil)

(autoload 'pr-toggle-ghostscript "printing" "\
Toggle printing using ghostscript.

\(fn)" t nil)

(autoload 'pr-toggle-faces "printing" "\
Toggle printing with faces.

\(fn)" t nil)

(autoload 'pr-toggle-spool "printing" "\
Toggle spooling.

\(fn)" t nil)

(autoload 'pr-toggle-duplex "printing" "\
Toggle duplex.

\(fn)" t nil)

(autoload 'pr-toggle-tumble "printing" "\
Toggle tumble.

If tumble is off, produces a printing suitable for binding on the left or
right.
If tumble is on, produces a printing suitable for binding at the top or
bottom.

\(fn)" t nil)

(autoload 'pr-toggle-landscape "printing" "\
Toggle landscape.

\(fn)" t nil)

(autoload 'pr-toggle-upside-down "printing" "\
Toggle upside-down.

\(fn)" t nil)

(autoload 'pr-toggle-line "printing" "\
Toggle line number.

\(fn)" t nil)

(autoload 'pr-toggle-zebra "printing" "\
Toggle zebra stripes.

\(fn)" t nil)

(autoload 'pr-toggle-header "printing" "\
Toggle printing header.

\(fn)" t nil)

(autoload 'pr-toggle-header-frame "printing" "\
Toggle printing header frame.

\(fn)" t nil)

(autoload 'pr-toggle-lock "printing" "\
Toggle menu lock.

\(fn)" t nil)

(autoload 'pr-toggle-region "printing" "\
Toggle whether the region is automagically detected.

\(fn)" t nil)

(autoload 'pr-toggle-mode "printing" "\
Toggle auto mode.

\(fn)" t nil)

(autoload 'pr-customize "printing" "\
Customization of the `printing' group.

\(fn &rest IGNORE)" t nil)

(autoload 'lpr-customize "printing" "\
Customization of the `lpr' group.

\(fn &rest IGNORE)" t nil)

(autoload 'pr-help "printing" "\
Help for the printing package.

\(fn &rest IGNORE)" t nil)

(autoload 'pr-ps-name "printing" "\
Interactively select a PostScript printer.

\(fn)" t nil)

(autoload 'pr-txt-name "printing" "\
Interactively select a text printer.

\(fn)" t nil)

(autoload 'pr-ps-utility "printing" "\
Interactively select a PostScript utility.

\(fn)" t nil)

(autoload 'pr-show-ps-setup "printing" "\
Show current ps-print settings.

\(fn &rest IGNORE)" t nil)

(autoload 'pr-show-pr-setup "printing" "\
Show current printing settings.

\(fn &rest IGNORE)" t nil)

(autoload 'pr-show-lpr-setup "printing" "\
Show current lpr settings.

\(fn &rest IGNORE)" t nil)

(autoload 'pr-ps-fast-fire "printing" "\
Fast fire function for PostScript printing.

If a region is active, the region will be printed instead of the whole buffer.
Also if the current major-mode is defined in `pr-mode-alist', the settings in
`pr-mode-alist' will be used, that is, the current buffer or region will be
printed using `pr-ps-mode-ps-print'.


Interactively, you have the following situations:

   M-x pr-ps-fast-fire RET
      The command prompts the user for a N-UP value and printing will
      immediately be done using the current active printer.

   C-u   M-x pr-ps-fast-fire RET
   C-u 0 M-x pr-ps-fast-fire RET
      The command prompts the user for a N-UP value and also for a current
      PostScript printer, then printing will immediately be done using the new
      current active printer.

   C-u 1 M-x pr-ps-fast-fire RET
      The command prompts the user for a N-UP value and also for a file name,
      and saves the PostScript image in that file instead of sending it to the
      printer.

   C-u 2 M-x pr-ps-fast-fire RET
      The command prompts the user for a N-UP value, then for a current
      PostScript printer and, finally, for a file name.  Then change the active
      printer to that chosen by user and saves the PostScript image in
      that file instead of sending it to the printer.


Noninteractively, the argument N-UP should be a positive integer greater than
zero and the argument SELECT is treated as follows:

   If it's nil, send the image to the printer.

   If it's a list or an integer lesser or equal to zero, the command prompts
   the user for a current PostScript printer, then printing will immediately
   be done using the new current active printer.

   If it's an integer equal to 1, the command prompts the user for a file name
   and saves the PostScript image in that file instead of sending it to the
   printer.

   If it's an integer greater or equal to 2, the command prompts the user for a
   current PostScript printer and for a file name.  Then change the active
   printer to that chosen by user and saves the PostScript image in that file
   instead of sending it to the printer.

   If it's a symbol which it's defined in `pr-ps-printer-alist', it's the new
   active printer and printing will immediately be done using the new active
   printer.

   Otherwise, send the image to the printer.


Note that this command always behaves as if `pr-auto-region' and `pr-auto-mode'
are both set to t.

\(fn N-UP &optional SELECT)" t nil)

(autoload 'pr-txt-fast-fire "printing" "\
Fast fire function for text printing.

If a region is active, the region will be printed instead of the whole buffer.
Also if the current major-mode is defined in `pr-mode-alist', the settings in
`pr-mode-alist' will be used, that is, the current buffer or region will be
printed using `pr-txt-mode'.

Interactively, when you use a prefix argument (C-u), the command prompts the
user for a new active text printer.

Noninteractively, the argument SELECT-PRINTER is treated as follows:

   If it's nil, the printing is sent to the current active text printer.

   If it's a symbol which it's defined in `pr-txt-printer-alist', it's the new
   active printer and printing will immediately be done using the new active
   printer.

   If it's non-nil, the command prompts the user for a new active text printer.

Note that this command always behaves as if `pr-auto-region' and `pr-auto-mode'
are both set to t.

\(fn &optional SELECT-PRINTER)" t nil)

;;;***

;;;### (autoloads nil "proced" "proced.el" (21788 61018 0 0))
;;; Generated autoloads from proced.el

(autoload 'proced "proced" "\
Generate a listing of UNIX system processes.
\\<proced-mode-map>
If invoked with optional ARG, do not select the window displaying
the process information.

This function runs the normal hook `proced-post-display-hook'.

See `proced-mode' for a description of features available in
Proced buffers.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "profiler" "profiler.el" (21710 25077 0 0))
;;; Generated autoloads from profiler.el

(autoload 'profiler-start "profiler" "\
Start/restart profilers.
MODE can be one of `cpu', `mem', or `cpu+mem'.
If MODE is `cpu' or `cpu+mem', time-based profiler will be started.
Also, if MODE is `mem' or `cpu+mem', then memory profiler will be started.

\(fn MODE)" t nil)

(autoload 'profiler-find-profile "profiler" "\
Open profile FILENAME.

\(fn FILENAME)" t nil)

(autoload 'profiler-find-profile-other-window "profiler" "\
Open profile FILENAME.

\(fn FILENAME)" t nil)

(autoload 'profiler-find-profile-other-frame "profiler" "\
Open profile FILENAME.

\(fn FILENAME)" t nil)

;;;***

;;;### (autoloads nil "prolog" "progmodes/prolog.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/prolog.el

(autoload 'prolog-mode "prolog" "\
Major mode for editing Prolog code.

Blank lines and `%%...' separate paragraphs.  `%'s starts a comment
line and comments can also be enclosed in /* ... */.

If an optional argument SYSTEM is non-nil, set up mode for the given system.

To find out what version of Prolog mode you are running, enter
`\\[prolog-mode-version]'.

Commands:
\\{prolog-mode-map}

\(fn)" t nil)

(autoload 'mercury-mode "prolog" "\
Major mode for editing Mercury programs.
Actually this is just customized `prolog-mode'.

\(fn)" t nil)

(autoload 'run-prolog "prolog" "\
Run an inferior Prolog process, input and output via buffer *prolog*.
With prefix argument ARG, restart the Prolog process if running before.

\(fn ARG)" t nil)

;;;***

;;;### (autoloads nil "ps-bdf" "ps-bdf.el" (21710 25077 0 0))
;;; Generated autoloads from ps-bdf.el

(defvar bdf-directory-list (if (memq system-type '(ms-dos windows-nt)) (list (expand-file-name "fonts/bdf" installation-directory)) '("/usr/local/share/emacs/fonts/bdf")) "\
List of directories to search for `BDF' font files.
The default value is '(\"/usr/local/share/emacs/fonts/bdf\").")

(custom-autoload 'bdf-directory-list "ps-bdf" t)

;;;***

;;;### (autoloads nil "ps-mode" "progmodes/ps-mode.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/ps-mode.el
(push (purecopy '(ps-mode 1 1 9)) package--builtin-versions)

(autoload 'ps-mode "ps-mode" "\
Major mode for editing PostScript with GNU Emacs.

Entry to this mode calls `ps-mode-hook'.

The following variables hold user options, and can
be set through the `customize' command:

  `ps-mode-auto-indent'
  `ps-mode-tab'
  `ps-mode-paper-size'
  `ps-mode-print-function'
  `ps-run-prompt'
  `ps-run-font-lock-keywords-2'
  `ps-run-x'
  `ps-run-dumb'
  `ps-run-init'
  `ps-run-error-line-numbers'
  `ps-run-tmp-dir'

Type \\[describe-variable] for documentation on these options.


\\{ps-mode-map}


When starting an interactive PostScript process with \\[ps-run-start],
a second window will be displayed, and `ps-run-mode-hook' will be called.
The keymap for this second window is:

\\{ps-run-mode-map}


When Ghostscript encounters an error it displays an error message
with a file position. Clicking mouse-2 on this number will bring
point to the corresponding spot in the PostScript window, if input
to the interpreter was sent from that window.
Typing \\<ps-run-mode-map>\\[ps-run-goto-error] when the cursor is at the number has the same effect.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "ps-print" "ps-print.el" (21788 61018 0 0))
;;; Generated autoloads from ps-print.el
(push (purecopy '(ps-print 7 3 5)) package--builtin-versions)

(defvar ps-page-dimensions-database (purecopy (list (list 'a4 (/ (* 72 21.0) 2.54) (/ (* 72 29.7) 2.54) "A4") (list 'a3 (/ (* 72 29.7) 2.54) (/ (* 72 42.0) 2.54) "A3") (list 'letter (* 72 8.5) (* 72 11.0) "Letter") (list 'legal (* 72 8.5) (* 72 14.0) "Legal") (list 'letter-small (* 72 7.68) (* 72 10.16) "LetterSmall") (list 'tabloid (* 72 11.0) (* 72 17.0) "Tabloid") (list 'ledger (* 72 17.0) (* 72 11.0) "Ledger") (list 'statement (* 72 5.5) (* 72 8.5) "Statement") (list 'executive (* 72 7.5) (* 72 10.0) "Executive") (list 'a4small (* 72 7.47) (* 72 10.85) "A4Small") (list 'b4 (* 72 10.125) (* 72 14.33) "B4") (list 'b5 (* 72 7.16) (* 72 10.125) "B5") '(addresslarge 236.0 99.0 "AddressLarge") '(addresssmall 236.0 68.0 "AddressSmall") '(cuthanging13 90.0 222.0 "CutHanging13") '(cuthanging15 90.0 114.0 "CutHanging15") '(diskette 181.0 136.0 "Diskette") '(eurofilefolder 139.0 112.0 "EuropeanFilefolder") '(eurofoldernarrow 526.0 107.0 "EuroFolderNarrow") '(eurofolderwide 526.0 136.0 "EuroFolderWide") '(euronamebadge 189.0 108.0 "EuroNameBadge") '(euronamebadgelarge 223.0 136.0 "EuroNameBadgeLarge") '(filefolder 230.0 37.0 "FileFolder") '(jewelry 76.0 136.0 "Jewelry") '(mediabadge 180.0 136.0 "MediaBadge") '(multipurpose 126.0 68.0 "MultiPurpose") '(retaillabel 90.0 104.0 "RetailLabel") '(shipping 271.0 136.0 "Shipping") '(slide35mm 26.0 104.0 "Slide35mm") '(spine8mm 187.0 26.0 "Spine8mm") '(topcoated 425.19685 136.0 "TopCoatedPaper") '(topcoatedpaper 396.0 136.0 "TopcoatedPaper150") '(vhsface 205.0 127.0 "VHSFace") '(vhsspine 400.0 50.0 "VHSSpine") '(zipdisk 156.0 136.0 "ZipDisk"))) "\
List associating a symbolic paper type to its width, height and doc media.
See `ps-paper-type'.")

(custom-autoload 'ps-page-dimensions-database "ps-print" t)

(defvar ps-paper-type 'letter "\
Specify the size of paper to format for.
Should be one of the paper types defined in `ps-page-dimensions-database', for
example `letter', `legal' or `a4'.")

(custom-autoload 'ps-paper-type "ps-print" t)

(defvar ps-print-color-p (or (fboundp 'x-color-values) (fboundp 'color-instance-rgb-components)) "\
Specify how buffer's text color is printed.

Valid values are:

   nil		Do not print colors.

   t		Print colors.

   black-white	Print colors on black/white printer.
		See also `ps-black-white-faces'.

Any other value is treated as t.")

(custom-autoload 'ps-print-color-p "ps-print" t)

(autoload 'ps-print-customize "ps-print" "\
Customization of ps-print group.

\(fn)" t nil)

(autoload 'ps-print-buffer "ps-print" "\
Generate and print a PostScript image of the buffer.

Interactively, when you use a prefix argument (\\[universal-argument]), the command prompts the
user for a file name, and saves the PostScript image in that file instead of
sending it to the printer.

Noninteractively, the argument FILENAME is treated as follows: if it is nil,
send the image to the printer.  If FILENAME is a string, save the PostScript
image in a file with that name.

\(fn &optional FILENAME)" t nil)

(autoload 'ps-print-buffer-with-faces "ps-print" "\
Generate and print a PostScript image of the buffer.
Like `ps-print-buffer', but includes font, color, and underline information in
the generated image.  This command works only if you are using a window system,
so it has a way to determine color values.

\(fn &optional FILENAME)" t nil)

(autoload 'ps-print-region "ps-print" "\
Generate and print a PostScript image of the region.
Like `ps-print-buffer', but prints just the current region.

\(fn FROM TO &optional FILENAME)" t nil)

(autoload 'ps-print-region-with-faces "ps-print" "\
Generate and print a PostScript image of the region.
Like `ps-print-region', but includes font, color, and underline information in
the generated image.  This command works only if you are using a window system,
so it has a way to determine color values.

\(fn FROM TO &optional FILENAME)" t nil)

(autoload 'ps-spool-buffer "ps-print" "\
Generate and spool a PostScript image of the buffer.
Like `ps-print-buffer' except that the PostScript image is saved in a local
buffer to be sent to the printer later.

Use the command `ps-despool' to send the spooled images to the printer.

\(fn)" t nil)

(autoload 'ps-spool-buffer-with-faces "ps-print" "\
Generate and spool a PostScript image of the buffer.
Like the command `ps-spool-buffer', but includes font, color, and underline
information in the generated image.  This command works only if you are using
a window system, so it has a way to determine color values.

Use the command `ps-despool' to send the spooled images to the printer.

\(fn)" t nil)

(autoload 'ps-spool-region "ps-print" "\
Generate a PostScript image of the region and spool locally.
Like `ps-spool-buffer', but spools just the current region.

Use the command `ps-despool' to send the spooled images to the printer.

\(fn FROM TO)" t nil)

(autoload 'ps-spool-region-with-faces "ps-print" "\
Generate a PostScript image of the region and spool locally.
Like `ps-spool-region', but includes font, color, and underline information in
the generated image.  This command works only if you are using a window system,
so it has a way to determine color values.

Use the command `ps-despool' to send the spooled images to the printer.

\(fn FROM TO)" t nil)

(autoload 'ps-despool "ps-print" "\
Send the spooled PostScript to the printer.

Interactively, when you use a prefix argument (\\[universal-argument]), the command prompts the
user for a file name, and saves the spooled PostScript image in that file
instead of sending it to the printer.

Noninteractively, the argument FILENAME is treated as follows: if it is nil,
send the image to the printer.  If FILENAME is a string, save the PostScript
image in a file with that name.

\(fn &optional FILENAME)" t nil)

(autoload 'ps-line-lengths "ps-print" "\
Display the correspondence between a line length and a font size.
Done using the current ps-print setup.
Try: pr -t file | awk '{printf \"%3d %s
\", length($0), $0}' | sort -r | head

\(fn)" t nil)

(autoload 'ps-nb-pages-buffer "ps-print" "\
Display number of pages to print this buffer, for various font heights.
The table depends on the current ps-print setup.

\(fn NB-LINES)" t nil)

(autoload 'ps-nb-pages-region "ps-print" "\
Display number of pages to print the region, for various font heights.
The table depends on the current ps-print setup.

\(fn NB-LINES)" t nil)

(autoload 'ps-setup "ps-print" "\
Return the current PostScript-generation setup.

\(fn)" nil nil)

(autoload 'ps-extend-face-list "ps-print" "\
Extend face in ALIST-SYM.

If optional MERGE-P is non-nil, extensions in FACE-EXTENSION-LIST are merged
with face extension in ALIST-SYM; otherwise, overrides.

If optional ALIST-SYM is nil, `ps-print-face-extension-alist' is used;
otherwise, it should be an alist symbol.

The elements in FACE-EXTENSION-LIST are like those for `ps-extend-face'.

See `ps-extend-face' for documentation.

\(fn FACE-EXTENSION-LIST &optional MERGE-P ALIST-SYM)" nil nil)

(autoload 'ps-extend-face "ps-print" "\
Extend face in ALIST-SYM.

If optional MERGE-P is non-nil, extensions in FACE-EXTENSION list are merged
with face extensions in ALIST-SYM; otherwise, overrides.

If optional ALIST-SYM is nil, `ps-print-face-extension-alist' is used;
otherwise, it should be an alist symbol.

The elements of FACE-EXTENSION list have the form:

   (FACE-NAME FOREGROUND BACKGROUND EXTENSION...)

FACE-NAME is a face name symbol.

FOREGROUND and BACKGROUND may be nil or a string that denotes the
foreground and background colors respectively.

EXTENSION is one of the following symbols:
   bold      - use bold font.
   italic    - use italic font.
   underline - put a line under text.
   strikeout - like underline, but the line is in middle of text.
   overline  - like underline, but the line is over the text.
   shadow    - text will have a shadow.
   box       - text will be surrounded by a box.
   outline   - print characters as hollow outlines.

If EXTENSION is any other symbol, it is ignored.

\(fn FACE-EXTENSION &optional MERGE-P ALIST-SYM)" nil nil)

;;;***

;;;### (autoloads nil "pulse" "cedet/pulse.el" (21788 61018 0 0))
;;; Generated autoloads from cedet/pulse.el
(push (purecopy '(pulse 1 0)) package--builtin-versions)

;;;***

;;;### (autoloads nil "python" "progmodes/python.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/python.el
(push (purecopy '(python 0 24 5)) package--builtin-versions)

(add-to-list 'auto-mode-alist (cons (purecopy "\\.py\\'") 'python-mode))

(add-to-list 'interpreter-mode-alist (cons (purecopy "python[0-9.]*") 'python-mode))

(autoload 'run-python "python" "\
Run an inferior Python process.
Input and output via buffer named after
`python-shell-buffer-name'.  If there is a process already
running in that buffer, just switch to it.

With argument, allows you to define CMD so you can edit the
command used to call the interpreter and define DEDICATED, so a
dedicated process for the current buffer is open.  When numeric
prefix arg is other than 0 or 4 do not SHOW.

Runs the hook `inferior-python-mode-hook' after
`comint-mode-hook' is run.  (Type \\[describe-mode] in the
process buffer for a list of commands.)

\(fn CMD &optional DEDICATED SHOW)" t nil)

(autoload 'python-mode "python" "\
Major mode for editing Python files.

\\{python-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "qp" "gnus/qp.el" (21710 25077 0 0))
;;; Generated autoloads from gnus/qp.el

(autoload 'quoted-printable-decode-region "qp" "\
Decode quoted-printable in the region between FROM and TO, per RFC 2045.
If CODING-SYSTEM is non-nil, decode bytes into characters with that
coding-system.

Interactively, you can supply the CODING-SYSTEM argument
with \\[universal-coding-system-argument].

The CODING-SYSTEM argument is a historical hangover and is deprecated.
QP encodes raw bytes and should be decoded into raw bytes.  Decoding
them into characters should be done separately.

\(fn FROM TO &optional CODING-SYSTEM)" t nil)

;;;***

;;;### (autoloads nil "quail" "international/quail.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from international/quail.el

(autoload 'quail-title "quail" "\
Return the title of the current Quail package.

\(fn)" nil nil)

(autoload 'quail-use-package "quail" "\
Start using Quail package PACKAGE-NAME.
The remaining arguments are LIBRARIES to be loaded before using the package.

This activates input method defined by PACKAGE-NAME by running
`quail-activate', which see.

\(fn PACKAGE-NAME &rest LIBRARIES)" nil nil)

(autoload 'quail-define-package "quail" "\
Define NAME as a new Quail package for input LANGUAGE.
TITLE is a string to be displayed at mode-line to indicate this package.
Optional arguments are GUIDANCE, DOCSTRING, TRANSLATION-KEYS,
 FORGET-LAST-SELECTION, DETERMINISTIC, KBD-TRANSLATE, SHOW-LAYOUT,
 CREATE-DECODE-MAP, MAXIMUM-SHORTEST, OVERLAY-PLIST,
 UPDATE-TRANSLATION-FUNCTION, CONVERSION-KEYS and SIMPLE.

GUIDANCE specifies how a guidance string is shown in echo area.
If it is t, list of all possible translations for the current key is shown
 with the currently selected translation being highlighted.
If it is an alist, the element has the form (CHAR . STRING).  Each character
 in the current key is searched in the list and the corresponding string is
 shown.
If it is nil, the current key is shown.

DOCSTRING is the documentation string of this package.  The command
`describe-input-method' shows this string while replacing the form
\\=\\<VAR> in the string by the value of VAR.  That value should be a
string.  For instance, the form \\=\\<quail-translation-docstring> is
replaced by a description about how to select a translation from a
list of candidates.

TRANSLATION-KEYS specifies additional key bindings used while translation
region is active.  It is an alist of single key character vs. corresponding
command to be called.

FORGET-LAST-SELECTION non-nil means a selected translation is not kept
for the future to translate the same key.  If this flag is nil, a
translation selected for a key is remembered so that it can be the
first candidate when the same key is entered later.

DETERMINISTIC non-nil means the first candidate of translation is
selected automatically without allowing users to select another
translation for a key.  In this case, unselected translations are of
no use for an interactive use of Quail but can be used by some other
programs.  If this flag is non-nil, FORGET-LAST-SELECTION is also set
to t.

KBD-TRANSLATE non-nil means input characters are translated from a
user's keyboard layout to the standard keyboard layout.  See the
documentation of `quail-keyboard-layout' and
`quail-keyboard-layout-standard' for more detail.

SHOW-LAYOUT non-nil means the function `quail-help' (as used by
the command `describe-input-method') should show the user's keyboard
layout visually with translated characters.  If KBD-TRANSLATE is
set, it is desirable to also set this flag, unless this package
defines no translations for single character keys.

CREATE-DECODE-MAP non-nil means decode map is also created.  A decode
map is an alist of translations and corresponding original keys.
Although this map is not used by Quail itself, it can be used by some
other programs.  For instance, Vietnamese supporting needs this map to
convert Vietnamese text to VIQR format which uses only ASCII
characters to represent Vietnamese characters.

MAXIMUM-SHORTEST non-nil means break key sequence to get maximum
length of the shortest sequence.  When we don't have a translation of
key \"..ABCD\" but have translations of \"..AB\" and \"CD..\", break
the key at \"..AB\" and start translation of \"CD..\".  Hangul
packages, for instance, use this facility.  If this flag is nil, we
break the key just at \"..ABC\" and start translation of \"D..\".

OVERLAY-PLIST if non-nil is a property list put on an overlay which
covers Quail translation region.

UPDATE-TRANSLATION-FUNCTION if non-nil is a function to call to update
the current translation region according to a new translation data.  By
default, a translated text or a user's key sequence (if no translation
for it) is inserted.

CONVERSION-KEYS specifies additional key bindings used while
conversion region is active.  It is an alist of single key character
vs. corresponding command to be called.

If SIMPLE is non-nil, then we do not alter the meanings of
commands such as C-f, C-b, C-n, C-p and TAB; they are treated as
non-Quail commands.

\(fn NAME LANGUAGE TITLE &optional GUIDANCE DOCSTRING TRANSLATION-KEYS FORGET-LAST-SELECTION DETERMINISTIC KBD-TRANSLATE SHOW-LAYOUT CREATE-DECODE-MAP MAXIMUM-SHORTEST OVERLAY-PLIST UPDATE-TRANSLATION-FUNCTION CONVERSION-KEYS SIMPLE)" nil nil)

(autoload 'quail-set-keyboard-layout "quail" "\
Set the current keyboard layout to the same as keyboard KBD-TYPE.

Since some Quail packages depends on a physical layout of keys (not
characters generated by them), those are created by assuming the
standard layout defined in `quail-keyboard-layout-standard'.  This
function tells Quail system the layout of your keyboard so that what
you type is correctly handled.

\(fn KBD-TYPE)" t nil)

(autoload 'quail-show-keyboard-layout "quail" "\
Show the physical layout of the keyboard type KEYBOARD-TYPE.

The variable `quail-keyboard-layout-type' holds the currently selected
keyboard type.

\(fn &optional KEYBOARD-TYPE)" t nil)

(autoload 'quail-define-rules "quail" "\
Define translation rules of the current Quail package.
Each argument is a list of KEY and TRANSLATION.
KEY is a string meaning a sequence of keystrokes to be translated.
TRANSLATION is a character, a string, a vector, a Quail map, or a function.
If it is a character, it is the sole translation of KEY.
If it is a string, each character is a candidate for the translation.
If it is a vector, each element (string or character) is a candidate
  for the translation.
In these cases, a key specific Quail map is generated and assigned to KEY.

If TRANSLATION is a Quail map or a function symbol which returns a Quail map,
 it is used to handle KEY.

The first argument may be an alist of annotations for the following
rules.  Each element has the form (ANNOTATION . VALUE), where
ANNOTATION is a symbol indicating the annotation type.  Currently
the following annotation types are supported.

  append -- the value non-nil means that the following rules should
	be appended to the rules of the current Quail package.

  face -- the value is a face to use for displaying TRANSLATIONs in
	candidate list.

  advice -- the value is a function to call after one of RULES is
	selected.  The function is called with one argument, the
	selected TRANSLATION string, after the TRANSLATION is
	inserted.

  no-decode-map --- the value non-nil means that decoding map is not
	generated for the following translations.

\(fn &rest RULES)" nil t)

(autoload 'quail-install-map "quail" "\
Install the Quail map MAP in the current Quail package.

Optional 2nd arg NAME, if non-nil, is a name of Quail package for
which to install MAP.

The installed map can be referred by the function `quail-map'.

\(fn MAP &optional NAME)" nil nil)

(autoload 'quail-install-decode-map "quail" "\
Install the Quail decode map DECODE-MAP in the current Quail package.

Optional 2nd arg NAME, if non-nil, is a name of Quail package for
which to install MAP.

The installed decode map can be referred by the function `quail-decode-map'.

\(fn DECODE-MAP &optional NAME)" nil nil)

(autoload 'quail-defrule "quail" "\
Add one translation rule, KEY to TRANSLATION, in the current Quail package.
KEY is a string meaning a sequence of keystrokes to be translated.
TRANSLATION is a character, a string, a vector, a Quail map,
 a function, or a cons.
It it is a character, it is the sole translation of KEY.
If it is a string, each character is a candidate for the translation.
If it is a vector, each element (string or character) is a candidate
 for the translation.
If it is a cons, the car is one of the above and the cdr is a function
 to call when translating KEY (the return value is assigned to the
 variable `quail-current-data').  If the cdr part is not a function,
 the value itself is assigned to `quail-current-data'.
In these cases, a key specific Quail map is generated and assigned to KEY.

If TRANSLATION is a Quail map or a function symbol which returns a Quail map,
 it is used to handle KEY.

Optional 3rd argument NAME, if specified, says which Quail package
to define this translation rule in.  The default is to define it in the
current Quail package.

Optional 4th argument APPEND, if non-nil, appends TRANSLATION
to the current translations for KEY instead of replacing them.

\(fn KEY TRANSLATION &optional NAME APPEND)" nil nil)

(autoload 'quail-defrule-internal "quail" "\
Define KEY as TRANS in a Quail map MAP.

If Optional 4th arg APPEND is non-nil, TRANS is appended to the
current translations for KEY instead of replacing them.

Optional 5th arg DECODE-MAP is a Quail decode map.

Optional 6th arg PROPS is a property list annotating TRANS.  See the
function `quail-define-rules' for the detail.

\(fn KEY TRANS MAP &optional APPEND DECODE-MAP PROPS)" nil nil)

(autoload 'quail-update-leim-list-file "quail" "\
Update entries for Quail packages in `LEIM' list file in directory DIRNAME.
DIRNAME is a directory containing Emacs input methods;
normally, it should specify the `leim' subdirectory
of the Emacs source tree.

It searches for Quail packages under `quail' subdirectory of DIRNAME,
and update the file \"leim-list.el\" in DIRNAME.

When called from a program, the remaining arguments are additional
directory names to search for Quail packages under `quail' subdirectory
of each directory.

\(fn DIRNAME &rest DIRNAMES)" t nil)

;;;***

;;;### (autoloads nil "quail/hangul" "leim/quail/hangul.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from leim/quail/hangul.el

(autoload 'hangul-input-method-activate "quail/hangul" "\
Activate Hangul input method INPUT-METHOD.
FUNC is a function to handle input key.
HELP-TEXT is a text set in `hangul-input-method-help-text'.

\(fn INPUT-METHOD FUNC HELP-TEXT &rest ARGS)" nil nil)

;;;***

;;;### (autoloads nil "quail/uni-input" "leim/quail/uni-input.el"
;;;;;;  (21710 25077 0 0))
;;; Generated autoloads from leim/quail/uni-input.el

(autoload 'ucs-input-activate "quail/uni-input" "\
Activate UCS input method.
With ARG, activate UCS input method if and only if ARG is positive.

While this input method is active, the variable
`input-method-function' is bound to the function `ucs-input-method'.

\(fn &optional ARG)" nil nil)

;;;***

;;;### (autoloads nil "quickurl" "net/quickurl.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from net/quickurl.el

(defconst quickurl-reread-hook-postfix "\n;; Local Variables:\n;; eval: (progn (require 'quickurl) (add-hook 'local-write-file-hooks (lambda () (quickurl-read) nil)))\n;; End:\n" "\
Example `quickurl-postfix' text that adds a local variable to the
`quickurl-url-file' so that if you edit it by hand it will ensure that
`quickurl-urls' is updated with the new URL list.

To make use of this do something like:

  (setq quickurl-postfix quickurl-reread-hook-postfix)

in your init file (after loading/requiring quickurl).")

(autoload 'quickurl "quickurl" "\
Insert a URL based on LOOKUP.

If not supplied LOOKUP is taken to be the word at point in the current
buffer, this default action can be modified via
`quickurl-grab-lookup-function'.

\(fn &optional LOOKUP)" t nil)

(autoload 'quickurl-ask "quickurl" "\
Insert a URL, with `completing-read' prompt, based on LOOKUP.

\(fn LOOKUP)" t nil)

(autoload 'quickurl-add-url "quickurl" "\
Allow the user to interactively add a new URL associated with WORD.

See `quickurl-grab-url' for details on how the default word/URL combination
is decided.

\(fn WORD URL COMMENT)" t nil)

(autoload 'quickurl-browse-url "quickurl" "\
Browse the URL associated with LOOKUP.

If not supplied LOOKUP is taken to be the word at point in the
current buffer, this default action can be modified via
`quickurl-grab-lookup-function'.

\(fn &optional LOOKUP)" t nil)

(autoload 'quickurl-browse-url-ask "quickurl" "\
Browse the URL, with `completing-read' prompt, associated with LOOKUP.

\(fn LOOKUP)" t nil)

(autoload 'quickurl-edit-urls "quickurl" "\
Pull `quickurl-url-file' into a buffer for hand editing.

\(fn)" t nil)

(autoload 'quickurl-list-mode "quickurl" "\
A mode for browsing the quickurl URL list.

The key bindings for `quickurl-list-mode' are:

\\{quickurl-list-mode-map}

\(fn)" t nil)

(autoload 'quickurl-list "quickurl" "\
Display `quickurl-list' as a formatted list using `quickurl-list-mode'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "rcirc" "net/rcirc.el" (21788 61018 0 0))
;;; Generated autoloads from net/rcirc.el

(autoload 'rcirc "rcirc" "\
Connect to all servers in `rcirc-server-alist'.

Do not connect to a server if it is already connected.

If ARG is non-nil, instead prompt for connection parameters.

\(fn ARG)" t nil)

(defalias 'irc 'rcirc)

(autoload 'rcirc-connect "rcirc" "\


\(fn SERVER &optional PORT NICK USER-NAME FULL-NAME STARTUP-CHANNELS PASSWORD ENCRYPTION)" nil nil)

(defvar rcirc-track-minor-mode nil "\
Non-nil if Rcirc-Track minor mode is enabled.
See the command `rcirc-track-minor-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `rcirc-track-minor-mode'.")

(custom-autoload 'rcirc-track-minor-mode "rcirc" nil)

(autoload 'rcirc-track-minor-mode "rcirc" "\
Global minor mode for tracking activity in rcirc buffers.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "re-builder" "emacs-lisp/re-builder.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from emacs-lisp/re-builder.el

(defalias 'regexp-builder 're-builder)

(autoload 're-builder "re-builder" "\
Construct a regexp interactively.
This command makes the current buffer the \"target\" buffer of
the regexp builder.  It displays a buffer named \"*RE-Builder*\"
in another window, initially containing an empty regexp.

As you edit the regexp in the \"*RE-Builder*\" buffer, the
matching parts of the target buffer will be highlighted.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "recentf" "recentf.el" (21710 25077 0 0))
;;; Generated autoloads from recentf.el

(defvar recentf-mode nil "\
Non-nil if Recentf mode is enabled.
See the command `recentf-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `recentf-mode'.")

(custom-autoload 'recentf-mode "recentf" nil)

(autoload 'recentf-mode "recentf" "\
Toggle \"Open Recent\" menu (Recentf mode).
With a prefix argument ARG, enable Recentf mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
Recentf mode if ARG is omitted or nil.

When Recentf mode is enabled, a \"Open Recent\" submenu is
displayed in the \"File\" menu, containing a list of files that
were operated on recently.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "rect" "rect.el" (21788 61018 0 0))
;;; Generated autoloads from rect.el

(autoload 'delete-rectangle "rect" "\
Delete (don't save) text in the region-rectangle.
The same range of columns is deleted in each line starting with the
line where the region begins and ending with the line where the region
ends.

When called from a program the rectangle's corners are START and END.
With a prefix (or a FILL) argument, also fill lines where nothing has
to be deleted.

\(fn START END &optional FILL)" t nil)

(autoload 'delete-extract-rectangle "rect" "\
Delete the contents of the rectangle with corners at START and END.
Return it as a list of strings, one for each line of the rectangle.

When called from a program the rectangle's corners are START and END.
With an optional FILL argument, also fill lines where nothing has to be
deleted.

\(fn START END &optional FILL)" nil nil)

(autoload 'extract-rectangle "rect" "\
Return the contents of the rectangle with corners at START and END.
Return it as a list of strings, one for each line of the rectangle.

\(fn START END)" nil nil)

(autoload 'kill-rectangle "rect" "\
Delete the region-rectangle and save it as the last killed one.

When called from a program the rectangle's corners are START and END.
You might prefer to use `delete-extract-rectangle' from a program.

With a prefix (or a FILL) argument, also fill lines where nothing has to be
deleted.

If the buffer is read-only, Emacs will beep and refrain from deleting
the rectangle, but put it in the kill ring anyway.  This means that
you can use this command to copy text from a read-only buffer.
\(If the variable `kill-read-only-ok' is non-nil, then this won't
even beep.)

\(fn START END &optional FILL)" t nil)

(autoload 'copy-rectangle-as-kill "rect" "\
Copy the region-rectangle and save it as the last killed one.

\(fn START END)" t nil)

(autoload 'yank-rectangle "rect" "\
Yank the last killed rectangle with upper left corner at point.

\(fn)" t nil)

(autoload 'insert-rectangle "rect" "\
Insert text of RECTANGLE with upper left corner at point.
RECTANGLE's first line is inserted at point, its second
line is inserted at a point vertically under point, etc.
RECTANGLE should be a list of strings.
After this command, the mark is at the upper left corner
and point is at the lower right corner.

\(fn RECTANGLE)" nil nil)

(autoload 'open-rectangle "rect" "\
Blank out the region-rectangle, shifting text right.

The text previously in the region is not overwritten by the blanks,
but instead winds up to the right of the rectangle.

When called from a program the rectangle's corners are START and END.
With a prefix (or a FILL) argument, fill with blanks even if there is
no text on the right side of the rectangle.

\(fn START END &optional FILL)" t nil)

(defalias 'close-rectangle 'delete-whitespace-rectangle)

(autoload 'delete-whitespace-rectangle "rect" "\
Delete all whitespace following a specified column in each line.
The left edge of the rectangle specifies the position in each line
at which whitespace deletion should begin.  On each line in the
rectangle, all continuous whitespace starting at that column is deleted.

When called from a program the rectangle's corners are START and END.
With a prefix (or a FILL) argument, also fill too short lines.

\(fn START END &optional FILL)" t nil)

(autoload 'string-rectangle "rect" "\
Replace rectangle contents with STRING on each line.
The length of STRING need not be the same as the rectangle width.

Called from a program, takes three args; START, END and STRING.

\(fn START END STRING)" t nil)

(defalias 'replace-rectangle 'string-rectangle)

(autoload 'string-insert-rectangle "rect" "\
Insert STRING on each line of region-rectangle, shifting text right.

When called from a program, the rectangle's corners are START and END.
The left edge of the rectangle specifies the column for insertion.
This command does not delete or overwrite any existing text.

\(fn START END STRING)" t nil)

(autoload 'clear-rectangle "rect" "\
Blank out the region-rectangle.
The text previously in the region is overwritten with blanks.

When called from a program the rectangle's corners are START and END.
With a prefix (or a FILL) argument, also fill with blanks the parts of the
rectangle which were empty.

\(fn START END &optional FILL)" t nil)

(autoload 'rectangle-number-lines "rect" "\
Insert numbers in front of the region-rectangle.

START-AT, if non-nil, should be a number from which to begin
counting.  FORMAT, if non-nil, should be a format string to pass
to `format' along with the line count.  When called interactively
with a prefix argument, prompt for START-AT and FORMAT.

\(fn START END START-AT &optional FORMAT)" t nil)

(autoload 'rectangle-mark-mode "rect" "\
Toggle the region as rectangular.
Activates the region if needed.  Only lasts until the region is deactivated.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "refill" "textmodes/refill.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from textmodes/refill.el

(autoload 'refill-mode "refill" "\
Toggle automatic refilling (Refill mode).
With a prefix argument ARG, enable Refill mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Refill mode is a buffer-local minor mode.  When enabled, the
current paragraph is refilled as you edit.  Self-inserting
characters only cause refilling if they would cause
auto-filling.

For true \"word wrap\" behavior, use `visual-line-mode' instead.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "reftex" "textmodes/reftex.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from textmodes/reftex.el

(autoload 'turn-on-reftex "reftex" "\
Turn on RefTeX mode.

\(fn)" nil nil)

(autoload 'reftex-mode "reftex" "\
Minor mode with distinct support for \\label, \\ref and \\cite in LaTeX.

\\<reftex-mode-map>A Table of Contents of the entire (multifile) document with browsing
capabilities is available with `\\[reftex-toc]'.

Labels can be created with `\\[reftex-label]' and referenced with `\\[reftex-reference]'.
When referencing, you get a menu with all labels of a given type and
context of the label definition.  The selected label is inserted as a
\\ref macro.

Citations can be made with `\\[reftex-citation]' which will use a regular expression
to pull out a *formatted* list of articles from your BibTeX
database.  The selected citation is inserted as a \\cite macro.

Index entries can be made with `\\[reftex-index-selection-or-word]' which indexes the word at point
or the current selection.  More general index entries are created with
`\\[reftex-index]'.  `\\[reftex-display-index]' displays the compiled index.

Most command have help available on the fly.  This help is accessed by
pressing `?' to any prompt mentioning this feature.

Extensive documentation about RefTeX is available in Info format.
You can view this information with `\\[reftex-info]'.

\\{reftex-mode-map}
Under X, these and other functions will also be available as `Ref' menu
on the menu bar.

------------------------------------------------------------------------------

\(fn &optional ARG)" t nil)

(autoload 'reftex-reset-scanning-information "reftex" "\
Reset the symbols containing information from buffer scanning.
This enforces rescanning the buffer on next use.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "reftex-cite" "textmodes/reftex-cite.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from textmodes/reftex-cite.el

(autoload 'reftex-citation "reftex-cite" "\
Make a citation using BibTeX database files.
After prompting for a regular expression, scans the buffers with
bibtex entries (taken from the \\bibliography command) and offers the
matching entries for selection.  The selected entry is formatted according
to `reftex-cite-format' and inserted into the buffer.

If NO-INSERT is non-nil, nothing is inserted, only the selected key returned.

FORMAT-KEY can be used to pre-select a citation format.

When called with a `C-u' prefix, prompt for optional arguments in
cite macros.  When called with a numeric prefix, make that many
citations.  When called with point inside the braces of a `\\cite'
command, it will add another key, ignoring the value of
`reftex-cite-format'.

The regular expression uses an expanded syntax: && is interpreted as `and'.
Thus, `aaaa&&bbb' matches entries which contain both `aaaa' and `bbb'.
While entering the regexp, completion on knows citation keys is possible.
`=' is a good regular expression to match all entries in all files.

\(fn &optional NO-INSERT FORMAT-KEY)" t nil)

;;;***

;;;### (autoloads nil "reftex-global" "textmodes/reftex-global.el"
;;;;;;  (21788 61018 0 0))
;;; Generated autoloads from textmodes/reftex-global.el

(autoload 'reftex-isearch-minor-mode "reftex-global" "\
When on, isearch searches the whole document, not only the current file.
This minor mode allows isearch to search through all the files of
the current TeX document.

With no argument, this command toggles
`reftex-isearch-minor-mode'.  With a prefix argument ARG, turn
`reftex-isearch-minor-mode' on if ARG is positive, otherwise turn it off.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "reftex-index" "textmodes/reftex-index.el"
;;;;;;  (21788 61018 0 0))
;;; Generated autoloads from textmodes/reftex-index.el

(autoload 'reftex-index-phrases-mode "reftex-index" "\
Major mode for managing the Index phrases of a LaTeX document.
This buffer was created with RefTeX.

To insert new phrases, use
 - `C-c \\' in the LaTeX document to copy selection or word
 - `\\[reftex-index-new-phrase]' in the phrases buffer.

To index phrases use one of:

\\[reftex-index-this-phrase]     index current phrase
\\[reftex-index-next-phrase]     index next phrase (or N with prefix arg)
\\[reftex-index-all-phrases]     index all phrases
\\[reftex-index-remaining-phrases]     index current and following phrases
\\[reftex-index-region-phrases]     index the phrases in the region

You can sort the phrases in this buffer with \\[reftex-index-sort-phrases].
To display information about the phrase at point, use \\[reftex-index-phrases-info].

For more information see the RefTeX User Manual.

Here are all local bindings.

\\{reftex-index-phrases-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "reftex-parse" "textmodes/reftex-parse.el"
;;;;;;  (21788 61018 0 0))
;;; Generated autoloads from textmodes/reftex-parse.el

(autoload 'reftex-all-document-files "reftex-parse" "\
Return a list of all files belonging to the current document.
When RELATIVE is non-nil, give file names relative to directory
of master file.

\(fn &optional RELATIVE)" nil nil)

;;;***

;;;### (autoloads nil "reftex-vars" "textmodes/reftex-vars.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from textmodes/reftex-vars.el
(put 'reftex-vref-is-default 'safe-local-variable (lambda (x) (or (stringp x) (symbolp x))))
(put 'reftex-fref-is-default 'safe-local-variable (lambda (x) (or (stringp x) (symbolp x))))
(put 'reftex-level-indent 'safe-local-variable 'integerp)
(put 'reftex-guess-label-type 'safe-local-variable (lambda (x) (memq x '(nil t))))

;;;***

;;;### (autoloads nil "regexp-opt" "emacs-lisp/regexp-opt.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from emacs-lisp/regexp-opt.el

(autoload 'regexp-opt "regexp-opt" "\
Return a regexp to match a string in the list STRINGS.
Each string should be unique in STRINGS and should not contain any regexps,
quoted or not.  If optional PAREN is non-nil, ensure that the returned regexp
is enclosed by at least one regexp grouping construct.
The returned regexp is typically more efficient than the equivalent regexp:

 (let ((open (if PAREN \"\\\\(\" \"\")) (close (if PAREN \"\\\\)\" \"\")))
   (concat open (mapconcat 'regexp-quote STRINGS \"\\\\|\") close))

If PAREN is `words', then the resulting regexp is additionally surrounded
by \\=\\< and \\>.
If PAREN is `symbols', then the resulting regexp is additionally surrounded
by \\=\\_< and \\_>.

\(fn STRINGS &optional PAREN)" nil nil)

(autoload 'regexp-opt-depth "regexp-opt" "\
Return the depth of REGEXP.
This means the number of non-shy regexp grouping constructs
\(parenthesized expressions) in REGEXP.

\(fn REGEXP)" nil nil)

;;;***

;;;### (autoloads nil "regi" "emacs-lisp/regi.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from emacs-lisp/regi.el
(push (purecopy '(regi 1 8)) package--builtin-versions)

;;;***

;;;### (autoloads nil "remember" "textmodes/remember.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from textmodes/remember.el
(push (purecopy '(remember 2 0)) package--builtin-versions)

(autoload 'remember "remember" "\
Remember an arbitrary piece of data.
INITIAL is the text to initially place in the *Remember* buffer,
or nil to bring up a blank *Remember* buffer.

With a prefix or a visible region, use the region as INITIAL.

\(fn &optional INITIAL)" t nil)

(autoload 'remember-other-frame "remember" "\
Call `remember' in another frame.

\(fn &optional INITIAL)" t nil)

(autoload 'remember-clipboard "remember" "\
Remember the contents of the current clipboard.
Most useful for remembering things from other applications.

\(fn)" t nil)

(autoload 'remember-diary-extract-entries "remember" "\
Extract diary entries from the region.

\(fn)" nil nil)

(autoload 'remember-notes "remember" "\
Return the notes buffer, creating it if needed, and maybe switch to it.
This buffer is for notes that you want to preserve across Emacs sessions.
The notes are saved in `remember-data-file'.

If a buffer is already visiting that file, just return it.

Otherwise, create the buffer, and rename it to `remember-notes-buffer-name',
unless a buffer of that name already exists.  Set the major mode according
to `remember-notes-initial-major-mode', and enable `remember-notes-mode'
minor mode.

Use \\<remember-notes-mode-map>\\[remember-notes-save-and-bury-buffer] to save and bury the notes buffer.

Interactively, or if SWITCH-TO is non-nil, switch to the buffer.
Return the buffer.

Set `initial-buffer-choice' to `remember-notes' to visit your notes buffer
when Emacs starts.  Set `remember-notes-buffer-name' to \"*scratch*\"
to turn the *scratch* buffer into your notes buffer.

\(fn &optional SWITCH-TO)" t nil)

;;;***

;;;### (autoloads nil "repeat" "repeat.el" (21710 25077 0 0))
;;; Generated autoloads from repeat.el
(push (purecopy '(repeat 0 51)) package--builtin-versions)

(autoload 'repeat "repeat" "\
Repeat most recently executed command.
If REPEAT-ARG is non-nil (interactively, with a prefix argument),
supply a prefix argument to that command.  Otherwise, give the
command the same prefix argument it was given before, if any.

If this command is invoked by a multi-character key sequence, it
can then be repeated by repeating the final character of that
sequence.  This behavior can be modified by the global variable
`repeat-on-final-keystroke'.

`repeat' ignores commands bound to input events.  Hence the term
\"most recently executed command\" shall be read as \"most
recently executed command not bound to an input event\".

\(fn REPEAT-ARG)" t nil)

;;;***

;;;### (autoloads nil "reporter" "mail/reporter.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/reporter.el

(autoload 'reporter-submit-bug-report "reporter" "\
Begin submitting a bug report via email.

ADDRESS is the email address for the package's maintainer.  PKGNAME is
the name of the package (if you want to include version numbers,
you must put them into PKGNAME before calling this function).
Optional PRE-HOOKS and POST-HOOKS are passed to `reporter-dump-state'.
Optional SALUTATION is inserted at the top of the mail buffer,
and point is left after the salutation.

VARLIST is the list of variables to dump (see `reporter-dump-state'
for details).  The optional argument PRE-HOOKS and POST-HOOKS are
passed to `reporter-dump-state'.  Optional argument SALUTATION is text
to be inserted at the top of the mail buffer; in that case, point is
left after that text.

This function prompts for a summary if `reporter-prompt-for-summary-p'
is non-nil.

This function does not send a message; it uses the given information
to initialize a message, which the user can then edit and finally send
\(or decline to send).  The variable `mail-user-agent' controls which
mail-sending package is used for editing and sending the message.

\(fn ADDRESS PKGNAME VARLIST &optional PRE-HOOKS POST-HOOKS SALUTATION)" nil nil)

;;;***

;;;### (autoloads nil "reposition" "reposition.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from reposition.el

(autoload 'reposition-window "reposition" "\
Make the current definition and/or comment visible.
Further invocations move it to the top of the window or toggle the
visibility of comments that precede it.
  Point is left unchanged unless prefix ARG is supplied.
  If the definition is fully onscreen, it is moved to the top of the
window.  If it is partly offscreen, the window is scrolled to get the
definition (or as much as will fit) onscreen, unless point is in a comment
which is also partly offscreen, in which case the scrolling attempts to get
as much of the comment onscreen as possible.
  Initially `reposition-window' attempts to make both the definition and
preceding comments visible.  Further invocations toggle the visibility of
the comment lines.
  If ARG is non-nil, point may move in order to make the whole defun
visible (if only part could otherwise be made so), to make the defun line
visible (if point is in code and it could not be made so, or if only
comments, including the first comment line, are visible), or to make the
first comment line visible (if point is in a comment).

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "reveal" "reveal.el" (21788 61018 0 0))
;;; Generated autoloads from reveal.el

(autoload 'reveal-mode "reveal" "\
Toggle uncloaking of invisible text near point (Reveal mode).
With a prefix argument ARG, enable Reveal mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
Reveal mode if ARG is omitted or nil.

Reveal mode is a buffer-local minor mode.  When enabled, it
reveals invisible text around point.

\(fn &optional ARG)" t nil)

(defvar global-reveal-mode nil "\
Non-nil if Global-Reveal mode is enabled.
See the command `global-reveal-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-reveal-mode'.")

(custom-autoload 'global-reveal-mode "reveal" nil)

(autoload 'global-reveal-mode "reveal" "\
Toggle Reveal mode in all buffers (Global Reveal mode).
Reveal mode renders invisible text around point visible again.

With a prefix argument ARG, enable Global Reveal mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "ring" "emacs-lisp/ring.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from emacs-lisp/ring.el

(autoload 'ring-p "ring" "\
Return t if X is a ring; nil otherwise.

\(fn X)" nil nil)

(autoload 'make-ring "ring" "\
Make a ring that can contain SIZE elements.

\(fn SIZE)" nil nil)

;;;***

;;;### (autoloads nil "rlogin" "net/rlogin.el" (21710 25077 0 0))
;;; Generated autoloads from net/rlogin.el

(autoload 'rlogin "rlogin" "\
Open a network login connection via `rlogin' with args INPUT-ARGS.
INPUT-ARGS should start with a host name; it may also contain
other arguments for `rlogin'.

Input is sent line-at-a-time to the remote connection.

Communication with the remote host is recorded in a buffer `*rlogin-HOST*'
\(or `*rlogin-USER@HOST*' if the remote username differs).
If a prefix argument is given and the buffer `*rlogin-HOST*' already exists,
a new buffer with a different connection will be made.

When called from a program, if the optional second argument BUFFER is
a string or buffer, it specifies the buffer to use.

The variable `rlogin-program' contains the name of the actual program to
run.  It can be a relative or absolute path.

The variable `rlogin-explicit-args' is a list of arguments to give to
the rlogin when starting.  They are added after any arguments given in
INPUT-ARGS.

If the default value of `rlogin-directory-tracking-mode' is t, then the
default directory in that buffer is set to a remote (FTP) file name to
access your home directory on the remote machine.  Occasionally this causes
an error, if you cannot access the home directory on that machine.  This
error is harmless as long as you don't try to use that default directory.

If `rlogin-directory-tracking-mode' is neither t nor nil, then the default
directory is initially set up to your (local) home directory.
This is useful if the remote machine and your local machine
share the same files via NFS.  This is the default.

If you wish to change directory tracking styles during a session, use the
function `rlogin-directory-tracking-mode' rather than simply setting the
variable.

\(fn INPUT-ARGS &optional BUFFER)" t nil)

;;;***

;;;### (autoloads nil "rmail" "mail/rmail.el" (21788 61018 0 0))
;;; Generated autoloads from mail/rmail.el

(defvar rmail-file-name (purecopy "~/RMAIL") "\
Name of user's primary mail file.")

(custom-autoload 'rmail-file-name "rmail" t)

(put 'rmail-spool-directory 'standard-value '((cond ((file-exists-p "/var/mail") "/var/mail/") ((file-exists-p "/var/spool/mail") "/var/spool/mail/") ((memq system-type '(hpux usg-unix-v irix)) "/usr/mail/") (t "/usr/spool/mail/"))))

(defvar rmail-spool-directory (purecopy (cond ((file-exists-p "/var/mail") "/var/mail/") ((file-exists-p "/var/spool/mail") "/var/spool/mail/") ((memq system-type '(hpux usg-unix-v irix)) "/usr/mail/") (t "/usr/spool/mail/"))) "\
Name of directory used by system mailer for delivering new mail.
Its name should end with a slash.")

(custom-autoload 'rmail-spool-directory "rmail" t)
(custom-initialize-delay 'rmail-spool-directory nil)

(autoload 'rmail-movemail-variant-p "rmail" "\
Return t if the current movemail variant is any of VARIANTS.
Currently known variants are 'emacs and 'mailutils.

\(fn &rest VARIANTS)" nil nil)

(defvar rmail-user-mail-address-regexp nil "\
Regexp matching user mail addresses.
If non-nil, this variable is used to identify the correspondent
when receiving new mail.  If it matches the address of the sender,
the recipient is taken as correspondent of a mail.
If nil (default value), your `user-login-name' and `user-mail-address'
are used to exclude yourself as correspondent.

Usually you don't have to set this variable, except if you collect mails
sent by you under different user names.
Then it should be a regexp matching your mail addresses.

Setting this variable has an effect only before reading a mail.")

(custom-autoload 'rmail-user-mail-address-regexp "rmail" t)

(define-obsolete-variable-alias 'rmail-dont-reply-to-names 'mail-dont-reply-to-names "24.1")

(defvar rmail-default-dont-reply-to-names nil "\
Regexp specifying part of the default value of `mail-dont-reply-to-names'.
This is used when the user does not set `mail-dont-reply-to-names'
explicitly.")

(make-obsolete-variable 'rmail-default-dont-reply-to-names 'mail-dont-reply-to-names "24.1")

(defvar rmail-ignored-headers (purecopy (concat "^via:\\|^mail-from:\\|^origin:\\|^references:\\|^sender:" "\\|^status:\\|^received:\\|^x400-originator:\\|^x400-recipients:" "\\|^x400-received:\\|^x400-mts-identifier:\\|^x400-content-type:" "\\|^\\(resent-\\|\\)message-id:\\|^summary-line:\\|^resent-date:" "\\|^nntp-posting-host:\\|^path:\\|^x-char.*:\\|^x-face:\\|^face:" "\\|^x-mailer:\\|^delivered-to:\\|^lines:" "\\|^content-transfer-encoding:\\|^x-coding-system:" "\\|^return-path:\\|^errors-to:\\|^return-receipt-to:" "\\|^precedence:\\|^mime-version:" "\\|^list-owner:\\|^list-help:\\|^list-post:\\|^list-subscribe:" "\\|^list-id:\\|^list-unsubscribe:\\|^list-archive:" "\\|^content-length:\\|^nntp-posting-date:\\|^user-agent" "\\|^importance:\\|^envelope-to:\\|^delivery-date\\|^openpgp:" "\\|^mbox-line:\\|^cancel-lock:" "\\|^DomainKey-Signature:\\|^dkim-signature:" "\\|^resent-face:\\|^resent-x.*:\\|^resent-organization:\\|^resent-openpgp:" "\\|^x-.*:")) "\
Regexp to match header fields that Rmail should normally hide.
\(See also `rmail-nonignored-headers', which overrides this regexp.)
This variable is used for reformatting the message header,
which normally happens once for each message,
when you view the message for the first time in Rmail.
To make a change in this variable take effect
for a message that you have already viewed,
go to that message and type \\[rmail-toggle-header] twice.")

(custom-autoload 'rmail-ignored-headers "rmail" t)

(defvar rmail-displayed-headers nil "\
Regexp to match Header fields that Rmail should display.
If nil, display all header fields except those matched by
`rmail-ignored-headers'.")

(custom-autoload 'rmail-displayed-headers "rmail" t)

(defvar rmail-retry-ignored-headers (purecopy "^x-authentication-warning:\\|^x-detected-operating-system:\\|^x-spam[-a-z]*:\\|content-type:\\|content-transfer-encoding:\\|mime-version:\\|message-id:") "\
Headers that should be stripped when retrying a failed message.")

(custom-autoload 'rmail-retry-ignored-headers "rmail" t)

(defvar rmail-highlighted-headers (purecopy "^From:\\|^Subject:") "\
Regexp to match Header fields that Rmail should normally highlight.
A value of nil means don't highlight.  Uses the face `rmail-highlight'.")

(custom-autoload 'rmail-highlighted-headers "rmail" t)

(defvar rmail-primary-inbox-list nil "\
List of files that are inboxes for your primary mail file `rmail-file-name'.
If this is nil, uses the environment variable MAIL.  If that is
unset, uses a file named by the function `user-login-name' in the
directory `rmail-spool-directory' (whose value depends on the
operating system).  For example, \"/var/mail/USER\".")

(custom-autoload 'rmail-primary-inbox-list "rmail" t)

(defvar rmail-secondary-file-directory (purecopy "~/") "\
Directory for additional secondary Rmail files.")

(custom-autoload 'rmail-secondary-file-directory "rmail" t)

(defvar rmail-secondary-file-regexp (purecopy "\\.xmail$") "\
Regexp for which files are secondary Rmail files.")

(custom-autoload 'rmail-secondary-file-regexp "rmail" t)

(defvar rmail-mode-hook nil "\
List of functions to call when Rmail is invoked.")

(defvar rmail-show-message-hook nil "\
List of functions to call when Rmail displays a message.")

(custom-autoload 'rmail-show-message-hook "rmail" t)

(defvar rmail-file-coding-system nil "\
Coding system used in RMAIL file.

This is set to nil by default.")

(defvar rmail-insert-mime-forwarded-message-function nil "\
Function to insert a message in MIME format so it can be forwarded.
This function is called if `rmail-enable-mime' and
`rmail-enable-mime-composing' are non-nil.
It is called with one argument FORWARD-BUFFER, which is a
buffer containing the message to forward.  The current buffer
is the outgoing mail buffer.")

(autoload 'rmail "rmail" "\
Read and edit incoming mail.
Moves messages into file named by `rmail-file-name' and edits that
file in RMAIL Mode.
Type \\[describe-mode] once editing that file, for a list of RMAIL commands.

May be called with file name as argument; then performs rmail editing on
that file, but does not copy any new mail into the file.
Interactively, if you supply a prefix argument, then you
have a chance to specify a file name with the minibuffer.

If `rmail-display-summary' is non-nil, make a summary for this RMAIL file.

\(fn &optional FILE-NAME-ARG)" t nil)

(autoload 'rmail-mode "rmail" "\
Rmail Mode is used by \\<rmail-mode-map>\\[rmail] for editing Rmail files.
All normal editing commands are turned off.
Instead, these commands are available:

\\[rmail-beginning-of-message]	Move point to front of this message.
\\[rmail-end-of-message]	Move point to bottom of this message.
\\[scroll-up]	Scroll to next screen of this message.
\\[scroll-down]	Scroll to previous screen of this message.
\\[rmail-next-undeleted-message]	Move to Next non-deleted message.
\\[rmail-previous-undeleted-message]	Move to Previous non-deleted message.
\\[rmail-next-message]	Move to Next message whether deleted or not.
\\[rmail-previous-message]	Move to Previous message whether deleted or not.
\\[rmail-first-message]	Move to the first message in Rmail file.
\\[rmail-last-message]	Move to the last message in Rmail file.
\\[rmail-show-message]	Jump to message specified by numeric position in file.
\\[rmail-search]	Search for string and show message it is found in.
\\[rmail-delete-forward]	Delete this message, move to next nondeleted.
\\[rmail-delete-backward]	Delete this message, move to previous nondeleted.
\\[rmail-undelete-previous-message]	Undelete message.  Tries current message, then earlier messages
	till a deleted message is found.
\\[rmail-edit-current-message]	Edit the current message.  \\[rmail-cease-edit] to return to Rmail.
\\[rmail-expunge]	Expunge deleted messages.
\\[rmail-expunge-and-save]	Expunge and save the file.
\\[rmail-quit]       Quit Rmail: expunge, save, then switch to another buffer.
\\[save-buffer] Save without expunging.
\\[rmail-get-new-mail]	Move new mail from system spool directory into this file.
\\[rmail-mail]	Mail a message (same as \\[mail-other-window]).
\\[rmail-continue]	Continue composing outgoing message started before.
\\[rmail-reply]	Reply to this message.  Like \\[rmail-mail] but initializes some fields.
\\[rmail-retry-failure]	Send this message again.  Used on a mailer failure message.
\\[rmail-forward]	Forward this message to another user.
\\[rmail-output]	Output (append) this message to another mail file.
\\[rmail-output-as-seen]	Output (append) this message to file as it's displayed.
\\[rmail-output-body-to-file]	Save message body to a file.  Default filename comes from Subject line.
\\[rmail-input]	Input Rmail file.  Run Rmail on that file.
\\[rmail-add-label]	Add label to message.  It will be displayed in the mode line.
\\[rmail-kill-label]	Kill label.  Remove a label from current message.
\\[rmail-next-labeled-message]   Move to Next message with specified label
          (label defaults to last one specified).
          Standard labels: filed, unseen, answered, forwarded, deleted.
          Any other label is present only if you add it with \\[rmail-add-label].
\\[rmail-previous-labeled-message]   Move to Previous message with specified label
\\[rmail-summary]	Show headers buffer, with a one line summary of each message.
\\[rmail-summary-by-labels]	Summarize only messages with particular label(s).
\\[rmail-summary-by-recipients]   Summarize only messages with particular recipient(s).
\\[rmail-summary-by-regexp]   Summarize only messages with particular regexp(s).
\\[rmail-summary-by-topic]   Summarize only messages with subject line regexp(s).
\\[rmail-toggle-header]	Toggle display of complete header.

\(fn)" t nil)

(autoload 'rmail-input "rmail" "\
Run Rmail on file FILENAME.

\(fn FILENAME)" t nil)

(autoload 'rmail-set-remote-password "rmail" "\
Set PASSWORD to be used for retrieving mail from a POP or IMAP server.

\(fn PASSWORD)" t nil)

;;;***

;;;### (autoloads nil "rmailout" "mail/rmailout.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/rmailout.el
(put 'rmail-output-file-alist 'risky-local-variable t)

(autoload 'rmail-output "rmailout" "\
Append this message to mail file FILE-NAME.
Writes mbox format, unless FILE-NAME exists and is Babyl format, in which
case it writes Babyl.

Interactively, the default file name comes from `rmail-default-file',
which is updated to the name you use in this command.  In all uses, if
FILE-NAME is not absolute, it is expanded with the directory part of
`rmail-default-file'.

If a buffer is visiting FILE-NAME, adds the text to that buffer
rather than saving the file directly.  If the buffer is an Rmail
buffer, updates it accordingly.

This command always outputs the complete message header, even if
the header display is currently pruned.

Optional prefix argument COUNT (default 1) says to output that
many consecutive messages, starting with the current one (ignoring
deleted messages).  If `rmail-delete-after-output' is non-nil, deletes
messages after output.

The optional third argument NOATTRIBUTE, if non-nil, says not to
set the `filed' attribute, and not to display a \"Wrote file\"
message (if writing a file directly).

Set the optional fourth argument NOT-RMAIL non-nil if you call this
from a non-Rmail buffer.  In this case, COUNT is ignored.

\(fn FILE-NAME &optional COUNT NOATTRIBUTE NOT-RMAIL)" t nil)

(autoload 'rmail-output-as-seen "rmailout" "\
Append this message to mbox file named FILE-NAME.
The details are as for `rmail-output', except that:
  i) the header is output as currently seen
 ii) this function cannot write to Babyl files
iii) an Rmail buffer cannot be visiting FILE-NAME

Note that if NOT-RMAIL is non-nil, there is no difference between this
function and `rmail-output'.  This argument may be removed in future,
so you should call `rmail-output' directly in that case.

\(fn FILE-NAME &optional COUNT NOATTRIBUTE NOT-RMAIL)" t nil)

(autoload 'rmail-output-body-to-file "rmailout" "\
Write this message body to the file FILE-NAME.
Interactively, the default file name comes from either the message
\"Subject\" header, or from `rmail-default-body-file'.  Updates the value
of `rmail-default-body-file' accordingly.  In all uses, if FILE-NAME
is not absolute, it is expanded with the directory part of
`rmail-default-body-file'.

Note that this overwrites FILE-NAME (after confirmation), rather
than appending to it.  Deletes the message after writing if
`rmail-delete-after-output' is non-nil.

\(fn FILE-NAME)" t nil)

;;;***

;;;### (autoloads nil "rng-cmpct" "nxml/rng-cmpct.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from nxml/rng-cmpct.el

(autoload 'rng-c-load-schema "rng-cmpct" "\
Load a schema in RELAX NG compact syntax from FILENAME.
Return a pattern.

\(fn FILENAME)" nil nil)

;;;***

;;;### (autoloads nil "rng-nxml" "nxml/rng-nxml.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from nxml/rng-nxml.el

(autoload 'rng-nxml-mode-init "rng-nxml" "\
Initialize `nxml-mode' to take advantage of `rng-validate-mode'.
This is typically called from `nxml-mode-hook'.
Validation will be enabled if `rng-nxml-auto-validate-flag' is non-nil.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "rng-valid" "nxml/rng-valid.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from nxml/rng-valid.el

(autoload 'rng-validate-mode "rng-valid" "\
Minor mode performing continual validation against a RELAX NG schema.

Checks whether the buffer is a well-formed XML 1.0 document,
conforming to the XML Namespaces Recommendation and valid against a
RELAX NG schema.  The mode-line indicates whether it is or not.  Any
parts of the buffer that cause it not to be are considered errors and
are highlighted with face `rng-error'.  A description of each error is
available as a tooltip.  \\[rng-next-error] goes to the next error
after point.  Clicking mouse-1 on the word `Invalid' in the mode-line
goes to the first error in the buffer.  If the buffer changes, then it
will be automatically rechecked when Emacs becomes idle; the
rechecking will be paused whenever there is input pending.

By default, uses a vacuous schema that allows any well-formed XML
document.  A schema can be specified explicitly using
\\[rng-set-schema-file-and-validate], or implicitly based on the buffer's
file name or on the root element name.  In each case the schema must
be a RELAX NG schema using the compact schema (such schemas
conventionally have a suffix of `.rnc').  The variable
`rng-schema-locating-files' specifies files containing rules
to use for finding the schema.

\(fn &optional ARG NO-CHANGE-SCHEMA)" t nil)

;;;***

;;;### (autoloads nil "rng-xsd" "nxml/rng-xsd.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from nxml/rng-xsd.el

(put 'http://www\.w3\.org/2001/XMLSchema-datatypes 'rng-dt-compile 'rng-xsd-compile)

(autoload 'rng-xsd-compile "rng-xsd" "\
Provides W3C XML Schema as a RELAX NG datatypes library.
NAME is a symbol giving the local name of the datatype.  PARAMS is a
list of pairs (PARAM-NAME . PARAM-VALUE) where PARAM-NAME is a symbol
giving the name of the parameter and PARAM-VALUE is a string giving
its value.  If NAME or PARAMS are invalid, it calls rng-dt-error
passing it arguments in the same style as format; the value from
rng-dt-error will be returned.  Otherwise, it returns a list.  The
first member of the list is t if any string is a legal value for the
datatype and nil otherwise.  The second argument is a symbol; this
symbol will be called as a function passing it a string followed by
the remaining members of the list.  The function must return an object
representing the value of the datatype that was represented by the
string, or nil if the string is not a representation of any value.
The object returned can be any convenient non-nil value, provided
that, if two strings represent the same value, the returned objects
must be equal.

\(fn NAME PARAMS)" nil nil)

;;;***

;;;### (autoloads nil "robin" "international/robin.el" (21676 8646
;;;;;;  0 0))
;;; Generated autoloads from international/robin.el

(autoload 'robin-define-package "robin" "\
Define a robin package.

NAME is the string of this robin package.
DOCSTRING is the documentation string of this robin package.
Each RULE is of the form (INPUT OUTPUT) where INPUT is a string and
OUTPUT is either a character or a string.  RULES are not evaluated.

If there already exists a robin package whose name is NAME, the new
one replaces the old one.

\(fn NAME DOCSTRING &rest RULES)" nil t)

(autoload 'robin-modify-package "robin" "\
Change a rule in an already defined robin package.

NAME is the string specifying a robin package.
INPUT is a string that specifies the input pattern.
OUTPUT is either a character or a string to be generated.

\(fn NAME INPUT OUTPUT)" nil nil)

(autoload 'robin-use-package "robin" "\
Start using robin package NAME, which is a string.

\(fn NAME)" nil nil)

;;;***

;;;### (autoloads nil "rot13" "rot13.el" (21710 25077 0 0))
;;; Generated autoloads from rot13.el

(autoload 'rot13 "rot13" "\
Return ROT13 encryption of OBJECT, a buffer or string.

\(fn OBJECT &optional START END)" nil nil)

(autoload 'rot13-string "rot13" "\
Return ROT13 encryption of STRING.

\(fn STRING)" nil nil)

(autoload 'rot13-region "rot13" "\
ROT13 encrypt the region between START and END in current buffer.

\(fn START END)" t nil)

(autoload 'rot13-other-window "rot13" "\
Display current buffer in ROT13 in another window.
The text itself is not modified, only the way it is displayed is affected.

To terminate the ROT13 display, delete that window.  As long as that window
is not deleted, any buffer displayed in it will become instantly encoded
in ROT13.

See also `toggle-rot13-mode'.

\(fn)" t nil)

(autoload 'toggle-rot13-mode "rot13" "\
Toggle the use of ROT13 encoding for the current window.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "rst" "textmodes/rst.el" (21788 61018 0 0))
;;; Generated autoloads from textmodes/rst.el
 (add-to-list 'auto-mode-alist (purecopy '("\\.re?st\\'" . rst-mode)))

(autoload 'rst-mode "rst" "\
Major mode for editing reStructuredText documents.
\\<rst-mode-map>

Turning on `rst-mode' calls the normal hooks `text-mode-hook'
and `rst-mode-hook'.  This mode also supports font-lock
highlighting.

\\{rst-mode-map}

\(fn)" t nil)

(autoload 'rst-minor-mode "rst" "\
Toggle ReST minor mode.
With a prefix argument ARG, enable ReST minor mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

When ReST minor mode is enabled, the ReST mode keybindings
are installed on top of the major mode bindings.  Use this
for modes derived from Text mode, like Mail mode.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "ruby-mode" "progmodes/ruby-mode.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from progmodes/ruby-mode.el
(push (purecopy '(ruby-mode 1 2)) package--builtin-versions)

(autoload 'ruby-mode "ruby-mode" "\
Major mode for editing Ruby code.

\\{ruby-mode-map}

\(fn)" t nil)

(add-to-list 'auto-mode-alist (cons (purecopy (concat "\\(?:\\." "rb\\|ru\\|rake\\|thor" "\\|jbuilder\\|gemspec\\|podspec" "\\|/" "\\(?:Gem\\|Rake\\|Cap\\|Thor" "\\|Vagrant\\|Guard\\|Pod\\)file" "\\)\\'")) 'ruby-mode))

(dolist (name (list "ruby" "rbx" "jruby" "ruby1.9" "ruby1.8")) (add-to-list 'interpreter-mode-alist (cons (purecopy name) 'ruby-mode)))

;;;***

;;;### (autoloads nil "ruler-mode" "ruler-mode.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from ruler-mode.el
(push (purecopy '(ruler-mode 1 6)) package--builtin-versions)

(defvar ruler-mode nil "\
Non-nil if Ruler mode is enabled.
Use the command `ruler-mode' to change this variable.")

(autoload 'ruler-mode "ruler-mode" "\
Toggle display of ruler in header line (Ruler mode).
With a prefix argument ARG, enable Ruler mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "rx" "emacs-lisp/rx.el" (21710 25077 0 0))
;;; Generated autoloads from emacs-lisp/rx.el

(autoload 'rx-to-string "rx" "\
Parse and produce code for regular expression FORM.
FORM is a regular expression in sexp form.
NO-GROUP non-nil means don't put shy groups around the result.

\(fn FORM &optional NO-GROUP)" nil nil)

(autoload 'rx "rx" "\
Translate regular expressions REGEXPS in sexp form to a regexp string.
REGEXPS is a non-empty sequence of forms of the sort listed below.

Note that `rx' is a Lisp macro; when used in a Lisp program being
compiled, the translation is performed by the compiler.
See `rx-to-string' for how to do such a translation at run-time.

The following are valid subforms of regular expressions in sexp
notation.

STRING
     matches string STRING literally.

CHAR
     matches character CHAR literally.

`not-newline', `nonl'
     matches any character except a newline.

`anything'
     matches any character

`(any SET ...)'
`(in SET ...)'
`(char SET ...)'
     matches any character in SET ....  SET may be a character or string.
     Ranges of characters can be specified as `A-Z' in strings.
     Ranges may also be specified as conses like `(?A . ?Z)'.

     SET may also be the name of a character class: `digit',
     `control', `hex-digit', `blank', `graph', `print', `alnum',
     `alpha', `ascii', `nonascii', `lower', `punct', `space', `upper',
     `word', or one of their synonyms.

`(not (any SET ...))'
     matches any character not in SET ...

`line-start', `bol'
     matches the empty string, but only at the beginning of a line
     in the text being matched

`line-end', `eol'
     is similar to `line-start' but matches only at the end of a line

`string-start', `bos', `bot'
     matches the empty string, but only at the beginning of the
     string being matched against.

`string-end', `eos', `eot'
     matches the empty string, but only at the end of the
     string being matched against.

`buffer-start'
     matches the empty string, but only at the beginning of the
     buffer being matched against.  Actually equivalent to `string-start'.

`buffer-end'
     matches the empty string, but only at the end of the
     buffer being matched against.  Actually equivalent to `string-end'.

`point'
     matches the empty string, but only at point.

`word-start', `bow'
     matches the empty string, but only at the beginning of a word.

`word-end', `eow'
     matches the empty string, but only at the end of a word.

`word-boundary'
     matches the empty string, but only at the beginning or end of a
     word.

`(not word-boundary)'
`not-word-boundary'
     matches the empty string, but not at the beginning or end of a
     word.

`symbol-start'
     matches the empty string, but only at the beginning of a symbol.

`symbol-end'
     matches the empty string, but only at the end of a symbol.

`digit', `numeric', `num'
     matches 0 through 9.

`control', `cntrl'
     matches ASCII control characters.

`hex-digit', `hex', `xdigit'
     matches 0 through 9, a through f and A through F.

`blank'
     matches space and tab only.

`graphic', `graph'
     matches graphic characters--everything except ASCII control chars,
     space, and DEL.

`printing', `print'
     matches printing characters--everything except ASCII control chars
     and DEL.

`alphanumeric', `alnum'
     matches letters and digits.  (But at present, for multibyte characters,
     it matches anything that has word syntax.)

`letter', `alphabetic', `alpha'
     matches letters.  (But at present, for multibyte characters,
     it matches anything that has word syntax.)

`ascii'
     matches ASCII (unibyte) characters.

`nonascii'
     matches non-ASCII (multibyte) characters.

`lower', `lower-case'
     matches anything lower-case.

`upper', `upper-case'
     matches anything upper-case.

`punctuation', `punct'
     matches punctuation.  (But at present, for multibyte characters,
     it matches anything that has non-word syntax.)

`space', `whitespace', `white'
     matches anything that has whitespace syntax.

`word', `wordchar'
     matches anything that has word syntax.

`not-wordchar'
     matches anything that has non-word syntax.

`(syntax SYNTAX)'
     matches a character with syntax SYNTAX.  SYNTAX must be one
     of the following symbols, or a symbol corresponding to the syntax
     character, e.g. `\\.' for `\\s.'.

     `whitespace'		(\\s- in string notation)
     `punctuation'		(\\s.)
     `word'			(\\sw)
     `symbol'			(\\s_)
     `open-parenthesis'		(\\s()
     `close-parenthesis'	(\\s))
     `expression-prefix'	(\\s')
     `string-quote'		(\\s\")
     `paired-delimiter'		(\\s$)
     `escape'			(\\s\\)
     `character-quote'		(\\s/)
     `comment-start'		(\\s<)
     `comment-end'		(\\s>)
     `string-delimiter'		(\\s|)
     `comment-delimiter'	(\\s!)

`(not (syntax SYNTAX))'
     matches a character that doesn't have syntax SYNTAX.

`(category CATEGORY)'
     matches a character with category CATEGORY.  CATEGORY must be
     either a character to use for C, or one of the following symbols.

     `consonant'			(\\c0 in string notation)
     `base-vowel'			(\\c1)
     `upper-diacritical-mark'		(\\c2)
     `lower-diacritical-mark'		(\\c3)
     `tone-mark'		        (\\c4)
     `symbol'			        (\\c5)
     `digit'			        (\\c6)
     `vowel-modifying-diacritical-mark'	(\\c7)
     `vowel-sign'			(\\c8)
     `semivowel-lower'			(\\c9)
     `not-at-end-of-line'		(\\c<)
     `not-at-beginning-of-line'		(\\c>)
     `alpha-numeric-two-byte'		(\\cA)
     `chinese-two-byte'			(\\cC)
     `greek-two-byte'			(\\cG)
     `japanese-hiragana-two-byte'	(\\cH)
     `indian-tow-byte'			(\\cI)
     `japanese-katakana-two-byte'	(\\cK)
     `korean-hangul-two-byte'		(\\cN)
     `cyrillic-two-byte'		(\\cY)
     `combining-diacritic'		(\\c^)
     `ascii'				(\\ca)
     `arabic'				(\\cb)
     `chinese'				(\\cc)
     `ethiopic'				(\\ce)
     `greek'				(\\cg)
     `korean'				(\\ch)
     `indian'				(\\ci)
     `japanese'				(\\cj)
     `japanese-katakana'		(\\ck)
     `latin'				(\\cl)
     `lao'				(\\co)
     `tibetan'				(\\cq)
     `japanese-roman'			(\\cr)
     `thai'				(\\ct)
     `vietnamese'			(\\cv)
     `hebrew'				(\\cw)
     `cyrillic'				(\\cy)
     `can-break'			(\\c|)

`(not (category CATEGORY))'
     matches a character that doesn't have category CATEGORY.

`(and SEXP1 SEXP2 ...)'
`(: SEXP1 SEXP2 ...)'
`(seq SEXP1 SEXP2 ...)'
`(sequence SEXP1 SEXP2 ...)'
     matches what SEXP1 matches, followed by what SEXP2 matches, etc.

`(submatch SEXP1 SEXP2 ...)'
`(group SEXP1 SEXP2 ...)'
     like `and', but makes the match accessible with `match-end',
     `match-beginning', and `match-string'.

`(submatch-n N SEXP1 SEXP2 ...)'
`(group-n N SEXP1 SEXP2 ...)'
     like `group', but make it an explicitly-numbered group with
     group number N.

`(or SEXP1 SEXP2 ...)'
`(| SEXP1 SEXP2 ...)'
     matches anything that matches SEXP1 or SEXP2, etc.  If all
     args are strings, use `regexp-opt' to optimize the resulting
     regular expression.

`(minimal-match SEXP)'
     produce a non-greedy regexp for SEXP.  Normally, regexps matching
     zero or more occurrences of something are \"greedy\" in that they
     match as much as they can, as long as the overall regexp can
     still match.  A non-greedy regexp matches as little as possible.

`(maximal-match SEXP)'
     produce a greedy regexp for SEXP.  This is the default.

Below, `SEXP ...' represents a sequence of regexp forms, treated as if
enclosed in `(and ...)'.

`(zero-or-more SEXP ...)'
`(0+ SEXP ...)'
     matches zero or more occurrences of what SEXP ... matches.

`(* SEXP ...)'
     like `zero-or-more', but always produces a greedy regexp, independent
     of `rx-greedy-flag'.

`(*? SEXP ...)'
     like `zero-or-more', but always produces a non-greedy regexp,
     independent of `rx-greedy-flag'.

`(one-or-more SEXP ...)'
`(1+ SEXP ...)'
     matches one or more occurrences of SEXP ...

`(+ SEXP ...)'
     like `one-or-more', but always produces a greedy regexp.

`(+? SEXP ...)'
     like `one-or-more', but always produces a non-greedy regexp.

`(zero-or-one SEXP ...)'
`(optional SEXP ...)'
`(opt SEXP ...)'
     matches zero or one occurrences of A.

`(? SEXP ...)'
     like `zero-or-one', but always produces a greedy regexp.

`(?? SEXP ...)'
     like `zero-or-one', but always produces a non-greedy regexp.

`(repeat N SEXP)'
`(= N SEXP ...)'
     matches N occurrences.

`(>= N SEXP ...)'
     matches N or more occurrences.

`(repeat N M SEXP)'
`(** N M SEXP ...)'
     matches N to M occurrences.

`(backref N)'
     matches what was matched previously by submatch N.

`(eval FORM)'
     evaluate FORM and insert result.  If result is a string,
     `regexp-quote' it.

`(regexp REGEXP)'
     include REGEXP in string notation in the result.

\(fn &rest REGEXPS)" nil t)

;;;***

;;;### (autoloads nil "sasl-ntlm" "net/sasl-ntlm.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from net/sasl-ntlm.el
(push (purecopy '(sasl 1 0)) package--builtin-versions)

;;;***

;;;### (autoloads nil "savehist" "savehist.el" (21788 61018 0 0))
;;; Generated autoloads from savehist.el
(push (purecopy '(savehist 24)) package--builtin-versions)

(defvar savehist-mode nil "\
Non-nil if Savehist mode is enabled.
See the command `savehist-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `savehist-mode'.")

(custom-autoload 'savehist-mode "savehist" nil)

(autoload 'savehist-mode "savehist" "\
Toggle saving of minibuffer history (Savehist mode).
With a prefix argument ARG, enable Savehist mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

When Savehist mode is enabled, minibuffer history is saved
periodically and when exiting Emacs.  When Savehist mode is
enabled for the first time in an Emacs session, it loads the
previous minibuffer history from `savehist-file'.

This mode should normally be turned on from your Emacs init file.
Calling it at any other time replaces your current minibuffer
histories, which is probably undesirable.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "scheme" "progmodes/scheme.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/scheme.el

(autoload 'scheme-mode "scheme" "\
Major mode for editing Scheme code.
Editing commands are similar to those of `lisp-mode'.

In addition, if an inferior Scheme process is running, some additional
commands will be defined, for evaluating expressions and controlling
the interpreter, and the state of the process will be displayed in the
mode line of all Scheme buffers.  The names of commands that interact
with the Scheme process start with \"xscheme-\" if you use the MIT
Scheme-specific `xscheme' package; for more information see the
documentation for `xscheme-interaction-mode'.  Use \\[run-scheme] to
start an inferior Scheme using the more general `cmuscheme' package.

Commands:
Delete converts tabs to spaces as it moves back.
Blank lines separate paragraphs.  Semicolons start comments.
\\{scheme-mode-map}

\(fn)" t nil)

(autoload 'dsssl-mode "scheme" "\
Major mode for editing DSSSL code.
Editing commands are similar to those of `lisp-mode'.

Commands:
Delete converts tabs to spaces as it moves back.
Blank lines separate paragraphs.  Semicolons start comments.
\\{scheme-mode-map}
Entering this mode runs the hooks `scheme-mode-hook' and then
`dsssl-mode-hook' and inserts the value of `dsssl-sgml-declaration' if
that variable's value is a string.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "score-mode" "gnus/score-mode.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/score-mode.el

(autoload 'gnus-score-mode "score-mode" "\
Mode for editing Gnus score files.
This mode is an extended emacs-lisp mode.

\\{gnus-score-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "scroll-all" "scroll-all.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from scroll-all.el

(defvar scroll-all-mode nil "\
Non-nil if Scroll-All mode is enabled.
See the command `scroll-all-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `scroll-all-mode'.")

(custom-autoload 'scroll-all-mode "scroll-all" nil)

(autoload 'scroll-all-mode "scroll-all" "\
Toggle shared scrolling in same-frame windows (Scroll-All mode).
With a prefix argument ARG, enable Scroll-All mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

When Scroll-All mode is enabled, scrolling commands invoked in
one window apply to all visible windows in the same frame.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "scroll-lock" "scroll-lock.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from scroll-lock.el

(autoload 'scroll-lock-mode "scroll-lock" "\
Buffer-local minor mode for pager-like scrolling.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.  When enabled, keys that normally move
point by line or paragraph will scroll the buffer by the
respective amount of lines instead and point will be kept
vertically fixed relative to window boundaries during scrolling.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "secrets" "net/secrets.el" (21710 25077 0 0))
;;; Generated autoloads from net/secrets.el
(when (featurep 'dbusbind)
 (autoload 'secrets-show-secrets "secrets" nil t))

;;;***

;;;### (autoloads nil "semantic" "cedet/semantic.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from cedet/semantic.el
(push (purecopy '(semantic 2 2)) package--builtin-versions)

(defvar semantic-default-submodes '(global-semantic-idle-scheduler-mode global-semanticdb-minor-mode) "\
List of auxiliary Semantic minor modes enabled by `semantic-mode'.
The possible elements of this list include the following:

 `global-semanticdb-minor-mode'        - Maintain tag database.
 `global-semantic-idle-scheduler-mode' - Reparse buffer when idle.
 `global-semantic-idle-summary-mode'   - Show summary of tag at point.
 `global-semantic-idle-completions-mode' - Show completions when idle.
 `global-semantic-decoration-mode'     - Additional tag decorations.
 `global-semantic-highlight-func-mode' - Highlight the current tag.
 `global-semantic-stickyfunc-mode'     - Show current fun in header line.
 `global-semantic-mru-bookmark-mode'   - Provide `switch-to-buffer'-like
                                         keybinding for tag names.
 `global-cedet-m3-minor-mode'          - A mouse 3 context menu.
 `global-semantic-idle-local-symbol-highlight-mode' - Highlight references
                                         of the symbol under point.
The following modes are more targeted at people who want to see
 some internal information of the semantic parser in action:
 `global-semantic-highlight-edits-mode' - Visualize incremental parser by
                                         highlighting not-yet parsed changes.
 `global-semantic-show-unmatched-syntax-mode' - Highlight unmatched lexical
                                         syntax tokens.
 `global-semantic-show-parser-state-mode' - Display the parser cache state.")

(custom-autoload 'semantic-default-submodes "semantic" t)

(defvar semantic-mode nil "\
Non-nil if Semantic mode is enabled.
See the command `semantic-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `semantic-mode'.")

(custom-autoload 'semantic-mode "semantic" nil)

(autoload 'semantic-mode "semantic" "\
Toggle parser features (Semantic mode).
With a prefix argument ARG, enable Semantic mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
Semantic mode if ARG is omitted or nil.

In Semantic mode, Emacs parses the buffers you visit for their
semantic content.  This information is used by a variety of
auxiliary minor modes, listed in `semantic-default-submodes';
all the minor modes in this list are also enabled when you enable
Semantic mode.

\\{semantic-mode-map}

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "semantic/bovine/grammar" "cedet/semantic/bovine/grammar.el"
;;;;;;  (21788 61018 0 0))
;;; Generated autoloads from cedet/semantic/bovine/grammar.el

(autoload 'bovine-grammar-mode "semantic/bovine/grammar" "\
Major mode for editing Bovine grammars.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "semantic/wisent/grammar" "cedet/semantic/wisent/grammar.el"
;;;;;;  (21710 25077 0 0))
;;; Generated autoloads from cedet/semantic/wisent/grammar.el

(autoload 'wisent-grammar-mode "semantic/wisent/grammar" "\
Major mode for editing Wisent grammars.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "sendmail" "mail/sendmail.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from mail/sendmail.el

(defvar mail-from-style 'default "\
Specifies how \"From:\" fields look.

If `nil', they contain just the return address like:
	king@grassland.com
If `parens', they look like:
	king@grassland.com (Elvis Parsley)
If `angles', they look like:
	Elvis Parsley <king@grassland.com>

Otherwise, most addresses look like `angles', but they look like
`parens' if `angles' would need quoting and `parens' would not.")

(custom-autoload 'mail-from-style "sendmail" t)

(defvar mail-specify-envelope-from nil "\
If non-nil, specify the envelope-from address when sending mail.
The value used to specify it is whatever is found in
the variable `mail-envelope-from', with `user-mail-address' as fallback.

On most systems, specifying the envelope-from address is a
privileged operation.  This variable affects sendmail and
smtpmail -- if you use feedmail to send mail, see instead the
variable `feedmail-deduce-envelope-from'.")

(custom-autoload 'mail-specify-envelope-from "sendmail" t)

(defvar mail-self-blind nil "\
Non-nil means insert BCC to self in messages to be sent.
This is done when the message is initialized,
so you can remove or alter the BCC field to override the default.")

(custom-autoload 'mail-self-blind "sendmail" t)

(defvar mail-interactive t "\
Non-nil means when sending a message wait for and display errors.
Otherwise, let mailer send back a message to report errors.")

(custom-autoload 'mail-interactive "sendmail" t)

(defvar send-mail-function (if (and (boundp 'smtpmail-smtp-server) smtpmail-smtp-server) 'smtpmail-send-it 'sendmail-query-once) "\
Function to call to send the current buffer as mail.
The headers should be delimited by a line which is
not a valid RFC822 header or continuation line,
that matches the variable `mail-header-separator'.
This is used by the default mail-sending commands.  See also
`message-send-mail-function' for use with the Message package.")

(custom-autoload 'send-mail-function "sendmail" t)

(defvar mail-header-separator (purecopy "--text follows this line--") "\
Line used to separate headers from text in messages being composed.")

(custom-autoload 'mail-header-separator "sendmail" t)

(defvar mail-archive-file-name nil "\
Name of file to write all outgoing messages in, or nil for none.
This is normally an mbox file, but for backwards compatibility may also
be a Babyl file.")

(custom-autoload 'mail-archive-file-name "sendmail" t)

(defvar mail-default-reply-to nil "\
Address to insert as default Reply-to field of outgoing messages.
If nil, it will be initialized from the REPLYTO environment variable
when you first send mail.")

(custom-autoload 'mail-default-reply-to "sendmail" t)

(defvar mail-personal-alias-file (purecopy "~/.mailrc") "\
If non-nil, the name of the user's personal mail alias file.
This file typically should be in same format as the `.mailrc' file used by
the `Mail' or `mailx' program.
This file need not actually exist.")

(custom-autoload 'mail-personal-alias-file "sendmail" t)

(defvar mail-setup-hook nil "\
Normal hook, run each time a new outgoing message is initialized.")

(custom-autoload 'mail-setup-hook "sendmail" t)

(defvar mail-aliases t "\
Alist of mail address aliases,
or t meaning should be initialized from your mail aliases file.
\(The file's name is normally `~/.mailrc', but `mail-personal-alias-file'
can specify a different file name.)
The alias definitions in the file have this form:
    alias ALIAS MEANING")

(defvar mail-yank-prefix "> " "\
Prefix insert on lines of yanked message being replied to.
If this is nil, use indentation, as specified by `mail-indentation-spaces'.")

(custom-autoload 'mail-yank-prefix "sendmail" t)

(defvar mail-indentation-spaces 3 "\
Number of spaces to insert at the beginning of each cited line.
Used by `mail-yank-original' via `mail-indent-citation'.")

(custom-autoload 'mail-indentation-spaces "sendmail" t)

(defvar mail-citation-hook nil "\
Hook for modifying a citation just inserted in the mail buffer.
Each hook function can find the citation between (point) and (mark t),
and should leave point and mark around the citation text as modified.
The hook functions can find the header of the cited message
in the variable `mail-citation-header', whether or not this is included
in the cited portion of the message.

If this hook is entirely empty (nil), a default action is taken
instead of no action.")

(custom-autoload 'mail-citation-hook "sendmail" t)

(defvar mail-citation-prefix-regexp (purecopy "\\([ 	]*\\(\\w\\|[_.]\\)+>+\\|[ 	]*[]>|]\\)+") "\
Regular expression to match a citation prefix plus whitespace.
It should match whatever sort of citation prefixes you want to handle,
with whitespace before and after; it should also match just whitespace.
The default value matches citations like `foo-bar>' plus whitespace.")

(custom-autoload 'mail-citation-prefix-regexp "sendmail" t)

(defvar mail-signature t "\
Text inserted at end of mail buffer when a message is initialized.
If t, it means to insert the contents of the file `mail-signature-file'.
If a string, that string is inserted.
 (To make a proper signature, the string should begin with \\n\\n-- \\n,
  which is the standard way to delimit a signature in a message.)
Otherwise, it should be an expression; it is evaluated
and should insert whatever you want to insert.")

(custom-autoload 'mail-signature "sendmail" t)

(defvar mail-signature-file (purecopy "~/.signature") "\
File containing the text inserted at end of mail buffer.")

(custom-autoload 'mail-signature-file "sendmail" t)

(defvar mail-default-directory (purecopy "~/") "\
Value of `default-directory' for Mail mode buffers.
This directory is used for auto-save files of Mail mode buffers.

Note that Message mode does not use this variable; it auto-saves
in `message-auto-save-directory'.")

(custom-autoload 'mail-default-directory "sendmail" t)

(defvar mail-default-headers nil "\
A string containing header lines, to be inserted in outgoing messages.
It can contain newlines, and should end in one.  It is inserted
before you edit the message, so you can edit or delete the lines.")

(custom-autoload 'mail-default-headers "sendmail" t)

(autoload 'sendmail-query-once "sendmail" "\
Query for `send-mail-function' and send mail with it.
This also saves the value of `send-mail-function' via Customize.

\(fn)" nil nil)

(define-mail-user-agent 'sendmail-user-agent 'sendmail-user-agent-compose 'mail-send-and-exit)

(autoload 'sendmail-user-agent-compose "sendmail" "\


\(fn &optional TO SUBJECT OTHER-HEADERS CONTINUE SWITCH-FUNCTION YANK-ACTION SEND-ACTIONS RETURN-ACTION &rest IGNORED)" nil nil)

(autoload 'mail-mode "sendmail" "\
Major mode for editing mail to be sent.
Like Text Mode but with these additional commands:

\\[mail-send]  mail-send (send the message)
\\[mail-send-and-exit]  mail-send-and-exit (send the message and exit)

Here are commands that move to a header field (and create it if there isn't):
	 \\[mail-to]  move to To:	\\[mail-subject]  move to Subj:
	 \\[mail-bcc]  move to BCC:	\\[mail-cc]  move to CC:
	 \\[mail-fcc]  move to FCC:	\\[mail-reply-to] move to Reply-To:
         \\[mail-mail-reply-to]  move to Mail-Reply-To:
         \\[mail-mail-followup-to] move to Mail-Followup-To:
\\[mail-text]  move to message text.
\\[mail-signature]  mail-signature (insert `mail-signature-file' file).
\\[mail-yank-original]  mail-yank-original (insert current message, in Rmail).
\\[mail-fill-yanked-message]  mail-fill-yanked-message (fill what was yanked).
\\[mail-insert-file] insert a text file into the message.
\\[mail-add-attachment] attach to the message a file as binary attachment.
Turning on Mail mode runs the normal hooks `text-mode-hook' and
`mail-mode-hook' (in that order).

\(fn)" t nil)

(defvar mail-mailing-lists nil "\
List of mailing list addresses the user is subscribed to.
The variable is used to trigger insertion of the \"Mail-Followup-To\"
header when sending a message to a mailing list.")

(custom-autoload 'mail-mailing-lists "sendmail" t)

(defvar sendmail-coding-system nil "\
Coding system for encoding the outgoing mail.
This has higher priority than the default `buffer-file-coding-system'
and `default-sendmail-coding-system',
but lower priority than the local value of `buffer-file-coding-system'.
See also the function `select-message-coding-system'.")

(defvar default-sendmail-coding-system 'iso-latin-1 "\
Default coding system for encoding the outgoing mail.
This variable is used only when `sendmail-coding-system' is nil.

This variable is set/changed by the command `set-language-environment'.
User should not set this variable manually,
instead use `sendmail-coding-system' to get a constant encoding
of outgoing mails regardless of the current language environment.
See also the function `select-message-coding-system'.")

(autoload 'mail "sendmail" "\
Edit a message to be sent.  Prefix arg means resume editing (don't erase).
When this function returns, the buffer `*mail*' is selected.
The value is t if the message was newly initialized; otherwise, nil.

Optionally, the signature file `mail-signature-file' can be inserted at the
end; see the variable `mail-signature'.

\\<mail-mode-map>
While editing message, type \\[mail-send-and-exit] to send the message and exit.

Various special commands starting with C-c are available in sendmail mode
to move to message header fields:
\\{mail-mode-map}

If `mail-self-blind' is non-nil, a BCC to yourself is inserted
when the message is initialized.

If `mail-default-reply-to' is non-nil, it should be an address (a string);
a Reply-to: field with that address is inserted.

If `mail-archive-file-name' is non-nil, an FCC field with that file name
is inserted.

The normal hook `mail-setup-hook' is run after the message is
initialized.  It can add more default fields to the message.

The first argument, NOERASE, determines what to do when there is
an existing modified `*mail*' buffer.  If NOERASE is nil, the
existing mail buffer is used, and the user is prompted whether to
keep the old contents or to erase them.  If NOERASE has the value
`new', a new mail buffer will be created instead of using the old
one.  Any other non-nil value means to always select the old
buffer without erasing the contents.

The second through fifth arguments,
 TO, SUBJECT, IN-REPLY-TO and CC, specify if non-nil
 the initial contents of those header fields.
 These arguments should not have final newlines.
The sixth argument REPLYBUFFER is a buffer which contains an
 original message being replied to, or else an action
 of the form (FUNCTION . ARGS) which says how to insert the original.
 Or it can be nil, if not replying to anything.
The seventh argument ACTIONS is a list of actions to take
 if/when the message is sent.  Each action looks like (FUNCTION . ARGS);
 when the message is sent, we apply FUNCTION to ARGS.
 This is how Rmail arranges to mark messages `answered'.

\(fn &optional NOERASE TO SUBJECT IN-REPLY-TO CC REPLYBUFFER ACTIONS RETURN-ACTION)" t nil)

(autoload 'mail-other-window "sendmail" "\
Like `mail' command, but display mail buffer in another window.

\(fn &optional NOERASE TO SUBJECT IN-REPLY-TO CC REPLYBUFFER SENDACTIONS)" t nil)

(autoload 'mail-other-frame "sendmail" "\
Like `mail' command, but display mail buffer in another frame.

\(fn &optional NOERASE TO SUBJECT IN-REPLY-TO CC REPLYBUFFER SENDACTIONS)" t nil)

;;;***

;;;### (autoloads nil "server" "server.el" (21788 61018 0 0))
;;; Generated autoloads from server.el

(put 'server-host 'risky-local-variable t)

(put 'server-port 'risky-local-variable t)

(put 'server-auth-dir 'risky-local-variable t)

(autoload 'server-start "server" "\
Allow this Emacs process to be a server for client processes.
This starts a server communications subprocess through which client
\"editors\" can send your editing commands to this Emacs job.
To use the server, set up the program `emacsclient' in the Emacs
distribution as your standard \"editor\".

Optional argument LEAVE-DEAD (interactively, a prefix arg) means just
kill any existing server communications subprocess.

If a server is already running, restart it.  If clients are
running, ask the user for confirmation first, unless optional
argument INHIBIT-PROMPT is non-nil.

To force-start a server, do \\[server-force-delete] and then
\\[server-start].

\(fn &optional LEAVE-DEAD INHIBIT-PROMPT)" t nil)

(autoload 'server-force-delete "server" "\
Unconditionally delete connection file for server NAME.
If server is running, it is first stopped.
NAME defaults to `server-name'.  With argument, ask for NAME.

\(fn &optional NAME)" t nil)

(defvar server-mode nil "\
Non-nil if Server mode is enabled.
See the command `server-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `server-mode'.")

(custom-autoload 'server-mode "server" nil)

(autoload 'server-mode "server" "\
Toggle Server mode.
With a prefix argument ARG, enable Server mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
Server mode if ARG is omitted or nil.

Server mode runs a process that accepts commands from the
`emacsclient' program.  See Info node `Emacs server' and
`server-start' for details.

\(fn &optional ARG)" t nil)

(autoload 'server-save-buffers-kill-terminal "server" "\
Offer to save each buffer, then kill the current client.
With ARG non-nil, silently save all file-visiting buffers, then kill.

If emacsclient was started with a list of filenames to edit, then
only these files will be asked to be saved.

\(fn ARG)" nil nil)

;;;***

;;;### (autoloads nil "ses" "ses.el" (21788 61018 0 0))
;;; Generated autoloads from ses.el

(autoload 'ses-mode "ses" "\
Major mode for Simple Emacs Spreadsheet.

When you invoke SES in a new buffer, it is divided into cells
that you can enter data into.  You can navigate the cells with
the arrow keys and add more cells with the tab key.  The contents
of these cells can be numbers, text, or Lisp expressions. (To
enter text, enclose it in double quotes.)

In an expression, you can use cell coordinates to refer to the
contents of another cell.  For example, you can sum a range of
cells with `(+ A1 A2 A3)'.  There are specialized functions like
`ses+' (addition for ranges with empty cells), `ses-average' (for
performing calculations on cells), and `ses-range' and `ses-select'
\(for extracting ranges of cells).

Each cell also has a print function that controls how it is
displayed.

Each SES buffer is divided into a print area and a data area.
Normally, you can simply use SES to look at and manipulate the print
area, and let SES manage the data area outside the visible region.

See \"ses-example.ses\" (in `data-directory') for an example
spreadsheet, and the Info node `(ses)Top.'

In the following, note the separate keymaps for cell editing mode
and print mode specifications.  Key definitions:

\\{ses-mode-map}
These key definitions are active only in the print area (the visible
part):
\\{ses-mode-print-map}
These are active only in the minibuffer, when entering or editing a
formula:
\\{ses-mode-edit-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "sgml-mode" "textmodes/sgml-mode.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from textmodes/sgml-mode.el

(autoload 'sgml-mode "sgml-mode" "\
Major mode for editing SGML documents.
Makes > match <.
Keys <, &, SPC within <>, \", / and ' can be electric depending on
`sgml-quick-keys'.

An argument of N to a tag-inserting command means to wrap it around
the next N words.  In Transient Mark mode, when the mark is active,
N defaults to -1, which means to wrap it around the current region.

If you like upcased tags, put (setq sgml-transformation-function 'upcase)
in your init file.

Use \\[sgml-validate] to validate your document with an SGML parser.

Do \\[describe-variable] sgml- SPC to see available variables.
Do \\[describe-key] on the following bindings to discover what they do.
\\{sgml-mode-map}

\(fn)" t nil)

(autoload 'html-mode "sgml-mode" "\
Major mode based on SGML mode for editing HTML documents.
This allows inserting skeleton constructs used in hypertext documents with
completion.  See below for an introduction to HTML.  Use
\\[browse-url-of-buffer] to see how this comes out.  See also `sgml-mode' on
which this is based.

Do \\[describe-variable] html- SPC and \\[describe-variable] sgml- SPC to see available variables.

To write fairly well formatted pages you only need to know few things.  Most
browsers have a function to read the source code of the page being seen, so
you can imitate various tricks.  Here's a very short HTML primer which you
can also view with a browser to see what happens:

<title>A Title Describing Contents</title> should be on every page.  Pages can
have <h1>Very Major Headlines</h1> through <h6>Very Minor Headlines</h6>
<hr> Parts can be separated with horizontal rules.

<p>Paragraphs only need an opening tag.  Line breaks and multiple spaces are
ignored unless the text is <pre>preformatted.</pre>  Text can be marked as
<b>bold</b>, <i>italic</i> or <u>underlined</u> using the normal M-o or
Edit/Text Properties/Face commands.

Pages can have <a name=\"SOMENAME\">named points</a> and can link other points
to them with <a href=\"#SOMENAME\">see also somename</a>.  In the same way <a
href=\"URL\">see also URL</a> where URL is a filename relative to current
directory, or absolute as in `http://www.cs.indiana.edu/elisp/w3/docs.html'.

Images in many formats can be inlined with <img src=\"URL\">.

If you mainly create your own documents, `sgml-specials' might be
interesting.  But note that some HTML 2 browsers can't handle `&apos;'.
To work around that, do:
   (eval-after-load \"sgml-mode\" '(aset sgml-char-names ?' nil))

\\{html-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "sh-script" "progmodes/sh-script.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from progmodes/sh-script.el
(push (purecopy '(sh-script 2 0 6)) package--builtin-versions)
(put 'sh-shell 'safe-local-variable 'symbolp)

(autoload 'sh-mode "sh-script" "\
Major mode for editing shell scripts.
This mode works for many shells, since they all have roughly the same syntax,
as far as commands, arguments, variables, pipes, comments etc. are concerned.
Unless the file's magic number indicates the shell, your usual shell is
assumed.  Since filenames rarely give a clue, they are not further analyzed.

This mode adapts to the variations between shells (see `sh-set-shell') by
means of an inheritance based feature lookup (see `sh-feature').  This
mechanism applies to all variables (including skeletons) that pertain to
shell-specific features.

The default style of this mode is that of Rosenblatt's Korn shell book.
The syntax of the statements varies with the shell being used.  The
following commands are available, based on the current shell's syntax:
\\<sh-mode-map>
\\[sh-case]	 case statement
\\[sh-for]	 for loop
\\[sh-function]	 function definition
\\[sh-if]	 if statement
\\[sh-indexed-loop]	 indexed loop from 1 to n
\\[sh-while-getopts]	 while getopts loop
\\[sh-repeat]	 repeat loop
\\[sh-select]	 select loop
\\[sh-until]	 until loop
\\[sh-while]	 while loop

For sh and rc shells indentation commands are:
\\[sh-show-indent]	Show the variable controlling this line's indentation.
\\[sh-set-indent]	Set then variable controlling this line's indentation.
\\[sh-learn-line-indent]	Change the indentation variable so this line
would indent to the way it currently is.
\\[sh-learn-buffer-indent]  Set the indentation variables so the
buffer indents as it currently is indented.


\\[backward-delete-char-untabify]	 Delete backward one position, even if it was a tab.
\\[sh-end-of-command]	 Go to end of successive commands.
\\[sh-beginning-of-command]	 Go to beginning of successive commands.
\\[sh-set-shell]	 Set this buffer's shell, and maybe its magic number.
\\[sh-execute-region]	 Have optional header and region be executed in a subshell.

`sh-electric-here-document-mode' controls whether insertion of two
unquoted < insert a here document.

If you generally program a shell different from your login shell you can
set `sh-shell-file' accordingly.  If your shell's file name doesn't correctly
indicate what shell it is use `sh-alias-alist' to translate.

If your shell gives error messages with line numbers, you can use \\[executable-interpret]
with your script for an edit-interpret-debug cycle.

\(fn)" t nil)

(defalias 'shell-script-mode 'sh-mode)

;;;***

;;;### (autoloads nil "shadow" "emacs-lisp/shadow.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from emacs-lisp/shadow.el

(autoload 'list-load-path-shadows "shadow" "\
Display a list of Emacs Lisp files that shadow other files.

If STRINGP is non-nil, returns any shadows as a string.
Otherwise, if interactive shows any shadows in a `*Shadows*' buffer;
else prints messages listing any shadows.

This function lists potential load path problems.  Directories in
the `load-path' variable are searched, in order, for Emacs Lisp
files.  When a previously encountered file name is found again, a
message is displayed indicating that the later file is \"hidden\" by
the earlier.

For example, suppose `load-path' is set to

\(\"/usr/share/emacs/site-lisp\" \"/usr/share/emacs/24.3/lisp\")

and that each of these directories contains a file called XXX.el.  Then
XXX.el in the site-lisp directory is referred to by all of:
\(require 'XXX), (autoload .... \"XXX\"), (load-library \"XXX\") etc.

The first XXX.el file prevents Emacs from seeing the second (unless
the second is loaded explicitly via `load-file').

When not intended, such shadowings can be the source of subtle
problems.  For example, the above situation may have arisen because the
XXX package was not distributed with versions of Emacs prior to
24.3.  A system administrator downloaded XXX from elsewhere and installed
it.  Later, XXX was updated and included in the Emacs distribution.
Unless the system administrator checks for this, the new version of XXX
will be hidden behind the old (which may no longer work with the new
Emacs version).

This function performs these checks and flags all possible
shadowings.  Because a .el file may exist without a corresponding .elc
\(or vice-versa), these suffixes are essentially ignored.  A file
XXX.elc in an early directory (that does not contain XXX.el) is
considered to shadow a later file XXX.el, and vice-versa.

Shadowings are located by calling the (non-interactive) companion
function, `load-path-shadows-find'.

\(fn &optional STRINGP)" t nil)

;;;***

;;;### (autoloads nil "shadowfile" "shadowfile.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from shadowfile.el

(autoload 'shadow-define-cluster "shadowfile" "\
Edit (or create) the definition of a cluster NAME.
This is a group of hosts that share directories, so that copying to or from
one of them is sufficient to update the file on all of them.  Clusters are
defined by a name, the network address of a primary host (the one we copy
files to), and a regular expression that matches the hostnames of all the
sites in the cluster.

\(fn NAME)" t nil)

(autoload 'shadow-define-literal-group "shadowfile" "\
Declare a single file to be shared between sites.
It may have different filenames on each site.  When this file is edited, the
new version will be copied to each of the other locations.  Sites can be
specific hostnames, or names of clusters (see `shadow-define-cluster').

\(fn)" t nil)

(autoload 'shadow-define-regexp-group "shadowfile" "\
Make each of a group of files be shared between hosts.
Prompts for regular expression; files matching this are shared between a list
of sites, which are also prompted for.  The filenames must be identical on all
hosts (if they aren't, use `shadow-define-literal-group' instead of this
function).  Each site can be either a hostname or the name of a cluster (see
`shadow-define-cluster').

\(fn)" t nil)

(autoload 'shadow-initialize "shadowfile" "\
Set up file shadowing.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "shell" "shell.el" (21788 61018 0 0))
;;; Generated autoloads from shell.el

(defvar shell-dumb-shell-regexp (purecopy "cmd\\(proxy\\)?\\.exe") "\
Regexp to match shells that don't save their command history, and
don't handle the backslash as a quote character.  For shells that
match this regexp, Emacs will write out the command history when the
shell finishes, and won't remove backslashes when it unquotes shell
arguments.")

(custom-autoload 'shell-dumb-shell-regexp "shell" t)

(autoload 'shell "shell" "\
Run an inferior shell, with I/O through BUFFER (which defaults to `*shell*').
Interactively, a prefix arg means to prompt for BUFFER.
If `default-directory' is a remote file name, it is also prompted
to change if called with a prefix arg.

If BUFFER exists but shell process is not running, make new shell.
If BUFFER exists and shell process is running, just switch to BUFFER.
Program used comes from variable `explicit-shell-file-name',
 or (if that is nil) from the ESHELL environment variable,
 or (if that is nil) from `shell-file-name'.
If a file `~/.emacs_SHELLNAME' exists, or `~/.emacs.d/init_SHELLNAME.sh',
it is given as initial input (but this may be lost, due to a timing
error, if the shell discards input when it starts up).
The buffer is put in Shell mode, giving commands for sending input
and controlling the subjobs of the shell.  See `shell-mode'.
See also the variable `shell-prompt-pattern'.

To specify a coding system for converting non-ASCII characters
in the input and output to the shell, use \\[universal-coding-system-argument]
before \\[shell].  You can also specify this with \\[set-buffer-process-coding-system]
in the shell buffer, after you start the shell.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

The shell file name (sans directories) is used to make a symbol name
such as `explicit-csh-args'.  If that symbol is a variable,
its value is used as a list of arguments when invoking the shell.
Otherwise, one argument `-i' is passed to the shell.

\(Type \\[describe-mode] in the shell buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

;;;***

;;;### (autoloads nil "shr" "net/shr.el" (21788 61018 0 0))
;;; Generated autoloads from net/shr.el

(autoload 'shr-render-region "shr" "\
Display the HTML rendering of the region between BEGIN and END.

\(fn BEGIN END &optional BUFFER)" t nil)

(autoload 'shr-insert-document "shr" "\
Render the parsed document DOM into the current buffer.
DOM should be a parse tree as generated by
`libxml-parse-html-region' or similar.

\(fn DOM)" nil nil)

;;;***

;;;### (autoloads nil "sieve" "gnus/sieve.el" (21710 25077 0 0))
;;; Generated autoloads from gnus/sieve.el

(autoload 'sieve-manage "sieve" "\


\(fn SERVER &optional PORT)" t nil)

(autoload 'sieve-upload "sieve" "\


\(fn &optional NAME)" t nil)

(autoload 'sieve-upload-and-bury "sieve" "\


\(fn &optional NAME)" t nil)

(autoload 'sieve-upload-and-kill "sieve" "\


\(fn &optional NAME)" t nil)

;;;***

;;;### (autoloads nil "sieve-mode" "gnus/sieve-mode.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/sieve-mode.el

(autoload 'sieve-mode "sieve-mode" "\
Major mode for editing Sieve code.
This is much like C mode except for the syntax of comments.  Its keymap
inherits from C mode's and it has the same variables for customizing
indentation.  It has its own abbrev table and its own syntax table.

Turning on Sieve mode runs `sieve-mode-hook'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "simula" "progmodes/simula.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from progmodes/simula.el

(autoload 'simula-mode "simula" "\
Major mode for editing SIMULA code.
\\{simula-mode-map}
Variables controlling indentation style:
 `simula-tab-always-indent'
    Non-nil means TAB in SIMULA mode should always reindent the current line,
    regardless of where in the line point is when the TAB command is used.
 `simula-indent-level'
    Indentation of SIMULA statements with respect to containing block.
 `simula-substatement-offset'
    Extra indentation after DO, THEN, ELSE, WHEN and OTHERWISE.
 `simula-continued-statement-offset' 3
    Extra indentation for lines not starting a statement or substatement,
    e.g. a nested FOR-loop.  If value is a list, each line in a multiple-
    line continued statement will have the car of the list extra indentation
    with respect to the previous line of the statement.
 `simula-label-offset' -4711
    Offset of SIMULA label lines relative to usual indentation.
 `simula-if-indent' '(0 . 0)
    Extra indentation of THEN and ELSE with respect to the starting IF.
    Value is a cons cell, the car is extra THEN indentation and the cdr
    extra ELSE indentation.  IF after ELSE is indented as the starting IF.
 `simula-inspect-indent' '(0 . 0)
    Extra indentation of WHEN and OTHERWISE with respect to the
    corresponding INSPECT.  Value is a cons cell, the car is
    extra WHEN indentation and the cdr extra OTHERWISE indentation.
 `simula-electric-indent' nil
    If this variable is non-nil, `simula-indent-line'
    will check the previous line to see if it has to be reindented.
 `simula-abbrev-keyword' 'upcase
    Determine how SIMULA keywords will be expanded.  Value is one of
    the symbols `upcase', `downcase', `capitalize', (as in) `abbrev-table',
    or nil if they should not be changed.
 `simula-abbrev-stdproc' 'abbrev-table
    Determine how standard SIMULA procedure and class names will be
    expanded.  Value is one of the symbols `upcase', `downcase', `capitalize',
    (as in) `abbrev-table', or nil if they should not be changed.

Turning on SIMULA mode calls the value of the variable simula-mode-hook
with no arguments, if that value is non-nil.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "skeleton" "skeleton.el" (21788 61018 0 0))
;;; Generated autoloads from skeleton.el

(defvar skeleton-filter-function 'identity "\
Function for transforming a skeleton proxy's aliases' variable value.")

(autoload 'define-skeleton "skeleton" "\
Define a user-configurable COMMAND that enters a statement skeleton.
DOCUMENTATION is that of the command.
SKELETON is as defined under `skeleton-insert'.

\(fn COMMAND DOCUMENTATION &rest SKELETON)" nil t)

(put 'define-skeleton 'doc-string-elt '2)

(autoload 'skeleton-proxy-new "skeleton" "\
Insert SKELETON.
Prefix ARG allows wrapping around words or regions (see `skeleton-insert').
If no ARG was given, but the region is visible, ARG defaults to -1 depending
on `skeleton-autowrap'.  An ARG of  M-0  will prevent this just for once.
This command can also be an abbrev expansion (3rd and 4th columns in
\\[edit-abbrevs]  buffer: \"\"  command-name).

Optional second argument STR may also be a string which will be the value
of `str' whereas the skeleton's interactor is then ignored.

\(fn SKELETON &optional STR ARG)" nil nil)

(autoload 'skeleton-insert "skeleton" "\
Insert the complex statement skeleton SKELETON describes very concisely.

With optional second argument REGIONS, wrap first interesting point
\(`_') in skeleton around next REGIONS words, if REGIONS is positive.
If REGIONS is negative, wrap REGIONS preceding interregions into first
REGIONS interesting positions (successive `_'s) in skeleton.

An interregion is the stretch of text between two contiguous marked
points.  If you marked A B C [] (where [] is the cursor) in
alphabetical order, the 3 interregions are simply the last 3 regions.
But if you marked B A [] C, the interregions are B-A, A-[], []-C.

The optional third argument STR, if specified, is the value for the
variable `str' within the skeleton.  When this is non-nil, the
interactor gets ignored, and this should be a valid skeleton element.

SKELETON is made up as (INTERACTOR ELEMENT ...).  INTERACTOR may be nil if
not needed, a prompt-string or an expression for complex read functions.

If ELEMENT is a string or a character it gets inserted (see also
`skeleton-transformation-function').  Other possibilities are:

	\\n	go to next line and indent according to mode, unless
                this is the first/last element of a skeleton and point
                is at bol/eol
	_	interesting point, interregion here
	-	interesting point, no interregion interaction, overrides
		interesting point set by _
	>	indent line (or interregion if > _) according to major mode
	@	add position to `skeleton-positions'
	&	do next ELEMENT if previous moved point
	|	do next ELEMENT if previous didn't move point
	-NUM	delete NUM preceding characters (see `skeleton-untabify')
	resume:	skipped, continue here if quit is signaled
	nil	skipped

After termination, point will be positioned at the last occurrence of -
or at the first occurrence of _ or at the end of the inserted text.

Note that \\n as the last element of the skeleton only inserts a
newline if not at eol.  If you want to unconditionally insert a newline
at the end of the skeleton, use \"\\n\" instead.  Likewise with \\n
as the first element when at bol.

Further elements can be defined via `skeleton-further-elements'.
ELEMENT may itself be a SKELETON with an INTERACTOR.  The user is prompted
repeatedly for different inputs.  The SKELETON is processed as often as
the user enters a non-empty string.  \\[keyboard-quit] terminates skeleton insertion, but
continues after `resume:' and positions at `_' if any.  If INTERACTOR in
such a subskeleton is a prompt-string which contains a \".. %s ..\" it is
formatted with `skeleton-subprompt'.  Such an INTERACTOR may also be a list
of strings with the subskeleton being repeated once for each string.

Quoted Lisp expressions are evaluated for their side-effects.
Other Lisp expressions are evaluated and the value treated as above.
Note that expressions may not return t since this implies an
endless loop.  Modes can define other symbols by locally setting them
to any valid skeleton element.  The following local variables are
available:

	str	first time: read a string according to INTERACTOR
		then: insert previously read string once more
	help	help-form during interaction with the user or nil
	input	initial input (string or cons with index) while reading str
	v1, v2	local variables for memorizing anything you want

When done with skeleton, but before going back to `_'-point call
`skeleton-end-hook' if that is non-nil.

\(fn SKELETON &optional REGIONS STR)" nil nil)

(autoload 'skeleton-pair-insert-maybe "skeleton" "\
Insert the character you type ARG times.

With no ARG, if `skeleton-pair' is non-nil, pairing can occur.  If the region
is visible the pair is wrapped around it depending on `skeleton-autowrap'.
Else, if `skeleton-pair-on-word' is non-nil or we are not before or inside a
word, and if `skeleton-pair-filter-function' returns nil, pairing is performed.
Pairing is also prohibited if we are right after a quoting character
such as backslash.

If a match is found in `skeleton-pair-alist', that is inserted, else
the defaults are used.  These are (), [], {}, <> and `' for the
symmetrical ones, and the same character twice for the others.

\(fn ARG)" t nil)

;;;***

;;;### (autoloads nil "smerge-mode" "vc/smerge-mode.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from vc/smerge-mode.el

(autoload 'smerge-ediff "smerge-mode" "\
Invoke ediff to resolve the conflicts.
NAME-MINE, NAME-OTHER, and NAME-BASE, if non-nil, are used for the
buffer names.

\(fn &optional NAME-MINE NAME-OTHER NAME-BASE)" t nil)

(autoload 'smerge-mode "smerge-mode" "\
Minor mode to simplify editing output from the diff3 program.
With a prefix argument ARG, enable the mode if ARG is positive,
and disable it otherwise.  If called from Lisp, enable the mode
if ARG is omitted or nil.
\\{smerge-mode-map}

\(fn &optional ARG)" t nil)

(autoload 'smerge-start-session "smerge-mode" "\
Turn on `smerge-mode' and move point to first conflict marker.
If no conflict maker is found, turn off `smerge-mode'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "smiley" "gnus/smiley.el" (21710 25077 0 0))
;;; Generated autoloads from gnus/smiley.el

(autoload 'smiley-region "smiley" "\
Replace in the region `smiley-regexp-alist' matches with corresponding images.
A list of images is returned.

\(fn START END)" t nil)

(autoload 'smiley-buffer "smiley" "\
Run `smiley-region' at the BUFFER, specified in the argument or
interactively.  If there's no argument, do it at the current buffer.

\(fn &optional BUFFER)" t nil)

;;;***

;;;### (autoloads nil "smtpmail" "mail/smtpmail.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from mail/smtpmail.el

(autoload 'smtpmail-send-it "smtpmail" "\


\(fn)" nil nil)

(autoload 'smtpmail-send-queued-mail "smtpmail" "\
Send mail that was queued as a result of setting `smtpmail-queue-mail'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "snake" "play/snake.el" (21710 25077 0 0))
;;; Generated autoloads from play/snake.el

(autoload 'snake "snake" "\
Play the Snake game.
Move the snake around without colliding with its tail or with the border.

Eating dots causes the snake to get longer.

Snake mode keybindings:
   \\<snake-mode-map>
\\[snake-start-game]	Starts a new game of Snake
\\[snake-end-game]	Terminates the current game
\\[snake-pause-game]	Pauses (or resumes) the current game
\\[snake-move-left]	Makes the snake move left
\\[snake-move-right]	Makes the snake move right
\\[snake-move-up]	Makes the snake move up
\\[snake-move-down]	Makes the snake move down

\(fn)" t nil)

;;;***

;;;### (autoloads nil "snmp-mode" "net/snmp-mode.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from net/snmp-mode.el

(autoload 'snmp-mode "snmp-mode" "\
Major mode for editing SNMP MIBs.
Expression and list commands understand all C brackets.
Tab indents for C code.
Comments start with -- and end with newline or another --.
Delete converts tabs to spaces as it moves back.
\\{snmp-mode-map}
Turning on snmp-mode runs the hooks in `snmp-common-mode-hook', then
`snmp-mode-hook'.

\(fn)" t nil)

(autoload 'snmpv2-mode "snmp-mode" "\
Major mode for editing SNMPv2 MIBs.
Expression and list commands understand all C brackets.
Tab indents for C code.
Comments start with -- and end with newline or another --.
Delete converts tabs to spaces as it moves back.
\\{snmp-mode-map}
Turning on snmp-mode runs the hooks in `snmp-common-mode-hook',
then `snmpv2-mode-hook'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "solar" "calendar/solar.el" (21788 61018 0
;;;;;;  0))
;;; Generated autoloads from calendar/solar.el

(autoload 'sunrise-sunset "solar" "\
Local time of sunrise and sunset for today.  Accurate to a few seconds.
If called with an optional prefix argument ARG, prompt for date.
If called with an optional double prefix argument, prompt for
longitude, latitude, time zone, and date, and always use standard time.

This function is suitable for execution in an init file.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "solitaire" "play/solitaire.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from play/solitaire.el

(autoload 'solitaire "solitaire" "\
Play Solitaire.

To play Solitaire, type \\[solitaire].
\\<solitaire-mode-map>
Move around the board using the cursor keys.
Move stones using \\[solitaire-move] followed by a direction key.
Undo moves using \\[solitaire-undo].
Check for possible moves using \\[solitaire-do-check].
\(The variable `solitaire-auto-eval' controls whether to automatically
check after each move or undo.)

What is Solitaire?

I don't know who invented this game, but it seems to be rather old and
its origin seems to be northern Africa.  Here's how to play:
Initially, the board will look similar to this:

	Le Solitaire
	============

		o   o   o

		o   o   o

	o   o   o   o   o   o   o

	o   o   o   .   o   o   o

	o   o   o   o   o   o   o

		o   o   o

		o   o   o

Let's call the o's stones and the .'s holes.  One stone fits into one
hole.  As you can see, all holes but one are occupied by stones.  The
aim of the game is to get rid of all but one stone, leaving that last
one in the middle of the board if you're cool.

A stone can be moved if there is another stone next to it, and a hole
after that one.  Thus there must be three fields in a row, either
horizontally or vertically, up, down, left or right, which look like
this:  o  o  .

Then the first stone is moved to the hole, jumping over the second,
which therefore is taken away.  The above thus `evaluates' to:  .  .  o

That's all.  Here's the board after two moves:

		o   o   o

		.   o   o

	o   o   .   o   o   o   o

	o   .   o   o   o   o   o

	o   o   o   o   o   o   o

		o   o   o

		o   o   o

Pick your favorite shortcuts:

\\{solitaire-mode-map}

\(fn ARG)" t nil)

;;;***

;;;### (autoloads nil "sort" "sort.el" (21710 25077 0 0))
;;; Generated autoloads from sort.el
(put 'sort-fold-case 'safe-local-variable 'booleanp)

(autoload 'sort-subr "sort" "\
General text sorting routine to divide buffer into records and sort them.

We divide the accessible portion of the buffer into disjoint pieces
called sort records.  A portion of each sort record (perhaps all of
it) is designated as the sort key.  The records are rearranged in the
buffer in order by their sort keys.  The records may or may not be
contiguous.

Usually the records are rearranged in order of ascending sort key.
If REVERSE is non-nil, they are rearranged in order of descending sort key.
The variable `sort-fold-case' determines whether alphabetic case affects
the sort order.

The next four arguments are functions to be called to move point
across a sort record.  They will be called many times from within sort-subr.

NEXTRECFUN is called with point at the end of the previous record.
It moves point to the start of the next record.
It should move point to the end of the buffer if there are no more records.
The first record is assumed to start at the position of point when sort-subr
is called.

ENDRECFUN is called with point within the record.
It should move point to the end of the record.

STARTKEYFUN moves from the start of the record to the start of the key.
It may return either a non-nil value to be used as the key, or
else the key is the substring between the values of point after
STARTKEYFUN and ENDKEYFUN are called.  If STARTKEYFUN is nil, the key
starts at the beginning of the record.

ENDKEYFUN moves from the start of the sort key to the end of the sort key.
ENDKEYFUN may be nil if STARTKEYFUN returns a value or if it would be the
same as ENDRECFUN.

PREDICATE, if non-nil, is the predicate function for comparing
keys; it is called with two arguments, the keys to compare, and
should return non-nil if the first key should sort before the
second key.  If PREDICATE is nil, comparison is done with `<' if
the keys are numbers, with `compare-buffer-substrings' if the
keys are cons cells (the car and cdr of each cons cell are taken
as start and end positions), and with `string<' otherwise.

\(fn REVERSE NEXTRECFUN ENDRECFUN &optional STARTKEYFUN ENDKEYFUN PREDICATE)" nil nil)

(autoload 'sort-lines "sort" "\
Sort lines in region alphabetically; argument means descending order.
Called from a program, there are three arguments:
REVERSE (non-nil means reverse order), BEG and END (region to sort).
The variable `sort-fold-case' determines whether alphabetic case affects
the sort order.

\(fn REVERSE BEG END)" t nil)

(autoload 'sort-paragraphs "sort" "\
Sort paragraphs in region alphabetically; argument means descending order.
Called from a program, there are three arguments:
REVERSE (non-nil means reverse order), BEG and END (region to sort).
The variable `sort-fold-case' determines whether alphabetic case affects
the sort order.

\(fn REVERSE BEG END)" t nil)

(autoload 'sort-pages "sort" "\
Sort pages in region alphabetically; argument means descending order.
Called from a program, there are three arguments:
REVERSE (non-nil means reverse order), BEG and END (region to sort).
The variable `sort-fold-case' determines whether alphabetic case affects
the sort order.

\(fn REVERSE BEG END)" t nil)
(put 'sort-numeric-base 'safe-local-variable 'integerp)

(autoload 'sort-numeric-fields "sort" "\
Sort lines in region numerically by the ARGth field of each line.
Fields are separated by whitespace and numbered from 1 up.
Specified field must contain a number in each line of the region,
which may begin with \"0x\" or \"0\" for hexadecimal and octal values.
Otherwise, the number is interpreted according to sort-numeric-base.
With a negative arg, sorts by the ARGth field counted from the right.
Called from a program, there are three arguments:
FIELD, BEG and END.  BEG and END specify region to sort.

\(fn FIELD BEG END)" t nil)

(autoload 'sort-fields "sort" "\
Sort lines in region lexicographically by the ARGth field of each line.
Fields are separated by whitespace and numbered from 1 up.
With a negative arg, sorts by the ARGth field counted from the right.
Called from a program, there are three arguments:
FIELD, BEG and END.  BEG and END specify region to sort.
The variable `sort-fold-case' determines whether alphabetic case affects
the sort order.

\(fn FIELD BEG END)" t nil)

(autoload 'sort-regexp-fields "sort" "\
Sort the text in the region region lexicographically.
If called interactively, prompt for two regular expressions,
RECORD-REGEXP and KEY-REGEXP.

RECORD-REGEXP specifies the textual units to be sorted.
  For example, to sort lines, RECORD-REGEXP would be \"^.*$\".

KEY-REGEXP specifies the part of each record (i.e. each match for
  RECORD-REGEXP) to be used for sorting.
  If it is \"\\\\digit\", use the digit'th \"\\\\(...\\\\)\"
  match field specified by RECORD-REGEXP.
  If it is \"\\\\&\", use the whole record.
  Otherwise, KEY-REGEXP should be a regular expression with which
  to search within the record.  If a match for KEY-REGEXP is not
  found within a record, that record is ignored.

With a negative prefix arg, sort in reverse order.

The variable `sort-fold-case' determines whether alphabetic case affects
the sort order.

For example: to sort lines in the region by the first word on each line
 starting with the letter \"f\",
 RECORD-REGEXP would be \"^.*$\" and KEY would be \"\\\\=\\<f\\\\w*\\\\>\"

\(fn REVERSE RECORD-REGEXP KEY-REGEXP BEG END)" t nil)

(autoload 'sort-columns "sort" "\
Sort lines in region alphabetically by a certain range of columns.
For the purpose of this command, the region BEG...END includes
the entire line that point is in and the entire line the mark is in.
The column positions of point and mark bound the range of columns to sort on.
A prefix argument means sort into REVERSE order.
The variable `sort-fold-case' determines whether alphabetic case affects
the sort order.

Note that `sort-columns' rejects text that contains tabs,
because tabs could be split across the specified columns
and it doesn't know how to handle that.  Also, when possible,
it uses the `sort' utility program, which doesn't understand tabs.
Use \\[untabify] to convert tabs to spaces before sorting.

\(fn REVERSE &optional BEG END)" t nil)

(autoload 'reverse-region "sort" "\
Reverse the order of lines in a region.
From a program takes two point or marker arguments, BEG and END.

\(fn BEG END)" t nil)

(autoload 'delete-duplicate-lines "sort" "\
Delete all but one copy of any identical lines in the region.
Non-interactively, arguments BEG and END delimit the region.
Normally it searches forwards, keeping the first instance of
each identical line.  If REVERSE is non-nil (interactively, with
a C-u prefix), it searches backwards and keeps the last instance of
each repeated line.

Identical lines need not be adjacent, unless the argument
ADJACENT is non-nil (interactively, with a C-u C-u prefix).
This is a more efficient mode of operation, and may be useful
on large regions that have already been sorted.

If the argument KEEP-BLANKS is non-nil (interactively, with a
C-u C-u C-u prefix), it retains repeated blank lines.

Returns the number of deleted lines.  Interactively, or if INTERACTIVE
is non-nil, it also prints a message describing the number of deletions.

\(fn BEG END &optional REVERSE ADJACENT KEEP-BLANKS INTERACTIVE)" t nil)

;;;***

;;;### (autoloads nil "spam" "gnus/spam.el" (21788 61018 0 0))
;;; Generated autoloads from gnus/spam.el

(autoload 'spam-initialize "spam" "\
Install the spam.el hooks and do other initialization.
When SYMBOLS is given, set those variables to t.  This is so you
can call `spam-initialize' before you set spam-use-* variables on
explicitly, and matters only if you need the extra headers
installed through `spam-necessary-extra-headers'.

\(fn &rest SYMBOLS)" t nil)

;;;***

;;;### (autoloads nil "spam-report" "gnus/spam-report.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from gnus/spam-report.el

(autoload 'spam-report-process-queue "spam-report" "\
Report all queued requests from `spam-report-requests-file'.

If FILE is given, use it instead of `spam-report-requests-file'.
If KEEP is t, leave old requests in the file.  If KEEP is the
symbol `ask', query before flushing the queue file.

\(fn &optional FILE KEEP)" t nil)

(autoload 'spam-report-url-ping-mm-url "spam-report" "\
Ping a host through HTTP, addressing a specific GET resource. Use
the external program specified in `mm-url-program' to connect to
server.

\(fn HOST REPORT)" nil nil)

(autoload 'spam-report-url-to-file "spam-report" "\
Collect spam report requests in `spam-report-requests-file'.
Customize `spam-report-url-ping-function' to use this function.

\(fn HOST REPORT)" nil nil)

(autoload 'spam-report-agentize "spam-report" "\
Add spam-report support to the Agent.
Spam reports will be queued with \\[spam-report-url-to-file] when
the Agent is unplugged, and will be submitted in a batch when the
Agent is plugged.

\(fn)" t nil)

(autoload 'spam-report-deagentize "spam-report" "\
Remove spam-report support from the Agent.
Spam reports will be queued with the method used when
\\[spam-report-agentize] was run.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "speedbar" "speedbar.el" (21788 61018 0 0))
;;; Generated autoloads from speedbar.el

(defalias 'speedbar 'speedbar-frame-mode)

(autoload 'speedbar-frame-mode "speedbar" "\
Enable or disable speedbar.  Positive ARG means turn on, negative turn off.
A nil ARG means toggle.  Once the speedbar frame is activated, a buffer in
`speedbar-mode' will be displayed.  Currently, only one speedbar is
supported at a time.
`speedbar-before-popup-hook' is called before popping up the speedbar frame.
`speedbar-before-delete-hook' is called before the frame is deleted.

\(fn &optional ARG)" t nil)

(autoload 'speedbar-get-focus "speedbar" "\
Change frame focus to or from the speedbar frame.
If the selected frame is not speedbar, then speedbar frame is
selected.  If the speedbar frame is active, then select the attached frame.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "spook" "play/spook.el" (21710 25077 0 0))
;;; Generated autoloads from play/spook.el

(autoload 'spook "spook" "\
Adds that special touch of class to your outgoing mail.

\(fn)" t nil)

(autoload 'snarf-spooks "spook" "\
Return a vector containing the lines from `spook-phrases-file'.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "sql" "progmodes/sql.el" (21788 61018 0 0))
;;; Generated autoloads from progmodes/sql.el
(push (purecopy '(sql 3 4)) package--builtin-versions)

(autoload 'sql-add-product-keywords "sql" "\
Add highlighting KEYWORDS for SQL PRODUCT.

PRODUCT should be a symbol, the name of a SQL product, such as
`oracle'.  KEYWORDS should be a list; see the variable
`font-lock-keywords'.  By default they are added at the beginning
of the current highlighting list.  If optional argument APPEND is
`set', they are used to replace the current highlighting list.
If APPEND is any other non-nil value, they are added at the end
of the current highlighting list.

For example:

 (sql-add-product-keywords 'ms
  '((\"\\\\b\\\\w+_t\\\\b\" . font-lock-type-face)))

adds a fontification pattern to fontify identifiers ending in
`_t' as data types.

\(fn PRODUCT KEYWORDS &optional APPEND)" nil nil)

(autoload 'sql-mode "sql" "\
Major mode to edit SQL.

You can send SQL statements to the SQLi buffer using
\\[sql-send-region].  Such a buffer must exist before you can do this.
See `sql-help' on how to create SQLi buffers.

\\{sql-mode-map}
Customization: Entry to this mode runs the `sql-mode-hook'.

When you put a buffer in SQL mode, the buffer stores the last SQLi
buffer created as its destination in the variable `sql-buffer'.  This
will be the buffer \\[sql-send-region] sends the region to.  If this
SQLi buffer is killed, \\[sql-send-region] is no longer able to
determine where the strings should be sent to.  You can set the
value of `sql-buffer' using \\[sql-set-sqli-buffer].

For information on how to create multiple SQLi buffers, see
`sql-interactive-mode'.

Note that SQL doesn't have an escape character unless you specify
one.  If you specify backslash as escape character in SQL, you
must tell Emacs.  Here's how to do that in your init file:

\(add-hook 'sql-mode-hook
          (lambda ()
	    (modify-syntax-entry ?\\\\ \".\" sql-mode-syntax-table)))

\(fn)" t nil)

(autoload 'sql-connect "sql" "\
Connect to an interactive session using CONNECTION settings.

See `sql-connection-alist' to see how to define connections and
their settings.

The user will not be prompted for any login parameters if a value
is specified in the connection settings.

\(fn CONNECTION &optional NEW-NAME)" t nil)

(autoload 'sql-product-interactive "sql" "\
Run PRODUCT interpreter as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer `*SQL*'.

To specify the SQL product, prefix the call with
\\[universal-argument].  To set the buffer name as well, prefix
the call to \\[sql-product-interactive] with
\\[universal-argument] \\[universal-argument].

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional PRODUCT NEW-NAME)" t nil)

(autoload 'sql-oracle "sql" "\
Run sqlplus by Oracle as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-oracle-program'.  Login uses
the variables `sql-user', `sql-password', and `sql-database' as
defaults, if set.  Additional command line parameters can be stored in
the list `sql-oracle-options'.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-oracle].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-oracle].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-sybase "sql" "\
Run isql by Sybase as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-sybase-program'.  Login uses
the variables `sql-server', `sql-user', `sql-password', and
`sql-database' as defaults, if set.  Additional command line parameters
can be stored in the list `sql-sybase-options'.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-sybase].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-sybase].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-informix "sql" "\
Run dbaccess by Informix as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-informix-program'.  Login uses
the variable `sql-database' as default, if set.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-informix].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-informix].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-sqlite "sql" "\
Run sqlite as an inferior process.

SQLite is free software.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-sqlite-program'.  Login uses
the variables `sql-user', `sql-password', `sql-database', and
`sql-server' as defaults, if set.  Additional command line parameters
can be stored in the list `sql-sqlite-options'.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-sqlite].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-sqlite].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-mysql "sql" "\
Run mysql by TcX as an inferior process.

Mysql versions 3.23 and up are free software.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-mysql-program'.  Login uses
the variables `sql-user', `sql-password', `sql-database', and
`sql-server' as defaults, if set.  Additional command line parameters
can be stored in the list `sql-mysql-options'.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-mysql].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-mysql].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-solid "sql" "\
Run solsql by Solid as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-solid-program'.  Login uses
the variables `sql-user', `sql-password', and `sql-server' as
defaults, if set.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-solid].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-solid].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-ingres "sql" "\
Run sql by Ingres as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-ingres-program'.  Login uses
the variable `sql-database' as default, if set.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-ingres].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-ingres].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-ms "sql" "\
Run osql by Microsoft as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-ms-program'.  Login uses the
variables `sql-user', `sql-password', `sql-database', and `sql-server'
as defaults, if set.  Additional command line parameters can be stored
in the list `sql-ms-options'.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-ms].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-ms].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-postgres "sql" "\
Run psql by Postgres as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-postgres-program'.  Login uses
the variables `sql-database' and `sql-server' as default, if set.
Additional command line parameters can be stored in the list
`sql-postgres-options'.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-postgres].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-postgres].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.  If your output lines end with ^M,
your might try undecided-dos as a coding system.  If this doesn't help,
Try to set `comint-output-filter-functions' like this:

\(setq comint-output-filter-functions (append comint-output-filter-functions
					     '(comint-strip-ctrl-m)))

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-interbase "sql" "\
Run isql by Interbase as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-interbase-program'.  Login
uses the variables `sql-user', `sql-password', and `sql-database' as
defaults, if set.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-interbase].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-interbase].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-db2 "sql" "\
Run db2 by IBM as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-db2-program'.  There is not
automatic login.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

If you use \\[sql-accumulate-and-indent] to send multiline commands to
db2, newlines will be escaped if necessary.  If you don't want that, set
`comint-input-sender' back to `comint-simple-send' by writing an after
advice.  See the elisp manual for more information.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-db2].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

To specify a coding system for converting non-ASCII characters
in the input and output to the process, use \\[universal-coding-system-argument]
before \\[sql-db2].  You can also specify this with \\[set-buffer-process-coding-system]
in the SQL buffer, after you start the process.
The default comes from `process-coding-system-alist' and
`default-process-coding-system'.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

(autoload 'sql-linter "sql" "\
Run inl by RELEX as an inferior process.

If buffer `*SQL*' exists but no process is running, make a new process.
If buffer exists and a process is running, just switch to buffer
`*SQL*'.

Interpreter used comes from variable `sql-linter-program' - usually `inl'.
Login uses the variables `sql-user', `sql-password', `sql-database' and
`sql-server' as defaults, if set.  Additional command line parameters
can be stored in the list `sql-linter-options'.  Run inl -h to get help on
parameters.

`sql-database' is used to set the LINTER_MBX environment variable for
local connections, `sql-server' refers to the server name from the
`nodetab' file for the network connection (dbc_tcp or friends must run
for this to work).  If `sql-password' is an empty string, inl will use
an empty password.

The buffer is put in SQL interactive mode, giving commands for sending
input.  See `sql-interactive-mode'.

To set the buffer name directly, use \\[universal-argument]
before \\[sql-linter].  Once session has started,
\\[sql-rename-buffer] can be called separately to rename the
buffer.

\(Type \\[describe-mode] in the SQL buffer for a list of commands.)

\(fn &optional BUFFER)" t nil)

;;;***

;;;### (autoloads nil "srecode" "cedet/srecode.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from cedet/srecode.el
(push (purecopy '(srecode 1 2)) package--builtin-versions)

;;;***

;;;### (autoloads nil "srecode/srt-mode" "cedet/srecode/srt-mode.el"
;;;;;;  (21788 61018 0 0))
;;; Generated autoloads from cedet/srecode/srt-mode.el

(autoload 'srecode-template-mode "srecode/srt-mode" "\
Major-mode for writing SRecode macros.

\(fn)" t nil)

(defalias 'srt-mode 'srecode-template-mode)

;;;***

;;;### (autoloads nil "starttls" "gnus/starttls.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from gnus/starttls.el

(autoload 'starttls-open-stream "starttls" "\
Open a TLS connection for a port to a host.
Returns a subprocess object to represent the connection.
Input and output work as for subprocesses; `delete-process' closes it.
Args are NAME BUFFER HOST PORT.
NAME is name for process.  It is modified if necessary to make it unique.
BUFFER is the buffer (or `buffer-name') to associate with the process.
 Process output goes at end of that buffer, unless you specify
 an output stream or filter function to handle the output.
 BUFFER may be also nil, meaning that this process is not associated
 with any buffer
Third arg is name of the host to connect to, or its IP address.
Fourth arg PORT is an integer specifying a port to connect to.
If `starttls-use-gnutls' is nil, this may also be a service name, but
GnuTLS requires a port number.

\(fn NAME BUFFER HOST PORT)" nil nil)

;;;***

;;;### (autoloads nil "strokes" "strokes.el" (21710 25077 0 0))
;;; Generated autoloads from strokes.el

(autoload 'strokes-global-set-stroke "strokes" "\
Interactively give STROKE the global binding as COMMAND.
Works just like `global-set-key', except for strokes.  COMMAND is
a symbol naming an interactively-callable function.  STROKE is a
list of sampled positions on the stroke grid as described in the
documentation for the `strokes-define-stroke' function.

See also `strokes-global-set-stroke-string'.

\(fn STROKE COMMAND)" t nil)

(autoload 'strokes-read-stroke "strokes" "\
Read a simple stroke (interactively) and return the stroke.
Optional PROMPT in minibuffer displays before and during stroke reading.
This function will display the stroke interactively as it is being
entered in the strokes buffer if the variable
`strokes-use-strokes-buffer' is non-nil.
Optional EVENT is acceptable as the starting event of the stroke.

\(fn &optional PROMPT EVENT)" nil nil)

(autoload 'strokes-read-complex-stroke "strokes" "\
Read a complex stroke (interactively) and return the stroke.
Optional PROMPT in minibuffer displays before and during stroke reading.
Note that a complex stroke allows the user to pen-up and pen-down.  This
is implemented by allowing the user to paint with button 1 or button 2 and
then complete the stroke with button 3.
Optional EVENT is acceptable as the starting event of the stroke.

\(fn &optional PROMPT EVENT)" nil nil)

(autoload 'strokes-do-stroke "strokes" "\
Read a simple stroke from the user and then execute its command.
This must be bound to a mouse event.

\(fn EVENT)" t nil)

(autoload 'strokes-do-complex-stroke "strokes" "\
Read a complex stroke from the user and then execute its command.
This must be bound to a mouse event.

\(fn EVENT)" t nil)

(autoload 'strokes-describe-stroke "strokes" "\
Displays the command which STROKE maps to, reading STROKE interactively.

\(fn STROKE)" t nil)

(autoload 'strokes-help "strokes" "\
Get instruction on using the Strokes package.

\(fn)" t nil)

(autoload 'strokes-load-user-strokes "strokes" "\
Load user-defined strokes from file named by `strokes-file'.

\(fn)" t nil)

(autoload 'strokes-list-strokes "strokes" "\
Pop up a buffer containing an alphabetical listing of strokes in STROKES-MAP.
With CHRONOLOGICAL prefix arg (\\[universal-argument]) list strokes chronologically
by command name.
If STROKES-MAP is not given, `strokes-global-map' will be used instead.

\(fn &optional CHRONOLOGICAL STROKES-MAP)" t nil)

(defvar strokes-mode nil "\
Non-nil if Strokes mode is enabled.
See the command `strokes-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `strokes-mode'.")

(custom-autoload 'strokes-mode "strokes" nil)

(autoload 'strokes-mode "strokes" "\
Toggle Strokes mode, a global minor mode.
With a prefix argument ARG, enable Strokes mode if ARG is
positive, and disable it otherwise.  If called from Lisp,
enable the mode if ARG is omitted or nil.

\\<strokes-mode-map>
Strokes are pictographic mouse gestures which invoke commands.
Strokes are invoked with \\[strokes-do-stroke].  You can define
new strokes with \\[strokes-global-set-stroke].  See also
\\[strokes-do-complex-stroke] for `complex' strokes.

To use strokes for pictographic editing, such as Chinese/Japanese, use
\\[strokes-compose-complex-stroke], which draws strokes and inserts them.
Encode/decode your strokes with \\[strokes-encode-buffer],
\\[strokes-decode-buffer].

\\{strokes-mode-map}

\(fn &optional ARG)" t nil)

(autoload 'strokes-decode-buffer "strokes" "\
Decode stroke strings in BUFFER and display their corresponding glyphs.
Optional BUFFER defaults to the current buffer.
Optional FORCE non-nil will ignore the buffer's read-only status.

\(fn &optional BUFFER FORCE)" t nil)

(autoload 'strokes-compose-complex-stroke "strokes" "\
Read a complex stroke and insert its glyph into the current buffer.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "studly" "play/studly.el" (21676 8647 0 0))
;;; Generated autoloads from play/studly.el

(autoload 'studlify-region "studly" "\
Studlify-case the region.

\(fn BEGIN END)" t nil)

(autoload 'studlify-word "studly" "\
Studlify-case the current word, or COUNT words if given an argument.

\(fn COUNT)" t nil)

(autoload 'studlify-buffer "studly" "\
Studlify-case the current buffer.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "subword" "progmodes/subword.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from progmodes/subword.el

(autoload 'subword-mode "subword" "\
Toggle subword movement and editing (Subword mode).
With a prefix argument ARG, enable Subword mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Subword mode is a buffer-local minor mode.  Enabling it remaps
word-based editing commands to subword-based commands that handle
symbols with mixed uppercase and lowercase letters,
e.g. \"GtkWidget\", \"EmacsFrameClass\", \"NSGraphicsContext\".

Here we call these mixed case symbols `nomenclatures'.  Each
capitalized (or completely uppercase) part of a nomenclature is
called a `subword'.  Here are some examples:

  Nomenclature           Subwords
  ===========================================================
  GtkWindow          =>  \"Gtk\" and \"Window\"
  EmacsFrameClass    =>  \"Emacs\", \"Frame\" and \"Class\"
  NSGraphicsContext  =>  \"NS\", \"Graphics\" and \"Context\"

The subword oriented commands activated in this minor mode recognize
subwords in a nomenclature to move between subwords and to edit them
as words.

\\{subword-mode-map}

\(fn &optional ARG)" t nil)

(defvar global-subword-mode nil "\
Non-nil if Global-Subword mode is enabled.
See the command `global-subword-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-subword-mode'.")

(custom-autoload 'global-subword-mode "subword" nil)

(autoload 'global-subword-mode "subword" "\
Toggle Subword mode in all buffers.
With prefix ARG, enable Global-Subword mode if ARG is positive;
otherwise, disable it.  If called from Lisp, enable the mode if
ARG is omitted or nil.

Subword mode is enabled in all buffers where
`(lambda nil (subword-mode 1))' would do it.
See `subword-mode' for more information on Subword mode.

\(fn &optional ARG)" t nil)

(autoload 'superword-mode "subword" "\
Toggle superword movement and editing (Superword mode).
With a prefix argument ARG, enable Superword mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

Superword mode is a buffer-local minor mode.  Enabling it remaps
word-based editing commands to superword-based commands that
treat symbols as words, e.g. \"this_is_a_symbol\".

The superword oriented commands activated in this minor mode
recognize symbols as superwords to move between superwords and to
edit them as words.

\\{superword-mode-map}

\(fn &optional ARG)" t nil)

(defvar global-superword-mode nil "\
Non-nil if Global-Superword mode is enabled.
See the command `global-superword-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `global-superword-mode'.")

(custom-autoload 'global-superword-mode "subword" nil)

(autoload 'global-superword-mode "subword" "\
Toggle Superword mode in all buffers.
With prefix ARG, enable Global-Superword mode if ARG is positive;
otherwise, disable it.  If called from Lisp, enable the mode if
ARG is omitted or nil.

Superword mode is enabled in all buffers where
`(lambda nil (superword-mode 1))' would do it.
See `superword-mode' for more information on Superword mode.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "supercite" "mail/supercite.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from mail/supercite.el

(autoload 'sc-cite-original "supercite" "\
Workhorse citing function which performs the initial citation.
This is callable from the various mail and news readers' reply
function according to the agreed upon standard.  See the associated
info node `(SC)Top' for more details.
`sc-cite-original' does not do any yanking of the
original message but it does require a few things:

     1) The reply buffer is the current buffer.

     2) The original message has been yanked and inserted into the
        reply buffer.

     3) Verbose mail headers from the original message have been
        inserted into the reply buffer directly before the text of the
        original message.

     4) Point is at the beginning of the verbose headers.

     5) Mark is at the end of the body of text to be cited.

The region need not be active (and typically isn't when this
function is called).  Also, the hook `sc-pre-hook' is run before,
and `sc-post-hook' is run after the guts of this function.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "t-mouse" "t-mouse.el" (21710 25077 0 0))
;;; Generated autoloads from t-mouse.el

(define-obsolete-function-alias 't-mouse-mode 'gpm-mouse-mode "23.1")

(defvar gpm-mouse-mode t "\
Non-nil if Gpm-Mouse mode is enabled.
See the command `gpm-mouse-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `gpm-mouse-mode'.")

(custom-autoload 'gpm-mouse-mode "t-mouse" nil)

(autoload 'gpm-mouse-mode "t-mouse" "\
Toggle mouse support in GNU/Linux consoles (GPM Mouse mode).
With a prefix argument ARG, enable GPM Mouse mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
the mode if ARG is omitted or nil.

This allows the use of the mouse when operating on a GNU/Linux console,
in the same way as you can use the mouse under X11.
It relies on the `gpm' daemon being activated.

\(fn &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "tabify" "tabify.el" (21710 25077 0 0))
;;; Generated autoloads from tabify.el

(autoload 'untabify "tabify" "\
Convert all tabs in region to multiple spaces, preserving columns.
If called interactively with prefix ARG, convert for the entire
buffer.

Called non-interactively, the region is specified by arguments
START and END, rather than by the position of point and mark.
The variable `tab-width' controls the spacing of tab stops.

\(fn START END &optional ARG)" t nil)

(autoload 'tabify "tabify" "\
Convert multiple spaces in region to tabs when possible.
A group of spaces is partially replaced by tabs
when this can be done without changing the column they end at.
If called interactively with prefix ARG, convert for the entire
buffer.

Called non-interactively, the region is specified by arguments
START and END, rather than by the position of point and mark.
The variable `tab-width' controls the spacing of tab stops.

\(fn START END &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "table" "textmodes/table.el" (21710 25077 0
;;;;;;  0))
;;; Generated autoloads from textmodes/table.el

(defvar table-cell-map-hook nil "\
Normal hooks run when finishing construction of `table-cell-map'.
User can modify `table-cell-map' by adding custom functions here.")

(custom-autoload 'table-cell-map-hook "table" t)

(defvar table-load-hook nil "\
List of functions to be called after the table is first loaded.")

(custom-autoload 'table-load-hook "table" t)

(defvar table-point-entered-cell-hook nil "\
List of functions to be called after point entered a table cell.")

(custom-autoload 'table-point-entered-cell-hook "table" t)

(defvar table-point-left-cell-hook nil "\
List of functions to be called after point left a table cell.")

(custom-autoload 'table-point-left-cell-hook "table" t)

(autoload 'table-insert "table" "\
Insert an editable text table.
Insert a table of specified number of COLUMNS and ROWS.  Optional
parameter CELL-WIDTH and CELL-HEIGHT can specify the size of each
cell.  The cell size is uniform across the table if the specified size
is a number.  They can be a list of numbers to specify different size
for each cell.  When called interactively, the list of number is
entered by simply listing all the numbers with space characters
delimiting them.

Examples:

\\[table-insert] inserts a table at the current point location.

Suppose we have the following situation where `-!-' indicates the
location of point.

    -!-

Type \\[table-insert] and hit ENTER key.  As it asks table
specification, provide 3 for number of columns, 1 for number of rows,
5 for cell width and 1 for cell height.  Now you shall see the next
table and the point is automatically moved to the beginning of the
first cell.

    +-----+-----+-----+
    |-!-  |     |     |
    +-----+-----+-----+

Inside a table cell, there are special key bindings. \\<table-cell-map>

M-9 \\[table-widen-cell] (or \\[universal-argument] 9 \\[table-widen-cell]) widens the first cell by 9 character
width, which results as

    +--------------+-----+-----+
    |-!-           |     |     |
    +--------------+-----+-----+

Type TAB \\[table-widen-cell] then type TAB M-2 M-7 \\[table-widen-cell] (or \\[universal-argument] 2 7 \\[table-widen-cell]).  Typing
TAB moves the point forward by a cell. The result now looks like this:

    +--------------+------+--------------------------------+
    |              |      |-!-                             |
    +--------------+------+--------------------------------+

If you knew each width of the columns prior to the table creation,
what you could have done better was to have had given the complete
width information to `table-insert'.

Cell width(s): 14 6 32

instead of

Cell width(s): 5

This would have eliminated the previously mentioned width adjustment
work all together.

If the point is in the last cell type S-TAB S-TAB to move it to the
first cell.  Now type \\[table-heighten-cell] which heighten the row by a line.

    +--------------+------+--------------------------------+
    |-!-           |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+

Type \\[table-insert-row-column] and tell it to insert a row.

    +--------------+------+--------------------------------+
    |-!-           |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+
    |              |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+

Move the point under the table as shown below.

    +--------------+------+--------------------------------+
    |              |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+
    |              |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+
    -!-

Type M-x table-insert-row instead of \\[table-insert-row-column].  \\[table-insert-row-column] does not work
when the point is outside of the table.  This insertion at
outside of the table effectively appends a row at the end.

    +--------------+------+--------------------------------+
    |              |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+
    |              |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+
    |-!-           |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+

Text editing inside the table cell produces reasonably expected
results.

    +--------------+------+--------------------------------+
    |              |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+
    |              |      |Text editing inside the table   |
    |              |      |cell produces reasonably        |
    |              |      |expected results.-!-            |
    +--------------+------+--------------------------------+
    |              |      |                                |
    |              |      |                                |
    +--------------+------+--------------------------------+

Inside a table cell has a special keymap.

\\{table-cell-map}

\(fn COLUMNS ROWS &optional CELL-WIDTH CELL-HEIGHT)" t nil)

(autoload 'table-insert-row "table" "\
Insert N table row(s).
When point is in a table the newly inserted row(s) are placed above
the current row.  When point is outside of the table it must be below
the table within the table width range, then the newly created row(s)
are appended at the bottom of the table.

\(fn N)" t nil)

(autoload 'table-insert-column "table" "\
Insert N table column(s).
When point is in a table the newly inserted column(s) are placed left
of the current column.  When point is outside of the table it must be
right side of the table within the table height range, then the newly
created column(s) are appended at the right of the table.

\(fn N)" t nil)

(autoload 'table-insert-row-column "table" "\
Insert row(s) or column(s).
See `table-insert-row' and `table-insert-column'.

\(fn ROW-COLUMN N)" t nil)

(autoload 'table-recognize "table" "\
Recognize all tables within the current buffer and activate them.
Scans the entire buffer and recognizes valid table cells.  If the
optional numeric prefix argument ARG is negative the tables in the
buffer become inactive, meaning the tables become plain text and loses
all the table specific features.

\(fn &optional ARG)" t nil)

(autoload 'table-unrecognize "table" "\


\(fn)" t nil)

(autoload 'table-recognize-region "table" "\
Recognize all tables within region.
BEG and END specify the region to work on.  If the optional numeric
prefix argument ARG is negative the tables in the region become
inactive, meaning the tables become plain text and lose all the table
specific features.

\(fn BEG END &optional ARG)" t nil)

(autoload 'table-unrecognize-region "table" "\


\(fn BEG END)" t nil)

(autoload 'table-recognize-table "table" "\
Recognize a table at point.
If the optional numeric prefix argument ARG is negative the table
becomes inactive, meaning the table becomes plain text and loses all
the table specific features.

\(fn &optional ARG)" t nil)

(autoload 'table-unrecognize-table "table" "\


\(fn)" t nil)

(autoload 'table-recognize-cell "table" "\
Recognize a table cell that contains current point.
Probe the cell dimension and prepare the cell information.  The
optional two arguments FORCE and NO-COPY are for internal use only and
must not be specified.  When the optional numeric prefix argument ARG
is negative the cell becomes inactive, meaning that the cell becomes
plain text and loses all the table specific features.

\(fn &optional FORCE NO-COPY ARG)" t nil)

(autoload 'table-unrecognize-cell "table" "\


\(fn)" t nil)

(autoload 'table-heighten-cell "table" "\
Heighten the current cell by N lines by expanding the cell vertically.
Heightening is done by adding blank lines at the bottom of the current
cell.  Other cells aligned horizontally with the current one are also
heightened in order to keep the rectangular table structure.  The
optional argument NO-COPY is internal use only and must not be
specified.

\(fn N &optional NO-COPY NO-UPDATE)" t nil)

(autoload 'table-shorten-cell "table" "\
Shorten the current cell by N lines by shrinking the cell vertically.
Shortening is done by removing blank lines from the bottom of the cell
and possibly from the top of the cell as well.  Therefore, the cell
must have some bottom/top blank lines to be shorten effectively.  This
is applicable to all the cells aligned horizontally with the current
one because they are also shortened in order to keep the rectangular
table structure.

\(fn N)" t nil)

(autoload 'table-widen-cell "table" "\
Widen the current cell by N columns and expand the cell horizontally.
Some other cells in the same table are widen as well to keep the
table's rectangle structure.

\(fn N &optional NO-COPY NO-UPDATE)" t nil)

(autoload 'table-narrow-cell "table" "\
Narrow the current cell by N columns and shrink the cell horizontally.
Some other cells in the same table are narrowed as well to keep the
table's rectangle structure.

\(fn N)" t nil)

(autoload 'table-forward-cell "table" "\
Move point forward to the beginning of the next cell.
With argument ARG, do it ARG times;
a negative argument ARG = -N means move backward N cells.
Do not specify NO-RECOGNIZE and UNRECOGNIZE. They are for internal use only.

Sample Cell Traveling Order (In Irregular Table Cases)

You can actually try how it works in this buffer.  Press
\\[table-recognize] and go to cells in the following tables and press
\\[table-forward-cell] or TAB key.

+-----+--+  +--+-----+  +--+--+--+  +--+--+--+  +---------+  +--+---+--+
|0    |1 |  |0 |1    |  |0 |1 |2 |  |0 |1 |2 |  |0        |  |0 |1  |2 |
+--+--+  |  |  +--+--+  +--+  |  |  |  |  +--+  +----+----+  +--+-+-+--+
|2 |3 |  |  |  |2 |3 |  |3 +--+  |  |  +--+3 |  |1   |2   |  |3   |4   |
|  +--+--+  +--+--+  |  +--+4 |  |  |  |4 +--+  +--+-+-+--+  +----+----+
|  |4    |  |4    |  |  |5 |  |  |  |  |  |5 |  |3 |4  |5 |  |5        |
+--+-----+  +-----+--+  +--+--+--+  +--+--+--+  +--+---+--+  +---------+

+--+--+--+  +--+--+--+  +--+--+--+  +--+--+--+
|0 |1 |2 |  |0 |1 |2 |  |0 |1 |2 |  |0 |1 |2 |
|  |  |  |  |  +--+  |  |  |  |  |  +--+  +--+
+--+  +--+  +--+3 +--+  |  +--+  |  |3 +--+4 |
|3 |  |4 |  |4 +--+5 |  |  |3 |  |  +--+5 +--+
|  |  |  |  |  |6 |  |  |  |  |  |  |6 |  |7 |
+--+--+--+  +--+--+--+  +--+--+--+  +--+--+--+

+--+--+--+  +--+--+--+  +--+--+--+--+  +--+-----+--+  +--+--+--+--+
|0 |1 |2 |  |0 |1 |2 |	|0 |1 |2 |3 |  |0 |1    |2 |  |0 |1 |2 |3 |
|  +--+  |  |  +--+  |	|  +--+--+  |  |  |     |  |  |  +--+--+  |
|  |3 +--+  +--+3 |  |	+--+4    +--+  +--+     +--+  +--+4    +--+
+--+  |4 |  |4 |  +--+	|5 +--+--+6 |  |3 +--+--+4 |  |5 |     |6 |
|5 +--+  |  |  +--+5 |	|  |7 |8 |  |  |  |5 |6 |  |  |  |     |  |
|  |6 |  |  |  |6 |  |	+--+--+--+--+  +--+--+--+--+  +--+-----+--+
+--+--+--+  +--+--+--+

\(fn &optional ARG NO-RECOGNIZE UNRECOGNIZE)" t nil)

(autoload 'table-backward-cell "table" "\
Move backward to the beginning of the previous cell.
With argument ARG, do it ARG times;
a negative argument ARG = -N means move forward N cells.

\(fn &optional ARG)" t nil)

(autoload 'table-span-cell "table" "\
Span current cell into adjacent cell in DIRECTION.
DIRECTION is one of symbols; right, left, above or below.

\(fn DIRECTION)" t nil)

(autoload 'table-split-cell-vertically "table" "\
Split current cell vertically.
Creates a cell above and a cell below the current point location.

\(fn)" t nil)

(autoload 'table-split-cell-horizontally "table" "\
Split current cell horizontally.
Creates a cell on the left and a cell on the right of the current point location.

\(fn)" t nil)

(autoload 'table-split-cell "table" "\
Split current cell in ORIENTATION.
ORIENTATION is a symbol either horizontally or vertically.

\(fn ORIENTATION)" t nil)

(autoload 'table-justify "table" "\
Justify contents of a cell, a row of cells or a column of cells.
WHAT is a symbol 'cell, 'row or 'column.  JUSTIFY is a symbol 'left,
'center, 'right, 'top, 'middle, 'bottom or 'none.

\(fn WHAT JUSTIFY)" t nil)

(autoload 'table-justify-cell "table" "\
Justify cell contents.
JUSTIFY is a symbol 'left, 'center or 'right for horizontal, or 'top,
'middle, 'bottom or 'none for vertical.  When optional PARAGRAPH is
non-nil the justify operation is limited to the current paragraph,
otherwise the entire cell contents is justified.

\(fn JUSTIFY &optional PARAGRAPH)" t nil)

(autoload 'table-justify-row "table" "\
Justify cells of a row.
JUSTIFY is a symbol 'left, 'center or 'right for horizontal, or top,
'middle, 'bottom or 'none for vertical.

\(fn JUSTIFY)" t nil)

(autoload 'table-justify-column "table" "\
Justify cells of a column.
JUSTIFY is a symbol 'left, 'center or 'right for horizontal, or top,
'middle, 'bottom or 'none for vertical.

\(fn JUSTIFY)" t nil)

(autoload 'table-fixed-width-mode "table" "\
Cell width is fixed when this is non-nil.
Normally it should be nil for allowing automatic cell width expansion
that widens a cell when it is necessary.  When non-nil, typing in a
cell does not automatically expand the cell width.  A word that is too
long to fit in a cell is chopped into multiple lines.  The chopped
location is indicated by `table-word-continuation-char'.  This
variable's value can be toggled by \\[table-fixed-width-mode] at
run-time.

\(fn &optional ARG)" t nil)

(autoload 'table-query-dimension "table" "\
Return the dimension of the current cell and the current table.
The result is a list (cw ch tw th c r cells) where cw is the cell
width, ch is the cell height, tw is the table width, th is the table
height, c is the number of columns, r is the number of rows and cells
is the total number of cells.  The cell dimension excludes the cell
frame while the table dimension includes the table frame.  The columns
and the rows are counted by the number of cell boundaries.  Therefore
the number tends to be larger than it appears for the tables with
non-uniform cell structure (heavily spanned and split).  When optional
WHERE is provided the cell and table at that location is reported.

\(fn &optional WHERE)" t nil)

(autoload 'table-generate-source "table" "\
Generate source of the current table in the specified language.
LANGUAGE is a symbol that specifies the language to describe the
structure of the table.  It must be either 'html, 'latex or 'cals.
The resulted source text is inserted into DEST-BUFFER and the buffer
object is returned.  When DEST-BUFFER is omitted or nil the default
buffer specified in `table-dest-buffer-name' is used.  In this case
the content of the default buffer is erased prior to the generation.
When DEST-BUFFER is non-nil it is expected to be either a destination
buffer or a name of the destination buffer.  In this case the
generated result is inserted at the current point in the destination
buffer and the previously existing contents in the buffer are
untouched.

References used for this implementation:

HTML:
        URL `http://www.w3.org'

LaTeX:
        URL `http://www.maths.tcd.ie/~dwilkins/LaTeXPrimer/Tables.html'

CALS (DocBook DTD):
        URL `http://www.oasis-open.org/html/a502.htm'
        URL `http://www.oreilly.com/catalog/docbook/chapter/book/table.html#AEN114751'

\(fn LANGUAGE &optional DEST-BUFFER CAPTION)" t nil)

(autoload 'table-insert-sequence "table" "\
Travel cells forward while inserting a specified sequence string in each cell.
STR is the base string from which the sequence starts.  When STR is an
empty string then each cell content is erased.  When STR ends with
numerical characters (they may optionally be surrounded by a pair of
parentheses) they are incremented as a decimal number.  Otherwise the
last character in STR is incremented in ASCII code order.  N is the
number of sequence elements to insert.  When N is negative the cell
traveling direction is backward.  When N is zero it travels forward
entire table.  INCREMENT is the increment between adjacent sequence
elements and can be a negative number for effectively decrementing.
INTERVAL is the number of cells to travel between sequence element
insertion which is normally 1.  When zero or less is given for
INTERVAL it is interpreted as number of cells per row so that sequence
is placed straight down vertically as long as the table's cell
structure is uniform.  JUSTIFY is one of the symbol 'left, 'center or
'right, that specifies justification of the inserted string.

Example:

  (progn
    (table-insert 16 3 5 1)
    (table-forward-cell 15)
    (table-insert-sequence \"D0\" -16 1 1 'center)
    (table-forward-cell 16)
    (table-insert-sequence \"A[0]\" -16 1 1 'center)
    (table-forward-cell 1)
    (table-insert-sequence \"-\" 16 0 1 'center))

  (progn
    (table-insert 16 8 5 1)
    (table-insert-sequence \"@\" 0 1 2 'right)
    (table-forward-cell 1)
    (table-insert-sequence \"64\" 0 1 2 'left))

\(fn STR N INCREMENT INTERVAL JUSTIFY)" t nil)

(autoload 'table-delete-row "table" "\
Delete N row(s) of cells.
Delete N rows of cells from current row.  The current row is the row
contains the current cell where point is located.  Each row must
consists from cells of same height.

\(fn N)" t nil)

(autoload 'table-delete-column "table" "\
Delete N column(s) of cells.
Delete N columns of cells from current column.  The current column is
the column contains the current cell where point is located.  Each
column must consists from cells of same width.

\(fn N)" t nil)

(autoload 'table-capture "table" "\
Convert plain text into a table by capturing the text in the region.
Create a table with the text in region as cell contents.  BEG and END
specify the region.  The text in the region is replaced with a table.
The removed text is inserted in the table.  When optional
COL-DELIM-REGEXP and ROW-DELIM-REGEXP are provided the region contents
is parsed and separated into individual cell contents by using the
delimiter regular expressions.  This parsing determines the number of
columns and rows of the table automatically.  If COL-DELIM-REGEXP and
ROW-DELIM-REGEXP are omitted the result table has only one cell and
the entire region contents is placed in that cell.  Optional JUSTIFY
is one of 'left, 'center or 'right, which specifies the cell
justification.  Optional MIN-CELL-WIDTH specifies the minimum cell
width.  Optional COLUMNS specify the number of columns when
ROW-DELIM-REGEXP is not specified.


Example 1:

1, 2, 3, 4
5, 6, 7, 8
, 9, 10

Running `table-capture' on above 3 line region with COL-DELIM-REGEXP
\",\" and ROW-DELIM-REGEXP \"\\n\" creates the following table.  In
this example the cells are centered and minimum cell width is
specified as 5.

+-----+-----+-----+-----+
|  1  |  2  |  3  |  4  |
+-----+-----+-----+-----+
|  5  |  6  |  7  |  8  |
+-----+-----+-----+-----+
|     |  9  | 10  |     |
+-----+-----+-----+-----+

Note:

In case the function is called interactively user must use \\[quoted-insert] `quoted-insert'
in order to enter \"\\n\" successfully.  COL-DELIM-REGEXP at the end
of each row is optional.


Example 2:

This example shows how a table can be used for text layout editing.
Let `table-capture' capture the following region starting from
-!- and ending at -*-, that contains three paragraphs and two item
name headers.  This time specify empty string for both
COL-DELIM-REGEXP and ROW-DELIM-REGEXP.

-!-`table-capture' is a powerful command however mastering its power
requires some practice.  Here is a list of items what it can do.

Parse Cell Items      By using column delimiter regular
		      expression and raw delimiter regular
		      expression, it parses the specified text
		      area and extracts cell items from
		      non-table text and then forms a table out
		      of them.

Capture Text Area     When no delimiters are specified it
		      creates a single cell table.  The text in
		      the specified region is placed in that
		      cell.-*-

Now the entire content is captured in a cell which is itself a table
like this.

+-----------------------------------------------------------------+
|`table-capture' is a powerful command however mastering its power|
|requires some practice.  Here is a list of items what it can do. |
|                                                                 |
|Parse Cell Items      By using column delimiter regular          |
|                      expression and raw delimiter regular       |
|                      expression, it parses the specified text   |
|                      area and extracts cell items from          |
|                      non-table text and then forms a table out  |
|                      of them.                                   |
|                                                                 |
|Capture Text Area     When no delimiters are specified it        |
|                      creates a single cell table.  The text in  |
|                      the specified region is placed in that     |
|                      cell.                                      |
+-----------------------------------------------------------------+

By splitting the cell appropriately we now have a table consisting of
paragraphs occupying its own cell.  Each cell can now be edited
independently.

+-----------------------------------------------------------------+
|`table-capture' is a powerful command however mastering its power|
|requires some practice.  Here is a list of items what it can do. |
+---------------------+-------------------------------------------+
|Parse Cell Items     |By using column delimiter regular          |
|                     |expression and raw delimiter regular       |
|                     |expression, it parses the specified text   |
|                     |area and extracts cell items from          |
|                     |non-table text and then forms a table out  |
|                     |of them.                                   |
+---------------------+-------------------------------------------+
|Capture Text Area    |When no delimiters are specified it        |
|                     |creates a single cell table.  The text in  |
|                     |the specified region is placed in that     |
|                     |cell.                                      |
+---------------------+-------------------------------------------+

By applying `table-release', which does the opposite process, the
contents become once again plain text.  `table-release' works as
companion command to `table-capture' this way.

\(fn BEG END &optional COL-DELIM-REGEXP ROW-DELIM-REGEXP JUSTIFY MIN-CELL-WIDTH COLUMNS)" t nil)

(autoload 'table-release "table" "\
Convert a table into plain text by removing the frame from a table.
Remove the frame from a table and deactivate the table.  This command
converts a table into plain text without frames.  It is a companion to
`table-capture' which does the opposite process.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "talk" "talk.el" (21710 25077 0 0))
;;; Generated autoloads from talk.el

(autoload 'talk-connect "talk" "\
Connect to display DISPLAY for the Emacs talk group.

\(fn DISPLAY)" t nil)

(autoload 'talk "talk" "\
Connect to the Emacs talk group from the current X display or tty frame.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "tar-mode" "tar-mode.el" (21788 61018 0 0))
;;; Generated autoloads from tar-mode.el

(autoload 'tar-mode "tar-mode" "\
Major mode for viewing a tar file as a dired-like listing of its contents.
You can move around using the usual cursor motion commands.
Letters no longer insert themselves.
Type `e' to pull a file out of the tar file and into its own buffer;
or click mouse-2 on the file's line in the Tar mode buffer.
Type `c' to copy an entry from the tar file into another file on disk.

If you edit a sub-file of this archive (as with the `e' command) and
save it with \\[save-buffer], the contents of that buffer will be
saved back into the tar-file buffer; in this way you can edit a file
inside of a tar archive without extracting it and re-archiving it.

See also: variables `tar-update-datestamp' and `tar-anal-blocksize'.
\\{tar-mode-map}

\(fn)" t nil)

;;;***

;;;### (autoloads nil "tcl" "progmodes/tcl.el" (21710 25077 0 0))
;;; Generated autoloads from progmodes/tcl.el

(autoload 'tcl-mode "tcl" "\
Major mode for editing Tcl code.
Expression and list commands understand all Tcl brackets.
Tab indents for Tcl code.
Paragraphs are separated by blank lines only.
Delete converts tabs to spaces as it moves back.

Variables controlling indentation style:
  `tcl-indent-level'
    Indentation of Tcl statements within surrounding block.
  `tcl-continued-indent-level'
    Indentation of continuation line relative to first line of command.

Variables controlling user interaction with mode (see variable
documentation for details):
  `tcl-tab-always-indent'
    Controls action of TAB key.
  `tcl-auto-newline'
    Non-nil means automatically newline before and after braces, brackets,
    and semicolons inserted in Tcl code.
  `tcl-use-smart-word-finder'
    If not nil, use a smarter, Tcl-specific way to find the current
    word when looking up help on a Tcl command.

Turning on Tcl mode runs `tcl-mode-hook'.  Read the documentation for
`tcl-mode-hook' to see what kinds of interesting hook functions
already exist.

\(fn)" t nil)

(autoload 'inferior-tcl "tcl" "\
Run inferior Tcl process.
Prefix arg means enter program name interactively.
See documentation for function `inferior-tcl-mode' for more information.

\(fn CMD)" t nil)

(autoload 'tcl-help-on-word "tcl" "\
Get help on Tcl command.  Default is word at point.
Prefix argument means invert sense of `tcl-use-smart-word-finder'.

\(fn COMMAND &optional ARG)" t nil)

;;;***

;;;### (autoloads nil "telnet" "net/telnet.el" (21710 25077 0 0))
;;; Generated autoloads from net/telnet.el

(autoload 'telnet "telnet" "\
Open a network login connection to host named HOST (a string).
Optional arg PORT specifies alternative port to connect to.
Interactively, use \\[universal-argument] prefix to be prompted for port number.

Communication with HOST is recorded in a buffer `*PROGRAM-HOST*'
where PROGRAM is the telnet program being used.  This program
is controlled by the contents of the global variable `telnet-host-properties',
falling back on the value of the global variable `telnet-program'.
Normally input is edited in Emacs and sent a line at a time.

\(fn HOST &optional PORT)" t nil)

(autoload 'rsh "telnet" "\
Open a network login connection to host named HOST (a string).
Communication with HOST is recorded in a buffer `*rsh-HOST*'.
Normally input is edited in Emacs and sent a line at a time.

\(fn HOST)" t nil)

;;;***

;;;### (autoloads nil "term" "term.el" (21788 61018 0 0))
;;; Generated autoloads from term.el

(autoload 'make-term "term" "\
Make a term process NAME in a buffer, running PROGRAM.
The name of the buffer is made by surrounding NAME with `*'s.
If there is already a running process in that buffer, it is not restarted.
Optional third arg STARTFILE is the name of a file to send the contents of to
the process.  Any more args are arguments to PROGRAM.

\(fn NAME PROGRAM &optional STARTFILE &rest SWITCHES)" nil nil)

(autoload 'term "term" "\
Start a terminal-emulator in a new buffer.
The buffer is in Term mode; see `term-mode' for the
commands to use in that buffer.

\\<term-raw-map>Type \\[switch-to-buffer] to switch to another buffer.

\(fn PROGRAM)" t nil)

(autoload 'ansi-term "term" "\
Start a terminal-emulator in a new buffer.

\(fn PROGRAM &optional NEW-BUFFER-NAME)" t nil)

(autoload 'serial-term "term" "\
Start a terminal-emulator for a serial port in a new buffer.
PORT is the path or name of the serial port.  For example, this
could be \"/dev/ttyS0\" on Unix.  On Windows, this could be
\"COM1\" or \"\\\\.\\COM10\".
SPEED is the speed of the serial port in bits per second.  9600
is a common value.  SPEED can be nil, see
`serial-process-configure' for details.
The buffer is in Term mode; see `term-mode' for the commands to
use in that buffer.
\\<term-raw-map>Type \\[switch-to-buffer] to switch to another buffer.

\(fn PORT SPEED)" t nil)

;;;***

;;;### (autoloads nil "testcover" "emacs-lisp/testcover.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from emacs-lisp/testcover.el

(autoload 'testcover-this-defun "testcover" "\
Start coverage on function under point.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "tetris" "play/tetris.el" (21710 25077 0 0))
;;; Generated autoloads from play/tetris.el
(push (purecopy '(tetris 2 1)) package--builtin-versions)

(autoload 'tetris "tetris" "\
Play the Tetris game.
Shapes drop from the top of the screen, and the user has to move and
rotate the shape to fit in with those at the bottom of the screen so
as to form complete rows.

tetris-mode keybindings:
   \\<tetris-mode-map>
\\[tetris-start-game]	Starts a new game of Tetris
\\[tetris-end-game]	Terminates the current game
\\[tetris-pause-game]	Pauses (or resumes) the current game
\\[tetris-move-left]	Moves the shape one square to the left
\\[tetris-move-right]	Moves the shape one square to the right
\\[tetris-rotate-prev]	Rotates the shape clockwise
\\[tetris-rotate-next]	Rotates the shape anticlockwise
\\[tetris-move-bottom]	Drops the shape to the bottom of the playing area

\(fn)" t nil)

;;;***

;;;### (autoloads nil "tex-mode" "textmodes/tex-mode.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from textmodes/tex-mode.el

(defvar tex-shell-file-name nil "\
If non-nil, the shell file name to run in the subshell used to run TeX.")

(custom-autoload 'tex-shell-file-name "tex-mode" t)

(defvar tex-directory (purecopy ".") "\
Directory in which temporary files are written.
You can make this `/tmp' if your TEXINPUTS has no relative directories in it
and you don't try to apply \\[tex-region] or \\[tex-buffer] when there are
`\\input' commands with relative directories.")

(custom-autoload 'tex-directory "tex-mode" t)

(defvar tex-first-line-header-regexp nil "\
Regexp for matching a first line which `tex-region' should include.
If this is non-nil, it should be a regular expression string;
if it matches the first line of the file,
`tex-region' always includes the first line in the TeX run.")

(custom-autoload 'tex-first-line-header-regexp "tex-mode" t)

(defvar tex-main-file nil "\
The main TeX source file which includes this buffer's file.
The command `tex-file' runs TeX on the file specified by `tex-main-file'
if the variable is non-nil.")

(custom-autoload 'tex-main-file "tex-mode" t)

(defvar tex-offer-save t "\
If non-nil, ask about saving modified buffers before \\[tex-file] is run.")

(custom-autoload 'tex-offer-save "tex-mode" t)

(defvar tex-run-command (purecopy "tex") "\
Command used to run TeX subjob.
TeX Mode sets `tex-command' to this string.
See the documentation of that variable.")

(custom-autoload 'tex-run-command "tex-mode" t)

(defvar latex-run-command (purecopy "latex") "\
Command used to run LaTeX subjob.
LaTeX Mode sets `tex-command' to this string.
See the documentation of that variable.")

(custom-autoload 'latex-run-command "tex-mode" t)

(defvar slitex-run-command (purecopy "slitex") "\
Command used to run SliTeX subjob.
SliTeX Mode sets `tex-command' to this string.
See the documentation of that variable.")

(custom-autoload 'slitex-run-command "tex-mode" t)

(defvar tex-start-options (purecopy "") "\
TeX options to use when starting TeX.
These immediately precede the commands in `tex-start-commands'
and the input file name, with no separating space and are not shell-quoted.
If nil, TeX runs with no options.  See the documentation of `tex-command'.")

(custom-autoload 'tex-start-options "tex-mode" t)

(defvar tex-start-commands (purecopy "\\nonstopmode\\input") "\
TeX commands to use when starting TeX.
They are shell-quoted and precede the input file name, with a separating space.
If nil, no commands are used.  See the documentation of `tex-command'.")

(custom-autoload 'tex-start-commands "tex-mode" t)

(defvar latex-block-names nil "\
User defined LaTeX block names.
Combined with `latex-standard-block-names' for minibuffer completion.")

(custom-autoload 'latex-block-names "tex-mode" t)

(defvar tex-bibtex-command (purecopy "bibtex") "\
Command used by `tex-bibtex-file' to gather bibliographic data.
If this string contains an asterisk (`*'), that is replaced by the file name;
otherwise, the file name, preceded by blank, is added at the end.")

(custom-autoload 'tex-bibtex-command "tex-mode" t)

(defvar tex-dvi-print-command (purecopy "lpr -d") "\
Command used by \\[tex-print] to print a .dvi file.
If this string contains an asterisk (`*'), that is replaced by the file name;
otherwise, the file name, preceded by blank, is added at the end.")

(custom-autoload 'tex-dvi-print-command "tex-mode" t)

(defvar tex-alt-dvi-print-command (purecopy "lpr -d") "\
Command used by \\[tex-print] with a prefix arg to print a .dvi file.
If this string contains an asterisk (`*'), that is replaced by the file name;
otherwise, the file name, preceded by blank, is added at the end.

If two printers are not enough of a choice, you can set the variable
`tex-alt-dvi-print-command' to an expression that asks what you want;
for example,

    (setq tex-alt-dvi-print-command
         '(format \"lpr -P%s\" (read-string \"Use printer: \")))

would tell \\[tex-print] with a prefix argument to ask you which printer to
use.")

(custom-autoload 'tex-alt-dvi-print-command "tex-mode" t)

(defvar tex-dvi-view-command `(cond ((eq window-system 'x) ,(purecopy "xdvi")) ((eq window-system 'w32) ,(purecopy "yap")) (t ,(purecopy "dvi2tty * | cat -s"))) "\
Command used by \\[tex-view] to display a `.dvi' file.
If it is a string, that specifies the command directly.
If this string contains an asterisk (`*'), that is replaced by the file name;
otherwise, the file name, preceded by a space, is added at the end.

If the value is a form, it is evaluated to get the command to use.")

(custom-autoload 'tex-dvi-view-command "tex-mode" t)

(defvar tex-show-queue-command (purecopy "lpq") "\
Command used by \\[tex-show-print-queue] to show the print queue.
Should show the queue(s) that \\[tex-print] puts jobs on.")

(custom-autoload 'tex-show-queue-command "tex-mode" t)

(defvar tex-default-mode 'latex-mode "\
Mode to enter for a new file that might be either TeX or LaTeX.
This variable is used when it can't be determined whether the file
is plain TeX or LaTeX or what because the file contains no commands.
Normally set to either `plain-tex-mode' or `latex-mode'.")

(custom-autoload 'tex-default-mode "tex-mode" t)

(defvar tex-open-quote (purecopy "``") "\
String inserted by typing \\[tex-insert-quote] to open a quotation.")

(custom-autoload 'tex-open-quote "tex-mode" t)

(defvar tex-close-quote (purecopy "''") "\
String inserted by typing \\[tex-insert-quote] to close a quotation.")

(custom-autoload 'tex-close-quote "tex-mode" t)

(autoload 'tex-mode "tex-mode" "\
Major mode for editing files of input for TeX, LaTeX, or SliTeX.
Tries to determine (by looking at the beginning of the file) whether
this file is for plain TeX, LaTeX, or SliTeX and calls `plain-tex-mode',
`latex-mode', or `slitex-mode', respectively.  If it cannot be determined,
such as if there are no commands in the file, the value of `tex-default-mode'
says which mode to use.

\(fn)" t nil)

(defalias 'TeX-mode 'tex-mode)

(defalias 'plain-TeX-mode 'plain-tex-mode)

(defalias 'LaTeX-mode 'latex-mode)

(autoload 'plain-tex-mode "tex-mode" "\
Major mode for editing files of input for plain TeX.
Makes $ and } display the characters they match.
Makes \" insert `` when it seems to be the beginning of a quotation,
and '' when it appears to be the end; it inserts \" only after a \\.

Use \\[tex-region] to run TeX on the current region, plus a \"header\"
copied from the top of the file (containing macro definitions, etc.),
running TeX under a special subshell.  \\[tex-buffer] does the whole buffer.
\\[tex-file] saves the buffer and then processes the file.
\\[tex-print] prints the .dvi file made by any of these.
\\[tex-view] previews the .dvi file made by any of these.
\\[tex-bibtex-file] runs bibtex on the file of the current buffer.

Use \\[tex-validate-buffer] to check buffer for paragraphs containing
mismatched $'s or braces.

Special commands:
\\{plain-tex-mode-map}

Mode variables:
tex-run-command
	Command string used by \\[tex-region] or \\[tex-buffer].
tex-directory
	Directory in which to create temporary files for TeX jobs
	run by \\[tex-region] or \\[tex-buffer].
tex-dvi-print-command
	Command string used by \\[tex-print] to print a .dvi file.
tex-alt-dvi-print-command
	Alternative command string used by \\[tex-print] (when given a prefix
	argument) to print a .dvi file.
tex-dvi-view-command
	Command string used by \\[tex-view] to preview a .dvi file.
tex-show-queue-command
	Command string used by \\[tex-show-print-queue] to show the print
	queue that \\[tex-print] put your job on.

Entering Plain-tex mode runs the hook `text-mode-hook', then the hook
`tex-mode-hook', and finally the hook `plain-tex-mode-hook'.  When the
special subshell is initiated, the hook `tex-shell-hook' is run.

\(fn)" t nil)

(autoload 'latex-mode "tex-mode" "\
Major mode for editing files of input for LaTeX.
Makes $ and } display the characters they match.
Makes \" insert `` when it seems to be the beginning of a quotation,
and '' when it appears to be the end; it inserts \" only after a \\.

Use \\[tex-region] to run LaTeX on the current region, plus the preamble
copied from the top of the file (containing \\documentstyle, etc.),
running LaTeX under a special subshell.  \\[tex-buffer] does the whole buffer.
\\[tex-file] saves the buffer and then processes the file.
\\[tex-print] prints the .dvi file made by any of these.
\\[tex-view] previews the .dvi file made by any of these.
\\[tex-bibtex-file] runs bibtex on the file of the current buffer.

Use \\[tex-validate-buffer] to check buffer for paragraphs containing
mismatched $'s or braces.

Special commands:
\\{latex-mode-map}

Mode variables:
latex-run-command
	Command string used by \\[tex-region] or \\[tex-buffer].
tex-directory
	Directory in which to create temporary files for LaTeX jobs
	run by \\[tex-region] or \\[tex-buffer].
tex-dvi-print-command
	Command string used by \\[tex-print] to print a .dvi file.
tex-alt-dvi-print-command
	Alternative command string used by \\[tex-print] (when given a prefix
	argument) to print a .dvi file.
tex-dvi-view-command
	Command string used by \\[tex-view] to preview a .dvi file.
tex-show-queue-command
	Command string used by \\[tex-show-print-queue] to show the print
	queue that \\[tex-print] put your job on.

Entering Latex mode runs the hook `text-mode-hook', then
`tex-mode-hook', and finally `latex-mode-hook'.  When the special
subshell is initiated, `tex-shell-hook' is run.

\(fn)" t nil)

(autoload 'slitex-mode "tex-mode" "\
Major mode for editing files of input for SliTeX.
Makes $ and } display the characters they match.
Makes \" insert `` when it seems to be the beginning of a quotation,
and '' when it appears to be the end; it inserts \" only after a \\.

Use \\[tex-region] to run SliTeX on the current region, plus the preamble
copied from the top of the file (containing \\documentstyle, etc.),
running SliTeX under a special subshell.  \\[tex-buffer] does the whole buffer.
\\[tex-file] saves the buffer and then processes the file.
\\[tex-print] prints the .dvi file made by any of these.
\\[tex-view] previews the .dvi file made by any of these.
\\[tex-bibtex-file] runs bibtex on the file of the current buffer.

Use \\[tex-validate-buffer] to check buffer for paragraphs containing
mismatched $'s or braces.

Special commands:
\\{slitex-mode-map}

Mode variables:
slitex-run-command
	Command string used by \\[tex-region] or \\[tex-buffer].
tex-directory
	Directory in which to create temporary files for SliTeX jobs
	run by \\[tex-region] or \\[tex-buffer].
tex-dvi-print-command
	Command string used by \\[tex-print] to print a .dvi file.
tex-alt-dvi-print-command
	Alternative command string used by \\[tex-print] (when given a prefix
	argument) to print a .dvi file.
tex-dvi-view-command
	Command string used by \\[tex-view] to preview a .dvi file.
tex-show-queue-command
	Command string used by \\[tex-show-print-queue] to show the print
	queue that \\[tex-print] put your job on.

Entering SliTeX mode runs the hook `text-mode-hook', then the hook
`tex-mode-hook', then the hook `latex-mode-hook', and finally the hook
`slitex-mode-hook'.  When the special subshell is initiated, the hook
`tex-shell-hook' is run.

\(fn)" t nil)

(autoload 'tex-start-shell "tex-mode" "\


\(fn)" nil nil)

(autoload 'doctex-mode "tex-mode" "\
Major mode to edit DocTeX files.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "texinfmt" "textmodes/texinfmt.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from textmodes/texinfmt.el

(autoload 'texinfo-format-buffer "texinfmt" "\
Process the current buffer as texinfo code, into an Info file.
The Info file output is generated in a buffer visiting the Info file
name specified in the @setfilename command.

Non-nil argument (prefix, if interactive) means don't make tag table
and don't split the file if large.  You can use `Info-tagify' and
`Info-split' to do these manually.

\(fn &optional NOSPLIT)" t nil)

(autoload 'texinfo-format-region "texinfmt" "\
Convert the current region of the Texinfo file to Info format.
This lets you see what that part of the file will look like in Info.
The command is bound to \\[texinfo-format-region].  The text that is
converted to Info is stored in a temporary buffer.

\(fn REGION-BEGINNING REGION-END)" t nil)

(autoload 'texi2info "texinfmt" "\
Convert the current buffer (written in Texinfo code) into an Info file.
The Info file output is generated in a buffer visiting the Info file
names specified in the @setfilename command.

This function automatically updates all node pointers and menus, and
creates a master menu.  This work is done on a temporary buffer that
is automatically removed when the Info file is created.  The original
Texinfo source buffer is not changed.

Non-nil argument (prefix, if interactive) means don't split the file
if large.  You can use `Info-split' to do this manually.

\(fn &optional NOSPLIT)" t nil)

;;;***

;;;### (autoloads nil "texinfo" "textmodes/texinfo.el" (21710 25077
;;;;;;  0 0))
;;; Generated autoloads from textmodes/texinfo.el

(defvar texinfo-open-quote (purecopy "``") "\
String inserted by typing \\[texinfo-insert-quote] to open a quotation.")

(custom-autoload 'texinfo-open-quote "texinfo" t)

(defvar texinfo-close-quote (purecopy "''") "\
String inserted by typing \\[texinfo-insert-quote] to close a quotation.")

(custom-autoload 'texinfo-close-quote "texinfo" t)

(autoload 'texinfo-mode "texinfo" "\
Major mode for editing Texinfo files.

  It has these extra commands:
\\{texinfo-mode-map}

  These are files that are used as input for TeX to make printed manuals
and also to be turned into Info files with \\[makeinfo-buffer] or
the `makeinfo' program.  These files must be written in a very restricted and
modified version of TeX input format.

  Editing commands are like text-mode except that the syntax table is
set up so expression commands skip Texinfo bracket groups.  To see
what the Info version of a region of the Texinfo file will look like,
use \\[makeinfo-region], which runs `makeinfo' on the current region.

  You can show the structure of a Texinfo file with \\[texinfo-show-structure].
This command shows the structure of a Texinfo file by listing the
lines with the @-sign commands for @chapter, @section, and the like.
These lines are displayed in another window called the *Occur* window.
In that window, you can position the cursor over one of the lines and
use \\[occur-mode-goto-occurrence], to jump to the corresponding spot
in the Texinfo file.

  In addition, Texinfo mode provides commands that insert various
frequently used @-sign commands into the buffer.  You can use these
commands to save keystrokes.  And you can insert balanced braces with
\\[texinfo-insert-braces] and later use the command \\[up-list] to
move forward past the closing brace.

Also, Texinfo mode provides functions for automatically creating or
updating menus and node pointers.  These functions

  * insert the `Next', `Previous' and `Up' pointers of a node,
  * insert or update the menu for a section, and
  * create a master menu for a Texinfo source file.

Here are the functions:

    texinfo-update-node                \\[texinfo-update-node]
    texinfo-every-node-update          \\[texinfo-every-node-update]
    texinfo-sequential-node-update

    texinfo-make-menu                  \\[texinfo-make-menu]
    texinfo-all-menus-update           \\[texinfo-all-menus-update]
    texinfo-master-menu

    texinfo-indent-menu-description (column &optional region-p)

The `texinfo-column-for-description' variable specifies the column to
which menu descriptions are indented.

Passed an argument (a prefix argument, if interactive), the
`texinfo-update-node' and `texinfo-make-menu' functions do their jobs
in the region.

To use the updating commands, you must structure your Texinfo file
hierarchically, such that each `@node' line, with the exception of the
Top node, is accompanied by some kind of section line, such as an
`@chapter' or `@section' line.

If the file has a `top' node, it must be called `top' or `Top' and
be the first node in the file.

Entering Texinfo mode calls the value of `text-mode-hook', and then the
value of `texinfo-mode-hook'.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "thai-util" "language/thai-util.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from language/thai-util.el

(autoload 'thai-compose-region "thai-util" "\
Compose Thai characters in the region.
When called from a program, expects two arguments,
positions (integers or markers) specifying the region.

\(fn BEG END)" t nil)

(autoload 'thai-compose-string "thai-util" "\
Compose Thai characters in STRING and return the resulting string.

\(fn STRING)" nil nil)

(autoload 'thai-compose-buffer "thai-util" "\
Compose Thai characters in the current buffer.

\(fn)" t nil)

(autoload 'thai-composition-function "thai-util" "\


\(fn GSTRING)" nil nil)

;;;***

;;;### (autoloads nil "thingatpt" "thingatpt.el" (21710 25077 0 0))
;;; Generated autoloads from thingatpt.el

(autoload 'forward-thing "thingatpt" "\
Move forward to the end of the Nth next THING.
THING should be a symbol specifying a type of syntactic entity.
Possibilities include `symbol', `list', `sexp', `defun',
`filename', `url', `email', `word', `sentence', `whitespace',
`line', and `page'.

\(fn THING &optional N)" nil nil)

(autoload 'bounds-of-thing-at-point "thingatpt" "\
Determine the start and end buffer locations for the THING at point.
THING should be a symbol specifying a type of syntactic entity.
Possibilities include `symbol', `list', `sexp', `defun',
`filename', `url', `email', `word', `sentence', `whitespace',
`line', and `page'.

See the file `thingatpt.el' for documentation on how to define a
valid THING.

Return a cons cell (START . END) giving the start and end
positions of the thing found.

\(fn THING)" nil nil)

(autoload 'thing-at-point "thingatpt" "\
Return the THING at point.
THING should be a symbol specifying a type of syntactic entity.
Possibilities include `symbol', `list', `sexp', `defun',
`filename', `url', `email', `word', `sentence', `whitespace',
`line', `number', and `page'.

When the optional argument NO-PROPERTIES is non-nil,
strip text properties from the return value.

See the file `thingatpt.el' for documentation on how to define
a symbol as a valid THING.

\(fn THING &optional NO-PROPERTIES)" nil nil)

(autoload 'sexp-at-point "thingatpt" "\
Return the sexp at point, or nil if none is found.

\(fn)" nil nil)

(autoload 'symbol-at-point "thingatpt" "\
Return the symbol at point, or nil if none is found.

\(fn)" nil nil)

(autoload 'number-at-point "thingatpt" "\
Return the number at point, or nil if none is found.

\(fn)" nil nil)

(autoload 'list-at-point "thingatpt" "\
Return the Lisp list at point, or nil if none is found.

\(fn)" nil nil)

;;;***

;;;### (autoloads nil "thumbs" "thumbs.el" (21710 25077 0 0))
;;; Generated autoloads from thumbs.el

(autoload 'thumbs-find-thumb "thumbs" "\
Display the thumbnail for IMG.

\(fn IMG)" t nil)

(autoload 'thumbs-show-from-dir "thumbs" "\
Make a preview buffer for all images in DIR.
Optional argument REG to select file matching a regexp,
and SAME-WINDOW to show thumbs in the same window.

\(fn DIR &optional REG SAME-WINDOW)" t nil)

(autoload 'thumbs-dired-show-marked "thumbs" "\
In dired, make a thumbs buffer with marked files.

\(fn)" t nil)

(autoload 'thumbs-dired-show "thumbs" "\
In dired, make a thumbs buffer with all files in current directory.

\(fn)" t nil)

(defalias 'thumbs 'thumbs-show-from-dir)

(autoload 'thumbs-dired-setroot "thumbs" "\
In dired, call the setroot program on the image at point.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "tibet-util" "language/tibet-util.el" (21710
;;;;;;  25077 0 0))
;;; Generated autoloads from language/tibet-util.el

(autoload 'tibetan-char-p "tibet-util" "\
Check if char CH is Tibetan character.
Returns non-nil if CH is Tibetan. Otherwise, returns nil.

\(fn CH)" nil nil)

(autoload 'tibetan-tibetan-to-transcription "tibet-util" "\
Transcribe Tibetan string STR and return the corresponding Roman string.

\(fn STR)" nil nil)

(autoload 'tibetan-transcription-to-tibetan "tibet-util" "\
Convert Tibetan Roman string STR to Tibetan character string.
The returned string has no composition information.

\(fn STR)" nil nil)

(autoload 'tibetan-compose-string "tibet-util" "\
Compose Tibetan string STR.

\(fn STR)" nil nil)

(autoload 'tibetan-compose-region "tibet-util" "\
Compose Tibetan text the region BEG and END.

\(fn BEG END)" t nil)

(autoload 'tibetan-decompose-region "tibet-util" "\
Decompose Tibetan text in the region FROM and TO.
This is different from decompose-region because precomposed Tibetan characters
are decomposed into normal Tibetan character sequences.

\(fn FROM TO)" t nil)

(autoload 'tibetan-decompose-string "tibet-util" "\
Decompose Tibetan string STR.
This is different from decompose-string because precomposed Tibetan characters
are decomposed into normal Tibetan character sequences.

\(fn STR)" nil nil)

(autoload 'tibetan-decompose-buffer "tibet-util" "\
Decomposes Tibetan characters in the buffer into their components.
See also the documentation of the function `tibetan-decompose-region'.

\(fn)" t nil)

(autoload 'tibetan-compose-buffer "tibet-util" "\
Composes Tibetan character components in the buffer.
See also docstring of the function tibetan-compose-region.

\(fn)" t nil)

(autoload 'tibetan-post-read-conversion "tibet-util" "\


\(fn LEN)" nil nil)

(autoload 'tibetan-pre-write-conversion "tibet-util" "\


\(fn FROM TO)" nil nil)

(autoload 'tibetan-pre-write-canonicalize-for-unicode "tibet-util" "\


\(fn FROM TO)" nil nil)

;;;***

;;;### (autoloads nil "tildify" "textmodes/tildify.el" (21788 61018
;;;;;;  0 0))
;;; Generated autoloads from textmodes/tildify.el
(push (purecopy '(tildify 4 5)) package--builtin-versions)

(autoload 'tildify-region "tildify" "\
Add hard spaces in the region between BEG and END.
See variables `tildify-pattern-alist', `tildify-string-alist', and
`tildify-ignored-environments-alist' for information about configuration
parameters.
This function performs no refilling of the changed text.

\(fn BEG END)" t nil)

(autoload 'tildify-buffer "tildify" "\
Add hard spaces in the current buffer.
See variables `tildify-pattern-alist', `tildify-string-alist', and
`tildify-ignored-environments-alist' for information about configuration
parameters.
This function performs no refilling of the changed text.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "time" "time.el" (21710 25077 0 0))
;;; Generated autoloads from time.el

(defvar display-time-day-and-date nil "\
Non-nil means \\[display-time] should display day and date as well as time.")

(custom-autoload 'display-time-day-and-date "time" t)
(put 'display-time-string 'risky-local-variable t)

(autoload 'display-time "time" "\
Enable display of time, load level, and mail flag in mode lines.
This display updates automatically every minute.
If `display-time-day-and-date' is non-nil, the current day and date
are displayed as well.
This runs the normal hook `display-time-hook' after each update.

\(fn)" t nil)

(defvar display-time-mode nil "\
Non-nil if Display-Time mode is enabled.
See the command `display-time-mode' for a description of this minor mode.
Setting this variable directly does not take effect;
either customize it (see the info node `Easy Customization')
or call the function `display-time-mode'.")

(custom-autoload 'display-time-mode "time" nil)

(autoload 'display-time-mode "time" "\
Toggle display of time, load level, and mail flag in mode lines.
With a prefix argument ARG, enable Display Time mode if ARG is
positive, and disable it otherwise.  If called from Lisp, enable
it if ARG is omitted or nil.

When Display Time mode is enabled, it updates every minute (you
can control the number of seconds between updates by customizing
`display-time-interval').  If `display-time-day-and-date' is
non-nil, the current day and date are displayed as well.  This
runs the normal hook `display-time-hook' after each update.

\(fn &optional ARG)" t nil)

(autoload 'display-time-world "time" "\
Enable updating display of times in various time zones.
`display-time-world-list' specifies the zones.
To turn off the world time display, go to that window and type `q'.

\(fn)" t nil)

(autoload 'emacs-uptime "time" "\
Return a string giving the uptime of this instance of Emacs.
FORMAT is a string to format the result, using `format-seconds'.
For example, the Unix uptime command format is \"%D, %z%2h:%.2m\".

\(fn &optional FORMAT)" t nil)

(autoload 'emacs-init-time "time" "\
Return a string giving the duration of the Emacs initialization.

\(fn)" t nil)

;;;***

;;;### (autoloads nil "time-date" "calendar/time-date.el" (21788
;;;;;;  61018 0 0))
;;; Generated autoloads from calendar/time-date.el

(autoload 'date-to-time "time-date" "\
Parse a string DATE that represents a date-time and return a time value.
If DATE lacks timezone information, GMT is assumed.

\(fn DATE)" nil nil)
(if (or (featurep 'emacs)
       (and (fboundp 'float-time)
            (subrp (symbol-function 'float-time))))
   (defalias 'time-to-seconds 'float-time)
 (autoload 'time-to-seconds "time-date"))

(autoload 'seconds-to-time "time-date" "\
Convert SECONDS (a floating point number) to a time value.

\(fn SECONDS)" nil nil)

(autoload 'time-less-p "time-date" "\
Return non-nil if time value T1 is earlier than time value T2.

\(fn T1 T2)" nil nil)

(autoload 'days-to-time "time-date" "\
Convert DAYS into a time value.

\(fn DAYS)" nil nil)

(autoload 'time-since "time-date" "\
Return the time elapsed since TIME.
TIME should be either a time value or a date-time string.

\(fn TIME)" nil nil)

(defalias 'subtract-time 'time-subtract)

(autoload 'time-subtract "time-date" "\
Subtract two time values, T1 minus T2.
Return the difference in the format of a time value.

\(fn T1 T2)" nil nil)

(autoload 'time-add "time-date" "\
Add two time values T1 and T2.  One should represent a time difference.

\(fn T1 T2)" nil nil)

(autoload 'date-to-day "time-date" "\
Return the number of days between year 1 and DATE.
DATE should be a date-time string.

\(fn DATE)" nil nil)

(autoload 'days-between "time-date" "\
Return the number of days between DATE1 and DATE2.
DATE1 and DATE2 should be date-time strings.

\(fn DATE1 DATE2)" nil nil)

(autoload 'date-leap-year-p "time-date" "\
Return t if YEAR is a leap year.

\(fn YEAR)" nil nil)

(autoload 'time-to-day-in-year "time-date" "\
Return the day number within the year corresponding to TIME.

\(fn TIME)" nil nil)

(autoload 'time-to-days "time-date" "\
The number of days between the Gregorian date 0001-12-31bce and TIME.
TIME should be a time value.
The Gregorian date Sunday, December 31, 1bce is imaginary.

\(fn TIME)" nil nil)

(autoload 'safe-date-to-time "time-date" "\
Parse a string DATE that represents a date-