/*  RetroArch - A frontend for libretro.
 *  Copyright (C) 2011-2015 - Daniel De Matteis
 * 
 *  RetroArch is free software: you can redistribute it and/or modify it under the terms
 *  of the GNU General Public License as published by the Free Software Found-
 *  ation, either version 3 of the License, or (at your option) any later version.
 *
 *  RetroArch is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY;
 *  without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 *  PURPOSE.  See the GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along with RetroArch.
 *  If not, see <http://www.gnu.org/licenses/>.
 */

#include <xtl.h>
#include <xgraphics.h>
#include <retro_miscellaneous.h>
#include "../screenshot.h"

bool screenshot_dump(const char *folder, const void *frame,
      unsigned width, unsigned height, int pitch, bool bgr24)
{
   (void)folder;
   (void)frame;
   (void)width;
   (void)height;
   (void)pitch;
   (void)bgr24;

   d3d_video_t *d3d = (d3d_video_t*)driver.video_data;
   HRESULT ret = S_OK;
   char filename[PATH_MAX_LENGTH];
   char shotname[PATH_MAX_LENGTH];

   fill_dated_filename(shotname, "bmp", sizeof(shotname));
   snprintf(filename, sizeof(filename), "%s\\%s", g_settings.screenshot_directory, shotname);
   
   D3DSurface *surf = NULL;
   d3d->dev->GetBackBuffer(-1, D3DBACKBUFFER_TYPE_MONO, &surf);
   ret = XGWriteSurfaceToFile(surf, filename);
   surf->Release();

   if(ret == S_OK)
   {
      RARCH_LOG("Screenshot saved: %s.\n", filename);
      msg_queue_push(g_extern.msg_queue, "Screenshot saved.", 1, 30);
      return true;
   }

   return false;
}
