/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.app.PendingIntent;
import android.content.ComponentName;
import android.content.Context;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GooglePlayServicesClient;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.internal.df;
import com.google.android.gms.internal.di;
import com.google.android.gms.internal.dj;
import com.google.android.gms.internal.dm;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class de<T extends IInterface>
implements GooglePlayServicesClient {
    private final Context mContext;
    final Handler mHandler;
    private T kD;
    private ArrayList<GooglePlayServicesClient.ConnectionCallbacks> kE;
    final ArrayList<GooglePlayServicesClient.ConnectionCallbacks> kF = new ArrayList();
    private boolean kG = false;
    private ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> kH;
    private boolean kI = false;
    private final ArrayList<b<?>> kJ = new ArrayList();
    private e kK;
    private final String[] is;
    boolean kL = false;
    boolean kM = false;
    private final Object kN = new Object();
    public static final String[] kO = new String[]{"service_esmobile", "service_googleme"};

    protected de(Context context, GooglePlayServicesClient.ConnectionCallbacks connectionCallbacks, GooglePlayServicesClient.OnConnectionFailedListener onConnectionFailedListener, String ... stringArray) {
        this.mContext = dm.e(context);
        this.kE = new ArrayList();
        this.kE.add(dm.e(connectionCallbacks));
        this.kH = new ArrayList();
        this.kH.add(dm.e(onConnectionFailedListener));
        this.mHandler = new a(context.getMainLooper());
        this.a(stringArray);
        this.is = stringArray;
    }

    protected void a(String ... stringArray) {
    }

    protected abstract String ag();

    protected abstract String ah();

    protected abstract T p(IBinder var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() {
        this.kL = true;
        Object object = this.kN;
        synchronized (object) {
            this.kM = true;
        }
        int n2 = GooglePlayServicesUtil.isGooglePlayServicesAvailable(this.mContext);
        if (n2 != 0) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)n2));
            return;
        }
        if (this.kK != null) {
            Log.e((String)"GmsClient", (String)"Calling connect() while still connected, missing disconnect().");
            this.kD = null;
            df.s(this.mContext).b(this.ag(), this.kK);
        }
        this.kK = new e();
        boolean bl2 = df.s(this.mContext).a(this.ag(), this.kK);
        if (!bl2) {
            Log.e((String)"GmsClient", (String)("unable to connect to service: " + this.ag()));
            this.mHandler.sendMessage(this.mHandler.obtainMessage(3, (Object)9));
            return;
        }
    }

    @Override
    public boolean isConnected() {
        return this.kD != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnecting() {
        Object object = this.kN;
        synchronized (object) {
            return this.kM;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() {
        this.kL = false;
        ArrayList<b<?>> arrayList = this.kN;
        synchronized (arrayList) {
            this.kM = false;
        }
        arrayList = this.kJ;
        synchronized (arrayList) {
            int n2 = this.kJ.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.kJ.get(i2).bf();
            }
            this.kJ.clear();
        }
        this.kD = null;
        if (this.kK != null) {
            df.s(this.mContext).b(this.ag(), this.kK);
            this.kK = null;
        }
    }

    public final Context getContext() {
        return this.mContext;
    }

    public final String[] aY() {
        return this.is;
    }

    protected final void u(IBinder iBinder) {
        try {
            dj dj2 = dj.a.w(iBinder);
            this.a(dj2, new d(this));
        }
        catch (RemoteException remoteException) {
            Log.w((String)"GmsClient", (String)"service died");
        }
    }

    protected abstract void a(dj var1, d var2) throws RemoteException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void aZ() {
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.kE;
        synchronized (arrayList) {
            dm.k(!this.kG);
            this.mHandler.removeMessages(4);
            this.kG = true;
            dm.k(this.kF.size() == 0);
            Bundle bundle = this.ba();
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.kE;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.kL && this.isConnected(); ++i2) {
                int n3 = this.kF.size();
                if (this.kF.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnected(bundle);
            }
            this.kF.clear();
            this.kG = false;
        }
    }

    protected Bundle ba() {
        return null;
    }

    protected void a(int n2, IBinder iBinder, Bundle bundle) {
        this.mHandler.sendMessage(this.mHandler.obtainMessage(1, (Object)new f(n2, iBinder, bundle)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void bb() {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.kE;
        synchronized (arrayList) {
            this.kG = true;
            ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList2 = this.kE;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2 && this.kL; ++i2) {
                if (!this.kE.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onDisconnected();
            }
            this.kG = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void a(ConnectionResult connectionResult) {
        this.mHandler.removeMessages(4);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.kH;
        synchronized (arrayList) {
            this.kI = true;
            ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList2 = this.kH;
            int n2 = arrayList2.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                if (!this.kL) {
                    return;
                }
                if (!this.kH.contains(arrayList2.get(i2))) continue;
                arrayList2.get(i2).onConnectionFailed(connectionResult);
            }
            this.kI = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        dm.e(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.kE;
        synchronized (arrayList) {
            if (this.kE.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionCallbacks(): listener " + listener + " is already registered"));
            } else {
                if (this.kG) {
                    this.kE = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.kE);
                }
                this.kE.add(listener);
            }
        }
        if (this.isConnected()) {
            this.mHandler.sendMessage(this.mHandler.obtainMessage(4, (Object)listener));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionCallbacksRegistered(GooglePlayServicesClient.ConnectionCallbacks listener) {
        dm.e(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.kE;
        synchronized (arrayList) {
            return this.kE.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionCallbacks(GooglePlayServicesClient.ConnectionCallbacks listener) {
        dm.e(listener);
        ArrayList<GooglePlayServicesClient.ConnectionCallbacks> arrayList = this.kE;
        synchronized (arrayList) {
            if (this.kE != null) {
                boolean bl2;
                if (this.kG) {
                    this.kE = new ArrayList<GooglePlayServicesClient.ConnectionCallbacks>(this.kE);
                }
                if (!(bl2 = this.kE.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionCallbacks(): listener " + listener + " not found"));
                } else if (this.kG && !this.kF.contains(listener)) {
                    this.kF.add(listener);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        dm.e(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.kH;
        synchronized (arrayList) {
            if (this.kH.contains(listener)) {
                Log.w((String)"GmsClient", (String)("registerConnectionFailedListener(): listener " + listener + " is already registered"));
            } else {
                if (this.kI) {
                    this.kH = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.kH);
                }
                this.kH.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isConnectionFailedListenerRegistered(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        dm.e(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.kH;
        synchronized (arrayList) {
            return this.kH.contains(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterConnectionFailedListener(GooglePlayServicesClient.OnConnectionFailedListener listener) {
        dm.e(listener);
        ArrayList<GooglePlayServicesClient.OnConnectionFailedListener> arrayList = this.kH;
        synchronized (arrayList) {
            if (this.kH != null) {
                boolean bl2;
                if (this.kI) {
                    this.kH = new ArrayList<GooglePlayServicesClient.OnConnectionFailedListener>(this.kH);
                }
                if (!(bl2 = this.kH.remove(listener))) {
                    Log.w((String)"GmsClient", (String)("unregisterConnectionFailedListener(): listener " + listener + " not found"));
                }
            }
        }
    }

    protected final void bc() {
        if (!this.isConnected()) {
            throw new IllegalStateException("Not connected. Call connect() and wait for onConnected() to be called.");
        }
    }

    protected final T bd() {
        this.bc();
        return this.kD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void a(b<?> b2) {
        ArrayList<b<?>> arrayList = this.kJ;
        synchronized (arrayList) {
            this.kJ.add(b2);
        }
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2, b2));
    }

    public static final class d
    extends di.a {
        private de kR;

        public d(de de2) {
            this.kR = de2;
        }

        public void b(int n2, IBinder iBinder, Bundle bundle) {
            dm.a("onPostInitComplete can be called only once per call to getServiceFromBroker", (Object)this.kR);
            this.kR.a(n2, iBinder, bundle);
            this.kR = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected final class f
    extends b<Boolean> {
        public final int statusCode;
        public final Bundle kS;
        public final IBinder kT;

        public f(int n2, IBinder iBinder, Bundle bundle) {
            super(true);
            this.statusCode = n2;
            this.kT = iBinder;
            this.kS = bundle;
        }

        @Override
        protected void a(Boolean bl2) {
            if (bl2 == null) {
                return;
            }
            switch (this.statusCode) {
                case 0: {
                    String string2 = null;
                    try {
                        string2 = this.kT.getInterfaceDescriptor();
                        if (de.this.ah().equals(string2)) {
                            de.this.kD = de.this.p(this.kT);
                            if (de.this.kD != null) {
                                de.this.aZ();
                                return;
                            }
                        }
                    }
                    catch (RemoteException remoteException) {
                        // empty catch block
                    }
                    df.s(de.this.mContext).b(de.this.ag(), de.this.kK);
                    de.this.kK = null;
                    de.this.kD = null;
                    de.this.a(new ConnectionResult(8, null));
                    break;
                }
                case 10: {
                    throw new IllegalStateException("A fatal developer error has occurred. Check the logs for further information.");
                }
                default: {
                    PendingIntent pendingIntent = null;
                    if (this.kS != null) {
                        pendingIntent = (PendingIntent)this.kS.getParcelable("pendingIntent");
                    }
                    if (de.this.kK != null) {
                        df.s(de.this.mContext).b(de.this.ag(), de.this.kK);
                        de.this.kK = null;
                    }
                    de.this.kD = null;
                    de.this.a(new ConnectionResult(this.statusCode, pendingIntent));
                }
            }
        }

        @Override
        protected void aF() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class c<TListener>
    extends b<TListener> {
        private final com.google.android.gms.common.data.d jf;

        public c(TListener TListener, com.google.android.gms.common.data.d d2) {
            super(TListener);
            this.jf = d2;
        }

        @Override
        protected final void a(TListener TListener) {
            this.a(TListener, this.jf);
        }

        protected abstract void a(TListener var1, com.google.android.gms.common.data.d var2);

        @Override
        protected void aF() {
            if (this.jf != null) {
                this.jf.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected abstract class b<TListener> {
        private TListener mListener;
        private boolean kQ;

        public b(TListener TListener) {
            this.mListener = TListener;
            this.kQ = false;
        }

        protected abstract void a(TListener var1);

        protected abstract void aF();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void be() {
            TListener TListener;
            b b2 = this;
            synchronized (b2) {
                TListener = this.mListener;
                if (this.kQ) {
                    Log.w((String)"GmsClient", (String)("Callback proxy " + this + " being reused. This is not safe."));
                }
            }
            if (TListener != null) {
                try {
                    this.a(TListener);
                }
                catch (RuntimeException runtimeException) {
                    this.aF();
                    throw runtimeException;
                }
            } else {
                this.aF();
            }
            b2 = this;
            synchronized (b2) {
                this.kQ = true;
            }
            this.unregister();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregister() {
            this.bf();
            ArrayList arrayList = de.this.kJ;
            synchronized (arrayList) {
                de.this.kJ.remove(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void bf() {
            b b2 = this;
            synchronized (b2) {
                this.mListener = null;
            }
        }
    }

    final class a
    extends Handler {
        public a(Looper looper) {
            super(looper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            if (msg.what == 1 && !de.this.isConnecting()) {
                b b2 = (b)msg.obj;
                b2.aF();
                b2.unregister();
                return;
            }
            Object object = de.this.kN;
            synchronized (object) {
                de.this.kM = false;
            }
            if (msg.what == 3) {
                de.this.a(new ConnectionResult((Integer)msg.obj, null));
                return;
            }
            if (msg.what == 4) {
                object = de.this.kE;
                synchronized (object) {
                    if (de.this.kL && de.this.isConnected() && de.this.kE.contains(msg.obj)) {
                        ((GooglePlayServicesClient.ConnectionCallbacks)msg.obj).onConnected(de.this.ba());
                    }
                }
                return;
            }
            if (msg.what == 2 && !de.this.isConnected()) {
                object = (b)msg.obj;
                ((b)object).aF();
                ((b)object).unregister();
                return;
            }
            if (msg.what == 2 || msg.what == 1) {
                object = (b)msg.obj;
                ((b)object).be();
                return;
            }
            Log.wtf((String)"GmsClient", (String)"Don't know how to handle this message.");
        }
    }

    final class e
    implements ServiceConnection {
        e() {
        }

        public void onServiceConnected(ComponentName component, IBinder binder) {
            de.this.u(binder);
        }

        public void onServiceDisconnected(ComponentName component) {
            de.this.kD = null;
            de.this.bb();
        }
    }
}

