/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import sun.nio.cs.Surrogate;

class UTF_32Coder {
    protected static final int BOM_BIG = 65279;
    protected static final int BOM_LITTLE = -131072;
    protected static final int NONE = 0;
    protected static final int BIG = 1;
    protected static final int LITTLE = 2;

    UTF_32Coder() {
    }

    protected static class Encoder
    extends CharsetEncoder {
        private boolean doBOM;
        private boolean doneBOM;
        private int byteOrder;

        protected void put(int n, ByteBuffer byteBuffer) {
            if (this.byteOrder == 1) {
                byteBuffer.put((byte)(n >> 24));
                byteBuffer.put((byte)(n >> 16));
                byteBuffer.put((byte)(n >> 8));
                byteBuffer.put((byte)n);
            } else {
                byteBuffer.put((byte)n);
                byteBuffer.put((byte)(n >> 8));
                byteBuffer.put((byte)(n >> 16));
                byteBuffer.put((byte)(n >> 24));
            }
        }

        protected Encoder(Charset charset, int n, boolean bl) {
            byte[] byArray;
            float f = bl ? 8.0f : 4.0f;
            if (n == 1) {
                byte[] byArray2 = new byte[4];
                byArray2[0] = 0;
                byArray2[1] = 0;
                byArray2[2] = -1;
                byArray = byArray2;
                byArray2[3] = -3;
            } else {
                byte[] byArray3 = new byte[4];
                byArray3[0] = -3;
                byArray3[1] = -1;
                byArray3[2] = 0;
                byArray = byArray3;
                byArray3[3] = 0;
            }
            super(charset, 4.0f, f, byArray);
            this.doBOM = false;
            this.doneBOM = true;
            this.byteOrder = n;
            this.doBOM = bl;
            this.doneBOM = !bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult encodeLoop(CharBuffer charBuffer, ByteBuffer byteBuffer) {
            int n = charBuffer.position();
            if (!this.doneBOM) {
                if (byteBuffer.remaining() < 4) {
                    return CoderResult.OVERFLOW;
                }
                this.put(65279, byteBuffer);
                this.doneBOM = true;
            }
            try {
                while (charBuffer.hasRemaining()) {
                    char c = charBuffer.get();
                    if (Surrogate.isHigh(c)) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.UNDERFLOW;
                            return coderResult;
                        }
                        char c2 = charBuffer.get();
                        if (Surrogate.isLow(c2)) {
                            if (byteBuffer.remaining() < 4) {
                                CoderResult coderResult = CoderResult.OVERFLOW;
                                return coderResult;
                            }
                            n += 2;
                        } else {
                            CoderResult coderResult = CoderResult.malformedForLength(1);
                            return coderResult;
                        }
                        this.put(Surrogate.toUCS4(c, c2), byteBuffer);
                        continue;
                    }
                    if (Surrogate.isLow(c)) {
                        CoderResult coderResult = CoderResult.malformedForLength(1);
                        return coderResult;
                    }
                    if (byteBuffer.remaining() < 4) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    ++n;
                    this.put(c, byteBuffer);
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                charBuffer.position(n);
            }
        }

        protected void implReset() {
            this.doneBOM = !this.doBOM;
        }
    }

    protected static class Decoder
    extends CharsetDecoder {
        private int currentBO;
        private int expectedBO;

        protected Decoder(Charset charset, int n) {
            super(charset, 0.25f, 1.0f);
            this.expectedBO = n;
            this.currentBO = 0;
        }

        private int getCP(ByteBuffer byteBuffer) {
            return this.currentBO == 1 ? (byteBuffer.get() & 0xFF) << 24 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF : byteBuffer.get() & 0xFF | (byteBuffer.get() & 0xFF) << 8 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 24;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CoderResult decodeLoop(ByteBuffer byteBuffer, CharBuffer charBuffer) {
            if (byteBuffer.remaining() < 4) {
                return CoderResult.UNDERFLOW;
            }
            int n = byteBuffer.position();
            try {
                int n2;
                if (this.currentBO == 0) {
                    n2 = (byteBuffer.get() & 0xFF) << 24 | (byteBuffer.get() & 0xFF) << 16 | (byteBuffer.get() & 0xFF) << 8 | byteBuffer.get() & 0xFF;
                    if (n2 == 65279 && this.expectedBO != 2) {
                        this.currentBO = 1;
                        n += 4;
                    } else if (n2 == -131072 && this.expectedBO != 1) {
                        this.currentBO = 2;
                        n += 4;
                    } else {
                        this.currentBO = this.expectedBO == 0 ? 1 : this.expectedBO;
                        byteBuffer.position(n);
                    }
                }
                while (byteBuffer.remaining() > 3) {
                    n2 = this.getCP(byteBuffer);
                    if (n2 < 0 || n2 > 0x10FFFF) {
                        CoderResult coderResult = CoderResult.malformedForLength(4);
                        return coderResult;
                    }
                    if (n2 < 65536) {
                        if (!charBuffer.hasRemaining()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        n += 4;
                        charBuffer.put((char)n2);
                        continue;
                    }
                    if (charBuffer.remaining() < 2) {
                        CoderResult coderResult = CoderResult.OVERFLOW;
                        return coderResult;
                    }
                    n += 4;
                    charBuffer.put(Surrogate.high(n2));
                    charBuffer.put(Surrogate.low(n2));
                }
                CoderResult coderResult = CoderResult.UNDERFLOW;
                return coderResult;
            }
            finally {
                byteBuffer.position(n);
            }
        }

        protected void implReset() {
            this.currentBO = 0;
        }
    }
}

