/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;

public class ChannelInputStream
extends InputStream {
    protected final ReadableByteChannel ch;
    private ByteBuffer bb = null;
    private byte[] bs = null;
    private byte[] b1 = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int read(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer, boolean bl) throws IOException {
        if (readableByteChannel instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)((Object)readableByteChannel);
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                boolean bl2 = selectableChannel.isBlocking();
                if (!bl2) {
                    throw new IllegalBlockingModeException();
                }
                if (bl2 != bl) {
                    selectableChannel.configureBlocking(bl);
                }
                int n = readableByteChannel.read(byteBuffer);
                if (bl2 != bl) {
                    selectableChannel.configureBlocking(bl2);
                }
                return n;
            }
        }
        return readableByteChannel.read(byteBuffer);
    }

    public ChannelInputStream(ReadableByteChannel readableByteChannel) {
        this.ch = readableByteChannel;
    }

    public synchronized int read() throws IOException {
        int n;
        if (this.b1 == null) {
            this.b1 = new byte[1];
        }
        if ((n = this.read(this.b1)) == 1) {
            return this.b1[0] & 0xFF;
        }
        return -1;
    }

    public synchronized int read(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n > byArray.length || n2 < 0 || n + n2 > byArray.length || n + n2 < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 == 0) {
            return 0;
        }
        ByteBuffer byteBuffer = this.bs == byArray ? this.bb : ByteBuffer.wrap(byArray);
        byteBuffer.limit(Math.min(n + n2, byteBuffer.capacity()));
        byteBuffer.position(n);
        this.bb = byteBuffer;
        this.bs = byArray;
        return this.read(byteBuffer);
    }

    protected int read(ByteBuffer byteBuffer) throws IOException {
        return ChannelInputStream.read(this.ch, byteBuffer, true);
    }

    public void close() throws IOException {
        this.ch.close();
    }
}

