/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BandedSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferUShort;
import java.awt.image.Raster;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import sun.awt.image.SunWritableRaster;

public class ShortBandedRaster
extends SunWritableRaster {
    int[] dataOffsets;
    int scanlineStride;
    short[][] data;
    private int maxX;
    private int maxY;

    public ShortBandedRaster(SampleModel sampleModel, Point point) {
        this(sampleModel, sampleModel.createDataBuffer(), new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ShortBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Point point) {
        this(sampleModel, dataBuffer, new Rectangle(point.x, point.y, sampleModel.getWidth(), sampleModel.getHeight()), point, null);
    }

    public ShortBandedRaster(SampleModel sampleModel, DataBuffer dataBuffer, Rectangle rectangle, Point point, ShortBandedRaster shortBandedRaster) {
        super(sampleModel, dataBuffer, rectangle, point, shortBandedRaster);
        this.maxX = this.minX + this.width;
        this.maxY = this.minY + this.height;
        if (!(dataBuffer instanceof DataBufferUShort)) {
            throw new RasterFormatException("ShortBandedRaster must have ushort DataBuffers");
        }
        DataBufferUShort dataBufferUShort = (DataBufferUShort)dataBuffer;
        if (sampleModel instanceof BandedSampleModel) {
            BandedSampleModel bandedSampleModel = (BandedSampleModel)sampleModel;
            this.scanlineStride = bandedSampleModel.getScanlineStride();
            int[] nArray = bandedSampleModel.getBankIndices();
            int[] nArray2 = bandedSampleModel.getBandOffsets();
            int[] nArray3 = dataBufferUShort.getOffsets();
            this.dataOffsets = new int[nArray.length];
            this.data = new short[nArray.length][];
            int n = rectangle.x - point.x;
            int n2 = rectangle.y - point.y;
            for (int i = 0; i < nArray.length; ++i) {
                this.data[i] = ShortBandedRaster.stealData(dataBufferUShort, nArray[i]);
                this.dataOffsets[i] = nArray3[nArray[i]] + n + n2 * this.scanlineStride + nArray2[i];
            }
        } else {
            throw new RasterFormatException("ShortBandedRasters must have BandedSampleModels");
        }
        this.verify(false);
    }

    public int[] getDataOffsets() {
        return (int[])this.dataOffsets.clone();
    }

    public int getDataOffset(int n) {
        return this.dataOffsets[n];
    }

    public int getScanlineStride() {
        return this.scanlineStride;
    }

    public int getPixelStride() {
        return 1;
    }

    public short[][] getDataStorage() {
        return this.data;
    }

    public short[] getDataStorage(int n) {
        return this.data[n];
    }

    public Object getDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = object == null ? new short[this.numDataElements] : (short[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            sArray[i] = this.data[i][this.dataOffsets[i] + n3];
        }
        return sArray;
    }

    public Object getDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = object == null ? new short[this.numDataElements * n3 * n4] : (short[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            int n6 = i;
            short[] sArray2 = this.data[i];
            int n7 = this.dataOffsets[i];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n7 + n8;
                for (int j = 0; j < n3; ++j) {
                    sArray[n6] = sArray2[n10++];
                    n6 += this.numDataElements;
                }
                ++n9;
                n8 += this.scanlineStride;
            }
        }
        return sArray;
    }

    public short[] getShortData(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (sArray == null) {
            sArray = new short[this.scanlineStride * n4];
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[n5];
        if (this.scanlineStride == n3) {
            System.arraycopy(this.data[n5], n6, sArray, 0, n3 * n4);
        } else {
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                System.arraycopy(this.data[n5], n6, sArray, n7, n3);
                n7 += n3;
                ++n8;
                n6 += this.scanlineStride;
            }
        }
        return sArray;
    }

    public short[] getShortData(int n, int n2, int n3, int n4, short[] sArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        if (sArray == null) {
            sArray = new short[this.numDataElements * this.scanlineStride * n4];
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            int n6 = i;
            short[] sArray2 = this.data[i];
            int n7 = this.dataOffsets[i];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n7 + n8;
                for (int j = 0; j < n3; ++j) {
                    sArray[n6] = sArray2[n10++];
                    n6 += this.numDataElements;
                }
                ++n9;
                n8 += this.scanlineStride;
            }
        }
        return sArray;
    }

    public void setDataElements(int n, int n2, Object object) {
        if (n < this.minX || n2 < this.minY || n >= this.maxX || n2 >= this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = (short[])object;
        int n3 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            this.data[i][this.dataOffsets[i] + n3] = sArray[i];
        }
        this.markDirty();
    }

    public void setDataElements(int n, int n2, Raster raster) {
        int n3 = n + raster.getMinX();
        int n4 = n2 + raster.getMinY();
        int n5 = raster.getWidth();
        int n6 = raster.getHeight();
        if (n3 < this.minX || n4 < this.minY || n3 + n5 > this.maxX || n4 + n6 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        this.setDataElements(n3, n4, n5, n6, raster);
    }

    private void setDataElements(int n, int n2, int n3, int n4, Raster raster) {
        if (n3 <= 0 || n4 <= 0) {
            return;
        }
        int n5 = raster.getMinX();
        int n6 = raster.getMinY();
        Object object = null;
        for (int i = 0; i < n4; ++i) {
            object = raster.getDataElements(n5, n6 + i, n3, 1, object);
            this.setDataElements(n, n2 + i, n3, 1, object);
        }
    }

    public void setDataElements(int n, int n2, int n3, int n4, Object object) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        short[] sArray = (short[])object;
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            int n6 = i;
            short[] sArray2 = this.data[i];
            int n7 = this.dataOffsets[i];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n7 + n8;
                for (int j = 0; j < n3; ++j) {
                    sArray2[n10++] = sArray[n6];
                    n6 += this.numDataElements;
                }
                ++n9;
                n8 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    public void putShortData(int n, int n2, int n3, int n4, int n5, short[] sArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n6 = (n2 - this.minY) * this.scanlineStride + (n - this.minX) + this.dataOffsets[n5];
        int n7 = 0;
        if (this.scanlineStride == n3) {
            System.arraycopy(sArray, 0, this.data[n5], n6, n3 * n4);
        } else {
            int n8 = 0;
            while (n8 < n4) {
                System.arraycopy(sArray, n7, this.data[n5], n6, n3);
                n7 += n3;
                ++n8;
                n6 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    public void putShortData(int n, int n2, int n3, int n4, short[] sArray) {
        if (n < this.minX || n2 < this.minY || n + n3 > this.maxX || n2 + n4 > this.maxY) {
            throw new ArrayIndexOutOfBoundsException("Coordinate out of bounds!");
        }
        int n5 = (n2 - this.minY) * this.scanlineStride + (n - this.minX);
        for (int i = 0; i < this.numDataElements; ++i) {
            int n6 = i;
            short[] sArray2 = this.data[i];
            int n7 = this.dataOffsets[i];
            int n8 = n5;
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n7 + n8;
                for (int j = 0; j < n3; ++j) {
                    sArray2[n10++] = sArray[n6];
                    n6 += this.numDataElements;
                }
                ++n9;
                n8 += this.scanlineStride;
            }
        }
        this.markDirty();
    }

    public WritableRaster createWritableChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        if (n < this.minX) {
            throw new RasterFormatException("x lies outside raster");
        }
        if (n2 < this.minY) {
            throw new RasterFormatException("y lies outside raster");
        }
        if (n + n3 < n || n + n3 > this.minX + this.width) {
            throw new RasterFormatException("(x + width) is outside of Raster");
        }
        if (n2 + n4 < n2 || n2 + n4 > this.minY + this.height) {
            throw new RasterFormatException("(y + height) is outside of Raster");
        }
        SampleModel sampleModel = nArray != null ? this.sampleModel.createSubsetSampleModel(nArray) : this.sampleModel;
        int n7 = n5 - n;
        int n8 = n6 - n2;
        return new ShortBandedRaster(sampleModel, this.dataBuffer, new Rectangle(n5, n6, n3, n4), new Point(this.sampleModelTranslateX + n7, this.sampleModelTranslateY + n8), this);
    }

    public Raster createChild(int n, int n2, int n3, int n4, int n5, int n6, int[] nArray) {
        return this.createWritableChild(n, n2, n3, n4, n5, n6, nArray);
    }

    public WritableRaster createCompatibleWritableRaster(int n, int n2) {
        if (n <= 0 || n2 <= 0) {
            throw new RasterFormatException("negative " + (n <= 0 ? "width" : "height"));
        }
        SampleModel sampleModel = this.sampleModel.createCompatibleSampleModel(n, n2);
        return new ShortBandedRaster(sampleModel, new Point(0, 0));
    }

    public WritableRaster createCompatibleWritableRaster() {
        return this.createCompatibleWritableRaster(this.width, this.height);
    }

    private void verify(boolean bl) {
        int n;
        int n2;
        for (n2 = 0; n2 < this.dataOffsets.length; ++n2) {
            if (this.dataOffsets[n2] >= 0) continue;
            throw new RasterFormatException("Data offsets for band " + n2 + "(" + this.dataOffsets[n2] + ") must be >= 0");
        }
        n2 = 0;
        for (n = 0; n < this.numDataElements; ++n) {
            int n3 = (this.height - 1) * this.scanlineStride + (this.width - 1) + this.dataOffsets[n];
            if (n3 <= n2) continue;
            n2 = n3;
        }
        for (n = 0; n < this.numDataElements; ++n) {
            if (this.data[n].length >= n2) continue;
            throw new RasterFormatException("Data array too small (should be " + n2 + " )");
        }
    }

    public String toString() {
        return new String("ShortBandedRaster: width = " + this.width + " height = " + this.height + " #numBands " + this.numBands + " #dataElements " + this.numDataElements);
    }
}

