/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.AWTError;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.beans.ConstructorProperties;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.BoxLayout;
import javax.swing.JComponent;

public class Box
extends JComponent
implements Accessible {
    public Box(int n) {
        super.setLayout(new BoxLayout(this, n));
    }

    public static Box createHorizontalBox() {
        return new Box(0);
    }

    public static Box createVerticalBox() {
        return new Box(1);
    }

    public static Component createRigidArea(Dimension dimension) {
        return new Filler(dimension, dimension, dimension);
    }

    public static Component createHorizontalStrut(int n) {
        return new Filler(new Dimension(n, 0), new Dimension(n, 0), new Dimension(n, Short.MAX_VALUE));
    }

    public static Component createVerticalStrut(int n) {
        return new Filler(new Dimension(0, n), new Dimension(0, n), new Dimension(Short.MAX_VALUE, n));
    }

    public static Component createGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
    }

    public static Component createHorizontalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(Short.MAX_VALUE, 0));
    }

    public static Component createVerticalGlue() {
        return new Filler(new Dimension(0, 0), new Dimension(0, 0), new Dimension(0, Short.MAX_VALUE));
    }

    public void setLayout(LayoutManager layoutManager) {
        throw new AWTError("Illegal request");
    }

    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            super.paintComponent(graphics);
        } else if (this.isOpaque()) {
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleBox();
        }
        return this.accessibleContext;
    }

    protected class AccessibleBox
    extends Container.AccessibleAWTContainer {
        protected AccessibleBox() {
            super(Box.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.FILLER;
        }
    }

    public static class Filler
    extends JComponent
    implements Accessible {
        @ConstructorProperties(value={"minimumSize", "preferredSize", "maximumSize"})
        public Filler(Dimension dimension, Dimension dimension2, Dimension dimension3) {
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension2);
            this.setMaximumSize(dimension3);
        }

        public void changeShape(Dimension dimension, Dimension dimension2, Dimension dimension3) {
            this.setMinimumSize(dimension);
            this.setPreferredSize(dimension2);
            this.setMaximumSize(dimension3);
            this.revalidate();
        }

        protected void paintComponent(Graphics graphics) {
            if (this.ui != null) {
                super.paintComponent(graphics);
            } else if (this.isOpaque()) {
                graphics.setColor(this.getBackground());
                graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            }
        }

        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleBoxFiller();
            }
            return this.accessibleContext;
        }

        protected class AccessibleBoxFiller
        extends Component.AccessibleAWTComponent {
            protected AccessibleBoxFiller() {
                super(Filler.this);
            }

            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.FILLER;
            }
        }
    }
}

