/*
 * Decompiled with CFR 0.152.
 */
package javax.security.auth.kerberos;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.security.auth.kerberos.DelegationPermission;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class KrbDelegationPermissionCollection
extends PermissionCollection
implements Serializable {
    private transient List<Permission> perms = new ArrayList<Permission>();
    private static final long serialVersionUID = -3383936936589966948L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Vector.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(Permission permission) {
        if (!(permission instanceof DelegationPermission)) {
            return false;
        }
        KrbDelegationPermissionCollection krbDelegationPermissionCollection = this;
        synchronized (krbDelegationPermissionCollection) {
            for (Permission permission2 : this.perms) {
                if (!permission2.implies(permission)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Permission permission) {
        if (!(permission instanceof DelegationPermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        KrbDelegationPermissionCollection krbDelegationPermissionCollection = this;
        synchronized (krbDelegationPermissionCollection) {
            this.perms.add(0, permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Enumeration<Permission> elements() {
        KrbDelegationPermissionCollection krbDelegationPermissionCollection = this;
        synchronized (krbDelegationPermissionCollection) {
            return Collections.enumeration(this.perms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector<Permission> vector = new Vector<Permission>(this.perms.size());
        Object object = this;
        synchronized (object) {
            vector.addAll(this.perms);
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("permissions", vector);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Vector vector = (Vector)getField.get("permissions", null);
        this.perms = new ArrayList<Permission>(vector.size());
        this.perms.addAll(vector);
    }
}

