/*
 * Decompiled with CFR 0.152.
 */
package javax.management;

import com.sun.jmx.mbeanserver.Introspector;
import com.sun.jmx.mbeanserver.MBeanInjector;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.TreeMap;
import javax.management.DynamicWrapperMBean;
import javax.management.MBeanServerConnection;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerInvocationHandler;
import javax.management.MXBean;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.ObjectName;
import javax.management.namespace.JMXNamespaces;
import javax.management.openmbean.MXBeanMappingFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMX {
    static final JMX proof = new JMX();
    public static final String DEFAULT_VALUE_FIELD = "defaultValue";
    public static final String DESCRIPTION_RESOURCE_BUNDLE_BASE_NAME_FIELD = "descriptionResourceBundleBaseName";
    public static final String DESCRIPTION_RESOURCE_KEY_FIELD = "descriptionResourceKey";
    public static final String EXCEPTIONS_FIELD = "exceptions";
    public static final String IMMUTABLE_INFO_FIELD = "immutableInfo";
    public static final String INTERFACE_CLASS_NAME_FIELD = "interfaceClassName";
    public static final String LEGAL_VALUES_FIELD = "legalValues";
    public static final String LOCALE_FIELD = "locale";
    public static final String MAX_VALUE_FIELD = "maxValue";
    public static final String MIN_VALUE_FIELD = "minValue";
    public static final String MXBEAN_FIELD = "mxbean";
    public static final String MXBEAN_MAPPING_FACTORY_CLASS_FIELD = "mxbeanMappingFactoryClass";
    public static final String OPEN_TYPE_FIELD = "openType";
    public static final String ORIGINAL_TYPE_FIELD = "originalType";
    public static final String SET_EXCEPTIONS_FIELD = "setExceptions";
    public static final String OBJECT_NAME_TEMPLATE = "objectNameTemplate";

    private JMX() {
    }

    public static <T> T newMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz) {
        return JMX.newMBeanProxy(mBeanServerConnection, objectName, clazz, false);
    }

    public static <T> T newMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, boolean bl) {
        ProxyOptions proxyOptions = new ProxyOptions();
        proxyOptions.setNotificationEmitter(bl);
        return JMX.newMBeanProxy(mBeanServerConnection, objectName, clazz, proxyOptions);
    }

    public static <T> T newMXBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz) {
        return JMX.newMXBeanProxy(mBeanServerConnection, objectName, clazz, false);
    }

    public static <T> T newMXBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, boolean bl) {
        ProxyOptions proxyOptions = new ProxyOptions();
        MXBeanMappingFactory mXBeanMappingFactory = MXBeanMappingFactory.forInterface(clazz);
        proxyOptions.setMXBeanMappingFactory(mXBeanMappingFactory);
        proxyOptions.setNotificationEmitter(bl);
        return JMX.newMBeanProxy(mBeanServerConnection, objectName, clazz, proxyOptions);
    }

    public static <T> T newMBeanProxy(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, MBeanOptions mBeanOptions) {
        try {
            return JMX.newMBeanProxy2(mBeanServerConnection, objectName, clazz, mBeanOptions);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            throw new IllegalArgumentException(notCompliantMBeanException);
        }
    }

    private static <T> T newMBeanProxy2(MBeanServerConnection mBeanServerConnection, ObjectName objectName, Class<T> clazz, MBeanOptions mBeanOptions) throws NotCompliantMBeanException {
        if (mBeanOptions == null) {
            mBeanOptions = new MBeanOptions();
        }
        boolean bl = mBeanOptions instanceof ProxyOptions && ((ProxyOptions)mBeanOptions).isNotificationEmitter();
        MXBeanMappingFactory mXBeanMappingFactory = mBeanOptions.getMXBeanMappingFactory();
        if (mXBeanMappingFactory != null) {
            Introspector.testComplianceMXBeanInterface(clazz, mXBeanMappingFactory);
        }
        MBeanServerInvocationHandler mBeanServerInvocationHandler = new MBeanServerInvocationHandler(mBeanServerConnection, objectName, mBeanOptions);
        Class[] classArray = bl ? new Class[]{clazz, NotificationEmitter.class} : new Class[]{clazz};
        Object object = Proxy.newProxyInstance(clazz.getClassLoader(), classArray, mBeanServerInvocationHandler);
        return clazz.cast(object);
    }

    public static boolean isMXBeanInterface(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        MXBean mXBean = clazz.getAnnotation(MXBean.class);
        if (mXBean != null) {
            return mXBean.value();
        }
        return clazz.getName().endsWith("MXBean");
    }

    public static boolean isNotificationSource(Object object) throws NotCompliantMBeanException {
        for (int i = 0; i < 2; ++i) {
            if (object instanceof NotificationBroadcaster || MBeanInjector.injectsSendNotification(object)) {
                return true;
            }
            if (!(object instanceof DynamicWrapperMBean)) break;
            object = ((DynamicWrapperMBean)object).getWrappedObject();
        }
        return false;
    }

    public static String getSpecificationVersion(MBeanServerConnection mBeanServerConnection, ObjectName objectName) throws IOException {
        if (mBeanServerConnection == null) {
            throw new IllegalArgumentException("Null MBeanServerConnection");
        }
        String string = objectName == null ? "" : JMXNamespaces.getContainingNamespace(objectName);
        if (string.contains("*") || string.contains("?")) {
            throw new IllegalArgumentException("ObjectName contains namespace wildcard: " + objectName);
        }
        try {
            if (string.length() > 0) {
                mBeanServerConnection = JMXNamespaces.narrowToNamespace(mBeanServerConnection, string);
            }
            return (String)mBeanServerConnection.getAttribute(MBeanServerDelegate.DELEGATE_NAME, "SpecificationVersion");
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new IOException(exception);
        }
    }

    public static class ProxyOptions
    extends MBeanOptions {
        private static final long serialVersionUID = 7238804866098386559L;
        private boolean notificationEmitter;
        private static final ProxyOptions[] CANONICALS = new ProxyOptions[]{new ProxyOptions(), new ProxyOptions(), new ProxyOptions(), new ProxyOptions()};

        public ProxyOptions clone() {
            return (ProxyOptions)super.clone();
        }

        public boolean isNotificationEmitter() {
            return this.notificationEmitter;
        }

        public void setNotificationEmitter(boolean bl) {
            this.notificationEmitter = bl;
        }

        MBeanOptions[] canonicals() {
            return CANONICALS;
        }

        boolean same(MBeanOptions mBeanOptions) {
            return super.same(mBeanOptions) && mBeanOptions instanceof ProxyOptions && ((ProxyOptions)mBeanOptions).notificationEmitter == this.notificationEmitter;
        }

        static {
            CANONICALS[1].setMXBeanMappingFactory(MXBeanMappingFactory.DEFAULT);
            CANONICALS[2].setNotificationEmitter(true);
            CANONICALS[3].setMXBeanMappingFactory(MXBeanMappingFactory.DEFAULT);
            CANONICALS[3].setNotificationEmitter(true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MBeanOptions
    implements Serializable,
    Cloneable {
        private static final long serialVersionUID = -6380842449318177843L;
        static final MBeanOptions MXBEAN = new MBeanOptions();
        private MXBeanMappingFactory mappingFactory;
        private static final MBeanOptions[] CANONICALS;

        public MBeanOptions clone() {
            try {
                return (MBeanOptions)super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError((Object)cloneNotSupportedException);
            }
        }

        public boolean isMXBean() {
            return this.mappingFactory != null;
        }

        public MXBeanMappingFactory getMXBeanMappingFactory() {
            return this.mappingFactory;
        }

        public void setMXBeanMappingFactory(MXBeanMappingFactory mXBeanMappingFactory) {
            this.mappingFactory = mXBeanMappingFactory;
        }

        MBeanOptions[] canonicals() {
            return CANONICALS;
        }

        boolean same(MBeanOptions mBeanOptions) {
            return mBeanOptions.mappingFactory == this.mappingFactory;
        }

        final MBeanOptions canonical() {
            for (MBeanOptions mBeanOptions : this.canonicals()) {
                if (mBeanOptions.getClass() != this.getClass() || !this.same(mBeanOptions)) continue;
                return mBeanOptions;
            }
            return this;
        }

        final MBeanOptions uncanonical() {
            for (MBeanOptions mBeanOptions : this.canonicals()) {
                if (this != mBeanOptions) continue;
                return this.clone();
            }
            return this;
        }

        private Map<String, Object> toMap() {
            TreeMap<String, Object> treeMap = new TreeMap<String, Object>();
            try {
                PropertyDescriptor[] propertyDescriptorArray;
                BeanInfo beanInfo = java.beans.Introspector.getBeanInfo(this.getClass());
                for (PropertyDescriptor propertyDescriptor : propertyDescriptorArray = beanInfo.getPropertyDescriptors()) {
                    Method method;
                    String string = propertyDescriptor.getName();
                    if (string.equals("class") || (method = propertyDescriptor.getReadMethod()) == null) continue;
                    treeMap.put(string, method.invoke(this, new Object[0]));
                }
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (throwable instanceof InvocationTargetException) {
                    throwable = throwable.getCause();
                }
                treeMap.put("Exception", throwable);
            }
            return treeMap;
        }

        public String toString() {
            return this.getClass().getSimpleName() + this.toMap();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            return ((Object)this.toMap()).equals(((MBeanOptions)object).toMap());
        }

        public int hashCode() {
            return ((Object)this.toMap()).hashCode();
        }

        static {
            MXBEAN.setMXBeanMappingFactory(MXBeanMappingFactory.DEFAULT);
            CANONICALS = new MBeanOptions[]{new MBeanOptions(), MXBEAN};
        }
    }
}

