/*
 * Decompiled with CFR 0.152.
 */
package java.awt.font;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphJustificationInfo;
import java.awt.font.GraphicAttribute;
import java.awt.font.LineMetrics;
import java.awt.font.StyledParagraph;
import java.awt.font.TextAttribute;
import java.awt.font.TextJustifier;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.AttributedCharacterIterator;
import java.text.Bidi;
import java.util.Map;
import sun.font.AttributeValues;
import sun.font.BidiUtils;
import sun.font.CoreMetrics;
import sun.font.Decoration;
import sun.font.FontResolver;
import sun.font.GraphicComponent;
import sun.font.LayoutPathImpl;
import sun.font.TextLabelFactory;
import sun.font.TextLineComponent;
import sun.text.CodePointIterator;

final class TextLine {
    private TextLineComponent[] fComponents;
    private float[] fBaselineOffsets;
    private int[] fComponentVisualOrder;
    private float[] locs;
    private char[] fChars;
    private int fCharsStart;
    private int fCharsLimit;
    private int[] fCharVisualOrder;
    private int[] fCharLogicalOrder;
    private byte[] fCharLevels;
    private boolean fIsDirectionLTR;
    private LayoutPathImpl lp;
    private boolean isSimple;
    private Rectangle pixelBounds;
    private FontRenderContext frc;
    private TextLineMetrics fMetrics = null;
    private static Function fgPosAdvF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            TextLineComponent textLineComponent = textLine.fComponents[n];
            int n3 = textLine.getComponentVisualIndex(n);
            return textLine.locs[n3 * 2] + textLineComponent.getCharX(n2) + textLineComponent.getCharAdvance(n2);
        }
    };
    private static Function fgAdvanceF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            TextLineComponent textLineComponent = textLine.fComponents[n];
            return textLineComponent.getCharAdvance(n2);
        }
    };
    private static Function fgXPositionF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            int n3 = textLine.getComponentVisualIndex(n);
            TextLineComponent textLineComponent = textLine.fComponents[n];
            return textLine.locs[n3 * 2] + textLineComponent.getCharX(n2);
        }
    };
    private static Function fgYPositionF = new Function(){

        float computeFunction(TextLine textLine, int n, int n2) {
            TextLineComponent textLineComponent = textLine.fComponents[n];
            float f = textLineComponent.getCharY(n2);
            return f + textLine.getComponentShift(n);
        }
    };

    public TextLine(FontRenderContext fontRenderContext, TextLineComponent[] textLineComponentArray, float[] fArray, char[] cArray, int n, int n2, int[] nArray, byte[] byArray, boolean bl) {
        int[] nArray2 = TextLine.computeComponentOrder(textLineComponentArray, nArray);
        this.frc = fontRenderContext;
        this.fComponents = textLineComponentArray;
        this.fBaselineOffsets = fArray;
        this.fComponentVisualOrder = nArray2;
        this.fChars = cArray;
        this.fCharsStart = n;
        this.fCharsLimit = n2;
        this.fCharLogicalOrder = nArray;
        this.fCharLevels = byArray;
        this.fIsDirectionLTR = bl;
        this.checkCtorArgs();
        this.init();
    }

    private void checkCtorArgs() {
        int n = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            n += this.fComponents[i].getNumCharacters();
        }
        if (n != this.characterCount()) {
            throw new IllegalArgumentException("Invalid TextLine!  char count is different from sum of char counts of components.");
        }
    }

    private void init() {
        float f;
        TextLineComponent textLineComponent;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        float f6 = 0.0f;
        float f7 = 0.0f;
        boolean bl = false;
        this.isSimple = true;
        for (int i = 0; i < this.fComponents.length; ++i) {
            float f8;
            float f9;
            textLineComponent = this.fComponents[i];
            this.isSimple &= textLineComponent.isSimple();
            CoreMetrics coreMetrics = textLineComponent.getCoreMetrics();
            byte by = (byte)coreMetrics.baselineIndex;
            if (by >= 0) {
                f9 = this.fBaselineOffsets[by];
                f2 = Math.max(f2, -f9 + coreMetrics.ascent);
                f8 = f9 + coreMetrics.descent;
                f3 = Math.max(f3, f8);
                f4 = Math.max(f4, f8 + coreMetrics.leading);
                continue;
            }
            bl = true;
            f9 = coreMetrics.ascent + coreMetrics.descent;
            f8 = f9 + coreMetrics.leading;
            f6 = Math.max(f6, f9);
            f7 = Math.max(f7, f8);
        }
        if (bl) {
            if (f6 > f2 + f3) {
                f3 = f6 - f2;
            }
            if (f7 > f2 + f4) {
                f4 = f7 - f2;
            }
        }
        f4 -= f3;
        if (bl) {
            this.fBaselineOffsets = new float[]{this.fBaselineOffsets[0], this.fBaselineOffsets[1], this.fBaselineOffsets[2], f3, -f2};
        }
        float f10 = 0.0f;
        float f11 = 0.0f;
        CoreMetrics coreMetrics = null;
        boolean bl2 = false;
        this.locs = new float[this.fComponents.length * 2 + 2];
        int n = 0;
        int n2 = 0;
        while (n < this.fComponents.length) {
            textLineComponent = this.fComponents[this.getComponentLogicalIndex(n)];
            CoreMetrics coreMetrics2 = textLineComponent.getCoreMetrics();
            if (!(coreMetrics == null || coreMetrics.italicAngle == 0.0f && coreMetrics2.italicAngle == 0.0f || coreMetrics.italicAngle == coreMetrics2.italicAngle && coreMetrics.baselineIndex == coreMetrics2.baselineIndex && coreMetrics.ssOffset == coreMetrics2.ssOffset)) {
                f = coreMetrics.effectiveBaselineOffset(this.fBaselineOffsets);
                float f12 = f - coreMetrics.ascent;
                float f13 = f + coreMetrics.descent;
                float f14 = coreMetrics2.effectiveBaselineOffset(this.fBaselineOffsets);
                float f15 = f14 - coreMetrics2.ascent;
                float f16 = f14 + coreMetrics2.descent;
                float f17 = Math.max(f12, f15);
                float f18 = Math.min(f13, f16);
                float f19 = coreMetrics.italicAngle * (f - f17);
                float f20 = coreMetrics.italicAngle * (f - f18);
                float f21 = coreMetrics2.italicAngle * (f14 - f17);
                float f22 = coreMetrics2.italicAngle * (f14 - f18);
                float f23 = f19 - f21;
                float f24 = f20 - f22;
                float f25 = Math.max(f23, f24);
                f10 += f25;
                f11 = f14;
            } else {
                f11 = coreMetrics2.effectiveBaselineOffset(this.fBaselineOffsets);
            }
            this.locs[n2] = f10;
            this.locs[n2 + 1] = f11;
            f10 += textLineComponent.getAdvance();
            coreMetrics = coreMetrics2;
            bl2 |= textLineComponent.getBaselineTransform() != null;
            ++n;
            n2 += 2;
        }
        if (coreMetrics.italicAngle != 0.0f) {
            float f26 = coreMetrics.effectiveBaselineOffset(this.fBaselineOffsets);
            float f27 = f26 - coreMetrics.ascent;
            float f28 = f26 + coreMetrics.descent;
            f = coreMetrics.italicAngle > 0.0f ? f26 + coreMetrics.ascent : (f26 += coreMetrics.ssOffset) - coreMetrics.descent;
            f10 += (f *= coreMetrics.italicAngle);
        }
        this.locs[this.locs.length - 2] = f10;
        f5 = f10;
        this.fMetrics = new TextLineMetrics(f2, f3, f4, f5);
        if (bl2) {
            AffineTransform affineTransform;
            this.isSimple = false;
            Point2D.Double double_ = new Point2D.Double();
            double d = 0.0;
            double d2 = 0.0;
            LayoutPathImpl.SegmentPathBuilder segmentPathBuilder = new LayoutPathImpl.SegmentPathBuilder();
            segmentPathBuilder.moveTo(this.locs[0], 0.0);
            int n3 = 0;
            int n4 = 0;
            while (n3 < this.fComponents.length) {
                textLineComponent = this.fComponents[this.getComponentLogicalIndex(n3)];
                AffineTransform affineTransform2 = textLineComponent.getBaselineTransform();
                if (affineTransform2 != null) {
                    if ((affineTransform2.getType() & 1) != 0) {
                        double d3 = affineTransform2.getTranslateX();
                        double d4 = affineTransform2.getTranslateY();
                        segmentPathBuilder.moveTo(d += d3, d2 += d4);
                    }
                }
                double_.x = this.locs[n4 + 2] - this.locs[n4];
                double_.y = 0.0;
                if (affineTransform2 != null) {
                    affineTransform2.deltaTransform(double_, double_);
                }
                segmentPathBuilder.lineTo(d += double_.x, d2 += double_.y);
                ++n3;
                n4 += 2;
            }
            this.lp = segmentPathBuilder.complete();
            if (this.lp == null && (affineTransform = (textLineComponent = this.fComponents[this.getComponentLogicalIndex(0)]).getBaselineTransform()) != null) {
                this.lp = new LayoutPathImpl.EmptyPath(affineTransform);
            }
        }
    }

    public Rectangle getPixelBounds(FontRenderContext fontRenderContext, float f, float f2) {
        boolean bl;
        Rectangle rectangle = null;
        if (fontRenderContext != null && fontRenderContext.equals(this.frc)) {
            fontRenderContext = null;
        }
        int n = (int)Math.floor(f);
        int n2 = (int)Math.floor(f2);
        float f3 = f - (float)n;
        float f4 = f2 - (float)n2;
        boolean bl2 = bl = fontRenderContext == null && f3 == 0.0f && f4 == 0.0f;
        if (bl && this.pixelBounds != null) {
            rectangle = new Rectangle(this.pixelBounds);
            rectangle.x += n;
            rectangle.y += n2;
            return rectangle;
        }
        if (this.isSimple) {
            int n3 = 0;
            int n4 = 0;
            while (n3 < this.fComponents.length) {
                TextLineComponent textLineComponent = this.fComponents[this.getComponentLogicalIndex(n3)];
                Rectangle rectangle2 = textLineComponent.getPixelBounds(fontRenderContext, this.locs[n4] + f3, this.locs[n4 + 1] + f4);
                if (!rectangle2.isEmpty()) {
                    if (rectangle == null) {
                        rectangle = rectangle2;
                    } else {
                        rectangle.add(rectangle2);
                    }
                }
                ++n3;
                n4 += 2;
            }
            if (rectangle == null) {
                rectangle = new Rectangle(0, 0, 0, 0);
            }
        } else {
            Rectangle2D rectangle2D = this.getVisualBounds();
            if (this.lp != null) {
                rectangle2D = this.lp.mapShape(rectangle2D).getBounds();
            }
            Rectangle rectangle3 = rectangle2D.getBounds();
            BufferedImage bufferedImage = new BufferedImage(rectangle3.width + 6, rectangle3.height + 6, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setColor(Color.WHITE);
            graphics2D.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
            graphics2D.setColor(Color.BLACK);
            this.draw(graphics2D, f3 + 3.0f - (float)rectangle3.x, f4 + 3.0f - (float)rectangle3.y);
            rectangle = TextLine.computePixelBounds(bufferedImage);
            rectangle.x -= 3 - rectangle3.x;
            rectangle.y -= 3 - rectangle3.y;
        }
        if (bl) {
            this.pixelBounds = new Rectangle(rectangle);
        }
        rectangle.x += n;
        rectangle.y += n2;
        return rectangle;
    }

    static Rectangle computePixelBounds(BufferedImage bufferedImage) {
        int n;
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        int n4 = -1;
        int n5 = -1;
        int n6 = n2;
        int n7 = n3;
        int[] nArray = new int[n2];
        block0: while (++n5 < n3) {
            bufferedImage.getRGB(0, n5, nArray.length, 1, nArray, 0, n2);
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] != -1) break block0;
            }
        }
        nArray = new int[n2];
        block2: while (--n7 > n5) {
            bufferedImage.getRGB(0, n7, nArray.length, 1, nArray, 0, n2);
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] != -1) break block2;
            }
        }
        ++n7;
        block4: while (++n4 < n6) {
            for (int i = n5; i < n7; ++i) {
                n = bufferedImage.getRGB(n4, i);
                if (n != -1) break block4;
            }
        }
        block6: while (--n6 > n4) {
            for (int i = n5; i < n7; ++i) {
                n = bufferedImage.getRGB(n6, i);
                if (n != -1) break block6;
            }
        }
        return new Rectangle(n4, n5, ++n6 - n4, n7 - n5);
    }

    public int characterCount() {
        return this.fCharsLimit - this.fCharsStart;
    }

    public boolean isDirectionLTR() {
        return this.fIsDirectionLTR;
    }

    public TextLineMetrics getMetrics() {
        return this.fMetrics;
    }

    public int visualToLogical(int n) {
        if (this.fCharLogicalOrder == null) {
            return n;
        }
        if (this.fCharVisualOrder == null) {
            this.fCharVisualOrder = BidiUtils.createInverseMap(this.fCharLogicalOrder);
        }
        return this.fCharVisualOrder[n];
    }

    public int logicalToVisual(int n) {
        return this.fCharLogicalOrder == null ? n : this.fCharLogicalOrder[n];
    }

    public byte getCharLevel(int n) {
        return this.fCharLevels == null ? (byte)0 : this.fCharLevels[n];
    }

    public boolean isCharLTR(int n) {
        return (this.getCharLevel(n) & 1) == 0;
    }

    public int getCharType(int n) {
        return Character.getType(this.fChars[n + this.fCharsStart]);
    }

    public boolean isCharSpace(int n) {
        return Character.isSpaceChar(this.fChars[n + this.fCharsStart]);
    }

    public boolean isCharWhitespace(int n) {
        return Character.isWhitespace(this.fChars[n + this.fCharsStart]);
    }

    public float getCharAngle(int n) {
        return this.getCoreMetricsAt((int)n).italicAngle;
    }

    public CoreMetrics getCoreMetricsAt(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        if (n > this.fCharsLimit - this.fCharsStart) {
            throw new IllegalArgumentException("logicalIndex too large.");
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while ((n4 += this.fComponents[n2].getNumCharacters()) <= n) {
            n3 = n4;
            if (++n2 < this.fComponents.length) continue;
        }
        return this.fComponents[n2].getCoreMetrics();
    }

    public float getCharAscent(int n) {
        return this.getCoreMetricsAt((int)n).ascent;
    }

    public float getCharDescent(int n) {
        return this.getCoreMetricsAt((int)n).descent;
    }

    public float getCharShift(int n) {
        return this.getCoreMetricsAt((int)n).ssOffset;
    }

    private float applyFunctionAtIndex(int n, Function function) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n2 = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int n3 = n2 + this.fComponents[i].getNumCharacters();
            if (n3 > n) {
                return function.computeFunction(this, i, n - n2);
            }
            n2 = n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    public float getCharAdvance(int n) {
        return this.applyFunctionAtIndex(n, fgAdvanceF);
    }

    public float getCharXPosition(int n) {
        return this.applyFunctionAtIndex(n, fgXPositionF);
    }

    public float getCharYPosition(int n) {
        return this.applyFunctionAtIndex(n, fgYPositionF);
    }

    public float getCharLinePosition(int n) {
        return this.getCharXPosition(n);
    }

    public float getCharLinePosition(int n, boolean bl) {
        Function function = this.isCharLTR(n) == bl ? fgXPositionF : fgPosAdvF;
        return this.applyFunctionAtIndex(n, function);
    }

    public boolean caretAtOffsetIsValid(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative offset.");
        }
        int n2 = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int n3 = n2 + this.fComponents[i].getNumCharacters();
            if (n3 > n) {
                return this.fComponents[i].caretAtOffsetIsValid(n - n2);
            }
            n2 = n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    private int getComponentLogicalIndex(int n) {
        if (this.fComponentVisualOrder == null) {
            return n;
        }
        return this.fComponentVisualOrder[n];
    }

    private int getComponentVisualIndex(int n) {
        if (this.fComponentVisualOrder == null) {
            return n;
        }
        for (int i = 0; i < this.fComponentVisualOrder.length; ++i) {
            if (this.fComponentVisualOrder[i] != n) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("bad component index: " + n);
    }

    public Rectangle2D getCharBounds(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Negative logicalIndex.");
        }
        int n2 = 0;
        for (int i = 0; i < this.fComponents.length; ++i) {
            int n3 = n2 + this.fComponents[i].getNumCharacters();
            if (n3 > n) {
                TextLineComponent textLineComponent = this.fComponents[i];
                int n4 = n - n2;
                Rectangle2D rectangle2D = textLineComponent.getCharVisualBounds(n4);
                int n5 = this.getComponentVisualIndex(i);
                rectangle2D.setRect(rectangle2D.getX() + (double)this.locs[n5 * 2], rectangle2D.getY() + (double)this.locs[n5 * 2 + 1], rectangle2D.getWidth(), rectangle2D.getHeight());
                return rectangle2D;
            }
            n2 = n3;
        }
        throw new IllegalArgumentException("logicalIndex too large.");
    }

    private float getComponentShift(int n) {
        CoreMetrics coreMetrics = this.fComponents[n].getCoreMetrics();
        return coreMetrics.effectiveBaselineOffset(this.fBaselineOffsets);
    }

    public void draw(Graphics2D graphics2D, float f, float f2) {
        if (this.lp == null) {
            int n = 0;
            int n2 = 0;
            while (n < this.fComponents.length) {
                TextLineComponent textLineComponent = this.fComponents[this.getComponentLogicalIndex(n)];
                textLineComponent.draw(graphics2D, this.locs[n2] + f, this.locs[n2 + 1] + f2);
                ++n;
                n2 += 2;
            }
        } else {
            AffineTransform affineTransform = graphics2D.getTransform();
            Point2D.Float float_ = new Point2D.Float();
            int n = 0;
            int n3 = 0;
            while (n < this.fComponents.length) {
                TextLineComponent textLineComponent = this.fComponents[this.getComponentLogicalIndex(n)];
                this.lp.pathToPoint(this.locs[n3], this.locs[n3 + 1], false, float_);
                float_.x += f;
                float_.y += f2;
                AffineTransform affineTransform2 = textLineComponent.getBaselineTransform();
                if (affineTransform2 != null) {
                    graphics2D.translate((double)float_.x - affineTransform2.getTranslateX(), (double)float_.y - affineTransform2.getTranslateY());
                    graphics2D.transform(affineTransform2);
                    textLineComponent.draw(graphics2D, 0.0f, 0.0f);
                    graphics2D.setTransform(affineTransform);
                } else {
                    textLineComponent.draw(graphics2D, float_.x, float_.y);
                }
                ++n;
                n3 += 2;
            }
        }
    }

    public Rectangle2D getVisualBounds() {
        Rectangle2D rectangle2D = null;
        int n = 0;
        int n2 = 0;
        while (n < this.fComponents.length) {
            TextLineComponent textLineComponent = this.fComponents[this.getComponentLogicalIndex(n)];
            Rectangle2D rectangle2D2 = textLineComponent.getVisualBounds();
            Point2D.Float float_ = new Point2D.Float(this.locs[n2], this.locs[n2 + 1]);
            if (this.lp == null) {
                rectangle2D2.setRect(rectangle2D2.getMinX() + (double)float_.x, rectangle2D2.getMinY() + (double)float_.y, rectangle2D2.getWidth(), rectangle2D2.getHeight());
            } else {
                this.lp.pathToPoint(float_, false, float_);
                AffineTransform affineTransform = textLineComponent.getBaselineTransform();
                if (affineTransform != null) {
                    AffineTransform affineTransform2 = AffineTransform.getTranslateInstance((double)float_.x - affineTransform.getTranslateX(), (double)float_.y - affineTransform.getTranslateY());
                    affineTransform2.concatenate(affineTransform);
                    rectangle2D2 = affineTransform2.createTransformedShape(rectangle2D2).getBounds2D();
                } else {
                    rectangle2D2.setRect(rectangle2D2.getMinX() + (double)float_.x, rectangle2D2.getMinY() + (double)float_.y, rectangle2D2.getWidth(), rectangle2D2.getHeight());
                }
            }
            if (rectangle2D == null) {
                rectangle2D = rectangle2D2;
            } else {
                rectangle2D.add(rectangle2D2);
            }
            ++n;
            n2 += 2;
        }
        if (rectangle2D == null) {
            rectangle2D = new Rectangle2D.Float(Float.MAX_VALUE, Float.MAX_VALUE, Float.MIN_VALUE, Float.MIN_VALUE);
        }
        return rectangle2D;
    }

    public Rectangle2D getItalicBounds() {
        float f = Float.MAX_VALUE;
        float f2 = -3.4028235E38f;
        float f3 = Float.MAX_VALUE;
        float f4 = -3.4028235E38f;
        int n = 0;
        int n2 = 0;
        while (n < this.fComponents.length) {
            TextLineComponent textLineComponent = this.fComponents[this.getComponentLogicalIndex(n)];
            Rectangle2D rectangle2D = textLineComponent.getItalicBounds();
            float f5 = this.locs[n2];
            float f6 = this.locs[n2 + 1];
            f = Math.min(f, f5 + (float)rectangle2D.getX());
            f2 = Math.max(f2, f5 + (float)rectangle2D.getMaxX());
            f3 = Math.min(f3, f6 + (float)rectangle2D.getY());
            f4 = Math.max(f4, f6 + (float)rectangle2D.getMaxY());
            ++n;
            n2 += 2;
        }
        return new Rectangle2D.Float(f, f3, f2 - f, f4 - f3);
    }

    public Shape getOutline(AffineTransform affineTransform) {
        GeneralPath generalPath = new GeneralPath(1);
        int n = 0;
        int n2 = 0;
        while (n < this.fComponents.length) {
            TextLineComponent textLineComponent = this.fComponents[this.getComponentLogicalIndex(n)];
            generalPath.append(textLineComponent.getOutline(this.locs[n2], this.locs[n2 + 1]), false);
            ++n;
            n2 += 2;
        }
        if (affineTransform != null) {
            generalPath.transform(affineTransform);
        }
        return generalPath;
    }

    public int hashCode() {
        return this.fComponents.length << 16 ^ this.fComponents[0].hashCode() << 3 ^ this.fCharsLimit - this.fCharsStart;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.fComponents.length; ++i) {
            stringBuilder.append(this.fComponents[i]);
        }
        return stringBuilder.toString();
    }

    public static TextLine fastCreateTextLine(FontRenderContext fontRenderContext, char[] cArray, Font font, CoreMetrics coreMetrics, Map map) {
        int n;
        int n2;
        boolean bl = true;
        byte[] byArray = null;
        int[] nArray = null;
        Bidi bidi = null;
        int n3 = cArray.length;
        boolean bl2 = false;
        byte[] byArray2 = null;
        AttributeValues attributeValues = null;
        if (map != null) {
            attributeValues = AttributeValues.fromMap(map);
            if (attributeValues.getRunDirection() >= 0) {
                bl = attributeValues.getRunDirection() == 0;
                boolean bl3 = bl2 = !bl;
            }
            if (attributeValues.getBidiEmbedding() != 0) {
                bl2 = true;
                n2 = (byte)attributeValues.getBidiEmbedding();
                byArray2 = new byte[n3];
                for (n = 0; n < byArray2.length; ++n) {
                    byArray2[n] = n2;
                }
            }
        }
        if (!bl2) {
            bl2 = Bidi.requiresBidi(cArray, 0, cArray.length);
        }
        if (bl2 && !(bidi = new Bidi(cArray, 0, byArray2, 0, cArray.length, n2 = attributeValues == null ? -2 : attributeValues.getRunDirection())).isLeftToRight()) {
            byArray = BidiUtils.getLevels(bidi);
            int[] nArray2 = BidiUtils.createVisualToLogicalMap(byArray);
            nArray = BidiUtils.createInverseMap(nArray2);
            bl = bidi.baseIsLeftToRight();
        }
        Decoration decoration = Decoration.getDecoration(attributeValues);
        n = 0;
        TextLabelFactory textLabelFactory = new TextLabelFactory(fontRenderContext, cArray, bidi, n);
        TextLineComponent[] textLineComponentArray = new TextLineComponent[1];
        textLineComponentArray = TextLine.createComponentsOnRun(0, cArray.length, cArray, nArray, byArray, textLabelFactory, font, coreMetrics, fontRenderContext, decoration, textLineComponentArray, 0);
        int n4 = textLineComponentArray.length;
        while (textLineComponentArray[n4 - 1] == null) {
            --n4;
        }
        if (n4 != textLineComponentArray.length) {
            TextLineComponent[] textLineComponentArray2 = new TextLineComponent[n4];
            System.arraycopy(textLineComponentArray, 0, textLineComponentArray2, 0, n4);
            textLineComponentArray = textLineComponentArray2;
        }
        return new TextLine(fontRenderContext, textLineComponentArray, coreMetrics.baselineOffsets, cArray, 0, cArray.length, nArray, byArray, bl);
    }

    private static TextLineComponent[] expandArray(TextLineComponent[] textLineComponentArray) {
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[textLineComponentArray.length + 8];
        System.arraycopy(textLineComponentArray, 0, textLineComponentArray2, 0, textLineComponentArray.length);
        return textLineComponentArray2;
    }

    public static TextLineComponent[] createComponentsOnRun(int n, int n2, char[] cArray, int[] nArray, byte[] byArray, TextLabelFactory textLabelFactory, Font font, CoreMetrics coreMetrics, FontRenderContext fontRenderContext, Decoration decoration, TextLineComponent[] textLineComponentArray, int n3) {
        int n4 = n;
        do {
            int n5;
            int n6 = TextLine.firstVisualChunk(nArray, byArray, n4, n2);
            do {
                Object object;
                int n7 = n4;
                if (coreMetrics == null) {
                    object = font.getLineMetrics(cArray, n7, n6, fontRenderContext);
                    coreMetrics = CoreMetrics.get((LineMetrics)object);
                    n5 = ((LineMetrics)object).getNumChars();
                } else {
                    n5 = n6 - n7;
                }
                object = textLabelFactory.createExtended(font, coreMetrics, decoration, n7, n7 + n5);
                if (++n3 >= textLineComponentArray.length) {
                    textLineComponentArray = TextLine.expandArray(textLineComponentArray);
                }
                textLineComponentArray[n3 - 1] = object;
            } while ((n4 += n5) < n6);
        } while (n4 < n2);
        return textLineComponentArray;
    }

    public static TextLineComponent[] getComponents(StyledParagraph styledParagraph, char[] cArray, int n, int n2, int[] nArray, byte[] byArray, TextLabelFactory textLabelFactory) {
        TextLineComponent[] textLineComponentArray;
        FontRenderContext fontRenderContext = textLabelFactory.getFontRenderContext();
        int n3 = 0;
        TextLineComponent[] textLineComponentArray2 = new TextLineComponent[1];
        int n4 = n;
        do {
            Font font;
            int n5 = Math.min(styledParagraph.getRunLimit(n4), n2);
            Decoration decoration = styledParagraph.getDecorationAt(n4);
            Object object = styledParagraph.getFontOrGraphicAt(n4);
            if (object instanceof GraphicAttribute) {
                font = null;
                GraphicAttribute graphicAttribute = (GraphicAttribute)object;
                do {
                    int n6 = TextLine.firstVisualChunk(nArray, byArray, n4, n5);
                    GraphicComponent graphicComponent = new GraphicComponent(graphicAttribute, decoration, nArray, byArray, n4, n6, (AffineTransform)((Object)font));
                    n4 = n6;
                    if (++n3 >= textLineComponentArray2.length) {
                        textLineComponentArray2 = TextLine.expandArray(textLineComponentArray2);
                    }
                    textLineComponentArray2[n3 - 1] = graphicComponent;
                } while (n4 < n5);
                continue;
            }
            font = (Font)object;
            textLineComponentArray2 = TextLine.createComponentsOnRun(n4, n5, cArray, nArray, byArray, textLabelFactory, font, null, fontRenderContext, decoration, textLineComponentArray2, n3);
            n4 = n5;
            n3 = textLineComponentArray2.length;
            while (textLineComponentArray2[n3 - 1] == null) {
                --n3;
            }
        } while (n4 < n2);
        if (textLineComponentArray2.length == n3) {
            textLineComponentArray = textLineComponentArray2;
        } else {
            textLineComponentArray = new TextLineComponent[n3];
            System.arraycopy(textLineComponentArray2, 0, textLineComponentArray, 0, n3);
        }
        return textLineComponentArray;
    }

    public static TextLine createLineFromText(char[] cArray, StyledParagraph styledParagraph, TextLabelFactory textLabelFactory, boolean bl, float[] fArray) {
        Object[] objectArray;
        textLabelFactory.setLineContext(0, cArray.length);
        Bidi bidi = textLabelFactory.getLineBidi();
        int[] nArray = null;
        byte[] byArray = null;
        if (bidi != null) {
            byArray = BidiUtils.getLevels(bidi);
            objectArray = BidiUtils.createVisualToLogicalMap(byArray);
            nArray = BidiUtils.createInverseMap(objectArray);
        }
        objectArray = TextLine.getComponents(styledParagraph, cArray, 0, cArray.length, nArray, byArray, textLabelFactory);
        return new TextLine(textLabelFactory.getFontRenderContext(), (TextLineComponent[])objectArray, fArray, cArray, 0, cArray.length, nArray, byArray, bl);
    }

    private static int[] computeComponentOrder(TextLineComponent[] textLineComponentArray, int[] nArray) {
        int[] nArray2 = null;
        if (nArray != null && textLineComponentArray.length > 1) {
            nArray2 = new int[textLineComponentArray.length];
            int n = 0;
            for (int i = 0; i < textLineComponentArray.length; ++i) {
                nArray2[i] = nArray[n];
                n += textLineComponentArray[i].getNumCharacters();
            }
            nArray2 = BidiUtils.createContiguousOrder(nArray2);
            nArray2 = BidiUtils.createInverseMap(nArray2);
        }
        return nArray2;
    }

    public static TextLine standardCreateTextLine(FontRenderContext fontRenderContext, AttributedCharacterIterator attributedCharacterIterator, char[] cArray, float[] fArray) {
        StyledParagraph styledParagraph = new StyledParagraph(attributedCharacterIterator, cArray);
        Bidi bidi = new Bidi(attributedCharacterIterator);
        if (bidi.isLeftToRight()) {
            bidi = null;
        }
        int n = 0;
        TextLabelFactory textLabelFactory = new TextLabelFactory(fontRenderContext, cArray, bidi, n);
        boolean bl = true;
        if (bidi != null) {
            bl = bidi.baseIsLeftToRight();
        }
        return TextLine.createLineFromText(cArray, styledParagraph, textLabelFactory, bl, fArray);
    }

    static boolean advanceToFirstFont(AttributedCharacterIterator attributedCharacterIterator) {
        char c = attributedCharacterIterator.first();
        while (true) {
            if (c == '\uffff') break;
            if (attributedCharacterIterator.getAttribute(TextAttribute.CHAR_REPLACEMENT) == null) {
                return true;
            }
            c = attributedCharacterIterator.setIndex(attributedCharacterIterator.getRunLimit());
        }
        return false;
    }

    static float[] getNormalizedOffsets(float[] fArray, byte by) {
        if (fArray[by] != 0.0f) {
            float f = fArray[by];
            float[] fArray2 = new float[fArray.length];
            for (int i = 0; i < fArray2.length; ++i) {
                fArray2[i] = fArray[i] - f;
            }
            fArray = fArray2;
        }
        return fArray;
    }

    static Font getFontAtCurrentPos(AttributedCharacterIterator attributedCharacterIterator) {
        Object object = attributedCharacterIterator.getAttribute(TextAttribute.FONT);
        if (object != null) {
            return (Font)object;
        }
        if (attributedCharacterIterator.getAttribute(TextAttribute.FAMILY) != null) {
            return Font.getFont(attributedCharacterIterator.getAttributes());
        }
        int n = CodePointIterator.create(attributedCharacterIterator).next();
        if (n != -1) {
            FontResolver fontResolver = FontResolver.getInstance();
            return fontResolver.getFont(fontResolver.getFontIndex(n), attributedCharacterIterator.getAttributes());
        }
        return null;
    }

    private static int firstVisualChunk(int[] nArray, byte[] byArray, int n, int n2) {
        if (nArray != null && byArray != null) {
            byte by = byArray[n];
            while (++n < n2 && byArray[n] == by) {
            }
            return n;
        }
        return n2;
    }

    public TextLine getJustifiedLine(float f, float f2, int n, int n2) {
        int n3;
        TextLineComponent[] textLineComponentArray = new TextLineComponent[this.fComponents.length];
        System.arraycopy(this.fComponents, 0, textLineComponentArray, 0, this.fComponents.length);
        float f3 = 0.0f;
        float f4 = 0.0f;
        float f5 = 0.0f;
        boolean bl = false;
        block0: do {
            int n4;
            int n5;
            int n6;
            f4 = TextLine.getAdvanceBetween(textLineComponentArray, 0, this.characterCount());
            float f6 = TextLine.getAdvanceBetween(textLineComponentArray, n, n2);
            f5 = (f - f6) * f2;
            int[] nArray = new int[textLineComponentArray.length];
            int n7 = 0;
            for (int i = 0; i < textLineComponentArray.length; ++i) {
                n6 = this.getComponentLogicalIndex(i);
                nArray[n6] = n7;
                n7 += textLineComponentArray[n6].getNumJustificationInfos();
            }
            GlyphJustificationInfo[] glyphJustificationInfoArray = new GlyphJustificationInfo[n7];
            n6 = 0;
            for (n5 = 0; n5 < textLineComponentArray.length; ++n5) {
                TextLineComponent textLineComponent = textLineComponentArray[n5];
                int n8 = textLineComponent.getNumCharacters();
                int n9 = n6 + n8;
                if (n9 <= n) continue;
                n4 = Math.max(0, n - n6);
                n3 = Math.min(n8, n2 - n6);
                textLineComponent.getJustificationInfos(glyphJustificationInfoArray, nArray[n5], n4, n3);
                if (n9 >= n2) break;
            }
            int n10 = n7;
            for (n5 = 0; n5 < n10 && glyphJustificationInfoArray[n5] == null; ++n5) {
            }
            while (n10 > n5 && glyphJustificationInfoArray[n10 - 1] == null) {
                --n10;
            }
            TextJustifier textJustifier = new TextJustifier(glyphJustificationInfoArray, n5, n10);
            float[] fArray = textJustifier.justify(f5);
            n4 = !bl ? 1 : 0;
            n3 = 0;
            boolean[] blArray = new boolean[1];
            n6 = 0;
            for (int i = 0; i < textLineComponentArray.length; ++i) {
                TextLineComponent textLineComponent = textLineComponentArray[i];
                int n11 = textLineComponent.getNumCharacters();
                int n12 = n6 + n11;
                if (n12 <= n) continue;
                int n13 = Math.max(0, n - n6);
                int n14 = Math.min(n11, n2 - n6);
                textLineComponentArray[i] = textLineComponent.applyJustificationDeltas(fArray, nArray[i] * 2, blArray);
                n3 |= blArray[0];
                if (n12 >= n2) continue block0;
            }
        } while (bl = n3 != 0 && !bl);
        return new TextLine(this.frc, textLineComponentArray, this.fBaselineOffsets, this.fChars, this.fCharsStart, this.fCharsLimit, this.fCharLogicalOrder, this.fCharLevels, this.fIsDirectionLTR);
    }

    public static float getAdvanceBetween(TextLineComponent[] textLineComponentArray, int n, int n2) {
        float f = 0.0f;
        int n3 = 0;
        for (int i = 0; i < textLineComponentArray.length; ++i) {
            TextLineComponent textLineComponent = textLineComponentArray[i];
            int n4 = textLineComponent.getNumCharacters();
            int n5 = n3 + n4;
            if (n5 > n) {
                int n6 = Math.max(0, n - n3);
                int n7 = Math.min(n4, n2 - n3);
                f += textLineComponent.getAdvanceBetween(n6, n7);
                if (n5 >= n2) break;
            }
            n3 = n5;
        }
        return f;
    }

    LayoutPathImpl getLayoutPath() {
        return this.lp;
    }

    private static abstract class Function {
        private Function() {
        }

        abstract float computeFunction(TextLine var1, int var2, int var3);
    }

    static final class TextLineMetrics {
        public final float ascent;
        public final float descent;
        public final float leading;
        public final float advance;

        public TextLineMetrics(float f, float f2, float f3, float f4) {
            this.ascent = f;
            this.descent = f2;
            this.leading = f3;
            this.advance = f4;
        }
    }
}

