/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.encoding.soap.SOAP12Constants;
import com.sun.xml.internal.ws.encoding.soap.SOAPConstants;
import com.sun.xml.internal.ws.handler.HandlerException;
import com.sun.xml.internal.ws.handler.SOAPHandlerContext;
import com.sun.xml.internal.ws.handler.SOAPMessageContextImpl;
import com.sun.xml.internal.ws.handler.XMLHandlerContext;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.LogicalMessage;
import javax.xml.ws.ProtocolException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.LogicalMessageContext;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import javax.xml.ws.http.HTTPException;
import javax.xml.ws.soap.SOAPFaultException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HandlerChainCaller {
    public static final String HANDLER_CHAIN_CALLER = "handler_chain_caller";
    public static final String IGNORE_FAULT_PROPERTY = "ignore fault in message";
    private static final Logger logger = Logger.getLogger("javax.enterprise.resource.webservices.jaxws.handler");
    private Set<QName> understoodHeaders;
    private List<Handler> handlers;
    private List<LogicalHandler> logicalHandlers;
    private List<SOAPHandler> soapHandlers;
    private Set<String> roles;

    public HandlerChainCaller(List<Handler> list) {
        if (list == null) {
            list = new ArrayList<Handler>();
        }
        this.handlers = list;
        this.logicalHandlers = new ArrayList<LogicalHandler>();
        this.soapHandlers = new ArrayList<SOAPHandler>();
        this.understoodHeaders = new HashSet<QName>();
        this.sortHandlers();
    }

    public List<Handler> getHandlerChain() {
        return this.handlers;
    }

    public boolean hasHandlers() {
        return this.handlers.size() != 0;
    }

    public void setRoles(Set<String> set) {
        this.roles = set;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    public Set<QName> getUnderstoodHeaders() {
        return this.understoodHeaders;
    }

    private void sortHandlers() {
        for (Handler handler : this.handlers) {
            if (LogicalHandler.class.isAssignableFrom(handler.getClass())) {
                this.logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            if (SOAPHandler.class.isAssignableFrom(handler.getClass())) {
                this.soapHandlers.add((SOAPHandler)handler);
                Set<QName> set = ((SOAPHandler)handler).getHeaders();
                if (set == null) continue;
                this.understoodHeaders.addAll(set);
                continue;
            }
            if (Handler.class.isAssignableFrom(handler.getClass())) {
                throw new HandlerException("cannot.extend.handler.directly", handler.getClass().toString());
            }
            throw new HandlerException("handler.not.valid.type", handler.getClass().toString());
        }
        this.handlers.clear();
        this.handlers.addAll(this.logicalHandlers);
        this.handlers.addAll(this.soapHandlers);
    }

    private void insertFaultMessage(ContextHolder contextHolder, ProtocolException protocolException) {
        try {
            SOAPMessage sOAPMessage;
            SOAPEnvelope sOAPEnvelope;
            SOAPBody sOAPBody;
            SOAPMessageContext sOAPMessageContext = contextHolder.getSMC();
            if (sOAPMessageContext == null) {
                LogicalMessageContext logicalMessageContext = contextHolder.getLMC();
                LogicalMessage logicalMessage = logicalMessageContext.getMessage();
                if (logicalMessage != null) {
                    logicalMessage.setPayload(null);
                }
                if (((Boolean)logicalMessageContext.get("javax.xml.ws.handler.message.outbound")).booleanValue()) {
                    if (protocolException instanceof HTTPException) {
                        logicalMessageContext.put("javax.xml.ws.http.response.code", ((HTTPException)protocolException).getStatusCode());
                    } else {
                        logicalMessageContext.put("javax.xml.ws.http.response.code", 500);
                    }
                }
                return;
            }
            if (((Boolean)sOAPMessageContext.get("javax.xml.ws.handler.message.outbound")).booleanValue()) {
                sOAPMessageContext.put("javax.xml.ws.http.response.code", 500);
            }
            if ((sOAPBody = (sOAPEnvelope = (sOAPMessage = sOAPMessageContext.getMessage()).getSOAPPart().getEnvelope()).getBody()).hasFault()) {
                return;
            }
            if (sOAPEnvelope.getHeader() != null) {
                sOAPEnvelope.getHeader().detachNode();
            }
            sOAPBody.removeContents();
            SOAPFault sOAPFault = sOAPBody.addFault();
            String string = sOAPEnvelope.getNamespaceURI();
            if (protocolException instanceof SOAPFaultException) {
                SOAPFaultException sOAPFaultException = (SOAPFaultException)protocolException;
                SOAPFault sOAPFault2 = sOAPFaultException.getFault();
                QName qName = sOAPFault2.getFaultCodeAsQName();
                if (qName == null) {
                    qName = this.determineFaultCode(sOAPMessageContext);
                }
                sOAPFault.setFaultCode(qName);
                String string2 = sOAPFault2.getFaultString();
                if (string2 == null) {
                    string2 = sOAPFaultException.getMessage() != null ? sOAPFaultException.getMessage() : sOAPFaultException.toString();
                }
                sOAPFault.setFaultString(string2);
                String string3 = sOAPFault2.getFaultActor();
                if (string3 == null) {
                    string3 = "";
                }
                sOAPFault.setFaultActor(string3);
                if (sOAPFault2.getDetail() != null) {
                    sOAPFault.addChildElement(sOAPFault2.getDetail());
                }
            } else {
                sOAPFault.setFaultCode(this.determineFaultCode(sOAPMessageContext));
                if (protocolException.getMessage() != null) {
                    sOAPFault.setFaultString(protocolException.getMessage());
                } else {
                    sOAPFault.setFaultString(protocolException.toString());
                }
            }
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, "exception while creating fault message in handler chain", exception);
            throw new RuntimeException(exception);
        }
    }

    private void addIgnoreFaultProperty(ContextHolder contextHolder) {
        LogicalMessageContext logicalMessageContext = contextHolder.getLMC();
        logicalMessageContext.put(IGNORE_FAULT_PROPERTY, Boolean.TRUE);
    }

    private QName determineFaultCode(SOAPMessageContext sOAPMessageContext) throws SOAPException {
        SOAPEnvelope sOAPEnvelope = sOAPMessageContext.getMessage().getSOAPPart().getEnvelope();
        String string = sOAPEnvelope.getNamespaceURI();
        if (!((Boolean)sOAPMessageContext.get("javax.xml.ws.handler.message.outbound")).booleanValue()) {
            if (string.equals("http://www.w3.org/2003/05/soap-envelope")) {
                return SOAP12Constants.FAULT_CODE_CLIENT;
            }
            return SOAPConstants.FAULT_CODE_CLIENT;
        }
        if (string.equals("http://www.w3.org/2003/05/soap-envelope")) {
            return SOAP12Constants.FAULT_CODE_SERVER;
        }
        return SOAPConstants.FAULT_CODE_SERVER;
    }

    public boolean callHandlers(Direction direction, RequestOrResponse requestOrResponse, SOAPHandlerContext sOAPHandlerContext, boolean bl) {
        return this.internalCallHandlers(direction, requestOrResponse, new ContextHolder(sOAPHandlerContext), bl);
    }

    public boolean callHandlers(Direction direction, RequestOrResponse requestOrResponse, XMLHandlerContext xMLHandlerContext, boolean bl) {
        return this.internalCallHandlers(direction, requestOrResponse, new ContextHolder(xMLHandlerContext), bl);
    }

    private boolean internalCallHandlers(Direction direction, RequestOrResponse requestOrResponse, ContextHolder contextHolder, boolean bl) {
        contextHolder.getLMC().put("javax.xml.ws.handler.message.outbound", direction == Direction.OUTBOUND);
        if (contextHolder.getSMC() != null) {
            ((SOAPMessageContextImpl)contextHolder.getSMC()).setRoles(this.getRoles());
        }
        if (direction == Direction.OUTBOUND) {
            if (!this.callLogicalHandlers(contextHolder, direction, requestOrResponse, bl)) {
                return false;
            }
            if (!this.callProtocolHandlers(contextHolder, direction, requestOrResponse, bl)) {
                return false;
            }
        } else {
            if (!this.callProtocolHandlers(contextHolder, direction, requestOrResponse, bl)) {
                return false;
            }
            if (!this.callLogicalHandlers(contextHolder, direction, requestOrResponse, bl)) {
                return false;
            }
        }
        if (!bl) {
            if (requestOrResponse == RequestOrResponse.REQUEST) {
                if (direction == Direction.INBOUND) {
                    this.closeHandlersServer(contextHolder);
                } else {
                    this.closeHandlersClient(contextHolder);
                }
            } else if (direction == Direction.INBOUND) {
                this.closeHandlersClient(contextHolder);
            } else {
                this.closeHandlersServer(contextHolder);
            }
        }
        return true;
    }

    public boolean callHandleFault(SOAPHandlerContext sOAPHandlerContext) {
        ContextHolder contextHolder = new ContextHolder(sOAPHandlerContext);
        contextHolder.getSMC().put("javax.xml.ws.handler.message.outbound", true);
        ((SOAPMessageContextImpl)contextHolder.getSMC()).setRoles(this.getRoles());
        int n = 0;
        try {
            for (int i = 0; i < this.logicalHandlers.size(); ++i) {
                if (this.logicalHandlers.get(i).handleFault(contextHolder.getLMC())) continue;
                boolean bl = false;
                return bl;
            }
            while (n < this.soapHandlers.size()) {
                if (!this.soapHandlers.get(n).handleFault(contextHolder.getSMC())) {
                    boolean bl = false;
                    return bl;
                }
                ++n;
            }
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.FINER, "exception in handler chain", runtimeException);
            throw runtimeException;
        }
        finally {
            this.closeHandlersServer(contextHolder);
        }
        return true;
    }

    public boolean callHandleFaultOnClient(SOAPHandlerContext sOAPHandlerContext) {
        ContextHolder contextHolder = new ContextHolder(sOAPHandlerContext);
        contextHolder.getSMC().put("javax.xml.ws.handler.message.outbound", false);
        ((SOAPMessageContextImpl)contextHolder.getSMC()).setRoles(this.getRoles());
        try {
            int n;
            for (n = this.soapHandlers.size() - 1; n >= 0; --n) {
                if (this.soapHandlers.get(n).handleFault(contextHolder.getSMC())) continue;
                boolean bl = false;
                return bl;
            }
            for (n = this.logicalHandlers.size() - 1; n >= 0; --n) {
                if (this.logicalHandlers.get(n).handleFault(contextHolder.getLMC())) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.FINER, "exception in handler chain", runtimeException);
            throw runtimeException;
        }
        finally {
            this.closeHandlersClient(contextHolder);
        }
        return true;
    }

    private boolean callLogicalHandlers(ContextHolder contextHolder, Direction direction, RequestOrResponse requestOrResponse, boolean bl) {
        int n;
        if (direction == Direction.OUTBOUND) {
            int n2;
            try {
                for (n2 = 0; n2 < this.logicalHandlers.size(); ++n2) {
                    if (this.logicalHandlers.get(n2).handleMessage(contextHolder.getLMC())) continue;
                    if (bl) {
                        contextHolder.getLMC().put("javax.xml.ws.handler.message.outbound", false);
                        this.callLogicalHandleMessage(contextHolder, n2 - 1, 0);
                    }
                    if (requestOrResponse == RequestOrResponse.RESPONSE) {
                        this.closeHandlersServer(contextHolder);
                    } else {
                        this.closeLogicalHandlers(contextHolder, n2, 0);
                    }
                    return false;
                }
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2;
                logger.log(Level.FINER, "exception in handler chain", runtimeException);
                if (bl && runtimeException instanceof ProtocolException) {
                    contextHolder.getLMC().put("javax.xml.ws.handler.message.outbound", false);
                    this.insertFaultMessage(contextHolder, (ProtocolException)runtimeException);
                    if (n2 > 0) {
                        try {
                            this.callLogicalHandleFault(contextHolder, n2 - 1, 0);
                        }
                        catch (ProtocolException protocolException) {
                            this.addIgnoreFaultProperty(contextHolder);
                            runtimeException2 = protocolException;
                        }
                        catch (RuntimeException runtimeException3) {
                            runtimeException2 = runtimeException3;
                        }
                    }
                }
                if (requestOrResponse == RequestOrResponse.RESPONSE) {
                    this.closeHandlersServer(contextHolder);
                } else {
                    this.closeLogicalHandlers(contextHolder, n2, 0);
                }
                throw runtimeException2;
            }
        }
        try {
            for (n = this.logicalHandlers.size() - 1; n >= 0; --n) {
                if (this.logicalHandlers.get(n).handleMessage(contextHolder.getLMC())) continue;
                if (bl) {
                    contextHolder.getLMC().put("javax.xml.ws.handler.message.outbound", true);
                    this.callLogicalHandleMessage(contextHolder, n + 1, this.logicalHandlers.size() - 1);
                    this.callProtocolHandleMessage(contextHolder, 0, this.soapHandlers.size() - 1);
                }
                if (requestOrResponse == RequestOrResponse.RESPONSE) {
                    this.closeHandlersClient(contextHolder);
                } else {
                    this.closeLogicalHandlers(contextHolder, n, this.logicalHandlers.size() - 1);
                    this.closeProtocolHandlers(contextHolder, 0, this.soapHandlers.size() - 1);
                }
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException4;
            logger.log(Level.FINER, "exception in handler chain", runtimeException);
            if (bl && runtimeException instanceof ProtocolException) {
                contextHolder.getLMC().put("javax.xml.ws.handler.message.outbound", true);
                this.insertFaultMessage(contextHolder, (ProtocolException)runtimeException);
                try {
                    if (n == this.logicalHandlers.size() - 1 || this.callLogicalHandleFault(contextHolder, n + 1, this.logicalHandlers.size() - 1)) {
                        this.callProtocolHandleFault(contextHolder, 0, this.soapHandlers.size() - 1);
                    }
                }
                catch (ProtocolException protocolException) {
                    this.addIgnoreFaultProperty(contextHolder);
                    runtimeException4 = protocolException;
                }
                catch (RuntimeException runtimeException5) {
                    runtimeException4 = runtimeException5;
                }
            }
            if (requestOrResponse == RequestOrResponse.RESPONSE) {
                this.closeHandlersClient(contextHolder);
            } else {
                this.closeLogicalHandlers(contextHolder, n, this.logicalHandlers.size() - 1);
                this.closeProtocolHandlers(contextHolder, 0, this.soapHandlers.size() - 1);
            }
            throw runtimeException4;
        }
        return true;
    }

    private boolean callProtocolHandlers(ContextHolder contextHolder, Direction direction, RequestOrResponse requestOrResponse, boolean bl) {
        int n;
        if (direction == Direction.OUTBOUND) {
            int n2;
            try {
                for (n2 = 0; n2 < this.soapHandlers.size(); ++n2) {
                    if (this.soapHandlers.get(n2).handleMessage(contextHolder.getSMC())) continue;
                    if (bl) {
                        contextHolder.getSMC().put("javax.xml.ws.handler.message.outbound", false);
                        if (n2 > 0) {
                            this.callProtocolHandleMessage(contextHolder, n2 - 1, 0);
                        }
                        this.callLogicalHandleMessage(contextHolder, this.logicalHandlers.size() - 1, 0);
                    }
                    if (requestOrResponse == RequestOrResponse.RESPONSE) {
                        this.closeHandlersServer(contextHolder);
                    } else {
                        this.closeProtocolHandlers(contextHolder, n2, 0);
                        this.closeLogicalHandlers(contextHolder, this.logicalHandlers.size() - 1, 0);
                    }
                    return false;
                }
            }
            catch (RuntimeException runtimeException) {
                RuntimeException runtimeException2;
                logger.log(Level.FINER, "exception in handler chain", runtimeException);
                if (bl && runtimeException instanceof ProtocolException) {
                    contextHolder.getSMC().put("javax.xml.ws.handler.message.outbound", false);
                    this.insertFaultMessage(contextHolder, (ProtocolException)runtimeException);
                    try {
                        if (n2 == 0 || this.callProtocolHandleFault(contextHolder, n2 - 1, 0)) {
                            this.callLogicalHandleFault(contextHolder, this.logicalHandlers.size() - 1, 0);
                        }
                    }
                    catch (ProtocolException protocolException) {
                        this.addIgnoreFaultProperty(contextHolder);
                        runtimeException2 = protocolException;
                    }
                    catch (RuntimeException runtimeException3) {
                        runtimeException2 = runtimeException3;
                    }
                }
                if (requestOrResponse == RequestOrResponse.RESPONSE) {
                    this.closeHandlersServer(contextHolder);
                } else {
                    this.closeProtocolHandlers(contextHolder, n2, 0);
                    this.closeLogicalHandlers(contextHolder, this.logicalHandlers.size() - 1, 0);
                }
                throw runtimeException2;
            }
        }
        try {
            for (n = this.soapHandlers.size() - 1; n >= 0; --n) {
                if (this.soapHandlers.get(n).handleMessage(contextHolder.getSMC())) continue;
                contextHolder.getSMC().put("javax.xml.ws.handler.message.outbound", true);
                if (bl && n != this.soapHandlers.size() - 1) {
                    this.callProtocolHandleMessage(contextHolder, n + 1, this.soapHandlers.size() - 1);
                }
                if (requestOrResponse == RequestOrResponse.RESPONSE) {
                    this.closeHandlersClient(contextHolder);
                } else {
                    this.closeProtocolHandlers(contextHolder, n, this.soapHandlers.size() - 1);
                }
                return false;
            }
        }
        catch (RuntimeException runtimeException) {
            RuntimeException runtimeException4;
            logger.log(Level.FINER, "exception in handler chain", runtimeException);
            if (bl && runtimeException instanceof ProtocolException) {
                contextHolder.getSMC().put("javax.xml.ws.handler.message.outbound", true);
                this.insertFaultMessage(contextHolder, (ProtocolException)runtimeException);
                try {
                    if (n < this.soapHandlers.size() - 1) {
                        this.callProtocolHandleFault(contextHolder, n + 1, this.soapHandlers.size() - 1);
                    }
                }
                catch (ProtocolException protocolException) {
                    this.addIgnoreFaultProperty(contextHolder);
                    runtimeException4 = protocolException;
                }
                catch (RuntimeException runtimeException5) {
                    runtimeException4 = runtimeException5;
                }
            }
            if (requestOrResponse == RequestOrResponse.RESPONSE) {
                this.closeHandlersClient(contextHolder);
            } else {
                this.closeProtocolHandlers(contextHolder, n, this.soapHandlers.size() - 1);
            }
            throw runtimeException4;
        }
        return true;
    }

    private void callLogicalHandleMessage(ContextHolder contextHolder, int n, int n2) {
        if (this.logicalHandlers.isEmpty() || n == -1 || n == this.logicalHandlers.size()) {
            return;
        }
        this.callGenericHandleMessage(this.logicalHandlers, contextHolder.getLMC(), n, n2);
    }

    private void callProtocolHandleMessage(ContextHolder contextHolder, int n, int n2) {
        if (this.soapHandlers.isEmpty()) {
            return;
        }
        this.callGenericHandleMessage(this.soapHandlers, contextHolder.getSMC(), n, n2);
    }

    private <C extends MessageContext> void callGenericHandleMessage(List<? extends Handler> list, C c, int n, int n2) {
        int n3;
        if (list.isEmpty()) {
            return;
        }
        if (n > n2) {
            try {
                for (n3 = n; n3 >= n2; --n3) {
                    if (list.get(n3).handleMessage(c)) continue;
                    return;
                }
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.FINER, "exception in handler chain", runtimeException);
                throw runtimeException;
            }
        }
        try {
            while (n3 <= n2) {
                if (!list.get(n3).handleMessage(c)) {
                    return;
                }
                ++n3;
            }
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.FINER, "exception in handler chain", runtimeException);
            throw runtimeException;
        }
    }

    private boolean callLogicalHandleFault(ContextHolder contextHolder, int n, int n2) {
        return this.callGenericHandleFault(this.logicalHandlers, contextHolder.getLMC(), n, n2);
    }

    private boolean callProtocolHandleFault(ContextHolder contextHolder, int n, int n2) {
        return this.callGenericHandleFault(this.soapHandlers, contextHolder.getSMC(), n, n2);
    }

    private <C extends MessageContext> boolean callGenericHandleFault(List<? extends Handler> list, C c, int n, int n2) {
        int n3;
        if (list.isEmpty()) {
            return true;
        }
        if (n > n2) {
            try {
                for (n3 = n; n3 >= n2; --n3) {
                    if (list.get(n3).handleFault(c)) continue;
                    return false;
                }
            }
            catch (RuntimeException runtimeException) {
                logger.log(Level.FINER, "exception in handler chain", runtimeException);
                throw runtimeException;
            }
        }
        try {
            while (n3 <= n2) {
                if (!list.get(n3).handleFault(c)) {
                    return false;
                }
                ++n3;
            }
        }
        catch (RuntimeException runtimeException) {
            logger.log(Level.FINER, "exception in handler chain", runtimeException);
            throw runtimeException;
        }
        return true;
    }

    private void closeHandlersClient(ContextHolder contextHolder) {
        this.closeProtocolHandlers(contextHolder, this.soapHandlers.size() - 1, 0);
        this.closeLogicalHandlers(contextHolder, this.logicalHandlers.size() - 1, 0);
    }

    private void closeHandlersServer(ContextHolder contextHolder) {
        this.closeLogicalHandlers(contextHolder, 0, this.logicalHandlers.size() - 1);
        this.closeProtocolHandlers(contextHolder, 0, this.soapHandlers.size() - 1);
    }

    public void forceCloseHandlersOnServer(SOAPHandlerContext sOAPHandlerContext) {
        ContextHolder contextHolder = new ContextHolder(sOAPHandlerContext);
        contextHolder.getSMC().put("javax.xml.ws.handler.message.outbound", false);
        ((SOAPMessageContextImpl)contextHolder.getSMC()).setRoles(this.getRoles());
        this.closeHandlersServer(contextHolder);
    }

    public void forceCloseHandlersOnClient(SOAPHandlerContext sOAPHandlerContext) {
        ContextHolder contextHolder = new ContextHolder(sOAPHandlerContext);
        contextHolder.getSMC().put("javax.xml.ws.handler.message.outbound", false);
        ((SOAPMessageContextImpl)contextHolder.getSMC()).setRoles(this.getRoles());
        this.closeHandlersClient(contextHolder);
    }

    public void forceCloseHandlersOnServer(XMLHandlerContext xMLHandlerContext) {
        ContextHolder contextHolder = new ContextHolder(xMLHandlerContext);
        contextHolder.getLMC().put("javax.xml.ws.handler.message.outbound", false);
        this.closeHandlersServer(contextHolder);
    }

    public void forceCloseHandlersOnClient(XMLHandlerContext xMLHandlerContext) {
        ContextHolder contextHolder = new ContextHolder(xMLHandlerContext);
        contextHolder.getLMC().put("javax.xml.ws.handler.message.outbound", false);
        this.closeHandlersClient(contextHolder);
    }

    private void closeProtocolHandlers(ContextHolder contextHolder, int n, int n2) {
        this.closeGenericHandlers(this.soapHandlers, contextHolder.getSMC(), n, n2);
    }

    private void closeLogicalHandlers(ContextHolder contextHolder, int n, int n2) {
        this.closeGenericHandlers(this.logicalHandlers, contextHolder.getLMC(), n, n2);
    }

    private void closeGenericHandlers(List<? extends Handler> list, MessageContext messageContext, int n, int n2) {
        if (list.isEmpty()) {
            return;
        }
        if (n > n2) {
            for (int i = n; i >= n2; --i) {
                try {
                    list.get(i).close(messageContext);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.INFO, "Exception ignored during close", runtimeException);
                }
            }
        } else {
            for (int i = n; i <= n2; ++i) {
                try {
                    list.get(i).close(messageContext);
                    continue;
                }
                catch (RuntimeException runtimeException) {
                    logger.log(Level.INFO, "Exception ignored during close", runtimeException);
                }
            }
        }
    }

    static class ContextHolder {
        boolean logicalOnly;
        SOAPHandlerContext context;
        XMLHandlerContext xmlContext;

        ContextHolder(SOAPHandlerContext sOAPHandlerContext) {
            this.context = sOAPHandlerContext;
            this.logicalOnly = false;
        }

        ContextHolder(XMLHandlerContext xMLHandlerContext) {
            this.xmlContext = xMLHandlerContext;
            this.logicalOnly = true;
        }

        LogicalMessageContext getLMC() {
            return this.logicalOnly ? this.xmlContext.getLogicalMessageContext() : this.context.getLogicalMessageContext();
        }

        SOAPMessageContext getSMC() {
            return this.logicalOnly ? null : this.context.getSOAPMessageContext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        OUTBOUND,
        INBOUND;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RequestOrResponse {
        REQUEST,
        RESPONSE;

    }
}

