/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import com.sun.org.apache.xml.internal.security.algorithms.MessageDigestAlgorithm;
import java.io.ByteArrayOutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DigesterOutputStream
extends ByteArrayOutputStream {
    final MessageDigestAlgorithm mda;
    static Logger log = Logger.getLogger(DigesterOutputStream.class.getName());

    public DigesterOutputStream(MessageDigestAlgorithm messageDigestAlgorithm) {
        this.mda = messageDigestAlgorithm;
    }

    public void write(byte[] byArray) {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) {
        this.mda.update((byte)n);
    }

    public void write(byte[] byArray, int n, int n2) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Pre-digested input:");
            StringBuffer stringBuffer = new StringBuffer(n2);
            for (int i = n; i < n + n2; ++i) {
                stringBuffer.append((char)byArray[i]);
            }
            log.log(Level.FINE, stringBuffer.toString());
        }
        this.mda.update(byArray, n, n2);
    }

    public byte[] getDigestValue() {
        return this.mda.digest();
    }
}

