/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.namespace;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.namespace.ObjectNameRouter;
import com.sun.jmx.namespace.RoutingMBeanServerConnection;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.namespace.JMXNamespaces;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RoutingProxy<T extends MBeanServerConnection>
extends RoutingMBeanServerConnection<T> {
    private static final Logger LOG = JmxProperties.NAMESPACE_LOGGER;
    private final T source;
    private final String sourceNs;
    private final String targetNs;
    private final ObjectName handlerName;
    private final ObjectNameRouter router;
    private volatile String defaultDomain = null;

    protected RoutingProxy(T t, String string, String string2, boolean bl) {
        if (t == null) {
            throw new IllegalArgumentException("null");
        }
        this.sourceNs = JMXNamespaces.normalizeNamespaceName(string);
        if (string.equals("")) {
            this.handlerName = null;
        } else {
            this.handlerName = JMXNamespaces.getNamespaceObjectName(this.sourceNs);
            if (bl) {
                try {
                    if (!t.isRegistered(this.handlerName)) {
                        InstanceNotFoundException instanceNotFoundException = new InstanceNotFoundException(this.handlerName);
                        throw new IllegalArgumentException(string + ": no such name space", instanceNotFoundException);
                    }
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("source stale: " + iOException, iOException);
                }
            }
        }
        this.source = t;
        this.targetNs = string2 == null ? "" : JMXNamespaces.normalizeNamespaceName(string2);
        this.router = new ObjectNameRouter(this.targetNs, this.sourceNs);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.finer("RoutingProxy for " + this.sourceNs + " created");
        }
    }

    @Override
    public T source() {
        return this.source;
    }

    @Override
    public ObjectName toSource(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        if (objectName.getDomain().equals("") && this.targetNs.equals("")) {
            try {
                if (this.defaultDomain == null) {
                    this.defaultDomain = this.getDefaultDomain();
                }
            }
            catch (Exception exception) {
                LOG.log(Level.FINEST, "Failed to get default domain", exception);
            }
            if (this.defaultDomain != null) {
                objectName = objectName.withDomain(this.defaultDomain);
            }
        }
        return this.router.toSourceContext(objectName, true);
    }

    @Override
    protected ObjectName newSourceMBeanName(ObjectName objectName) throws MBeanRegistrationException {
        if (objectName != null) {
            return super.newSourceMBeanName(objectName);
        }
        if (this.sourceNs.equals("")) {
            return null;
        }
        throw new MBeanRegistrationException(new IllegalArgumentException("Can't use null ObjectName with namespaces"));
    }

    @Override
    public ObjectName toTarget(ObjectName objectName) {
        if (objectName == null) {
            return null;
        }
        return this.router.toTargetContext(objectName, false);
    }

    private Object getAttributeFromHandler(String string) throws IOException {
        try {
            return this.source().getAttribute(this.handlerName, string);
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (MBeanException mBeanException) {
            throw new IOException("Failed to get " + string + ": " + mBeanException.getCause(), mBeanException.getCause());
        }
        catch (Exception exception) {
            throw new IOException("Failed to get " + string + ": " + exception, exception);
        }
    }

    @Override
    public Integer getMBeanCount() throws IOException {
        try {
            if (this.handlerName == null) {
                return this.source().getMBeanCount();
            }
            return (Integer)this.getAttributeFromHandler("MBeanCount");
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public String[] getDomains() throws IOException {
        try {
            if (this.handlerName == null) {
                return this.source().getDomains();
            }
            return (String[])this.getAttributeFromHandler("Domains");
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    @Override
    public String getDefaultDomain() throws IOException {
        try {
            this.defaultDomain = this.handlerName == null ? this.source().getDefaultDomain() : (String)this.getAttributeFromHandler("DefaultDomain");
            return this.defaultDomain;
        }
        catch (RuntimeException runtimeException) {
            throw this.makeCompliantRuntimeException(runtimeException);
        }
    }

    public String getSourceNamespace() {
        return this.sourceNs;
    }

    public String getTargetNamespace() {
        return this.targetNs;
    }

    public String toString() {
        return super.toString() + ", sourceNs=" + this.sourceNs + (this.targetNs.equals("") ? "" : " mounted on targetNs=" + this.targetNs);
    }

    static <T extends MBeanServerConnection, R extends RoutingProxy<T>> R cd(Class<R> clazz, RoutingProxyFactory<T, R> routingProxyFactory, T t, String string, boolean bl) {
        RoutingProxy routingProxy;
        String string2;
        if (t == null) {
            throw new IllegalArgumentException("null");
        }
        if (t.getClass().equals(clazz) && ((string2 = (routingProxy = (RoutingProxy)clazz.cast(t)).getTargetNamespace()) == null || string2.equals(""))) {
            String string3 = JMXNamespaces.concat(routingProxy.getSourceNamespace(), string);
            return routingProxyFactory.newInstance(routingProxy.source(), string3, "", bl);
        }
        return routingProxyFactory.newInstance(t, string, "", bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RoutingProxyFactory<T extends MBeanServerConnection, R extends RoutingProxy<T>> {
        public R newInstance(T var1, String var2, String var3, boolean var4);
    }
}

