/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding.soap;

import com.sun.xml.internal.ws.encoding.EncoderDecoderBase;
import com.sun.xml.internal.ws.encoding.jaxb.JAXBBridgeInfo;
import com.sun.xml.internal.ws.encoding.jaxb.RpcLitPayload;
import com.sun.xml.internal.ws.encoding.soap.SerializationException;
import com.sun.xml.internal.ws.encoding.soap.internal.AttachmentBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.HeaderBlock;
import com.sun.xml.internal.ws.encoding.soap.internal.InternalMessage;
import com.sun.xml.internal.ws.handler.HandlerContext;
import com.sun.xml.internal.ws.handler.MessageContextUtil;
import com.sun.xml.internal.ws.model.Parameter;
import com.sun.xml.internal.ws.model.ParameterBinding;
import com.sun.xml.internal.ws.model.RuntimeModel;
import com.sun.xml.internal.ws.model.WrapperParameter;
import com.sun.xml.internal.ws.model.soap.SOAPBinding;
import com.sun.xml.internal.ws.server.RuntimeContext;
import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Type;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.activation.DataHandler;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EncoderDecoder
extends EncoderDecoderBase {
    protected Object fillData(RuntimeContext runtimeContext, Parameter parameter, Object object, Object[] objectArray, SOAPBinding sOAPBinding, ParameterBinding parameterBinding) {
        if (parameter.isWrapperStyle()) {
            Object object2 = null;
            for (Parameter parameter2 : ((WrapperParameter)parameter).getWrapperChildren()) {
                QName qName = parameter2.getName();
                Object object3 = null;
                if (sOAPBinding.isDocLit()) {
                    object3 = super.getWrapperChildValue(runtimeContext, ((JAXBBridgeInfo)object).getValue(), qName.getNamespaceURI(), qName.getLocalPart());
                } else if (sOAPBinding.isRpcLit() && (object3 = this.getWrapperChildValue(runtimeContext, object, qName.getNamespaceURI(), qName.getLocalPart())) == null) {
                    object3 = this.setIfPrimitive(parameter2.getTypeReference().type);
                }
                if (parameter2.isResponse()) {
                    object2 = object3;
                    continue;
                }
                if (objectArray[parameter2.getIndex()] != null) {
                    Parameter.setHolderValue(objectArray[parameter2.getIndex()], object3);
                    continue;
                }
                objectArray[parameter2.getIndex()] = parameter2.createHolderValue(object3);
            }
            return object2;
        }
        if (!parameterBinding.isAttachment()) {
            if (parameterBinding.isUnbound()) {
                object = this.setIfPrimitive(parameter.getTypeReference().type);
            } else {
                Object object4 = object = object != null ? ((JAXBBridgeInfo)object).getValue() : null;
            }
        }
        if (parameter.isResponse()) {
            if (parameterBinding.isUnbound()) {
                return this.setIfPrimitive(parameter.getTypeReference().type);
            }
            return object;
        }
        if (objectArray[parameter.getIndex()] != null) {
            Parameter.setHolderValue(objectArray[parameter.getIndex()], object);
        } else {
            objectArray[parameter.getIndex()] = parameter.createHolderValue(object);
        }
        return null;
    }

    private Object setIfPrimitive(Type type) {
        Class clazz;
        if (type instanceof Class && (clazz = (Class)type).isPrimitive()) {
            if (clazz.getName().equals(Boolean.TYPE.getName())) {
                return false;
            }
            return 0;
        }
        return null;
    }

    protected Object createPayload(RuntimeContext runtimeContext, Parameter parameter, Object[] objectArray, Object object, SOAPBinding sOAPBinding, ParameterBinding parameterBinding) {
        if (parameterBinding.isAttachment()) {
            Object object2 = null;
            object2 = parameter.isResponse() ? object : parameter.getHolderValue(objectArray[parameter.getIndex()]);
            return object2;
        }
        if (sOAPBinding.isRpcLit() && parameterBinding.isBody()) {
            return this.createRpcLitPayload(runtimeContext, (WrapperParameter)parameter, objectArray, object);
        }
        Object object3 = this.createDocLitPayloadValue(runtimeContext, parameter, objectArray, object);
        RuntimeModel runtimeModel = runtimeContext.getModel();
        return new JAXBBridgeInfo(runtimeModel.getBridge(parameter.getTypeReference()), object3);
    }

    @Override
    protected Object getWrapperChildValue(RuntimeContext runtimeContext, Object object, String string, String string2) {
        RpcLitPayload rpcLitPayload = (RpcLitPayload)object;
        JAXBBridgeInfo jAXBBridgeInfo = rpcLitPayload.getBridgeParameterByName(string2);
        if (jAXBBridgeInfo != null) {
            return jAXBBridgeInfo.getValue();
        }
        return null;
    }

    private Object createDocLitPayloadValue(RuntimeContext runtimeContext, Parameter parameter, Object[] objectArray, Object object) {
        if (parameter.isWrapperStyle()) {
            return this.createJAXBBeanPayload(runtimeContext, (WrapperParameter)parameter, objectArray, object);
        }
        return this.getBarePayload(parameter, objectArray, object);
    }

    protected HeaderBlock getHeaderBlock(QName qName, List<HeaderBlock> list) {
        for (HeaderBlock headerBlock : list) {
            if (!qName.equals(headerBlock.getName())) continue;
            return headerBlock;
        }
        return null;
    }

    private Object getBarePayload(Parameter parameter, Object[] objectArray, Object object) {
        Object object2 = null;
        object2 = parameter.isResponse() ? object : parameter.getHolderValue(objectArray[parameter.getIndex()]);
        return object2;
    }

    private Object createJAXBBeanPayload(RuntimeContext runtimeContext, WrapperParameter wrapperParameter, Object[] objectArray, Object object) {
        Class clazz = (Class)wrapperParameter.getTypeReference().type;
        try {
            Object t = clazz.newInstance();
            for (Parameter parameter : wrapperParameter.getWrapperChildren()) {
                Object object2 = parameter.isResponse() ? object : parameter.getHolderValue(objectArray[parameter.getIndex()]);
                QName qName = parameter.getName();
                this.setWrapperChildValue(runtimeContext, t, object2, qName.getNamespaceURI(), qName.getLocalPart());
            }
            return t;
        }
        catch (Exception exception) {
            throw new SerializationException(exception);
        }
    }

    private Object createRpcLitPayload(RuntimeContext runtimeContext, WrapperParameter wrapperParameter, Object[] objectArray, Object object) {
        RpcLitPayload rpcLitPayload = new RpcLitPayload(wrapperParameter.getName());
        for (Parameter parameter : wrapperParameter.getWrapperChildren()) {
            if (parameter.getBinding().isUnbound()) continue;
            Object object2 = null;
            object2 = parameter.isResponse() ? object : parameter.getHolderValue(objectArray[parameter.getIndex()]);
            this.checkRPCLitNullableParameter(parameter, object2);
            RuntimeModel runtimeModel = runtimeContext.getModel();
            JAXBBridgeInfo jAXBBridgeInfo = new JAXBBridgeInfo(runtimeModel.getBridge(parameter.getTypeReference()), object2);
            rpcLitPayload.addParameter(jAXBBridgeInfo);
        }
        return rpcLitPayload;
    }

    protected Object getAttachment(RuntimeContext runtimeContext, Map<String, AttachmentBlock> map, Parameter parameter, ParameterBinding parameterBinding) {
        try {
            for (Map.Entry<String, AttachmentBlock> entry : map.entrySet()) {
                AttachmentBlock attachmentBlock = entry.getValue();
                String string = attachmentBlock.getWSDLPartName();
                if (string == null || !string.equals(parameter.getPartName()) && !string.equals("<" + parameter.getPartName())) continue;
                Class clazz = (Class)parameter.getTypeReference().type;
                if (DataHandler.class.isAssignableFrom(clazz)) {
                    return attachmentBlock.asDataHandler();
                }
                if (byte[].class == clazz) {
                    return attachmentBlock.asByteArray();
                }
                if (Source.class.isAssignableFrom(clazz)) {
                    return attachmentBlock.asSource();
                }
                if (Image.class.isAssignableFrom(clazz)) {
                    return attachmentBlock.asImage();
                }
                if (InputStream.class == clazz) {
                    return attachmentBlock.asDataHandler().getInputStream();
                }
                if (!this.isXMLMimeType(parameterBinding.getMimeType())) continue;
                JAXBBridgeInfo jAXBBridgeInfo = (JAXBBridgeInfo)runtimeContext.getDecoderInfo(parameter.getName());
                attachmentBlock.deserialize(runtimeContext.getBridgeContext(), jAXBBridgeInfo);
                return jAXBBridgeInfo.getValue();
            }
            return null;
        }
        catch (IOException iOException) {
            throw new SerializationException(iOException);
        }
    }

    protected void addAttachmentPart(RuntimeContext runtimeContext, InternalMessage internalMessage, Object object, Parameter parameter) {
        MessageContext messageContext;
        String string;
        if (object == null) {
            return;
        }
        RuntimeModel runtimeModel = runtimeContext.getModel();
        String string2 = parameter.getBinding().getMimeType();
        try {
            string = URLEncoder.encode(parameter.getPartName(), "UTF-8") + '=' + UUID.randomUUID() + "@jaxws.sun.com";
            string = "<" + string + ">";
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SerializationException(unsupportedEncodingException);
        }
        AttachmentBlock attachmentBlock = object instanceof DataHandler ? AttachmentBlock.fromDataHandler(string, (DataHandler)object) : (object instanceof Source ? AttachmentBlock.fromDataHandler(string, new DataHandler(object, string2)) : (object instanceof byte[] ? AttachmentBlock.fromByteArray(string, (byte[])object, string2) : (this.isXMLMimeType(string2) ? AttachmentBlock.fromJAXB(string, new JAXBBridgeInfo(runtimeModel.getBridge(parameter.getTypeReference()), object), runtimeContext, string2) : AttachmentBlock.fromDataHandler(string, new DataHandler(object, string2)))));
        HandlerContext handlerContext = runtimeContext.getHandlerContext();
        if (handlerContext != null && (messageContext = handlerContext.getMessageContext()) != null) {
            MessageContextUtil.addMessageAttachment(messageContext, attachmentBlock.getId(), attachmentBlock.asDataHandler());
        }
        internalMessage.addAttachment(attachmentBlock);
    }

    protected void copyAttachmentProperty(Map<String, Object> map, InternalMessage internalMessage) {
        if (map == null) {
            return;
        }
        Map map2 = (Map)map.get("javax.xml.ws.binding.attachments.outbound");
        if (map2 == null) {
            return;
        }
        for (Map.Entry entry : map2.entrySet()) {
            internalMessage.addAttachment(AttachmentBlock.fromDataHandler((String)entry.getKey(), (DataHandler)entry.getValue()));
        }
    }

    private boolean isXMLMimeType(String string) {
        return string.equals("text/xml") || string.equals("application/xml");
    }

    void checkRPCLitNullableParameter(Parameter parameter, Object object) {
        if (object == null) {
            throw new WebServiceException("Method Parameter: " + parameter.getName() + " cannot be null. This is BP 1.1 R2211 violation.");
        }
    }
}

