/*	$NetBSD$	*/

/*-
 * Copyright (c) 1998 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Christos Zoulas.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *        This product includes software developed by the NetBSD
 *        Foundation, Inc. and its contributors.
 * 4. Neither the name of The NetBSD Foundation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef	_BSD_MACHINE_ANSI_H_
#define	_BSD_MACHINE_ANSI_H_

/*
 * Types which are fundamental to the implementation and may appear in
 * more than one standard header are defined here.  Standard headers
 * then use:
 *	#ifdef	_BSD_SIZE_T_
 *	typedef	_BSD_SIZE_T_ size_t;
 *	#undef	_BSD_SIZE_T_
 *	#endif
 *
 * Thanks, ANSI!
 */
#ifndef _BSD_CLOCK_T_
#define	_BSD_CLOCK_T_	long			/* clock() */
#endif
#ifndef _BSD_PTRDIFF_T_
#define	_BSD_PTRDIFF_T_	int			/* ptr1 - ptr2 */
#endif
#ifndef _BSD_SIZE_T_
#if 0
#define	_BSD_SIZE_T_	long unsigned int	/* sizeof() */
#else
#define	_BSD_SIZE_T_	unsigned int		/* sizeof() */
#endif
#endif
#ifndef _BSD_SSIZE_T_
#define	_BSD_SSIZE_T_	int			/* byte count or error */
#endif
#ifndef _BSD_TIME_T_
#define	_BSD_TIME_T_	long			/* time() */
#endif
#ifndef _BSD_TIMER_T_
#define	_BSD_TIMER_T_	int			/* timer_t */
#endif
#ifndef _BSD_CLOCKID_T_
#define	_BSD_CLOCKID_T_	int			/* clockid_t */
#endif
#ifndef _BSD_USECONDS_T_
#define	_BSD_USECONDS_T_	unsigned int	/* useconds_t */
#endif
#ifndef _BSD_SUSECONDS_T_
#define	_BSD_SUSECONDS_T_	int		/* suseconds_t */
#endif
#ifndef _BSD_VA_LIST_
#define	_BSD_VA_LIST_	char *			/* va_list */
#endif
#ifndef __linux__
#ifndef _BSD_WCHAR_T_
#define	_BSD_WCHAR_T_	unsigned short		/* wchar_t */
#endif
#else
#ifndef _WCHAR_T_DEFINED_
#ifndef _BSD_WCHAR_T_
#define _BSD_WCHAR_T_ int
typedef _BSD_WCHAR_T_ wchar_t;
#define _WCHAR_T_DEFINED_
#endif
#endif

#ifndef _BSD___LONG_DOUBLE_T_
#define _BSD___LONG_DOUBLE_T_ long double
typedef _BSD___LONG_DOUBLE_T_  __long_double_t;
#endif
#ifndef _BSD___PTR_T_
#define _BSD___PTR_T_ void *
#if 0
typedef _BSD___PTR_T_ __ptr_t;
#else
#define __ptr_t void *
#endif
#endif
typedef _BSD_PTRDIFF_T_ ptrdiff_t;
#define _PTRDIFF_T
#endif


#define __ARCHITECTURE__ "i386"
#define MACHINE "i386"
#define MACHINE_ARCH "i386"

#endif	/* _BSD_MACHINE_ANSI_H_ */
