/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.net.ProtocolFamily;
import java.net.SocketOption;
import java.net.StandardProtocolFamily;
import java.net.StandardSocketOption;
import java.util.HashMap;
import java.util.Map;
import sun.nio.ch.ExtendedSocketOption;
import sun.nio.ch.Net;
import sun.nio.ch.OptionKey;

class SocketOptionRegistry {
    private SocketOptionRegistry() {
    }

    public static OptionKey findOption(SocketOption socketOption, ProtocolFamily protocolFamily) {
        RegistryKey registryKey = new RegistryKey(socketOption, protocolFamily);
        return LazyInitialization.options.get(registryKey);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LazyInitialization {
        static final Map<RegistryKey, OptionKey> options = LazyInitialization.options();

        private LazyInitialization() {
        }

        private static Map<RegistryKey, OptionKey> options() {
            HashMap<RegistryKey, OptionKey> hashMap = new HashMap<RegistryKey, OptionKey>();
            hashMap.put(new RegistryKey(StandardSocketOption.SO_BROADCAST, Net.UNSPEC), new OptionKey(65535, 32));
            hashMap.put(new RegistryKey(StandardSocketOption.SO_KEEPALIVE, Net.UNSPEC), new OptionKey(65535, 8));
            hashMap.put(new RegistryKey(StandardSocketOption.SO_LINGER, Net.UNSPEC), new OptionKey(65535, 128));
            hashMap.put(new RegistryKey(StandardSocketOption.SO_SNDBUF, Net.UNSPEC), new OptionKey(65535, 4097));
            hashMap.put(new RegistryKey(StandardSocketOption.SO_RCVBUF, Net.UNSPEC), new OptionKey(65535, 4098));
            hashMap.put(new RegistryKey(StandardSocketOption.SO_REUSEADDR, Net.UNSPEC), new OptionKey(65535, 4));
            hashMap.put(new RegistryKey(StandardSocketOption.TCP_NODELAY, Net.UNSPEC), new OptionKey(6, 1));
            hashMap.put(new RegistryKey(StandardSocketOption.IP_TOS, StandardProtocolFamily.INET), new OptionKey(0, 3));
            hashMap.put(new RegistryKey(StandardSocketOption.IP_MULTICAST_IF, StandardProtocolFamily.INET), new OptionKey(0, 9));
            hashMap.put(new RegistryKey(StandardSocketOption.IP_MULTICAST_TTL, StandardProtocolFamily.INET), new OptionKey(0, 10));
            hashMap.put(new RegistryKey(StandardSocketOption.IP_MULTICAST_LOOP, StandardProtocolFamily.INET), new OptionKey(0, 11));
            hashMap.put(new RegistryKey(StandardSocketOption.IP_MULTICAST_IF, StandardProtocolFamily.INET6), new OptionKey(41, 9));
            hashMap.put(new RegistryKey(StandardSocketOption.IP_MULTICAST_TTL, StandardProtocolFamily.INET6), new OptionKey(41, 10));
            hashMap.put(new RegistryKey(StandardSocketOption.IP_MULTICAST_LOOP, StandardProtocolFamily.INET6), new OptionKey(41, 11));
            hashMap.put(new RegistryKey(ExtendedSocketOption.SO_OOBINLINE, Net.UNSPEC), new OptionKey(65535, 256));
            return hashMap;
        }
    }

    private static class RegistryKey {
        private final SocketOption name;
        private final ProtocolFamily family;

        RegistryKey(SocketOption socketOption, ProtocolFamily protocolFamily) {
            this.name = socketOption;
            this.family = protocolFamily;
        }

        public int hashCode() {
            return this.name.hashCode() + this.family.hashCode();
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof RegistryKey)) {
                return false;
            }
            RegistryKey registryKey = (RegistryKey)object;
            if (this.name != registryKey.name) {
                return false;
            }
            return this.family == registryKey.family;
        }
    }
}

