/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.client;

import com.sun.xml.internal.ws.client.BindingProviderProperties;
import com.sun.xml.internal.ws.client.PortInfoBase;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ContextMap
extends HashMap<String, Object>
implements BindingProviderProperties {
    private static final Set<String> KNOWN_PROPERTIES;
    private static final HashMap<String, Class> _allowedClass;
    protected BindingProvider _owner;
    protected PortInfoBase portInfo;

    public abstract ContextMap copy();

    public ContextMap(PortInfoBase portInfoBase, BindingProvider bindingProvider) {
        this._owner = bindingProvider;
        if (portInfoBase != null) {
            this.portInfo = portInfoBase;
        }
    }

    public ContextMap(ContextMap contextMap) {
        super(contextMap);
        this._owner = contextMap._owner;
    }

    public ContextMap(BindingProvider bindingProvider) {
        this(null, bindingProvider);
    }

    boolean doValidation() {
        return this._owner != null;
    }

    @Override
    public Object put(String string, Object object) {
        if (this.doValidation()) {
            this.validateProperty(string, object, true);
            return super.put(string, object);
        }
        return null;
    }

    public Object get(String string) {
        if (this.doValidation()) {
            this.validateProperty(string, null, false);
            return super.get(string);
        }
        return null;
    }

    public Iterator<String> getPropertyNames() {
        return this.keySet().iterator();
    }

    public Object remove(String string) {
        if (this.doValidation()) {
            this.validateProperty(string, null, false);
            return super.remove(string);
        }
        return null;
    }

    private boolean isAllowedValue(String string, Object object) {
        if (string.equals("javax.xml.ws.http.request.pathinfo") || string.equals("javax.xml.ws.http.request.querystring")) {
            return true;
        }
        return object != null;
    }

    private boolean isAllowedClass(String string, Object object) {
        Class clazz = _allowedClass.get(string);
        if (clazz != null) {
            return clazz.isInstance(object);
        }
        return true;
    }

    private void validateProperty(String string, Object object, boolean bl) {
        if (string == null) {
            throw new WebServiceException(string + " is a User-defined property - property name can not be null. ", new IllegalArgumentException("Name of property is null.  This is an invalid property name. "));
        }
        if (bl) {
            if (!this.isAllowedClass(string, object)) {
                throw new WebServiceException(object + " is Not Allowed Class for property " + string, new IllegalArgumentException("Not Allowed Class for property"));
            }
            if (!this.isAllowedValue(string, object)) {
                throw new WebServiceException(object + " is Not Allowed Value for property " + string, new IllegalArgumentException("Not Allowed value"));
            }
        }
    }

    static {
        _allowedClass = new HashMap();
        _allowedClass.put("javax.xml.ws.security.auth.username", String.class);
        _allowedClass.put("javax.xml.ws.security.auth.password", String.class);
        _allowedClass.put("javax.xml.ws.service.endpoint.address", String.class);
        _allowedClass.put("javax.xml.ws.session.maintain", Boolean.class);
        _allowedClass.put("javax.xml.ws.soap.http.soapaction.use", Boolean.class);
        _allowedClass.put("javax.xml.ws.soap.http.soapaction.uri", String.class);
        _allowedClass.put("com.sun.xml.internal.ws.jaxbcontext", JAXBContext.class);
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("javax.xml.ws.security.auth.username");
        hashSet.add("javax.xml.ws.security.auth.password");
        hashSet.add("javax.xml.ws.service.endpoint.address");
        hashSet.add("javax.xml.ws.session.maintain");
        hashSet.add("javax.xml.ws.soap.http.soapaction.use");
        hashSet.add("javax.xml.ws.soap.http.soapaction.uri");
        hashSet.add("com.sun.xml.internal.ws.jaxbcontext");
        hashSet.add("accept.encoding");
        hashSet.add("com.sun.xml.internal.ws.client.ClientTransportFactory");
        hashSet.add("com.sun.xml.internal.ws.client.handle");
        hashSet.add("com.sun.xml.internal.ws.client.handle");
        hashSet.add("com.sun.xml.internal.ws.client.http.CookieJar");
        hashSet.add("com.sun.xml.internal.ws.server.OneWayOperation");
        hashSet.add("com.sun.xml.internal.ws.client.http.HTTPStatusCode");
        hashSet.add("com.sun.xml.internal.ws.client.http.HostnameVerificationProperty");
        hashSet.add("com.sun.xml.internal.ws.client.http.RedirectRequestProperty");
        hashSet.add("com.sun.xml.internal.ws.security.context");
        hashSet.add("com.sun.xml.internal.ws.attachment.SetAttachmentContext");
        hashSet.add("com.sun.xml.internal.ws.attachment.GetAttachmentContext");
        hashSet.add("javax.xml.ws.binding.attachments.inbound");
        hashSet.add("javax.xml.ws.binding.attachments.outbound");
        hashSet.add("javax.xml.ws.wsdl.description");
        hashSet.add("javax.xml.ws.wsdl.interface");
        hashSet.add("javax.xml.ws.wsdl.operation");
        hashSet.add("javax.xml.ws.wsdl.port");
        hashSet.add("javax.xml.ws.wsdl.service");
        hashSet.add("javax.xml.ws.http.request.method");
        hashSet.add("javax.xml.ws.http.request.headers");
        hashSet.add("javax.xml.ws.http.response.code");
        hashSet.add("javax.xml.ws.http.response.headers");
        hashSet.add("javax.xml.ws.http.request.pathinfo");
        hashSet.add("javax.xml.ws.http.request.querystring");
        hashSet.add("com.sun.xml.ws.client.ContentNegotiation");
        hashSet.add("com.sun.xml.internal.ws.common.MtomThresholdValue");
        KNOWN_PROPERTIES = hashSet;
    }
}

