/*
 * Decompiled with CFR 0.152.
 */
package javax.management.relation;

import com.sun.jmx.defaults.JmxProperties;
import com.sun.jmx.mbeanserver.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.Attribute;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.relation.InvalidRelationIdException;
import javax.management.relation.InvalidRelationServiceException;
import javax.management.relation.InvalidRelationTypeException;
import javax.management.relation.InvalidRoleValueException;
import javax.management.relation.MBeanServerNotificationFilter;
import javax.management.relation.RelationNotFoundException;
import javax.management.relation.RelationNotification;
import javax.management.relation.RelationServiceMBean;
import javax.management.relation.RelationServiceNotRegisteredException;
import javax.management.relation.RelationSupport;
import javax.management.relation.RelationType;
import javax.management.relation.RelationTypeNotFoundException;
import javax.management.relation.RelationTypeSupport;
import javax.management.relation.Role;
import javax.management.relation.RoleInfo;
import javax.management.relation.RoleInfoNotFoundException;
import javax.management.relation.RoleList;
import javax.management.relation.RoleNotFoundException;
import javax.management.relation.RoleResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationService
extends NotificationBroadcasterSupport
implements RelationServiceMBean,
MBeanRegistration,
NotificationListener {
    private Map<String, Object> myRelId2ObjMap = new HashMap<String, Object>();
    private Map<String, String> myRelId2RelTypeMap = new HashMap<String, String>();
    private Map<ObjectName, String> myRelMBeanObjName2RelIdMap = new HashMap<ObjectName, String>();
    private Map<String, RelationType> myRelType2ObjMap = new HashMap<String, RelationType>();
    private Map<String, List<String>> myRelType2RelIdsMap = new HashMap<String, List<String>>();
    private final Map<ObjectName, Map<String, List<String>>> myRefedMBeanObjName2RelIdsMap = new HashMap<ObjectName, Map<String, List<String>>>();
    private boolean myPurgeFlag = true;
    private final AtomicLong atomicSeqNo = new AtomicLong();
    private ObjectName myObjName = null;
    private MBeanServer myMBeanServer = null;
    private MBeanServerNotificationFilter myUnregNtfFilter = null;
    private List<MBeanServerNotification> myUnregNtfList = new ArrayList<MBeanServerNotification>();

    public RelationService(boolean bl) {
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "RelationService");
        this.setPurgeFlag(bl);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "RelationService");
    }

    @Override
    public void isActive() throws RelationServiceNotRegisteredException {
        if (this.myMBeanServer == null) {
            String string = "Relation Service not registered in the MBean Server.";
            throw new RelationServiceNotRegisteredException(string);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws Exception {
        this.myMBeanServer = mBeanServer;
        this.myObjName = objectName;
        return objectName;
    }

    @Override
    public void postRegister(Boolean bl) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public boolean getPurgeFlag() {
        return this.myPurgeFlag;
    }

    @Override
    public void setPurgeFlag(boolean bl) {
        this.myPurgeFlag = bl;
    }

    @Override
    public void createRelationType(String string, RoleInfo[] roleInfoArray) throws IllegalArgumentException, InvalidRelationTypeException {
        if (string == null || roleInfoArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "createRelationType", string);
        RelationTypeSupport relationTypeSupport = new RelationTypeSupport(string, roleInfoArray);
        this.addRelationTypeInt(relationTypeSupport);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "createRelationType");
    }

    @Override
    public void addRelationType(RelationType relationType) throws IllegalArgumentException, InvalidRelationTypeException {
        if (relationType == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addRelationType");
        List<RoleInfo> list = relationType.getRoleInfos();
        if (list == null) {
            String string = "No role info provided.";
            throw new InvalidRelationTypeException(string);
        }
        RoleInfo[] roleInfoArray = new RoleInfo[list.size()];
        int n = 0;
        Iterator<RoleInfo> iterator = list.iterator();
        while (iterator.hasNext()) {
            RoleInfo roleInfo;
            roleInfoArray[n] = roleInfo = iterator.next();
            ++n;
        }
        RelationTypeSupport.checkRoleInfos(roleInfoArray);
        this.addRelationTypeInt(relationType);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addRelationType");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRelationTypeNames() {
        ArrayList<String> arrayList;
        Map<String, RelationType> map = this.myRelType2ObjMap;
        synchronized (map) {
            arrayList = new ArrayList<String>(this.myRelType2ObjMap.keySet());
        }
        return arrayList;
    }

    @Override
    public List<RoleInfo> getRoleInfos(String string) throws IllegalArgumentException, RelationTypeNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoleInfos", string);
        RelationType relationType = this.getRelationType(string);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoleInfos");
        return relationType.getRoleInfos();
    }

    @Override
    public RoleInfo getRoleInfo(String string, String string2) throws IllegalArgumentException, RelationTypeNotFoundException, RoleInfoNotFoundException {
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoleInfo", new Object[]{string, string2});
        RelationType relationType = this.getRelationType(string);
        RoleInfo roleInfo = relationType.getRoleInfo(string2);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoleInfo");
        return roleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRelationType(String string) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationTypeNotFoundException {
        this.isActive();
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "removeRelationType", string);
        RelationType relationType = this.getRelationType(string);
        ArrayList<String> arrayList = null;
        Object object = this.myRelType2RelIdsMap;
        synchronized (object) {
            List<String> object2 = this.myRelType2RelIdsMap.get(string);
            if (object2 != null) {
                arrayList = new ArrayList<String>(object2);
            }
        }
        object = this.myRelType2ObjMap;
        synchronized (object) {
            this.myRelType2ObjMap.remove(string);
        }
        object = this.myRelType2RelIdsMap;
        synchronized (object) {
            this.myRelType2RelIdsMap.remove(string);
        }
        if (arrayList != null) {
            for (String string2 : arrayList) {
                try {
                    this.removeRelation(string2);
                }
                catch (RelationNotFoundException relationNotFoundException) {
                    throw new RuntimeException(relationNotFoundException.getMessage());
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "removeRelationType");
    }

    @Override
    public void createRelation(String string, String string2, RoleList roleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        this.isActive();
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "createRelation", new Object[]{string, string2, roleList});
        RelationSupport relationSupport = new RelationSupport(string, this.myObjName, string2, roleList);
        this.addRelationInt(true, relationSupport, null, string, string2, roleList);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "createRelation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRelation(ObjectName objectName) throws IllegalArgumentException, RelationServiceNotRegisteredException, NoSuchMethodException, InvalidRelationIdException, InstanceNotFoundException, InvalidRelationServiceException, RelationTypeNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        RoleList roleList;
        String string;
        ObjectName objectName2;
        String string2;
        if (objectName == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addRelation", objectName);
        this.isActive();
        if (!this.myMBeanServer.isInstanceOf(objectName, "javax.management.relation.Relation")) {
            String string4 = "This MBean does not implement the Relation interface.";
            throw new NoSuchMethodException(string4);
        }
        try {
            string2 = (String)this.myMBeanServer.getAttribute(objectName, "RelationId");
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(attributeNotFoundException.getMessage());
        }
        if (string2 == null) {
            String string5 = "This MBean does not provide a relation id.";
            throw new InvalidRelationIdException(string5);
        }
        try {
            objectName2 = (ObjectName)this.myMBeanServer.getAttribute(objectName, "RelationServiceName");
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(attributeNotFoundException.getMessage());
        }
        boolean bl = false;
        if (objectName2 == null) {
            bl = true;
        } else if (!objectName2.equals(this.myObjName)) {
            bl = true;
        }
        if (bl) {
            String string6 = "The Relation Service referenced in the MBean is not the current one.";
            throw new InvalidRelationServiceException(string6);
        }
        try {
            string = (String)this.myMBeanServer.getAttribute(objectName, "RelationTypeName");
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(attributeNotFoundException.getMessage());
        }
        if (string == null) {
            String string7 = "No relation type provided.";
            throw new RelationTypeNotFoundException(string7);
        }
        try {
            roleList = (RoleList)this.myMBeanServer.invoke(objectName, "retrieveAllRoles", null, null);
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        this.addRelationInt(false, null, objectName, string2, string, roleList);
        Object object = this.myRelMBeanObjName2RelIdMap;
        synchronized (object) {
            this.myRelMBeanObjName2RelIdMap.put(objectName, string2);
        }
        try {
            this.myMBeanServer.setAttribute(objectName, new Attribute("RelationServiceManagementFlag", Boolean.TRUE));
        }
        catch (Exception exception) {
            // empty catch block
        }
        object = new ArrayList();
        object.add(objectName);
        this.updateUnregistrationListener((List<ObjectName>)object, null);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addRelation");
    }

    @Override
    public ObjectName isRelationMBean(String string) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "isRelationMBean", string);
        Object object = this.getRelation(string);
        if (object instanceof ObjectName) {
            return (ObjectName)object;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String isRelation(ObjectName objectName) throws IllegalArgumentException {
        if (objectName == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "isRelation", objectName);
        String string = null;
        Map<ObjectName, String> map = this.myRelMBeanObjName2RelIdMap;
        synchronized (map) {
            String string2 = this.myRelMBeanObjName2RelIdMap.get(objectName);
            if (string2 != null) {
                string = string2;
            }
        }
        return string;
    }

    @Override
    public Boolean hasRelation(String string) throws IllegalArgumentException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "hasRelation", string);
        try {
            Object object = this.getRelation(string);
            return true;
        }
        catch (RelationNotFoundException relationNotFoundException) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllRelationIds() {
        ArrayList<String> arrayList;
        Map<String, Object> map = this.myRelId2ObjMap;
        synchronized (map) {
            arrayList = new ArrayList<String>(this.myRelId2ObjMap.keySet());
        }
        return arrayList;
    }

    @Override
    public Integer checkRoleReading(String string, String string2) throws IllegalArgumentException, RelationTypeNotFoundException {
        Integer n;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "checkRoleReading", new Object[]{string, string2});
        RelationType relationType = this.getRelationType(string2);
        try {
            RoleInfo roleInfo = relationType.getRoleInfo(string);
            n = this.checkRoleInt(1, string, null, roleInfo, false);
        }
        catch (RoleInfoNotFoundException roleInfoNotFoundException) {
            n = 1;
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleReading");
        return n;
    }

    @Override
    public Integer checkRoleWriting(Role role, String string, Boolean bl) throws IllegalArgumentException, RelationTypeNotFoundException {
        RoleInfo roleInfo;
        if (role == null || string == null || bl == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "checkRoleWriting", new Object[]{role, string, bl});
        RelationType relationType = this.getRelationType(string);
        String string3 = role.getRoleName();
        List<ObjectName> list = role.getRoleValue();
        boolean bl2 = true;
        if (bl.booleanValue()) {
            bl2 = false;
        }
        try {
            roleInfo = relationType.getRoleInfo(string3);
        }
        catch (RoleInfoNotFoundException roleInfoNotFoundException) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleWriting");
            return 1;
        }
        Integer n = this.checkRoleInt(2, string3, list, roleInfo, bl2);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleWriting");
        return n;
    }

    @Override
    public void sendRelationCreationNotification(String string) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "sendRelationCreationNotification", string);
        StringBuilder stringBuilder = new StringBuilder("Creation of relation ");
        stringBuilder.append(string);
        this.sendNotificationInt(1, stringBuilder.toString(), string, null, null, null, null);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "sendRelationCreationNotification");
    }

    @Override
    public void sendRoleUpdateNotification(String string, Role role, List<ObjectName> list) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null || role == null || list == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        if (!(list instanceof ArrayList)) {
            list = new ArrayList<ObjectName>(list);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "sendRoleUpdateNotification", new Object[]{string, role, list});
        String string3 = role.getRoleName();
        List<ObjectName> list2 = role.getRoleValue();
        String string4 = Role.roleValueToString(list2);
        String string5 = Role.roleValueToString(list);
        StringBuilder stringBuilder = new StringBuilder("Value of role ");
        stringBuilder.append(string3);
        stringBuilder.append(" has changed\nOld value:\n");
        stringBuilder.append(string5);
        stringBuilder.append("\nNew value:\n");
        stringBuilder.append(string4);
        this.sendNotificationInt(2, stringBuilder.toString(), string, null, string3, list2, list);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "sendRoleUpdateNotification");
    }

    @Override
    public void sendRelationRemovalNotification(String string, List<ObjectName> list) throws IllegalArgumentException, RelationNotFoundException {
        if (string == null) {
            String string2 = "Invalid parameter";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "sendRelationRemovalNotification", new Object[]{string, list});
        this.sendNotificationInt(3, "Removal of relation " + string, string, list, null, null, null);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "sendRelationRemovalNotification");
    }

    @Override
    public void updateRoleMap(String string, Role role, List<ObjectName> list) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException {
        boolean bl;
        if (string == null || role == null || list == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "updateRoleMap", new Object[]{string, role, list});
        this.isActive();
        Object object = this.getRelation(string);
        String string3 = role.getRoleName();
        List<ObjectName> list2 = role.getRoleValue();
        ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>(list);
        ArrayList<ObjectName> arrayList2 = new ArrayList<ObjectName>();
        for (ObjectName object2 : list2) {
            int objectName = arrayList.indexOf(object2);
            if (objectName == -1) {
                bl = this.addNewMBeanReference(object2, string, string3);
                if (!bl) continue;
                arrayList2.add(object2);
                continue;
            }
            arrayList.remove(objectName);
        }
        ArrayList arrayList3 = new ArrayList();
        for (ObjectName objectName : arrayList) {
            bl = this.removeMBeanReference(objectName, string, string3, false);
            if (!bl) continue;
            arrayList3.add(objectName);
        }
        this.updateUnregistrationListener(arrayList2, arrayList3);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "updateRoleMap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRelation(String string) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        ArrayList<ObjectName> arrayList;
        this.isActive();
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "removeRelation", string);
        Object object = this.getRelation(string);
        if (object instanceof ObjectName) {
            arrayList = new ArrayList<ObjectName>();
            arrayList.add((ObjectName)object);
            this.updateUnregistrationListener(null, arrayList);
        }
        this.sendRelationRemovalNotification(string, null);
        arrayList = new ArrayList();
        ArrayList<ObjectName> arrayList2 = new ArrayList<ObjectName>();
        Object object2 = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (object2) {
            for (ObjectName object3 : this.myRefedMBeanObjName2RelIdsMap.keySet()) {
                Map<String, List<String>> map = this.myRefedMBeanObjName2RelIdsMap.get(object3);
                if (map.containsKey(string)) {
                    map.remove(string);
                    arrayList.add(object3);
                }
                if (!map.isEmpty()) continue;
                arrayList2.add(object3);
            }
            for (ObjectName objectName : arrayList2) {
                this.myRefedMBeanObjName2RelIdsMap.remove(objectName);
            }
        }
        object2 = this.myRelId2ObjMap;
        synchronized (object2) {
            this.myRelId2ObjMap.remove(string);
        }
        if (object instanceof ObjectName) {
            object2 = this.myRelMBeanObjName2RelIdMap;
            synchronized (object2) {
                this.myRelMBeanObjName2RelIdMap.remove((ObjectName)object);
            }
        }
        Map<String, List<String>> map = this.myRelId2RelTypeMap;
        synchronized (map) {
            object2 = this.myRelId2RelTypeMap.get(string);
            this.myRelId2RelTypeMap.remove(string);
        }
        map = this.myRelType2RelIdsMap;
        synchronized (map) {
            List<String> list = this.myRelType2RelIdsMap.get(object2);
            if (list != null) {
                list.remove(string);
                if (list.isEmpty()) {
                    this.myRelType2RelIdsMap.remove(object2);
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "removeRelation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeRelations() throws RelationServiceNotRegisteredException {
        Object object;
        ArrayList<MBeanServerNotification> arrayList;
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "purgeRelations");
        this.isActive();
        Object object2 = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (object2) {
            arrayList = new ArrayList<MBeanServerNotification>(this.myUnregNtfList);
            this.myUnregNtfList = new ArrayList<MBeanServerNotification>();
        }
        object2 = new ArrayList();
        HashMap<ObjectName, Map<String, List<String>>> hashMap = new HashMap<ObjectName, Map<String, List<String>>>();
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            for (Serializable serializable : arrayList) {
                object = serializable.getMBeanName();
                object2.add(object);
                Map<String, List<String>> map2 = this.myRefedMBeanObjName2RelIdsMap.get(object);
                hashMap.put((ObjectName)object, map2);
                this.myRefedMBeanObjName2RelIdsMap.remove(object);
            }
        }
        this.updateUnregistrationListener(null, (List<ObjectName>)object2);
        for (MBeanServerNotification mBeanServerNotification : arrayList) {
            Serializable serializable;
            serializable = mBeanServerNotification.getMBeanName();
            object = (Map)hashMap.get(serializable);
            for (Map.Entry entry : object.entrySet()) {
                String string = (String)entry.getKey();
                List list = (List)entry.getValue();
                try {
                    this.handleReferenceUnregistration(string, (ObjectName)serializable, list);
                }
                catch (RelationNotFoundException relationNotFoundException) {
                    throw new RuntimeException(relationNotFoundException.getMessage());
                }
                catch (RoleNotFoundException roleNotFoundException) {
                    throw new RuntimeException(roleNotFoundException.getMessage());
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "purgeRelations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<String>> findReferencingRelations(ObjectName objectName, String string, String string2) throws IllegalArgumentException {
        if (objectName == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "findReferencingRelations", new Object[]{objectName, string, string2});
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            Map<String, List<String>> map2 = this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (map2 != null) {
                Object object;
                Object object2;
                ArrayList<Object> arrayList;
                Set<String> set = map2.keySet();
                if (string == null) {
                    arrayList = new ArrayList<String>(set);
                } else {
                    arrayList = new ArrayList();
                    for (String string4 : set) {
                        object2 = this.myRelId2RelTypeMap;
                        synchronized (object2) {
                            object = this.myRelId2RelTypeMap.get(string4);
                        }
                        if (!((String)object).equals(string)) continue;
                        arrayList.add(string4);
                    }
                }
                for (String string3 : arrayList) {
                    object = map2.get(string3);
                    if (string2 == null) {
                        hashMap.put(string3, new ArrayList(object));
                        continue;
                    }
                    if (!object.contains(string2)) continue;
                    object2 = new ArrayList();
                    object2.add(string2);
                    hashMap.put(string3, (List<String>)object2);
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "findReferencingRelations");
        return hashMap;
    }

    @Override
    public Map<ObjectName, List<String>> findAssociatedMBeans(ObjectName objectName, String string, String string2) throws IllegalArgumentException {
        if (objectName == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "findAssociatedMBeans", new Object[]{objectName, string, string2});
        Map<String, List<String>> map = this.findReferencingRelations(objectName, string, string2);
        HashMap<ObjectName, List<String>> hashMap = new HashMap<ObjectName, List<String>>();
        for (String string4 : map.keySet()) {
            Map<ObjectName, List<String>> map2;
            try {
                map2 = this.getReferencedMBeans(string4);
            }
            catch (RelationNotFoundException relationNotFoundException) {
                throw new RuntimeException(relationNotFoundException.getMessage());
            }
            for (ObjectName objectName2 : map2.keySet()) {
                if (objectName2.equals(objectName)) continue;
                ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(objectName2);
                if (arrayList == null) {
                    arrayList = new ArrayList<String>();
                    arrayList.add(string4);
                    hashMap.put(objectName2, arrayList);
                    continue;
                }
                arrayList.add(string4);
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "findAssociatedMBeans");
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> findRelationsOfType(String string) throws IllegalArgumentException, RelationTypeNotFoundException {
        ArrayList<Object> arrayList;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "findRelationsOfType");
        RelationType relationType = this.getRelationType(string);
        Map<String, List<String>> map = this.myRelType2RelIdsMap;
        synchronized (map) {
            List<String> list = this.myRelType2RelIdsMap.get(string);
            arrayList = list == null ? new ArrayList() : new ArrayList<String>(list);
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "findRelationsOfType");
        return arrayList;
    }

    @Override
    public List<ObjectName> getRole(String string, String string2) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        List list;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRole", new Object[]{string, string2});
        this.isActive();
        Object object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            list = (ArrayList)Util.cast(((RelationSupport)object).getRoleInt(string2, true, this, false));
        } else {
            Object[] objectArray = new Object[]{string2};
            String[] stringArray = new String[]{"java.lang.String"};
            try {
                List list2 = (List)Util.cast(this.myMBeanServer.invoke((ObjectName)object, "getRole", objectArray, stringArray));
                list = list2 == null || list2 instanceof ArrayList ? list2 : new ArrayList(list2);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)exception;
                }
                throw new RuntimeException(exception.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRole");
        return list;
    }

    @Override
    public RoleResult getRoles(String string, String[] stringArray) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        RoleResult roleResult;
        if (string == null || stringArray == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoles", string);
        this.isActive();
        Object object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            roleResult = ((RelationSupport)object).getRolesInt(stringArray, true, this);
        } else {
            Object[] objectArray = new Object[]{stringArray};
            String[] stringArray2 = new String[1];
            try {
                stringArray2[0] = stringArray.getClass().getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                roleResult = (RoleResult)this.myMBeanServer.invoke((ObjectName)object, "getRoles", objectArray, stringArray2);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                throw new RuntimeException(mBeanException.getTargetException().getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoles");
        return roleResult;
    }

    @Override
    public RoleResult getAllRoles(String string) throws IllegalArgumentException, RelationNotFoundException, RelationServiceNotRegisteredException {
        RoleResult roleResult;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoles", string);
        Object object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            roleResult = ((RelationSupport)object).getAllRolesInt(true, this);
        } else {
            try {
                roleResult = (RoleResult)this.myMBeanServer.getAttribute((ObjectName)object, "AllRoles");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoles");
        return roleResult;
    }

    @Override
    public Integer getRoleCardinality(String string, String string2) throws IllegalArgumentException, RelationNotFoundException, RoleNotFoundException {
        Integer n;
        if (string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRoleCardinality", new Object[]{string, string2});
        Object object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            n = ((RelationSupport)object).getRoleCardinality(string2);
        } else {
            Object[] objectArray = new Object[]{string2};
            String[] stringArray = new String[]{"java.lang.String"};
            try {
                n = (Integer)this.myMBeanServer.invoke((ObjectName)object, "getRoleCardinality", objectArray, stringArray);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof RoleNotFoundException) {
                    throw (RoleNotFoundException)exception;
                }
                throw new RuntimeException(exception.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRoleCardinality");
        return n;
    }

    @Override
    public void setRole(String string, Role role) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException, RoleNotFoundException, InvalidRoleValueException {
        if (string == null || role == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "setRole", new Object[]{string, role});
        this.isActive();
        Object object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            try {
                ((RelationSupport)object).setRoleInt(role, true, this, false);
            }
            catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                throw new RuntimeException(relationTypeNotFoundException.getMessage());
            }
        }
        Object[] objectArray = new Object[]{role};
        String[] stringArray = new String[]{"javax.management.relation.Role"};
        try {
            this.myMBeanServer.setAttribute((ObjectName)object, new Attribute("Role", role));
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException(instanceNotFoundException.getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (MBeanException mBeanException) {
            Exception exception = mBeanException.getTargetException();
            if (exception instanceof RoleNotFoundException) {
                throw (RoleNotFoundException)exception;
            }
            if (exception instanceof InvalidRoleValueException) {
                throw (InvalidRoleValueException)exception;
            }
            throw new RuntimeException(exception.getMessage());
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            throw new RuntimeException(attributeNotFoundException.getMessage());
        }
        catch (InvalidAttributeValueException invalidAttributeValueException) {
            throw new RuntimeException(invalidAttributeValueException.getMessage());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "setRole");
    }

    @Override
    public RoleResult setRoles(String string, RoleList roleList) throws RelationServiceNotRegisteredException, IllegalArgumentException, RelationNotFoundException {
        RoleResult roleResult;
        if (string == null || roleList == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "setRoles", new Object[]{string, roleList});
        this.isActive();
        Object object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            try {
                roleResult = ((RelationSupport)object).setRolesInt(roleList, true, this);
            }
            catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                throw new RuntimeException(relationTypeNotFoundException.getMessage());
            }
        }
        Object[] objectArray = new Object[]{roleList};
        String[] stringArray = new String[]{"javax.management.relation.RoleList"};
        try {
            roleResult = (RoleResult)this.myMBeanServer.invoke((ObjectName)object, "setRoles", objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new RuntimeException(instanceNotFoundException.getMessage());
        }
        catch (ReflectionException reflectionException) {
            throw new RuntimeException(reflectionException.getMessage());
        }
        catch (MBeanException mBeanException) {
            throw new RuntimeException(mBeanException.getTargetException().getMessage());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "setRoles");
        return roleResult;
    }

    @Override
    public Map<ObjectName, List<String>> getReferencedMBeans(String string) throws IllegalArgumentException, RelationNotFoundException {
        Map map;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getReferencedMBeans", string);
        Object object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            map = ((RelationSupport)object).getReferencedMBeans();
        } else {
            try {
                map = (Map)Util.cast(this.myMBeanServer.getAttribute((ObjectName)object, "ReferencedMBeans"));
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getReferencedMBeans");
        return map;
    }

    @Override
    public String getRelationTypeName(String string) throws IllegalArgumentException, RelationNotFoundException {
        String string2;
        if (string == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRelationTypeName", string);
        Object object = this.getRelation(string);
        if (object instanceof RelationSupport) {
            string2 = ((RelationSupport)object).getRelationTypeName();
        } else {
            try {
                string2 = (String)this.myMBeanServer.getAttribute((ObjectName)object, "RelationTypeName");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRelationTypeName");
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleNotification(Notification notification, Object object) {
        if (notification == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "handleNotification", notification);
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification mBeanServerNotification = (MBeanServerNotification)notification;
            String string = notification.getType();
            if (string.equals("JMX.mbean.unregistered")) {
                Object object2;
                ObjectName objectName = ((MBeanServerNotification)notification).getMBeanName();
                boolean bl = false;
                Object object3 = this.myRefedMBeanObjName2RelIdsMap;
                synchronized (object3) {
                    if (this.myRefedMBeanObjName2RelIdsMap.containsKey(objectName)) {
                        object2 = this.myUnregNtfList;
                        synchronized (object2) {
                            this.myUnregNtfList.add(mBeanServerNotification);
                        }
                        bl = true;
                    }
                    if (bl && this.myPurgeFlag) {
                        try {
                            this.purgeRelations();
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception.getMessage());
                        }
                    }
                }
                object2 = this.myRelMBeanObjName2RelIdMap;
                synchronized (object2) {
                    object3 = this.myRelMBeanObjName2RelIdMap.get(objectName);
                }
                if (object3 != null) {
                    try {
                        this.removeRelation((String)object3);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.getMessage());
                    }
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "handleNotification");
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getNotificationInfo");
        String string = "javax.management.relation.RelationNotification";
        String[] stringArray = new String[]{"jmx.relation.creation.basic", "jmx.relation.creation.mbean", "jmx.relation.update.basic", "jmx.relation.update.mbean", "jmx.relation.removal.basic", "jmx.relation.removal.mbean"};
        String string2 = "Sent when a relation is created, updated or deleted.";
        MBeanNotificationInfo mBeanNotificationInfo = new MBeanNotificationInfo(stringArray, string, string2);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getNotificationInfo");
        return new MBeanNotificationInfo[]{mBeanNotificationInfo};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRelationTypeInt(RelationType relationType) throws IllegalArgumentException, InvalidRelationTypeException {
        Object object;
        if (relationType == null) {
            String string = "Invalid parameter.";
            throw new IllegalArgumentException(string);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addRelationTypeInt");
        String string = relationType.getRelationTypeName();
        try {
            object = this.getRelationType(string);
            if (object != null) {
                String string2 = "There is already a relation type in the Relation Service with name ";
                StringBuilder stringBuilder = new StringBuilder(string2);
                stringBuilder.append(string);
                throw new InvalidRelationTypeException(stringBuilder.toString());
            }
        }
        catch (RelationTypeNotFoundException relationTypeNotFoundException) {
            // empty catch block
        }
        object = this.myRelType2ObjMap;
        synchronized (object) {
            this.myRelType2ObjMap.put(string, relationType);
        }
        if (relationType instanceof RelationTypeSupport) {
            ((RelationTypeSupport)relationType).setRelationServiceFlag(true);
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addRelationTypeInt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    RelationType getRelationType(String string) throws IllegalArgumentException, RelationTypeNotFoundException {
        RelationType relationType;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRelationType", string);
        Object object = this.myRelType2ObjMap;
        synchronized (object) {
            relationType = this.myRelType2ObjMap.get(string);
        }
        if (relationType == null) {
            object = "No relation type created in the Relation Service with the name ";
            StringBuilder stringBuilder = new StringBuilder((String)object);
            stringBuilder.append(string);
            throw new RelationTypeNotFoundException(stringBuilder.toString());
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRelationType");
        return relationType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object getRelation(String string) throws IllegalArgumentException, RelationNotFoundException {
        Object object;
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "getRelation", string);
        Object object2 = this.myRelId2ObjMap;
        synchronized (object2) {
            object = this.myRelId2ObjMap.get(string);
        }
        if (object == null) {
            object2 = "No relation associated to relation id " + string;
            throw new RelationNotFoundException((String)object2);
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "getRelation");
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addNewMBeanReference(ObjectName objectName, String string, String string2) throws IllegalArgumentException {
        if (objectName == null || string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addNewMBeanReference", new Object[]{objectName, string, string2});
        boolean bl = false;
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            Map<String, List<String>> map2 = this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (map2 == null) {
                bl = true;
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(string2);
                map2 = new HashMap<String, List<String>>();
                map2.put(string, arrayList);
                this.myRefedMBeanObjName2RelIdsMap.put(objectName, map2);
            } else {
                List<String> list = map2.get(string);
                if (list == null) {
                    list = new ArrayList<String>();
                    list.add(string2);
                    map2.put(string, list);
                } else {
                    list.add(string2);
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addNewMBeanReference");
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeMBeanReference(ObjectName objectName, String string, String string2, boolean bl) throws IllegalArgumentException {
        if (objectName == null || string == null || string2 == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "removeMBeanReference", new Object[]{objectName, string, string2, bl});
        boolean bl2 = false;
        Map<ObjectName, Map<String, List<String>>> map = this.myRefedMBeanObjName2RelIdsMap;
        synchronized (map) {
            int n;
            Map<String, List<String>> map2 = this.myRefedMBeanObjName2RelIdsMap.get(objectName);
            if (map2 == null) {
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "removeMBeanReference");
                return true;
            }
            List<String> list = null;
            if (!bl && (n = (list = map2.get(string)).indexOf(string2)) != -1) {
                list.remove(n);
            }
            if (list.isEmpty() || bl) {
                map2.remove(string);
            }
            if (map2.isEmpty()) {
                this.myRefedMBeanObjName2RelIdsMap.remove(objectName);
                bl2 = true;
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "removeMBeanReference");
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnregistrationListener(List<ObjectName> list, List<ObjectName> list2) throws RelationServiceNotRegisteredException {
        if (list != null && list2 != null && list.isEmpty() && list2.isEmpty()) {
            return;
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "updateUnregistrationListener", new Object[]{list, list2});
        this.isActive();
        if (list != null || list2 != null) {
            boolean bl = false;
            if (this.myUnregNtfFilter == null) {
                this.myUnregNtfFilter = new MBeanServerNotificationFilter();
                bl = true;
            }
            MBeanServerNotificationFilter mBeanServerNotificationFilter = this.myUnregNtfFilter;
            synchronized (mBeanServerNotificationFilter) {
                if (list != null) {
                    for (ObjectName objectName : list) {
                        this.myUnregNtfFilter.enableObjectName(objectName);
                    }
                }
                if (list2 != null) {
                    for (ObjectName objectName : list2) {
                        this.myUnregNtfFilter.disableObjectName(objectName);
                    }
                }
                if (bl) {
                    try {
                        this.myMBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, this, (NotificationFilter)this.myUnregNtfFilter, null);
                    }
                    catch (InstanceNotFoundException instanceNotFoundException) {
                        throw new RelationServiceNotRegisteredException(instanceNotFoundException.getMessage());
                    }
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "updateUnregistrationListener");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addRelationInt(boolean bl, RelationSupport relationSupport, ObjectName objectName, String string, String string2, RoleList roleList) throws IllegalArgumentException, RelationServiceNotRegisteredException, RoleNotFoundException, InvalidRelationIdException, RelationTypeNotFoundException, InvalidRoleValueException {
        Object object;
        if (string == null || string2 == null || bl && (relationSupport == null || objectName != null) || !bl && (objectName == null || relationSupport != null)) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "addRelationInt", new Object[]{bl, relationSupport, objectName, string, string2, roleList});
        this.isActive();
        try {
            object = this.getRelation(string);
            if (object != null) {
                String string4 = "There is already a relation with id ";
                StringBuilder stringBuilder = new StringBuilder(string4);
                stringBuilder.append(string);
                throw new InvalidRelationIdException(stringBuilder.toString());
            }
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
        object = this.getRelationType(string2);
        ArrayList<RoleInfo> arrayList = new ArrayList<RoleInfo>(object.getRoleInfos());
        if (roleList != null) {
            for (Role serializable : roleList.asList()) {
                RoleInfo roleInfo;
                String string3 = serializable.getRoleName();
                List<ObjectName> list = serializable.getRoleValue();
                try {
                    roleInfo = object.getRoleInfo(string3);
                }
                catch (RoleInfoNotFoundException roleInfoNotFoundException) {
                    throw new RoleNotFoundException(roleInfoNotFoundException.getMessage());
                }
                Integer n = this.checkRoleInt(2, string3, list, roleInfo, false);
                int n2 = n;
                if (n2 != 0) {
                    RelationService.throwRoleProblemException(n2, string3);
                }
                int n3 = arrayList.indexOf(roleInfo);
                arrayList.remove(n3);
            }
        }
        this.initializeMissingRoles(bl, relationSupport, objectName, string, string2, arrayList);
        Object object2 = this.myRelId2ObjMap;
        synchronized (object2) {
            if (bl) {
                this.myRelId2ObjMap.put(string, relationSupport);
            } else {
                this.myRelId2ObjMap.put(string, objectName);
            }
        }
        object2 = this.myRelId2RelTypeMap;
        synchronized (object2) {
            this.myRelId2RelTypeMap.put(string, string2);
        }
        object2 = this.myRelType2RelIdsMap;
        synchronized (object2) {
            void var10_18;
            List<String> list = this.myRelType2RelIdsMap.get(string2);
            boolean bl2 = false;
            if (list == null) {
                bl2 = true;
                ArrayList arrayList2 = new ArrayList();
            }
            var10_18.add(string);
            if (bl2) {
                this.myRelType2RelIdsMap.put(string2, (List<String>)var10_18);
            }
        }
        for (Role role : roleList.asList()) {
            ArrayList<ObjectName> arrayList3 = new ArrayList<ObjectName>();
            try {
                this.updateRoleMap(string, role, arrayList3);
            }
            catch (RelationNotFoundException relationNotFoundException) {}
        }
        try {
            this.sendRelationCreationNotification(string);
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "addRelationInt");
    }

    private Integer checkRoleInt(int n, String string, List<ObjectName> list, RoleInfo roleInfo, boolean bl) throws IllegalArgumentException {
        int n2;
        if (string == null || roleInfo == null || n == 2 && list == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "checkRoleInt", new Object[]{n, string, list, roleInfo, bl});
        String string3 = roleInfo.getName();
        if (!string.equals(string3)) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return 1;
        }
        if (n == 1) {
            boolean bl2 = roleInfo.isReadable();
            if (!bl2) {
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
                return 2;
            }
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return new Integer(0);
        }
        if (bl && (n2 = roleInfo.isWritable()) == 0) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return new Integer(3);
        }
        n2 = list.size();
        boolean bl3 = roleInfo.checkMinDegree(n2);
        if (!bl3) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return new Integer(4);
        }
        boolean bl4 = roleInfo.checkMaxDegree(n2);
        if (!bl4) {
            JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
            return new Integer(5);
        }
        String string4 = roleInfo.getRefMBeanClassName();
        for (ObjectName objectName : list) {
            if (objectName == null) {
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
                return new Integer(7);
            }
            try {
                boolean bl5 = this.myMBeanServer.isInstanceOf(objectName, string4);
                if (bl5) continue;
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
                return new Integer(6);
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
                return new Integer(7);
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "checkRoleInt");
        return new Integer(0);
    }

    private void initializeMissingRoles(boolean bl, RelationSupport relationSupport, ObjectName objectName, String string, String string2, List<RoleInfo> list) throws IllegalArgumentException, RelationServiceNotRegisteredException, InvalidRoleValueException {
        if (bl && (relationSupport == null || objectName != null) || !bl && (objectName == null || relationSupport != null) || string == null || string2 == null || list == null) {
            String string3 = "Invalid parameter.";
            throw new IllegalArgumentException(string3);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "initializeMissingRoles", new Object[]{bl, relationSupport, objectName, string, string2, list});
        this.isActive();
        for (RoleInfo roleInfo : list) {
            String string4 = roleInfo.getName();
            ArrayList<ObjectName> arrayList = new ArrayList<ObjectName>();
            Role role = new Role(string4, arrayList);
            if (bl) {
                try {
                    relationSupport.setRoleInt(role, true, this, false);
                    continue;
                }
                catch (RoleNotFoundException roleNotFoundException) {
                    throw new RuntimeException(roleNotFoundException.getMessage());
                }
                catch (RelationNotFoundException relationNotFoundException) {
                    throw new RuntimeException(relationNotFoundException.getMessage());
                }
                catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                    throw new RuntimeException(relationTypeNotFoundException.getMessage());
                }
            }
            Object[] objectArray = new Object[]{role};
            String[] stringArray = new String[]{"javax.management.relation.Role"};
            try {
                this.myMBeanServer.setAttribute(objectName, new Attribute("Role", role));
            }
            catch (InstanceNotFoundException instanceNotFoundException) {
                throw new RuntimeException(instanceNotFoundException.getMessage());
            }
            catch (ReflectionException reflectionException) {
                throw new RuntimeException(reflectionException.getMessage());
            }
            catch (MBeanException mBeanException) {
                Exception exception = mBeanException.getTargetException();
                if (exception instanceof InvalidRoleValueException) {
                    throw (InvalidRoleValueException)exception;
                }
                throw new RuntimeException(exception.getMessage());
            }
            catch (AttributeNotFoundException attributeNotFoundException) {
                throw new RuntimeException(attributeNotFoundException.getMessage());
            }
            catch (InvalidAttributeValueException invalidAttributeValueException) {
                throw new RuntimeException(invalidAttributeValueException.getMessage());
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "initializeMissingRoles");
    }

    static void throwRoleProblemException(int n, String string) throws IllegalArgumentException, RoleNotFoundException, InvalidRoleValueException {
        if (string == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        int n2 = 0;
        String string3 = null;
        switch (n) {
            case 1: {
                string3 = " does not exist in relation.";
                n2 = 1;
                break;
            }
            case 2: {
                string3 = " is not readable.";
                n2 = 1;
                break;
            }
            case 3: {
                string3 = " is not writable.";
                n2 = 1;
                break;
            }
            case 4: {
                string3 = " has a number of MBean references less than the expected minimum degree.";
                n2 = 2;
                break;
            }
            case 5: {
                string3 = " has a number of MBean references greater than the expected maximum degree.";
                n2 = 2;
                break;
            }
            case 6: {
                string3 = " has an MBean reference to an MBean not of the expected class of references for that role.";
                n2 = 2;
                break;
            }
            case 7: {
                string3 = " has a reference to null or to an MBean not registered.";
                n2 = 2;
            }
        }
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append(string3);
        String string4 = stringBuilder.toString();
        if (n2 == 1) {
            throw new RoleNotFoundException(string4);
        }
        if (n2 == 2) {
            throw new InvalidRoleValueException(string4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendNotificationInt(int n, String string, String string2, List<ObjectName> list, String string3, List<ObjectName> list2, List<ObjectName> list3) throws IllegalArgumentException, RelationNotFoundException {
        String string4;
        if (string == null || string2 == null || n != 3 && list != null || n == 2 && (string3 == null || list2 == null || list3 == null)) {
            String string5 = "Invalid parameter.";
            throw new IllegalArgumentException(string5);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "sendNotificationInt", new Object[]{n, string, string2, list, string3, list2, list3});
        Object object = this.myRelId2RelTypeMap;
        synchronized (object) {
            string4 = this.myRelId2RelTypeMap.get(string2);
        }
        object = this.isRelationMBean(string2);
        String string6 = null;
        if (object != null) {
            switch (n) {
                case 1: {
                    string6 = "jmx.relation.creation.mbean";
                    break;
                }
                case 2: {
                    string6 = "jmx.relation.update.mbean";
                    break;
                }
                case 3: {
                    string6 = "jmx.relation.removal.mbean";
                }
            }
        } else {
            switch (n) {
                case 1: {
                    string6 = "jmx.relation.creation.basic";
                    break;
                }
                case 2: {
                    string6 = "jmx.relation.update.basic";
                    break;
                }
                case 3: {
                    string6 = "jmx.relation.removal.basic";
                }
            }
        }
        Long l = this.atomicSeqNo.incrementAndGet();
        Date date = new Date();
        long l2 = date.getTime();
        RelationNotification relationNotification = null;
        if (string6.equals("jmx.relation.creation.basic") || string6.equals("jmx.relation.creation.mbean") || string6.equals("jmx.relation.removal.basic") || string6.equals("jmx.relation.removal.mbean")) {
            relationNotification = new RelationNotification(string6, this, l, l2, string, string2, string4, (ObjectName)object, list);
        } else if (string6.equals("jmx.relation.update.basic") || string6.equals("jmx.relation.update.mbean")) {
            relationNotification = new RelationNotification(string6, this, l, l2, string, string2, string4, (ObjectName)object, string3, list2, list3);
        }
        this.sendNotification(relationNotification);
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "sendNotificationInt");
    }

    private void handleReferenceUnregistration(String string, ObjectName objectName, List<String> list) throws IllegalArgumentException, RelationServiceNotRegisteredException, RelationNotFoundException, RoleNotFoundException {
        if (string == null || list == null || objectName == null) {
            String string2 = "Invalid parameter.";
            throw new IllegalArgumentException(string2);
        }
        JmxProperties.RELATION_LOGGER.entering(RelationService.class.getName(), "handleReferenceUnregistration", new Object[]{string, objectName, list});
        this.isActive();
        String string3 = this.getRelationTypeName(string);
        Object object = this.getRelation(string);
        boolean bl = false;
        for (String string4 : list) {
            RoleInfo roleInfo;
            if (bl) break;
            int n = this.getRoleCardinality(string, string4);
            int n2 = n - 1;
            try {
                roleInfo = this.getRoleInfo(string3, string4);
            }
            catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                throw new RuntimeException(relationTypeNotFoundException.getMessage());
            }
            catch (RoleInfoNotFoundException roleInfoNotFoundException) {
                throw new RuntimeException(roleInfoNotFoundException.getMessage());
            }
            boolean bl2 = roleInfo.checkMinDegree(n2);
            if (bl2) continue;
            bl = true;
        }
        if (bl) {
            this.removeRelation(string);
        } else {
            for (String string4 : list) {
                if (object instanceof RelationSupport) {
                    try {
                        ((RelationSupport)object).handleMBeanUnregistrationInt(objectName, string4, true, this);
                        continue;
                    }
                    catch (RelationTypeNotFoundException relationTypeNotFoundException) {
                        throw new RuntimeException(relationTypeNotFoundException.getMessage());
                    }
                    catch (InvalidRoleValueException invalidRoleValueException) {
                        throw new RuntimeException(invalidRoleValueException.getMessage());
                    }
                }
                Object[] objectArray = new Object[]{objectName, string4};
                String[] stringArray = new String[]{"javax.management.ObjectName", "java.lang.String"};
                try {
                    this.myMBeanServer.invoke((ObjectName)object, "handleMBeanUnregistration", objectArray, stringArray);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    throw new RuntimeException(instanceNotFoundException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    throw new RuntimeException(reflectionException.getMessage());
                }
                catch (MBeanException mBeanException) {
                    Exception exception = mBeanException.getTargetException();
                    throw new RuntimeException(exception.getMessage());
                }
            }
        }
        JmxProperties.RELATION_LOGGER.exiting(RelationService.class.getName(), "handleReferenceUnregistration");
    }
}

