/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.interceptor;

import com.sun.jmx.mbeanserver.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.namespace.MBeanServerSupport;
import javax.management.remote.IdentityMBeanServerForwarder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingleMBeanForwarder
extends IdentityMBeanServerForwarder {
    private final ObjectName mbeanName;
    private final boolean visible;
    private DynamicMBean mbean;
    private MBeanServer mbeanMBS = new MBeanServerSupport(){

        @Override
        public DynamicMBean getDynamicMBeanFor(ObjectName objectName) throws InstanceNotFoundException {
            if (SingleMBeanForwarder.this.mbeanName.equals(objectName)) {
                return SingleMBeanForwarder.this.mbean;
            }
            throw new InstanceNotFoundException(objectName.toString());
        }

        @Override
        protected Set<ObjectName> getNames() {
            return Collections.singleton(SingleMBeanForwarder.this.mbeanName);
        }

        @Override
        public NotificationEmitter getNotificationEmitterFor(ObjectName objectName) {
            if (SingleMBeanForwarder.this.mbean instanceof NotificationEmitter) {
                return (NotificationEmitter)((Object)SingleMBeanForwarder.this.mbean);
            }
            return null;
        }

        @Override
        public String getDefaultDomain() {
            return SingleMBeanForwarder.this.mbeanName.getDomain();
        }
    };

    public SingleMBeanForwarder(ObjectName objectName, DynamicMBean dynamicMBean, boolean bl) {
        this.mbeanName = objectName;
        this.visible = bl;
        this.setSingleMBean(dynamicMBean);
    }

    protected void setSingleMBean(DynamicMBean dynamicMBean) {
        this.mbean = dynamicMBean;
    }

    @Override
    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            this.mbeanMBS.addNotificationListener(objectName, objectName2, notificationFilter, object);
        } else {
            super.addNotificationListener(objectName, objectName2, notificationFilter, object);
        }
    }

    @Override
    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            this.mbeanMBS.addNotificationListener(objectName, notificationListener, notificationFilter, object);
        } else {
            super.addNotificationListener(objectName, notificationListener, notificationFilter, object);
        }
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            throw new InstanceAlreadyExistsException(this.mbeanName.toString());
        }
        return super.createMBean(string, objectName, objectName2, objectArray, stringArray);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (this.mbeanName.equals(objectName)) {
            throw new InstanceAlreadyExistsException(this.mbeanName.toString());
        }
        return super.createMBean(string, objectName, objectArray, stringArray);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            throw new InstanceAlreadyExistsException(this.mbeanName.toString());
        }
        return super.createMBean(string, objectName, objectName2);
    }

    @Override
    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        if (this.mbeanName.equals(objectName)) {
            throw new InstanceAlreadyExistsException(this.mbeanName.toString());
        }
        return super.createMBean(string, objectName);
    }

    @Override
    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (this.mbeanName.equals(objectName)) {
            return this.mbeanMBS.getAttribute(objectName, string);
        }
        return super.getAttribute(objectName, string);
    }

    @Override
    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        if (this.mbeanName.equals(objectName)) {
            return this.mbeanMBS.getAttributes(objectName, stringArray);
        }
        return super.getAttributes(objectName, stringArray);
    }

    @Override
    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            return this.mbeanMBS.getClassLoader(objectName);
        }
        return super.getClassLoader(objectName);
    }

    @Override
    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            return this.mbeanMBS.getClassLoaderFor(objectName);
        }
        return super.getClassLoaderFor(objectName);
    }

    @Override
    public String[] getDomains() {
        String[] stringArray = super.getDomains();
        if (!this.visible) {
            return stringArray;
        }
        TreeSet<String> treeSet = new TreeSet<String>(Arrays.asList(stringArray));
        treeSet.add(this.mbeanName.getDomain());
        return treeSet.toArray(new String[treeSet.size()]);
    }

    @Override
    public Integer getMBeanCount() {
        Integer n = super.getMBeanCount();
        if (this.visible && !super.isRegistered(this.mbeanName)) {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        return n;
    }

    @Override
    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        if (this.mbeanName.equals(objectName)) {
            return this.mbeanMBS.getMBeanInfo(objectName);
        }
        return super.getMBeanInfo(objectName);
    }

    @Override
    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            return this.mbeanMBS.getObjectInstance(objectName);
        }
        return super.getObjectInstance(objectName);
    }

    @Override
    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        if (this.mbeanName.equals(objectName)) {
            return this.mbeanMBS.invoke(objectName, string, objectArray, stringArray);
        }
        return super.invoke(objectName, string, objectArray, stringArray);
    }

    @Override
    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            return this.mbeanMBS.isInstanceOf(objectName, string);
        }
        return super.isInstanceOf(objectName, string);
    }

    @Override
    public boolean isRegistered(ObjectName objectName) {
        if (this.mbeanName.equals(objectName)) {
            return true;
        }
        return super.isRegistered(objectName);
    }

    private boolean applies(ObjectName objectName) {
        if (!this.visible || !objectName.apply(this.mbeanName)) {
            return false;
        }
        String string = objectName.getDomain();
        if (!string.contains("//")) {
            return true;
        }
        if (this.mbeanName.getDomain().endsWith("//")) {
            return string.endsWith("//");
        }
        return true;
    }

    @Override
    public Set<ObjectInstance> queryMBeans(ObjectName objectName, QueryExp queryExp) {
        Set<ObjectInstance> set = super.queryMBeans(objectName, queryExp);
        if (this.visible && (objectName == null || this.applies(objectName))) {
            set = Util.cloneSet(set);
            set.addAll(this.mbeanMBS.queryMBeans(objectName, queryExp));
        }
        return set;
    }

    @Override
    public Set<ObjectName> queryNames(ObjectName objectName, QueryExp queryExp) {
        Set<ObjectName> set = super.queryNames(objectName, queryExp);
        if (this.visible && (objectName == null || this.applies(objectName))) {
            set = Util.cloneSet(set);
            set.addAll(this.mbeanMBS.queryNames(objectName, queryExp));
        }
        return set;
    }

    @Override
    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (this.mbeanName.equals(objectName)) {
            throw new InstanceAlreadyExistsException(this.mbeanName.toString());
        }
        return super.registerMBean(object, objectName);
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            this.mbeanMBS.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
        } else {
            super.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            this.mbeanMBS.removeNotificationListener(objectName, notificationListener);
        } else {
            super.removeNotificationListener(objectName, notificationListener);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            this.mbeanMBS.removeNotificationListener(objectName, objectName2, notificationFilter, object);
        } else {
            super.removeNotificationListener(objectName, objectName2, notificationFilter, object);
        }
    }

    @Override
    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        if (this.mbeanName.equals(objectName)) {
            this.mbeanMBS.removeNotificationListener(objectName, objectName2);
        } else {
            super.removeNotificationListener(objectName, objectName2);
        }
    }

    @Override
    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (this.mbeanName.equals(objectName)) {
            this.mbeanMBS.setAttribute(objectName, attribute);
        } else {
            super.setAttribute(objectName, attribute);
        }
    }

    @Override
    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (this.mbeanName.equals(objectName)) {
            return this.mbeanMBS.setAttributes(objectName, attributeList);
        }
        return super.setAttributes(objectName, attributeList);
    }

    @Override
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        if (this.mbeanName.equals(objectName)) {
            this.mbeanMBS.unregisterMBean(objectName);
        } else {
            super.unregisterMBean(objectName);
        }
    }
}

