/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.rmic.newrmic.jrmp;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.Type;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.rmi.rmic.newrmic.BatchEnvironment;
import sun.rmi.rmic.newrmic.IndentingWriter;
import sun.rmi.rmic.newrmic.jrmp.Constants;
import sun.rmi.rmic.newrmic.jrmp.RemoteClass;
import sun.rmi.rmic.newrmic.jrmp.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StubSkeletonWriter {
    private final BatchEnvironment env;
    private final RemoteClass remoteClass;
    private final Constants.StubVersion version;
    private final String stubClassName;
    private final String skeletonClassName;
    private final String packageName;
    private final String stubClassSimpleName;
    private final String skeletonClassSimpleName;
    private final RemoteClass.Method[] remoteMethods;
    private final String[] methodFieldNames;

    StubSkeletonWriter(BatchEnvironment batchEnvironment, RemoteClass remoteClass, Constants.StubVersion stubVersion) {
        this.env = batchEnvironment;
        this.remoteClass = remoteClass;
        this.version = stubVersion;
        this.stubClassName = Util.binaryNameOf(remoteClass.classDoc()) + "_Stub";
        this.skeletonClassName = Util.binaryNameOf(remoteClass.classDoc()) + "_Skel";
        int n = this.stubClassName.lastIndexOf(46);
        this.packageName = n != -1 ? this.stubClassName.substring(0, n) : "";
        this.stubClassSimpleName = this.stubClassName.substring(n + 1);
        this.skeletonClassSimpleName = this.skeletonClassName.substring(n + 1);
        this.remoteMethods = remoteClass.remoteMethods();
        this.methodFieldNames = StubSkeletonWriter.nameMethodFields(this.remoteMethods);
    }

    String stubClassName() {
        return this.stubClassName;
    }

    String skeletonClassName() {
        return this.skeletonClassName;
    }

    void writeStub(IndentingWriter indentingWriter) throws IOException {
        int n;
        indentingWriter.pln("// Stub class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        if (!this.packageName.equals("")) {
            indentingWriter.pln("package " + this.packageName + ";");
            indentingWriter.pln();
        }
        indentingWriter.plnI("public final class " + this.stubClassSimpleName);
        indentingWriter.pln("extends java.rmi.server.RemoteStub");
        ClassDoc[] classDocArray = this.remoteClass.remoteInterfaces();
        if (classDocArray.length > 0) {
            indentingWriter.p("implements ");
            for (n = 0; n < classDocArray.length; ++n) {
                if (n > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(classDocArray[n].qualifiedName());
            }
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("{");
        if (this.version == Constants.StubVersion.V1_1 || this.version == Constants.StubVersion.VCOMPAT) {
            this.writeOperationsArray(indentingWriter);
            indentingWriter.pln();
            this.writeInterfaceHash(indentingWriter);
            indentingWriter.pln();
        }
        if (this.version == Constants.StubVersion.VCOMPAT || this.version == Constants.StubVersion.V1_2) {
            indentingWriter.pln("private static final long serialVersionUID = 2;");
            indentingWriter.pln();
            if (this.methodFieldNames.length > 0) {
                if (this.version == Constants.StubVersion.VCOMPAT) {
                    indentingWriter.pln("private static boolean useNewInvoke;");
                }
                this.writeMethodFieldDeclarations(indentingWriter);
                indentingWriter.pln();
                indentingWriter.plnI("static {");
                indentingWriter.plnI("try {");
                if (this.version == Constants.StubVersion.VCOMPAT) {
                    indentingWriter.plnI("java.rmi.server.RemoteRef.class.getMethod(\"invoke\",");
                    indentingWriter.plnI("new java.lang.Class[] {");
                    indentingWriter.pln("java.rmi.Remote.class,");
                    indentingWriter.pln("java.lang.reflect.Method.class,");
                    indentingWriter.pln("java.lang.Object[].class,");
                    indentingWriter.pln("long.class");
                    indentingWriter.pOln("});");
                    indentingWriter.pO();
                    indentingWriter.pln("useNewInvoke = true;");
                }
                this.writeMethodFieldInitializers(indentingWriter);
                indentingWriter.pOlnI("} catch (java.lang.NoSuchMethodException e) {");
                if (this.version == Constants.StubVersion.VCOMPAT) {
                    indentingWriter.pln("useNewInvoke = false;");
                } else {
                    indentingWriter.plnI("throw new java.lang.NoSuchMethodError(");
                    indentingWriter.pln("\"stub class initialization failed\");");
                    indentingWriter.pO();
                }
                indentingWriter.pOln("}");
                indentingWriter.pOln("}");
                indentingWriter.pln();
            }
        }
        this.writeStubConstructors(indentingWriter);
        indentingWriter.pln();
        if (this.remoteMethods.length > 0) {
            indentingWriter.pln("// methods from remote interfaces");
            for (n = 0; n < this.remoteMethods.length; ++n) {
                indentingWriter.pln();
                this.writeStubMethod(indentingWriter, n);
            }
        }
        indentingWriter.pOln("}");
    }

    private void writeStubConstructors(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("// constructors");
        if (this.version == Constants.StubVersion.V1_1 || this.version == Constants.StubVersion.VCOMPAT) {
            indentingWriter.plnI("public " + this.stubClassSimpleName + "() {");
            indentingWriter.pln("super();");
            indentingWriter.pOln("}");
        }
        indentingWriter.plnI("public " + this.stubClassSimpleName + "(" + "java.rmi.server.RemoteRef" + " ref) {");
        indentingWriter.pln("super(ref);");
        indentingWriter.pOln("}");
    }

    private void writeStubMethod(IndentingWriter indentingWriter, int n) throws IOException {
        int n2;
        int n3;
        RemoteClass.Method method = this.remoteMethods[n];
        MethodDoc methodDoc = method.methodDoc();
        String string = methodDoc.name();
        Type[] typeArray = method.parameterTypes();
        String[] stringArray = StubSkeletonWriter.nameParameters(typeArray);
        Type type = methodDoc.returnType();
        ClassDoc[] classDocArray = method.exceptionTypes();
        indentingWriter.pln("// implementation of " + Util.getFriendlyUnqualifiedSignature(methodDoc));
        indentingWriter.p("public " + ((Object)type).toString() + " " + string + "(");
        for (n3 = 0; n3 < typeArray.length; ++n3) {
            if (n3 > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(((Object)typeArray[n3]).toString() + " " + stringArray[n3]);
        }
        indentingWriter.plnI(")");
        if (classDocArray.length > 0) {
            indentingWriter.p("throws ");
            for (n3 = 0; n3 < classDocArray.length; ++n3) {
                if (n3 > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(classDocArray[n3].qualifiedName());
            }
            indentingWriter.pln();
        }
        indentingWriter.pOlnI("{");
        List<ClassDoc> list = this.computeUniqueCatchList(classDocArray);
        if (list.size() > 0) {
            indentingWriter.plnI("try {");
        }
        if (this.version == Constants.StubVersion.VCOMPAT) {
            indentingWriter.plnI("if (useNewInvoke) {");
        }
        if (this.version == Constants.StubVersion.VCOMPAT || this.version == Constants.StubVersion.V1_2) {
            if (!Util.isVoid(type)) {
                indentingWriter.p("Object $result = ");
            }
            indentingWriter.p("ref.invoke(this, " + this.methodFieldNames[n] + ", ");
            if (typeArray.length > 0) {
                indentingWriter.p("new java.lang.Object[] {");
                for (n2 = 0; n2 < typeArray.length; ++n2) {
                    if (n2 > 0) {
                        indentingWriter.p(", ");
                    }
                    indentingWriter.p(StubSkeletonWriter.wrapArgumentCode(typeArray[n2], stringArray[n2]));
                }
                indentingWriter.p("}");
            } else {
                indentingWriter.p("null");
            }
            indentingWriter.pln(", " + method.methodHash() + "L);");
            if (!Util.isVoid(type)) {
                indentingWriter.pln("return " + StubSkeletonWriter.unwrapArgumentCode(type, "$result") + ";");
            }
        }
        if (this.version == Constants.StubVersion.VCOMPAT) {
            indentingWriter.pOlnI("} else {");
        }
        if (this.version == Constants.StubVersion.V1_1 || this.version == Constants.StubVersion.VCOMPAT) {
            indentingWriter.pln("java.rmi.server.RemoteCall call = ref.newCall((java.rmi.server.RemoteObject) this, operations, " + n + ", interfaceHash);");
            if (typeArray.length > 0) {
                indentingWriter.plnI("try {");
                indentingWriter.pln("java.io.ObjectOutput out = call.getOutputStream();");
                StubSkeletonWriter.writeMarshalArguments(indentingWriter, "out", typeArray, stringArray);
                indentingWriter.pOlnI("} catch (java.io.IOException e) {");
                indentingWriter.pln("throw new java.rmi.MarshalException(\"error marshalling arguments\", e);");
                indentingWriter.pOln("}");
            }
            indentingWriter.pln("ref.invoke(call);");
            if (Util.isVoid(type)) {
                indentingWriter.pln("ref.done(call);");
            } else {
                indentingWriter.pln(((Object)type).toString() + " $result;");
                indentingWriter.plnI("try {");
                indentingWriter.pln("java.io.ObjectInput in = call.getInputStream();");
                n2 = StubSkeletonWriter.writeUnmarshalArgument(indentingWriter, "in", type, "$result") ? 1 : 0;
                indentingWriter.pln(";");
                indentingWriter.pOlnI("} catch (java.io.IOException e) {");
                indentingWriter.pln("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
                if (n2 != 0) {
                    indentingWriter.pOlnI("} catch (java.lang.ClassNotFoundException e) {");
                    indentingWriter.pln("throw new java.rmi.UnmarshalException(\"error unmarshalling return\", e);");
                }
                indentingWriter.pOlnI("} finally {");
                indentingWriter.pln("ref.done(call);");
                indentingWriter.pOln("}");
                indentingWriter.pln("return $result;");
            }
        }
        if (this.version == Constants.StubVersion.VCOMPAT) {
            indentingWriter.pOln("}");
        }
        if (list.size() > 0) {
            for (ClassDoc classDoc : list) {
                indentingWriter.pOlnI("} catch (" + classDoc.qualifiedName() + " e) {");
                indentingWriter.pln("throw e;");
            }
            indentingWriter.pOlnI("} catch (java.lang.Exception e) {");
            indentingWriter.pln("throw new java.rmi.UnexpectedException(\"undeclared checked exception\", e);");
            indentingWriter.pOln("}");
        }
        indentingWriter.pOln("}");
    }

    private List<ClassDoc> computeUniqueCatchList(ClassDoc[] classDocArray) {
        ArrayList<ClassDoc> arrayList = new ArrayList<ClassDoc>();
        arrayList.add(this.env.docRuntimeException());
        arrayList.add(this.env.docRemoteException());
        block0: for (ClassDoc classDoc : classDocArray) {
            if (this.env.docException().subclassOf(classDoc)) {
                arrayList.clear();
                break;
            }
            if (!classDoc.subclassOf(this.env.docException())) continue;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                ClassDoc classDoc2 = (ClassDoc)iterator.next();
                if (classDoc.subclassOf(classDoc2)) continue block0;
                if (!classDoc2.subclassOf(classDoc)) continue;
                iterator.remove();
            }
            arrayList.add(classDoc);
        }
        return arrayList;
    }

    void writeSkeleton(IndentingWriter indentingWriter) throws IOException {
        int n;
        if (this.version == Constants.StubVersion.V1_2) {
            throw new AssertionError((Object)("should not generate skeleton for version " + (Object)((Object)this.version)));
        }
        indentingWriter.pln("// Skeleton class generated by rmic, do not edit.");
        indentingWriter.pln("// Contents subject to change without notice.");
        indentingWriter.pln();
        if (!this.packageName.equals("")) {
            indentingWriter.pln("package " + this.packageName + ";");
            indentingWriter.pln();
        }
        indentingWriter.plnI("public final class " + this.skeletonClassSimpleName);
        indentingWriter.pln("implements java.rmi.server.Skeleton");
        indentingWriter.pOlnI("{");
        this.writeOperationsArray(indentingWriter);
        indentingWriter.pln();
        this.writeInterfaceHash(indentingWriter);
        indentingWriter.pln();
        indentingWriter.plnI("public java.rmi.server.Operation[] getOperations() {");
        indentingWriter.pln("return (java.rmi.server.Operation[]) operations.clone();");
        indentingWriter.pOln("}");
        indentingWriter.pln();
        indentingWriter.plnI("public void dispatch(java.rmi.Remote obj, java.rmi.server.RemoteCall call, int opnum, long hash)");
        indentingWriter.pln("throws java.lang.Exception");
        indentingWriter.pOlnI("{");
        if (this.version == Constants.StubVersion.VCOMPAT) {
            indentingWriter.plnI("if (opnum < 0) {");
            if (this.remoteMethods.length > 0) {
                for (n = 0; n < this.remoteMethods.length; ++n) {
                    if (n > 0) {
                        indentingWriter.pO("} else ");
                    }
                    indentingWriter.plnI("if (hash == " + this.remoteMethods[n].methodHash() + "L) {");
                    indentingWriter.pln("opnum = " + n + ";");
                }
                indentingWriter.pOlnI("} else {");
            }
            indentingWriter.pln("throw new java.rmi.UnmarshalException(\"invalid method hash\");");
            if (this.remoteMethods.length > 0) {
                indentingWriter.pOln("}");
            }
            indentingWriter.pOlnI("} else {");
        }
        indentingWriter.plnI("if (hash != interfaceHash)");
        indentingWriter.pln("throw new java.rmi.server.SkeletonMismatchException(\"interface hash mismatch\");");
        indentingWriter.pO();
        if (this.version == Constants.StubVersion.VCOMPAT) {
            indentingWriter.pOln("}");
        }
        indentingWriter.pln();
        if (!this.remoteClass.classDoc().isPrivate()) {
            indentingWriter.pln(this.remoteClass.classDoc().qualifiedName() + " server = (" + this.remoteClass.classDoc().qualifiedName() + ") obj;");
        }
        indentingWriter.plnI("switch (opnum) {");
        for (n = 0; n < this.remoteMethods.length; ++n) {
            this.writeSkeletonDispatchCase(indentingWriter, n);
        }
        indentingWriter.pOlnI("default:");
        indentingWriter.pln("throw new java.rmi.UnmarshalException(\"invalid method number\");");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
        indentingWriter.pOln("}");
    }

    private void writeSkeletonDispatchCase(IndentingWriter indentingWriter, int n) throws IOException {
        RemoteClass.Method method = this.remoteMethods[n];
        MethodDoc methodDoc = method.methodDoc();
        String string = methodDoc.name();
        Type[] typeArray = method.parameterTypes();
        String[] stringArray = StubSkeletonWriter.nameParameters(typeArray);
        Type type = methodDoc.returnType();
        indentingWriter.pOlnI("case " + n + ": // " + Util.getFriendlyUnqualifiedSignature(methodDoc));
        indentingWriter.pOlnI("{");
        if (typeArray.length > 0) {
            int n2;
            for (n2 = 0; n2 < typeArray.length; ++n2) {
                indentingWriter.pln(((Object)typeArray[n2]).toString() + " " + stringArray[n2] + ";");
            }
            indentingWriter.plnI("try {");
            indentingWriter.pln("java.io.ObjectInput in = call.getInputStream();");
            n2 = StubSkeletonWriter.writeUnmarshalArguments(indentingWriter, "in", typeArray, stringArray) ? 1 : 0;
            indentingWriter.pOlnI("} catch (java.io.IOException e) {");
            indentingWriter.pln("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
            if (n2 != 0) {
                indentingWriter.pOlnI("} catch (java.lang.ClassNotFoundException e) {");
                indentingWriter.pln("throw new java.rmi.UnmarshalException(\"error unmarshalling arguments\", e);");
            }
            indentingWriter.pOlnI("} finally {");
            indentingWriter.pln("call.releaseInputStream();");
            indentingWriter.pOln("}");
        } else {
            indentingWriter.pln("call.releaseInputStream();");
        }
        if (!Util.isVoid(type)) {
            indentingWriter.p(((Object)type).toString() + " $result = ");
        }
        String string2 = this.remoteClass.classDoc().isPrivate() ? "((" + methodDoc.containingClass().qualifiedName() + ") obj)" : "server";
        indentingWriter.p(string2 + "." + string + "(");
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                indentingWriter.p(", ");
            }
            indentingWriter.p(stringArray[i]);
        }
        indentingWriter.pln(");");
        indentingWriter.plnI("try {");
        if (!Util.isVoid(type)) {
            indentingWriter.p("java.io.ObjectOutput out = ");
        }
        indentingWriter.pln("call.getResultStream(true);");
        if (!Util.isVoid(type)) {
            StubSkeletonWriter.writeMarshalArgument(indentingWriter, "out", type, "$result");
            indentingWriter.pln(";");
        }
        indentingWriter.pOlnI("} catch (java.io.IOException e) {");
        indentingWriter.pln("throw new java.rmi.MarshalException(\"error marshalling return\", e);");
        indentingWriter.pOln("}");
        indentingWriter.pln("break;");
        indentingWriter.pOlnI("}");
        indentingWriter.pln();
    }

    private void writeOperationsArray(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.plnI("private static final java.rmi.server.Operation[] operations = {");
        for (int i = 0; i < this.remoteMethods.length; ++i) {
            if (i > 0) {
                indentingWriter.pln(",");
            }
            indentingWriter.p("new java.rmi.server.Operation(\"" + this.remoteMethods[i].operationString() + "\")");
        }
        indentingWriter.pln();
        indentingWriter.pOln("};");
    }

    private void writeInterfaceHash(IndentingWriter indentingWriter) throws IOException {
        indentingWriter.pln("private static final long interfaceHash = " + this.remoteClass.interfaceHash() + "L;");
    }

    private void writeMethodFieldDeclarations(IndentingWriter indentingWriter) throws IOException {
        for (String string : this.methodFieldNames) {
            indentingWriter.pln("private static java.lang.reflect.Method " + string + ";");
        }
    }

    private void writeMethodFieldInitializers(IndentingWriter indentingWriter) throws IOException {
        for (int i = 0; i < this.methodFieldNames.length; ++i) {
            indentingWriter.p(this.methodFieldNames[i] + " = ");
            RemoteClass.Method method = this.remoteMethods[i];
            MethodDoc methodDoc = method.methodDoc();
            String string = methodDoc.name();
            Type[] typeArray = method.parameterTypes();
            indentingWriter.p(methodDoc.containingClass().qualifiedName() + ".class.getMethod(\"" + string + "\", new java.lang.Class[] {");
            for (int j = 0; j < typeArray.length; ++j) {
                if (j > 0) {
                    indentingWriter.p(", ");
                }
                indentingWriter.p(((Object)typeArray[j]).toString() + ".class");
            }
            indentingWriter.pln("});");
        }
    }

    private static String[] nameMethodFields(RemoteClass.Method[] methodArray) {
        String[] stringArray = new String[methodArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "$method_" + methodArray[i].methodDoc().name() + "_" + i;
        }
        return stringArray;
    }

    private static String[] nameParameters(Type[] typeArray) {
        String[] stringArray = new String[typeArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = "$param_" + StubSkeletonWriter.generateNameFromType(typeArray[i]) + "_" + (i + 1);
        }
        return stringArray;
    }

    private static String generateNameFromType(Type type) {
        String string = type.typeName().replace('.', '$');
        int n = type.dimension().length() / 2;
        for (int i = 0; i < n; ++i) {
            string = "arrayOf_" + string;
        }
        return string;
    }

    private static void writeMarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        if (type.dimension().length() > 0 || type.asClassDoc() != null) {
            indentingWriter.p(string + ".writeObject(" + string2 + ")");
        } else if (type.typeName().equals("boolean")) {
            indentingWriter.p(string + ".writeBoolean(" + string2 + ")");
        } else if (type.typeName().equals("byte")) {
            indentingWriter.p(string + ".writeByte(" + string2 + ")");
        } else if (type.typeName().equals("char")) {
            indentingWriter.p(string + ".writeChar(" + string2 + ")");
        } else if (type.typeName().equals("short")) {
            indentingWriter.p(string + ".writeShort(" + string2 + ")");
        } else if (type.typeName().equals("int")) {
            indentingWriter.p(string + ".writeInt(" + string2 + ")");
        } else if (type.typeName().equals("long")) {
            indentingWriter.p(string + ".writeLong(" + string2 + ")");
        } else if (type.typeName().equals("float")) {
            indentingWriter.p(string + ".writeFloat(" + string2 + ")");
        } else if (type.typeName().equals("double")) {
            indentingWriter.p(string + ".writeDouble(" + string2 + ")");
        } else {
            throw new AssertionError(type);
        }
    }

    private static void writeMarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        assert (typeArray.length == stringArray.length);
        for (int i = 0; i < typeArray.length; ++i) {
            StubSkeletonWriter.writeMarshalArgument(indentingWriter, string, typeArray[i], stringArray[i]);
            indentingWriter.pln(";");
        }
    }

    private static boolean writeUnmarshalArgument(IndentingWriter indentingWriter, String string, Type type, String string2) throws IOException {
        boolean bl = false;
        if (string2 != null) {
            indentingWriter.p(string2 + " = ");
        }
        if (type.dimension().length() > 0 || type.asClassDoc() != null) {
            indentingWriter.p("(" + ((Object)type).toString() + ") " + string + ".readObject()");
            bl = true;
        } else if (type.typeName().equals("boolean")) {
            indentingWriter.p(string + ".readBoolean()");
        } else if (type.typeName().equals("byte")) {
            indentingWriter.p(string + ".readByte()");
        } else if (type.typeName().equals("char")) {
            indentingWriter.p(string + ".readChar()");
        } else if (type.typeName().equals("short")) {
            indentingWriter.p(string + ".readShort()");
        } else if (type.typeName().equals("int")) {
            indentingWriter.p(string + ".readInt()");
        } else if (type.typeName().equals("long")) {
            indentingWriter.p(string + ".readLong()");
        } else if (type.typeName().equals("float")) {
            indentingWriter.p(string + ".readFloat()");
        } else if (type.typeName().equals("double")) {
            indentingWriter.p(string + ".readDouble()");
        } else {
            throw new AssertionError(type);
        }
        return bl;
    }

    private static boolean writeUnmarshalArguments(IndentingWriter indentingWriter, String string, Type[] typeArray, String[] stringArray) throws IOException {
        assert (typeArray.length == stringArray.length);
        boolean bl = false;
        for (int i = 0; i < typeArray.length; ++i) {
            if (StubSkeletonWriter.writeUnmarshalArgument(indentingWriter, string, typeArray[i], stringArray[i])) {
                bl = true;
            }
            indentingWriter.pln(";");
        }
        return bl;
    }

    private static String wrapArgumentCode(Type type, String string) {
        if (type.dimension().length() > 0 || type.asClassDoc() != null) {
            return string;
        }
        if (type.typeName().equals("boolean")) {
            return "(" + string + " ? java.lang.Boolean.TRUE : java.lang.Boolean.FALSE)";
        }
        if (type.typeName().equals("byte")) {
            return "new java.lang.Byte(" + string + ")";
        }
        if (type.typeName().equals("char")) {
            return "new java.lang.Character(" + string + ")";
        }
        if (type.typeName().equals("short")) {
            return "new java.lang.Short(" + string + ")";
        }
        if (type.typeName().equals("int")) {
            return "new java.lang.Integer(" + string + ")";
        }
        if (type.typeName().equals("long")) {
            return "new java.lang.Long(" + string + ")";
        }
        if (type.typeName().equals("float")) {
            return "new java.lang.Float(" + string + ")";
        }
        if (type.typeName().equals("double")) {
            return "new java.lang.Double(" + string + ")";
        }
        throw new AssertionError(type);
    }

    private static String unwrapArgumentCode(Type type, String string) {
        if (type.dimension().length() > 0 || type.asClassDoc() != null) {
            return "((" + ((Object)type).toString() + ") " + string + ")";
        }
        if (type.typeName().equals("boolean")) {
            return "((java.lang.Boolean) " + string + ").booleanValue()";
        }
        if (type.typeName().equals("byte")) {
            return "((java.lang.Byte) " + string + ").byteValue()";
        }
        if (type.typeName().equals("char")) {
            return "((java.lang.Character) " + string + ").charValue()";
        }
        if (type.typeName().equals("short")) {
            return "((java.lang.Short) " + string + ").shortValue()";
        }
        if (type.typeName().equals("int")) {
            return "((java.lang.Integer) " + string + ").intValue()";
        }
        if (type.typeName().equals("long")) {
            return "((java.lang.Long) " + string + ").longValue()";
        }
        if (type.typeName().equals("float")) {
            return "((java.lang.Float) " + string + ").floatValue()";
        }
        if (type.typeName().equals("double")) {
            return "((java.lang.Double) " + string + ").doubleValue()";
        }
        throw new AssertionError(type);
    }
}

