/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.perfdata.monitor.protocol.local;

import java.io.File;
import java.io.FilenameFilter;

public class PerfDataFile {
    public static final String tmpDirName;
    public static final String dirNamePrefix = "hsperfdata_";
    public static final String userDirNamePattern = "hsperfdata_\\S*";
    public static final String fileNamePattern = "^[0-9]+$";
    public static final String tmpFileNamePattern = "^hsperfdata_[0-9]+(_[1-2]+)?$";

    private PerfDataFile() {
    }

    public static File getFile(int n) {
        if (n == 0) {
            return null;
        }
        File file = new File(tmpDirName);
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                if (!string.startsWith(PerfDataFile.dirNamePrefix)) {
                    return false;
                }
                File file2 = new File(file, string);
                return (file2.isDirectory() || file2.isFile()) && file2.canRead();
            }
        });
        long l = 0L;
        File file2 = null;
        for (int i = 0; i < stringArray.length; ++i) {
            long l2;
            File file3 = new File(tmpDirName + stringArray[i]);
            File file4 = null;
            if (file3.exists() && file3.isDirectory()) {
                String string = Integer.toString(n);
                file4 = new File(file3.getName(), string);
            } else {
                file4 = file3.exists() && file3.isFile() ? file3 : file3;
            }
            if (!file4.exists() || !file4.isFile() || !file4.canRead() || (l2 = file4.lastModified()) < l) continue;
            l = l2;
            file2 = file4;
        }
        return file2;
    }

    public static File getFile(String string, int n) {
        if (n == 0) {
            return null;
        }
        String string2 = PerfDataFile.getTempDirectory(string) + Integer.toString(n);
        File file = new File(string2);
        if (file.exists() && file.isFile() && file.canRead()) {
            return file;
        }
        long l = 0L;
        File file2 = null;
        for (int i = 0; i < 2; ++i) {
            long l2;
            string2 = i == 0 ? PerfDataFile.getTempDirectory() + Integer.toString(n) : PerfDataFile.getTempDirectory() + Integer.toString(n) + Integer.toString(i);
            file = new File(string2);
            if (!file.exists() || !file.isFile() || !file.canRead() || (l2 = file.lastModified()) < l) continue;
            l = l2;
            file2 = file;
        }
        return file2;
    }

    public static int getLocalVmId(File file) {
        boolean bl = false;
        try {
            return Integer.parseInt(file.getName());
        }
        catch (NumberFormatException numberFormatException) {
            String string = file.getName();
            if (string.startsWith(dirNamePrefix)) {
                int n = string.indexOf(95);
                int n2 = string.lastIndexOf(95);
                try {
                    if (n == n2) {
                        return Integer.parseInt(string.substring(n + 1));
                    }
                    return Integer.parseInt(string.substring(n + 1, n2));
                }
                catch (NumberFormatException numberFormatException2) {
                    // empty catch block
                }
            }
            throw new IllegalArgumentException("file name does not match pattern");
        }
    }

    public static String getTempDirectory() {
        return tmpDirName;
    }

    public static String getTempDirectory(String string) {
        return tmpDirName + dirNamePrefix + string + File.separator;
    }

    static {
        String string = System.getProperty("java.io.tmpdir");
        if (string.compareTo("/var/tmp/") == 0) {
            string = "/tmp/";
        }
        if (string.lastIndexOf(File.separator) != string.length() - 1) {
            string = string + File.separator;
        }
        tmpDirName = string;
    }
}

