/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.ws.wsdl.parser;

import com.sun.tools.internal.ws.util.xml.NullEntityResolver;
import com.sun.tools.internal.ws.wsdl.document.schema.Schema;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaAttribute;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaConstants;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaDocument;
import com.sun.tools.internal.ws.wsdl.document.schema.SchemaElement;
import com.sun.tools.internal.ws.wsdl.framework.ParseException;
import com.sun.tools.internal.ws.wsdl.framework.ParserContext;
import com.sun.tools.internal.ws.wsdl.framework.ValidationException;
import com.sun.tools.internal.ws.wsdl.parser.Util;
import com.sun.xml.internal.ws.util.xml.NamedNodeMapIterator;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SchemaParser {
    private boolean _followImports;
    private static final String PREFIX_XMLNS = "xmlns";
    private static final String PREFIX_XMLNS_COLON = "xmlns:";

    public boolean getFollowImports() {
        return this._followImports;
    }

    public void setFollowImports(boolean bl) {
        this._followImports = bl;
    }

    public SchemaDocument parse(InputSource inputSource) {
        SchemaDocument schemaDocument = new SchemaDocument();
        schemaDocument.setSystemId(inputSource.getSystemId());
        ParserContext parserContext = new ParserContext(schemaDocument, null);
        parserContext.setFollowImports(this._followImports);
        schemaDocument.setSchema(this.parseSchema(parserContext, inputSource, null));
        return schemaDocument;
    }

    public Schema parseSchema(ParserContext parserContext, InputSource inputSource, String string) {
        Schema schema = this.parseSchemaNoImport(parserContext, inputSource, string);
        schema.defineAllEntities();
        this.processImports(parserContext, inputSource, schema);
        return schema;
    }

    public Schema parseSchema(ParserContext parserContext, Element element, String string) {
        Schema schema = this.parseSchemaNoImport(parserContext, element, string);
        schema.defineAllEntities();
        this.processImports(parserContext, null, schema);
        return schema;
    }

    protected void processImports(ParserContext parserContext, InputSource inputSource, Schema schema) {
        Iterator iterator = schema.getContent().children();
        while (iterator.hasNext()) {
            String string;
            String string2;
            SchemaElement schemaElement = (SchemaElement)iterator.next();
            if (schemaElement.getQName().equals(SchemaConstants.QNAME_IMPORT)) {
                string2 = schemaElement.getValueOfAttributeOrNull("schemaLocation");
                string = schemaElement.getValueOfAttributeOrNull("namespace");
                if (string2 == null) continue;
                String string3 = null;
                if (inputSource != null && inputSource.getSystemId() != null) {
                    string3 = Util.processSystemIdWithBase(inputSource.getSystemId(), string2);
                }
                if (string3 == null) {
                    String string4 = string3 = parserContext.getWSDLLocation() == null ? string2 : Util.processSystemIdWithBase(parserContext.getWSDLLocation(), string2);
                }
                if (parserContext.getDocument().isImportedDocument(string3)) continue;
                parserContext.getDocument().addImportedEntity(this.parseSchema(parserContext, new InputSource(string3), string));
                parserContext.getDocument().addImportedDocument(string3);
                continue;
            }
            if (schemaElement.getQName().equals(SchemaConstants.QNAME_INCLUDE) && schema.getTargetNamespaceURI() != null) {
                string2 = schemaElement.getValueOfAttributeOrNull("schemaLocation");
                if (string2 == null || parserContext.getDocument().isIncludedDocument(string2)) continue;
                parserContext.getDocument().addIncludedDocument(string2);
                string = null;
                if (inputSource != null && inputSource.getSystemId() != null) {
                    string = Util.processSystemIdWithBase(inputSource.getSystemId(), string2);
                }
                if (string == null) {
                    string = parserContext.getDocument().getSystemId() == null ? string2 : Util.processSystemIdWithBase(parserContext.getDocument().getSystemId(), string2);
                }
                parserContext.getDocument().addIncludedEntity(this.parseSchema(parserContext, new InputSource(string), schema.getTargetNamespaceURI()));
                continue;
            }
            if (!schemaElement.getQName().equals(SchemaConstants.QNAME_REDEFINE)) continue;
            Util.fail("validation.unsupportedSchemaFeature", "redefine");
        }
    }

    protected Schema parseSchemaNoImport(ParserContext parserContext, InputSource inputSource, String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new ErrorHandler(){

                public void error(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
                    throw sAXParseException;
                }

                public void warning(SAXParseException sAXParseException) throws SAXParseException {
                }
            });
            documentBuilder.setEntityResolver(new NullEntityResolver());
            try {
                Document document = documentBuilder.parse(inputSource);
                return this.parseSchemaNoImport(parserContext, document, string);
            }
            catch (IOException iOException) {
                throw new ParseException("parsing.ioException", iOException);
            }
            catch (SAXException sAXException) {
                throw new ParseException("parsing.saxException", sAXException);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new ParseException("parsing.parserConfigException", parserConfigurationException);
        }
        catch (FactoryConfigurationError factoryConfigurationError) {
            throw new ParseException("parsing.factoryConfigException", factoryConfigurationError);
        }
    }

    protected Schema parseSchemaNoImport(ParserContext parserContext, Document document, String string) {
        Element element = document.getDocumentElement();
        Util.verifyTagNSRootElement(element, SchemaConstants.QNAME_SCHEMA);
        return this.parseSchemaNoImport(parserContext, element, string);
    }

    protected Schema parseSchemaNoImport(ParserContext parserContext, Element element, String string) {
        Schema schema = new Schema(parserContext.getDocument());
        String string2 = XmlUtil.getAttributeOrNull((Element)element, (String)"targetNamespace");
        if (string2 != null && string != null && !string.equals(string2)) {
            throw new ValidationException("validation.incorrectTargetNamespace", string2, string);
        }
        if (string2 == null) {
            schema.setTargetNamespaceURI(string);
        } else {
            schema.setTargetNamespaceURI(string2);
        }
        Object object = parserContext.getPrefixes();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            String string4 = parserContext.getNamespaceURI(string3);
            if (string4 == null) {
                throw new ParseException("parsing.shouldNotHappen", new Object[0]);
            }
            schema.addPrefix(string3, string4);
        }
        parserContext.push();
        parserContext.registerNamespaces(element);
        object = new SchemaElement(SchemaConstants.QNAME_SCHEMA);
        this.copyNamespaceDeclarations((SchemaElement)object, element);
        this.copyAttributesNoNs((SchemaElement)object, element);
        this.copyElementContent((SchemaElement)object, element);
        schema.setContent((SchemaElement)object);
        ((SchemaElement)object).setSchema(schema);
        parserContext.pop();
        parserContext.fireDoneParsingEntity(SchemaConstants.QNAME_SCHEMA, schema);
        return schema;
    }

    protected void copyAttributesNoNs(SchemaElement schemaElement, Element element) {
        NamedNodeMapIterator namedNodeMapIterator = new NamedNodeMapIterator(element.getAttributes());
        while (namedNodeMapIterator.hasNext()) {
            Attr attr = (Attr)namedNodeMapIterator.next();
            if (attr.getName().equals(PREFIX_XMLNS) || attr.getName().startsWith(PREFIX_XMLNS_COLON)) continue;
            SchemaAttribute schemaAttribute = new SchemaAttribute(attr.getLocalName());
            schemaAttribute.setNamespaceURI(attr.getNamespaceURI());
            schemaAttribute.setValue(attr.getValue());
            schemaElement.addAttribute(schemaAttribute);
        }
    }

    protected void copyNamespaceDeclarations(SchemaElement schemaElement, Element element) {
        NamedNodeMapIterator namedNodeMapIterator = new NamedNodeMapIterator(element.getAttributes());
        while (namedNodeMapIterator.hasNext()) {
            Attr attr = (Attr)namedNodeMapIterator.next();
            if (attr.getName().equals(PREFIX_XMLNS)) {
                schemaElement.addPrefix("", attr.getValue());
                continue;
            }
            String string = XmlUtil.getPrefix((String)attr.getName());
            if (string == null || !string.equals(PREFIX_XMLNS)) continue;
            String string2 = XmlUtil.getLocalPart((String)attr.getName());
            String string3 = attr.getValue();
            schemaElement.addPrefix(string2, string3);
        }
    }

    protected void copyElementContent(SchemaElement schemaElement, Element element) {
        Element element2;
        Iterator iterator = XmlUtil.getAllChildren((Element)element);
        while (iterator.hasNext() && (element2 = Util.nextElementIgnoringCharacterContent(iterator)) != null) {
            SchemaElement schemaElement2 = new SchemaElement(element2.getLocalName());
            schemaElement2.setNamespaceURI(element2.getNamespaceURI());
            this.copyNamespaceDeclarations(schemaElement2, element2);
            this.copyAttributesNoNs(schemaElement2, element2);
            this.copyElementContent(schemaElement2, element2);
            schemaElement.addChild(schemaElement2);
            schemaElement2.setParent(schemaElement);
        }
    }
}

