/******************************************************************************
 * Header file for Rage 128 Chapter 8 sample code                             *
 * Includes structures, prototypes, and globals.                              *
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#ifndef _MAINRT_H
#define _MAINRT_H

// use chap8 main.h
#include "..\..\chap8\util\main.h"

// Rage Theatre's Logical Register Listings:
typedef enum tagRTLOGREGS
{
  fld_tmpReg1=0,
  fld_tmpReg2,
  fld_tmpReg3,
  fld_LP_CONTRAST,
  fld_LP_BRIGHTNESS,
  fld_CP_HUE_CNTL,
  fld_LUMA_FILTER,
  fld_H_SCALE_RATIO,
  fld_H_SHARPNESS,
  fld_V_SCALE_RATIO,
  fld_V_DEINTERLACE_ON,
  fld_V_BYPSS,
  fld_V_DITHER_ON,
  fld_EVENF_OFFSET,
  fld_ODDF_OFFSET,
  fld_INTERLACE_DETECTED,
  fld_VS_LINE_COUNT,
  fld_VS_DETECTED_LINES,
  fld_VS_ITU656_VB,
  fld_VBI_CC_DATA,
  fld_VBI_CC_WT,
  fld_VBI_CC_WT_ACK,
  fld_VBI_CC_HOLD,
  fld_VBI_DECODE_EN,
  fld_VBI_CC_DTO_P,
  fld_VBI_20BIT_DTO_P,
  fld_VBI_CC_LEVEL,
  fld_VBI_20BIT_LEVEL,
  fld_VBI_CLK_RUNIN_GAIN,
  fld_H_VBI_WIND_START,
  fld_H_VBI_WIND_END,
  fld_V_VBI_WIND_START,
  fld_V_VBI_WIND_END,
  fld_VBI_20BIT_DATA0,
  fld_VBI_20BIT_DATA1,
  fld_VBI_20BIT_WT,
  fld_VBI_20BIT_WT_ACK,
  fld_VBI_20BIT_HOLD,
  fld_VBI_CAPTURE_ENABLE,
  fld_VBI_EDS_DATA,
  fld_VBI_EDS_WT,
  fld_VBI_EDS_WT_ACK,
  fld_VBI_EDS_HOLD,
  fld_VBI_SCALING_RATIO,
  fld_VBI_ALIGNER_ENABLE,
  fld_H_ACTIVE_START,
  fld_H_ACTIVE_END,
  fld_V_ACTIVE_START,
  fld_V_ACTIVE_END,
  fld_CH_HEIGHT,
  fld_CH_KILL_LEVEL,
  fld_CH_AGC_ERROR_LIM,
  fld_CH_AGC_FILTER_EN,
  fld_CH_AGC_LOOP_SPEED,
  fld_HUE_ADJ,
  fld_STANDARD_SEL,
  fld_STANDARD_YC,
  fld_ADC_PDWN,
  fld_INPUT_SELECT,
  fld_ADC_PREFLO,
  fld_H_SYNC_PULSE_WIDTH,
  fld_HS_GENLOCKED,
  fld_HS_SYNC_IN_WIN,
  fld_VIN_ASYNC_RST,
  fld_DVS_ASYNC_RST,
  fld_VIP_VENDOR_ID,
  fld_VIP_DEVICE_ID,
  fld_VIP_REVISION_ID,
  fld_BLACK_INT_START,
  fld_BLACK_INT_LENGTH,
  fld_UV_INT_START,
  fld_U_INT_LENGTH,
  fld_V_INT_LENGTH,
  fld_CRDR_ACTIVE_GAIN,
  fld_CBDB_ACTIVE_GAIN,
  fld_DVS_DIRECTION,
  fld_DVS_VBI_BYTE_SWAP,
  fld_DVS_CLK_SELECT,
  fld_CONTINUOUS_STREAM,
  fld_DVSOUT_CLK_DRV,
  fld_DVSOUT_DATA_DRV,
  fld_COMB_CNTL0,
  fld_COMB_CNTL1,
  fld_COMB_CNTL2,
  fld_COMB_LENGTH,
  fld_SYNCTIP_REF0,
  fld_SYNCTIP_REF1,
  fld_CLAMP_REF,
  fld_AGC_PEAKWHITE,
  fld_VBI_PEAKWHITE,
  fld_WPA_THRESHOLD,
  fld_WPA_TRIGGER_LO,
  fld_WPA_TRIGGER_HIGH,
  fld_LOCKOUT_START,
  fld_LOCKOUT_END,
  fld_CH_DTO_INC,
  fld_PLL_SGAIN,
  fld_PLL_FGAIN,
  fld_CR_BURST_GAIN,
  fld_CB_BURST_GAIN,
  fld_VERT_LOCKOUT_START,
  fld_VERT_LOCKOUT_END,
  fld_H_IN_WIND_START,
  fld_V_IN_WIND_START,
  fld_H_OUT_WIND_WIDTH,
  fld_V_OUT_WIND_WIDTH,
  fld_HS_LINE_TOTAL,
  fld_MIN_PULSE_WIDTH,
  fld_MAX_PULSE_WIDTH,
  fld_WIN_CLOSE_LIMIT,
  fld_WIN_OPEN_LIMIT,
  fld_VSYNC_INT_TRIGGER,
  fld_VSYNC_INT_HOLD,
  fld_VIN_M0,
  fld_VIN_N0,
  fld_MNFLIP_EN,
  fld_VIN_P,
  fld_REG_CLK_SEL,
  fld_VIN_M1,
  fld_VIN_N1,
  fld_VIN_DRIVER_SEL,
  fld_VIN_MNFLIP_REQ,
  fld_VIN_MNFLIP_DONE,
  fld_TV_LOCK_TO_VIN,
  fld_TV_P_FOR_WINCLK,
  fld_VINRST,
  fld_VIN_CLK_SEL,
  fld_VS_FIELD_BLANK_START,
  fld_VS_FIELD_BLANK_END,
  fld_VS_FIELD_IDLOCATION,
  fld_VS_FRAME_TOTAL,
  fld_SYNC_TIP_START,
  fld_SYNC_TIP_LENGTH,
  fld_GAIN_FORCE_DATA,
  fld_GAIN_FORCE_EN,
  fld_I_CLAMP_SEL,
  fld_I_AGC_SEL,
  fld_EXT_CLAMP_CAP,
  fld_EXT_AGC_CAP,
  fld_DECI_DITHER_EN,
  fld_ADC_PREFHI,
  fld_ADC_CH_GAIN_SEL,
  fld_HS_PLL_SGAIN,
  fld_NREn,
  fld_NRGainCntl,
  fld_NRBWTresh,
  fld_NRGCTresh,
  fld_NRCoefDespeclMode,
  fld_GPIO_5_OE,
  fld_GPIO_6_OE,
  fld_GPIO_5_OUT,
  fld_GPIO_6_OUT,

  //  End of Rage Theatre Logical Registers used for Video In
  regRT_MAX_REGS
} RTLOGREGS;

// Rage Theatre's Logical Field Mappings:
typedef struct tagRTREGMAP {
    BYTE     bSize;             // size of the field in bits
    DWORD    dwFldName;         // Name of the field.
    DWORD    dwRegAddrLSBs;     // Register Addr the field belongs to.
    DWORD    dwFldOffsetLSBs;   // Field's offset.
    DWORD    dwMaskLSBs;        // Field's Mask.
    DWORD    dwRegAddrMSBs;     // Register Addr the field belongs to. (in case Field overlap 2 registers NOT USED NOW)
    DWORD    dwFldOffsetMSBs;   // Field's offset.                     (NOT USED NOW)
    DWORD    dwMaskMSBs;        // Field's Mask.                       (NOT USED NOW)
    DWORD    dwCurrValue;       // Current Value;
    BYTE     RegStatus;         // read only - 1, otherwise - 0
} RTREGMAP;

// Rage Theatre's Access Type:
typedef enum tagRTACCESSTYPE {
                                    UNKNOWN = 0,      // Unknown or Error
                                    VIP_ACCESS,       // VIP Access
                                    MPP_ACCESS        // MPP Access
} RTACCESSTYPE;

// Rage Theatre Chip Information and Status:
typedef struct {
    RTACCESSTYPE            bAccessType;                    //VIP, MPP....
    DWORD                   dwChannel;                      //VIP, MPP Channel
    BYTE                    bChipID;                        //Chip ID defined in decode.h
    DWORD                   dwCapability;                   //Chip's capability.
    WORD                    wConnector;                     //Current Connector
    WORD                    wStandard;                      //Current standard
    WORD                    wSharpness;                     //Current Sharpness.
    WORD                    wSaturation_V;
    WORD                    wSaturation_U;
    double                  dbContrast;
    double                  dbBrightnessRatio;
    WORD                    wInterlaced;
    WORD                    wHorDelay_Start;
    WORD                    wVertDelay_Start;
    WORD                    wHorSize_End;
    WORD                    wVertSize_End;
    DWORD                   dwHorzScalingRatio;
    DWORD                   dwVertScalingRatio;
    WORD                    wTunerConnector;
    WORD                    wComp0Connector;
    WORD                    wSVideo0Connector;
    int                     iSaturation;
    int                     iBrightness;
    int                     iContrast;
    int                     iHue;
    RTREGMAP                RegsMap[regRT_MAX_REGS];
} RTINFO;

// Function prototypes in RT_REGS.C
void WriteRT_fld (DWORD dwReg, DWORD dwData);
DWORD ReadRT_fld (DWORD dwReg);

// Prototypes in DECFUNC.C
void RT_Init (void);
void RT_ResetVideoLevels (void);
void RT_SetTint (int hue);
void RT_SetSaturation (int Saturation);
void RT_SetBrightness (int Brightness);
void RT_SetSharpness (WORD wSharpness);
void RT_SetContrast (int Contrast);
void RT_SetInterlace (BYTE bInterlace);
void RT_SetStandard (WORD wStandard);
void RT_SetVINClock (WORD wStandard);
void RT_SetCombFilter (WORD wStandard, WORD wConnector);
void RT_SetConnector (WORD wConnector, int tunerFlag);
void RT_SetOutputVideoSize (WORD wHorzSize, WORD wVertSize, BYTE fCC_On, BYTE fVBICap_On);
void GetStandardConstants (double *LPeriod, double *FPeriod, double *Fsamp, WORD wStandard);
void CalculateCrCbGain (double *CrGain, double *CbGain, WORD wStandard);
void RT_InitInfoStruct (void);
void RT_EnableDecoder (void);
void RT_ShutDown (void);

// Function prototypes in 3430.C
void EnableMSP3430 (void);
void DisableMSP3430 (void);
void SetMSP3430Data (BYTE RegAddress, BYTE RegSubAddressHigh, BYTE RegSubAddressLow,
                     BYTE RegValueHigh, BYTE RegValueLow);
void SetMSP3430Control (BYTE RegAddress, BYTE RegValueHigh, BYTE RegValueLow);
void GetMSP3430Data (BYTE RegAddress, BYTE RegSubAddressHigh, BYTE RegSubAddressLow,
                 BYTE *RegValueHigh, BYTE *RegValueLow);
WORD ReadI2CWord (WORD Register, WORD SubAddr);
void WriteI2CWord (WORD Register, WORD SubAddr, WORD Data);
BYTE MSP_I2C_Set (BYTE address, BYTE num_data, BYTE *data);
void MSP3430_SetVolume (BYTE value);

// Functions in VIPRW.C
int RT_GetVIPAddress (void);
DWORD VIP_Write (DWORD DeviceNum, BYTE RegOrFifo, DWORD Address,
                 DWORD WriteSize, DWORD Data);
DWORD VIP_Read (DWORD DeviceNum, BYTE RegOrFifo, DWORD Address,
                DWORD ReadSize, DWORD *Data);
void R128_InitVIP (void);
BYTE R128_VIPIdle (void);
DWORD RT_regr (DWORD reg, DWORD *data);
DWORD RT_regw (DWORD reg, DWORD data);

// functions in RTUTIL.C
WORD TickCount (void);
void ReadRT_VINregs (void);
void ReadRTRegs (void);

// Globals
extern int RT_DEVICE_NUM;
extern RTINFO RT_DATA, *RT_INFO;
extern _MMTABLE MMTABLE;
extern RTREGMAP RT_RegMap[regRT_MAX_REGS];

#endif // MAINRT_H

