/****************************************************************************
 * OVERLAY.C                                                                *
 *                                                                          *
 *  This program initializes and uses the overlay to display a test file.   *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved            *
 ****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include "..\util\main.h"
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\overlay.h"

extern OVERLAY_DESCRIPTOR OverlayDescriptor;
extern OVERLAY_REG_FIELDS OverlayRegFields;

/****************************************************************************
 * Main Program to demonstrate the hardware overlay of the Rage 128         *
 *  Function: A test image is displayed using the hardware overlay.         *
 *            Random locations and scaling of the image are performed.      *
 *    Inputs: Arguments for mode spatial and colour resolution              *
 *   Outputs: NONE                                                          *
 ****************************************************************************/
void main (int argc, char *argv[])
{
    WORD x, y, width, height;
    DWORD temp, offscreen;
    _img_info IMG;
    SURFACE Surface;

    R128_StartUp (argc, argv);
    R128_ClearScreen (WHITE);

    temp = 0xB; /* for a UYVY image */

    /* Load image into offscreen memory */
    /* However, make sure the address is 1024 byte aligned. */
    offscreen = R128_AdapterInfo.xres * R128_AdapterInfo.yres * R128_AdapterInfo.bytepp;
    offscreen = (DWORD)(((float)offscreen + 1023.0) / 1024.0) * 1024;
    // Calculate the x and y values where the image will be loaded.
    y = (offscreen/R128_AdapterInfo.bytepp)/R128_AdapterInfo.xres;
    x = (offscreen/R128_AdapterInfo.bytepp)%R128_AdapterInfo.xres;

    IMG = Load_Image (TRAJECTORY_LINEAR, temp, x, y);

    /* CreateSurface for the overlay data */
    CreateSurface (IMG.width, IMG.height, temp, 0, offscreen, &Surface);

    R128_InitOverlayDescriptor (&OverlayDescriptor);
    R128_GetBandwidthInfo (&OverlayDescriptor);
    R128_SetOverlayDefaults (temp, IMG.width, IMG.height, 1.0, 1.0, &OverlayDescriptor);

    OverlayDescriptor.SimpleSurfacePitch = IMG.bytepp * IMG.width;

    OverlayDescriptor.SimpleBaseOffsetOfSurface = offscreen;

    R128_SetupOverlay (&OverlayDescriptor, &OverlayRegFields);
    R128_WriteOverlayFields (&OverlayRegFields);

    /* Reset deinterlace pattern mode */
    regw (OV0_AUTO_FLIP_CNTRL, (regr (OV0_AUTO_FLIP_CNTRL) ^ 0x40 ));
    regw (OV0_AUTO_FLIP_CNTRL, (regr (OV0_AUTO_FLIP_CNTRL) ^ 0x40 ));

    /* while (getch () != 32) */
    while (!kbhit ())
    {
        x = rand()%(R128_AdapterInfo.xres - 32);
        y = rand()%(R128_AdapterInfo.yres - 32);
        width = rand()%(R128_AdapterInfo.xres - x);
        if (width <= 32) width = 32;
        height = rand()%(R128_AdapterInfo.yres - y);
        if (height <= 32) height = 32;

        R128_SetOverlay (x, y, width, height);
        R128_Delay (5);
    }

    getch ();

    /* Disable the overlay */
    R128_DisableOverlay ();

    R128_ShutDown ();
    exit (0);                       // no errors.

} /* main () */

