/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * polyline.c - This program demonstrates how to use Rage 128 Type-3        *
 * command packets to draw a 2D polyline.                                   *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <conio.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"
#include "..\util\cce.h"


/****************************************************************************
 * main                                                                     *
 *  Function: Main loop.                                                    *
 *    Inputs: none                                                          *
 *   Outputs: none                                                          *
 ****************************************************************************/

void main (int argc, char *argv[])
{
    DWORD Buf[20];
    DWORD x, y, colour;
    int test;
    int i, j;

    printf ("Rage 128 Sample Code, Chapter 6.\n"
        "POLYLINE.EXE\n\n"
        "This program demonstrates how to use Rage 128 Type-3 command packets\n"
        "to draw a 2D polyline.\n\n"
        "Mode resolution (eg 640 480) and colour depth (8, 15, 16, 24, 32)\n"
        "should be passed as command line arguments.\n"
        "Default resolution and colour depth is 640x480, 8bpp.\n\n"
        "Press any key to continue.\n\n");

    getch ();

    // First, run StartUp function to set up the application

    R128_StartUp (argc, argv);

    // Clear the screen

    R128_ClearScreen (BLACK);

    // Initialize the CCE microengine.

    if (R128_CCEInit (CCE_MODE_192BM) != CCE_SUCCESS)
    {
        R128_ShutDown ();
        printf ("R128_CCEInit failed!!\n");
        exit (1);
    } // if

    // Draw the outline of a rectangle using a 2D polyline packet:

    // Set up a polyline packet and fill the header with packet size
    // Note that packet size is two less than total number of packets sent

    i=0;
    Buf[i++] = CCE_PACKET3_CNTL_POLYLINE;

    // Compose GUI_CONTROL

    Buf[i++] = CCE_GC_BRUSH_SOLIDCOLOR | CCE_GC_SRC_DSTCOLOR | ROP3_PATCOPY |
               (R128_GetBPPValue (R128_AdapterInfo.bpp) << 8);

    // Colour used to draw the line due to CCE_GC_BRUSH_SOLIDCOLOR

    Buf[i++] = R128_GetColourCode (WHITE);

    // Fill rectangle data into packet:

    // top, left

    x = R128_AdapterInfo.xres * 0.2f;
    y = R128_AdapterInfo.yres * 0.2f;

    Buf[i++] = x + (y << 16);

    // top, right

    x = R128_AdapterInfo.xres * 0.8f;
    y = R128_AdapterInfo.yres * 0.2f;

    Buf[i++] = x + (y << 16);

    // bottom, right

    x = R128_AdapterInfo.xres * 0.8f;
    y = R128_AdapterInfo.yres * 0.8f;

    Buf[i++] = x + (y << 16);

    // bottom, left

    x = R128_AdapterInfo.xres * 0.2f;
    y = R128_AdapterInfo.yres * 0.8f;

    Buf[i++] = x + (y << 16);

    // top, left again

    x = R128_AdapterInfo.xres * 0.2f;
    y = R128_AdapterInfo.yres * 0.2f;

    Buf[i++] = x + (y << 16);

    Buf[0] |= ((i - 2) << 16);

    test = R128_CCESubmitPackets (Buf, i);

    getch ();

    // Shut down the microengine.

    R128_CCEEnd (CCE_END_WAIT);
    R128_ShutDown ();

    return;
} // main
