/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * vertfog.c - This program demonstrates how to set vertex fog states using *
 * CCE command packets.                                                     *  
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <i86.h>
#include <conio.h>
#include "..\..\util\regdef.h"
#include "..\..\util\defines.h"
#include "..\..\util\main.h"
#include "..\..\util\cce.h"
#include "..\util\cntx3d.h"
#include "..\util\prim.h"
#include "..\util\fog.h"

char gErrMsg [64] = {0};

extern DWORD BPPOverride; // Override default 8bpp mode in Chap 3 lib.


/****************************************************************************
 * main                                                                     *
 *  Function: Main loop.                                                    *
 *    Inputs: none                                                          *
 *   Outputs: none                                                          *
 ****************************************************************************/

void main (int argc, char *argv[])
{
	int i, exitcode = 0;
    TLVERTEX2 rect[4];
	PRIMDATA rectstrip;

    printf ("Rage 128 Sample Code, Chapter 6.\n"
        "VERTFOG.EXE\n\n"
        "This program demonstrates how to set vertex fog states using Rage 128\n"
        "CCE command packets.\n\n"
        "Mode resolution (eg 640 480) and colour depth (15, 16, 32)\n"
        "should be passed as command line arguments.\n"
        "Default resolution and colour depth is 640x480, 32bpp.\n\n"
        "Press any key to continue.\n\n");

    getch ();

    // Inspect arguments for invalid color depth.

    for (i = 1; i < argc; i++)
    {
        if ((strcmp (argv[i], "8") == 0) || (strcmp (argv[i], "24") == 0))
		{
			printf ("\nThis program does not operate at 8 or 24 bpp.");
			printf ("\nProgram terminated.");
			exit (1);
		}
	}

    // Override default 8bpp mode in Chap 3 lib.

    BPPOverride = 32;

    // First, run StartUp function to set up the application.

    R128_StartUp (argc, argv);

    // Clear the screen.

    R128_ClearScreen (DARKBLUE);

    // Initialize the CCE microengine.

    if (R128_CCEInit (CCE_MODE_192BM) != CCE_SUCCESS)
    {
        R128_ShutDown ();
        printf ("R128_CCEInit failed!!\n");
        exit (1);
    } // if

	// Set the default 3D context.

    R128_Init3DContext ();

	// Set rect parameters.

	rect[0].x = R128_AdapterInfo.xres * 0.3f;
	rect[0].y = R128_AdapterInfo.yres * 0.2f;
	rect[0].z = 0.5f;
	rect[0].rhw = 1.0f;
	rect[0].diffuse = 0x00ff0000;
    rect[0].specular = 0xff000000;
	rect[0].s2 = rect[0].s1 = 0.0f;
	rect[0].t2 = rect[0].t1 = 1.0f;

	rect[1].x = R128_AdapterInfo.xres * 0.7f;
	rect[1].y = R128_AdapterInfo.yres * 0.4f;
	rect[1].z = 0.5f;
	rect[1].rhw = 1.0f;
	rect[1].diffuse = 0x00ff0000;
    rect[1].specular = 0x00000000;
	rect[1].s2 = rect[1].s1 = 1.0f;
	rect[1].t2 = rect[1].t1 = 1.0f;

	rect[2].x = R128_AdapterInfo.xres * 0.3f;
	rect[2].y = R128_AdapterInfo.yres * 0.8f;
	rect[2].z = 0.5f;
	rect[2].rhw = 1.0f;
	rect[2].diffuse = 0x00ff0000;
    rect[2].specular = 0xff000000;
	rect[2].s2 = rect[2].s1 = 0.0f;
	rect[2].t2 = rect[2].t1 = 0.0f;

	rect[3].x = R128_AdapterInfo.xres * 0.7f;
	rect[3].y = R128_AdapterInfo.yres * 0.6f;
	rect[3].z = 0.5f;
	rect[3].rhw = 1.0f;
	rect[3].diffuse = 0x00ff0000;
    rect[3].specular = 0x00000000;
	rect[3].s2 = rect[3].s1 = 1.0f;
	rect[3].t2 = rect[3].t1 = 0.0f;

	rectstrip.numverts = 4;
	rectstrip.verts = rect;

    // Enable fog.

    ATTEMPT (R128_SetFogState (FOGSTATE_ENABLE, TRUE), 
		"fog enable failed!!")

    // Set vertex fog mode.

    ATTEMPT (R128_SetFogState (FOGSTATE_MODE, FOGMODE_VERTEX), 
		"set fog mode failed!!")

    // Set the fog color.

    ATTEMPT (R128_SetFogState (FOGSTATE_COLOR, 0x0000008f), 
		"set fog color failed!!")

    // Draw a quadrangle.

	ATTEMPT (R128_DrawTriangleStrip (&rectstrip), 
		"R128_DrawTriangleStrip for rect failed!!")

	// Wait for key press to exit.

	getch ();

exit_app:

	// Close 3D context, shut down micro-engine and restore original mode.

	R128_Close3DContext ();
    R128_CCEEnd (CCE_END_WAIT);
    R128_ShutDown ();

	// print error message if any.

	if (exitcode == 1)
		printf ("%s\n", gErrMsg);

	exit (exitcode);
} // main


