/****************************************************************************
 * RAGE128 Chapter 6 Sample Code                                            *
 *                                                                          *
 * util3d.c - General purpose 3D utility functions.                         * 
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <i86.h>
#include <conio.h>
#include <string.h>
#include "..\..\util\regdef.h"
#include "..\..\util\defines.h"
#include "..\..\util\main.h"
#include "..\..\util\cce.h"
#include "cntx3d.h"

extern CONTEXT3D gContext3D;
extern DWORD gCommandBuf[];


/****************************************************************************
 * R128_CCEClearScreen										                *
 *  Function: Clear the visible screen to the given color.                  *
 *    Inputs: color - color to clear the screen to.                         *
 *   Outputs: none                                                          *
 ****************************************************************************/

void R128_CCEClearScreen (DWORD color)
{
	int i;
	DWORD temp;

    // Temprarily turn off Z_EN, STEN_EN, and TEX_EN if on.

    temp = gContext3D.regTEX_CNTL_C &
        ~((0x00000001) | (0x00000001 << 3) | (0x00000001 << 4));
	i = 0;
    gCommandBuf[i++] = CCE_PACKET0 | (TEX_CNTL_C >> 2);
    gCommandBuf[i++] = temp;
    R128_CCESubmitPackets (gCommandBuf, i);

	// Get byte per pixel value.

    temp = R128_GetBPPValue (R128_AdapterInfo.bpp);

	// Setup a CCE_PACKET3_CNTL_PAINT Type-3 packet.

	i = 0;
    gCommandBuf[i++] = CCE_PACKET3_CNTL_PAINT;
    gCommandBuf[i++] =
        CCE_GC_SRC_PITCH_OFFSET_DEFAULT |
        CCE_GC_DST_PITCH_OFFSET_DEFAULT |
		CCE_GC_SRC_CLIP_DEFAULT |
		CCE_GC_DST_CLIP_DEFAULT |
		CCE_GC_BRUSH_SOLIDCOLOR | 
        (temp << 8) | 
		CCE_GC_SRC_DSTCOLOR | 
		ROP3_PATCOPY |
		CCE_GC_DST_CLR_CMP_FCN_CLEAR |
		CCE_GC_AUX_CLIP_CLEAR |
        CCE_GC_3D_FCN_EN_SET |
		CCE_GC_WRITE_MASK_LEAVE;

    // Colour used to draw the rectangle due to CCE_GC_BRUSH_SOLIDCOLOR

    gCommandBuf[i++] = color;

    // Fill rectangle data into packet.

	// TOP | LEFT

    gCommandBuf[i++] = 0x00000000;

	// BOTTOM | RIGHT

    gCommandBuf[i++] = (R128_AdapterInfo.yres << 16) | R128_AdapterInfo.xres;

	// Submit the packet.

    gCommandBuf[0] |= ((i - 2) << 16);
    R128_CCESubmitPackets (gCommandBuf, i);

	// Restore DST_PITCH_OFFSET_C.

	i = 0;
    gCommandBuf[i++] = CCE_PACKET0 | (DST_PITCH_OFFSET_C >> 2);
    gCommandBuf[i++] = R128_AdapterInfo.pitch << 21;
    gCommandBuf[i++] = gContext3D.regDP_GUI_MASTER_CNTL; 
    gCommandBuf[0] |= ((i - 2) << 16);
    R128_CCESubmitPackets (gCommandBuf, i);

	// Restore TEX_CNTL_C states.

	i = 0;
    gCommandBuf[i++] = CCE_PACKET0 | (TEX_CNTL_C >> 2);
    gCommandBuf[i++] = gContext3D.regTEX_CNTL_C;
    R128_CCESubmitPackets (gCommandBuf, i);
}

