/****************************************************************************
 * key.h                                                                    *
 * Header file for Rage 128 Chapter 6 sample code                           *
 * Data type definitions and function declarations for key.c.               * 
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.           *
 ****************************************************************************/

#include <stdio.h>
#include <bios.h>
#include "..\..\util\main.h"

#ifndef _KEY_H
#define _KEY_H

// Defines.

#define KEY_ESC         0x011b

#define KEY_F1          0x3b00
#define KEY_F2          0x3c00
#define KEY_F3          0x3d00
#define KEY_F4          0x3e00
#define KEY_F5          0x3f00
#define KEY_F6          0x4000
#define KEY_F7          0x4100
#define KEY_F8          0x4200
#define KEY_F9          0x4300
#define KEY_F10         0x4400

#define KEY_SHFT_F1     0x5400
#define KEY_SHFT_F2     0x5500
#define KEY_SHFT_F3     0x5600
#define KEY_SHFT_F4     0x5700
#define KEY_SHFT_F5     0x5800
#define KEY_SHFT_F6     0x5900
#define KEY_SHFT_F7     0x5a00
#define KEY_SHFT_F8     0x5b00
#define KEY_SHFT_F9     0x5c00
#define KEY_SHFT_F10    0x5d00


// Functions.

WORD R128_GetKey (void);

#endif // _KEY_H

