/******************************************************************************
 * alphblnd.h	        													  *
 * Header file for Rage 128 Chapter 6 sample code                             *
 * Data type definitions and function declarations for ablend.c.			  *	
 *                                                                            *
 * Copyright (c) 1999 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/

#include <stdio.h>
#include "..\..\util\main.h"

#ifndef _ALPHBLND_H
#define _ALPHBLND_H

// alpha blend state enumeration.

typedef enum {
	ALPHABLENDSTATE_ENABLE = 0,
	ALPHABLENDSTATE_SRCBLEND,
	ALPHABLENDSTATE_DSTBLEND,
	ALPHABLENDSTATE_COMBFNC,
	ALPHABLENDSTATE_FORCE_DWORD = 0xffffffff
} EALPHABLENDSTATE;

// alpha blend function enumeration.

typedef enum {
	BLEND_ZERO = 0,
	BLEND_ONE,
	BLEND_SRCCOLOR,
	BLEND_INVSRCCOLOR,
	BLEND_SRCALPHA,
	BLEND_INVSRCALPHA,
	BLEND_DSTALPHA,
	BLEND_INVDSTALPHA,
	BLEND_DSTCOLOR,
	BLEND_INVDSTCOLOR,
	BLEND_SRCALPHASAT,
	BLEND_BOTHSRCALPHA,
	BLEND_BOTHINVSRCALPHA,
	BLEND_SRCSRCALPHA_DSTINVSRCALPHA = 0x11,
	BLEND_SRCINVSRCALPHA_DSTSRCALPHA = 0x12,
	BLEND_FORCE_DWORD = 0xffffffff
} EBLEND;

// alpha blend combine function enumeration.

typedef enum {
	COMBFNC_ADD_CLAMP = 0,
	COMBFNC_ADD_NOCLAMP,
	COMBFNC_SUB_DSTSRC_CLAMP,
	COMBFNC_SUB_DSTSRC_NOCLAMP,
	COMBFNC_FORCE_DWORD = 0xffffffff,
} ECOMBFNC;

// Functions.

BOOL R128_SetAlphaBlendState (EALPHABLENDSTATE eastate, DWORD data);

#endif // _ALPHBLND_H
