/****************************************************************************
 * Rage 128 Chapter 4 sample code                                           *
 *                                                                          *
 * rect.c - This program uses the Rage 128 engine to perform simple         *
 *          coloured rectangle fills.                                       *
 *                                                                          *
 * Copyright (c) 1999 ATI Technologies Inc. All rights reserved.            *
 ****************************************************************************/
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>
#include <i86.h>
#include "..\util\regdef.h"
#include "..\util\defines.h"
#include "..\util\main.h"

/****************************************************************************
 * Main Program to demonstrate rectangle fills                              *
 *  Function: The engine is used to perform rectangle fills.  Rectangle     *
 *            fills are done repeatedly, until a key is pressed.            *
 *    Inputs: Arguments for mode spatial and colour resolution              *
 *   Outputs: NONE                                                          *
 ****************************************************************************/
void main (int argc, char *argv[])
{
    DWORD width, height, x, y, bppvalue;
    DWORD temp;

    R128_StartUp (argc, argv);

    // clear screen.
    R128_ClearScreen (BLACK);

    R128_WaitForFifo (1);
    // Set up DP_DATATYPE for a solid color brush, and to proper colour depth.
    bppvalue = R128_GetBPPValue (R128_AdapterInfo.bpp);
    regw (DP_DATATYPE, BRUSH_SOLIDCOLOR | bppvalue);

    while (!kbhit ())
    {
        x = (rand()%(R128_AdapterInfo.xres));
        width = rand()%(R128_AdapterInfo.xres - x);
        y = (rand()%(R128_AdapterInfo.yres));
        height = rand()%(R128_AdapterInfo.yres - y);

        temp = R128_GetColourCode (rand()%NUM_COLOURS);

        R128_WaitForFifo (3);
        regw (DP_BRUSH_FRGD_CLR, temp);

        // Draw a filled pattern rectangle.
        regw (DST_Y_X, (y << 16) | x);
        regw (DST_HEIGHT_WIDTH, (height << 16) | width);
    }

    // Wait for a carriage return.
    getch ();

    // Batch command to restore old mode.
    R128_ShutDown ();

    exit (0);                           // No errors.

} // main


