/******************************************************************************
 * DETECT.C - Chapter 3 sample code                                           *
 *                                                                            *
 * This program uses the PCI CONFIGURATION SPACE to detect the presence       *
 * of a R128 via the PCI CONFIG space.  The global structure R128_AdapterInfo *
 * is also filled in with various values                                      *
 *                                                                            *
 * Copyright (c) 1998 ATI Technologies Inc.  All rights reserved.             *
 ******************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <i86.h>
#include <dos.h>
#include "..\util\main.h"
#include "..\util\regdef.h"

void main (int argc, char *argv[])
{
    // Use the PCI Configuration Space to locate a Rage 128 adapter
    if (R128_Detect ())
    {
        printf ("\nRage 128 detected.");
    }
    else
    {
        printf ("\nNo Rage 128 adapter detected.");
        //exit (1);
    }

    // Now scan the BIOS area to find the ROM location
    if (R128_FindRom ())
    {
        printf ("\nRage 128 ROM found.");
    }
    else
    {
        printf ("\nNo Rage 128 adapter ROM not found.");
        // exit (1);
    }

    // Perform a Scratch Register Test
    if (R128_RegTest ())
    {
        printf ("\nRage 128 scratch register test passed.");
    }
    else
    {
        printf ("\nRage 128 scratch register test FAILED.");
        // exit (1);
    }

    // Print out information about the installed adapter
    R128_PrintInfoStruct ();

    return;

} // main
