/******************************************************************************
 * Header file to mach64 Chapter 8 sample code                                *
 *                                                                            *
 * Includes structures, prototypes, and globals.                              *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

// Use Chapter 7 version of MAIN.H

#include "..\..\chap7\util\main.h"


// Structures for VIEWIMG.C
#pragma pack(1)

typedef struct                      /* VT image file header structure */
{
    char     img_code[5];           // set to "_IMG" terminated with 0
    short    format_id;             // see FORMAT_TYPE_???? defines
    short    bytes_per_pixel;       // bytes per pixel (per format)
    short    width;                 // width of image in pixels
    short    height;                // height of image in lines
    unsigned long u_offset;         // byte offset to start of U data for
                                    //   YUV9 and YUV12 formats
    unsigned long v_offset;         // byte offset to start of V data for
                                    //   YUV9 and YUV12 formats
    char     filler[11];            // set to 0 (sets header to 32 bytes);
                                    //   regular data and Y data follows
                                    //   header
} img_header;

typedef struct
{
    char *filespec;
    img_header *image;
} img_handle;

#pragma pack()

// structure for bmaster.c and bmgui.c

typedef struct 
{
    unsigned long int FRAME_BUF_OFFSET;
    unsigned long int SYSTEM_MEM_ADDR;
    unsigned long int COMMAND;
    unsigned long int RESERVED;
} BM_LIST_DESCRIPTOR;

// Functions in vtovrscl.c

void set_overlay (int x, int y, int width, int height);
void set_scale (int src_width, int src_height, int dst_width, int dst_height);

// Functions in viewimg.c

img_handle *get_img_header(char *filename);
int load_img(img_handle *himage, int x, int y);

// Functions in vtcontrl.c

void start_overlay();
void setup_overlay(int pixel_format, int starting_mem_addr);
void enable_overlay();
void disable_overlay();
void finish_overlay();
void change_overlay_pitch(int mode_bpp);

// Functions in vtgtdet.c

void pro_overlay_init();
unsigned int is_pro();
unsigned int is_revb_or_greater();
unsigned int is_vtgt();
unsigned int is_gt();
unsigned int is_gtb();
unsigned int is_gtbplus();

// Functions in dpmimem.c

unsigned long DPMI_allocdosmem ( unsigned long paragraphs,
                                 unsigned long *segment,
                                 unsigned long *selector );

unsigned long DPMI_freedosmem ( unsigned long selector );


