/******************************************************************************
 * defines file for mach64 Chapter 6 sample code                              *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#ifndef _DEFINES_H
#define _DEFINES_H

// Miscellaneous.

#define OFF 0
#define ON  1

// I/O types.

#define FIXED       0
#define RELOCATABLE 1

// mach64 'chip_type' id constants.

#define CHIP_GX_ID  0x00D7
#define CHIP_CX_ID  0x0057
#define CHIP_CT_ID  0x4354
#define CHIP_VT_ID  0x5654
#define CHIP_GT_ID  0x4754 // 3D RAGE I, II
#define CHIP_GU_ID  0x4755 // 3D RAGE II+
#define CHIP_GB_ID  0x4742 // 3D RAGE PRO (BGA package, AGP1x2x)
#define CHIP_GD_ID  0x4744 // 3D RAGE PRO (BGA package, AGP1x only)
#define CHIP_GI_ID  0x4749 // 3D RAGE PRO (BGA package, PCI 33 MHz only)
#define CHIP_GP_ID  0x4750 // 3D RAGE PRO (PQFP package, PCI)
#define CHIP_GQ_ID  0x4751 // 3D RAGE PRO (PQFP package, PCI, limited 3D)


// Bus types.

#define BUS_ISA     0
#define BUS_EISA    1
#define BUS_VLB     6
#define BUS_PCI     7

// 'dac_type' constants from ROM query header.
// - lower 4 bits is DAC main type
// - upper 4 bits is DAC sub type
// - DACs other than TVP3026 will have a different sub type than 7

#define DAC_INTERNAL    0x00            // CT, internal DAC.
#define DAC_IBM514      0x01
#define DAC_ATI68875    0x02            // Also TLC34075.
#define DAC_TVP3026_1   0x72            // Same as DAC_TVP3026_2.
#define DAC_BT476       0x03            // Also BT478.
#define DAC_BT481       0x04
#define DAC_ATT20C490   0x14            // Also ATT20C491/493, IMS-G174,
                                        //  SC15025/15026, MU9C4910/1880.
#define DAC_ATI68860_1  0x05            // Revision B.
#define DAC_ATI68860_2  0x15            // Revision C.
#define DAC_TVP3026_2   0x75            // Same as DAC_TVP3026_1.
#define DAC_STG1700     0x06
#define DAC_ATT20C498   0x16
#define DAC_STG1702     0x07
#define DAC_SC15021     0x17
#define DAC_ATT21C498   0x27
#define DAC_STG1703     0x37
#define DAC_CH8398      0x47

// Generic colour definitions for use in get_colour_code ().

#define BLACK            0
#define DARKBLUE         1
#define DARKGREEN        2
#define DARKCYAN         3
#define DARKRED          4
#define DARKMAGENTA      5
#define BROWN            6
#define LIGHTGRAY        7
#define DARKGRAY         8
#define LIGHTBLUE        9
#define LIGHTGREEN      10
#define LIGHTCYAN       11
#define LIGHTRED        12
#define LIGHTMAGENTA    13
#define YELLOW          14
#define WHITE           15
#define NUM_COLOURS     16

// Colour depth support for MODE_INFO.

#define DEPTH_SUPPORT_ARGB  0x80        // support 32 bpp, xRGB, x is byte 0
#define DEPTH_SUPPORT_BGRA  0x40        // support 32 bpp, BGRx, B is byte 0
#define DEPTH_SUPPORT_RGBA  0x20        // support 32 bpp, RGBx, R is byte 0
#define DEPTH_SUPPORT_ABGR  0x10        // support 32 bpp, xBGR, x is byte 0
#define DEPTH_SUPPORT_BGR   0x08        // support 24 bpp, BGR
#define DEPTH_SUPPORT_RGB   0x04        // support 24 bpp, RGB
#define DEPTH_SUPPORT_555   0x02        // support 16 bpp (15), 555
#define DEPTH_SUPPORT_565   0x01        // support 16 bpp, 565

// wait_for_idle () and wait_for_fifo () errors and constants.

#define BAD_IDLE            0
#define BAD_FIFO            1
#define DOS_TICK_ADDRESS    0x0000046C
#define IDLE_TIMEOUT        100
#define FIFO_TIMEOUT        100

// Hardware cursor bitmap dimensions.

#define HWCURWIDTH      8               // Width of hwcursor in words.
#define HWCURHEIGHT     64              // Height of hwcursor in scan lines.


// Engine bit constants - these are typically ORed together.

// GEN_TEST_CNTL register constants.

#define HWCURSOR_ENABLE             0x80
#define GUI_ENGINE_ENABLE           0x100

// CONFIG_CNTL register constants.

#define APERTURE_4M_ENABLE          1
#define APERTURE_8M_ENABLE          2
#define VGA_APERTURE_ENABLE         4

// DST_CNTL register constants.

#define DST_X_RIGHT_TO_LEFT         0
#define DST_X_LEFT_TO_RIGHT         1
#define DST_Y_BOTTOM_TO_TOP         0
#define DST_Y_TOP_TO_BOTTOM         2
#define DST_X_MAJOR                 0
#define DST_Y_MAJOR                 4
#define DST_X_TILE                  8
#define DST_Y_TILE                  0x10
#define DST_LAST_PEL                0x20
#define DST_POLYGON_ENABLE          0x40
#define DST_24_ROTATION_ENABLE      0x80

// SRC_CNTL register constants.

#define SRC_PATTERN_ENABLE          1
#define SRC_ROTATION_ENABLE         2
#define SRC_LINEAR_ENABLE           4
#define SRC_BYTE_ALIGN              8
#define SRC_LINE_X_RIGHT_TO_LEFT    0
#define SRC_LINE_X_LEFT_TO_RIGHT    0x10

// HOST_CNTL register constants.

#define HOST_BYTE_ALIGN             1

// PAT_CNTL register constants.

#define PAT_MONO_8x8_ENABLE         1
#define PAT_CLR_4x2_ENABLE          2
#define PAT_CLR_8x1_ENABLE          4

// DP_PIX_WIDTH register constants.

#define DST_1BPP                    0
#define DST_4BPP                    1
#define DST_8BPP                    2
#define DST_15BPP                   3
#define DST_16BPP                   4
#define DST_32BPP                   6
#define SRC_1BPP                    0
#define SRC_4BPP                    0x100
#define SRC_8BPP                    0x200
#define SRC_15BPP                   0x300
#define SRC_16BPP                   0x400
#define SRC_32BPP                   0x600
#define HOST_1BPP                   0
#define HOST_4BPP                   0x10000
#define HOST_8BPP                   0x20000
#define HOST_15BPP                  0x30000
#define HOST_16BPP                  0x40000
#define HOST_32BPP                  0x60000
#define BYTE_ORDER_MSB_TO_LSB       0
#define BYTE_ORDER_LSB_TO_MSB       0x1000000

// DP_MIX register constants.

#define BKGD_MIX_NOT_D              0
#define BKGD_MIX_ZERO               1
#define BKGD_MIX_ONE                2
#define BKGD_MIX_D                  3
#define BKGD_MIX_NOT_S              4
#define BKGD_MIX_D_XOR_S            5
#define BKGD_MIX_NOT_D_XOR_S        6
#define BKGD_MIX_S                  7
#define BKGD_MIX_NOT_D_OR_NOT_S     8
#define BKGD_MIX_D_OR_NOT_S         9
#define BKGD_MIX_NOT_D_OR_S         10
#define BKGD_MIX_D_OR_S             11
#define BKGD_MIX_D_AND_S            12
#define BKGD_MIX_NOT_D_AND_S        13
#define BKGD_MIX_D_AND_NOT_S        14
#define BKGD_MIX_NOT_D_AND_NOT_S    15
#define BKGD_MIX_D_PLUS_S_DIV2      0x17
#define FRGD_MIX_NOT_D              0
#define FRGD_MIX_ZERO               0x10000
#define FRGD_MIX_ONE                0x20000
#define FRGD_MIX_D                  0x30000
#define FRGD_MIX_NOT_S              0x40000
#define FRGD_MIX_D_XOR_S            0x50000
#define FRGD_MIX_NOT_D_XOR_S        0x60000
#define FRGD_MIX_S                  0x70000
#define FRGD_MIX_NOT_D_OR_NOT_S     0x80000
#define FRGD_MIX_D_OR_NOT_S         0x90000
#define FRGD_MIX_NOT_D_OR_S         0xA0000
#define FRGD_MIX_D_OR_S             0xB0000
#define FRGD_MIX_D_AND_S            0xC0000
#define FRGD_MIX_NOT_D_AND_S        0xD0000
#define FRGD_MIX_D_AND_NOT_S        0xE0000
#define FRGD_MIX_NOT_D_AND_NOT_S    0xF0000
#define FRGD_MIX_D_PLUS_S_DIV2      0x170000

// DP_SRC register constants.

#define BKGD_SRC_BKGD_CLR           0
#define BKGD_SRC_FRGD_CLR           1
#define BKGD_SRC_HOST               2
#define BKGD_SRC_BLIT               3
#define BKGD_SRC_PATTERN            4
#define FRGD_SRC_BKGD_CLR           0
#define FRGD_SRC_FRGD_CLR           0x100
#define FRGD_SRC_HOST               0x200
#define FRGD_SRC_BLIT               0x300
#define FRGD_SRC_PATTERN            0x400
#define MONO_SRC_ONE                0
#define MONO_SRC_PATTERN            0x10000
#define MONO_SRC_HOST               0x20000
#define MONO_SRC_BLIT               0x30000

// CLR_CMP_CNTL register constants.

#define COMPARE_FALSE               0
#define COMPARE_TRUE                1
#define COMPARE_NOT_EQUAL           4
#define COMPARE_EQUAL               5
#define COMPARE_DESTINATION         0
#define COMPARE_SOURCE              0x1000000

// FIFO_STAT register constants.

#define FIFO_ERR                    0x80000000

// CONTEXT_LOAD_CNTL constants.

#define CONTEXT_NO_LOAD             0
#define CONTEXT_LOAD                0x10000
#define CONTEXT_LOAD_AND_DO_FILL    0x20000
#define CONTEXT_LOAD_AND_DO_LINE    0x30000
#define CONTEXT_EXECUTE             0
#define CONTEXT_CMD_DISABLE         0x80000000

// GUI_STAT register constants.

#define ENGINE_IDLE                 0
#define ENGINE_BUSY                 1
#define SCISSOR_LEFT_FLAG           0x10
#define SCISSOR_RIGHT_FLAG          0x20
#define SCISSOR_TOP_FLAG            0x40
#define SCISSOR_BOTTOM_FLAG         0x80

#endif // _DEFINES_H
