# $Csoft: arc4random.pm,v 1.1 2004/01/01 00:33:41 vedge Exp $
# vim:ts=4
#
# Copyright (c) 2003, 2004 CubeSoft Communications, Inc.
# <http://www.csoft.org>
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
# 
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
# USE OF THIS SOFTWARE EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

sub Test
{
	TryCompile 'HAVE_ARC4RANDOM', << 'EOF';
#include <sys/types.h>
#include <stdlib.h>
int
main(int argc, char *argv[])
{
	u_int32_t i;

	i = arc4random();
	return (0);
}
EOF
}

sub Emul
{
	my ($os, $osrel, $machine) = @_;

	if ($os eq 'darwin' || $os eq 'openbsd' || $os eq 'freebsd') {
		MkDefine('HAVE_ARC4RANDOM', 'yes');
		MkSaveDefine('HAVE_ARC4RANDOM');
	} else {
		MkSaveUndef('HAVE_ARC4RANDOM');
	}
	return (1);
}

BEGIN
{
	$TESTS{'arc4random'} = \&Test;
	$DEPS{'arc4random'} = 'cc';
	$EMUL{'arc4random'} = \&Emul;
	$DESCR{'arc4random'} = 'the arc4random() random number generator';
}

;1
