#! /bin/sh

if [ -z "$1" ]; then
	echo "Usage: $0 nodes.h" 1>&2
	exit 1
fi

NODES=$1

test -t 1 && test -z "$2" && exec > nodenames.h

echo "#ifdef DEBUG"
echo '
/*
 * Automatically generated by '"$0"'
 * DO NOT EDIT. Do Not "cvs add".
 */
'

MAX=$(awk < "$NODES" '
	/#define/ {
		if ($3 > MAX) MAX = $3
	}
	END { print MAX }
')

echo
echo '#ifdef DEFINE_NODENAMES'
echo "STATIC const char * const NodeNames[${MAX} + 1] = {"

grep '^#define' "$NODES" | sort -k3n | while read define name number opt_comment
do
	: ${next:=0}
	while [ "$number" -gt "$next" ]
	do
		echo '	"???",'
		next=$(( next + 1))
	done
	echo '	"'"$name"'",'
	next=$(( number + 1 ))
done

echo "};"
echo '#else'
echo "extern const char * const NodeNames[${MAX} + 1];"
echo '#endif'
echo
echo '#define NODETYPENAME(type) \'
echo '	((unsigned)(type) <= '"${MAX}"' ? NodeNames[(type)] : "??OOR??")'
echo
echo '#endif'
