/*	$NetBSD: netsmb_iconv.c,v 1.1 2014/11/15 18:49:04 nakayama Exp $	*/

/*
 * Copyright (c) 2014 Takeshi Nakayama.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include <sys/cdefs.h>
__KERNEL_RCSID(0, "$NetBSD: netsmb_iconv.c,v 1.1 2014/11/15 18:49:04 nakayama Exp $");

#include <sys/param.h>
#include <sys/kernel.h>
#include <sys/systm.h>
#include <sys/errno.h>

#include <netsmb/iconv.h>

#include "netsmb_user.h"

int
iconv_open(const char *to, const char *from, void **handle)
{
	if (strcmp(to, "tolower") && strcmp(to, "toupper"))
		return rumpcomp_netsmb_iconv_open(to, from, handle);
	return 0;
}

int
iconv_close(void *handle)
{
	if (handle != NULL)
		return rumpcomp_netsmb_iconv_close(handle);
	return 0;
}

int
iconv_conv(void *handle, const char **inbuf, size_t *inbytesleft,
    char **outbuf, size_t *outbytesleft)
{
	size_t len;

	if (handle != NULL)
		return rumpcomp_netsmb_iconv_conv(handle, inbuf, inbytesleft,
		    outbuf, outbytesleft);

	if (inbuf == NULL)
		return 0;

	if (*inbytesleft > *outbytesleft)
		return E2BIG;

	len = *inbytesleft;
	memcpy(*outbuf, *inbuf, len);
	*inbuf += len;
	*inbytesleft = 0;
	*outbuf += len;
	*outbytesleft -= len;
	return 0;
}
