/*	$NetBSD: rzn1-pinctrl.h,v 1.1.1.1 2019/01/22 14:57:01 jmcneill Exp $	*/

/* SPDX-License-Identifier: GPL-2.0 */
/*
 * Defines macros and constants for Renesas RZ/N1 pin controller pin
 * muxing functions.
 */
#ifndef __DT_BINDINGS_RZN1_PINCTRL_H
#define __DT_BINDINGS_RZN1_PINCTRL_H

#define RZN1_PINMUX(_gpio, _func) \
	(((_func) << 8) | (_gpio))

/*
 * Given the different levels of muxing on the SoC, it was decided to
 * 'linearize' them into one numerical space. So mux level 1, 2 and the MDIO
 * muxes are all represented by one single value.
 *
 * You can derive the hardware value pretty easily too, as
 * 0...9   are Level 1
 * 10...71 are Level 2. The Level 2 mux will be set to this
 *         value - RZN1_FUNC_L2_OFFSET, and the Level 1 mux will be
 *         set accordingly.
 * 72...103 are for the 2 MDIO muxes.
 */
#define RZN1_FUNC_HIGHZ				0
#define RZN1_FUNC_0L				1
#define RZN1_FUNC_CLK_ETH_MII_RGMII_RMII	2
#define RZN1_FUNC_CLK_ETH_NAND			3
#define RZN1_FUNC_QSPI				4
#define RZN1_FUNC_SDIO				5
#define RZN1_FUNC_LCD				6
#define RZN1_FUNC_LCD_E				7
#define RZN1_FUNC_MSEBIM			8
#define RZN1_FUNC_MSEBIS			9
#define RZN1_FUNC_L2_OFFSET			10	/* I'm Special */

#define RZN1_FUNC_HIGHZ1			(RZN1_FUNC_L2_OFFSET + 0)
#define RZN1_FUNC_ETHERCAT			(RZN1_FUNC_L2_OFFSET + 1)
#define RZN1_FUNC_SERCOS3			(RZN1_FUNC_L2_OFFSET + 2)
#define RZN1_FUNC_SDIO_E			(RZN1_FUNC_L2_OFFSET + 3)
#define RZN1_FUNC_ETH_MDIO			(RZN1_FUNC_L2_OFFSET + 4)
#define RZN1_FUNC_ETH_MDIO_E1			(RZN1_FUNC_L2_OFFSET + 5)
#define RZN1_FUNC_USB				(RZN1_FUNC_L2_OFFSET + 6)
#define RZN1_FUNC_MSEBIM_E			(RZN1_FUNC_L2_OFFSET + 7)
#define RZN1_FUNC_MSEBIS_E			(RZN1_FUNC_L2_OFFSET + 8)
#define RZN1_FUNC_RSV				(RZN1_FUNC_L2_OFFSET + 9)
#define RZN1_FUNC_RSV_E				(RZN1_FUNC_L2_OFFSET + 10)
#define RZN1_FUNC_RSV_E1			(RZN1_FUNC_L2_OFFSET + 11)
#define RZN1_FUNC_UART0_I			(RZN1_FUNC_L2_OFFSET + 12)
#define RZN1_FUNC_UART0_I_E			(RZN1_FUNC_L2_OFFSET + 13)
#define RZN1_FUNC_UART1_I			(RZN1_FUNC_L2_OFFSET + 14)
#define RZN1_FUNC_UART1_I_E			(RZN1_FUNC_L2_OFFSET + 15)
#define RZN1_FUNC_UART2_I			(RZN1_FUNC_L2_OFFSET + 16)
#define RZN1_FUNC_UART2_I_E			(RZN1_FUNC_L2_OFFSET + 17)
#define RZN1_FUNC_UART0				(RZN1_FUNC_L2_OFFSET + 18)
#define RZN1_FUNC_UART0_E			(RZN1_FUNC_L2_OFFSET + 19)
#define RZN1_FUNC_UART1				(RZN1_FUNC_L2_OFFSET + 20)
#define RZN1_FUNC_UART1_E			(RZN1_FUNC_L2_OFFSET + 21)
#define RZN1_FUNC_UART2				(RZN1_FUNC_L2_OFFSET + 22)
#define RZN1_FUNC_UART2_E			(RZN1_FUNC_L2_OFFSET + 23)
#define RZN1_FUNC_UART3				(RZN1_FUNC_L2_OFFSET + 24)
#define RZN1_FUNC_UART3_E			(RZN1_FUNC_L2_OFFSET + 25)
#define RZN1_FUNC_UART4				(RZN1_FUNC_L2_OFFSET + 26)
#define RZN1_FUNC_UART4_E			(RZN1_FUNC_L2_OFFSET + 27)
#define RZN1_FUNC_UART5				(RZN1_FUNC_L2_OFFSET + 28)
#define RZN1_FUNC_UART5_E			(RZN1_FUNC_L2_OFFSET + 29)
#define RZN1_FUNC_UART6				(RZN1_FUNC_L2_OFFSET + 30)
#define RZN1_FUNC_UART6_E			(RZN1_FUNC_L2_OFFSET + 31)
#define RZN1_FUNC_UART7				(RZN1_FUNC_L2_OFFSET + 32)
#define RZN1_FUNC_UART7_E			(RZN1_FUNC_L2_OFFSET + 33)
#define RZN1_FUNC_SPI0_M			(RZN1_FUNC_L2_OFFSET + 34)
#define RZN1_FUNC_SPI0_M_E			(RZN1_FUNC_L2_OFFSET + 35)
#define RZN1_FUNC_SPI1_M			(RZN1_FUNC_L2_OFFSET + 36)
#define RZN1_FUNC_SPI1_M_E			(RZN1_FUNC_L2_OFFSET + 37)
#define RZN1_FUNC_SPI2_M			(RZN1_FUNC_L2_OFFSET + 38)
#define RZN1_FUNC_SPI2_M_E			(RZN1_FUNC_L2_OFFSET + 39)
#define RZN1_FUNC_SPI3_M			(RZN1_FUNC_L2_OFFSET + 40)
#define RZN1_FUNC_SPI3_M_E			(RZN1_FUNC_L2_OFFSET + 41)
#define RZN1_FUNC_SPI4_S			(RZN1_FUNC_L2_OFFSET + 42)
#define RZN1_FUNC_SPI4_S_E			(RZN1_FUNC_L2_OFFSET + 43)
#define RZN1_FUNC_SPI5_S			(RZN1_FUNC_L2_OFFSET + 44)
#define RZN1_FUNC_SPI5_S_E			(RZN1_FUNC_L2_OFFSET + 45)
#define RZN1_FUNC_SGPIO0_M			(RZN1_FUNC_L2_OFFSET + 46)
#define RZN1_FUNC_SGPIO1_M			(RZN1_FUNC_L2_OFFSET + 47)
#define RZN1_FUNC_GPIO				(RZN1_FUNC_L2_OFFSET + 48)
#define RZN1_FUNC_CAN				(RZN1_FUNC_L2_OFFSET + 49)
#define RZN1_FUNC_I2C				(RZN1_FUNC_L2_OFFSET + 50)
#define RZN1_FUNC_SAFE				(RZN1_FUNC_L2_OFFSET + 51)
#define RZN1_FUNC_PTO_PWM			(RZN1_FUNC_L2_OFFSET + 52)
#define RZN1_FUNC_PTO_PWM1			(RZN1_FUNC_L2_OFFSET + 53)
#define RZN1_FUNC_PTO_PWM2			(RZN1_FUNC_L2_OFFSET + 54)
#define RZN1_FUNC_PTO_PWM3			(RZN1_FUNC_L2_OFFSET + 55)
#define RZN1_FUNC_PTO_PWM4			(RZN1_FUNC_L2_OFFSET + 56)
#define RZN1_FUNC_DELTA_SIGMA			(RZN1_FUNC_L2_OFFSET + 57)
#define RZN1_FUNC_SGPIO2_M			(RZN1_FUNC_L2_OFFSET + 58)
#define RZN1_FUNC_SGPIO3_M			(RZN1_FUNC_L2_OFFSET + 59)
#define RZN1_FUNC_SGPIO4_S			(RZN1_FUNC_L2_OFFSET + 60)
#define RZN1_FUNC_MAC_MTIP_SWITCH		(RZN1_FUNC_L2_OFFSET + 61)

#define RZN1_FUNC_MDIO_OFFSET			(RZN1_FUNC_L2_OFFSET + 62)

/* These are MDIO0 peripherals for the RZN1_FUNC_ETH_MDIO function */
#define RZN1_FUNC_MDIO0_HIGHZ			(RZN1_FUNC_MDIO_OFFSET + 0)
#define RZN1_FUNC_MDIO0_GMAC0			(RZN1_FUNC_MDIO_OFFSET + 1)
#define RZN1_FUNC_MDIO0_GMAC1			(RZN1_FUNC_MDIO_OFFSET + 2)
#define RZN1_FUNC_MDIO0_ECAT			(RZN1_FUNC_MDIO_OFFSET + 3)
#define RZN1_FUNC_MDIO0_S3_MDIO0		(RZN1_FUNC_MDIO_OFFSET + 4)
#define RZN1_FUNC_MDIO0_S3_MDIO1		(RZN1_FUNC_MDIO_OFFSET + 5)
#define RZN1_FUNC_MDIO0_HWRTOS			(RZN1_FUNC_MDIO_OFFSET + 6)
#define RZN1_FUNC_MDIO0_SWITCH			(RZN1_FUNC_MDIO_OFFSET + 7)
/* These are MDIO0 peripherals for the RZN1_FUNC_ETH_MDIO_E1 function */
#define RZN1_FUNC_MDIO0_E1_HIGHZ		(RZN1_FUNC_MDIO_OFFSET + 8)
#define RZN1_FUNC_MDIO0_E1_GMAC0		(RZN1_FUNC_MDIO_OFFSET + 9)
#define RZN1_FUNC_MDIO0_E1_GMAC1		(RZN1_FUNC_MDIO_OFFSET + 10)
#define RZN1_FUNC_MDIO0_E1_ECAT			(RZN1_FUNC_MDIO_OFFSET + 11)
#define RZN1_FUNC_MDIO0_E1_S3_MDIO0		(RZN1_FUNC_MDIO_OFFSET + 12)
#define RZN1_FUNC_MDIO0_E1_S3_MDIO1		(RZN1_FUNC_MDIO_OFFSET + 13)
#define RZN1_FUNC_MDIO0_E1_HWRTOS		(RZN1_FUNC_MDIO_OFFSET + 14)
#define RZN1_FUNC_MDIO0_E1_SWITCH		(RZN1_FUNC_MDIO_OFFSET + 15)

/* These are MDIO1 peripherals for the RZN1_FUNC_ETH_MDIO function */
#define RZN1_FUNC_MDIO1_HIGHZ			(RZN1_FUNC_MDIO_OFFSET + 16)
#define RZN1_FUNC_MDIO1_GMAC0			(RZN1_FUNC_MDIO_OFFSET + 17)
#define RZN1_FUNC_MDIO1_GMAC1			(RZN1_FUNC_MDIO_OFFSET + 18)
#define RZN1_FUNC_MDIO1_ECAT			(RZN1_FUNC_MDIO_OFFSET + 19)
#define RZN1_FUNC_MDIO1_S3_MDIO0		(RZN1_FUNC_MDIO_OFFSET + 20)
#define RZN1_FUNC_MDIO1_S3_MDIO1		(RZN1_FUNC_MDIO_OFFSET + 21)
#define RZN1_FUNC_MDIO1_HWRTOS			(RZN1_FUNC_MDIO_OFFSET + 22)
#define RZN1_FUNC_MDIO1_SWITCH			(RZN1_FUNC_MDIO_OFFSET + 23)
/* These are MDIO1 peripherals for the RZN1_FUNC_ETH_MDIO_E1 function */
#define RZN1_FUNC_MDIO1_E1_HIGHZ		(RZN1_FUNC_MDIO_OFFSET + 24)
#define RZN1_FUNC_MDIO1_E1_GMAC0		(RZN1_FUNC_MDIO_OFFSET + 25)
#define RZN1_FUNC_MDIO1_E1_GMAC1		(RZN1_FUNC_MDIO_OFFSET + 26)
#define RZN1_FUNC_MDIO1_E1_ECAT			(RZN1_FUNC_MDIO_OFFSET + 27)
#define RZN1_FUNC_MDIO1_E1_S3_MDIO0		(RZN1_FUNC_MDIO_OFFSET + 28)
#define RZN1_FUNC_MDIO1_E1_S3_MDIO1		(RZN1_FUNC_MDIO_OFFSET + 29)
#define RZN1_FUNC_MDIO1_E1_HWRTOS		(RZN1_FUNC_MDIO_OFFSET + 30)
#define RZN1_FUNC_MDIO1_E1_SWITCH		(RZN1_FUNC_MDIO_OFFSET + 31)

#define RZN1_FUNC_MAX				(RZN1_FUNC_MDIO_OFFSET + 32)

#endif /* __DT_BINDINGS_RZN1_PINCTRL_H */
