#	$NetBSD: Makefile.inc,v 1.21.6.1 2017/08/30 15:45:03 martin Exp $
#
#	etc.evbmips/Makefile.inc -- evbmips-specific etc Makefile targets
#

# If you change the list of distributed kernels, don't forget
# to update the release documentation in distrib/notes/common/contents

KERNEL_SUFFIXES=	srec ub elf32

.if ${MACHINE_ARCH} == "mipsel"
KERNEL_SETS=		ALCHEMY CI20 CPMBR1400 DBAU1500 DBAU1550 GDIUM
KERNEL_SETS+=		MALTA MTX-1 OMSAL400
BUILD_KERNELS=		INSTALL_CI20 INSTALL_OMSAL400 INSTALL_MALTA

KERNEL_SETS+=		P4032 P5064 P6032

. elif ${MACHINE_ARCH} == "mips64eb" || ${MACHINE_ARCH} == "mips64el"
KERNEL_SETS=		MALTA32 MALTA64 XLSATX32 XLSATX64
BUILD_KERNELS=		INSTALL_MALTA32 INSTALL_MALTA64
BUILD_KERNELS+=		INSTALL_XLSATX32 INSTALL_XLSATX64

. if ${MACHINE_ARCH} == "mips64el"
KERNEL_SETS+=		P5064-64
KERNEL_SETS+=		LOONGSON
BUILD_KERNELS+=		INSTALL_LOONGSON
KERNEL_SETS+=		GDIUM64
. else
KERNEL_SETS+=		ERLITE
BUILD_KERNELS+=		INSTALL_ERLITE
. endif
.else
KERNEL_SETS=		ALCHEMY DB120 DBAU1500 DBAU1550 MALTA RB433UAH
BUILD_KERNELS=		INSTALL_MALTA

.endif

# SBMIPS has a kernel for all targets
KERNEL_SETS+=		SBMIPS${MACHINE_ARCH:S/mips//:C/e[lb]//}
