.\" $Xorg: xhost.man,v 1.4 2001/02/09 02:05:46 xorgcvs Exp $
.\" Copyright 1988, 1998  The Open Group
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\" $XFree86: xc/programs/xhost/xhost.man,v 1.10 2005/02/11 03:03:19 dawes Exp $
.\"
.TH XHOST 1 __vendorversion__
.SH NAME
xhost \- server access control program for X
.SH SYNOPSIS
.B xhost
[[+\-]name ...]
.SH DESCRIPTION
The \fIxhost\fP program 
is used to add and delete host names or user names to the list allowed
to make connections to the X server.  In the case of hosts, this provides
a rudimentary form of privacy control and security.  It is only sufficient
for a workstation (single user) environment, although it does limit the
worst abuses.  Environments which require more sophisticated measures should
implement the user-based mechanism or use the hooks in the
protocol for passing other authentication data to the server.
.P
For better security use authority cookies (see xauth(1)) instead. Combine
it with a secure X11 forwarder like SSH (see ssh(1)) for connections over
an insecure network.
.SH OPTIONS
\fIXhost\fP accepts the following command line options described below.  For
security, the options that effect access control may only be run from the
"controlling host".  For workstations, this is the same machine as the
server.  For X terminals, it is the login host.
.TP 8
.B \-help
Prints a usage message.
.TP 8
.BI "[+]" "name"
The given \fIname\fP (the plus sign is optional)
is added to the list allowed to connect to the X server.
The name can be a host name or a user name.
.TP 8
.BI \- "name"
The given \fIname\fP is removed from the list of allowed
to connect to the server.  The name can be a host name or a user name.
Existing connections are not broken, but new
connection attempts will be denied.
Note that the current machine is allowed to be removed; however, further
connections (including attempts to add it back) will not be permitted.
Resetting the server (thereby breaking all connections) 
is the only way to allow local connections again.
.TP 8
.B \+
Access is granted to everyone, even if they aren't on the list
(i.e., access control is turned off).
.TP 8
.B \-
Access is restricted to only those on the list
(i.e., access control is turned on).
.TP 8
.I nothing
If no command line arguments are given,
a message indicating whether or not access control is currently enabled
is printed, followed by the list of those allowed to connect.
This is the only option that may be used from machines other than
the controlling host.
.SH NAMES
A complete name has the syntax
``family:name'' where the families are
as follows:
.PP
.nf
.ta 1i
inet	Internet host (IPv4)
inet6	Internet host (IPv6)
dnet	DECnet host
nis	Secure RPC network name
krb	Kerberos V5 principal
local	contains only one name, the empty string
.fi
.PP
The family is case insensitive.
The format of the name varies with the family.
.PP
When Secure RPC is being used, the
network independent netname (e.g., "nis:unix.\fIuid\fP@\fIdomainname\fP") can
be specified, or a local user can be specified with just the username
and a trailing at-sign (e.g., "nis:pat@").
.PP
For backward compatibility with pre-R6 \fIxhost\fP,
names that contain an at-sign (@) are assumed to be in the nis family.
Otherwise they are assumed to be Internet addresses. If compiled to support
IPv6, then all IPv4 and IPv6 addresses returned by getaddrinfo(3) are added to
the access list in the appropriate inet or inet6 family.
.SH DIAGNOSTICS
For each name added to the access control list,
a line of the form "\fIname\fP being added to access control list"
is printed.
For each name removed from the access control list,
a line of the form "\fIname\fP being removed from access control list"
is printed.
.SH FILES
/etc/X*.hosts
.SH "SEE ALSO"
X(__miscmansuffix__), Xsecurity(__miscmansuffix__), Xserver(1), xdm(1), getaddrinfo(3), ssh(1)
.SH ENVIRONMENT
.TP 8
.B DISPLAY
to get the default host and display to use.
.SH BUGS
.PP
You can't specify a display on the command line because
.B \-display 
is a valid command line argument (indicating that you want
to remove the machine named 
.I ``display''
from the access list).
.PP
The X server stores network addresses, not host names.  This is not
really a bug.  If somehow you change a host's network address while
the server is still running, \fIxhost\fP must be used to add the new
address and/or remove the old address.
.SH AUTHORS
Bob Scheifler, MIT Laboratory for Computer Science,
.br
Jim Gettys, MIT Project Athena (DEC).
