/*	$NetBSD: am335x_prcm.h,v 1.8.2.1 2015/06/10 16:38:05 snj Exp $	*/

/*
 * TI OMAP Power, Reset, and Clock Management on the AM335x
 */

/*-
 * Copyright (c) 2012 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Taylor R. Campbell.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _ARM_OMAP_AM335X_PRCM_H_
#define _ARM_OMAP_AM335X_PRCM_H_

#include <sys/bus.h>

struct omap_module {
	bus_size_t om_prcm_cm_module;
	bus_size_t om_prcm_cm_clkctrl_reg;
};

#define AM335X_PRCM_CM_PER	0x0000
#define CM_PER_L4LS_CLKSTCTRL		0x000
#define CM_PER_L3S_CLKSTCTRL		0x004
#define CM_PER_L3_CLKSTCTRL		0x00C
#define CM_PER_CPGMAC0_CLKCTRL		0x014
#define CM_PER_LCDC_CLKCTRL		0x018
#define CM_PER_USB0_CLKCTRL		0x01C
#define CM_PER_TPTC0_CLKCTRL		0x024
#define CM_PER_UART5_CLKCTRL		0x038
#define CM_PER_MMC0_CLKCTRL		0x03C
#define CM_PER_I2C2_CLKCTRL		0x044
#define CM_PER_I2C1_CLKCTRL		0x048
#define CM_PER_UART1_CLKCTRL		0x06C
#define CM_PER_UART2_CLKCTRL		0x070
#define CM_PER_UART3_CLKCTRL		0x074
#define CM_PER_UART4_CLKCTRL		0x078
#define CM_PER_TIMER7_CLKCTRL		0x07C
#define CM_PER_TIMER2_CLKCTRL		0x080
#define CM_PER_TIMER3_CLKCTRL		0x084
#define CM_PER_TIMER4_CLKCTRL		0x088
#define CM_PER_RNG_CLKCTRL		0x090
#define CM_PER_GPIO1_CLKCTRL		0x0AC
#define CM_PER_GPIO2_CLKCTRL		0x0B0
#define CM_PER_GPIO3_CLKCTRL		0x0B4
#define CM_PER_TPCC_CLKCTRL		0x0BC
#define CM_PER_EPWMSS1_CLKCTRL		0x0CC
#define CM_PER_EPWMSS0_CLKCTRL		0x0D4
#define CM_PER_EPWMSS2_CLKCTRL		0x0D8
#define CM_PER_L3_INSTR_CLKCTRL		0x0DC
#define CM_PER_L3_CLKCTRL		0x0E0
#define CM_PER_PRUSS_CLKCTRL		0x0E8
#define CM_PER_TIMER5_CLKCTRL		0x0EC
#define CM_PER_TIMER6_CLKCTRL		0x0F0
#define CM_PER_MMC1_CLKCTRL		0x0F4
#define CM_PER_MMC2_CLKCTRL		0x0F8
#define CM_PER_TPTC1_CLKCTRL		0x0FC
#define CM_PER_TPTC2_CLKCTRL		0x100
#define CM_PER_SPINLOCK0_CLKCTRL	0x10C
#define CM_PER_MAILBOX0_CLKCTRL		0x110
#define CM_PER_OCPWP_L3_CLKSTCTRL	0x12C
#define CM_PER_OCPWP_CLKCTRL		0x130
#define CM_PER_CPSW_CLKSTCTRL		0x144
#define CM_PER_PRUSS_CLKSTCTRL		0x140

#define AM335X_PRCM_CM_WKUP	0x0400
#define CM_WKUP_CLKSTCTRL		0x000
#define CM_WKUP_CONTROL_CLKCTRL		0x004
#define CM_WKUP_GPIO0_CLKCTRL		0x008
#define CM_WKUP_CM_L3_AON_CLKSTCTRL	0x01C
#define CM_WKUP_CM_CLKSEL_DPLL_MPU	0x02C
#define CM_WKUP_CM_IDLEST_DPLL_DISP	0x048
#define CM_WKUP_CM_CLKSEL_DPLL_DISP	0x054
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER	0x07C
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_CLKDCOLDO_ST		0x200
#define CM_WKUP_CM_CLKDCOLDO_DPLL_PER_CLKDCOLDO_GATE_CTRL	0x100

#define CM_WKUP_CM_CLKMODE_DPLL_DISP	0x098
#define CM_WKUP_I2C0_CLKCTRL		0x0B8
#define CM_WKUP_ADC_TSC_CLKCTRL		0x0BC

#define AM335X_PRCM_CM_DPLL	0x0500
#define CLKSEL_TIMER7_CLK		0x004
#define CLKSEL_TIMER2_CLK		0x008
#define CLKSEL_TIMER3_CLK		0x00C
#define CLKSEL_TIMER4_CLK		0x010
#define CLKSEL_TIMER5_CLK		0x018
#define CLKSEL_TIMER6_CLK		0x01C
#define CLKSEL_PRUSS_OCP_CLK		0x030

#define AM335X_PRCM_CM_MPU	0x0600
#define AM335X_PRCM_CM_DEVICE	0x0700
#define AM335X_PRCM_CM_RTC	0x0800
#define AM335X_PRCM_CM_GFX	0x0900
#define AM335X_PRCM_CM_CEFUSE	0x0a00

#define AM335X_PRCM_PRM_IRQ	0x0b00
#define AM335X_PRCM_PRM_PER	0x0c00
#define AM335X_PRCM_PRM_WKUP	0x0d00
#define AM335X_PRCM_PRM_MPU	0x0e00
#define AM335X_PRCM_PRM_DEVICE	0x0f00
#define AM335X_PRCM_PRM_RTC	0x1000
#define AM335X_PRCM_PRM_GFX	0x1100
#define AM335X_PRCM_PRM_CEFUSE	0x1200

/* In CM_WKUP */
#define	AM335X_PRCM_CM_IDLEST_DPLL_MPU	0x20
#define  AM335X_PRCM_CM_IDLEST_DPLL_ST_DPLL_CLK_MN_BYPASS	__BIT(8)
#define  AM335X_PRCM_CM_IDLEST_DPLL_ST_DPLL_CLK_LOCKED		__BIT(0)
#define	AM335X_PRCM_CM_CLKSEL_DPLL_MPU	0x2c
#define  AM335X_PRCM_CM_CLKSEL_DPLL_BYPASS	__BIT(23)
#define  AM335X_PRCM_CM_CLKSEL_DPLL_MULT	__BITS(18,8)
#define  AM335X_PRCM_CM_CLKSEL_DPLL_DIV		__BITS(6,0)
#define	AM335X_PRCM_CM_CLKMODE_DPLL_MPU	0x88
#define  AM335X_PRCM_CM_CLKMODE_DPLL_MN_BYP_MODE	4
#define  AM335X_PRCM_CM_CLKMODE_DPLL_LOCK_MODE		7
#define	AM335X_PRCM_CM_DIV_M2_DPLL_MPU	0xa8
#define	 AM335X_PRCM_CM_DIV_M2_DPLL_ST_DPLL_CLKOUT	__BIT(9)
#define	 AM335X_PRCM_CM_DIV_M2_DPLL_CLKOUT_GATE_CTRL	__BIT(8)
#define	 AM335X_PRCM_CM_DIV_M2_DPLL_CLKOUT_DIVCHACK	__BIT(5)
#define	 AM335X_PRCM_CM_DIV_M2_DPLL_CLKOUT_DIV		__BITS(4,0)


#define PRM_RSTCTRL		0x00	/* offset from AM335X_PRCM_PRM_DEVICE */
#define RST_GLOBAL_WARM_SW	__BIT(0)
#define RST_GLOBAL_COLD_SW	__BIT(1)

#ifdef _KERNEL
int  set_mpu_volt(int);
void am335x_sys_clk(bus_space_handle_t);
void am335x_cpu_clk(void);
#endif

#endif  /* _ARM_OMAP_AM335X_PRCM_H_ */
