/* $NetBSD: amlogic_crureg.h,v 1.7.2.4 2015/04/30 19:34:40 snj Exp $ */

/*-
 * Copyright (c) 2015 Jared D. McNeill <jmcneill@invisible.ca>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
 * BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED
 * AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _ARM_AMLOGIC_CRUREG_H
#define _ARM_AMLOGIC_CRUREG_H

#define CBUS_REG(n)	((n) << 2)

#define EE_CLK_GATING0_REG		CBUS_REG(0x1050)
#define EE_CLK_GATING1_REG		CBUS_REG(0x1051)
#define EE_CLK_GATING2_REG		CBUS_REG(0x1052)
#define EE_CLK_GATING3_REG		CBUS_REG(0x1054)

#define EE_CLK_GATING0_SDIO		__BIT(17)
#define EE_CLK_GATING0_SDHC		__BIT(14)
#define EE_CLK_GATING0_RNG		__BIT(12)

#define EE_CLK_GATING1_USB_GENERAL	__BIT(26)
#define EE_CLK_GATING1_USB1		__BIT(22)
#define EE_CLK_GATING1_USB0		__BIT(21)
#define EE_CLK_GATING1_ETHERNET		__BIT(3)

#define EE_CLK_GATING2_USB0_TO_DDR	__BIT(9)
#define EE_CLK_GATING2_USB1_TO_DDR	__BIT(8)

#define EE_CLK_GATING3_RNG		__BIT(21)

#define HHI_SYS_CPU_CLK_CNTL1_REG	CBUS_REG(0x1057)
#define HHI_SYS_CPU_CLK_CNTL1_SDIV	__BITS(29,20)
#define HHI_SYS_CPU_CLK_CNTL1_PERIPH_CLK_MUX __BITS(8,6)

#define HHI_MPEG_CLK_CNTL_REG		CBUS_REG(0x105d)
#define HHI_MPEG_CLK_CNTL_DIV_SRC	__BITS(14,12)
#define HHI_MPEG_CLK_CNTL_DIV_N		__BITS(5,0)

#define HHI_SYS_CPU_CLK_CNTL0_REG	CBUS_REG(0x1067)
#define HHI_SYS_CPU_CLK_CNTL0_CLKSEL	__BIT(7)
#define HHI_SYS_CPU_CLK_CNTL0_SOUTSEL	__BITS(3,2)
#define HHI_SYS_CPU_CLK_CNTL0_PLLSEL	__BITS(1,0)

#define HHI_SYS_PLL_CNTL_REG		CBUS_REG(0x10c0)
#define HHI_SYS_PLL_CNTL_MUL		__BITS(8,0)
#define HHI_SYS_PLL_CNTL_DIV		__BITS(14,9)
#define HHI_SYS_PLL_CNTL_OD		__BITS(17,16)

#define HHI_MPLL_CNTL_REG		CBUS_REG(0x10a0)
#define HHI_MPLL_CNTL_MUL		__BITS(8,0)
#define HHI_MPLL_CNTL_DIV		__BITS(13,9)
#define HHI_MPLL_CNTL_OD		__BITS(17,16)

#define RESET1_REG			CBUS_REG(0x1102)
#define RESET1_USB			__BIT(2)

#define RESET6_REG			CBUS_REG(0x1107)
#define RESET6_SDIO			__BIT(8)

#define PREG_CTLREG0_ADDR_REG		CBUS_REG(0x2000)
#define PREG_CTLREG0_ADDR_CLKRATE	__BITS(9,4)

#define PREG_PAD_GPIO0_EN_N_REG		CBUS_REG(0x200c)
#define PREG_PAD_GPIO0_OUT_REG		CBUS_REG(0x200d)
#define PREG_PAD_GPIO0_IN_REG		CBUS_REG(0x200e)
#define PREG_PAD_GPIO0_PUPD_EN_REG	CBUS_REG(0x204c)
#define PREG_PAD_GPIO0_PUPD_REG		CBUS_REG(0x203e)

#define PREG_PAD_GPIO1_EN_N_REG		CBUS_REG(0x200f)
#define PREG_PAD_GPIO1_OUT_REG		CBUS_REG(0x2010)
#define PREG_PAD_GPIO1_IN_REG		CBUS_REG(0x2011)
#define PREG_PAD_GPIO1_PUPD_EN_REG	CBUS_REG(0x204b)
#define PREG_PAD_GPIO1_PUPD_REG		CBUS_REG(0x203d)

#define PREG_PAD_GPIO2_EN_N_REG		CBUS_REG(0x2012)
#define PREG_PAD_GPIO2_OUT_REG		CBUS_REG(0x2013)
#define PREG_PAD_GPIO2_IN_REG		CBUS_REG(0x2014)
#define PREG_PAD_GPIO2_PUPD_EN_REG	CBUS_REG(0x2048)
#define PREG_PAD_GPIO2_PUPD_REG		CBUS_REG(0x203a)

#define PREG_PAD_GPIO3_EN_N_REG		CBUS_REG(0x2015)
#define PREG_PAD_GPIO3_OUT_REG		CBUS_REG(0x2016)
#define PREG_PAD_GPIO3_IN_REG		CBUS_REG(0x2017)
#define PREG_PAD_GPIO3_PUPD_EN_REG	CBUS_REG(0x204a)
#define PREG_PAD_GPIO3_PUPD_REG		CBUS_REG(0x203c)

#define PREG_PAD_GPIO5_EN_N_REG		CBUS_REG(0x201b)
#define PREG_PAD_GPIO5_OUT_REG		CBUS_REG(0x201c)
#define PREG_PAD_GPIO5_IN_REG		CBUS_REG(0x201d)

#define PERIPHS_PIN_MUX_0_REG		CBUS_REG(0x202c)
#define PERIPHS_PIN_MUX_1_REG		CBUS_REG(0x202d)
#define PERIPHS_PIN_MUX_2_REG		CBUS_REG(0x202e)
#define PERIPHS_PIN_MUX_3_REG		CBUS_REG(0x202f)
#define PERIPHS_PIN_MUX_4_REG		CBUS_REG(0x2030)
#define PERIPHS_PIN_MUX_5_REG		CBUS_REG(0x2031)
#define PERIPHS_PIN_MUX_6_REG		CBUS_REG(0x2032)
#define PERIPHS_PIN_MUX_7_REG		CBUS_REG(0x2033)
#define PERIPHS_PIN_MUX_8_REG		CBUS_REG(0x2034)
#define PERIPHS_PIN_MUX_9_REG		CBUS_REG(0x2035)

#define PAD_PULL_UP_6_REG		CBUS_REG(0x2039)
#define PAD_PULL_UP_0_REG		CBUS_REG(0x203a)
#define PAD_PULL_UP_1_REG		CBUS_REG(0x203b)
#define PAD_PULL_UP_2_REG		CBUS_REG(0x203c)
#define PAD_PULL_UP_3_REG		CBUS_REG(0x203d)
#define PAD_PULL_UP_4_REG		CBUS_REG(0x203e)
#define PAD_PULL_UP_5_REG		CBUS_REG(0x203f)

#define RAND64_ADDR0_REG		CBUS_REG(0x2040)
#define RAND64_ADDR1_REG		CBUS_REG(0x2041)

#define PAD_PULL_UP_EN_0_REG		CBUS_REG(0x2048)
#define PAD_PULL_UP_EN_1_REG		CBUS_REG(0x2049)
#define PAD_PULL_UP_EN_2_REG		CBUS_REG(0x204a)
#define PAD_PULL_UP_EN_3_REG		CBUS_REG(0x204b)
#define PAD_PULL_UP_EN_4_REG		CBUS_REG(0x204c)
#define PAD_PULL_UP_EN_5_REG		CBUS_REG(0x204d)
#define PAD_PULL_UP_EN_6_REG		CBUS_REG(0x204e)

#define AM_RING_OSC_REG			CBUS_REG(0x207f)

#define AM_RING_OSC_ENABLE		__BIT(0)
#define AM_RING_OSC_HF_MODE		__BIT(1)

#define PREI_USB_PHY_A_CFG_REG		CBUS_REG(0x2200)
#define PREI_USB_PHY_A_CTRL_REG		CBUS_REG(0x2201)
#define PREI_USB_PHY_A_ADP_BC_REG	CBUS_REG(0x2203)
#define PREI_USB_PHY_B_CFG_REG		CBUS_REG(0x2208)
#define PREI_USB_PHY_B_CTRL_REG		CBUS_REG(0x2209)
#define PREI_USB_PHY_B_ADP_BC_REG	CBUS_REG(0x220b)

#define PREI_USB_PHY_CFG_CLK_32K_ALT_SEL __BIT(15)

#define PREI_USB_PHY_CTRL_FSEL		__BITS(24,22)
#define PREI_USB_PHY_CTRL_FSEL_24M	5
#define PREI_USB_PHY_CTRL_FSEL_12M	2
#define PREI_USB_PHY_CTRL_POR		__BIT(15)
#define PREI_USB_PHY_CTRL_CLK_DET	__BIT(8)

#define PREI_USB_PHY_ADP_BC_ACA_FLOATING __BIT(26)
#define PREI_USB_PHY_ADP_BC_ACA_ENABLE	__BIT(16)

#define WATCHDOG_TC_REG			CBUS_REG(0x2640)
#define WATCHDOG_TC_CPUS		__BITS(27,24)
#define WATCHDOG_TC_ENABLE		__BIT(19)
#define WATCHDOG_TC_TCNT		__BITS(15,0)

#define WATCHDOG_RESET_REG		CBUS_REG(0x2641)
#define WATCHDOG_RESET_COUNT		__BITS(15,0)

#endif /* _ARM_AMLOGIC_CRUREG_H */
