/*	$NetBSD: acquire_cred.c,v 1.1.1.2.12.1 2017/08/20 05:44:17 snj Exp $	*/

/*
 * Copyright (c) 1997 - 2004 Kungliga Tekniska Högskolan
 * (Royal Institute of Technology, Stockholm, Sweden).
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the Institute nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE INSTITUTE AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE INSTITUTE OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include "ntlm.h"

OM_uint32 GSSAPI_CALLCONV
_gss_ntlm_acquire_cred(OM_uint32            *min_stat,
                       gss_const_name_t     desired_name,
                       OM_uint32            time_req,
                       const gss_OID_set    desired_mechs,
                       gss_cred_usage_t     cred_usage,
                       gss_cred_id_t        *output_cred_handle,
                       gss_OID_set          *actual_mechs,
                       OM_uint32            *time_rec)
{
    ntlm_name name = (ntlm_name) desired_name;
    const char *domain = NULL;
    OM_uint32 maj_stat;
    ntlm_ctx ctx;

    *min_stat = 0;
    *output_cred_handle = GSS_C_NO_CREDENTIAL;
    if (actual_mechs)
	*actual_mechs = GSS_C_NO_OID_SET;
    if (time_rec)
	*time_rec = GSS_C_INDEFINITE;

    if (cred_usage == GSS_C_BOTH || cred_usage == GSS_C_ACCEPT) {

	maj_stat = _gss_ntlm_allocate_ctx(min_stat, &ctx);
	if (maj_stat != GSS_S_COMPLETE)
	    return maj_stat;

        domain = name != NULL ? name->domain : NULL;
	maj_stat = (*ctx->server->nsi_probe)(min_stat, ctx->ictx, domain);
	{
	    gss_ctx_id_t context = (gss_ctx_id_t)ctx;
	    OM_uint32 junk;
	    _gss_ntlm_delete_sec_context(&junk, &context, NULL);
	}
	if (maj_stat)
	    return maj_stat;
    }
    if (cred_usage == GSS_C_BOTH || cred_usage == GSS_C_INITIATE) {
	ntlm_cred cred;

	*min_stat = _gss_ntlm_get_user_cred(name, &cred);
	if (*min_stat)
	    return GSS_S_NO_CRED;
	cred->usage = cred_usage;

	*output_cred_handle = (gss_cred_id_t)cred;
    }

    return (GSS_S_COMPLETE);
}
