/*	$NetBSD: exynos4_loc.c,v 1.9.4.1 2015/01/04 11:19:00 martin Exp $	*/

/*-
 * Copyright (c) 2014 The NetBSD Foundation, Inc.
 * All rights reserved.
 *
 * This code is derived from software contributed to The NetBSD Foundation
 * by Nick Hudson
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE NETBSD FOUNDATION, INC. AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
 * TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE FOUNDATION OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <arm/samsung/exynos_io.h>
#include <arm/samsung/exynos_intr.h>

#include <arm/samsung/exynos4_reg.h>

#define IRQ_G3D_IRQGP			IRQ_SPI(127)
#define IRQ_G3D_IRQPP3			IRQ_SPI(126)
#define IRQ_G3D_IRQPP2			IRQ_SPI(125)
#define IRQ_G3D_IRQPP1			IRQ_SPI(124)
#define IRQ_G3D_IRQPP0			IRQ_SPI(123)
#define IRQ_G3D_IRQGPMMU		IRQ_SPI(122)
#define IRQ_G3D_IRQPPMMU3		IRQ_SPI(121)
#define IRQ_G3D_IRQPPMMU2		IRQ_SPI(120)
#define IRQ_G3D_IRQPPMMU1		IRQ_SPI(119)
#define IRQ_G3D_IRQPPMMU0		IRQ_SPI(118)
#define IRQ_G3D_IRQPMU			IRQ_SPI(117)
#define IRQ_C2C_SSCM_1			IRQ_SPI(116)
#define IRQ_TSI				IRQ_SPI(115)
#define IRQ_CEC				IRQ_SPI(114)
#define IRQ_SLIMBUS			IRQ_SPI(113)
#define IRQ_SSS				IRQ_SPI(112)
#define IRQ_GPS				IRQ_SPI(111)
#define IRQ_PMU				IRQ_SPI(110)
#define IRQ_KEYPAD			IRQ_SPI(109)

#define IRQ_FIMC_LITE1			IRQ_SPI(106)
#define IRQ_FIMC_LITE0			IRQ_SPI(105)
#define IRQ_SPDIF			IRQ_SPI(104)
#define IRQ_PCM2			IRQ_SPI(103)
#define IRQ_PCM1			IRQ_SPI(102)
#define IRQ_PCM0			IRQ_SPI(101)
#define IRQ_AC97			IRQ_SPI(100)
#define IRQ_I2S2			IRQ_SPI(99)
#define IRQ_I2S1			IRQ_SPI(98)
#define IRQ_I2S0			IRQ_SPI(97)
#define IRQ_AUDIO_SS			IRQ_SPI(96)
#define IRQ_ISP_1			IRQ_SPI(95)
#define IRQ_MFC				IRQ_SPI(94)
#define IRQ_HDMI_I2C			IRQ_SPI(93)
#define IRQ_HDMI			IRQ_SPI(92)
#define IRQ_MIXER			IRQ_SPI(91)
#define IRQ_ISP_0			IRQ_SPI(90)
#define IRQ_G2D				IRQ_SPI(89)
#define IRQ_JPEG			IRQ_SPI(88)
#define IRQ_FIMC3			IRQ_SPI(87)
#define IRQ_FIMC2			IRQ_SPI(86)
#define IRQ_FIMC1			IRQ_SPI(85)
#define IRQ_FIMC0			IRQ_SPI(84)
#define IRQ_ROTATOR			IRQ_SPI(83)
#define IRQ_MIPI_CSI_2LANE		IRQ_SPI(80)
#define IRQ_MIPI_DSI_4LANE		IRQ_SPI(79)
#define IRQ_MIPI_CSI_4LANE		IRQ_SPI(78)
#define IRQ_SDMMC			IRQ_SPI(77)
#define IRQ_HSMMC3			IRQ_SPI(76)
#define IRQ_HSMMC2			IRQ_SPI(75)
#define IRQ_HSMMC1			IRQ_SPI(74)
#define IRQ_HSMMC0			IRQ_SPI(73)
#define IRQ_GPIO_C2C			IRQ_SPI(72)
#define IRQ_HSOTG			IRQ_SPI(71)
#define IRQ_UHOST			IRQ_SPI(70)
#define IRQ_G1_IRQ			IRQ_SPI(69)
#define IRQ_SPI2			IRQ_SPI(68)
#define IRQ_SPI1			IRQ_SPI(67)
#define IRQ_SPI0			IRQ_SPI(66)
#define IRQ_I2C7			IRQ_SPI(65)
#define IRQ_I2C6			IRQ_SPI(64)
#define IRQ_I2C5			IRQ_SPI(63)
#define IRQ_I2C4			IRQ_SPI(62)
#define IRQ_I2C3			IRQ_SPI(61)
#define IRQ_I2C2			IRQ_SPI(60)
#define IRQ_I2C1			IRQ_SPI(59)
#define IRQ_I2C0			IRQ_SPI(58)
#define IRQ_G0_IRQ			IRQ_SPI(57)
#define IRQ_UART3			IRQ_SPI(55)
#define IRQ_UART2			IRQ_SPI(54)
#define IRQ_UART1			IRQ_SPI(53)
#define IRQ_UART0			IRQ_SPI(52)
#define IRQ_NFC				IRQ_SPI(51)
#define IRQ_IEM_IEC			IRQ_SPI(50)
#define IRQ_IEM_APC			IRQ_SPI(49)
#define IRQ_GPIO_LB			IRQ_SPI(47)
#define IRQ_GPIO_RT			IRQ_SPI(46)
#define IRQ_RTC_TIC			IRQ_SPI(45)
#define IRQ_RTC_ALARM			IRQ_SPI(44)
#define IRQ_WDT				IRQ_SPI(43)
#define IRQ_TIMER4			IRQ_SPI(41)
#define IRQ_TIMER3			IRQ_SPI(40)
#define IRQ_TIMER2			IRQ_SPI(39)
#define IRQ_TIMER1			IRQ_SPI(38)
#define IRQ_TIMER0			IRQ_SPI(37)
#define IRQ_PDMA1			IRQ_SPI(36)
#define IRQ_PDMA0			IRQ_SPI(35)
#define IRQ_MDMA			IRQ_SPI(34)
#define IRQ_C2C_SSCM_0			IRQ_SPI(33)
#define IRQ_EINT16_31			IRQ_SPI(32)
#define IRQ_EINT_15			IRQ_SPI(31)
#define IRQ_EINT_14			IRQ_SPI(30)
#define IRQ_EINT_13			IRQ_SPI(29)
#define IRQ_EINT_12			IRQ_SPI(28)
#define IRQ_EINT_11			IRQ_SPI(27)
#define IRQ_EINT_10			IRQ_SPI(26)
#define IRQ_EINT_9			IRQ_SPI(25)
#define IRQ_EINT_8			IRQ_SPI(24)
#define IRQ_EINT_7			IRQ_SPI(23)
#define IRQ_EINT_6			IRQ_SPI(22)
#define IRQ_EINT_5			IRQ_SPI(21)
#define IRQ_EINT_4			IRQ_SPI(20)
#define IRQ_EINT_3			IRQ_SPI(19)
#define IRQ_EINT_2			IRQ_SPI(18)
#define IRQ_EINT_1			IRQ_SPI(17)
#define IRQ_EINT_0			IRQ_SPI(16)

/* rest of PPI's marked reserved */
#define IRQ_MCT_L			IRQ_PPI(12)
#define IRQ_MCT_G			IRQ_PPI(10)

#define IRQ_CPU_NIRQOUT_3		EXYNOS_COMBINERIRQ(19, 6)
#define IRQ_PARITYFAILSCU_3		EXYNOS_COMBINERIRQ(19, 5)
#define IRQ_PARITYFAIL3			EXYNOS_COMBINERIRQ(19, 4)
#define IRQ_NCTIIRQ_3			EXYNOS_COMBINERIRQ(19, 3)
#define IRQ_PMUIRQ_3			EXYNOS_COMBINERIRQ(19, 2)
#define IRQ_MCT_L0_IRQ			EXYNOS_COMBINERIRQ(19, 0)
#define IRQ_CPU_NIRQOUT_2		EXYNOS_COMBINERIRQ(18, 6)
#define IRQ_PARITYFAILSCU_2		EXYNOS_COMBINERIRQ(18, 5)
#define IRQ_PARITYFAIL2			EXYNOS_COMBINERIRQ(18, 4)
#define IRQ_NCTIIRQ_2			EXYNOS_COMBINERIRQ(18, 3)
#define IRQ_PMUIRQ_2			EXYNOS_COMBINERIRQ(18, 2)
#define IRQ_MCT_L1_IRQ			EXYNOS_COMBINERIRQ(18, 0)
#define IRQ_MCT_L2_IRQ			EXYNOS_COMBINERIRQ(17, 7)
#define IRQ_SYSMMU_ISP_CX_1		EXYNOS_COMBINERIRQ(17, 5)
#define IRQ_SYSMMU_FIMC_FD_1		EXYNOS_COMBINERIRQ(17, 4)
#define IRQ_SYSMMU_FIMC_DRC_1		EXYNOS_COMBINERIRQ(17, 3)
#define IRQ_SYSMMU_FIMC_ISP_1		EXYNOS_COMBINERIRQ(17, 2)
#define IRQ_SYSMMU_FIMC_LITE1_1		EXYNOS_COMBINERIRQ(17, 1)
#define IRQ_SYSMMU_FIMC_LITE0_1		EXYNOS_COMBINERIRQ(17, 0)
#define IRQ_MCT_L3_IRQ			EXYNOS_COMBINERIRQ(16, 7)
#define IRQ_SYSMMU_ISP_CX_0		EXYNOS_COMBINERIRQ(16, 5)
#define IRQ_SYSMMU_FIMC_FD_0		EXYNOS_COMBINERIRQ(16, 4)
#define IRQ_SYSMMU_FIMC_DRC_0		EXYNOS_COMBINERIRQ(16, 3)
#define IRQ_SYSMMU_FIMC_ISP_0		EXYNOS_COMBINERIRQ(16, 2)
#define IRQ_SYSMMU_FIMC_LITE1_0		EXYNOS_COMBINERIRQ(16, 1)
#define IRQ_SYSMMU_FIMC_LITE0_0		EXYNOS_COMBINERIRQ(16, 0)
#define IRQ_DECERRINTR			EXYNOS_COMBINERIRQ(15, 7)
#define IRQ_SLVERRINTR			EXYNOS_COMBINERIRQ(15, 6)
#define IRQ_ERRRDINTR			EXYNOS_COMBINERIRQ(15, 5)
#define IRQ_ERRRTINTR			EXYNOS_COMBINERIRQ(15, 4)
#define IRQ_ERRWDINTR			EXYNOS_COMBINERIRQ(15, 3)
#define IRQ_ERRWTINTR			EXYNOS_COMBINERIRQ(15, 2)
#define IRQ_ECNTRINTR			EXYNOS_COMBINERIRQ(15, 1)
#define IRQ_SCUEVABORT			EXYNOS_COMBINERIRQ(15, 0)
#define IRQ_CPU_NIRQOUT_1		EXYNOS_COMBINERIRQ(14, 6)
#define IRQ_CPU_NIRQOUT_0		EXYNOS_COMBINERIRQ(13, 5)
#define IRQ_MCT_G3			EXYNOS_COMBINERIRQ(12, 7)
#define IRQ_MCT_G2			EXYNOS_COMBINERIRQ(12, 6)
#define IRQ_MCT_G1			EXYNOS_COMBINERIRQ(12, 5)
#define IRQ_MCT_G0			EXYNOS_COMBINERIRQ(12, 4)
#define IRQ_MIPI_HSI			EXYNOS_COMBINERIRQ(12, 1)
#define IRQ_UART4			EXYNOS_COMBINERIRQ(12, 0)
#define IRQ_LCD0_3			EXYNOS_COMBINERIRQ(11, 3)
#define IRQ_LCD0_2			EXYNOS_COMBINERIRQ(11, 2)
#define IRQ_LCD0_1			EXYNOS_COMBINERIRQ(11, 1)
#define IRQ_LCD0_0			EXYNOS_COMBINERIRQ(11, 0)
#define IRQ_DMC1_PPC_PEREV_M		EXYNOS_COMBINERIRQ(10, 7)
#define IRQ_DMC1_PPC_PEREV_A		EXYNOS_COMBINERIRQ(10, 6)
#define IRQ_DMC0_PPC_PEREV_M		EXYNOS_COMBINERIRQ(10, 5)
#define IRQ_DMC0_PPC_PEREV_A		EXYNOS_COMBINERIRQ(10, 4)
#define IRQ_ADC				EXYNOS_COMBINERIRQ(10, 3)
#define IRQ_L2CACHE			EXYNOS_COMBINERIRQ(10, 2)
#define IRQ_RP_TIMER			EXYNOS_COMBINERIRQ(10, 1)
#define IRQ_GPIO_AUDIO			EXYNOS_COMBINERIRQ(10, 0)
#define IRQ_PPMU_ISP_X			EXYNOS_COMBINERIRQ(9, 7)
#define IRQ_PPMU_MFC_M1			EXYNOS_COMBINERIRQ(9, 6)
#define IRQ_PPMU_MFC_M0			EXYNOS_COMBINERIRQ(9, 5)
#define IRQ_PPMU_3D			EXYNOS_COMBINERIRQ(9, 4)
#define IRQ_PPMU_TV_M0			EXYNOS_COMBINERIRQ(9, 3)
#define IRQ_PPMU_FILE_D_M0		EXYNOS_COMBINERIRQ(9, 2)
#define IRQ_PPMU_ISP_MX			EXYNOS_COMBINERIRQ(9, 1)
#define IRQ_PPMU_LCD0			EXYNOS_COMBINERIRQ(9, 0)
#define IRQ_PPMU_IMAGE_M0		EXYNOS_COMBINERIRQ(8, 7)
#define IRQ_PPMU_CAMIF_M0		EXYNOS_COMBINERIRQ(8, 6)
#define IRQ_PPMU_D_RIGHT_M0		EXYNOS_COMBINERIRQ(8, 5)
#define IRQ_PPMU_D_LEFT_M0		EXYNOS_COMBINERIRQ(8, 4)
#define IRQ_PPMU_ACP0_M0		EXYNOS_COMBINERIRQ(8, 3)
#define IRQ_PPMU_XIU_R_S1		EXYNOS_COMBINERIRQ(8, 2)
#define IRQ_PPMU_XIU_R			EXYNOS_COMBINERIRQ(8, 1)
#define IRQ_PPMU_XIU_L			EXYNOS_COMBINERIRQ(8, 0)
#define IRQ_SYSMMU_MFC_M1_1		EXYNOS_COMBINERIRQ(7, 6)
#define IRQ_SYSMMU_MFC_M0_1		EXYNOS_COMBINERIRQ(7, 5)
#define IRQ_SYSMMU_TV_M0_1		EXYNOS_COMBINERIRQ(7, 4)
#define IRQ_SYSMMU_LCD0_M0_1		EXYNOS_COMBINERIRQ(7, 2)
#define IRQ_SYSMMU_GPS_1		EXYNOS_COMBINERIRQ(7, 1)
#define IRQ_SYSMMU_ROTATOR_1		EXYNOS_COMBINERIRQ(7, 0)
#define IRQ_SYSMMU_2D_1			EXYNOS_COMBINERIRQ(6, 7)
#define IRQ_SYSMMU_JPEG_1		EXYNOS_COMBINERIRQ(6, 6)
#define IRQ_SYSMMU_FIMC3_1		EXYNOS_COMBINERIRQ(6, 5)
#define IRQ_SYSMMU_FIMC2_1		EXYNOS_COMBINERIRQ(6, 4)
#define IRQ_SYSMMU_FIMC1_1		EXYNOS_COMBINERIRQ(6, 3)
#define IRQ_SYSMMU_FIMC0_1		EXYNOS_COMBINERIRQ(6, 2)
#define IRQ_SYSMMU_SSS_1		EXYNOS_COMBINERIRQ(6, 1)
#define IRQ_SYSMMU_MDMA_1		EXYNOS_COMBINERIRQ(6, 0)
#define IRQ_SYSMMU_MFC_M1_0		EXYNOS_COMBINERIRQ(5, 6)
#define IRQ_SYSMMU_MFC_M0_0		EXYNOS_COMBINERIRQ(5, 5)
#define IRQ_SYSMMU_TV_M0_0		EXYNOS_COMBINERIRQ(5, 4)
#define IRQ_SYSMMU_LCD0_M0_0		EXYNOS_COMBINERIRQ(5, 2)
#define IRQ_SYSMMU_GPS_0		EXYNOS_COMBINERIRQ(5, 1)
#define IRQ_SYSMMU_ROTATOR_0		EXYNOS_COMBINERIRQ(5, 0)
#define IRQ_SYSMMU_2D_0			EXYNOS_COMBINERIRQ(4, 7)
#define IRQ_SYSMMU_JPEG_0		EXYNOS_COMBINERIRQ(4, 6)
#define IRQ_SYSMMU_FIMC3_0		EXYNOS_COMBINERIRQ(4, 5)
#define IRQ_SYSMMU_FIMC2_0		EXYNOS_COMBINERIRQ(4, 4)
#define IRQ_SYSMMU_FIMC1_0		EXYNOS_COMBINERIRQ(4, 3)
#define IRQ_SYSMMU_FIMC0_0		EXYNOS_COMBINERIRQ(4, 2)
#define IRQ_SYSMMU_SSS_0		EXYNOS_COMBINERIRQ(4, 1)
#define IRQ_SYSMMU_MDMA_0		EXYNOS_COMBINERIRQ(4, 0)
#define IRQ_NCTIIRQ_ISP			EXYNOS_COMBINERIRQ(3, 6)
#define IRQ_PMUIRQ_ISP			EXYNOS_COMBINERIRQ(3, 5)
#define IRQ_TMU_1			EXYNOS_COMBINERIRQ(3, 4)
#define IRQ_NCTIIRQ_1			EXYNOS_COMBINERIRQ(3, 3)
#define IRQ_PMUIRQ_1			EXYNOS_COMBINERIRQ(3, 2)
#define IRQ_PARITYFAILSCU_1		EXYNOS_COMBINERIRQ(3, 1)
#define IRQ_PARITYFAIL1			EXYNOS_COMBINERIRQ(3, 0)
#define IRQ_PARRINTR			EXYNOS_COMBINERIRQ(2, 6)
#define IRQ_PARRDINTR			EXYNOS_COMBINERIRQ(2, 5)
#define IRQ_TMU_0			EXYNOS_COMBINERIRQ(2, 4)
#define IRQ_NCTIIRQ_0			EXYNOS_COMBINERIRQ(2, 3)
#define IRQ_PMUIRQ_0			EXYNOS_COMBINERIRQ(2, 2)
#define IRQ_PARITYFAILSCU_0		EXYNOS_COMBINERIRQ(2, 1)
#define IRQ_PARITYFAIL0			EXYNOS_COMBINERIRQ(2, 0)
#define IRQ_TZASC1_1			EXYNOS_COMBINERIRQ(1, 3)
#define IRQ_TZASC1_0			EXYNOS_COMBINERIRQ(1, 2)
#define IRQ_TZASC0_1			EXYNOS_COMBINERIRQ(1, 1)
#define IRQ_TZASC0_0			EXYNOS_COMBINERIRQ(1, 0)
#define IRQ_MDNIE_LCD0_3		EXYNOS_COMBINERIRQ(0, 3)
#define IRQ_MDNIE_LCD0_2		EXYNOS_COMBINERIRQ(0, 2)
#define IRQ_MDNIE_LCD0_1		EXYNOS_COMBINERIRQ(0, 1)
#define IRQ_MDNIE_LCD0_0		EXYNOS_COMBINERIRQ(0, 0)

#define	OFFANDSIZE(p,n) \
	EXYNOS4##p##_##n##_OFFSET, 0x10000

static const struct exyo_locators exynos4_locators[] = {
	{ "exyogpio", 0, 0, NOPORT, NOINTR, 0 },
	{ "exyoiic", 0, 0, NOPORT, NOINTR, 0 },
	{ "mct", OFFANDSIZE(,MCT), NOPORT, IRQ_MCT_G, 0 },
	{ "exyowdt", OFFANDSIZE(,WDT), NOPORT, IRQ_WDT, 0 },
	{ "sscom", OFFANDSIZE(,UART0), 0, IRQ_UART0, 0 },
	{ "sscom", OFFANDSIZE(,UART1), 1, IRQ_UART1, 0 },
	{ "sscom", OFFANDSIZE(,UART2), 2, IRQ_UART2, 0 },
	{ "sscom", OFFANDSIZE(,UART3), 3, IRQ_UART3, 0 },
	{ "exyousb", OFFANDSIZE(,USB2HOST), NOPORT, IRQ_UHOST, 0 },
};

const struct exyo_locinfo exynos4_locinfo = {
	.locators = exynos4_locators,
	.nlocators = __arraycount(exynos4_locators)
};


/* flag signal the use of gpio */
static const struct exyo_locators exynos4_i2c_locators[] = {
					/* busname, sdabit, slcbit, func */
	{ "iic0", OFFANDSIZE(,I2C0), 0, IRQ_I2C0, 1 , "GPD1", 0, 1, 2 },
	{ "iic1", OFFANDSIZE(,I2C1), 1, IRQ_I2C1, 1 , "GPD1", 2, 3, 2 },
	{ "iic2", OFFANDSIZE(,I2C2), 2, IRQ_I2C2, 1 , "GPA0", 6, 7, 2 },
	{ "iic3", OFFANDSIZE(,I2C3), 3, IRQ_I2C3, 1 , "GPA1", 2, 3, 3 },
	{ "iic4", OFFANDSIZE(,I2C4), 4, IRQ_I2C4, 1 , "GPB",  0, 1, 3 },
	{ "iic5", OFFANDSIZE(,I2C5), 5, IRQ_I2C5, 1 , "GPB",  2, 3, 3 },
	{ "iic6", OFFANDSIZE(,I2C6), 6, IRQ_I2C6, 1 , "GPC1", 3, 4, 4 },
	{ "iic7", OFFANDSIZE(,I2C7), 7, IRQ_I2C7, 1 , "GPD0", 2, 3, 3 },
	{ "iic8", OFFANDSIZE(,I2CHDMI), 8, IRQ_HDMI_I2C, 0 , "", 0, 0, 0 },
};


const struct exyo_locinfo exynos4_i2c_locinfo = {
	.locators = exynos4_i2c_locators,
	.nlocators = __arraycount(exynos4_i2c_locators)
};

