/*
 * Copyright 2001-2009, Haiku, Inc.
 * Distributed under the terms of the MIT License.
 *
 * Authors:
 *		Stefano Ceccherini (stefano.ceccherini@gmail.com)
 */

#include <MenuPrivate.h>

#include <Bitmap.h>
#include <Menu.h>

const unsigned char kCtrlBits[] = {
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x14,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x13,0x04,0x04,0x13,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x04,0x04,0x04,0x1a,0x04,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x04,0x1a,0x1a,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x04,0x1a,0x1a,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x13,0x04,0x04,0x13,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x04,0x04,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14
};


const unsigned char kAltBits[] = {
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x14,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x13,0x04,0x04,0x13,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x04,0x1a,0x1a,0x04,0x04,0x04,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x04,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x04,0x04,0x04,0x1a,0x04,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x04,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x04,0x04,0x04,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14
};


const unsigned char kOptBits[] = {
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x14,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x13,0x04,0x04,0x13,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x04,0x04,0x1a,0x04,0x04,0x04,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x04,0x1a,0x04,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x04,0x04,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x1a,0x1a,0x04,0x1a,0x04,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x13,0x04,0x04,0x13,0x1a,0x04,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14
};


const unsigned char kShiftBits[] = {
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x14,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x17,0x04,0x04,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x17,0x17,0x04,0x1a,0x04,0x1a,0x04,0x1a,0x04,0x04,0x04,0x1a,0x04,0x04,0x04,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x17,0x04,0x04,0x17,0x1a,0x04,0x1a,0x04,0x1a,0x04,0x1a,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x04,0x1a,0x04,0x04,0x04,0x1a,0x04,0x04,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x04,0x17,0x17,0x04,0x1a,0x04,0x1a,0x04,0x1a,0x04,0x1a,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x17,0x04,0x04,0x17,0x1a,0x04,0x1a,0x04,0x1a,0x04,0x1a,0x1a,0x1a,0x1a,0x04,0x1a,0x1a,0x17,0x14,
	0x1d,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x14,
	0x1d,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14
};

namespace BPrivate {


BBitmap* MenuPrivate::sMenuItemAlt;
BBitmap* MenuPrivate::sMenuItemControl;
BBitmap* MenuPrivate::sMenuItemOption;
BBitmap* MenuPrivate::sMenuItemShift;


MenuPrivate::MenuPrivate(BMenu *menu)
	:
	fMenu(menu)
{
}


menu_layout
MenuPrivate::Layout() const
{
	return fMenu->Layout();
}


void
MenuPrivate::ItemMarked(BMenuItem *item)
{
	fMenu->_ItemMarked(item);
}


void
MenuPrivate::CacheFontInfo()
{
	fMenu->_CacheFontInfo();
}


float
MenuPrivate::FontHeight() const
{
	return fMenu->fFontHeight;
}


float
MenuPrivate::Ascent() const
{
	return fMenu->fAscent;
}


BRect
MenuPrivate::Padding() const
{
	return fMenu->fPad;
}


void
MenuPrivate::GetItemMargins(float *left, float *top,
					float *right, float *bottom) const
{
	fMenu->GetItemMargins(left, top, right, bottom);
}


/* static */
bool
MenuPrivate::IsAltCommandKey()
{
	return BMenu::sAltAsCommandKey;
}


int
MenuPrivate::State(BMenuItem **item) const
{
	return fMenu->_State(item);
}


void
MenuPrivate::Install(BWindow *window)
{
	fMenu->_Install(window);
}


void
MenuPrivate::Uninstall()
{
	fMenu->_Uninstall();
}


void
MenuPrivate::SetSuper(BMenu *menu)
{
	fMenu->fSuper = menu;
}


void
MenuPrivate::SetSuperItem(BMenuItem *item)
{
	fMenu->fSuperitem = item;
}


void
MenuPrivate::InvokeItem(BMenuItem *item, bool now)
{
	fMenu->_InvokeItem(item, now);
}


void
MenuPrivate::QuitTracking(bool thisMenuOnly)
{
	fMenu->_QuitTracking(thisMenuOnly);
}


/* static */
status_t
MenuPrivate::CreateBitmaps()
{
	BRect smallRect(0, 0, 16, 10);
	BRect largeRect(0, 0, 21, 10);
	try {
		sMenuItemAlt = new BBitmap(smallRect, B_CMAP8);
		sMenuItemControl = new BBitmap(smallRect, B_CMAP8);
		sMenuItemOption = new BBitmap(smallRect, B_CMAP8);	
		sMenuItemShift = new BBitmap(largeRect, B_CMAP8);
	} catch (...) {
		return B_NO_MEMORY;
	}
	
	sMenuItemAlt->ImportBits(kAltBits, sizeof(kAltBits),
		17, 0, B_CMAP8);
	sMenuItemControl->ImportBits(kCtrlBits, sizeof(kCtrlBits),
		17, 0, B_CMAP8);
	sMenuItemOption->ImportBits(kOptBits, sizeof(kOptBits),
		17, 0, B_CMAP8);
	sMenuItemShift->ImportBits(kShiftBits, sizeof(kShiftBits),
		22, 0, B_CMAP8);
	
	return B_OK;
}


/* static */
void
MenuPrivate::DeleteBitmaps()
{
	delete sMenuItemAlt;
	delete sMenuItemControl;
	delete sMenuItemOption;
	delete sMenuItemShift;
}


/* static */
const BBitmap *
MenuPrivate::MenuItemCommand()
{
	if (BMenu::sAltAsCommandKey)
		return sMenuItemAlt;
	
	return sMenuItemControl;
}


/* static */
const BBitmap *
MenuPrivate::MenuItemControl()
{
	if (BMenu::sAltAsCommandKey)
		return sMenuItemControl;
	
	return sMenuItemAlt;
}


/* static */
const BBitmap *
MenuPrivate::MenuItemOption()
{
	return sMenuItemOption;
}


/* static */
const BBitmap *
MenuPrivate::MenuItemShift()
{
	return sMenuItemShift;
}


}	// namespace BPrivate
