/*
 * Copyright 2009, Axel Dörfler, axeld@pinc-software.de.
 * Distributed under the terms of the MIT License.
 */


#include "UnicodeBlocks.h"


const unicode_block kNoBlock;

const struct unicode_block_entry kUnicodeBlocks[] = {
	{"Basic Latin", 0x0000, 0x007f, false, B_BASIC_LATIN_BLOCK},
	{"Latin-1 Supplement", 0x0080, 0x00ff, false, B_LATIN1_SUPPLEMENT_BLOCK},
	{"Latin Extended A", 0x0100, 0x017f, false, B_LATIN_EXTENDED_A_BLOCK},
	{"Latin Extended B", 0x0180, 0x024f, false, B_LATIN_EXTENDED_B_BLOCK},
	{"IPA Extensions", 0x0250, 0x02af, false, B_IPA_EXTENSIONS_BLOCK},
	{"Spacing Modifier Letters", 0x02b0, 0x02ff, false,
		B_SPACING_MODIFIER_LETTERS_BLOCK},
	{"Combining Diacritical Marks", 0x0300, 0x036f, false,
		B_COMBINING_DIACRITICAL_MARKS_BLOCK},
	{"Greek and Coptic", 0x0370, 0x03ff, false,
		B_BASIC_GREEK_BLOCK | B_GREEK_SYMBOLS_AND_COPTIC_BLOCK},
	{"Cyrillic", 0x0400, 0x04ff, false, B_CYRILLIC_BLOCK},
	{"Cyrillic Supplement", 0x0500, 0x052f, false, B_CYRILLIC_BLOCK},
	{"Armenian", 0x0530, 0x058f, false, B_ARMENIAN_BLOCK},
	{"Hebrew", 0x0590, 0x05ff, false,
		B_BASIC_HEBREW_BLOCK | B_HEBREW_EXTENDED_BLOCK},
	{"Arabic", 0x0600, 0x06ff, false,
		B_BASIC_ARABIC_BLOCK | B_ARABIC_EXTENDED_BLOCK},
	{"Syriac", 0x0700, 0x074f, false, kNoBlock},
	{"Arabic Supplement", 0x0750, 0x077f, false, kNoBlock},
	{"Thaana", 0x0780, 0x07bf, false, kNoBlock},
	{"N'Ko", 0x07c0, 0x07ff, false, kNoBlock},
	{"Devanagari", 0x0900, 0x097f, false, B_DEVANAGARI_BLOCK},
	{"Bengali", 0x0980, 0x09ff, false, B_BENGALI_BLOCK},
	{"Gurmukhi", 0x0a00, 0x0a7f, false, B_GURMUKHI_BLOCK},
	{"Gujarati", 0x0a80, 0x0aff, false, B_GUJARATI_BLOCK},
	{"Oriya", 0x0b00, 0x0b7f, false, B_ORIYA_BLOCK},
	{"Tamil", 0x0b80, 0x0bff, false, B_TAMIL_BLOCK},
	{"Telugu", 0x0c00, 0x0c7f, false, B_TELUGU_BLOCK},
	{"Kannada", 0x0c80, 0x0cff, false, B_KANNADA_BLOCK},
	{"Malayalam", 0x0d00, 0x0d7f, false, B_MALAYALAM_BLOCK},
	{"Sinhala", 0x0d80, 0x0dff, false, kNoBlock},
	{"Thai", 0x0e00, 0x0e7f, false, B_THAI_BLOCK},
	{"Lao", 0x0e80, 0x0eff, false, B_LAO_BLOCK},
	{"Tibetan", 0x0f00, 0x0fff, false, kNoBlock},
	{"Myanmar", 0x1000, 0x109f, false, kNoBlock},
	{"Georgian", 0x10a0, 0x10ff, false, B_BASIC_GEORGIAN_BLOCK},
	{"Hangul Jamo", 0x1100, 0x11ff, false, kNoBlock},
// TODO!
	{"Ethiopic", 0x1200, 0x137f, false, kNoBlock},
	{"Ethiopic Supplement", 0x1380, 0x139f, false, kNoBlock},
	{"Cherokee", 0x13a0, 0x13ff, false, kNoBlock},
	{"Unified Canadian Aboriginal Syllabics", 0x1400, 0x167f, false, kNoBlock},
	{"Ogham", 0x1680, 0x169f, false, kNoBlock},
	{"Runic", 0x16a0, 0x16ff, false, kNoBlock},
	{"Tagalog", 0x1700, 0x171f, false, kNoBlock},
	{"Hanunoo", 0x1720, 0x173f, false, kNoBlock},
	{"Buhid", 0x1740, 0x175f, false, kNoBlock},
	{"Tagbanwa", 0x1760, 0x177f, false, kNoBlock},
	{"Khmer", 0x1780, 0x17ff, false, kNoBlock},
	{"Mongolian", 0x1800, 0x18af, false, kNoBlock},
	{"Limbu", 0x1900, 0x194f, false, kNoBlock},
	{"Tai Le", 0x1950, 0x197f, false, kNoBlock},
	{"New Tai Lue", 0x1980, 0x19df, false, kNoBlock},
	{"Khmer Symbols", 0x19e0, 0x19ff, false, kNoBlock},
	{"Buginese", 0x1a00, 0x1a1f, false, kNoBlock},
	{"Balinese", 0x1b00, 0x1b7f, false, kNoBlock},
	{"Sundanese", 0x1b80, 0x1bbf, false, kNoBlock},
	{"Lepcha", 0x1c00, 0x1c4f, false, kNoBlock},
	{"Ol Chiki", 0x1c50, 0x1c7f, false, kNoBlock},
	{"Phonetic Extensions", 0x1d00, 0x1d7f, false, kNoBlock},
	{"Phonetic Extensions Supplement", 0x1d80, 0x1dbf, false, kNoBlock},
	{"Combining Diacritical Marks Supplement", 0x1dc0, 0x1dff, false, kNoBlock},
	{"Latin Extended Additional", 0x1e00, 0x1eff, false, kNoBlock},
	{"Greek Extended", 0x1f00, 0x1fff, false, kNoBlock},
	{"General Punctuation", 0x2000, 0x206f, false, kNoBlock},
	{"Superscripts and Subscripts", 0x2070, 0x209f, false, kNoBlock},
	{"Currency Symbols", 0x20a0, 0x20cf, false, kNoBlock},
	{"Combining Diacritical Marks for Symbols", 0x20d0, 0x20ff, false,
		kNoBlock},
	{"Letterlike Symbols", 0x2100, 0x214f, false, kNoBlock},
	{"Number Forms", 0x2150, 0x218f, false, kNoBlock},
	{"Arrows", 0x2190, 0x21ff, false, kNoBlock},
	{"Mathematical Operators", 0x2200, 0x22ff, false, kNoBlock},
	{"Miscellaneous Technical", 0x2300, 0x23ff, false, kNoBlock},
	{"Control Pictures", 0x2400, 0x243f, false, kNoBlock},
	{"Optical Character Recognition", 0x2440, 0x245f, false, kNoBlock},
	{"Enclosed Alphanumerics", 0x2460, 0x24ff, false, kNoBlock},
	{"Box Drawing", 0x2500, 0x257f, false, kNoBlock},
	{"Block Elements", 0x2580, 0x259f, false, kNoBlock},
	{"Geometric Shapes", 0x25a0, 0x25ff, false, kNoBlock},
	{"Miscellaneous Symbols", 0x2600, 0x26ff, false, kNoBlock},
	{"Dingbats", 0x2700, 0x27bf, false, kNoBlock},
	{"Miscellaneous Mathematical Symbols A", 0x27c0, 0x27ef, false, kNoBlock},
	{"Supplemental Arrows A", 0x27f0, 0x27ff, false, kNoBlock},
	{"Braille Patterns", 0x2800, 0x28ff, false, kNoBlock},
	{"Supplemental Arrows B", 0x2900, 0x297f, false, kNoBlock},
	{"Miscellaneous Mathematical Symbols B", 0x2980, 0x29ff, false, kNoBlock},
	{"Supplemental Mathematical Operators", 0x2a00, 0x2aff, false, kNoBlock},
	{"Miscellaneous Symbols And Arrows", 0x2b00, 0x2bff, false, kNoBlock},
	{"Glagotic", 0x2c00, 0x2c5f, false, kNoBlock},
	{"Latin Extended C", 0x2c60, 0x2c7f, false, kNoBlock},
	{"Coptic", 0x2c80, 0x2cff, false, kNoBlock},
	{"Georgian Supplement", 0x2d00, 0x2d2f, false, kNoBlock},
	{"Tifinagh", 0x2d30, 0x2d7f, false, kNoBlock},
	{"Ethiopic Extended", 0x2d80, 0x2ddf, false, kNoBlock},
	{"Cyrillic Extended A", 0x2de0, 0x2dff, false, kNoBlock},
	{"Supplement Punctuation", 0x2e00, 0x2e7f, false, kNoBlock},
	{"CJK Radicals Supplement", 0x2e80, 0x2eff, false, kNoBlock},
	{"Kangxi Radicals", 0x2f00, 0x2fdf, false, kNoBlock},
	{"Ideographic Description Characters", 0x2ff0, 0x2fff, false, kNoBlock},
	{"CJK Symbols and Punctuation", 0x3000, 0x303f, false, kNoBlock},
	{"Hiragana", 0x3040, 0x309f, false, kNoBlock},
	{"Katakana", 0x30a0, 0x30ff, false, kNoBlock},
	{"Bopomofo", 0x3100, 0x312f, false, kNoBlock},
	{"Hangul Compatibility Jamo", 0x3130, 0x318f, false, kNoBlock},
	{"Kanbun", 0x3190, 0x319f, false, kNoBlock},
	{"Bopomofo Extended", 0x31a0, 0x31bf, false, kNoBlock},
	{"CJK Strokes", 0x31c0, 0x31ef, false, kNoBlock},
	{"Katakana Phonetic Extensions", 0x31f0, 0x31ff, false, kNoBlock},
	{"Enclosed CJK Letters and Months", 0x3200, 0x32ff, false, kNoBlock},
	{"CJK Compatibility", 0x3300, 0x33ff, false, kNoBlock},
	{"CJK Unified Ideographs Extension A", 0x3400, 0x4dbf, false, kNoBlock},
	{"Yijing Hexagram Symbols", 0x4dc0, 0x4dff, false, kNoBlock},
	{"CJK Unified Ideographs", 0x4e00, 0x9fff, false, kNoBlock},
	{"Yi Syllables", 0xa000, 0xa48f, false, kNoBlock},
	{"Yi Radicals", 0xa490, 0xa4cf, false, kNoBlock},
	{"Vai", 0xa500, 0xa63f, false, kNoBlock},
	{"Cyrillic Extended B", 0xa640, 0xa69f, false, kNoBlock},
	{"Modifier Tone Letters", 0xa700, 0xa71f, false, kNoBlock},
	{"Latin Extended D", 0xa720, 0xa7ff, false, kNoBlock},
	{"Syloti Nagri", 0xa800, 0xa82f, false, kNoBlock},
	{"Phags-pa", 0xa840, 0xa87f, false, kNoBlock},
	{"Saurashtra", 0xa880, 0xa8df, false, kNoBlock},
	{"Kayah Li", 0xa900, 0xa92f, false, kNoBlock},
	{"Rejang", 0xa930, 0xa95f, false, kNoBlock},
	{"Cham", 0xaa00, 0xaa5f, false, kNoBlock},
	{"Hangul Syllables", 0xac00, 0xd7af, false, kNoBlock},
//	{"High Surrogates", 0xd800, 0xdb7f, false, kNoBlock},
//	{"High Private Use Surrogates", 0xdb80, 0xdbff, false, kNoBlock},
//	{"Low Surrogates", 0xdc00, 0xdfff, false, kNoBlock},
	{"Private Use Area", 0xe000, 0xf8ff, true, kNoBlock},
	{"CJK Compatibility Ideographs", 0xf900, 0xfaff, false, kNoBlock},
	{"Alphabetic Presentation Forms", 0xfb00, 0xfb4f, false, kNoBlock},
	{"Arabic Presentation Forms A", 0xfb50, 0xfdff, false, kNoBlock},
	{"Variation Selectors", 0xfe00, 0xfe0f, false, kNoBlock},
	{"Vertical Forms", 0xfe10, 0xfe1f, false, kNoBlock},
	{"Combining Half Marks", 0xfe20, 0xfe2f, false, kNoBlock},
	{"CJK Compatibility Forms", 0xfe30, 0xfe4f, false, kNoBlock},
	{"Small Form Variants", 0xfe50, 0xfe6f, false, kNoBlock},
	{"Arabic Presentation Forms B", 0xfe70, 0xfeff, false, kNoBlock},
	{"Halfwidth and Fullwidth Forms", 0xff00, 0xffef, false, kNoBlock},
	{"Specials", 0xfff0, 0xffff, false, kNoBlock},
	{"Linear B Syllabary", 0x010000, 0x01007f, false, kNoBlock},
	{"Linear B Ideograms", 0x010080, 0x0100ff, false, kNoBlock},
	{"Aegean Numbers", 0x010100, 0x01013f, false, kNoBlock},
	{"Ancient Greek Numbers", 0x010140, 0x01018f, false, kNoBlock},
	{"Ancient Symbols", 0x010190, 0x0101cf, false, kNoBlock},
	{"Phaistos Disc", 0x0101d0, 0x0101ff, false, kNoBlock},
	{"Lycian", 0x010280, 0x01029f, false, kNoBlock},
	{"Carian", 0x0102a0, 0x0102df, false, kNoBlock},
	{"Old Italic", 0x010300, 0x01032f, false, kNoBlock},
	{"Gothic", 0x010330, 0x01034f, false, kNoBlock},
	{"Ugaritic", 0x010380, 0x01039f, false, kNoBlock},
	{"Old Persian", 0x0103a0, 0x0103df, false, kNoBlock},
	{"Deseret", 0x010400, 0x01044f, false, kNoBlock},
	{"Shavian", 0x010450, 0x01047f, false, kNoBlock},
	{"Osmanya", 0x010480, 0x0104af, false, kNoBlock},
	{"Cypriot Syllabary", 0x010800, 0x01083f, false, kNoBlock},
	{"Phoenician", 0x010900, 0x01091f, false, kNoBlock},
	{"Lydian", 0x010920, 0x01093f, false, kNoBlock},
	{"Kharoshthi", 0x010a00, 0x010a5f, false, kNoBlock},
	{"Cuneiform", 0x012000, 0x0123ff, false, kNoBlock},
	{"Cuneiform Numbers and Punctuation", 0x012400, 0x01247f, false, kNoBlock},
	{"Byzantine Musical Symbols", 0x01d000, 0x01d0ff, false, kNoBlock},
	{"Muscial Symbols", 0x01d100, 0x01d1ff, false, kNoBlock},
	{"Ancient Greek Musical Notation", 0x01d200, 0x01d24f, false, kNoBlock},
	{"Tai Xuan Jing Symbols", 0x01d300, 0x01d35f, false, kNoBlock},
	{"Counting Rod Numerals", 0x01d360, 0x01d37f, false, kNoBlock},
	{"Mathematical Alphanumeric Symbols", 0x01d400, 0x01d7ff, false, kNoBlock},
	{"Mahjong Tiles", 0x01f000, 0x01f02f, false, kNoBlock},
	{"Domino Tiles", 0x01f030, 0x01f09f, false, kNoBlock},
	{"CJK Unified Ideographs Extension B", 0x020000, 0x02a6df, false, kNoBlock},
	{"CJK Compatibility Ideographs Supplement", 0x02f800, 0x02fa1f, false,
		kNoBlock},
	{"Tags", 0x0e0000, 0x0e007f, false, kNoBlock},
	{"Variation Selectors Supplement", 0x0e0100, 0x0e01ef, false, kNoBlock},
	{"Supplementary Private Use Area A", 0x0f0000, 0x0fffff, true, kNoBlock},
	{"Supplementary Private Use Area B", 0x100000, 0x10ffff, true, kNoBlock},
};

const uint32 kNumUnicodeBlocks
	= sizeof(kUnicodeBlocks) / sizeof(kUnicodeBlocks[0]);
