/*
 * Copyright 2006, Haiku.
 * Distributed under the terms of the MIT License.
 *
 * Authors:
 *		Stephan Aßmus <superstippi@gmx.de>
 */

// NOTE: The images in here originate from Be Sample code. They have been
// integrated in the BeOS interface for the VLC Media Player code. When I
// worked on VLC during the 0.4.3-0.4.6 times, I reworked the bitmaps, and
// all code left in this file is from my own work on the Be Sample code
// buttons. -Stephan Aßmus

#ifndef BUTTON_BITMAPS_H
#define BUTTON_BITMAPS_H

#include <SupportDefs.h>

// #pragma mark play

const int32 kPlayPauseBitmapWidth = 48;
const int32 kPlayPauseBitmapHeight = 21;

const unsigned char kPlayButtonBitmapBits [] = {
	0xff,0xff,0xff,0xff,0xff,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0xff,0xff,0xff,0xff,
	0xff,0xff,0xff,0x1a,0x18,0x14,0x10,0x0d,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0xff,0xff,0xff,
	0xff,0xff,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,0x12,0x12,0x16,0x19,0xff,0xff,
	0xff,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0xff,
	0xff,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1b,0x19,0x16,0x19,0xff,
	0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,
	0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1b,
	0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x1c,
	0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1d,
	0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1d,
	0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,
	0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x0c,0x19,0x1d,
	0xff,0xff,0x19,0x17,0x16,0x17,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,
	0xff,0xff,0xff,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x12,0x0b,0x10,0x1c,0x1d,0x1c,
	0xff,0xff,0xff,0xff,0xff,0x16,0x10,0x10,0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0xff,
	0xff,0xff,0xff,0xff,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,0x19,0x1e,0x1e,0x1c,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0x1c,0x1c,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0xff,0xff,0xff,
	0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0xff,0xff,0xff,0xff,0xff
};

const unsigned char kDisabledPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,0x16,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x16,0x1b,0x1b,0x1b,
	0x16,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x1c,0x1b,0x1b,
	0x16,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPressedPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,0x12,0x14,0x18,0x1a,0x1a,0x1b,
	0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x0f,0x0f,0x13,0x16,0x19,0x1a,
	0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0x18,0x1b,
	0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x10,0x13,
	0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1c,
	0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x11,0x18,0x1c,
	0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x19,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x10,0x19,0x19,0x19,0x13,
	0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x11,0x11,0x18,0x1b,0x1c,
	0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,0x11,0x16,0x1b,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0e,0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0e,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPlayingPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,0x12,0x12,0x16,0x19,0x1b,0x1b,
	0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1b,0x19,0x16,0x19,0x1a,
	0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x00,0x00,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,
	0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1b,
	0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x34,0x34,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x1c,
	0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x34,0x34,0x34,0x34,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x34,0x34,0x34,0x34,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1d,
	0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x34,0x34,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x34,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x3f,0x1a,0x1a,
	0x00,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1d,
	0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,
	0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x0c,0x19,0x1d,
	0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x12,0x0b,0x10,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,0x19,0x1e,0x1e,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPressedPlayingPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,0x12,0x14,0x18,0x1a,0x1a,0x1b,
	0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x0f,0x0f,0x13,0x16,0x19,0x1a,
	0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0x18,0x1b,
	0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x10,0x13,
	0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1c,
	0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x11,0x18,0x1c,
	0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,0x19,0x13,
	0x13,0x00,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x19,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x10,0x19,0x19,0x19,0x13,
	0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x11,0x11,0x18,0x1b,0x1c,
	0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,0x11,0x16,0x1b,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPausedPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,0x12,0x12,0x16,0x19,0x1b,0x1b,
	0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1b,0x19,0x16,0x19,0x1a,
	0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,
	0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x10,0x1a,0x1a,
	0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1b,
	0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x1c,
	0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1d,
	0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x34,0x34,0x3f,0x1a,0x1a,
	0x00,0x34,0x34,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1d,
	0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,0x1a,0x1a,
	0x10,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x0c,0x19,0x1d,
	0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x12,0x0b,0x10,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,0x19,0x1e,0x1e,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b
};

const unsigned char kPressedPausedPlayButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,0x12,0x14,0x18,0x1a,0x1a,0x1b,
	0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x0f,0x0f,0x13,0x16,0x19,0x1a,
	0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0x18,0x1b,
	0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,0x10,0x13,
	0x13,0x00,0x00,0x00,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1c,
	0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x11,0x18,0x1c,
	0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x19,0x13,
	0x13,0x00,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x19,
	0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x10,0x19,0x19,0x19,0x13,
	0x13,0x10,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x11,0x11,0x18,0x1b,0x1c,
	0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,0x11,0x16,0x1b,0x1c,0x1d,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0e,0x0e,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b
};

// #pragma mark stop

const int32 kStopBitmapWidth = 31;
const int32 kStopBitmapHeight = 21;

const unsigned char kStopButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,
	0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,
	0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x10,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,
	0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,
	0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,
	0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,
	0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x10,0x3f,0x3f,0x3f,
	0x3f,0x3f,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,
	0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f
};


const unsigned char kDisabledStopButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f
};


const unsigned char kPressedStopButtonBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,
	0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,
	0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,
	0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,
	0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,
	0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,
	0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x10,0x10,
	0x10,0x10,0x10,0x10,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x13,0x13,0x13,0x13,0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,
	0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f
};

// #pragma mark rewind

const int32 kRewindBitmapWidth = 38;
const int32 kRewindBitmapHeight = 21;

const unsigned char kRewindBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,
	0x19,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,
	0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,
	0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,0x3f,0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,
	0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,
	0x17,0x3f,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,0x3f,0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x00,0x00,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x17,
	0x17,0x3f,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,0x3f,0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,
	0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,
	0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,0x3f,0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,0x3f,0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,
	0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,
	0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,
	0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kDisabledRewindBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,
	0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,0x3f,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,
	0x16,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x19,
	0x19,0x1c,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x16,0x16,0x19,0x19,0x19,
	0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,0x3f,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x19,
	0x19,0x1c,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,0x3f,0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,
	0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,
	0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,0x3f,0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,
	0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kPressedRewindBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,
	0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,
	0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,
	0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,
	0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,
	0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,0x3f,0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,
	0x00,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x00,0x00,
	0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x34,0x34,
	0x34,0x34,0x19,0x13,0x00,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,0x3f,0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x19,0x19,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x19,0x19,0x34,0x34,
	0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x34,
	0x34,0x34,0x19,0x13,0x13,0x13,0x19,0x19,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,0x3f,0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x34,0x19,0x13,0x13,0x13,0x13,0x13,
	0x19,0x19,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,
	0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,0x3f,0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,
	0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,
	0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

const unsigned char kForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x11,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,
	0x19,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,
	0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,
	0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,0x3f,0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,
	0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x00,0x00,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,0x3f,0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x00,0x17,0x17,
	0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,
	0x17,0x17,0x3f,0x3f,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,0x3f,0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x00,0x17,0x17,
	0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,0x3f,0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,0x3f,0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,
	0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,
	0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,
	0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

const unsigned char kDisabledForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,
	0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,0x3f,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,
	0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x16,0x16,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x16,0x16,0x1b,0x16,0x19,0x19,
	0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,0x3f,
	0x1b,0x13,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,
	0x19,0x19,0x1c,0x1c,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x13,0x1b,0x3f,0x3f,0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x16,0x19,0x19,
	0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,
	0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x18,0x16,0x1b,0x3f,0x3f,0x1b,0x18,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x18,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x18,0x16,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x19,0x16,0x1a,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x16,0x19,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x16,0x18,
	0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x16,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,
	0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x16,0x18,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

const unsigned char kPressedForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,
	0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,
	0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,
	0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,
	0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,
	0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,0x3f,0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,
	0x00,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x00,0x34,
	0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x34,0x34,0x00,0x00,0x13,0x00,0x34,0x34,0x34,0x34,0x34,0x00,0x00,0x13,0x13,
	0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,0x3f,0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x00,0x34,
	0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,
	0x34,0x19,0x19,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,0x3f,0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x34,
	0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,0x3f,0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,
	0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,
	0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


// #pragma mark skip back

const unsigned char kSkipBackBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,
	0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,
	0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,
	0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,0x3f,0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,
	0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x00,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x00,0x00,
	0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x00,0x00,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,0x3f,0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x3f,0x1a,0x00,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x00,0x00,0x17,
	0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x3f,0x3f,0x17,0x17,
	0x17,0x17,0x17,0x3f,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,0x3f,0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x3f,
	0x3f,0x17,0x17,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x3f,0x3f,0x17,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x17,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,0x3f,0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,0x3f,0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,
	0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,
	0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,
	0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

const unsigned char kDisabledSkipBackBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x16,
	0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
	0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x18,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x15,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x15,
	0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x18,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x19,0x16,0x18,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x15,0x18,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x1a,0x1b,0x3f,0x3f,
	0x1b,0x18,0x15,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x15,0x18,0x1b,0x3f,0x3f,0x1b,0x16,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x16,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x17,0x16,0x1b,0x3f,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x16,0x16,
	0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x16,0x16,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,0x1b,0x13,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x1c,0x1b,0x16,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x16,0x16,0x19,
	0x19,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x13,0x1b,0x3f,0x3f,
	0x1b,0x13,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1c,0x1c,0x19,0x19,
	0x19,0x19,0x19,0x1c,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x13,0x1b,0x3f,0x3f,0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1c,
	0x1c,0x19,0x19,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,
	0x1b,0x16,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1c,0x1c,0x19,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x17,0x16,0x1b,0x3f,0x3f,0x1b,0x18,0x15,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x15,0x18,0x1b,0x3f,0x3f,
	0x1b,0x1a,0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x18,0x15,0x1a,0x1b,0x3f,0x3f,0x1b,0x1b,0x18,0x16,0x19,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x18,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x15,0x17,
	0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x15,0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
	0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x18,
	0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kPressedSkipBackBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,
	0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,
	0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,
	0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,
	0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,
	0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,0x3f,0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x13,
	0x13,0x00,0x00,0x34,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x34,0x19,0x13,0x13,
	0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x00,0x00,0x34,0x34,0x34,0x19,0x13,0x13,0x13,
	0x00,0x00,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x00,0x00,0x34,
	0x34,0x34,0x34,0x34,0x19,0x13,0x00,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x13,
	0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,0x3f,0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x19,0x13,0x19,0x19,0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x19,0x19,
	0x34,0x34,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x19,
	0x19,0x34,0x34,0x34,0x19,0x13,0x13,0x13,0x19,0x19,0x34,0x34,0x34,0x19,0x13,0x13,
	0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,0x3f,0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,
	0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x34,0x19,0x13,0x13,0x13,
	0x13,0x13,0x19,0x19,0x34,0x19,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,
	0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,0x3f,0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,
	0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,
	0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};

// #pragma mark skip forward

const unsigned char kSkipForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,0x11,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,
	0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x18,0x14,0x10,0x0d,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,
	0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0b,0x0f,0x13,0x17,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x17,0x11,0x0b,0x10,0x16,0x1a,0x1d,0x1d,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x19,
	0x12,0x12,0x16,0x19,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x10,0x0d,0x16,0x1e,0x1e,
	0x1d,0x1d,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x18,0x14,0x17,0x1a,0x1b,0x3f,0x3f,
	0x1a,0x18,0x11,0x0d,0x18,0x1e,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1b,0x1b,0x19,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0c,0x16,0x1e,0x1c,0x1b,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x17,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x10,0x1d,0x1c,0x1b,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x00,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x17,0x18,0x1b,0x3f,0x3f,0x16,0x0f,0x17,0x1d,0x1b,0x1a,0x1a,0x1a,
	0x1a,0x00,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x00,0x00,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x16,0x1b,0x3f,0x3f,
	0x14,0x0f,0x1b,0x1c,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,0x00,0x1a,
	0x1a,0x1a,0x00,0x17,0x17,0x17,0x00,0x00,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x12,0x1c,0x3f,0x3f,0x14,0x0f,0x1c,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x00,0x00,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,
	0x00,0x00,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x16,0x0f,0x1c,0x3f,0x3f,
	0x14,0x10,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,
	0x3f,0x1a,0x00,0x17,0x17,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x16,0x0f,0x1d,0x3f,0x3f,0x16,0x11,0x1b,0x1b,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x00,0x17,0x17,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x00,0x17,0x17,0x17,0x3f,0x3f,
	0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x14,0x0e,0x1d,0x3f,0x3f,
	0x17,0x13,0x19,0x1b,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x00,0x17,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x00,0x3f,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x18,0x12,0x10,0x1d,0x3f,0x3f,0x18,0x16,0x17,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x3f,0x3f,0x1a,0x1a,0x1a,0x1a,0x19,0x16,0x0f,0x13,0x1d,0x3f,0x3f,
	0x1a,0x19,0x17,0x18,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x18,0x12,0x0c,0x19,0x1d,0x3f,0x3f,0x1b,0x1b,0x19,0x17,0x16,0x17,0x19,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x18,0x13,0x0c,0x13,0x1e,0x1d,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1a,0x16,0x13,0x16,0x17,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x19,0x16,
	0x12,0x0b,0x10,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x10,0x10,
	0x12,0x13,0x13,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,0x14,
	0x14,0x14,0x14,0x14,0x14,0x13,0x11,0x0d,0x0a,0x11,0x1c,0x1e,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x19,0x13,0x0f,0x0b,0x0b,0x0b,0x0a,0x0a,0x0a,0x0a,
	0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0a,0x0b,0x0f,
	0x19,0x1e,0x1e,0x1c,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1d,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,
	0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1e,0x1d,0x1c,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,
	0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kDisabledSkipForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x16,
	0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
	0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x18,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x15,0x17,0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x15,
	0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x18,0x16,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x19,0x16,0x18,0x1b,0x1b,0x3f,0x3f,0x1b,0x1a,0x15,0x18,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x1a,0x1b,0x3f,0x3f,
	0x1b,0x18,0x15,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x16,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x15,0x18,0x1b,0x3f,0x3f,0x1b,0x16,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x16,0x16,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x17,0x16,0x1b,0x3f,0x3f,
	0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x16,0x16,0x1b,
	0x1b,0x1b,0x16,0x19,0x19,0x19,0x16,0x16,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,0x1b,0x13,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x16,0x16,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,
	0x16,0x16,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x13,0x1b,0x3f,0x3f,
	0x1b,0x13,0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,
	0x1c,0x1b,0x16,0x19,0x19,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1a,0x13,0x1b,0x3f,0x3f,0x1b,0x14,0x19,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x16,0x19,0x19,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x16,0x19,0x19,0x19,0x1c,0x1c,
	0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x14,0x1b,0x3f,0x3f,
	0x1b,0x16,0x17,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x16,0x19,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x16,0x1c,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x17,0x16,0x1b,0x3f,0x3f,0x1b,0x18,0x15,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x15,0x18,0x1b,0x3f,0x3f,
	0x1b,0x1a,0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x18,0x15,0x1a,0x1b,0x3f,0x3f,0x1b,0x1b,0x18,0x16,0x19,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x19,0x16,0x18,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x18,0x16,0x18,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x18,0x16,0x18,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x15,0x15,0x17,
	0x18,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,0x19,
	0x19,0x19,0x19,0x19,0x18,0x18,0x17,0x15,0x15,0x18,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x18,0x16,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,
	0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x15,0x16,0x18,
	0x1a,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


const unsigned char kPressedSkipForwardBitmapBits [] = {
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1a,0x19,0x19,0x18,0x18,0x18,0x17,0x17,0x17,0x17,0x17,
	0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x17,0x18,0x18,0x19,
	0x1a,0x1a,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1a,0x19,0x17,0x14,0x13,
	0x12,0x11,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x11,0x12,0x14,0x16,0x19,0x1a,0x1b,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x18,0x14,0x11,0x0d,0x0b,0x0a,0x09,0x09,0x09,0x09,0x09,0x09,0x09,
	0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x09,0x0a,0x0c,0x0e,
	0x12,0x14,0x18,0x1a,0x1a,0x1b,0x3f,0x3f,0x1b,0x1a,0x17,0x13,0x0e,0x0b,0x0c,0x0d,
	0x0f,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,
	0x10,0x10,0x10,0x10,0x10,0x0f,0x0d,0x0d,0x0f,0x11,0x14,0x18,0x1a,0x1a,0x3f,0x3f,
	0x1a,0x18,0x13,0x0d,0x0c,0x0e,0x11,0x12,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,
	0x0f,0x0f,0x13,0x16,0x19,0x1a,0x3f,0x3f,0x19,0x14,0x0e,0x0c,0x0f,0x12,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x0f,0x10,0x16,0x18,0x1a,0x3f,0x3f,
	0x17,0x11,0x0c,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x12,0x0f,0x13,0x18,0x1b,0x3f,0x3f,0x16,0x0d,0x0d,0x11,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x00,0x00,0x13,0x13,0x13,0x13,0x11,0x10,0x17,0x1b,0x3f,0x3f,
	0x14,0x0d,0x0e,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x00,0x00,0x13,0x13,
	0x13,0x13,0x13,0x00,0x34,0x00,0x00,0x13,0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,
	0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,0x14,0x0d,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x34,0x34,0x34,0x00,0x00,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x00,
	0x00,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x16,0x1c,0x3f,0x3f,
	0x14,0x0e,0x10,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x34,0x34,
	0x00,0x00,0x13,0x00,0x34,0x34,0x34,0x34,0x34,0x00,0x00,0x13,0x00,0x19,0x13,0x13,
	0x13,0x13,0x12,0x0f,0x16,0x1c,0x3f,0x3f,0x16,0x0e,0x0f,0x12,0x13,0x13,0x13,0x13,
	0x13,0x13,0x00,0x34,0x34,0x34,0x34,0x34,0x19,0x19,0x13,0x00,0x34,0x34,0x34,0x34,
	0x34,0x19,0x19,0x13,0x00,0x19,0x13,0x13,0x13,0x13,0x12,0x10,0x17,0x1c,0x3f,0x3f,
	0x17,0x10,0x0f,0x12,0x13,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x19,0x19,
	0x13,0x13,0x13,0x00,0x34,0x34,0x34,0x19,0x19,0x13,0x13,0x13,0x00,0x19,0x13,0x13,
	0x13,0x13,0x11,0x11,0x18,0x1c,0x3f,0x3f,0x18,0x12,0x0f,0x10,0x12,0x13,0x13,0x13,
	0x13,0x13,0x00,0x34,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x00,0x34,0x19,0x19,0x13,
	0x13,0x13,0x13,0x13,0x00,0x19,0x13,0x13,0x13,0x12,0x10,0x13,0x1a,0x1c,0x3f,0x3f,
	0x1a,0x16,0x11,0x0f,0x11,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x19,0x19,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x19,0x19,0x13,0x13,
	0x12,0x11,0x11,0x18,0x1b,0x1c,0x3f,0x3f,0x1b,0x1a,0x16,0x11,0x0f,0x11,0x12,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,0x13,
	0x13,0x13,0x13,0x13,0x13,0x13,0x12,0x12,0x11,0x10,0x16,0x1b,0x1d,0x1c,0x3f,0x3f,
	0x1b,0x1b,0x1a,0x16,0x12,0x10,0x10,0x11,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,
	0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x12,0x11,0x10,
	0x11,0x16,0x1b,0x1c,0x1d,0x1c,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x18,0x16,0x12,0x10,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,
	0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x11,0x14,0x19,0x1b,0x1d,0x1d,0x1c,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1c,0x1a,0x19,0x19,0x19,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,
	0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1a,0x1b,
	0x1c,0x1d,0x1d,0x1c,0x1c,0x1b,0x3f,0x3f,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,
	0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1d,0x1c,0x1c,0x1b,0x1b,0x3f,0x3f,
	0x1b,0x1b,0x1b,0x1b,0x1b,0x1b,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,0x1c,
	0x1c,0x1c,0x1b,0x1b,0x1b,0x1b,0x3f,0x3f
};


#endif	// BUTTON_BITMAPS_H

